/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import def.processing.core.PConstants;
import def.processing.event.KeyEvent;
import def.processing.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ktbyte.gui.ArrowButton;
import ktbyte.gui.Button;
import ktbyte.gui.Controller;
import ktbyte.gui.InputTextBox;
import ktbyte.gui.Pane;
import ktbyte.gui.Panel;
import ktbyte.gui.ScrollBar;
import ktbyte.gui.Slider;
import ktbyte.gui.StageManager;

public class KTGUI
implements PConstants {
    private static PApplet pa;
    private HashMap<Controller, Integer> garbageList;
    public ArrayList<String> drawCallStack = new ArrayList();
    public static int COLOR_FG_HOVERED;
    public static int COLOR_FG_PRESSED;
    public static int COLOR_FG_PASSIVE;
    public static int COLOR_BG_HOVERED;
    public static int COLOR_BG_PASSIVE;
    public static int COLOR_BG_PRESSED;
    public static int DEFAULT_COMPONENT_WIDTH;
    public static int DEFAULT_ALIGN_GAP;
    public static int DEFAULT_ROUNDING;
    private static boolean debugControllers;
    private boolean debugDrawCallStack = false;

    public KTGUI(PApplet pa) {
        KTGUI.debug("\nCreating of the KTGUI instance started.");
        this.init(pa);
        KTGUI.debug("Creating of the KTGUI instance completed.\n");
    }

    private void init(PApplet pa) {
        KTGUI.debug("\tInitializing of the KTGUI started.");
        KTGUI.pa = pa;
        KTGUI.pa.registerMethod("draw", (Object)this);
        KTGUI.debug("\t\t'draw()' method has been registered in parent PApplet.");
        KTGUI.pa.registerMethod("mouseEvent", (Object)this);
        KTGUI.debug("\t\t'mouseEvent()' method has been registered in parent PApplet.");
        KTGUI.pa.registerMethod("keyEvent", (Object)this);
        KTGUI.debug("\t\t'keyEvent()' method has been registered in parent PApplet.");
        this.garbageList = new HashMap();
        KTGUI.debug("\t\tGarbage list created.");
        COLOR_FG_PASSIVE = pa.color(150, 180, 150);
        COLOR_FG_HOVERED = pa.color(150, 220, 150);
        COLOR_FG_PRESSED = pa.color(110, 200, 110);
        COLOR_BG_PASSIVE = pa.color(190);
        COLOR_BG_HOVERED = pa.color(220);
        COLOR_BG_PRESSED = pa.color(210);
        DEFAULT_COMPONENT_WIDTH = 16;
        DEFAULT_ALIGN_GAP = 20;
        DEFAULT_ROUNDING = 8;
        KTGUI.debug("\t\tColor and size constants initialized.");
        StageManager.getInstance();
        KTGUI.debug("\tInitializing of the KTGUI completed.");
    }

    public static PApplet getParentPApplet() {
        return pa;
    }

    public void draw() {
        if (StageManager.getInstance().userStagesExist()) {
            StageManager.getInstance().getActiveStage().draw();
        }
        StageManager.getInstance().getDefaultStage().draw();
        this.collectGarbage();
    }

    public void setDrawCallStackFlag(boolean debug) {
        this.debugDrawCallStack = debug;
    }

    void drawDebugTextSplitLine(int x, int y) {
        pa.text("----------------------------------------------------------------------------------------------------------------------------", (float)x, (float)y);
    }

    public void addDrawCallStackDebugMessage(String msg) {
        if (this.debugDrawCallStack) {
            this.drawCallStack.add(msg);
        }
    }

    public void addToGarbage(Controller controller, int millis) {
        this.garbageList.put(controller, millis);
    }

    void collectGarbage() {
        for (Map.Entry<Controller, Integer> me : this.garbageList.entrySet()) {
            Controller controller = me.getKey();
            int time = me.getValue();
            if (pa.millis() - time <= 100) continue;
            if (controller.parentStage != null) {
                controller.parentStage.unregisterController(controller);
                continue;
            }
            if (controller.parentController == null) continue;
            controller.parentController.detachController(controller);
        }
    }

    public Button createButton(String title, int x, int y, int w, int h) {
        return new Button(this, title, x, y, w, h);
    }

    public Button createButton(int x, int y, int w, int h) {
        return new Button(this, "A Button", x, y, w, h);
    }

    public ArrowButton createDirectionButton(String title, int x, int y, int w, int h, int dir) {
        return new ArrowButton(this, title, x, y, w, h, dir);
    }

    public ArrowButton createDirectionButton(int x, int y, int w, int h, int dir) {
        return new ArrowButton(this, "A DirButton", x, y, w, h, dir);
    }

    public Slider createSlider(String title, int posx, int posy, int w, int h, int sr, int er) {
        return new Slider(this, title, posx, posy, w, h, sr, er);
    }

    public Slider createSlider(int posx, int posy, int w, int h, int sr, int er) {
        return new Slider(this, "A Slider", posx, posy, w, h, sr, er);
    }

    public Panel createPanel(String title, int x, int y, int w, int h) {
        Panel panel = new Panel(this, title, x, y, w, h);
        return panel;
    }

    public Panel createPanel(int x, int y, int w, int h) {
        Panel panel = new Panel(this, "A Panel", x, y, w, h);
        return panel;
    }

    public Pane createPane(String title, int x, int y, int w, int h) {
        Pane pane = new Pane(this, title, x, y, w, h);
        return pane;
    }

    public Pane createPane(int x, int y, int w, int h) {
        Pane pane = new Pane(this, "A Pane", x, y, w, h);
        return pane;
    }

    public ScrollBar createScrollBar(int x, int y, int w, int h, int sr, int er) {
        ScrollBar scrollBar = this.createScrollBar("A ScrollBar", x, y, w, h, sr, er);
        return scrollBar;
    }

    public ScrollBar createScrollBar(String title, int x, int y, int w, int h, int sr, int er) {
        if (w > h) {
            if (w - 2 * h < 2 * DEFAULT_COMPONENT_WIDTH) {
                KTGUI.debug("ERROR: The width of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
                return null;
            }
        } else if (h - 2 * w < 2 * DEFAULT_COMPONENT_WIDTH) {
            KTGUI.debug("ERROR: The height of the ScrollBar to be created is  too small. As a consequence, the internal slider would have  orthogonal direction. Cannot create ScrollBar. Returning null reference.");
            return null;
        }
        ScrollBar scrollBar = new ScrollBar(this, title, x, y, w, h, sr, er);
        return scrollBar;
    }

    public InputTextBox createInputTextBox(String title, int x, int y, int w, int h) {
        return new InputTextBox(this, title, x, y, w, h);
    }

    public InputTextBox createInputTextBox(int x, int y, int w, int h) {
        return this.createInputTextBox("An InputTextBox", x, y, w, h);
    }

    public void mouseEvent(MouseEvent e) {
        switch (e.getAction()) {
            case 1: {
                this.mousePressed();
                break;
            }
            case 2: {
                this.mouseReleased();
                break;
            }
            case 4: {
                this.mouseDragged();
                break;
            }
            case 5: {
                this.mouseMoved();
                break;
            }
            case 8: {
                this.mouseWheel(e);
            }
        }
    }

    public void keyEvent(KeyEvent e) {
        switch (e.getAction()) {
            case 1: {
                this.keyPressed();
                break;
            }
            case 2: {
                this.keyReleased();
            }
        }
    }

    public static void debug(String string) {
        if (debugControllers) {
            PApplet.println((String)string);
        }
    }

    private void mouseDragged() {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processMouseDragged();
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processMouseDragged();
            }
        }
    }

    private void mousePressed() {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processMousePressed();
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processMousePressed();
            }
        }
    }

    private void mouseReleased() {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processMouseReleased();
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processMouseReleased();
            }
        }
    }

    private void mouseMoved() {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processMouseMoved();
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processMouseMoved();
            }
        }
    }

    private void mouseWheel(MouseEvent me) {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processMouseWheel(me);
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processMouseWheel(me);
            }
        }
    }

    private void keyPressed() {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processKeyPressed();
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processKeyPressed();
            }
        }
    }

    private void keyReleased() {
        for (Controller controller : StageManager.getInstance().getActiveStage().controllers) {
            controller.processKeyReleased();
        }
        if (StageManager.getInstance().getDefaultStage() != StageManager.getInstance().getActiveStage()) {
            for (Controller controller : StageManager.getInstance().getDefaultStage().controllers) {
                controller.processKeyReleased();
            }
        }
    }

    static {
        debugControllers = false;
    }
}

