/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import ktbyte.gui.Controller;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.KTGUI;

public class InputTextBox
extends Controller {
    private static final int BACKSPACE_ASCII_CODE = 8;
    private static final int ENTER_ASCII_CODE = 10;
    private static final int BASIC_ASCII_LOWER_LIMIT = 32;
    private static final int BASIC_ASCII_UPPER_LIMIT = 126;
    private String welcomeText = "Type text here ...";
    private String inputText = "";
    private int textSize = 18;
    private float textHeight;
    private float padding;

    InputTextBox(KTGUI ktgui, String title, int posx, int posy, int w, int h) {
        super(ktgui, title, posx, posy, w, h);
        this.updateTextAttributes();
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
        this.updateTextBox();
        this.updateBlinkingCursorGraphics();
    }

    private void updateTextBox() {
        this.pg.beginDraw();
        this.pg.pushStyle();
        if (this.isSelected(this)) {
            this.pg.fill(this.bgPressedColor);
            this.pg.stroke(50);
            this.pg.strokeWeight(3.0f);
        } else {
            this.pg.fill(this.bgPassiveColor);
            this.pg.stroke(0.0f, 50.0f, 0.0f);
            this.pg.strokeWeight(1.0f);
        }
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h, (float)this.r1, (float)this.r2, (float)this.r3, (float)this.r4);
        this.pg.textSize((float)this.textSize);
        this.pg.textAlign(37, 3);
        if (this.inputText.length() > 0) {
            this.pg.fill(0);
            this.pg.text(this.getTrimmedInputText(), this.padding, (float)this.h * 0.5f);
        } else {
            this.pg.fill(100);
            this.pg.text(this.welcomeText, this.padding, (float)this.h * 0.5f);
        }
        this.pg.popStyle();
        this.pg.endDraw();
    }

    private void updateBlinkingCursorGraphics() {
        if (this.isSelected(this) && this.pa.frameCount % 60 < 30) {
            this.pa.textSize((float)this.textSize);
            float cursorX = PApplet.min((float)((float)this.w - this.padding), (float)(this.padding + this.pa.textWidth(this.inputText)));
            this.pg.beginDraw();
            this.pg.stroke(0);
            this.pg.strokeWeight(2.0f);
            this.pg.line(cursorX, (float)this.h * 0.5f - this.textHeight * 0.5f, cursorX, (float)this.h * 0.5f + this.textHeight * 0.5f);
            this.pg.endDraw();
        }
    }

    @Override
    public void processMousePressed() {
        super.processMousePressed();
        if (this.isSelected(this)) {
            this.welcomeText = "";
        }
    }

    @Override
    public void processKeyPressed() {
        if (!this.isSelected(this)) {
            return;
        }
        if (this.pa.key == '\b' && this.inputText.length() > 0) {
            this.inputText = this.inputText.substring(0, this.inputText.length() - 1);
        }
        if (this.pa.key == '\n') {
            for (EventAdapter adapter : this.adapters) {
                adapter.onEnterKeyPressed();
            }
        } else if (this.pa.key >= ' ' && this.pa.key <= '~') {
            byte b = (byte)this.pa.key;
            char ch = (char)b;
            this.inputText = this.inputText + ch;
        }
    }

    public void setFocused(boolean value) {
    }

    public void setWelcomeText(String text) {
        this.welcomeText = text;
    }

    public void setText(String text) {
        this.inputText = text;
    }

    public String getText() {
        return this.inputText;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.pa.textSize((float)this.textSize);
        this.updateTextAttributes();
    }

    private void updateTextAttributes() {
        this.padding = 0.08f * (float)this.h;
        this.textHeight = this.pa.textAscent() + this.pa.textDescent();
    }

    private String getTrimmedInputText() {
        int chunkWidth;
        StringBuilder sb = new StringBuilder();
        int wrappedWidth = PApplet.floor((float)((float)this.w - this.padding));
        this.pa.textSize((float)this.textSize);
        for (int i = this.inputText.length() - 1; i >= 0 && (chunkWidth = PApplet.ceil((float)this.pa.textWidth(sb.toString() + ":"))) < wrappedWidth; --i) {
            sb.append(this.inputText.charAt(i));
        }
        return this.reverse(sb.toString());
    }

    private String reverse(String input) {
        char[] inChars = new char[input.length()];
        input.getChars(0, input.length(), inChars, 0);
        char[] outChars = new char[inChars.length];
        for (int i = inChars.length; i > 0; --i) {
            outChars[i - 1] = inChars[inChars.length - i];
        }
        return new String(outChars);
    }
}

