/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import def.processing.core.PConstants;
import def.processing.core.PGraphics;
import def.processing.core.PImage;
import def.processing.event.MouseEvent;
import java.util.ArrayList;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.EventProcessor;
import ktbyte.gui.KTGUI;
import ktbyte.gui.Stage;
import ktbyte.gui.StageManager;

public abstract class Controller
extends EventProcessor
implements PConstants {
    public String title;
    public int posx;
    public int posy;
    public int w;
    public int h;
    public int r1;
    public int r2;
    public int r3;
    public int r4;
    public ArrayList<Controller> controllers = new ArrayList();
    public PApplet pa;
    public KTGUI ktgui;
    public Controller parentController = null;
    public Stage parentStage = null;
    public static Controller selectedController = null;
    public PGraphics pg;
    public PGraphics userpg;
    public int fgHoveredColor = KTGUI.COLOR_FG_HOVERED;
    public int fgPressedColor = KTGUI.COLOR_FG_PRESSED;
    public int fgPassiveColor = KTGUI.COLOR_FG_PASSIVE;
    public int bgHoveredColor = KTGUI.COLOR_BG_HOVERED;
    public int bgPressedColor = KTGUI.COLOR_BG_PRESSED;
    public int bgPassiveColor = KTGUI.COLOR_BG_PASSIVE;

    Controller(KTGUI ktgui, String title, int posx, int posy, int w, int h) {
        KTGUI.debug("Creation of [" + title + "] started.");
        if ((float)w < (float)KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5f || (float)h < (float)KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5f) {
            KTGUI.debug("!!! ERRROR.");
            KTGUI.debug("!!! w:" + w + ", h:" + h);
            KTGUI.debug("!!! Width and height of the " + title + " controller must be greater than KTGUI.DEFAULT_COMPONENT_SIZE/2 a.u. Which is currently equal to " + (float)KTGUI.DEFAULT_COMPONENT_WIDTH * 0.5f + " a.u.");
            KTGUI.debug("!!! Creation of " + title + " interrupted (prevented).");
            KTGUI.debug("!!! Exiting from " + title + "`s constructor without creating the actual object.\n");
            return;
        }
        this.ktgui = ktgui;
        this.pa = KTGUI.getParentPApplet();
        this.title = title;
        this.posx = posx;
        this.posy = posy;
        this.w = w;
        this.h = h;
        this.pg = this.pa.createGraphics(w + 1, h + 1);
        this.userpg = this.pa.createGraphics(w + 1, h + 1);
        StageManager.getInstance().getDefaultStage().registerController(this);
        KTGUI.debug("Creation of [" + title + "] completed.\n");
    }

    public void updateGraphics() {
        this.ktgui.addDrawCallStackDebugMessage(this.title + ".updateGraphics()");
    }

    public void updateUserDefinedGraphics(PGraphics userpg) {
        this.userpg = userpg;
    }

    public void drawUserDefinedGraphics() {
        this.ktgui.drawCallStack.add(this.title + ".drawUserDefinedGraphics()-'");
        this.pg.beginDraw();
        this.pg.image((PImage)this.userpg, 0.0f, 0.0f);
        this.pg.endDraw();
    }

    public void drawControllers() {
        this.ktgui.drawCallStack.add(this.title + ".drawControllers()-'");
        for (Controller child : this.controllers) {
            child.updateGraphics();
            child.draw();
            this.pg.beginDraw();
            this.ktgui.drawCallStack.add("pg.image(" + child.title + ").getGraphics: " + child.posx + ", " + child.posy + "-'  ");
            this.ktgui.drawCallStack.add("(" + child.title + ").apos:" + child.getAbsolutePosX() + ", " + child.getAbsolutePosY() + "-'    ");
            this.pg.image((PImage)child.getGraphics(), (float)child.posx, (float)child.posy);
            this.pg.endDraw();
        }
    }

    private void drawGraphics() {
        if (this.parentController == null) {
            this.ktgui.drawCallStack.add(this.title + ".drawGraphics()-'");
            this.pa.image((PImage)this.pg, (float)this.posx, (float)this.posy);
        }
    }

    public void draw() {
        if (this.isVisible) {
            this.ktgui.drawCallStack.add(this.title + ".draw()|");
            this.drawControllers();
            this.drawUserDefinedGraphics();
            this.drawGraphics();
        }
    }

    public void setParentController(Controller controller) {
        this.parentController = controller;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInfo() {
        StringBuilder info = new StringBuilder();
        info.append("[" + (this.title != null ? this.title : "null") + "]");
        info.append(", pStage:" + (this.parentStage != null ? this.parentStage.getName() : "null"));
        info.append(", pCtrlr:" + (this.parentController != null ? this.parentController.title : "null"));
        info.append(", childs.sz():" + this.controllers.size());
        info.append(", isPrsd:" + this.isPressed);
        info.append(", isHvrd:" + this.isHovered);
        info.append(", isDrgd:" + this.isDragged);
        info.append(", rpsx:" + this.posx);
        info.append(", rpsy:" + this.posy);
        return info.toString();
    }

    public ArrayList<String> getFullInfoList(int level) {
        int recursyLevel = level;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        if (recursyLevel > 0) {
            prefix.append("'");
            for (int i = 0; i < recursyLevel; ++i) {
                prefix.append("-");
            }
        } else {
            prefix.append("+");
        }
        list.add(prefix.toString() + this.getInfo());
        if (this.controllers.size() > 0) {
            ++recursyLevel;
            for (Controller child : this.controllers) {
                list.addAll(child.getFullInfoList(recursyLevel));
            }
        }
        return list;
    }

    public int getWidth() {
        return this.w;
    }

    public void setWidth(int w) {
        this.w = w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getAbsolutePosX() {
        int px = 0;
        if (this.parentController != null) {
            px += this.parentController.getAbsolutePosX();
        }
        return px += this.posx;
    }

    public int getAbsolutePosY() {
        int py = 0;
        if (this.parentController != null) {
            py += this.parentController.getAbsolutePosY();
        }
        return py += this.posy;
    }

    public void setHeight(int h) {
        this.h = h;
    }

    public void setHoveredColor(int c) {
        this.fgHoveredColor = c;
    }

    public void setPressedColor(int c) {
        this.fgPressedColor = c;
    }

    public void setPassiveColor(int c) {
        this.fgPassiveColor = c;
    }

    public void setBorderRoundings(int r1, int r2, int r3, int r4) {
        this.r1 = r1;
        this.r2 = r2;
        this.r3 = r3;
        this.r4 = r4;
    }

    public void setHandleFocus(boolean val) {
        this.handleFocus = val;
    }

    public PGraphics getGraphics() {
        return this.pg;
    }

    public void addController(Controller child, int hAlign, int vAlign) {
        if (this.isActive) {
            child.alignAbout(this, hAlign, vAlign);
            this.attachController(child);
        }
    }

    public void addController(Controller child, int hAlign, int vAlign, int gap) {
        if (this.isActive) {
            child.alignAbout(this, hAlign, vAlign, gap);
            this.attachController(child);
        }
    }

    public void positionAboutOtherController(Controller controller, int relativePosx, int relativePosy) {
        this.posx = controller.posx + relativePosx;
        this.posy = controller.posy + relativePosy;
    }

    public void attachController(Controller controller) {
        if (this.isActive) {
            KTGUI.debug("Attaching of [" + controller.title + "] of type <" + controller.getClass().getName() + "> to [" + this.title + "] of type <" + this.getClass().getName() + "> started.");
            if (controller.parentController != null) {
                Controller pc = controller.parentController;
                pc.detachController(controller);
            }
            if (!this.controllers.contains(controller)) {
                KTGUI.debug("\t[" + this.title + "].controllers.contains(" + controller.title + ") = " + this.controllers.contains(controller));
                this.controllers.add(controller);
            }
            KTGUI.debug("\tSetting parent controller...");
            controller.setParentController(this);
            KTGUI.debug("\t[" + controller.title + "].parentController is [" + controller.parentController.title + "]");
            StageManager.getInstance().unregisterControllerFromAllStages(controller);
            KTGUI.debug("Attaching of [" + controller.title + "] to [" + this.title + "] completed.\n");
        }
    }

    public void detachController(Controller controller) {
        controller.parentController = null;
        this.controllers.remove(controller);
    }

    public void detachAllControllers() {
        for (Controller controller : this.controllers) {
            this.detachController(controller);
        }
    }

    public void closeParent() {
        if (this.parentController != null) {
            this.parentController.close();
        }
        this.closeAllChildsRecursively();
    }

    public void closeAllChildsRecursively() {
        for (Controller childController : this.controllers) {
            childController.closeAllChildsRecursively();
            childController.close();
        }
    }

    public void close() {
        PApplet.println((String)("Closing '" + this.title + "' controller."));
        this.isActive = false;
        this.ktgui.addToGarbage(this, this.pa.millis());
    }

    public float getPosx() {
        return this.posx;
    }

    public void setPosx(int posx) {
        this.posx = posx;
    }

    public float getPosy() {
        return this.posy;
    }

    public void setPosy(int posy) {
        this.posy = posy;
    }

    public void alignAboutCanvas(int hAlign, int vAlign) {
        this.alignAboutCanvas(hAlign, vAlign, KTGUI.DEFAULT_ALIGN_GAP);
    }

    public void alignAboutCanvas(int hAlign, int vAlign, int gap) {
        switch (hAlign) {
            case 37: {
                this.posx = gap;
                break;
            }
            case 39: {
                this.posx = this.pa.width - this.w - gap;
                break;
            }
            case 3: {
                this.posx = (int)((double)this.pa.width * 0.5 - (double)this.w * 0.5);
                break;
            }
        }
        switch (vAlign) {
            case 101: {
                this.posy = gap;
                break;
            }
            case 102: {
                this.posy = this.pa.height - this.h - gap;
                break;
            }
            case 3: {
                this.posy = (int)((double)this.pa.height * 0.5 - (double)this.h * 0.5);
                break;
            }
        }
    }

    public void alignAbout(Controller controller, int hAlign, int vAlign) {
        this.alignAbout(controller, hAlign, vAlign, KTGUI.DEFAULT_ALIGN_GAP);
    }

    public void alignAbout(Controller controller, int hAlign, int vAlign, int gap) {
        switch (hAlign) {
            case 37: {
                this.posx = gap;
                break;
            }
            case 39: {
                this.posx = controller.w - this.w - gap;
                break;
            }
            case 3: {
                this.posx = (int)((double)controller.w * 0.5 - (double)this.w * 0.5);
                break;
            }
        }
        switch (vAlign) {
            case 101: {
                this.posy = gap;
                break;
            }
            case 102: {
                this.posy = controller.h - this.h - gap;
                break;
            }
            case 3: {
                this.posy = (int)((double)controller.h * 0.5 - (double)this.h * 0.5);
                break;
            }
        }
    }

    public void stackAbout(Controller controller, int direction, int align) {
        this.stackAbout(controller, direction, align, KTGUI.DEFAULT_ALIGN_GAP);
    }

    public void stackAbout(Controller controller, int direction, int align, int gap) {
        block0 : switch (direction) {
            case 101: {
                this.posy = controller.posy - this.h - gap;
                switch (align) {
                    case 37: {
                        this.posx = controller.posx + gap;
                        break block0;
                    }
                    case 39: {
                        this.posx = controller.posx + controller.w - this.w - gap;
                        break block0;
                    }
                    case 3: {
                        this.posx = (int)((double)controller.posx + (double)controller.w * 0.5) - (int)((double)this.w * 0.5);
                        break block0;
                    }
                }
                break;
            }
            case 102: {
                this.posy = controller.posy + controller.h + gap;
                switch (align) {
                    case 37: {
                        this.posx = controller.posx + gap;
                        break block0;
                    }
                    case 39: {
                        this.posx = controller.posx + controller.w - this.w - gap;
                        break block0;
                    }
                    case 3: {
                        this.posx = (int)((double)controller.posx + (double)controller.w * 0.5) - (int)((double)this.w * 0.5);
                        break block0;
                    }
                }
                break;
            }
            case 37: {
                this.posx = controller.posx - this.w - gap;
                switch (align) {
                    case 101: {
                        this.posy = controller.posy + gap;
                        break block0;
                    }
                    case 102: {
                        this.posy = controller.posy + controller.h - this.h - gap;
                        break block0;
                    }
                    case 3: {
                        this.posy = (int)((double)controller.posy + (double)controller.h * 0.5) - (int)((double)this.h * 0.5);
                        break block0;
                    }
                }
                break;
            }
            case 39: {
                this.posx = controller.posx + controller.w + gap;
                switch (align) {
                    case 101: {
                        this.posy = controller.posy + gap;
                        break block0;
                    }
                    case 102: {
                        this.posy = controller.posy + controller.h - this.h - gap;
                        break block0;
                    }
                    case 3: {
                        this.posy = (int)((double)controller.posy + (double)controller.h * 0.5) - (int)((double)this.h * 0.5);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public boolean isAnyChildPressed() {
        for (Controller child : this.controllers) {
            if (child.isPressed) {
                return true;
            }
            if (!child.isAnyChildPressed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processMouseMoved() {
        if (this.isActive) {
            for (Controller child : this.controllers) {
                child.processMouseMoved();
            }
            this.isHovered = this.isPointInside(this.pa.mouseX, this.pa.mouseY);
            for (EventAdapter adapter : this.adapters) {
                adapter.onMouseMoved();
            }
        }
    }

    @Override
    public void processMousePressed() {
        if (this.isActive && this.isHovered) {
            for (Controller child : this.controllers) {
                child.processMousePressed();
            }
            if (this.isAnyChildPressed()) {
                this.isPressed = false;
                return;
            }
            this.isPressed = true;
            selectedController = this;
            for (EventAdapter adapter : this.adapters) {
                adapter.onMousePressed();
            }
        }
    }

    @Override
    public void processMouseReleased() {
        if (this.isActive) {
            this.isPressed = false;
            for (Controller child : this.controllers) {
                child.processMouseReleased();
            }
            if (this.isHovered) {
                for (EventAdapter adapter : this.adapters) {
                    adapter.onMouseReleased();
                }
            }
        }
    }

    @Override
    public void processMouseDragged() {
        if (this.isActive) {
            for (Controller child : this.controllers) {
                child.processMouseDragged();
            }
            if (this.isDragable && this.isPressed) {
                this.posx += this.pa.mouseX - this.pa.pmouseX;
                this.posy += this.pa.mouseY - this.pa.pmouseY;
                for (EventAdapter adapter : this.adapters) {
                    adapter.onMouseDragged();
                }
            }
        }
    }

    @Override
    public void processMouseWheel(MouseEvent me) {
        if (this.isActive) {
            for (Controller child : this.controllers) {
                child.processMouseWheel(me);
            }
        }
    }

    @Override
    public void processKeyPressed() {
        if (this.isActive) {
            for (Controller child : this.controllers) {
                child.processKeyPressed();
            }
        }
    }

    @Override
    public void processKeyReleased() {
        if (this.isActive) {
            for (Controller child : this.controllers) {
                child.processKeyReleased();
            }
        }
    }

    public boolean isSelected(Controller controller) {
        return selectedController == controller;
    }

    @Override
    public boolean isPointInside(int x, int y) {
        boolean isInside = false;
        if (this.isActive && x > this.getAbsolutePosX() && x < this.getAbsolutePosX() + this.w && y > this.getAbsolutePosY() && y < this.getAbsolutePosY() + this.h) {
            isInside = true;
        }
        return isInside;
    }
}

