/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import def.processing.core.PApplet;
import java.util.HashMap;
import ktbyte.gui.Controller;
import ktbyte.gui.EventAdapter;
import ktbyte.gui.InputTextBox;
import ktbyte.gui.KTGUI;
import ktbyte.gui.ScrollBar;
import ktbyte.gui.ScrollableTextArea;

public class Console
extends Controller {
    private static final int BOX_ROUNDING = 7;
    private static final float INPUT_BOX_HEIGHT_PERCENTAGE = 0.1f;
    private InputTextBox inputBox;
    private ScrollableTextArea textArea;
    private ScrollBar scrollBar;
    private int inputTextColor = 0xFFFFFF;
    private int outputTextColor = 0;
    private HashMap<String, String> dict;
    private String lastVariableName;
    int inputBoxWidth = (int)(0.1f * (float)this.h);

    public Console(KTGUI ktgui, String title, int posx, int posy, int w, int h) {
        super(ktgui, title, posx, posy, w, h);
        this.dict = new HashMap();
        this.createScrollableTextArea();
        this.createInputBox();
        this.createScrollBar();
    }

    private void createScrollableTextArea() {
        this.textArea = new ScrollableTextArea(this.ktgui, "sta:" + this.title, 0, 0, this.w - this.inputBoxWidth, this.h - this.inputBoxWidth);
        this.textArea.setBorderRoundings(7, 0, 0, 0);
        this.textArea.addEventAdapter(new EventAdapter(){

            @Override
            public void onMouseWheel(int count) {
                int startLineNumberPosition = Console.this.textArea.getStartLinePosition();
                int endOfScrollableRange = Console.this.textArea.getLineCount() - Console.this.textArea.getMaxLinesToDisplay() - 1;
                float mappedScrollBarPos = PApplet.map((float)startLineNumberPosition, (float)0.0f, (float)endOfScrollableRange, (float)0.0f, (float)100.0f);
                ((Console)Console.this).scrollBar.isActive = false;
                Console.this.scrollBar.setNormalizedValue(mappedScrollBarPos);
                ((Console)Console.this).scrollBar.isActive = true;
            }
        });
        this.attachController(this.textArea);
    }

    private void createScrollBar() {
        this.scrollBar = new ScrollBar(this.ktgui, "sb:" + this.title, this.w - this.inputBoxWidth, 0, this.inputBoxWidth, this.h - this.inputBoxWidth, 0, 100);
        this.scrollBar.addEventAdapter(new EventAdapter(){

            @Override
            public void onValueChanged() {
                Console.this.textArea.setNormalizedLinePosition(Console.this.scrollBar.getNormalizedValue());
            }
        });
        this.attachController(this.scrollBar);
    }

    private void createInputBox() {
        this.inputBox = new InputTextBox(this.ktgui, "ib:" + this.title, 0, this.h - this.inputBoxWidth, this.w, this.inputBoxWidth);
        this.inputBox.setHandleFocus(true);
        this.inputBox.setTextSize(16);
        this.inputBox.setBorderRoundings(0, 0, 7, 7);
        this.inputBox.addEventAdapter(new EventAdapter(){

            @Override
            public void onEnterKeyPressed() {
                KTGUI.debug("Processing input...");
                Console.this.handleConsoleInput();
            }
        });
        this.attachController(this.inputBox);
    }

    public String getValue(String name) {
        return this.dict.get(name);
    }

    public void readInput(String name) {
        this.lastVariableName = name;
    }

    @Override
    public void setBorderRoundings(int r1, int r2, int r3, int r4) {
        this.textArea.setBorderRoundings(r1, 0, 0, 0);
        this.inputBox.setBorderRoundings(0, 0, r3, r4);
        this.scrollBar.setBorderRoundings(0, r2, 0, 0);
    }

    public void enableLineStartMarks(boolean val) {
        this.textArea.enableBlockMarks(val);
    }

    private void handleConsoleInput() {
        String textInput = this.inputBox.getText();
        this.textArea.appendTextBlock(textInput, this.inputTextColor);
        this.textArea.scrollToBottom();
        this.inputBox.setText("");
        this.dict.put(this.lastVariableName, textInput);
        int scrollableRange = this.textArea.getLineCount() - this.textArea.getMaxLinesToDisplay() - 1;
        float scrollBarRange = this.scrollBar.getRangeEnd() - this.scrollBar.getRangeStart();
        float step = scrollBarRange / (float)scrollableRange;
        this.scrollBar.setHandleStep(step);
        for (EventAdapter adapter : this.adapters) {
            adapter.onConsoleInput(textInput, this.lastVariableName);
        }
    }

    public void setInputTextSize(int size) {
        this.inputBox.setTextSize(size);
    }

    public void setOutputTextSize(int size) {
        this.textArea.setTextSize(size);
    }

    public void writeOutput(String textBlock) {
        this.textArea.appendTextBlock(textBlock, this.outputTextColor);
        this.textArea.scrollToBottom();
        int scrollableRange = this.textArea.getLineCount() - this.textArea.getMaxLinesToDisplay() - 1;
        float scrollBarRange = this.scrollBar.getRangeEnd() - this.scrollBar.getRangeStart();
        float step = scrollBarRange / (float)scrollableRange;
        this.scrollBar.setHandleStep(step);
    }

    public void setInputFocused(boolean value) {
        this.inputBox.setFocused(value);
    }

    public int getStartLinePosition() {
        return this.textArea.getStartLinePosition();
    }

    public void setInputTextColor(int c) {
        this.inputTextColor = c;
    }

    public void setOutputTextColor(int c) {
        this.outputTextColor = c;
    }

    public void enableBlockMarks(boolean val) {
        this.textArea.enableBlockMarks(val);
    }

    public void enableLineNumbers(boolean val) {
        this.textArea.enableLineNumbers(val);
    }

    public String getLine(int index) {
        return this.textArea.getTextLine(index);
    }

    public String getBlock(int index) {
        return this.textArea.getTextBlock(index);
    }

    public int getLineCount() {
        return this.textArea.getLineCount();
    }

    public int getBlockCount() {
        return this.textArea.getBlockCount();
    }

    public String getLastLine() {
        String textLine = "_NO_LINES_EXIST_YET_";
        if (this.getLineCount() > 0) {
            textLine = this.getLine(this.getLineCount() - 1);
        }
        return textLine;
    }

    public String getLastBlock() {
        String textBlock = "_NO_BLOCKS_EXIST_YET_";
        if (this.getBlockCount() > 0) {
            textBlock = this.getBlock(this.getBlockCount() - 1);
        }
        return textBlock;
    }

    public InputTextBox getInputBox() {
        return this.inputBox;
    }

    public ScrollableTextArea getTextArea() {
        return this.textArea;
    }

    public ScrollBar getScrollBar() {
        return this.scrollBar;
    }
}

