/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import ktbyte.gui.Button;
import ktbyte.gui.KTGUI;

class CloseButton
extends Button {
    public CloseButton(KTGUI ktgui, String title, int posx, int posy, int w, int h) {
        super(ktgui, title, posx, posy, w, h);
        this.isDragable = false;
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
        this.pg.beginDraw();
        this.pg.rectMode(0);
        if (this.isHovered && !this.isPressed) {
            this.pg.fill(KTGUI.COLOR_FG_HOVERED);
        } else if (this.isHovered && this.isPressed) {
            this.pg.fill(KTGUI.COLOR_FG_PRESSED);
        } else {
            this.pg.fill(200, 200.0f);
        }
        this.pg.stroke(0);
        this.pg.strokeWeight(1.0f);
        this.pg.rectMode(0);
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h);
        this.pg.line((float)this.w * 0.2f, (float)this.h * 0.2f, (float)this.w * 0.8f, (float)this.h * 0.8f);
        this.pg.line((float)this.w * 0.2f, (float)this.h * 0.8f, (float)this.w * 0.8f, (float)this.h * 0.2f);
        this.pg.endDraw();
    }

    @Override
    public void processMousePressed() {
        super.processMousePressed();
        if (this.isPressed) {
            this.closeParent();
        }
    }

    @Override
    public void closeParent() {
        if (this.parentController != null) {
            if (!this.parentController.getClass().getName().contains("Window")) {
                this.parentController.closeParent();
            }
            this.parentController.close();
        }
        this.closeAllChildsRecursively();
    }
}

