/*
 * Decompiled with CFR 0.152.
 */
package ktbyte.gui;

import ktbyte.gui.Controller;
import ktbyte.gui.KTGUI;

public class ArrowButton
extends Controller {
    private int direction;

    ArrowButton(KTGUI ktgui, String title, int posx, int posy, int w, int h, int dir) {
        super(ktgui, title, posx, posy, w, h);
        this.direction = dir;
    }

    @Override
    public void updateGraphics() {
        super.updateGraphics();
        this.pg.beginDraw();
        this.pg.pushStyle();
        this.pg.stroke(0);
        if (this.isHovered && !this.isPressed) {
            this.pg.fill(this.fgHoveredColor);
        } else if (this.isHovered && this.isPressed) {
            this.pg.fill(this.fgPressedColor);
        } else {
            this.pg.fill(this.fgPassiveColor);
        }
        if (this.isSelected(this)) {
            this.pg.strokeWeight(2.0f);
        } else {
            this.pg.strokeWeight(1.0f);
        }
        this.pg.rectMode(0);
        this.pg.rect(0.0f, 0.0f, (float)this.w, (float)this.h, (float)this.r1, (float)this.r2, (float)this.r3, (float)this.r4);
        this.pg.pushMatrix();
        this.pg.translate((float)this.w * 0.5f, (float)this.h * 0.5f);
        if (this.direction == 38) {
            this.pg.rotate((float)Math.PI);
        } else if (this.direction == 40) {
            this.pg.rotate(0.0f);
        } else if (this.direction == 37) {
            this.pg.rotate(1.5707964f);
        } else if (this.direction == 39) {
            this.pg.rotate(4.712389f);
        }
        this.pg.strokeWeight(1.0f);
        this.pg.line((float)(-this.w) * 0.4f, (float)(-this.h) * 0.4f, 0.0f, (float)this.h * 0.4f);
        this.pg.line(0.0f, (float)this.h * 0.4f, (float)this.w * 0.4f, (float)(-this.h) * 0.4f);
        this.pg.popMatrix();
        this.pg.popStyle();
        this.pg.endDraw();
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }
}

