declare namespace ktbyte.gui {
}
declare namespace ktbyte.gui {
    /**
     * This abstract class should be extended by the KTGUI components (controllers)
     * @class
     */
    abstract class EventAdapter {
        onMousePressed(): void;
        onMouseReleased(): void;
        onMouseMoved(): void;
        onMouseDragged(): void;
        onMouseWheel(count: number): void;
        onAnyKeyReleased(): void;
        onAnyKeyPressed(): void;
        onEnterKeyPressed(): void;
        onValueChanged(): void;
        onConsoleInput(textInput: string, lastVariableName: string): void;
        println(string: string): void;
    }
}
declare namespace ktbyte.gui {
    /**
     * This is a constructor of the KTGUI class.
     * It automatically registers the 'draw', 'mouseEvent' and 'keyEvent' methods of this class in PApplet.
     * @param {*} pa
     * @class
     */
    class KTGUI implements PConstants {
        static pa: any;
        garbageList: any;
        drawCallStack: Array<string>;
        static COLOR_FG_HOVERED: number;
        static COLOR_FG_PRESSED: number;
        static COLOR_FG_PASSIVE: number;
        static COLOR_BG_HOVERED: number;
        static COLOR_BG_PASSIVE: number;
        static COLOR_BG_PRESSED: number;
        static DEFAULT_COMPONENT_WIDTH: number;
        static DEFAULT_ALIGN_GAP: number;
        static DEFAULT_ROUNDING: number;
        static debugControllers: boolean;
        debugDrawCallStack: boolean;
        constructor(pa: any);
        init(pa: any): void;
        static getParentPApplet(): any;
        /**
         * This method is intended to be called <b>automatically</b> at the end of each draw() cycle of the parent PApplet.
         * This way, the KTGUI class automatically updates all the controllers on the <i>default</i> and <i>active</i> stages.
         */
        draw(): void;
        setDrawCallStackFlag(debug: boolean): void;
        drawDebugTextSplitLine(x: number, y: number): void;
        addDrawCallStackDebugMessage(msg: string): void;
        addToGarbage(controller: ktbyte.gui.Controller, millis: number): void;
        collectGarbage(): void;
        createButton$java_lang_String$int$int$int$int(title: string, x: number, y: number, w: number, h: number): ktbyte.gui.Button;
        createButton(title?: any, x?: any, y?: any, w?: any, h?: any): any;
        createButton$int$int$int$int(x: number, y: number, w: number, h: number): ktbyte.gui.Button;
        createDirectionButton$java_lang_String$int$int$int$int$int(title: string, x: number, y: number, w: number, h: number, dir: number): ktbyte.gui.ArrowButton;
        createDirectionButton(title?: any, x?: any, y?: any, w?: any, h?: any, dir?: any): any;
        createDirectionButton$int$int$int$int$int(x: number, y: number, w: number, h: number, dir: number): ktbyte.gui.ArrowButton;
        createSlider$java_lang_String$int$int$int$int$int$int(title: string, posx: number, posy: number, w: number, h: number, sr: number, er: number): ktbyte.gui.Slider;
        createSlider(title?: any, posx?: any, posy?: any, w?: any, h?: any, sr?: any, er?: any): any;
        createSlider$int$int$int$int$int$int(posx: number, posy: number, w: number, h: number, sr: number, er: number): ktbyte.gui.Slider;
        createPanel$java_lang_String$int$int$int$int(title: string, x: number, y: number, w: number, h: number): ktbyte.gui.Panel;
        createPanel(title?: any, x?: any, y?: any, w?: any, h?: any): any;
        createPanel$int$int$int$int(x: number, y: number, w: number, h: number): ktbyte.gui.Panel;
        createPane$java_lang_String$int$int$int$int(title: string, x: number, y: number, w: number, h: number): ktbyte.gui.Pane;
        createPane(title?: any, x?: any, y?: any, w?: any, h?: any): any;
        createPane$int$int$int$int(x: number, y: number, w: number, h: number): ktbyte.gui.Pane;
        createScrollBar$int$int$int$int$int$int(x: number, y: number, w: number, h: number, sr: number, er: number): ktbyte.gui.ScrollBar;
        createScrollBar$java_lang_String$int$int$int$int$int$int(title: string, x: number, y: number, w: number, h: number, sr: number, er: number): ktbyte.gui.ScrollBar;
        createScrollBar(title?: any, x?: any, y?: any, w?: any, h?: any, sr?: any, er?: any): any;
        createInputTextBox$java_lang_String$int$int$int$int(title: string, x: number, y: number, w: number, h: number): ktbyte.gui.InputTextBox;
        createInputTextBox(title?: any, x?: any, y?: any, w?: any, h?: any): any;
        createInputTextBox$int$int$int$int(x: number, y: number, w: number, h: number): ktbyte.gui.InputTextBox;
        /**
         * This method 'redirects' the emitted mouse event from PApplet to KTGUI 'transfer' methods.
         * This method will be called <b>automatically</b> when the PApplet.mouseEvent is happening.
         * @param {ProcessingMouseEvent} e
         */
        mouseEvent(e: ProcessingMouseEvent): void;
        /**
         * This method 'redirects' the emitted keyboard event from PApplet to KTGUI 'transfer' methods.
         * This method will be called <b>automatically</b> when the PApplet.keyEvent is happening.
         * @param {ProcessingKeyEvent} e
         */
        keyEvent(e: ProcessingKeyEvent): void;
        static debug(string: string): void;
        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseDragged event to KTGUI components (controllers)
         * @private
         */
        mouseDragged(): void;
        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mousePressed event to KTGUI components (controllers)
         * @private
         */
        mousePressed(): void;
        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseReleased event to KTGUI components (controllers)
         * @private
         */
        mouseReleased(): void;
        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.mouseMoved event to KTGUI components (controllers)
         * @private
         */
        mouseMoved(): void;
        mouseWheel(me: ProcessingMouseEvent): void;
        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.keyPressed event to KTGUI components (controllers)
         * @private
         */
        keyPressed(): void;
        /**
         * This is a 'transfer' method - it 'redirects' the PApplet.keyReleased event to KTGUI components (controllers)
         * @private
         */
        keyReleased(): void;
    }
}
declare namespace ktbyte.gui {
    /**
     *
     *
     * @class
     */
    class StageManager {
        static __static_initialized: boolean;
        static __static_initialize(): void;
        static stages: Array<ktbyte.gui.Stage>;
        static stages_$LI$(): Array<ktbyte.gui.Stage>;
        static activeStage: ktbyte.gui.Stage;
        static activeStage_$LI$(): ktbyte.gui.Stage;
        static defaultStage: ktbyte.gui.Stage;
        static defaultStage_$LI$(): ktbyte.gui.Stage;
        static instance: StageManager;
        static instance_$LI$(): StageManager;
        static __static_initializer_0(): void;
        static getInstance(): StageManager;
        init(): void;
        createStage(name: string): ktbyte.gui.Stage;
        getDefaultStage(): ktbyte.gui.Stage;
        getActiveStage(): ktbyte.gui.Stage;
        goToStage$ktbyte_gui_Stage(stage: ktbyte.gui.Stage): void;
        goToStage(stage?: any): any;
        goToStage$int(numStage: number): void;
        goToNextStage(): void;
        unregisterControllerFromAllStages(controller: ktbyte.gui.Controller): void;
        userStagesExist(): boolean;
        getStages(): Array<ktbyte.gui.Stage>;
    }
}
declare namespace ktbyte.gui {
    class EventProcessor {
        isActive: boolean;
        isPressed: boolean;
        isHovered: boolean;
        isDragged: boolean;
        isVisible: boolean;
        isDragable: boolean;
        handleFocus: boolean;
        adapters: Array<ktbyte.gui.EventAdapter>;
        processMouseMoved(): void;
        processMousePressed(): void;
        processMouseReleased(): void;
        processMouseDragged(): void;
        processMouseWheel(me: ProcessingMouseEvent): void;
        processKeyPressed(): void;
        processKeyReleased(): void;
        isPointInside(x: number, y: number): boolean;
        addEventAdapter(adapter: ktbyte.gui.EventAdapter): void;
        constructor();
    }
}
declare namespace ktbyte.gui {
    /**
     * A Stage can have multple controllers.
     * The KTGUI class should handle the transition from one Stage to another.
     * Only one Stage can be active at a time.
     * Only the GUI elements from the active Stage will be displayed
     * This allows the sharing of variables between different Stages, by storing/retriving data from the 'context' object
     * @param {string} name
     * @class
     */
    class Stage {
        controllers: Array<ktbyte.gui.Controller>;
        name: string;
        pa: any;
        constructor(name: string);
        getName(): string;
        draw(): void;
        registerController(controller: ktbyte.gui.Controller): void;
        unregisterController(controller: ktbyte.gui.Controller): void;
        getControllers(): Array<ktbyte.gui.Controller>;
    }
}
declare namespace ktbyte.gui {
    /**
     * This class automatically receives events from PApplet when they happen.
     * Every KTGUI component (controller) should extend this class in order to be able to receive the mouse and keyboard
     * events.
     * One should override only the 'needed' event methods. This allows to save time and decrease the amount of code.
     * One should always overridde the 'draw' method.
     * @extends ktbyte.gui.EventProcessor
     * @class
     */
    abstract class Controller extends ktbyte.gui.EventProcessor implements PConstants {
        title: string;
        posx: number;
        posy: number;
        w: number;
        h: number;
        r1: number;
        r2: number;
        r3: number;
        r4: number;
        controllers: Array<Controller>;
        pa: any;
        ktgui: ktbyte.gui.KTGUI;
        parentController: Controller;
        parentStage: ktbyte.gui.Stage;
        static selectedController: Controller;
        pg: PGraphics;
        userpg: PGraphics;
        fgHoveredColor: number;
        fgPressedColor: number;
        fgPassiveColor: number;
        bgHoveredColor: number;
        bgPressedColor: number;
        bgPassiveColor: number;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        updateGraphics(): void;
        updateUserDefinedGraphics(userpg: PGraphics): void;
        drawUserDefinedGraphics(): void;
        drawControllers(): void;
        drawGraphics(): void;
        draw(): void;
        setParentController(controller: Controller): void;
        setTitle(title: string): void;
        getInfo(): string;
        getFullInfoList(level: number): Array<string>;
        getWidth(): number;
        setWidth(w: number): void;
        getHeight(): number;
        getAbsolutePosX(): number;
        getAbsolutePosY(): number;
        setHeight(h: number): void;
        setHoveredColor(c: number): void;
        setPressedColor(c: number): void;
        setPassiveColor(c: number): void;
        setBorderRoundings(r1: number, r2: number, r3: number, r4: number): void;
        setHandleFocus(val: boolean): void;
        getGraphics(): PGraphics;
        addController$ktbyte_gui_Controller$int$int(child: Controller, hAlign: number, vAlign: number): void;
        addController$ktbyte_gui_Controller$int$int$int(child: Controller, hAlign: number, vAlign: number, gap: number): void;
        addController(child?: any, hAlign?: any, vAlign?: any, gap?: any): any;
        positionAboutOtherController(controller: Controller, relativePosx: number, relativePosy: number): void;
        attachController(controller: Controller): void;
        detachController(controller: Controller): void;
        detachAllControllers(): void;
        closeParent(): void;
        closeAllChildsRecursively(): void;
        close(): void;
        getPosx(): number;
        setPosx(posx: number): void;
        getPosy(): number;
        setPosy(posy: number): void;
        alignAboutCanvas$int$int(hAlign: number, vAlign: number): void;
        alignAboutCanvas$int$int$int(hAlign: number, vAlign: number, gap: number): void;
        /**
         * @param {number} hAlign
         * the horizontal alignment position
         * @param {number} vAlign
         * the vertical alignment position
         * @param {number} gap
         * the gap between the outer boundary of the PApplet canvas and
         * the side of the controller to be aligned.
         */
        alignAboutCanvas(hAlign?: any, vAlign?: any, gap?: any): any;
        alignAbout$ktbyte_gui_Controller$int$int(controller: Controller, hAlign: number, vAlign: number): void;
        alignAbout$ktbyte_gui_Controller$int$int$int(controller: Controller, hAlign: number, vAlign: number, gap: number): void;
        /**
         * This method is used to place one controller <b>inside</b> the other (reference)
         * controller.
         * By 'aligning' we understand the process of changing the X and Y coordinates
         * so that the controller is placed inside and near one of the walls of the
         * reference controller.
         * The X and Y position, and width and height of the controller being used as
         * a reference are used to calculate the new position of the controller that is to
         * be aligned. The said values identify the 'boundary rectangle' of the reference
         * controller. The named constants LEFT, RIGHT, BOTTOM, TOP and CENTER are used to
         * identify the sides and the center of the bounding rectangle. The sides and center
         * of the reference rectangle are used for calculation of the relative
         * distances that are used to 'shift' the position of the controller to be
         * aligned. The direction of shifting is <b>inward</b> - i.e. the changing of relative
         * position is made <i>from the sides</i> of the bounding rectangle <i>to the
         * center</i> of the bounding rectangle.
         *
         * @param {ktbyte.gui.Controller} controller
         * the 'reference' controller.
         * @param {number} hAlign
         * the horizontal alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>left</i> side will
         * 'stick' to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>right</i> side will
         * 'stick' to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will
         * 'stick' to the <i>center</i> of the reference controller.</br>
         * </li>
         * </ul>
         * @param {number} vAlign
         * the vertical alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * TOP - the controller will be placed so that its <i>top</i> side will
         * 'stick' to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>bottom</i> side will
         * 'stick' to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will
         * 'stick' to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         * @param {number} gap
         * the gap between aligned sides. If the CENTER constant is used as hAlign
         * or vAlign argument then the gap will <b>not</b> be added to that direction.
         */
        alignAbout(controller?: any, hAlign?: any, vAlign?: any, gap?: any): any;
        stackAbout$ktbyte_gui_Controller$int$int(controller: Controller, direction: number, align: number): void;
        stackAbout$ktbyte_gui_Controller$int$int$int(controller: Controller, direction: number, align: number, gap: number): void;
        /**
         * This method is used to position one controller <b>outside</b> the other
         * (reference) controller.
         * By 'stacking' we understand the process of changing the X and Y coordinates
         * so that the controller is placed outside and near one of the walls of the
         * reference controller.
         * The X and Y position, and width and height of the controller being used as
         * a reference are used to calculate the new position of the controller to
         * be aligned. The said values identify the 'boundary rectangle' of the reference
         * controller.
         * The named constants LEFT, RIGHT, BOTTOM and TOP are used to identify
         * the sides of the bounding rectangle. They are used for calculation of the
         * relative distances that are used to 'shift' the position of the controller to be
         * aligned. The direction of shifting is <b>outward</b> - i.e. the changing of
         * relative position is made from the sides of the bounding rectangle <i>to the
         * outward direction about</i> the bounding rectangle.
         *
         * @param <b>controller</b>
         * the 'reference' controller.
         * @param <b>direction</b>
         * the 'reference' alignment direction. The following named constants can be used:</br>
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>rigth</i> side will
         * 'stick' to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>left</i> side will
         * 'stick' to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * TOP - the controller will be placed so that its <i>bottom</i> side will
         * 'stick' to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>top</i> side will
         * 'stick' to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * </ul>
         * @param <b>align</b>
         * the 'orthogonal' alignment direction. </br>
         * The following named constants can be used:</br>
         * If the 'reference' alignment direction was chosen as LEFT or RIGTH, then the
         * 'orthogonal' direction can be set only fron one of the following constants:
         * <ul>
         * <li>
         * TOP - the controller will be placed so that its <i>top</i> side will be
         * aligned to the <i>top</i> side of the reference controller.</br>
         * </li>
         * <li>
         * BOTTOM - the controller will be placed so that its <i>bottom</i> side will be
         * aligned to the <i>bottom</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will be
         * aligned to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         *
         * If the 'reference' alignment direction was chosen as BOTTOM or TOP, then the
         * 'orthogonal' direction can be set only from one of the following constants:
         * <ul>
         * <li>
         * LEFT - the controller will be placed so that its <i>left</i> side will be
         * aligned to the <i>left</i> side of the reference controller.</br>
         * </li>
         * <li>
         * RIGHT - the controller will be placed so that its <i>right</i> side will be
         * aligned to the <i>right</i> side of the reference controller.</br>
         * </li>
         * <li>
         * CENTER - the controller will be placed so that its <i>center</i> will be
         * aligned to the <i>center</i> of the reference controller. </br>
         * </li>
         * </ul>
         *
         * @param <b>gap</b>
         * the gap of some length between the sides to be aligned. If the CENTER constant
         * is used as 'direction' or 'align' argument then the gap is <b>not</b> added
         * in that direction.
         * @param {ktbyte.gui.Controller} controller
         * @param {number} direction
         * @param {number} align
         * @param {number} gap
         */
        stackAbout(controller?: any, direction?: any, align?: any, gap?: any): any;
        isAnyChildPressed(): boolean;
        /**
         *
         */
        processMouseMoved(): void;
        /**
         *
         */
        processMousePressed(): void;
        /**
         *
         */
        processMouseReleased(): void;
        /**
         *
         */
        processMouseDragged(): void;
        /**
         *
         * @param {ProcessingMouseEvent} me
         */
        processMouseWheel(me: ProcessingMouseEvent): void;
        /**
         *
         */
        processKeyPressed(): void;
        /**
         *
         */
        processKeyReleased(): void;
        isSelected(controller: Controller): boolean;
        /**
         *
         * @param {number} x
         * @param {number} y
         * @return {boolean}
         */
        isPointInside(x: number, y: number): boolean;
    }
}
declare namespace ktbyte.gui {
    class InputTextBox extends ktbyte.gui.Controller {
        static BACKSPACE_ASCII_CODE: number;
        static ENTER_ASCII_CODE: number;
        static BASIC_ASCII_LOWER_LIMIT: number;
        static BASIC_ASCII_UPPER_LIMIT: number;
        welcomeText: string;
        inputText: string;
        textSize: number;
        textHeight: number;
        padding: number;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        updateGraphics(): void;
        updateTextBox(): void;
        updateBlinkingCursorGraphics(): void;
        /**
         *
         */
        processMousePressed(): void;
        /**
         *
         */
        processKeyPressed(): void;
        setFocused(value: boolean): void;
        setWelcomeText(text: string): void;
        /**
         * Sets the current text
         *
         * @param {string} text
         * The text that should be displayed inside the box
         */
        setText(text: string): void;
        getText(): string;
        /**
         * Sets the text size
         *
         * @param {number} textSize
         * The text size
         */
        setTextSize(textSize: number): void;
        updateTextAttributes(): void;
        getTrimmedInputText(): string;
        reverse(input: string): string;
    }
}
declare namespace ktbyte.gui {
    class Bar extends ktbyte.gui.Controller {
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        /**
         *
         */
        updateGraphics(): void;
    }
}
declare namespace ktbyte.gui {
    class ScrollBar extends ktbyte.gui.Controller {
        backwardButton: ktbyte.gui.ArrowButton;
        forwardButton: ktbyte.gui.ArrowButton;
        slider: ktbyte.gui.Slider;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number, sr: number, er: number);
        /**
         *
         */
        updateGraphics(): void;
        /**
         *
         * @param {number} r1
         * @param {number} r2
         * @param {number} r3
         * @param {number} r4
         */
        setBorderRoundings(r1: number, r2: number, r3: number, r4: number): void;
        createButtons(): void;
        createSlider(sr: number, er: number): void;
        getValue(): number;
        setValue(val: number): void;
        setNormalizedValue(val: number): void;
        getNormalizedValue(): number;
        getHandlePos(): number;
        setHandlePos(pos: number): void;
        setHandleType(handleType: number): void;
        setHandleStep(step: number): void;
        getHandleStep(): number;
        getIsValueVisible(): boolean;
        setIsValueVisible(visible: boolean): void;
        getRangeStart(): number;
        setRangeStart(rangeStart: number): void;
        getRangeEnd(): number;
        setRangeEnd(rangeEnd: number): void;
        setRounding(n: number): void;
        getSlider(): ktbyte.gui.Slider;
    }
    namespace ScrollBar {
        class ScrollBar$0 extends ktbyte.gui.EventAdapter {
            __parent: any;
            onMousePressed(): void;
            constructor(__parent: any);
        }
        class ScrollBar$1 extends ktbyte.gui.EventAdapter {
            __parent: any;
            onMousePressed(): void;
            constructor(__parent: any);
        }
        class ScrollBar$2 extends ktbyte.gui.EventAdapter {
            __parent: any;
            onMouseDragged(): void;
            onMousePressed(): void;
            onValueChanged(): void;
            constructor(__parent: any);
        }
    }
}
declare namespace ktbyte.gui {
    /**
     * This is a KTGUI component (controller).
     * This class extends the 'Controller' class.
     * The object of this class can be 'Pressed', 'Hovered', 'Released' and 'Dragged'.
     * @param {ktbyte.gui.KTGUI} ktgui
     * @param {string} title
     * @param {number} posx
     * @param {number} posy
     * @param {number} w
     * @param {number} h
     * @class
     * @extends ktbyte.gui.Controller
     */
    class Button extends ktbyte.gui.Controller {
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        /**
         *
         */
        updateGraphics(): void;
    }
}
declare namespace ktbyte.gui {
    class Console extends ktbyte.gui.Controller {
        static BOX_ROUNDING: number;
        static INPUT_BOX_HEIGHT_PERCENTAGE: number;
        inputBox: ktbyte.gui.InputTextBox;
        textArea: ktbyte.gui.ScrollableTextArea;
        scrollBar: ktbyte.gui.ScrollBar;
        inputTextColor: number;
        outputTextColor: number;
        dict: any;
        lastVariableName: string;
        inputBoxWidth: number;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        createScrollableTextArea(): void;
        createScrollBar(): void;
        createInputBox(): void;
        /**
         * Returns a stored value from the console's memory
         *
         * @param {string} name
         * the key of the stored entry
         *
         * @return {string} a stored value from the console's memory
         */
        getValue(name: string): string;
        /**
         * Sets the name of the next console's entry
         *
         * @param {string} name
         * the key of the next stored entry
         */
        readInput(name: string): void;
        setBorderRoundings(r1: number, r2: number, r3: number, r4: number): void;
        enableLineStartMarks(val: boolean): void;
        handleConsoleInput(): void;
        setInputTextSize(size: number): void;
        setOutputTextSize(size: number): void;
        writeOutput(textBlock: string): void;
        setInputFocused(value: boolean): void;
        getStartLinePosition(): number;
        setInputTextColor(c: number): void;
        setOutputTextColor(c: number): void;
        enableBlockMarks(val: boolean): void;
        enableLineNumbers(val: boolean): void;
        getLine(index: number): string;
        getBlock(index: number): string;
        getLineCount(): number;
        getBlockCount(): number;
        getLastLine(): string;
        getLastBlock(): string;
        getInputBox(): ktbyte.gui.InputTextBox;
        getTextArea(): ktbyte.gui.ScrollableTextArea;
        getScrollBar(): ktbyte.gui.ScrollBar;
    }
    namespace Console {
        class Console$0 extends ktbyte.gui.EventAdapter {
            __parent: any;
            onMouseWheel(count: number): void;
            constructor(__parent: any);
        }
        class Console$1 extends ktbyte.gui.EventAdapter {
            __parent: any;
            onValueChanged(): void;
            constructor(__parent: any);
        }
        class Console$2 extends ktbyte.gui.EventAdapter {
            __parent: any;
            onEnterKeyPressed(): void;
            constructor(__parent: any);
        }
    }
}
declare namespace ktbyte.gui {
    class ScrollableTextArea extends ktbyte.gui.Controller {
        textSize: number;
        padding: number;
        textLines: Array<ScrollableTextArea.TextLine>;
        textBlocks: Array<ScrollableTextArea.TextBlock>;
        startLinePosition: number;
        __enableBlockMarks: boolean;
        __enableLineNumbers: boolean;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        /**
         *
         */
        updateGraphics(): void;
        updateTextAreaGraphics(): void;
        getEndLinePosition(): number;
        /**
         *
         * @param {ProcessingMouseEvent} me
         */
        processMouseWheel(me: ProcessingMouseEvent): void;
        mouseScrolled(mouseWheelDelta: number): void;
        incrementStartLine(): void;
        decrementStartLine(): void;
        getMaxAllowedStartLinePos(): number;
        getMaxLinesToDisplay(): number;
        scrollToTop(): void;
        scrollToBottom(): void;
        scrollToPosition(lineNumber: number): void;
        getTextLines(): Array<ScrollableTextArea.TextLine>;
        getTextBlocks(): Array<ScrollableTextArea.TextBlock>;
        getPadding(): number;
        setPadding(padding: number): void;
        getTextSize(): number;
        setTextSize(textSize: number): void;
        appendTextBlock$java_lang_String(text: string): void;
        appendTextBlock$java_lang_String$int(text: string, color: number): void;
        appendTextBlock(text?: any, color?: any): any;
        updateWrappedLines(): void;
        getTextHeight(): number;
        getStartLinePosition(): number;
        setStartLinePosition(pos: number): void;
        setNormalizedLinePosition(pos: number): void;
        enableBlockMarks(val: boolean): void;
        enableLineNumbers(val: boolean): void;
        getTextLine(index: number): string;
        getTextBlock(index: number): string;
        getLineCount(): number;
        getBlockCount(): number;
    }
    namespace ScrollableTextArea {
        class TextLine {
            __parent: any;
            content: string;
            textColor: number;
            isHead: boolean;
            constructor(__parent: any, content?: any, textColor?: any, isHead?: any);
        }
        class TextBlock {
            __parent: any;
            content: string;
            isHeadAlreadyMarked: boolean;
            textColor: number;
            constructor(__parent: any, content?: any, textColor?: any);
            appendAsWrappedLines(_textSize: number): void;
            addWrappedLine(sb: {
                str: string;
                toString: Function;
            }): void;
        }
    }
}
declare namespace ktbyte.gui {
    /**
     * @extends ktbyte.gui.Controller
     * @class
     */
    class Pane extends ktbyte.gui.Controller {
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        /**
         *
         */
        updateGraphics(): void;
    }
}
declare namespace ktbyte.gui {
    class ArrowButton extends ktbyte.gui.Controller {
        direction: number;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number, dir: number);
        /**
         *
         */
        updateGraphics(): void;
        setDirection(dir: number): void;
    }
}
declare namespace ktbyte.gui {
    class Panel extends ktbyte.gui.Controller {
        titleBar: ktbyte.gui.TitleBar;
        pane: ktbyte.gui.Pane;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        /**
         *
         */
        updateGraphics(): void;
        /**
         *
         */
        processMousePressed(): void;
        /**
         *
         * @param {number} x
         * @param {number} y
         * @return {boolean}
         */
        isPointInside(x: number, y: number): boolean;
        createTitleBar(): void;
        createPane(): void;
        addController$ktbyte_gui_Controller$int$int(child: ktbyte.gui.Controller, hAlign: number, vAlign: number): void;
        addController$ktbyte_gui_Controller$int$int$int(child: ktbyte.gui.Controller, hAlign: number, vAlign: number, gap: number): void;
        /**
         * Add child controller to the 'internal' pane instead of adding it to 'this' window
         * @param {ktbyte.gui.Controller} child
         * @param {number} hAlign
         * @param {number} vAlign
         * @param {number} gap
         */
        addController(child?: any, hAlign?: any, vAlign?: any, gap?: any): any;
        getPane(): ktbyte.gui.Pane;
    }
}
declare namespace ktbyte.gui {
    /**
     * @extends ktbyte.gui.Controller
     * @class
     */
    class Slider extends ktbyte.gui.Controller {
        static HANDLE_TYPE_CENTERED: number;
        static HANDLE_TYPE_EXPANDED: number;
        handleType: number;
        handleSize: number;
        handlePos: number;
        rangeStart: number;
        rangeEnd: number;
        value: number;
        valueStep: number;
        roundingTemplate: number;
        isValueVisible: boolean;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number, sr: number, er: number);
        /**
         *
         */
        updateGraphics(): void;
        drawExpandedHandle(): void;
        drawCenteredHandle(): void;
        getValue(): number;
        setValue(val: number): void;
        getNormalizedValue(): number;
        setNormalizedValue(val: number): void;
        notifyAdapterOnValueChanged(): void;
        getIsValueVisible(): boolean;
        setIsValueVisible(visible: boolean): void;
        getHandlePos(): number;
        setHandlePos(pos: number): void;
        getValueStep(): number;
        setValueStep(step: number): void;
        incrementValue(): void;
        decrementValue(): void;
        setHandleType(handleType: number): void;
        getHandleSize(): number;
        setHandleSize(hSize: number): void;
        getRangeStart(): number;
        setRangeStart(rangeStart: number): void;
        getRangeEnd(): number;
        setRangeEnd(rangeEnd: number): void;
        setRounding(n: number): void;
        /**
         * This method is called when the user change the <b>value</b> of the slider
         * without the mouse, using the setValue(int) method.
         * @private
         */
        updateHandlePositionFromValue(): void;
        /**
         * This method is called when the user change the <b>position</b> of the slider
         * with the mouse.
         * @private
         */
        updateHandlePositionFromMouse(): void;
        /**
         * This method is called to recalculate the slider's `value` within the given range
         * when the user change the <b>position</b> of the slider with the mouse.
         * @private
         */
        updateValueFromHandlePosition(): void;
        processMouseMoved(): void;
        processMousePressed(): void;
        processMouseReleased(): void;
        processMouseDragged(): void;
    }
}
declare namespace ktbyte.gui {
    class TitleBar extends ktbyte.gui.Bar {
        closeButton: ktbyte.gui.CloseButton;
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
    }
}
declare namespace ktbyte.gui {
    /**
     *
     * @param {ktbyte.gui.KTGUI} ktgui
     * @param {string} title
     * @param {number} posx
     * @param {number} posy
     * @param {number} w
     * @param {number} h
     * @class
     * @extends ktbyte.gui.Button
     */
    class CloseButton extends ktbyte.gui.Button {
        constructor(ktgui: ktbyte.gui.KTGUI, title: string, posx: number, posy: number, w: number, h: number);
        /**
         *
         */
        updateGraphics(): void;
        /**
         * TODO : replace 'closeControllerRecursively' method with 'closeParentWindow' in
         * order to prevent closing ALL controllers up to the 'root'. That behaviour is not
         * right - the CloseButton of the Window.TitleBar should close only the parent Window
         * and all it's childs (and their childs).
         */
        processMousePressed(): void;
        /**
         * This method closes all the controllers recursively up to the parent Window
         * and then closes all its childs recursively down.
         */
        closeParent(): void;
    }
}
