/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.sph;

import org.jbox2d.common.Vec2;
import org.jbox2d.util.sph.Parameter;
import org.jbox2d.util.sph.Particle;

public class SmoothParticle
extends Particle {
    public int ID;
    protected double pressure;
    protected double density;
    protected double h;
    protected double c;
    protected double ChangeDensity;
    protected Vec2 ChangeVelocity;
    protected int shapeID;
    protected int numNeighbors;
    protected double minDensity;
    protected double maxDensity;

    public SmoothParticle() {
        this.pressure = 0.0;
        this.density = 0.0;
        this.h = 0.0;
        this.c = 0.0;
        this.ChangeDensity = 0.0;
        this.ChangeVelocity = new Vec2(0.0f, 0.0f);
        this.ID = 0;
        this.shapeID = -1;
        this.minDensity = 999999.0;
        this.maxDensity = -999999.0;
        this.numNeighbors = 0;
    }

    public SmoothParticle(Vec2 p, Vec2 v, double m, double d, double pr, double len, double speedSnd) {
        super(p, v, m);
        this.pressure = pr;
        this.density = d;
        this.h = len;
        this.c = speedSnd;
        this.ChangeDensity = 0.0;
        this.ChangeVelocity = new Vec2(0.0f, 0.0f);
        this.shapeID = -1;
        this.ID = 0;
        this.minDensity = 999999.0;
        this.maxDensity = -999999.0;
        this.numNeighbors = 0;
    }

    public SmoothParticle(SmoothParticle SP) {
        this.pos = SP.pos.clone();
        this.vel = SP.vel.clone();
        this.mass = SP.mass;
        this.density = SP.getDensity();
        this.pressure = SP.getPressure();
        this.h = SP.getSmoothingLength();
        this.c = SP.getSpeedSound();
        this.minDensity = SP.getMinDensity();
        this.maxDensity = SP.getMaxDensity();
        this.ChangeVelocity = SP.getChangeVelocity();
        this.ChangeDensity = SP.getChangeDensity();
        this.deleted = SP.deleted;
        this.ID = SP.ID;
        this.shapeID = SP.shapeID;
        this.numNeighbors = SP.numNeighbors;
    }

    public void setPressure(double p) {
        this.pressure = p;
    }

    public void setDensity(double den) {
        this.density = den;
    }

    public void setSmoothingLength(double len) {
        this.h = len;
    }

    public void setSpeedSound(double spSnd) {
        this.c = spSnd;
    }

    public void setChangeVelocity(Vec2 ChangeV) {
        this.ChangeVelocity.set(ChangeV);
    }

    public void setChangeDensity(double cd) {
        this.ChangeDensity = cd;
    }

    public void setMinDensity(double m) {
        this.minDensity = m;
    }

    public void setMaxDensity(double m) {
        this.maxDensity = m;
    }

    public void setShapeID(int id) {
        this.shapeID = id;
    }

    public void setNumNeighbors(int n) {
        this.numNeighbors = n;
    }

    public double getPressure() {
        return this.pressure;
    }

    public double getSmoothingLength() {
        return this.h;
    }

    public double getDensity() {
        return this.density;
    }

    public double getSpeedSound() {
        return this.c;
    }

    public double getChangeDensity() {
        return this.ChangeDensity;
    }

    public Vec2 getChangeVelocity() {
        return this.ChangeVelocity;
    }

    public double getChangeVelocityX() {
        return this.ChangeVelocity.x;
    }

    public double getChangeVelocityY() {
        return this.ChangeVelocity.y;
    }

    public int getShapeID() {
        return this.shapeID;
    }

    public double getMinDensity() {
        return this.minDensity;
    }

    public double getMaxDensity() {
        return this.maxDensity;
    }

    public int getNumNeighbors() {
        return this.numNeighbors;
    }

    public void calcPressure(Parameter p) {
        this.pressure = p.c * p.c * this.density;
    }

    public void zeroSPHVars() {
        this.ChangeDensity = 0.0;
        this.ChangeVelocity.set(0.0f, 0.0f);
        this.numNeighbors = 0;
    }

    public void calcChangeDensity(SmoothParticle sp, Vec2 v_ij) {
        this.ChangeDensity += sp.mass * ((double)v_ij.x * this.gradientKernelX(sp) + (double)v_ij.y * this.gradientKernelY(sp));
    }

    public void calcChangeVelocity(SmoothParticle sp, Vec2 v_ij, Parameter param) {
        double pressTerm = this.pressureTerm(sp);
        double artVisc = this.artificialViscosity(sp, param);
        double oldChngVelX = this.ChangeVelocity.x;
        double oldChngVelY = this.ChangeVelocity.y;
        this.ChangeVelocity.x = (float)(oldChngVelX + sp.mass * (pressTerm * this.gradientKernelX(sp) + (double)v_ij.x * artVisc));
        this.ChangeVelocity.y = (float)(oldChngVelY + sp.mass * (pressTerm * this.gradientKernelY(sp) + (double)v_ij.y * artVisc));
    }

    public void addForceX(Parameter param) {
        this.ChangeVelocity.x = (float)((double)this.ChangeVelocity.x + param.bodyFX);
    }

    public void addForceY(Parameter param) {
        this.ChangeVelocity.x = (float)((double)this.ChangeVelocity.y + param.bodyFY);
    }

    private double pressureTerm(SmoothParticle sp) {
        return -1.0 * (this.pressure / (this.density * this.density) + sp.getPressure() / (sp.getDensity() * sp.getDensity()));
    }

    protected double artificialViscosity(SmoothParticle sp, Parameter param) {
        double distance = Math.sqrt((this.pos.x - sp.pos.x) * (this.pos.x - sp.pos.x) + (this.pos.y - sp.pos.y) * (this.pos.y - sp.pos.y));
        Vec2 r_ij = new Vec2(this.pos.x - sp.pos.x, this.pos.y - sp.pos.y);
        return param.nu * (this.density + sp.getDensity()) * ((double)r_ij.x * this.gradientKernelX(sp) + (double)r_ij.y * this.gradientKernelY(sp)) / (this.density * sp.getDensity() * (distance * distance + 0.01 * this.h * this.h));
    }

    protected double kernel(SmoothParticle sp) {
        double distance = 0.0;
        double normalization = 10.0 / (Math.PI * 7 * this.h * this.h);
        double dist1 = this.pos.x - sp.pos.x;
        double dist2 = this.pos.y - sp.pos.y;
        distance = Math.sqrt(dist1 * dist1 + dist2 * dist2);
        if (distance < this.h) {
            return normalization * (1.0 - 1.5 * distance * distance / (this.h * this.h) + 0.75 * distance * distance * distance / (this.h * this.h * this.h));
        }
        if (distance < 2.0 * this.h) {
            return normalization * (2.0 - 3.0 * distance / this.h + 1.5 * distance * distance / (this.h * this.h) - 0.25 * distance * distance * distance / (this.h * this.h * this.h));
        }
        return 0.0;
    }

    protected double gradientKernelX(SmoothParticle sp) {
        double distance = 0.0;
        double diffX = 0.0;
        double diffY = 0.0;
        double normalization = 10.0 / (Math.PI * 7 * this.h * this.h);
        diffX = this.pos.x - sp.pos.x;
        diffY = this.pos.y - sp.pos.y;
        distance = Math.sqrt(diffX * diffX + diffY * diffY);
        if (distance < this.h) {
            return normalization * (-3.0 / (this.h * this.h) + 9.0 * distance / (4.0 * this.h * this.h * this.h)) * diffX;
        }
        if (distance < 2.0 * this.h) {
            return normalization * (-3.0 / (this.h * distance) + 3.0 / (this.h * this.h) - 3.0 * distance / (4.0 * this.h * this.h * this.h)) * diffX;
        }
        return 0.0;
    }

    protected double gradientKernelY(SmoothParticle sp) {
        double distance = 0.0;
        double diffX = 0.0;
        double diffY = 0.0;
        double normalization = 10.0 / (Math.PI * 7 * this.h * this.h);
        diffX = this.pos.x - sp.pos.x;
        diffY = this.pos.y - sp.pos.y;
        distance = Math.sqrt(diffX * diffX + diffY * diffY);
        if (distance < this.h) {
            return normalization * (-3.0 / (this.h * this.h) + 9.0 * distance / (4.0 * this.h * this.h * this.h)) * diffY;
        }
        if (distance < 2.0 * this.h) {
            return normalization * (-3.0 / (this.h * distance) + 3.0 / (this.h * this.h) - 3.0 * distance / (4.0 * this.h * this.h * this.h)) * diffY;
        }
        return 0.0;
    }

    public void setMinMaxDensity() {
        if (this.density > this.maxDensity) {
            this.maxDensity = this.density;
        } else if (this.density < this.minDensity) {
            this.minDensity = this.density;
        }
    }

    void updateNumNeighbors(SmoothParticle sp) {
        double distance = Math.sqrt((this.pos.x - sp.pos.x) * (this.pos.x - sp.pos.x) + (this.pos.y - sp.pos.y) * (this.pos.y - sp.pos.y));
        if (distance < 2.0 * this.h) {
            ++this.numNeighbors;
        }
    }
}

