/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.nonconvex;

public class Triangle {
    public float[] x = new float[3];
    public float[] y = new float[3];

    public Triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this();
        boolean ccw;
        float dx1 = x2 - x1;
        float dx2 = x3 - x1;
        float dy1 = y2 - y1;
        float dy2 = y3 - y1;
        float cross = dx1 * dy2 - dx2 * dy1;
        boolean bl = ccw = cross > 0.0f;
        if (ccw) {
            this.x[0] = x1;
            this.x[1] = x2;
            this.x[2] = x3;
            this.y[0] = y1;
            this.y[1] = y2;
            this.y[2] = y3;
        } else {
            this.x[0] = x1;
            this.x[1] = x3;
            this.x[2] = x2;
            this.y[0] = y1;
            this.y[1] = y3;
            this.y[2] = y2;
        }
    }

    public Triangle() {
    }

    public void set(Triangle t) {
        this.x[0] = t.x[0];
        this.x[1] = t.x[1];
        this.x[2] = t.x[2];
        this.y[0] = t.y[0];
        this.y[1] = t.y[1];
        this.y[2] = t.y[2];
    }

    public boolean containsPoint(float _x, float _y) {
        float vx2 = _x - this.x[0];
        float vy2 = _y - this.y[0];
        float vx1 = this.x[1] - this.x[0];
        float vy1 = this.y[1] - this.y[0];
        float vx0 = this.x[2] - this.x[0];
        float vy0 = this.y[2] - this.y[0];
        float dot00 = vx0 * vx0 + vy0 * vy0;
        float dot01 = vx0 * vx1 + vy0 * vy1;
        float dot02 = vx0 * vx2 + vy0 * vy2;
        float dot11 = vx1 * vx1 + vy1 * vy1;
        float dot12 = vx1 * vx2 + vy1 * vy2;
        float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0f && v >= 0.0f && u + v <= 1.0f;
    }
}

