/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.nonconvex;

import org.jbox2d.common.Vec2;
import org.jbox2d.util.nonconvex.Polygon;

class PolyNode {
    static final int MAX_CONNECTED = 32;
    int nConnected;
    boolean visited;
    Vec2 position;
    PolyNode[] connected = new PolyNode[32];

    public PolyNode() {
        this.nConnected = 0;
        this.visited = false;
    }

    public PolyNode(Vec2 pos) {
        this.position = pos;
        this.nConnected = 0;
        this.visited = false;
    }

    void addConnection(PolyNode toMe) {
        assert (this.nConnected < 32);
        int i = 0;
        while (i < this.nConnected) {
            if (this.connected[i] == toMe) {
                return;
            }
            ++i;
        }
        this.connected[this.nConnected] = toMe;
        ++this.nConnected;
    }

    void removeConnection(PolyNode fromMe) {
        boolean isFound = false;
        int foundIndex = -1;
        int i = 0;
        while (i < this.nConnected) {
            if (fromMe == this.connected[i]) {
                isFound = true;
                foundIndex = i;
                break;
            }
            ++i;
        }
        assert (isFound);
        --this.nConnected;
        i = foundIndex;
        while (i < this.nConnected) {
            this.connected[i] = this.connected[i + 1];
            ++i;
        }
    }

    void removeConnectionByIndex(int index) {
        --this.nConnected;
        int i = index;
        while (i < this.nConnected) {
            this.connected[i] = this.connected[i + 1];
            ++i;
        }
    }

    boolean isConnectedTo(PolyNode me) {
        boolean isFound = false;
        int i = 0;
        while (i < this.nConnected) {
            if (me == this.connected[i]) {
                isFound = true;
                break;
            }
            ++i;
        }
        return isFound;
    }

    PolyNode getRightestConnection(PolyNode incoming) {
        if (this.nConnected == 0) {
            assert (false);
            return null;
        }
        if (this.nConnected == 1) {
            return incoming;
        }
        Vec2 inDir = this.position.sub(incoming.position);
        float inLength = inDir.normalize();
        assert (inLength > 1.1920929E-7f);
        PolyNode result = null;
        int i = 0;
        while (i < this.nConnected) {
            if (this.connected[i] != incoming) {
                Vec2 testDir = this.connected[i].position.sub(this.position);
                float testLengthSqr = testDir.lengthSquared();
                testDir.normalize();
                assert (testLengthSqr >= 1.4210855E-14f);
                float myCos = Vec2.dot(inDir, testDir);
                float mySin = Vec2.cross(inDir, testDir);
                if (result != null) {
                    Vec2 resultDir = result.position.sub(this.position);
                    resultDir.normalize();
                    float resCos = Vec2.dot(inDir, resultDir);
                    float resSin = Vec2.cross(inDir, resultDir);
                    if (Polygon.isRighter(mySin, myCos, resSin, resCos)) {
                        result = this.connected[i];
                    }
                } else {
                    result = this.connected[i];
                }
            }
            ++i;
        }
        assert (result != null);
        return result;
    }

    PolyNode getRightestConnection(Vec2 incomingDir) {
        Vec2 diff = this.position.sub(incomingDir);
        PolyNode temp = new PolyNode(diff);
        PolyNode res = this.getRightestConnection(temp);
        assert (res != null);
        return res;
    }
}

