/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.blob;

import org.jbox2d.collision.AABB;
import org.jbox2d.common.Vec2;
import org.jbox2d.util.blob.BlobContainer;

public class DonutBlobContainer
implements BlobContainer {
    private float centerX;
    private float centerY;
    private float radiusLarge;
    private float radiusSmallSqr;
    private float radiusLargeSqr;

    public DonutBlobContainer(Vec2 _center, float _radiusSmall, float _radiusLarge) {
        this.centerX = _center.x;
        this.centerY = _center.y;
        this.radiusLarge = _radiusLarge;
        this.radiusSmallSqr = _radiusSmall * _radiusSmall;
        this.radiusLargeSqr = _radiusLarge * _radiusLarge;
    }

    @Override
    public boolean containsPoint(Vec2 p) {
        float distSqr = (p.x - this.centerX) * (p.x - this.centerX) + (p.y - this.centerY) * (p.y - this.centerY);
        if (distSqr > this.radiusLargeSqr) {
            return false;
        }
        return !(distSqr < this.radiusSmallSqr);
    }

    @Override
    public AABB getAABB() {
        Vec2 min = new Vec2(this.centerX - 1.2f * this.radiusLarge, this.centerY - 1.2f * this.radiusLarge);
        Vec2 max = new Vec2(this.centerX + 1.2f * this.radiusLarge, this.centerY + 1.2f * this.radiusLarge);
        return new AABB(min, max);
    }
}

