/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.p5;

import def.processing.core.PApplet;
import java.lang.reflect.Method;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.CircleDef;
import org.jbox2d.collision.shapes.PolygonDef;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.p5.JointUtils;
import org.jbox2d.testbed.ProcessingDebugDraw;
import org.jbox2d.testbed.TestSettings;

public class Physics {
    private World m_world;
    private PApplet m_parent;
    private ProcessingDebugDraw m_draw;
    private Vec2 m_gravity;
    public AABB m_worldAABB;
    private TestSettings m_settings;
    private Body[] m_border;
    private float m_density;
    private float m_restitution;
    private float m_friction;
    private boolean m_bullet;
    private boolean m_sensor;
    private Method m_customRenderingMethod;
    private Object m_customRenderingObject;

    public Physics(PApplet parent, float screenW, float screenH) {
        this(parent, screenW, screenH, 0.0f, -10.0f, 2.0f * screenW, 2.0f * screenH, screenW, screenH, 10.0f);
    }

    public Physics(PApplet parent, float screenW, float screenH, float gravX, float gravY, float screenAABBWidth, float screenAABBHeight, float borderBoxWidth, float borderBoxHeight, float pixelsPerMeter) {
        this.m_parent = parent;
        this.m_draw = new ProcessingDebugDraw(this.m_parent);
        this.m_gravity = new Vec2(gravX, gravY);
        this.m_draw.setCamera(0.0f, 0.0f, pixelsPerMeter);
        Vec2 minWorldAABB = new Vec2(-screenAABBWidth * 0.5f / pixelsPerMeter, -screenAABBHeight * 0.5f / pixelsPerMeter);
        Vec2 maxWorldAABB = minWorldAABB.mul(-1.0f);
        boolean doSleep = true;
        this.m_world = new World(new AABB(minWorldAABB, maxWorldAABB), this.m_gravity, doSleep);
        this.m_world.setDebugDraw(this.m_draw);
        this.m_world.setDrawDebugData(false);
        this.m_settings = new TestSettings();
        this.setDensity(0.0f);
        this.setRestitution(0.1f);
        this.setFriction(0.4f);
        this.setBullet(false);
        this.setSensor(false);
        this.m_border = this.createHollowBox(screenW * 0.5f, screenH * 0.5f, borderBoxWidth, borderBoxHeight, 10.0f);
        parent.registerMethod("draw", (Object)this);
    }

    public void draw() {
        this.m_world.setWarmStarting(this.m_settings.enableWarmStarting);
        this.m_world.setPositionCorrection(this.m_settings.enablePositionCorrection);
        this.m_world.setContinuousPhysics(this.m_settings.enableTOI);
        this.m_world.step(1.0f / (float)this.m_settings.hz, this.m_settings.iterationCount);
        if (this.m_customRenderingMethod == null) {
            this.defaultDraw(this.m_world);
        } else {
            try {
                this.m_customRenderingMethod.invoke(this.m_customRenderingObject, this.m_world);
            }
            catch (Exception e) {
                System.err.println("error " + e);
                e.printStackTrace();
                this.m_parent.exit();
            }
        }
    }

    public void setCustomRenderingMethod(Object object, String methodName) {
        Class<?> c = object.getClass();
        try {
            Class[] methodArgs = new Class[]{World.class};
            Method method = c.getMethod(methodName, methodArgs);
            this.m_customRenderingObject = object;
            this.m_customRenderingMethod = method;
        }
        catch (Exception e) {
            System.err.println("Could not register " + methodName + "(World) for " + object + ", make sure the method name is spelled correctly and that the method " + "takes a World object as an argument!" + e);
            e.printStackTrace();
        }
    }

    public void unsetCustomRenderingMethod() {
        this.m_customRenderingMethod = null;
        this.m_customRenderingObject = null;
    }

    public void defaultDraw(World world) {
        this.m_draw.setFlags(0);
        if (this.m_settings.drawShapes) {
            this.m_draw.appendFlags(1);
        }
        if (this.m_settings.drawJoints) {
            this.m_draw.appendFlags(2);
        }
        if (this.m_settings.drawCoreShapes) {
            this.m_draw.appendFlags(4);
        }
        if (this.m_settings.drawAABBs) {
            this.m_draw.appendFlags(8);
        }
        if (this.m_settings.drawOBBs) {
            this.m_draw.appendFlags(16);
        }
        if (this.m_settings.drawPairs) {
            this.m_draw.appendFlags(32);
        }
        if (this.m_settings.drawCOMs) {
            this.m_draw.appendFlags(64);
        }
        world.setDrawDebugData(true);
        world.drawDebugData();
        world.setDrawDebugData(false);
    }

    public TestSettings getSettings() {
        return this.m_settings;
    }

    public Body[] createHollowBox(float centerX, float centerY, float width, float height, float thickness) {
        Body[] result = new Body[]{this.createRect(centerX - width * 0.5f - thickness * 0.5f, centerY - height * 0.5f - thickness * 0.5f, centerX - width * 0.5f + thickness * 0.5f, centerY + height * 0.5f + thickness * 0.5f), this.createRect(centerX + width * 0.5f - thickness * 0.5f, centerY - height * 0.5f - thickness * 0.5f, centerX + width * 0.5f + thickness * 0.5f, centerY + height * 0.5f + thickness * 0.5f), this.createRect(centerX - width * 0.5f - thickness * 0.5f, centerY + height * 0.5f - thickness * 0.5f, centerX + width * 0.5f + thickness * 0.5f, centerY + height * 0.5f + thickness * 0.5f), this.createRect(centerX - width * 0.5f - thickness * 0.5f, centerY - height * 0.5f - thickness * 0.5f, centerX + width * 0.5f + thickness * 0.5f, centerY - height * 0.5f + thickness * 0.5f)};
        return result;
    }

    public Body createRect(float x0, float y0, float x1, float y1) {
        float cxs = (x0 + x1) * 0.5f;
        float cys = (y0 + y1) * 0.5f;
        float wxs = MathUtils.abs(x1 - x0);
        float wys = MathUtils.abs(y1 - y0);
        Vec2 center = this.screenToWorld(cxs, cys);
        float halfWidthWorld = 0.5f * this.screenToWorld(wxs, new Vec2(1.0f, 0.0f));
        float halfHeightWorld = 0.5f * this.screenToWorld(wys, new Vec2(1.0f, 0.0f));
        PolygonDef pd = new PolygonDef();
        pd.setAsBox(halfWidthWorld, halfHeightWorld);
        this.setShapeDefProperties(pd);
        BodyDef bd = new BodyDef();
        this.setBodyDefProperties(bd);
        Body b = this.m_world.createBody(bd);
        b.createShape(pd);
        if (this.m_density > 0.0f) {
            b.setMassFromShapes();
        }
        b.setXForm(center, 0.0f);
        return b;
    }

    public Body createCircle(float x, float y, float r) {
        Vec2 center = this.screenToWorld(x, y);
        float rad = this.screenToWorld(r, new Vec2(1.0f, 0.0f));
        CircleDef cd = new CircleDef();
        cd.radius = rad;
        this.setShapeDefProperties(cd);
        BodyDef bd = new BodyDef();
        this.setBodyDefProperties(bd);
        Body b = this.m_world.createBody(bd);
        b.createShape(cd);
        if (this.m_density > 0.0f) {
            b.setMassFromShapes();
        }
        b.setXForm(center, 0.0f);
        return b;
    }

    public Body createPolygon(float ... vertices) {
        if (vertices.length % 2 != 0) {
            throw new IllegalArgumentException("Vertices must be given as pairs of x,y coordinates, but number of passed parameters was odd.");
        }
        int nVertices = vertices.length / 2;
        PolygonDef pd = new PolygonDef();
        int i = 0;
        while (i < nVertices) {
            Vec2 v = this.screenToWorld(vertices[2 * i], vertices[2 * i + 1]);
            pd.addVertex(v);
            ++i;
        }
        this.setShapeDefProperties(pd);
        BodyDef bd = new BodyDef();
        this.setBodyDefProperties(bd);
        Body b = this.m_world.createBody(bd);
        b.createShape(pd);
        if (this.m_density > 0.0f) {
            b.setMassFromShapes();
        }
        return b;
    }

    public DistanceJoint createDistanceJoint(Body a, Body b, float xa, float ya, float xb, float yb) {
        Vec2 va = this.screenToWorld(xa, ya);
        Vec2 vb = this.screenToWorld(xb, yb);
        DistanceJointDef jd = new DistanceJointDef();
        jd.initialize(a, b, va, vb);
        return (DistanceJoint)this.m_world.createJoint(jd);
    }

    public RevoluteJoint createRevoluteJoint(Body a, Body b, float x, float y) {
        Vec2 v = this.screenToWorld(x, y);
        return JointUtils.createRevoluteJoint(a, b, v);
    }

    public PrismaticJoint createPrismaticJoint(Body a, Body b, float dirX, float dirY) {
        Vec2 dir = new Vec2(dirX, dirY);
        dir.normalize();
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(a, b, a.getMemberWorldCenter().add(b.getMemberWorldCenter()).mul(0.5f), dir);
        return (PrismaticJoint)this.m_world.createJoint(pjd);
    }

    public PulleyJoint createPulleyJoint(Body a, Body b, float groundAnchorAx, float groundAnchorAy, float groundAnchorBx, float groundAnchorBy, float anchorAx, float anchorAy, float anchorBx, float anchorBy, float ratio) {
        Vec2 gA = this.screenToWorld(groundAnchorAx, groundAnchorAy);
        Vec2 gB = this.screenToWorld(groundAnchorBx, groundAnchorBy);
        Vec2 aA = this.screenToWorld(anchorAx, anchorAy);
        Vec2 aB = this.screenToWorld(anchorBx, anchorBy);
        PulleyJointDef pjd = new PulleyJointDef();
        pjd.initialize(a, b, gA, gB, aA, aB, ratio);
        return (PulleyJoint)this.m_world.createJoint(pjd);
    }

    public GearJoint createGearJoint(Joint pj1, Joint pj2, float ratio) {
        if (pj1.getType() != JointType.REVOLUTE_JOINT && pj1.getType() != JointType.PRISMATIC_JOINT) {
            throw new IllegalArgumentException("Gear joints can only be created between combinations of revolute and prismatic joints.");
        }
        if (pj1.getType() != JointType.REVOLUTE_JOINT && pj1.getType() != JointType.PRISMATIC_JOINT) {
            throw new IllegalArgumentException("Gear joints can only be created between combinations of revolute and prismatic joints.");
        }
        GearJointDef gjd = new GearJointDef();
        gjd.joint1 = pj1;
        gjd.joint2 = pj2;
        gjd.ratio = ratio;
        return (GearJoint)this.m_world.createJoint(gjd);
    }

    private void setBodyDefProperties(BodyDef bd) {
        bd.isBullet = this.m_bullet;
    }

    private void setShapeDefProperties(ShapeDef sd) {
        sd.density = this.m_density;
        sd.friction = this.m_friction;
        sd.restitution = this.m_restitution;
        sd.isSensor = this.m_sensor;
    }

    public void setDensity(float d) {
        this.m_density = d;
    }

    public float getDensity() {
        return this.m_density;
    }

    public void setRestitution(float r) {
        this.m_restitution = r;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void setFriction(float f) {
        this.m_friction = f;
    }

    public float getFriction() {
        return this.m_friction;
    }

    public IViewportTransform getViewportTransform() {
        return this.m_draw.getViewportTranform();
    }

    public void setBullet(boolean bullet) {
        this.m_bullet = bullet;
    }

    public boolean getBullet() {
        return this.m_bullet;
    }

    public void setSensor(boolean sensor) {
        this.m_sensor = sensor;
    }

    public boolean getSensor() {
        return this.m_sensor;
    }

    public void destroy() {
        this.m_parent.unregisterMethod("draw", (Object)this);
    }

    public World getWorld() {
        return this.m_world;
    }

    public Body[] getBorder() {
        return this.m_border;
    }

    public void removeBorder() {
        if (this.m_border == null) {
            return;
        }
        int i = 0;
        while (i < this.m_border.length) {
            this.removeBody(this.m_border[i]);
            ++i;
        }
        this.m_border = null;
    }

    public void removeBody(Body b) {
        this.m_world.destroyBody(b);
    }

    public void removeJoint(Joint j) {
        this.m_world.destroyJoint(j);
    }

    public void applyForce(Body b, float fx, float fy) {
        Vec2 fv = this.screenToWorldVector(fx, fy);
        b.applyForce(fv, b.getMemberWorldCenter());
    }

    public void applyForce(Body b, Vec2 f) {
        b.applyForce(this.screenToWorldVector(f), b.getMemberWorldCenter());
    }

    public void applyForce(Body b, float fx, float fy, float pointX, float pointY) {
        Vec2 fv = this.screenToWorldVector(fx, fy);
        Vec2 point = this.screenToWorld(pointX, pointY);
        b.applyForce(fv, point);
    }

    public void applyForce(Body b, Vec2 f, Vec2 point) {
        b.applyForce(this.screenToWorldVector(f), this.screenToWorld(point));
    }

    public Vec2 getPosition(Body b) {
        return this.worldToScreen(b.getMemberPosition());
    }

    public Vec2 getCMPosition(Body b) {
        return this.worldToScreen(b.getMemberWorldCenter());
    }

    public float getAngle(Body b) {
        return b.getAngle();
    }

    public float screenToWorldX(float x, float y) {
        return this.m_draw.getScreenToWorld((float)x, (float)y).x;
    }

    public float screenToWorldY(float x, float y) {
        return this.m_draw.getScreenToWorld((float)x, (float)y).y;
    }

    public Vec2 screenToWorld(float x, float y) {
        return this.m_draw.getScreenToWorld(x, y);
    }

    public Vec2 screenToWorld(Vec2 v) {
        return this.m_draw.getScreenToWorld(v);
    }

    public float screenToWorld(float length, Vec2 vector) {
        Vec2 ret = new Vec2(vector);
        ret.normalize();
        ret.mulLocal(length);
        this.m_draw.getViewportTranform().vectorInverseTransform(ret, ret);
        return ret.length();
    }

    public float worldToScreenX(float x, float y) {
        return this.m_draw.getWorldToScreen((float)x, (float)y).x;
    }

    public float worldToScreenY(float x, float y) {
        return this.m_draw.getWorldToScreen((float)x, (float)y).y;
    }

    public Vec2 worldToScreen(float x, float y) {
        return this.m_draw.getWorldToScreen(x, y);
    }

    public Vec2 worldToScreen(Vec2 v) {
        return this.m_draw.getWorldToScreen(v);
    }

    public float worldToScreen(float length, Vec2 vector) {
        Vec2 ret = new Vec2(vector);
        ret.normalize();
        ret.mulLocal(length);
        this.m_draw.getViewportTranform().vectorTransform(ret, ret);
        return ret.length();
    }

    public Vec2 screenToWorldVector(Vec2 screenV) {
        Vec2 ret = new Vec2();
        this.m_draw.getViewportTranform().vectorInverseTransform(screenV, ret);
        if (this.m_draw.getViewportTranform().isYFlip()) {
            ret.y *= -1.0f;
        }
        return ret;
    }

    public Vec2 screenToWorldVector(float sx, float sy) {
        Vec2 ret = new Vec2(sx, sy);
        this.m_draw.getViewportTranform().vectorInverseTransform(ret, ret);
        if (this.m_draw.getViewportTranform().isYFlip()) {
            ret.y *= -1.0f;
        }
        return ret;
    }

    public Vec2 worldToScreenVector(Vec2 worldV) {
        Vec2 ret = new Vec2();
        this.m_draw.getViewportTranform().vectorTransform(worldV, ret);
        if (this.m_draw.getViewportTranform().isYFlip()) {
            ret.y *= -1.0f;
        }
        return ret;
    }

    public Vec2 worldToScreenVector(float wx, float wy) {
        Vec2 ret = new Vec2(wx, wy);
        this.m_draw.getViewportTranform().vectorTransform(ret, ret);
        if (this.m_draw.getViewportTranform().isYFlip()) {
            ret.y *= -1.0f;
        }
        return ret;
    }
}

