/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class PrismaticJointDef
extends JointDef {
    public Vec2 localAnchor1;
    public Vec2 localAnchor2;
    public Vec2 localAxis1;
    public float referenceAngle;
    public boolean enableLimit;
    public float lowerTranslation;
    public float upperTranslation;
    public boolean enableMotor;
    public float maxMotorForce;
    public float motorSpeed;

    public PrismaticJointDef() {
        this.type = JointType.PRISMATIC_JOINT;
        this.localAnchor1 = new Vec2();
        this.localAnchor2 = new Vec2();
        this.localAxis1 = new Vec2();
        this.referenceAngle = 0.0f;
        this.enableLimit = false;
        this.lowerTranslation = 0.0f;
        this.upperTranslation = 0.0f;
        this.enableMotor = false;
        this.maxMotorForce = 0.0f;
        this.motorSpeed = 0.0f;
    }

    public void initialize(Body b1, Body b2, Vec2 anchor, Vec2 axis) {
        this.body1 = b1;
        this.body2 = b2;
        this.body1.getLocalPointToOut(anchor, this.localAnchor1);
        this.body2.getLocalPointToOut(anchor, this.localAnchor2);
        this.body1.getLocalVectorToOut(axis, this.localAxis1);
        this.referenceAngle = this.body2.getAngle() - this.body1.getAngle();
    }
}

