/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Jacobian;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.pooling.TLVec2;

public class PrismaticJoint
extends Joint {
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_localXAxis1;
    public final Vec2 m_localYAxis1;
    public float m_refAngle;
    public Jacobian m_linearJacobian;
    public float m_linearMass;
    public float m_force;
    public float m_angularMass;
    public float m_torque;
    public Jacobian m_motorJacobian;
    public float m_motorMass;
    public float m_motorForce;
    public float m_limitForce;
    public float m_limitPositionImpulse;
    public float m_lowerTranslation;
    public float m_upperTranslation;
    public float m_maxMotorForce;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public boolean m_enableMotor;
    public LimitState m_limitState;
    private static final TLVec2 tlr1 = new TLVec2();
    private static final TLVec2 tlr2 = new TLVec2();
    private static final TLVec2 tlax1 = new TLVec2();
    private static final TLVec2 tlay1 = new TLVec2();
    private static final TLVec2 tle = new TLVec2();
    private static final TLVec2 tlax1Neg = new TLVec2();
    private static final TLVec2 tlay1Neg = new TLVec2();
    private static final TLVec2 tld = new TLVec2();
    private float m_lastWarmStartingForce;
    private float m_lastWarmStartingTorque;
    private static final TLVec2 tltemp = new TLVec2();
    private static final TLVec2 tlp1 = new TLVec2();
    private static final TLVec2 tlp2 = new TLVec2();
    private static final TLVec2 tlr1z = new TLVec2();
    private static final TLVec2 tlr2z = new TLVec2();
    private static final TLVec2 tlp1z = new TLVec2();
    private static final TLVec2 tlp2z = new TLVec2();
    private static final TLVec2 tldz = new TLVec2();
    public static final TLVec2 tlaxis = new TLVec2();
    private static final TLVec2 tlw1xAxis = new TLVec2();
    private static final TLVec2 tlv22 = new TLVec2();
    private static final TLVec2 tlw2xR2 = new TLVec2();
    private static final TLVec2 tlw1xR1 = new TLVec2();
    private static final TLVec2 tlreactionAx1 = new TLVec2();

    public PrismaticJoint(PrismaticJointDef def) {
        super(def);
        this.m_localAnchor1 = def.localAnchor1.clone();
        this.m_localAnchor2 = def.localAnchor2.clone();
        this.m_localXAxis1 = def.localAxis1.clone();
        this.m_localYAxis1 = Vec2.cross(1.0f, this.m_localXAxis1);
        this.m_refAngle = def.referenceAngle;
        this.m_linearJacobian = new Jacobian();
        this.m_linearMass = 0.0f;
        this.m_force = 0.0f;
        this.m_angularMass = 0.0f;
        this.m_torque = 0.0f;
        this.m_motorJacobian = new Jacobian();
        this.m_motorMass = 0.0f;
        this.m_motorForce = 0.0f;
        this.m_limitForce = 0.0f;
        this.m_limitPositionImpulse = 0.0f;
        this.m_lowerTranslation = def.lowerTranslation;
        this.m_upperTranslation = def.upperTranslation;
        this.m_maxMotorForce = def.maxMotorForce;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 ax1 = (Vec2)tlax1.get();
        Vec2 ay1 = (Vec2)tlay1.get();
        Vec2 e = (Vec2)tle.get();
        Vec2 ax1Neg = (Vec2)tlax1Neg.get();
        Vec2 ay1Neg = (Vec2)tlay1Neg.get();
        Vec2 d = (Vec2)tld.get();
        Mat22.mulToOut(b1.m_xf.R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
        Mat22.mulToOut(b2.m_xf.R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        Mat22.mulToOut(b1.m_xf.R, this.m_localYAxis1, ay1);
        e.set(b2.m_sweep.c);
        e.addLocal(r2).subLocal(b1.m_sweep.c);
        Vec2.negateToOut(ay1, ay1Neg);
        this.m_linearJacobian.set(ay1Neg, -Vec2.cross(e, ay1), ay1, Vec2.cross(r2, ay1));
        this.m_linearMass = invMass1 + invI1 * this.m_linearJacobian.angular1 * this.m_linearJacobian.angular1 + invMass2 + invI2 * this.m_linearJacobian.angular2 * this.m_linearJacobian.angular2;
        assert (this.m_linearMass > 1.1920929E-7f);
        this.m_linearMass = 1.0f / this.m_linearMass;
        this.m_angularMass = invI1 + invI2;
        if (this.m_angularMass > 1.1920929E-7f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        if (this.m_enableLimit || this.m_enableMotor) {
            Mat22.mulToOut(b1.m_xf.R, this.m_localXAxis1, ax1);
            Vec2.negateToOut(ax1, ax1Neg);
            this.m_motorJacobian.set(ax1Neg, -Vec2.cross(e, ax1), ax1, Vec2.cross(r2, ax1));
            this.m_motorMass = invMass1 + invI1 * this.m_motorJacobian.angular1 * this.m_motorJacobian.angular1 + invMass2 + invI2 * this.m_motorJacobian.angular2 * this.m_motorJacobian.angular2;
            assert (this.m_motorMass > 1.1920929E-7f);
            this.m_motorMass = 1.0f / this.m_motorMass;
            if (this.m_enableLimit) {
                d.set(e);
                d.subLocal(r1);
                float jointTranslation = Vec2.dot(ax1, d);
                if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 0.01f) {
                    this.m_limitState = LimitState.EQUAL_LIMITS;
                } else if (jointTranslation <= this.m_lowerTranslation) {
                    if (this.m_limitState != LimitState.AT_LOWER_LIMIT) {
                        this.m_limitForce = 0.0f;
                    }
                    this.m_limitState = LimitState.AT_LOWER_LIMIT;
                } else if (jointTranslation >= this.m_upperTranslation) {
                    if (this.m_limitState != LimitState.AT_UPPER_LIMIT) {
                        this.m_limitForce = 0.0f;
                    }
                    this.m_limitState = LimitState.AT_UPPER_LIMIT;
                } else {
                    this.m_limitState = LimitState.INACTIVE_LIMIT;
                    this.m_limitForce = 0.0f;
                }
            }
        }
        if (!this.m_enableMotor) {
            this.m_motorForce = 0.0f;
        }
        if (!this.m_enableLimit) {
            this.m_limitForce = 0.0f;
        }
        if (step.warmStarting) {
            float L1 = step.dt * (this.m_force * this.m_linearJacobian.angular1 - this.m_torque + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.angular1);
            float L2 = step.dt * (this.m_force * this.m_linearJacobian.angular2 + this.m_torque + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.angular2);
            b1.m_linearVelocity.x += invMass1 * step.dt * (this.m_force * this.m_linearJacobian.linear1.x + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear1.x);
            b1.m_linearVelocity.y += invMass1 * step.dt * (this.m_force * this.m_linearJacobian.linear1.y + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear1.y);
            b1.m_angularVelocity += invI1 * L1;
            b2.m_linearVelocity.x += invMass2 * step.dt * (this.m_force * this.m_linearJacobian.linear2.x + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear2.x);
            b2.m_linearVelocity.y += invMass2 * step.dt * (this.m_force * this.m_linearJacobian.linear2.y + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear2.y);
            b2.m_angularVelocity += invI2 * L2;
        } else {
            this.m_force = 0.0f;
            this.m_torque = 0.0f;
            this.m_limitForce = 0.0f;
            this.m_motorForce = 0.0f;
        }
        this.m_limitPositionImpulse = 0.0f;
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        float linearCdot = this.m_linearJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
        float force = -step.inv_dt * this.m_linearMass * linearCdot;
        if (step.warmStarting) {
            this.m_force += force;
            this.m_lastWarmStartingForce = this.m_force;
        } else {
            this.m_force = this.m_lastWarmStartingForce;
        }
        float P = step.dt * force;
        b1.m_linearVelocity.x += invMass1 * P * this.m_linearJacobian.linear1.x;
        b1.m_linearVelocity.y += invMass1 * P * this.m_linearJacobian.linear1.y;
        b1.m_angularVelocity += invI1 * P * this.m_linearJacobian.angular1;
        b2.m_linearVelocity.x += invMass2 * P * this.m_linearJacobian.linear2.x;
        b2.m_linearVelocity.y += invMass2 * P * this.m_linearJacobian.linear2.y;
        b2.m_angularVelocity += invI2 * P * this.m_linearJacobian.angular2;
        float angularCdot = b2.m_angularVelocity - b1.m_angularVelocity;
        float torque = -step.inv_dt * this.m_angularMass * angularCdot;
        this.m_torque += torque;
        if (step.warmStarting) {
            this.m_torque += torque;
            this.m_lastWarmStartingTorque = this.m_torque;
        } else {
            this.m_torque = this.m_lastWarmStartingTorque;
        }
        float L = step.dt * torque;
        b1.m_angularVelocity -= invI1 * L;
        b2.m_angularVelocity += invI2 * L;
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL_LIMITS) {
            float motorCdot = this.m_motorJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity) - this.m_motorSpeed;
            float motorForce = -step.inv_dt * this.m_motorMass * motorCdot;
            float oldMotorForce = this.m_motorForce;
            this.m_motorForce = MathUtils.clamp(this.m_motorForce + motorForce, -this.m_maxMotorForce, this.m_maxMotorForce);
            motorForce = this.m_motorForce - oldMotorForce;
            float P2 = step.dt * motorForce;
            b1.m_linearVelocity.x += invMass1 * P2 * this.m_motorJacobian.linear1.x;
            b1.m_linearVelocity.y += invMass1 * P2 * this.m_motorJacobian.linear1.y;
            b1.m_angularVelocity += invI1 * P2 * this.m_motorJacobian.angular1;
            b2.m_linearVelocity.x += invMass2 * P2 * this.m_motorJacobian.linear2.x;
            b2.m_linearVelocity.y += invMass2 * P2 * this.m_motorJacobian.linear2.y;
            b2.m_angularVelocity += invI2 * P2 * this.m_motorJacobian.angular2;
        }
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE_LIMIT) {
            float oldLimitForce;
            float limitCdot = this.m_motorJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
            float limitForce = -step.inv_dt * this.m_motorMass * limitCdot;
            if (this.m_limitState == LimitState.EQUAL_LIMITS) {
                this.m_limitForce += limitForce;
            } else if (this.m_limitState == LimitState.AT_LOWER_LIMIT) {
                oldLimitForce = this.m_limitForce;
                this.m_limitForce = MathUtils.max(this.m_limitForce + limitForce, 0.0f);
                limitForce = this.m_limitForce - oldLimitForce;
            } else if (this.m_limitState == LimitState.AT_UPPER_LIMIT) {
                oldLimitForce = this.m_limitForce;
                this.m_limitForce = MathUtils.min(this.m_limitForce + limitForce, 0.0f);
                limitForce = this.m_limitForce - oldLimitForce;
            }
            float P2 = step.dt * limitForce;
            b1.m_linearVelocity.x += invMass1 * P2 * this.m_motorJacobian.linear1.x;
            b1.m_linearVelocity.y += invMass1 * P2 * this.m_motorJacobian.linear1.y;
            b1.m_angularVelocity += invI1 * P2 * this.m_motorJacobian.angular1;
            b2.m_linearVelocity.x += invMass2 * P2 * this.m_motorJacobian.linear2.x;
            b2.m_linearVelocity.y += invMass2 * P2 * this.m_motorJacobian.linear2.y;
            b2.m_angularVelocity += invI2 * P2 * this.m_motorJacobian.angular2;
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 temp = (Vec2)tltemp.get();
        Vec2 p1 = (Vec2)tlp1.get();
        Vec2 p2 = (Vec2)tlp2.get();
        Vec2 r1z = (Vec2)tlr1z.get();
        Vec2 r2z = (Vec2)tlr2z.get();
        Vec2 p1z = (Vec2)tlp1z.get();
        Vec2 p2z = (Vec2)tlp2z.get();
        Vec2 dz = (Vec2)tldz.get();
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 d = (Vec2)tld.get();
        Vec2 ax1 = (Vec2)tlax1.get();
        Vec2 ay1 = (Vec2)tlay1.get();
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        temp.set(this.m_localAnchor1);
        temp.subLocal(b1.getMemberLocalCenter());
        Mat22.mulToOut(b1.m_xf.R, temp, r1);
        temp.set(this.m_localAnchor2);
        temp.subLocal(b2.getMemberLocalCenter());
        Mat22.mulToOut(b2.m_xf.R, temp, r2);
        p1.set(b1.m_sweep.c);
        p1.addLocal(r1);
        p2.set(b2.m_sweep.c);
        p2.addLocal(r2);
        d.set(p2);
        d.subLocal(p1);
        Mat22.mulToOut(b1.m_xf.R, this.m_localYAxis1, ay1);
        float linearC = Vec2.dot(ay1, d);
        linearC = MathUtils.clamp(linearC, -0.2f, 0.2f);
        float linearImpulse = -this.m_linearMass * linearC;
        b1.m_sweep.c.x += invMass1 * linearImpulse * this.m_linearJacobian.linear1.x;
        b1.m_sweep.c.y += invMass1 * linearImpulse * this.m_linearJacobian.linear1.y;
        b1.m_sweep.a += invI1 * linearImpulse * this.m_linearJacobian.angular1;
        b2.m_sweep.c.x += invMass2 * linearImpulse * this.m_linearJacobian.linear2.x;
        b2.m_sweep.c.y += invMass2 * linearImpulse * this.m_linearJacobian.linear2.y;
        b2.m_sweep.a += invI2 * linearImpulse * this.m_linearJacobian.angular2;
        float positionError = MathUtils.abs(linearC);
        float angularC = b2.m_sweep.a - b1.m_sweep.a - this.m_refAngle;
        angularC = MathUtils.clamp(angularC, -0.13962635f, 0.13962635f);
        float angularImpulse = -this.m_angularMass * angularC;
        b1.m_sweep.a -= b1.m_invI * angularImpulse;
        b2.m_sweep.a += b2.m_invI * angularImpulse;
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        float angularError = MathUtils.abs(angularC);
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE_LIMIT) {
            temp.set(this.m_localAnchor1);
            temp.subLocal(b1.getMemberLocalCenter());
            Mat22.mulToOut(b1.m_xf.R, temp, r1z);
            temp.set(this.m_localAnchor2);
            temp.subLocal(b2.getMemberLocalCenter());
            Mat22.mulToOut(b2.m_xf.R, temp, r2z);
            p1z.set(b1.m_sweep.c);
            p1z.addLocal(r1z);
            p2z.set(b2.m_sweep.c);
            p2z.addLocal(r2z);
            dz.set(p2z);
            dz.subLocal(p1z);
            Mat22.mulToOut(b1.m_xf.R, this.m_localXAxis1, ax1);
            float translation = Vec2.dot(ax1, dz);
            float limitImpulse = 0.0f;
            if (this.m_limitState == LimitState.EQUAL_LIMITS) {
                float limitC = MathUtils.clamp(translation, -0.2f, 0.2f);
                limitImpulse = -this.m_motorMass * limitC;
                positionError = MathUtils.max(positionError, MathUtils.abs(angularC));
            } else if (this.m_limitState == LimitState.AT_LOWER_LIMIT) {
                float limitC = translation - this.m_lowerTranslation;
                positionError = MathUtils.max(positionError, -limitC);
                limitC = MathUtils.clamp(limitC + 0.005f, -0.2f, 0.0f);
                limitImpulse = -this.m_motorMass * limitC;
                float oldLimitImpulse = this.m_limitPositionImpulse;
                this.m_limitPositionImpulse = MathUtils.max(this.m_limitPositionImpulse + limitImpulse, 0.0f);
                limitImpulse = this.m_limitPositionImpulse - oldLimitImpulse;
            } else if (this.m_limitState == LimitState.AT_UPPER_LIMIT) {
                float limitC = translation - this.m_upperTranslation;
                positionError = MathUtils.max(positionError, limitC);
                limitC = MathUtils.clamp(limitC - 0.005f, 0.0f, 0.2f);
                limitImpulse = -this.m_motorMass * limitC;
                float oldLimitImpulse = this.m_limitPositionImpulse;
                this.m_limitPositionImpulse = MathUtils.min(this.m_limitPositionImpulse + limitImpulse, 0.0f);
                limitImpulse = this.m_limitPositionImpulse - oldLimitImpulse;
            }
            b1.m_sweep.c.x += invMass1 * limitImpulse * this.m_motorJacobian.linear1.x;
            b1.m_sweep.c.y += invMass1 * limitImpulse * this.m_motorJacobian.linear1.y;
            b1.m_sweep.a += invI1 * limitImpulse * this.m_motorJacobian.angular1;
            b2.m_sweep.c.x += invMass2 * limitImpulse * this.m_motorJacobian.linear2.x;
            b2.m_sweep.c.y += invMass2 * limitImpulse * this.m_motorJacobian.linear2.y;
            b2.m_sweep.a += invI2 * limitImpulse * this.m_motorJacobian.angular2;
            b1.synchronizeTransform();
            b2.synchronizeTransform();
        }
        return positionError <= 0.005f && angularError <= 0.03490659f;
    }

    @Override
    public Vec2 getAnchor1() {
        return this.m_body1.getWorldLocation(this.m_localAnchor1);
    }

    public void getAnchor1ToOut(Vec2 out) {
        this.m_body1.getWorldLocationToOut(this.m_localAnchor1, out);
    }

    @Override
    public Vec2 getAnchor2() {
        return this.m_body2.getWorldLocation(this.m_localAnchor2);
    }

    public void getAnchor2ToOut(Vec2 out) {
        this.m_body2.getWorldLocationToOut(this.m_localAnchor2, out);
    }

    public float getJointTranslation() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 axis = (Vec2)tlaxis.get();
        Vec2 p1 = (Vec2)tlp1.get();
        Vec2 p2 = (Vec2)tlp2.get();
        Vec2 d = (Vec2)tld.get();
        b1.getWorldLocationToOut(this.m_localAnchor1, p1);
        b2.getWorldLocationToOut(this.m_localAnchor2, p2);
        d.set(p2);
        d.subLocal(p1);
        b1.getWorldDirectionToOut(this.m_localXAxis1, axis);
        float translation = Vec2.dot(d, axis);
        return translation;
    }

    public float getJointSpeed() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 p1 = (Vec2)tlp1.get();
        Vec2 p2 = (Vec2)tlp2.get();
        Vec2 d = (Vec2)tld.get();
        Vec2 axis = (Vec2)tlaxis.get();
        Vec2 w1xAxis = (Vec2)tlw1xAxis.get();
        Vec2 v22 = (Vec2)tlv22.get();
        Vec2 w2xR2 = (Vec2)tlw2xR2.get();
        Vec2 w1xR1 = (Vec2)tlw1xR1.get();
        Mat22.mulToOut(b1.m_xf.R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
        Mat22.mulToOut(b2.m_xf.R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
        p1.set(b1.m_sweep.c);
        p1.addLocal(r1);
        p2.set(b2.m_sweep.c);
        p2.addLocal(r2);
        d.set(p2);
        d.subLocal(p1);
        b1.getWorldDirectionToOut(this.m_localXAxis1, axis);
        Vec2 v1 = b1.m_linearVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        float w2 = b2.m_angularVelocity;
        Vec2.crossToOut(w1, axis, w1xAxis);
        Vec2.crossToOut(w2, r2, w2xR2);
        Vec2.crossToOut(w1, r1, w1xR1);
        v22.set(v2);
        float speed = Vec2.dot(d, w1xAxis) + Vec2.dot(axis, v22.addLocal(w2xR2).subLocal(v1).subLocal(w1xR1));
        return speed;
    }

    @Override
    public float getReactionTorque() {
        return this.m_torque;
    }

    @Override
    public Vec2 getReactionForce() {
        Vec2 ax1 = Mat22.mul(this.m_body1.m_xf.R, this.m_localXAxis1);
        Vec2 ay1 = Mat22.mul(this.m_body1.m_xf.R, this.m_localYAxis1);
        return new Vec2(this.m_limitForce * ax1.x + this.m_force * ay1.x, this.m_limitForce * ax1.y + this.m_force * ay1.y);
    }

    public void getReactionForceToOut(Vec2 out) {
        Vec2 reactionAx1 = (Vec2)tlreactionAx1.get();
        Mat22.mulToOut(this.m_body1.m_xf.R, this.m_localXAxis1, reactionAx1);
        Mat22.mulToOut(this.m_body1.m_xf.R, this.m_localYAxis1, out);
        out.x = this.m_limitForce * reactionAx1.x + this.m_force * out.x;
        out.y = this.m_limitForce * reactionAx1.y + this.m_force * out.y;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean flag) {
        this.m_enableLimit = flag;
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        this.m_lowerTranslation = lower;
        this.m_upperTranslation = upper;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_enableMotor = flag;
    }

    public void setMotorSpeed(float speed) {
        this.m_motorSpeed = speed;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public void setMaxMotorForce(float force) {
        this.m_maxMotorForce = force;
    }

    public float getMotorForce() {
        return this.m_motorForce;
    }
}

