/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.controllers;

import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.DebugDraw;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.controllers.ControllerDef;
import org.jbox2d.dynamics.controllers.ControllerEdge;

public class Controller {
    public World m_world = null;
    protected ControllerEdge m_bodyList = null;
    protected int m_bodyCount = 0;
    public Controller m_prev = null;
    public Controller m_next = null;

    public void step(TimeStep step) {
    }

    public void draw(DebugDraw debugDraw) {
    }

    public void addBody(Body body) {
        ControllerEdge edge = new ControllerEdge();
        edge.body = body;
        edge.controller = this;
        edge.nextBody = this.m_bodyList;
        edge.prevBody = null;
        if (this.m_bodyList != null) {
            this.m_bodyList.prevBody = edge;
        }
        this.m_bodyList = edge;
        ++this.m_bodyCount;
        edge.nextController = body.m_controllerList;
        edge.prevController = null;
        if (body.m_controllerList != null) {
            body.m_controllerList.prevController = edge;
        }
        body.m_controllerList = edge;
    }

    public void removeBody(Body body) {
        assert (this.m_bodyCount > 0);
        ControllerEdge edge = this.m_bodyList;
        while (edge != null && edge.body != body) {
            edge = edge.nextBody;
        }
        assert (edge != null);
        if (edge.prevBody != null) {
            edge.prevBody.nextBody = edge.nextBody;
        }
        if (edge.nextBody != null) {
            edge.nextBody.prevBody = edge.prevBody;
        }
        if (edge == this.m_bodyList) {
            this.m_bodyList = edge.nextBody;
        }
        --this.m_bodyCount;
        if (edge.prevController != null) {
            edge.prevController.nextController = edge.nextController;
        }
        if (edge.nextController != null) {
            edge.nextController.prevController = edge.prevController;
        }
        if (edge == body.m_controllerList) {
            body.m_controllerList = edge.nextController;
        }
    }

    public void clear() {
        while (this.m_bodyList != null) {
            ControllerEdge edge = this.m_bodyList;
            this.m_bodyList = edge.nextBody;
            if (edge.prevController != null) {
                edge.prevController.nextController = edge.nextController;
            }
            if (edge.nextController != null) {
                edge.nextController.prevController = edge.prevController;
            }
            if (edge != edge.body.m_controllerList) continue;
            edge.body.m_controllerList = edge.nextController;
        }
        this.m_bodyCount = 0;
    }

    public Controller getNext() {
        return this.m_next;
    }

    public World getWorld() {
        return this.m_world;
    }

    public ControllerEdge getBodyList() {
        return this.m_bodyList;
    }

    protected Controller(ControllerDef def) {
    }
}

