/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;
import org.jbox2d.pooling.SingletonPool;
import org.jbox2d.pooling.TLContactPoint;
import org.jbox2d.pooling.TLManifold;
import org.jbox2d.pooling.TLVec2;
import org.jbox2d.pooling.arrays.BooleanArray;

public class PolyAndEdgeContact
extends Contact
implements ContactCreateFcn {
    public final Manifold m_manifold;
    public final ArrayList<Manifold> manifoldList = new ArrayList();
    private static final TLManifold tlm0 = new TLManifold();
    private static final TLVec2 tlV1 = new TLVec2();
    private static final TLContactPoint tlCp = new TLContactPoint();
    private static final BooleanArray tlPersisted = new BooleanArray();

    @Override
    public Contact create(Shape s1, Shape s2) {
        return new PolyAndEdgeContact(s1, s2);
    }

    public PolyAndEdgeContact() {
        this.m_manifold = new Manifold();
        this.manifoldList.add(this.m_manifold);
        this.m_manifoldCount = 0;
    }

    public PolyAndEdgeContact(Shape shape1, Shape shape2) {
        super(shape1, shape2);
        assert (this.m_shape1.getType() == ShapeType.POLYGON_SHAPE);
        assert (this.m_shape2.getType() == ShapeType.EDGE_SHAPE);
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
        this.manifoldList.add(this.m_manifold);
    }

    public static void Destroy(Contact contact) {
        ((PolyAndEdgeContact)contact).destructor();
    }

    public void destructor() {
    }

    @Override
    public Contact clone() {
        assert (false) : "Not yet implemented.";
        return this;
    }

    @Override
    public void evaluate(ContactListener listener) {
        int i;
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = (Manifold)tlm0.get();
        Vec2 v1 = (Vec2)tlV1.get();
        ContactPoint cp = (ContactPoint)tlCp.get();
        m0.set(this.m_manifold);
        SingletonPool.getCollidePoly().collidePolyAndEdge(this.m_manifold, (PolygonShape)this.m_shape1, b1.getMemberXForm(), (EdgeShape)this.m_shape2, b2.getMemberXForm());
        Boolean[] persisted = (Boolean[])tlPersisted.get(2);
        persisted[0] = false;
        persisted[1] = false;
        cp.shape1 = this.m_shape1;
        cp.shape2 = this.m_shape2;
        cp.friction = this.m_friction;
        cp.restitution = this.m_restitution;
        if (this.m_manifold.pointCount > 0) {
            i = 0;
            while (i < this.m_manifold.pointCount) {
                ManifoldPoint mp = this.m_manifold.points[i];
                mp.normalImpulse = 0.0f;
                mp.tangentImpulse = 0.0f;
                boolean found = false;
                ContactID id = mp.id;
                int j = 0;
                while (j < m0.pointCount) {
                    if (!persisted[j].booleanValue()) {
                        ManifoldPoint mp0 = m0.points[j];
                        if (mp0.id.isEqual(id)) {
                            persisted[j] = true;
                            mp.normalImpulse = mp0.normalImpulse;
                            mp.tangentImpulse = mp0.tangentImpulse;
                            found = true;
                            if (listener == null) break;
                            b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                            b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                            b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                            cp.velocity.subLocal(v1);
                            cp.normal.set(this.m_manifold.normal);
                            cp.separation = mp.separation;
                            cp.id.set(id);
                            listener.persist(cp);
                            break;
                        }
                    }
                    ++j;
                }
                if (!found && listener != null) {
                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                    cp.velocity.subLocal(v1);
                    cp.normal.set(this.m_manifold.normal);
                    cp.separation = mp.separation;
                    cp.id.set(id);
                    listener.add(cp);
                }
                ++i;
            }
            this.m_manifoldCount = 1;
        } else {
            this.m_manifoldCount = 0;
        }
        if (listener == null) {
            return;
        }
        i = 0;
        while (i < m0.pointCount) {
            if (!persisted[i].booleanValue()) {
                ManifoldPoint mp0 = m0.points[i];
                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                cp.velocity.subLocal(v1);
                cp.normal.set(this.m_manifold.normal);
                cp.separation = mp0.separation;
                cp.id.set(mp0.id);
                listener.remove(cp);
            }
            ++i;
        }
    }

    @Override
    public List<Manifold> getManifolds() {
        return this.manifoldList;
    }
}

