/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.List;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;

public class ContactSolver {
    public TimeStep m_step;
    public ContactConstraint[] m_constraints;
    public int m_constraintCount;

    public final void init(TimeStep step, Contact[] contacts, int contactCount) {
        this.m_step = step;
        this.m_constraintCount = 0;
        int i = 0;
        while (i < contactCount) {
            assert (contacts[i].isSolid());
            this.m_constraintCount += contacts[i].getManifoldCount();
            ++i;
        }
        this.m_constraints = new ContactConstraint[this.m_constraintCount];
        i = 0;
        while (i < this.m_constraintCount) {
            this.m_constraints[i] = new ContactConstraint();
            ++i;
        }
        int count = 0;
        int i2 = 0;
        while (i2 < contactCount) {
            Contact contact = contacts[i2];
            Body b1 = contact.m_shape1.getBody();
            Body b2 = contact.m_shape2.getBody();
            int manifoldCount = contact.getManifoldCount();
            List<Manifold> manifolds = contact.getManifolds();
            float friction = contact.m_friction;
            float restitution = contact.m_restitution;
            Vec2 v1 = b1.m_linearVelocity;
            Vec2 v2 = b2.m_linearVelocity;
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            int j = 0;
            while (j < manifoldCount) {
                Manifold manifold = manifolds.get(j);
                assert (manifold.pointCount > 0) : "Manifold " + j + " has length 0";
                Vec2 normal = manifold.normal;
                assert (count < this.m_constraintCount);
                ContactConstraint c = this.m_constraints[count];
                c.body1 = b1;
                c.body2 = b2;
                c.manifold = manifold;
                c.normal.set(normal);
                c.pointCount = manifold.pointCount;
                c.friction = friction;
                c.restitution = restitution;
                int k = 0;
                while (k < c.pointCount) {
                    ManifoldPoint cp = manifold.points[k];
                    ContactConstraintPoint ccp = c.points[k];
                    ccp.normalImpulse = cp.normalImpulse;
                    ccp.tangentImpulse = cp.tangentImpulse;
                    ccp.separation = cp.separation;
                    ccp.positionImpulse = 0.0f;
                    ccp.localAnchor1.set(cp.localPoint1);
                    ccp.localAnchor2.set(cp.localPoint2);
                    float v3x = cp.localPoint1.x - b1.m_sweep.localCenter.x;
                    float v3y = cp.localPoint1.y - b1.m_sweep.localCenter.y;
                    ccp.r1.set(b1.m_xf.R.col1.x * v3x + b1.m_xf.R.col2.x * v3y, b1.m_xf.R.col1.y * v3x + b1.m_xf.R.col2.y * v3y);
                    float v4x = cp.localPoint2.x - b2.m_sweep.localCenter.x;
                    float v4y = cp.localPoint2.y - b2.m_sweep.localCenter.y;
                    ccp.r2.set(b2.m_xf.R.col1.x * v4x + b2.m_xf.R.col2.x * v4y, b2.m_xf.R.col1.y * v4x + b2.m_xf.R.col2.y * v4y);
                    float rn1 = Vec2.cross(ccp.r1, normal);
                    float rn2 = Vec2.cross(ccp.r2, normal);
                    rn1 *= rn1;
                    rn2 *= rn2;
                    float kNormal = b1.m_invMass + b2.m_invMass + b1.m_invI * rn1 + b2.m_invI * rn2;
                    assert (kNormal > 1.1920929E-7f) : "kNormal was " + kNormal;
                    ccp.normalMass = 1.0f / kNormal;
                    float kEqualized = b1.m_mass * b1.m_invMass + b2.m_mass * b2.m_invMass;
                    assert ((kEqualized += b1.m_mass * b1.m_invI * rn1 + b2.m_mass * b2.m_invI * rn2) > 1.1920929E-7f) : "kEqualized was " + kEqualized;
                    ccp.equalizedMass = 1.0f / kEqualized;
                    float tangentx = normal.y;
                    float tangenty = -normal.x;
                    Vec2 a = ccp.r1;
                    float rt1 = a.x * tangenty - a.y * tangentx;
                    Vec2 a1 = ccp.r2;
                    float rt2 = a1.x * tangenty - a1.y * tangentx;
                    rt1 *= rt1;
                    rt2 *= rt2;
                    float kTangent = b1.m_invMass + b2.m_invMass + b1.m_invI * rt1 + b2.m_invI * rt2;
                    assert (kTangent > 1.1920929E-7f);
                    ccp.tangentMass = 1.0f / kTangent;
                    ccp.velocityBias = 0.0f;
                    if (ccp.separation > 0.0f) {
                        ccp.velocityBias = -60.0f * ccp.separation;
                    }
                    Vec2 a2 = ccp.r2;
                    Vec2 a3 = ccp.r1;
                    float bufferx = -w2 * a2.y - -w1 * a3.y + v2.x - v1.x;
                    float buffery = w2 * a2.x - w1 * a3.x + v2.y - v1.y;
                    float vRel = c.normal.x * bufferx + c.normal.y * buffery;
                    if (vRel < -1.0f) {
                        ccp.velocityBias += -c.restitution * vRel;
                    }
                    ++k;
                }
                ++count;
                ++j;
            }
            ++i2;
        }
        assert (count == this.m_constraintCount);
    }

    public void initVelocityConstraints(TimeStep step) {
        int i = 0;
        while (i < this.m_constraintCount) {
            ContactConstraintPoint ccp;
            int j;
            float normaly;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            float normalx = c.normal.x;
            float tangentx = normaly = c.normal.y;
            float tangenty = -normalx;
            if (step.warmStarting) {
                j = 0;
                while (j < c.pointCount) {
                    ccp = c.points[j];
                    ccp.normalImpulse *= step.dtRatio;
                    ccp.tangentImpulse *= step.dtRatio;
                    float px = ccp.normalImpulse * normalx + ccp.tangentImpulse * tangentx;
                    float py = ccp.normalImpulse * normaly + ccp.tangentImpulse * tangenty;
                    b1.m_angularVelocity -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                    b1.m_linearVelocity.x -= px * invMass1;
                    b1.m_linearVelocity.y -= py * invMass1;
                    b2.m_angularVelocity += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                    b2.m_linearVelocity.x += px * invMass2;
                    b2.m_linearVelocity.y += py * invMass2;
                    ++j;
                }
            } else {
                j = 0;
                while (j < c.pointCount) {
                    ccp = c.points[j];
                    ccp.normalImpulse = 0.0f;
                    ccp.tangentImpulse = 0.0f;
                    ++j;
                }
            }
            ++i;
        }
    }

    public void solveVelocityConstraints() {
        int i = 0;
        while (i < this.m_constraintCount) {
            float lambda;
            float dvy;
            float dvx;
            ContactConstraintPoint ccp;
            float normaly;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            float v1x = b1.m_linearVelocity.x;
            float v1y = b1.m_linearVelocity.y;
            float v2x = b2.m_linearVelocity.x;
            float v2y = b2.m_linearVelocity.y;
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            float normalx = c.normal.x;
            float tangentx = normaly = c.normal.y;
            float tangenty = -normalx;
            float friction = c.friction;
            int j = 0;
            while (j < c.pointCount) {
                ccp = c.points[j];
                dvx = v2x - w2 * ccp.r2.y - v1x + w1 * ccp.r1.y;
                dvy = v2y + w2 * ccp.r2.x - v1y - w1 * ccp.r1.x;
                float vn = dvx * normalx + dvy * normaly;
                lambda = -ccp.normalMass * (vn - ccp.velocityBias);
                float newImpulse = MathUtils.max(ccp.normalImpulse + lambda, 0.0f);
                lambda = newImpulse - ccp.normalImpulse;
                float Px = lambda * normalx;
                float Py = lambda * normaly;
                v1x -= invMass1 * Px;
                v1y -= invMass1 * Py;
                w1 -= invI1 * (ccp.r1.x * Py - ccp.r1.y * Px);
                v2x += invMass2 * Px;
                v2y += invMass2 * Py;
                w2 += invI2 * (ccp.r2.x * Py - ccp.r2.y * Px);
                ccp.normalImpulse = newImpulse;
                ++j;
            }
            j = 0;
            while (j < c.pointCount) {
                ccp = c.points[j];
                dvx = v2x - w2 * ccp.r2.y - v1x + w1 * ccp.r1.y;
                dvy = v2y + w2 * ccp.r2.x - v1y - w1 * ccp.r1.x;
                float vt = dvx * tangentx + dvy * tangenty;
                lambda = ccp.tangentMass * -vt;
                float maxFriction = friction * ccp.normalImpulse;
                float newImpulse = MathUtils.max(-maxFriction, MathUtils.min(ccp.tangentImpulse + lambda, maxFriction));
                lambda = newImpulse - ccp.tangentImpulse;
                float px = lambda * tangentx;
                float py = lambda * tangenty;
                v1x -= px * invMass1;
                v1y -= py * invMass1;
                w1 -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                v2x += px * invMass2;
                v2y += py * invMass2;
                w2 += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                ccp.tangentImpulse = newImpulse;
                ++j;
            }
            b1.m_linearVelocity.x = v1x;
            b1.m_linearVelocity.y = v1y;
            b1.m_angularVelocity = w1;
            b2.m_linearVelocity.x = v2x;
            b2.m_linearVelocity.y = v2y;
            b2.m_angularVelocity = w2;
            ++i;
        }
    }

    public void finalizeVelocityConstraints() {
        int i = 0;
        while (i < this.m_constraintCount) {
            ContactConstraint c = this.m_constraints[i];
            Manifold m = c.manifold;
            int j = 0;
            while (j < c.pointCount) {
                m.points[j].normalImpulse = c.points[j].normalImpulse;
                m.points[j].tangentImpulse = c.points[j].tangentImpulse;
                ++j;
            }
            ++i;
        }
    }

    public boolean solvePositionConstraints(float baumgarte) {
        float minSeparation = 0.0f;
        int i = 0;
        while (i < this.m_constraintCount) {
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_mass * b1.m_invMass;
            float invI1 = b1.m_mass * b1.m_invI;
            float invMass2 = b2.m_mass * b2.m_invMass;
            float invI2 = b2.m_mass * b2.m_invI;
            Vec2 normal = c.normal;
            int j = 0;
            while (j < c.pointCount) {
                ContactConstraintPoint ccp = c.points[j];
                float vx = ccp.localAnchor1.x - b1.m_sweep.localCenter.x;
                float vy = ccp.localAnchor1.y - b1.m_sweep.localCenter.y;
                float r1x = b1.m_xf.R.col1.x * vx + b1.m_xf.R.col2.x * vy;
                float r1y = b1.m_xf.R.col1.y * vx + b1.m_xf.R.col2.y * vy;
                vx = ccp.localAnchor2.x - b2.m_sweep.localCenter.x;
                vy = ccp.localAnchor2.y - b2.m_sweep.localCenter.y;
                float r2x = b2.m_xf.R.col1.x * vx + b2.m_xf.R.col2.x * vy;
                float r2y = b2.m_xf.R.col1.y * vx + b2.m_xf.R.col2.y * vy;
                float dpx = b2.m_sweep.c.x + r2x - b1.m_sweep.c.x - r1x;
                float dpy = b2.m_sweep.c.y + r2y - b1.m_sweep.c.y - r1y;
                float separation = dpx * normal.x + dpy * normal.y + ccp.separation;
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = baumgarte * MathUtils.clamp(separation + 0.005f, -0.2f, 0.0f);
                float dImpulse = -ccp.equalizedMass * C;
                float impulse0 = ccp.positionImpulse;
                ccp.positionImpulse = MathUtils.max(impulse0 + dImpulse, 0.0f);
                dImpulse = ccp.positionImpulse - impulse0;
                float impulsex = dImpulse * normal.x;
                float impulsey = dImpulse * normal.y;
                b1.m_sweep.c.x -= invMass1 * impulsex;
                b1.m_sweep.c.y -= invMass1 * impulsey;
                b1.m_sweep.a -= invI1 * (r1x * impulsey - r1y * impulsex);
                b1.synchronizeTransform();
                b2.m_sweep.c.x += invMass2 * impulsex;
                b2.m_sweep.c.y += invMass2 * impulsey;
                b2.m_sweep.a += invI2 * (r2x * impulsey - r2y * impulsex);
                b2.synchronizeTransform();
                ++j;
            }
            ++i;
        }
        return minSeparation >= -0.0075f;
    }
}

