/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import java.util.HashSet;
import java.util.Set;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.World;

public class BodyGroup {
    private final Set<BodyGroup> children = new HashSet<BodyGroup>();
    private final Set<Body> bodies = new HashSet<Body>();
    private final World world;

    public BodyGroup(Body ... bodies) {
        World w = null;
        Body[] bodyArray = bodies;
        int n = bodies.length;
        int n2 = 0;
        while (n2 < n) {
            Body b = bodyArray[n2];
            this.bodies.add(b);
            if (w == null) {
                w = b.getWorld();
            } else if (b.getWorld() != w) {
                System.out.println("Cannot add bodies from different worlds to a BodyGroup");
                assert (false) : "Cannot add bodies from different worlds to a BodyGroup";
            }
            ++n2;
        }
        this.world = w;
    }

    public BodyGroup(BodyGroup ... groups) {
        World w = null;
        BodyGroup[] bodyGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            BodyGroup bg = bodyGroupArray[n2];
            this.children.add(bg);
            if (w == null) {
                w = bg.getWorld();
            } else if (bg.getWorld() != w) {
                System.out.println("Cannot add BodyGroups from different worlds to a BodyGroup");
                assert (false) : "Cannot add BodyGroups from different worlds to a BodyGroup";
            }
            ++n2;
        }
        this.world = w;
    }

    public Set<BodyGroup> getChildren() {
        return this.children;
    }

    public Set<Body> getBodies() {
        return this.bodies;
    }

    public Set<Body> getBodiesDeep() {
        HashSet<Body> res = new HashSet<Body>();
        res.addAll(this.bodies);
        for (BodyGroup bg : this.children) {
            res.addAll(bg.getBodiesDeep());
        }
        return res;
    }

    public World getWorld() {
        return this.world;
    }

    public static BodyGroup fromSeedConnectedByJoints(Body seed) {
        Set<Body> bodies = seed.getConnectedDynamicBodyIsland();
        return new BodyGroup(bodies.toArray(new Body[bodies.size()]));
    }
}

