/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import java.util.HashSet;
import java.util.Set;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.shapes.EdgeChainDef;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.controllers.ControllerEdge;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.pooling.TLVec2;
import org.jbox2d.pooling.TLXForm;

public class Body {
    private static volatile int nextID = 0;
    private static Object idLock = new Object();
    private int m_uniqueID;
    public static final int e_frozenFlag = 2;
    public static final int e_islandFlag = 4;
    public static final int e_sleepFlag = 8;
    public static final int e_allowSleepFlag = 16;
    public static final int e_bulletFlag = 32;
    public static final int e_fixedRotationFlag = 64;
    public int m_flags;
    public static final int e_staticType = 0;
    public static final int e_dynamicType = 1;
    public static final int e_maxTypes = 2;
    public int m_type;
    public ControllerEdge m_controllerList;
    public final XForm m_xf;
    public Sweep m_sweep;
    public final Vec2 m_linearVelocity;
    public float m_angularVelocity;
    public final Vec2 m_force;
    public float m_torque;
    public World m_world;
    public Body m_prev;
    public Body m_next;
    public Shape m_shapeList;
    public int m_shapeCount;
    public JointEdge m_jointList;
    public ContactEdge m_contactList;
    public float m_mass;
    public float m_invMass;
    public float m_I;
    public float m_invI;
    public float m_linearDamping;
    public float m_angularDamping;
    public float m_sleepTime;
    public Object m_userData;
    private static final TLVec2 tlCenter = new TLVec2();
    private static final TLXForm tlXf1 = new TLXForm();

    public Body() {
        this(new BodyDef(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Body(BodyDef bd, World world) {
        assert (!world.m_lock);
        Object object = idLock;
        synchronized (object) {
            this.m_uniqueID = nextID++;
        }
        this.m_flags = 0;
        if (bd.isBullet) {
            this.m_flags |= 0x20;
        }
        if (bd.fixedRotation) {
            this.m_flags |= 0x40;
        }
        if (bd.allowSleep) {
            this.m_flags |= 0x10;
        }
        if (bd.isSleeping) {
            this.m_flags |= 8;
        }
        this.m_world = world;
        this.m_xf = new XForm();
        this.m_xf.position.set(bd.position);
        this.m_xf.R.set(bd.angle);
        this.m_sweep = new Sweep();
        this.m_sweep.localCenter.set(bd.massData.center);
        this.m_sweep.t0 = 1.0f;
        this.m_sweep.a0 = this.m_sweep.a = bd.angle;
        this.m_sweep.c.set(XForm.mul(this.m_xf, this.m_sweep.localCenter));
        this.m_sweep.c0.set(this.m_sweep.c);
        this.m_jointList = null;
        this.m_contactList = null;
        this.m_prev = null;
        this.m_next = null;
        this.m_linearDamping = bd.linearDamping;
        this.m_angularDamping = bd.angularDamping;
        this.m_force = new Vec2(0.0f, 0.0f);
        this.m_torque = 0.0f;
        this.m_linearVelocity = new Vec2(0.0f, 0.0f);
        this.m_angularVelocity = 0.0f;
        this.m_sleepTime = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = bd.massData.mass;
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
        }
        if ((this.m_flags & 0x40) == 0) {
            this.m_I = bd.massData.I;
        }
        if (this.m_I > 0.0f) {
            this.m_invI = 1.0f / this.m_I;
        }
        this.m_type = this.m_invMass == 0.0f && this.m_invI == 0.0f ? 0 : 1;
        this.m_userData = bd.userData;
        this.m_shapeList = null;
        this.m_shapeCount = 0;
    }

    private float connectEdges(EdgeShape s1, EdgeShape s2, float angle1) {
        float angle2 = (float)Math.atan2(s2.getDirectionVector().y, s2.getDirectionVector().x);
        Vec2 core = s2.getDirectionVector().mul((float)Math.tan((angle2 - angle1) * 0.5f));
        core.subLocal(s2.getNormalVector()).mulLocal(0.04f).addLocal(s2.getVertex1());
        Vec2 cornerDir = s1.getDirectionVector().add(s2.getDirectionVector());
        cornerDir.normalize();
        boolean convex = Vec2.dot(s1.getDirectionVector(), s2.getNormalVector()) > 0.0f;
        s1.setNextEdge(s2, core, cornerDir, convex);
        s2.setPrevEdge(s1, core, cornerDir, convex);
        return angle2;
    }

    public Shape createShape(ShapeDef def) {
        assert (!this.m_world.m_lock);
        if (def.type == ShapeType.EDGE_SHAPE) {
            Vec2 v1;
            EdgeChainDef edgeDef = (EdgeChainDef)def;
            int i = 0;
            if (edgeDef.isLoop()) {
                v1 = edgeDef.getVertices().get(edgeDef.getVertexCount() - 1);
                i = 0;
            } else {
                v1 = edgeDef.getVertices().get(0);
                i = 1;
            }
            EdgeShape s0 = null;
            EdgeShape s1 = null;
            EdgeShape s2 = null;
            float angle = 0.0f;
            while (i < edgeDef.getVertexCount()) {
                Vec2 v2 = edgeDef.getVertices().get(i);
                s2 = new EdgeShape(v1, v2, def);
                s2.m_next = this.m_shapeList;
                this.m_shapeList = s2;
                ++this.m_shapeCount;
                s2.m_body = this;
                s2.createProxy(this.m_world.m_broadPhase, this.m_xf);
                s2.updateSweepRadius(this.m_sweep.localCenter);
                if (s1 == null) {
                    s0 = s2;
                    angle = (float)Math.atan2(s2.getDirectionVector().y, s2.getDirectionVector().x);
                } else {
                    angle = this.connectEdges(s1, s2, angle);
                }
                s1 = s2;
                v1 = v2;
                ++i;
            }
            if (edgeDef.isLoop()) {
                this.connectEdges(s1, s0, angle);
            }
            return s0;
        }
        Shape s = Shape.create(def);
        s.m_next = this.m_shapeList;
        this.m_shapeList = s;
        ++this.m_shapeCount;
        s.m_body = this;
        s.createProxy(this.m_world.m_broadPhase, this.m_xf);
        s.updateSweepRadius(this.m_sweep.localCenter);
        return s;
    }

    public void destroyShape(Shape s) {
        assert (!this.m_world.m_lock);
        assert (s.getBody() == this);
        s.destroyProxy(this.m_world.m_broadPhase);
        assert (this.m_shapeCount > 0);
        Shape node = this.m_shapeList;
        Shape prevNode = null;
        boolean found = false;
        while (node != null) {
            if (node == s) {
                if (prevNode == null) {
                    this.m_shapeList = s.m_next;
                    found = true;
                    break;
                }
                prevNode.m_next = s.m_next;
                found = true;
                break;
            }
            prevNode = node;
            node = node.m_next;
        }
        assert (found);
        s.m_body = null;
        s.m_next = null;
        --this.m_shapeCount;
        Shape.destroy(s);
    }

    public void setMass(MassData massData) {
        assert (!this.m_world.m_lock);
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = massData.mass;
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
        }
        if ((this.m_flags & 0x40) == 0) {
            this.m_I = massData.I;
        }
        if (this.m_I > 0.0f) {
            this.m_invI = 1.0f / this.m_I;
        }
        this.m_sweep.localCenter.set(massData.center);
        XForm.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c);
        this.m_sweep.c0.set(this.m_sweep.c);
        Shape s = this.m_shapeList;
        while (s != null) {
            s.updateSweepRadius(this.m_sweep.localCenter);
            s = s.m_next;
        }
        int oldType = this.m_type;
        this.m_type = this.m_invMass == 0.0f && this.m_invI == 0.0f ? 0 : 1;
        if (oldType != this.m_type) {
            Shape s2 = this.m_shapeList;
            while (s2 != null) {
                s2.refilterProxy(this.m_world.m_broadPhase, this.m_xf);
                s2 = s2.m_next;
            }
        }
    }

    public void setMassFromShapes() {
        assert (!this.m_world.m_lock);
        this.m_mass = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        Vec2 center = (Vec2)tlCenter.get();
        center.setZero();
        Shape s = this.m_shapeList;
        while (s != null) {
            MassData massData = new MassData();
            s.computeMass(massData);
            this.m_mass += massData.mass;
            center.x += massData.mass * massData.center.x;
            center.y += massData.mass * massData.center.y;
            this.m_I += massData.I;
            s = s.m_next;
        }
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
            center.x *= this.m_invMass;
            center.y *= this.m_invMass;
        }
        if (this.m_I > 0.0f && (this.m_flags & 0x40) == 0) {
            this.m_I -= this.m_mass * Vec2.dot(center, center);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        } else {
            this.m_I = 0.0f;
            this.m_invI = 0.0f;
        }
        this.m_sweep.localCenter.set(center);
        XForm.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c);
        this.m_sweep.c0.set(this.m_sweep.c);
        s = this.m_shapeList;
        while (s != null) {
            s.updateSweepRadius(this.m_sweep.localCenter);
            s = s.m_next;
        }
        int oldType = this.m_type;
        this.m_type = this.m_invMass == 0.0f && this.m_invI == 0.0f ? 0 : 1;
        if (oldType != this.m_type) {
            Shape s2 = this.m_shapeList;
            while (s2 != null) {
                s2.refilterProxy(this.m_world.m_broadPhase, this.m_xf);
                s2 = s2.m_next;
            }
        }
    }

    public boolean setXForm(Vec2 position, float angle) {
        assert (!this.m_world.m_lock);
        if (this.isFrozen()) {
            return false;
        }
        this.m_xf.R.set(angle);
        this.m_xf.position.set(position);
        XForm.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c);
        this.m_sweep.c0.set(this.m_sweep.c);
        this.m_sweep.a0 = this.m_sweep.a = angle;
        boolean freeze = false;
        Shape s = this.m_shapeList;
        while (s != null) {
            boolean inRange = s.synchronize(this.m_world.m_broadPhase, this.m_xf, this.m_xf);
            if (!inRange) {
                freeze = true;
                break;
            }
            s = s.m_next;
        }
        if (freeze) {
            this.m_flags |= 2;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            s = this.m_shapeList;
            while (s != null) {
                s.destroyProxy(this.m_world.m_broadPhase);
                s = s.m_next;
            }
            return false;
        }
        this.m_world.m_broadPhase.commit();
        return true;
    }

    public XForm getXForm() {
        XForm xf = new XForm();
        xf.set(this.m_xf);
        return xf;
    }

    public XForm getMemberXForm() {
        return this.m_xf;
    }

    public Vec2 getPosition() {
        return this.m_xf.position.clone();
    }

    public Vec2 getMemberPosition() {
        return this.m_xf.position;
    }

    public float getAngle() {
        return this.m_sweep.a;
    }

    public Vec2 getWorldCenter() {
        return this.m_sweep.c.clone();
    }

    public Vec2 getMemberWorldCenter() {
        return this.m_sweep.c;
    }

    public Vec2 getLocalCenter() {
        return this.m_sweep.localCenter.clone();
    }

    public Vec2 getMemberLocalCenter() {
        return this.m_sweep.localCenter;
    }

    public void setLinearVelocity(Vec2 v) {
        this.m_linearVelocity.set(v);
    }

    public Vec2 getLinearVelocity() {
        return this.m_linearVelocity;
    }

    public void setAngularVelocity(float omega) {
        this.m_angularVelocity = omega;
    }

    public float getAngularVelocity() {
        return this.m_angularVelocity;
    }

    public void applyForce(Vec2 force, Vec2 point) {
        if (this.isSleeping()) {
            this.wakeUp();
        }
        this.m_force.addLocal(force);
        this.m_torque += (point.x - this.m_sweep.c.x) * force.y - (point.y - this.m_sweep.c.y) * force.x;
    }

    public void applyTorque(float torque) {
        if (this.isSleeping()) {
            this.wakeUp();
        }
        this.m_torque += torque;
    }

    public void applyImpulse(Vec2 impulse, Vec2 point) {
        if (this.isSleeping()) {
            this.wakeUp();
        }
        this.m_linearVelocity.x += this.m_invMass * impulse.x;
        this.m_linearVelocity.y += this.m_invMass * impulse.y;
        this.m_angularVelocity += this.m_invI * ((point.x - this.m_sweep.c.x) * impulse.y - (point.y - this.m_sweep.c.y) * impulse.x);
    }

    public float getMass() {
        return this.m_mass;
    }

    public float getInertia() {
        return this.m_I;
    }

    public Vec2 getWorldLocation(Vec2 localPoint) {
        return XForm.mul(this.m_xf, localPoint);
    }

    public void getWorldLocationToOut(Vec2 localPoint, Vec2 out) {
        XForm.mulToOut(this.m_xf, localPoint, out);
    }

    @Deprecated
    public Vec2 getWorldPoint(Vec2 localPoint) {
        return this.getWorldLocation(localPoint);
    }

    @Deprecated
    public Vec2 getWorldVector(Vec2 localVector) {
        return this.getWorldDirection(localVector);
    }

    public Vec2 getWorldDirection(Vec2 localDirection) {
        return Mat22.mul(this.m_xf.R, localDirection);
    }

    public void getWorldDirectionToOut(Vec2 localDirection, Vec2 out) {
        Mat22.mulToOut(this.m_xf.R, localDirection, out);
    }

    public Vec2 getLocalPoint(Vec2 worldPoint) {
        return XForm.mulTrans(this.m_xf, worldPoint);
    }

    public void getLocalPointToOut(Vec2 worldPoint, Vec2 out) {
        XForm.mulTransToOut(this.m_xf, worldPoint, out);
    }

    public Vec2 getLocalVector(Vec2 worldVector) {
        return Mat22.mulTrans(this.m_xf.R, worldVector);
    }

    public void getLocalVectorToOut(Vec2 worldVector, Vec2 out) {
        Mat22.mulTransToOut(this.m_xf.R, worldVector, out);
    }

    public boolean isBullet() {
        return (this.m_flags & 0x20) == 32;
    }

    public void setBullet(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 0x20) : (this.m_flags &= 0xFFFFFFDF);
    }

    public boolean isStatic() {
        return this.m_type == 0;
    }

    public boolean isDynamic() {
        return this.m_type == 1;
    }

    public boolean isFrozen() {
        return (this.m_flags & 2) == 2;
    }

    public boolean isSleeping() {
        return (this.m_flags & 8) == 8;
    }

    public void allowSleeping(boolean flag) {
        if (flag) {
            this.m_flags |= 0x10;
        } else {
            this.m_flags &= 0xFFFFFFEF;
            this.wakeUp();
        }
    }

    public void wakeUp() {
        this.m_flags &= 0xFFFFFFF7;
        this.m_sleepTime = 0.0f;
    }

    public Shape getShapeList() {
        return this.m_shapeList;
    }

    public JointEdge getJointList() {
        return this.m_jointList;
    }

    public Body getNext() {
        return this.m_next;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void computeMass() {
    }

    public boolean synchronizeShapes() {
        XForm xf1 = (XForm)tlXf1.get();
        xf1.R.set(this.m_sweep.a0);
        Mat22 R = xf1.R;
        Vec2 v = this.m_sweep.localCenter;
        xf1.position.set(this.m_sweep.c0.x - (R.col1.x * v.x + R.col2.x * v.y), this.m_sweep.c0.y - (R.col1.y * v.x + R.col2.y * v.y));
        boolean inRange = true;
        Shape s = this.m_shapeList;
        while (s != null) {
            inRange = s.synchronize(this.m_world.m_broadPhase, xf1, this.m_xf);
            if (!inRange) break;
            s = s.m_next;
        }
        if (!inRange) {
            this.m_flags |= 2;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            s = this.m_shapeList;
            while (s != null) {
                s.destroyProxy(this.m_world.m_broadPhase);
                s = s.m_next;
            }
            return false;
        }
        return true;
    }

    public void synchronizeTransform() {
        this.m_xf.R.set(this.m_sweep.a);
        Vec2 v1 = this.m_sweep.localCenter;
        this.m_xf.position.x = this.m_sweep.c.x - (this.m_xf.R.col1.x * v1.x + this.m_xf.R.col2.x * v1.y);
        this.m_xf.position.y = this.m_sweep.c.y - (this.m_xf.R.col1.y * v1.x + this.m_xf.R.col2.y * v1.y);
    }

    public boolean isConnected(Body other) {
        JointEdge jn = this.m_jointList;
        while (jn != null) {
            if (jn.other == other) {
                return !jn.joint.m_collideConnected;
            }
            jn = jn.next;
        }
        return false;
    }

    public void advance(float t) {
        this.m_sweep.advance(t);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a = this.m_sweep.a0;
        this.synchronizeTransform();
    }

    public Vec2 getLinearVelocityFromWorldPoint(Vec2 worldPoint) {
        float ax = worldPoint.x - this.m_sweep.c.x;
        float ay = worldPoint.y - this.m_sweep.c.y;
        float vx = -this.m_angularVelocity * ay;
        float vy = this.m_angularVelocity * ax;
        return new Vec2(this.m_linearVelocity.x + vx, this.m_linearVelocity.y + vy);
    }

    public void getLinearVelocityFromWorldPointToOut(Vec2 worldPoint, Vec2 out) {
        float ax = worldPoint.x - this.m_sweep.c.x;
        float ay = worldPoint.y - this.m_sweep.c.y;
        float vx = -this.m_angularVelocity * ay;
        float vy = this.m_angularVelocity * ax;
        out.set(this.m_linearVelocity.x + vx, this.m_linearVelocity.y + vy);
    }

    public Vec2 getLinearVelocityFromLocalPoint(Vec2 localPoint) {
        Vec2 out = new Vec2();
        this.getWorldLocationToOut(localPoint, out);
        float ax = out.x - this.m_sweep.c.x;
        float ay = out.y - this.m_sweep.c.y;
        float vx = -this.m_angularVelocity * ay;
        float vy = this.m_angularVelocity * ax;
        out.x = this.m_linearVelocity.x + vx;
        out.y = this.m_linearVelocity.y + vy;
        return out;
    }

    public void getLinearVelocityFromLocalPointToOut(Vec2 localPoint, Vec2 out) {
        this.getWorldLocationToOut(localPoint, out);
        float ax = out.x - this.m_sweep.c.x;
        float ay = out.y - this.m_sweep.c.y;
        float vx = -this.m_angularVelocity * ay;
        float vy = this.m_angularVelocity * ax;
        out.x = this.m_linearVelocity.x + vx;
        out.y = this.m_linearVelocity.y + vy;
    }

    public void putToSleep() {
        this.m_flags |= 8;
        this.m_sleepTime = 0.0f;
        this.m_linearVelocity.setZero();
        this.m_angularVelocity = 0.0f;
        this.m_force.setZero();
        this.m_torque = 0.0f;
    }

    public void setUserData(Object data) {
        this.m_userData = data;
    }

    public World getWorld() {
        return this.m_world;
    }

    public ContactEdge getContactList() {
        return this.m_contactList;
    }

    public Set<Body> getBodiesInContact() {
        HashSet<Body> mySet = new HashSet<Body>();
        ContactEdge edge = this.getContactList();
        while (edge != null) {
            if (edge.contact.getManifoldCount() > 0) {
                mySet.add(edge.other);
            }
            edge = edge.next;
        }
        return mySet;
    }

    public Set<Body> getConnectedBodies() {
        HashSet<Body> mySet = new HashSet<Body>();
        JointEdge edge = this.getJointList();
        while (edge != null) {
            mySet.add(edge.other);
            edge = edge.next;
        }
        return mySet;
    }

    public Set<Body> getConnectedDynamicBodies() {
        HashSet<Body> mySet = new HashSet<Body>();
        JointEdge edge = this.getJointList();
        while (edge != null) {
            if (edge.other.isDynamic()) {
                mySet.add(edge.other);
            }
            edge = edge.next;
        }
        return mySet;
    }

    public Set<Body> getConnectedBodyIsland() {
        HashSet<Body> result = new HashSet<Body>();
        result.add(this);
        return this.getConnectedBodyIsland_impl(this, result);
    }

    private Set<Body> getConnectedBodyIsland_impl(Body parent, Set<Body> parentResult) {
        Set<Body> connected = this.getConnectedBodies();
        for (Body b : connected) {
            if (b == parent || parentResult.contains(b)) continue;
            parentResult.add(b);
            parentResult.addAll(b.getConnectedBodyIsland_impl(b, parentResult));
        }
        return parentResult;
    }

    public Set<Body> getConnectedDynamicBodyIsland() {
        HashSet<Body> result = new HashSet<Body>();
        if (!this.isDynamic()) {
            return result;
        }
        result.add(this);
        return this.getConnectedDynamicBodyIsland_impl(this, result);
    }

    private Set<Body> getConnectedDynamicBodyIsland_impl(Body parent, Set<Body> parentResult) {
        Set<Body> connected = this.getConnectedBodies();
        for (Body b : connected) {
            if (b == parent || !b.isDynamic() || parentResult.contains(b)) continue;
            parentResult.add(b);
            parentResult.addAll(b.getConnectedDynamicBodyIsland_impl(b, parentResult));
        }
        return parentResult;
    }

    public Set<Body> getTouchingBodyIsland() {
        HashSet<Body> result = new HashSet<Body>();
        result.add(this);
        return this.getTouchingBodyIsland_impl(this, result);
    }

    private Set<Body> getTouchingBodyIsland_impl(Body parent, Set<Body> parentResult) {
        Set<Body> touching = this.getBodiesInContact();
        for (Body b : touching) {
            if (b == parent || parentResult.contains(b)) continue;
            parentResult.add(b);
            parentResult.addAll(b.getTouchingBodyIsland_impl(b, parentResult));
        }
        return parentResult;
    }

    public Set<Body> getTouchingDynamicBodyIsland() {
        HashSet<Body> result = new HashSet<Body>();
        result.add(this);
        return this.getTouchingDynamicBodyIsland_impl(this, result);
    }

    private Set<Body> getTouchingDynamicBodyIsland_impl(Body parent, Set<Body> parentResult) {
        Set<Body> touching = this.getBodiesInContact();
        for (Body b : touching) {
            if (b == parent || !b.isDynamic() || parentResult.contains(b)) continue;
            parentResult.add(b);
            parentResult.addAll(b.getTouchingDynamicBodyIsland_impl(b, parentResult));
        }
        return parentResult;
    }

    public boolean isTouching(Body other) {
        ContactEdge edge = this.getContactList();
        while (edge != null) {
            if (edge.other == other && edge.contact.getManifoldCount() > 0) {
                return true;
            }
            edge = edge.next;
        }
        return false;
    }

    public void setLinearDamping(float damping) {
        this.m_linearDamping = damping;
    }

    public float getLinearDamping() {
        return this.m_linearDamping;
    }

    public void setAngularDamping(float damping) {
        this.m_angularDamping = damping;
    }

    public float getAngularDamping() {
        return this.m_angularDamping;
    }
}

