/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import java.util.HashSet;
import java.util.Set;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.BroadPhase;
import org.jbox2d.collision.FilterData;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SegmentCollide;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PointShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.pooling.TLAABB;

public abstract class Shape {
    public int uid = uidcount++;
    private static int uidcount = 0;
    public ShapeType m_type;
    public Shape m_next;
    public Body m_body;
    public float m_sweepRadius;
    public float m_density;
    public float m_friction;
    public float m_restitution;
    public int m_proxyId;
    public FilterData m_filter;
    public boolean m_isSensor;
    public Object m_userData;
    private static final TLAABB tlAabb = new TLAABB();

    public Shape(ShapeDef def) {
        this.m_userData = def.userData;
        this.m_friction = def.friction;
        this.m_restitution = def.restitution;
        this.m_density = def.density;
        this.m_body = null;
        this.m_sweepRadius = 0.0f;
        this.m_next = null;
        this.m_proxyId = Integer.MAX_VALUE;
        this.m_filter = new FilterData();
        this.m_filter.categoryBits = def.filter.categoryBits;
        this.m_filter.maskBits = def.filter.maskBits;
        this.m_filter.groupIndex = def.filter.groupIndex;
        this.m_isSensor = def.isSensor;
    }

    public float getFriction() {
        return this.m_friction;
    }

    public void setFriction(float friction) {
        this.m_friction = friction;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void setRestitution(float restitution) {
        this.m_restitution = restitution;
    }

    public void setFilterData(FilterData filter) {
        this.m_filter.set(filter);
    }

    public FilterData getFilterData() {
        return this.m_filter;
    }

    public ShapeType getType() {
        return this.m_type;
    }

    public boolean isSensor() {
        return this.m_isSensor;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object o) {
        this.m_userData = o;
    }

    public Body getBody() {
        return this.m_body;
    }

    public Shape getNext() {
        return this.m_next;
    }

    public float getSweepRadius() {
        return this.m_sweepRadius;
    }

    public abstract boolean testPoint(XForm var1, Vec2 var2);

    public abstract SegmentCollide testSegment(XForm var1, RaycastResult var2, Segment var3, float var4);

    public abstract void computeAABB(AABB var1, XForm var2);

    public abstract void computeSweptAABB(AABB var1, XForm var2, XForm var3);

    public abstract void computeMass(MassData var1);

    public abstract void updateSweepRadius(Vec2 var1);

    public boolean synchronize(BroadPhase broadPhase, XForm transform1, XForm transform2) {
        if (this.m_proxyId == Integer.MAX_VALUE) {
            return false;
        }
        AABB aabb = (AABB)tlAabb.get();
        this.computeSweptAABB(aabb, transform1, transform2);
        if (broadPhase.inRange(aabb)) {
            broadPhase.moveProxy(this.m_proxyId, aabb);
            return true;
        }
        return false;
    }

    public void refilterProxy(BroadPhase broadPhase, XForm transform) {
        if (this.m_proxyId == Integer.MAX_VALUE) {
            return;
        }
        broadPhase.destroyProxy(this.m_proxyId);
        AABB aabb = new AABB();
        this.computeAABB(aabb, transform);
        boolean inRange = broadPhase.inRange(aabb);
        this.m_proxyId = inRange ? broadPhase.createProxy(aabb, this) : Integer.MAX_VALUE;
    }

    public static Shape create(ShapeDef def) {
        if (def.type == ShapeType.CIRCLE_SHAPE) {
            return new CircleShape(def);
        }
        if (def.type == ShapeType.POLYGON_SHAPE) {
            return new PolygonShape(def);
        }
        if (def.type == ShapeType.POINT_SHAPE) {
            return new PointShape(def);
        }
        assert (false);
        return null;
    }

    public static void destroy(Shape s) {
        if (s.getType() == ShapeType.EDGE_SHAPE) {
            EdgeShape edge = (EdgeShape)s;
            if (edge.m_nextEdge != null) {
                edge.m_nextEdge.m_prevEdge = null;
            }
            if (edge.m_prevEdge != null) {
                edge.m_prevEdge.m_nextEdge = null;
            }
        }
        s.destructor();
    }

    public void destructor() {
        assert (this.m_proxyId == Integer.MAX_VALUE);
    }

    public void createProxy(BroadPhase broadPhase, XForm transform) {
        assert (this.m_proxyId == Integer.MAX_VALUE);
        AABB aabb = new AABB();
        this.computeAABB(aabb, transform);
        boolean inRange = broadPhase.inRange(aabb);
        assert (inRange);
        this.m_proxyId = inRange ? broadPhase.createProxy(aabb, this) : Integer.MAX_VALUE;
    }

    public void destroyProxy(BroadPhase broadPhase) {
        if (this.m_proxyId != Integer.MAX_VALUE) {
            broadPhase.destroyProxy(this.m_proxyId);
            this.m_proxyId = Integer.MAX_VALUE;
        }
    }

    public float computeSubmergedArea(Vec2 normal, float offset, Vec2 c) {
        return this.computeSubmergedArea(normal, offset, this.m_body.getXForm(), c);
    }

    public float computeSubmergedArea(Vec2 normal, float offset, XForm form, Vec2 c) {
        return 0.0f;
    }

    public float getDensity() {
        return this.m_density;
    }

    public Set<Shape> getShapesInContact() {
        ContactEdge curr = this.m_body.getContactList();
        HashSet<Shape> touching = new HashSet<Shape>();
        while (curr != null) {
            if (curr.contact.m_shape1 == this) {
                touching.add(curr.contact.m_shape2);
            } else if (curr.contact.m_shape2 == this) {
                touching.add(curr.contact.m_shape1);
            }
            curr = curr.next;
        }
        return touching;
    }

    public Set<Contact> getContacts() {
        ContactEdge curr = this.m_body.getContactList();
        HashSet<Contact> contacts = new HashSet<Contact>();
        while (curr != null) {
            if (curr.contact.getManifoldCount() > 0) {
                if (curr.contact.m_shape1 == this) {
                    contacts.add(curr.contact);
                } else if (curr.contact.m_shape2 == this) {
                    contacts.add(curr.contact);
                }
            }
            curr = curr.next;
        }
        return contacts;
    }

    public String toString() {
        return "shape:" + (this.m_type == null ? "unknown" : this.m_type.name()) + "_uid=" + this.uid;
    }
}

