/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SegmentCollide;
import org.jbox2d.collision.shapes.PointDef;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.pooling.TLVec2;

public class PointShape
extends Shape {
    public final Vec2 m_localPosition;
    public float m_mass;
    private static final TLVec2 tlP = new TLVec2();
    private static final TLVec2 tlSwept1 = new TLVec2();
    private static final TLVec2 tlSwept2 = new TLVec2();
    private static final TLVec2 tlS = new TLVec2();
    private static final TLVec2 tlPosition = new TLVec2();
    private static final TLVec2 tlR = new TLVec2();

    public PointShape(ShapeDef def) {
        super(def);
        assert (def.type == ShapeType.POINT_SHAPE);
        PointDef pointDef = (PointDef)def;
        this.m_type = ShapeType.POINT_SHAPE;
        this.m_localPosition = pointDef.localPosition.clone();
        this.m_mass = pointDef.mass;
    }

    @Override
    public void computeAABB(AABB aabb, XForm transform) {
        Vec2 p = (Vec2)tlP.get();
        Mat22.mulToOut(transform.R, this.m_localPosition, p);
        p.add(transform.position);
        aabb.lowerBound.set(p.x - 1.1920929E-7f, p.y - 1.1920929E-7f);
        aabb.upperBound.set(p.x + 1.1920929E-7f, p.y + 1.1920929E-7f);
    }

    @Override
    public void computeMass(MassData massData) {
        massData.mass = this.m_mass;
        massData.center.set(this.m_localPosition);
        massData.I = 0.0f;
    }

    @Override
    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        Vec2 sweptP1 = (Vec2)tlSwept1.get();
        Vec2 sweptP2 = (Vec2)tlSwept2.get();
        Mat22.mulToOut(transform2.R, this.m_localPosition, sweptP1);
        Mat22.mulToOut(transform2.R, this.m_localPosition, sweptP2);
        Vec2.minToOut(sweptP1, sweptP2, aabb.lowerBound);
        Vec2.maxToOut(sweptP1, sweptP2, aabb.upperBound);
        aabb.lowerBound.x -= 1.1920929E-7f;
        aabb.lowerBound.y -= 1.1920929E-7f;
        aabb.upperBound.x += 1.1920929E-7f;
        aabb.upperBound.y += 1.1920929E-7f;
    }

    @Override
    public boolean testPoint(XForm xf, Vec2 p) {
        return false;
    }

    @Override
    public SegmentCollide testSegment(XForm xf, RaycastResult out, Segment segment, float maxLambda) {
        Vec2 position = (Vec2)tlPosition.get();
        Vec2 s = (Vec2)tlS.get();
        Mat22.mulToOut(xf.R, this.m_localPosition, position);
        position.addLocal(xf.position);
        s.set(segment.p1);
        s.subLocal(position);
        float b = Vec2.dot(s, s);
        if (b < 0.0f) {
            return SegmentCollide.STARTS_INSIDE_COLLIDE;
        }
        Vec2 r = (Vec2)tlR.get();
        r.set(segment.p2).subLocal(segment.p1);
        float c = Vec2.dot(s, r);
        float rr = Vec2.dot(r, r);
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return SegmentCollide.MISS_COLLIDE;
        }
        float a = -(c + MathUtils.sqrt(sigma));
        if (0.0f <= a && a <= maxLambda * rr) {
            out.lambda = a /= rr;
            out.normal.set(r).mulLocal(a).addLocal(s);
            out.normal.normalize();
            return SegmentCollide.HIT_COLLIDE;
        }
        return SegmentCollide.MISS_COLLIDE;
    }

    @Override
    public void updateSweepRadius(Vec2 center) {
        float dx = this.m_localPosition.x - center.x;
        float dy = this.m_localPosition.y - center.y;
        this.m_sweepRadius = MathUtils.sqrt(dx * dx + dy * dy) - 0.04f;
    }

    public Vec2 getLocalPosition() {
        return this.m_localPosition.clone();
    }

    public Vec2 getMemberLocalPosition() {
        return this.m_localPosition;
    }

    public float getMass() {
        return this.m_mass;
    }
}

