/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SegmentCollide;
import org.jbox2d.collision.SupportsGenericDistance;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.pooling.TLVec2;

public class EdgeShape
extends Shape
implements SupportsGenericDistance {
    private final Vec2 m_v1;
    private final Vec2 m_v2;
    private final Vec2 m_coreV1;
    private final Vec2 m_coreV2;
    private final float m_length;
    private final Vec2 m_normal;
    private final Vec2 m_direction;
    private final Vec2 m_cornerDir1;
    private final Vec2 m_cornerDir2;
    private boolean m_cornerConvex1;
    private boolean m_cornerConvex2;
    EdgeShape m_nextEdge;
    EdgeShape m_prevEdge;
    private static final TLVec2 tlR = new TLVec2();
    private static final TLVec2 tlV1 = new TLVec2();
    private static final TLVec2 tlD = new TLVec2();
    private static final TLVec2 tlN = new TLVec2();
    private static final TLVec2 tlB = new TLVec2();
    private static final TLVec2 tlV2 = new TLVec2();
    private static final TLVec2 tlSwept1 = new TLVec2();
    private static final TLVec2 tlSwept2 = new TLVec2();
    private static final TLVec2 tlSwept3 = new TLVec2();
    private static final TLVec2 tlSwept4 = new TLVec2();
    private static final TLVec2 tlSupportV1 = new TLVec2();
    private static final TLVec2 tlSupportV2 = new TLVec2();
    private static final TLVec2 tlV0 = new TLVec2();
    private static final TLVec2 tlTemp = new TLVec2();
    private static final TLVec2 tlE1 = new TLVec2();
    private static final TLVec2 tlE2 = new TLVec2();

    public EdgeShape(Vec2 v1, Vec2 v2, ShapeDef def) {
        super(def);
        assert (def.type == ShapeType.EDGE_SHAPE);
        this.m_type = ShapeType.EDGE_SHAPE;
        this.m_prevEdge = null;
        this.m_nextEdge = null;
        this.m_v1 = v1;
        this.m_v2 = v2;
        this.m_direction = this.m_v2.sub(this.m_v1);
        this.m_length = this.m_direction.normalize();
        this.m_normal = new Vec2(this.m_direction.y, -this.m_direction.x);
        this.m_coreV1 = this.m_normal.sub(this.m_direction).mulLocal(-0.04f).addLocal(this.m_v1);
        this.m_coreV2 = this.m_normal.add(this.m_direction).mulLocal(-0.04f).addLocal(this.m_v2);
        this.m_cornerDir1 = this.m_normal.clone();
        this.m_cornerDir2 = this.m_normal.mul(-1.0f);
    }

    @Override
    public void updateSweepRadius(Vec2 center) {
        float dx = this.m_coreV1.x - center.x;
        float dy = this.m_coreV1.y - center.y;
        float d1 = dx * dx + dy * dy;
        float dx2 = this.m_coreV2.x - center.x;
        float dy2 = this.m_coreV2.y - center.y;
        float d2 = dx2 * dx2 + dy2 * dy2;
        this.m_sweepRadius = MathUtils.sqrt(d1 > d2 ? d1 : d2);
    }

    @Override
    public boolean testPoint(XForm transform, Vec2 p) {
        return false;
    }

    @Override
    public SegmentCollide testSegment(XForm xf, RaycastResult out, Segment segment, float maxLambda) {
        Vec2 r = (Vec2)tlR.get();
        Vec2 v1 = (Vec2)tlV1.get();
        Vec2 d = (Vec2)tlD.get();
        Vec2 n = (Vec2)tlN.get();
        Vec2 b = (Vec2)tlB.get();
        r.set(segment.p2).subLocal(segment.p1);
        XForm.mulToOut(xf, this.m_v1, v1);
        XForm.mulToOut(xf, this.m_v2, d);
        d.subLocal(v1);
        Vec2.crossToOut(d, 1.0f, n);
        float k_slop = 1.1920929E-5f;
        float denom = -Vec2.dot(r, n);
        if (denom > 1.1920929E-5f) {
            float mu2;
            b.set(segment.p1).subLocal(v1);
            float a = Vec2.dot(b, n);
            if (0.0f <= a && a <= maxLambda * denom && -1.1920929E-5f * denom <= (mu2 = -r.x * b.y + r.y * b.x) && mu2 <= denom * 1.0000119f) {
                n.normalize();
                out.lambda = a /= denom;
                out.normal.set(n);
                return SegmentCollide.HIT_COLLIDE;
            }
        }
        return SegmentCollide.MISS_COLLIDE;
    }

    @Override
    public void computeAABB(AABB aabb, XForm transform) {
        XForm.mulToOut(transform, this.m_v1, aabb.lowerBound);
        Vec2 v2 = (Vec2)tlV2.get();
        XForm.mulToOut(transform, this.m_v2, v2);
        Vec2.maxToOut(aabb.lowerBound, v2, aabb.upperBound);
        Vec2.minToOut(aabb.lowerBound, v2, aabb.lowerBound);
    }

    @Override
    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        Vec2 sweptV1 = (Vec2)tlSwept1.get();
        Vec2 sweptV2 = (Vec2)tlSwept2.get();
        Vec2 sweptV3 = (Vec2)tlSwept3.get();
        Vec2 sweptV4 = (Vec2)tlSwept4.get();
        XForm.mulToOut(transform1, this.m_v1, sweptV1);
        XForm.mulToOut(transform1, this.m_v2, sweptV2);
        XForm.mulToOut(transform2, this.m_v1, sweptV3);
        XForm.mulToOut(transform2, this.m_v2, sweptV4);
        Vec2.minToOut(sweptV1, sweptV2, aabb.lowerBound);
        Vec2.minToOut(aabb.lowerBound, sweptV3, aabb.lowerBound);
        Vec2.minToOut(aabb.lowerBound, sweptV4, aabb.lowerBound);
        Vec2.maxToOut(sweptV1, sweptV2, aabb.upperBound);
        Vec2.maxToOut(aabb.upperBound, sweptV3, aabb.upperBound);
        Vec2.maxToOut(aabb.upperBound, sweptV4, aabb.upperBound);
    }

    @Override
    public void computeMass(MassData massData) {
        massData.mass = 0.0f;
        massData.center.set(this.m_v1);
        massData.I = 0.0f;
    }

    @Override
    public void support(Vec2 dest, XForm xf, Vec2 d) {
        Vec2 supportV1 = (Vec2)tlSupportV1.get();
        Vec2 supportV2 = (Vec2)tlSupportV2.get();
        XForm.mulToOut(xf, this.m_coreV1, supportV1);
        XForm.mulToOut(xf, this.m_coreV2, supportV2);
        dest.set(Vec2.dot(supportV1, d) > Vec2.dot(supportV2, d) ? supportV1 : supportV2);
    }

    public void setPrevEdge(EdgeShape edge, Vec2 core, Vec2 cornerDir, boolean convex) {
        this.m_prevEdge = edge;
        this.m_coreV1.set(core);
        this.m_cornerDir1.set(cornerDir);
        this.m_cornerConvex1 = convex;
    }

    public void setNextEdge(EdgeShape edge, Vec2 core, Vec2 cornerDir, boolean convex) {
        this.m_nextEdge = edge;
        this.m_coreV2.set(core);
        this.m_cornerDir2.set(cornerDir);
        this.m_cornerConvex2 = convex;
    }

    public float getLength() {
        return this.m_length;
    }

    public Vec2 getVertex1() {
        return this.m_v1;
    }

    public Vec2 getVertex2() {
        return this.m_v2;
    }

    public Vec2 getCoreVertex1() {
        return this.m_coreV1;
    }

    public Vec2 getCoreVertex2() {
        return this.m_coreV2;
    }

    public Vec2 getNormalVector() {
        return this.m_normal;
    }

    public Vec2 getDirectionVector() {
        return this.m_direction;
    }

    public Vec2 getCorner1Vector() {
        return this.m_cornerDir1;
    }

    public Vec2 getCorner2Vector() {
        return this.m_cornerDir2;
    }

    public EdgeShape getNextEdge() {
        return this.m_nextEdge;
    }

    public EdgeShape getPrevEdge() {
        return this.m_prevEdge;
    }

    @Override
    public void getFirstVertexToOut(XForm xf, Vec2 out) {
        XForm.mulToOut(xf, this.m_coreV1, out);
    }

    public boolean corner1IsConvex() {
        return this.m_cornerConvex1;
    }

    public boolean corner2IsConvex() {
        return this.m_cornerConvex2;
    }

    @Override
    public float computeSubmergedArea(Vec2 normal, float offset, XForm xf, Vec2 c) {
        Vec2 v0 = (Vec2)tlV0.get();
        Vec2 v1 = (Vec2)tlV1.get();
        Vec2 v2 = (Vec2)tlV2.get();
        Vec2 temp = (Vec2)tlTemp.get();
        v0.set(normal).mul(offset);
        XForm.mulToOut(xf, this.m_v1, v1);
        XForm.mulToOut(xf, this.m_v2, v2);
        float d1 = Vec2.dot(normal, v1) - offset;
        float d2 = Vec2.dot(normal, v2) - offset;
        if (d1 > 0.0f) {
            if (d2 > 0.0f) {
                return 0.0f;
            }
            temp.set(v2).mulLocal(d1 / (d1 - d2));
            v1.mulLocal(-d2 / (d1 - d2)).addLocal(temp);
        } else if (d2 > 0.0f) {
            temp.set(v1).mulLocal(-d2 / (d1 - d2));
            v2.mulLocal(d1 / (d1 - d2)).addLocal(temp);
        }
        Vec2 e1 = (Vec2)tlE1.get();
        Vec2 e2 = (Vec2)tlE2.get();
        float k_inv3 = 0.33333334f;
        c.x = k_inv3 * (v0.x + v1.x + v2.x);
        c.y = k_inv3 * (v0.y + v1.y + v2.y);
        e1.set(v1).subLocal(v0);
        e2.set(v2).subLocal(v0);
        return 0.5f * Vec2.cross(e1, e2);
    }
}

