/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.MaxSeparation;
import org.jbox2d.collision.shapes.PointShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class CollidePoly {
    private final Vec2 normal1World = new Vec2();
    private Vec2 dLocal1 = new Vec2();
    private Vec2 mulTemp = new Vec2();
    private Vec2 normal1 = new Vec2();
    private final Vec2 colPPc = new Vec2();
    private final Vec2 colPPcLocal = new Vec2();
    private final Vec2 colPPsub = new Vec2();
    private final Vec2 colPPe = new Vec2();
    private final Vec2 colPPp = new Vec2();
    private final Vec2 colPPd = new Vec2();
    private final Vec2 PEv1 = new Vec2();
    private final Vec2 PEv2 = new Vec2();
    private final Vec2 PEn = new Vec2();
    private final Vec2 PEv1Local = new Vec2();
    private final Vec2 PEv2Local = new Vec2();
    private final Vec2 PEnLocal = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 temp2 = new Vec2();
    private final Vec2 sideNormal = new Vec2();
    private final Vec2 frontNormal = new Vec2();
    private final XForm p_xf1 = new XForm();
    private final XForm p_xf2 = new XForm();

    public final int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vec2 normal, float offset) {
        int numOut = 0;
        float distance0 = Vec2.dot(normal, vIn[0].v) - offset;
        float distance1 = Vec2.dot(normal, vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut] = new ClipVertex();
            vOut[numOut].id.set(vIn[0].id);
            vOut[numOut++].v.set(vIn[0].v);
        }
        if (distance1 <= 0.0f) {
            vOut[numOut] = new ClipVertex();
            vOut[numOut].id.set(vIn[1].id);
            vOut[numOut++].v.set(vIn[1].v);
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut] = new ClipVertex();
            vOut[numOut].v.x = vIn[0].v.x + interp * (vIn[1].v.x - vIn[0].v.x);
            vOut[numOut].v.y = vIn[0].v.y + interp * (vIn[1].v.y - vIn[0].v.y);
            if (distance0 > 0.0f) {
                vOut[numOut].id.set(vIn[0].id);
            } else {
                vOut[numOut].id.set(vIn[1].id);
            }
            ++numOut;
        }
        return numOut;
    }

    public final float edgeSeparation(PolygonShape poly1, XForm xf1, int edge1, PolygonShape poly2, XForm xf2) {
        int count1 = poly1.getVertexCount();
        Vec2[] vertices1 = poly1.getVertices();
        Vec2[] normals1 = poly1.getNormals();
        int count2 = poly2.getVertexCount();
        Vec2[] vertices2 = poly2.getVertices();
        assert (edge1 >= 0 && edge1 < count1);
        Mat22.mulToOut(xf1.R, normals1[edge1], this.normal1World);
        float normal1x = Vec2.dot(this.normal1World, xf2.R.col1);
        float normal1y = Vec2.dot(this.normal1World, xf2.R.col2);
        int index = 0;
        float minDot = Float.MAX_VALUE;
        int i = 0;
        while (i < count2) {
            float dot = vertices2[i].x * normal1x + vertices2[i].y * normal1y;
            if (dot < minDot) {
                minDot = dot;
                index = i;
            }
            ++i;
        }
        Vec2 v = vertices1[edge1];
        float v1x = xf1.position.x + xf1.R.col1.x * v.x + xf1.R.col2.x * v.y;
        float v1y = xf1.position.y + xf1.R.col1.y * v.x + xf1.R.col2.y * v.y;
        Vec2 v3 = vertices2[index];
        float v2x = xf2.position.x + xf2.R.col1.x * v3.x + xf2.R.col2.x * v3.y;
        float v2y = xf2.position.y + xf2.R.col1.y * v3.x + xf2.R.col2.y * v3.y;
        float separation = (v2x - v1x) * this.normal1World.x + (v2y - v1y) * this.normal1World.y;
        return separation;
    }

    public final MaxSeparation findMaxSeparation(PolygonShape poly1, XForm xf1, PolygonShape poly2, XForm xf2) {
        float bestSeparation;
        int bestEdge;
        int increment;
        MaxSeparation separation = new MaxSeparation();
        int count1 = poly1.getVertexCount();
        Vec2[] normals1 = poly1.getNormals();
        Vec2 v = poly1.getCentroid();
        Vec2 v1 = poly2.getCentroid();
        float dx = xf2.position.x + xf2.R.col1.x * v1.x + xf2.R.col2.x * v1.y - (xf1.position.x + xf1.R.col1.x * v.x + xf1.R.col2.x * v.y);
        float dy = xf2.position.y + xf2.R.col1.y * v1.x + xf2.R.col2.y * v1.y - (xf1.position.y + xf1.R.col1.y * v.x + xf1.R.col2.y * v.y);
        Vec2 b = xf1.R.col1;
        Vec2 b1 = xf1.R.col2;
        this.dLocal1.x = dx * b.x + dy * b.y;
        this.dLocal1.y = dx * b1.x + dy * b1.y;
        int edge = 0;
        float maxDot = -3.4028235E38f;
        int i = 0;
        while (i < count1) {
            float dot = Vec2.dot(normals1[i], this.dLocal1);
            if (dot > maxDot) {
                maxDot = dot;
                edge = i;
            }
            ++i;
        }
        float s = this.edgeSeparation(poly1, xf1, edge, poly2, xf2);
        if (s > 0.0f) {
            separation.bestSeparation = s;
            return separation;
        }
        int prevEdge = edge - 1 >= 0 ? edge - 1 : count1 - 1;
        float sPrev = this.edgeSeparation(poly1, xf1, prevEdge, poly2, xf2);
        if (sPrev > 0.0f) {
            separation.bestSeparation = sPrev;
            return separation;
        }
        int nextEdge = edge + 1 < count1 ? edge + 1 : 0;
        float sNext = this.edgeSeparation(poly1, xf1, nextEdge, poly2, xf2);
        if (sNext > 0.0f) {
            separation.bestSeparation = sNext;
            return separation;
        }
        if (sPrev > s && sPrev > sNext) {
            increment = -1;
            bestEdge = prevEdge;
            bestSeparation = sPrev;
        } else if (sNext > s) {
            increment = 1;
            bestEdge = nextEdge;
            bestSeparation = sNext;
        } else {
            separation.bestFaceIndex = edge;
            separation.bestSeparation = s;
            return separation;
        }
        while (true) {
            if ((s = this.edgeSeparation(poly1, xf1, edge = increment == -1 ? (bestEdge - 1 >= 0 ? bestEdge - 1 : count1 - 1) : (bestEdge + 1 < count1 ? bestEdge + 1 : 0), poly2, xf2)) > 0.0f) {
                separation.bestSeparation = s;
                return separation;
            }
            if (!(s > bestSeparation)) break;
            bestEdge = edge;
            bestSeparation = s;
        }
        separation.bestFaceIndex = bestEdge;
        separation.bestSeparation = bestSeparation;
        return separation;
    }

    public final void findIncidentEdge(ClipVertex[] c, PolygonShape poly1, XForm xf1, int edge1, PolygonShape poly2, XForm xf2) {
        int count1 = poly1.getVertexCount();
        Vec2[] normals1 = poly1.getNormals();
        int count2 = poly2.getVertexCount();
        Vec2[] vertices2 = poly2.getVertices();
        Vec2[] normals2 = poly2.getNormals();
        assert (edge1 >= 0 && edge1 < count1);
        Mat22.mulToOut(xf1.R, normals1[edge1], this.mulTemp);
        Mat22.mulTransToOut(xf2.R, this.mulTemp, this.normal1);
        int index = 0;
        float minDot = Float.MAX_VALUE;
        int i = 0;
        while (i < count2) {
            float dot = Vec2.dot(this.normal1, normals2[i]);
            if (dot < minDot) {
                minDot = dot;
                index = i;
            }
            ++i;
        }
        int i1 = index;
        int i2 = i1 + 1 < count2 ? i1 + 1 : 0;
        c[0] = new ClipVertex();
        c[1] = new ClipVertex();
        XForm.mulToOut(xf2, vertices2[i1], c[0].v);
        c[0].id.features.referenceEdge = edge1;
        c[0].id.features.incidentEdge = i1;
        c[0].id.features.incidentVertex = 0;
        XForm.mulToOut(xf2, vertices2[i2], c[1].v);
        c[1].id.features.referenceEdge = edge1;
        c[1].id.features.incidentEdge = i2;
        c[1].id.features.incidentVertex = 1;
    }

    public final void collidePolygons(Manifold manif, PolygonShape polyA, XForm xfA, PolygonShape polyB, XForm xfB) {
        int flip;
        int edge1;
        PolygonShape poly2;
        PolygonShape poly1;
        manif.pointCount = 0;
        MaxSeparation sepA = this.findMaxSeparation(polyA, xfA, polyB, xfB);
        if (sepA.bestSeparation > 0.0f) {
            return;
        }
        MaxSeparation sepB = this.findMaxSeparation(polyB, xfB, polyA, xfA);
        if (sepB.bestSeparation > 0.0f) {
            return;
        }
        XForm xf1 = this.p_xf1;
        XForm xf2 = this.p_xf2;
        float k_relativeTol = 0.98f;
        float k_absoluteTol = 0.001f;
        if (sepB.bestSeparation > 0.98f * sepA.bestSeparation + 0.001f) {
            poly1 = polyB;
            poly2 = polyA;
            xf1.set(xfB);
            xf2.set(xfA);
            edge1 = sepB.bestFaceIndex;
            flip = 1;
        } else {
            poly1 = polyA;
            poly2 = polyB;
            xf1.set(xfA);
            xf2.set(xfB);
            edge1 = sepA.bestFaceIndex;
            flip = 0;
        }
        ClipVertex[] incidentEdge = new ClipVertex[2];
        this.findIncidentEdge(incidentEdge, poly1, xf1, edge1, poly2, xf2);
        int count1 = poly1.getVertexCount();
        Vec2[] vertices1 = poly1.getVertices();
        Vec2 v11 = vertices1[edge1];
        Vec2 v12 = edge1 + 1 < count1 ? vertices1[edge1 + 1] : vertices1[0];
        float v1x = v12.x - v11.x;
        float v1y = v12.y - v11.y;
        this.sideNormal.set(xf1.R.col1.x * v1x + xf1.R.col2.x * v1y, xf1.R.col1.y * v1x + xf1.R.col2.y * v1y);
        this.sideNormal.normalize();
        this.frontNormal.set(this.sideNormal.y, -this.sideNormal.x);
        float v11x = xf1.position.x + xf1.R.col1.x * v11.x + xf1.R.col2.x * v11.y;
        float v11y = xf1.position.y + xf1.R.col1.y * v11.x + xf1.R.col2.y * v11.y;
        float v12x = xf1.position.x + xf1.R.col1.x * v12.x + xf1.R.col2.x * v12.y;
        float v12y = xf1.position.y + xf1.R.col1.y * v12.x + xf1.R.col2.y * v12.y;
        float frontOffset = this.frontNormal.x * v11x + this.frontNormal.y * v11y;
        float sideOffset1 = -(this.sideNormal.x * v11x + this.sideNormal.y * v11y);
        float sideOffset2 = this.sideNormal.x * v12x + this.sideNormal.y * v12y;
        ClipVertex[] clipPoints1 = new ClipVertex[2];
        ClipVertex[] clipPoints2 = new ClipVertex[2];
        int np = this.clipSegmentToLine(clipPoints1, incidentEdge, this.sideNormal.negate(), sideOffset1);
        if (np < 2) {
            return;
        }
        np = this.clipSegmentToLine(clipPoints2, clipPoints1, this.sideNormal, sideOffset2);
        if (np < 2) {
            return;
        }
        manif.normal.set(this.frontNormal);
        if (flip != 0) {
            manif.normal.negateLocal();
        }
        int pointCount = 0;
        int i = 0;
        while (i < 2) {
            float separation = Vec2.dot(this.frontNormal, clipPoints2[i].v) - frontOffset;
            if (separation <= 0.0f) {
                ManifoldPoint cp = manif.points[pointCount];
                cp.separation = separation;
                Vec2 vec = clipPoints2[i].v;
                float u1x = vec.x - xfA.position.x;
                float u1y = vec.y - xfA.position.y;
                cp.localPoint1.x = u1x * xfA.R.col1.x + u1y * xfA.R.col1.y;
                cp.localPoint1.y = u1x * xfA.R.col2.x + u1y * xfA.R.col2.y;
                u1x = vec.x - xfB.position.x;
                u1y = vec.y - xfB.position.y;
                cp.localPoint2.x = u1x * xfB.R.col1.x + u1y * xfB.R.col1.y;
                cp.localPoint2.y = u1x * xfB.R.col2.x + u1y * xfB.R.col2.y;
                cp.id.set(clipPoints2[i].id);
                cp.id.features.flip = flip;
                ++pointCount;
            }
            ++i;
        }
        manif.pointCount = pointCount;
    }

    public final void collidePolygonAndPoint(Manifold manifold, PolygonShape polygon, XForm xf1, PointShape point, XForm xf2) {
        manifold.pointCount = 0;
        XForm.mulToOut(xf2, point.getMemberLocalPosition(), this.colPPc);
        XForm.mulTransToOut(xf1, this.colPPc, this.colPPcLocal);
        int normalIndex = 0;
        float separation = -3.4028235E38f;
        int vertexCount = polygon.getVertexCount();
        Vec2[] vertices = polygon.getVertices();
        Vec2[] normals = polygon.getNormals();
        int i = 0;
        while (i < vertexCount) {
            this.colPPsub.set(this.colPPcLocal);
            this.colPPsub.subLocal(vertices[i]);
            float s = Vec2.dot(normals[i], this.colPPsub);
            if (s > 0.0f) {
                return;
            }
            if (s > separation) {
                normalIndex = i;
                separation = s;
            }
            ++i;
        }
        if (separation < 1.1920929E-7f) {
            manifold.pointCount = 1;
            Mat22.mulToOut(xf1.R, normals[normalIndex], manifold.normal);
            manifold.points[0].id.features.incidentEdge = normalIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
            manifold.points[0].id.features.referenceEdge = 0;
            manifold.points[0].id.features.flip = 0;
            Vec2 position = this.colPPc;
            XForm.mulTransToOut(xf1, position, manifold.points[0].localPoint1);
            XForm.mulTransToOut(xf2, position, manifold.points[0].localPoint2);
            manifold.points[0].separation = separation;
            return;
        }
        int vertIndex1 = normalIndex;
        int vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
        this.colPPe.set(vertices[vertIndex2]);
        this.colPPe.subLocal(vertices[vertIndex1]);
        float length = this.colPPe.normalize();
        assert (length > 1.1920929E-7f);
        this.colPPsub.set(this.colPPcLocal);
        this.colPPsub.subLocal(vertices[vertIndex1]);
        float u = Vec2.dot(this.colPPsub, this.colPPe);
        this.colPPp.setZero();
        if (u <= 0.0f) {
            this.colPPp.set(vertices[vertIndex1]);
            manifold.points[0].id.features.incidentEdge = Integer.MAX_VALUE;
            manifold.points[0].id.features.incidentVertex = vertIndex1;
        } else if (u >= length) {
            this.colPPp.set(vertices[vertIndex2]);
            manifold.points[0].id.features.incidentEdge = Integer.MAX_VALUE;
            manifold.points[0].id.features.incidentVertex = vertIndex2;
        } else {
            this.colPPp.set(vertices[vertIndex1]);
            this.colPPp.x += u * this.colPPe.x;
            this.colPPp.y += u * this.colPPe.y;
            manifold.points[0].id.features.incidentEdge = normalIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
        }
        this.colPPd.set(this.colPPcLocal);
        this.colPPd.subLocal(this.colPPp);
        float dist = this.colPPd.normalize();
        if (dist > 0.0f) {
            return;
        }
        manifold.pointCount = 1;
        Mat22.mulToOut(xf1.R, this.colPPd, manifold.normal);
        Vec2 position = this.colPPc;
        XForm.mulTransToOut(xf1, position, manifold.points[0].localPoint1);
        XForm.mulTransToOut(xf2, position, manifold.points[0].localPoint2);
        manifold.points[0].separation = dist;
        manifold.points[0].id.features.referenceEdge = 0;
        manifold.points[0].id.features.flip = 0;
    }

    public final void collidePolyAndEdge(Manifold manifold, PolygonShape polygon, XForm xf1, EdgeShape edge, XForm xf2) {
        float ratio;
        manifold.pointCount = 0;
        XForm.mulToOut(xf2, edge.getVertex1(), this.PEv1);
        XForm.mulToOut(xf2, edge.getVertex2(), this.PEv2);
        Mat22.mulToOut(xf2.R, edge.getNormalVector(), this.PEn);
        XForm.mulTransToOut(xf1, this.PEv1, this.PEv1Local);
        XForm.mulTransToOut(xf1, this.PEv2, this.PEv2Local);
        Mat22.mulTransToOut(xf1.R, this.PEn, this.PEnLocal);
        int separationIndex1 = -1;
        float separationMax1 = -3.4028235E38f;
        int separationIndex2 = -1;
        float separationMax2 = -3.4028235E38f;
        float separationMax = -3.4028235E38f;
        boolean separationV1 = false;
        int separationIndex = -1;
        int vertexCount = polygon.getVertexCount();
        Vec2[] vertices = polygon.getVertices();
        Vec2[] normals = polygon.getNormals();
        int enterStartIndex = -1;
        int enterEndIndex = -1;
        int exitStartIndex = -1;
        int exitEndIndex = -1;
        float prevSepN = 0.0f;
        float nextSepN = 0.0f;
        float enterSepN = 0.0f;
        float exitSepN = 0.0f;
        float deepestSepN = Float.MAX_VALUE;
        this.temp.set(vertices[vertexCount - 1]);
        this.temp.subLocal(this.PEv1Local);
        prevSepN = Vec2.dot(this.temp, this.PEnLocal);
        int i = 0;
        while (i < vertexCount) {
            this.temp.set(this.PEv1Local);
            this.temp.subLocal(vertices[i]);
            float separation1 = Vec2.dot(this.temp, normals[i]);
            this.temp.set(this.PEv2Local);
            this.temp.subLocal(vertices[i]);
            float separation2 = Vec2.dot(this.temp, normals[i]);
            if (separation2 < separation1) {
                if (separation2 > separationMax) {
                    separationMax = separation2;
                    separationV1 = false;
                    separationIndex = i;
                }
            } else if (separation1 > separationMax) {
                separationMax = separation1;
                separationV1 = true;
                separationIndex = i;
            }
            if (separation1 > separationMax1) {
                separationMax1 = separation1;
                separationIndex1 = i;
            }
            if (separation2 > separationMax2) {
                separationMax2 = separation2;
                separationIndex2 = i;
            }
            this.temp.set(vertices[i]);
            this.temp.subLocal(this.PEv1Local);
            nextSepN = Vec2.dot(this.temp, this.PEnLocal);
            if (nextSepN >= 0.0f && prevSepN < 0.0f) {
                exitStartIndex = i == 0 ? vertexCount - 1 : i - 1;
                exitEndIndex = i;
                exitSepN = prevSepN;
            } else if (nextSepN < 0.0f && prevSepN >= 0.0f) {
                enterStartIndex = i == 0 ? vertexCount - 1 : i - 1;
                enterEndIndex = i;
                enterSepN = nextSepN;
            }
            if (nextSepN < deepestSepN) {
                deepestSepN = nextSepN;
            }
            prevSepN = nextSepN;
            ++i;
        }
        if (enterStartIndex == -1) {
            return;
        }
        if (separationMax > 0.0f) {
            return;
        }
        if ((separationV1 && edge.corner1IsConvex() || !separationV1 && edge.corner2IsConvex()) && separationMax > deepestSepN + 0.005f) {
            if (separationV1) {
                Mat22.mulToOut(xf2.R, edge.getCorner1Vector(), this.temp);
                Mat22.mulTransToOut(xf1.R, this.temp, this.temp);
                if (Vec2.dot(normals[separationIndex1], this.temp) >= 0.0f) {
                    return;
                }
            } else {
                Mat22.mulToOut(xf2.R, edge.getCorner2Vector(), this.temp);
                Mat22.mulTransToOut(xf1.R, this.temp, this.temp);
                if (Vec2.dot(normals[separationIndex2], this.temp) <= 0.0f) {
                    return;
                }
            }
            manifold.pointCount = 1;
            Mat22.mulToOut(xf1.R, normals[separationIndex], manifold.normal);
            manifold.points[0].separation = separationMax;
            manifold.points[0].id.features.incidentEdge = separationIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
            manifold.points[0].id.features.referenceEdge = 0;
            manifold.points[0].id.features.flip = 0;
            if (separationV1) {
                manifold.points[0].localPoint1.set(this.PEv1Local);
                manifold.points[0].localPoint2.set(edge.getVertex1());
            } else {
                manifold.points[0].localPoint1.set(this.PEv2Local);
                manifold.points[0].localPoint2.set(edge.getVertex2());
            }
            return;
        }
        this.temp.set(this.PEn);
        this.temp.mulLocal(-1.0f);
        manifold.normal.set(this.temp);
        if (enterEndIndex == exitStartIndex) {
            manifold.pointCount = 1;
            manifold.points[0].id.features.incidentEdge = enterEndIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
            manifold.points[0].id.features.referenceEdge = 0;
            manifold.points[0].id.features.flip = 0;
            manifold.points[0].localPoint1.set(vertices[enterEndIndex]);
            XForm.mulTransToOut(xf2, XForm.mul(xf1, vertices[enterEndIndex]), manifold.points[0].localPoint2);
            manifold.points[0].separation = enterSepN;
            return;
        }
        manifold.pointCount = 2;
        Vec2.crossToOut(this.PEnLocal, -1.0f, this.temp);
        this.temp2.set(vertices[enterEndIndex]);
        this.temp2.subLocal(this.PEv1Local);
        float dirProj1 = Vec2.dot(this.temp, this.temp2);
        float dirProj2 = 0.0f;
        this.temp2.set(vertices[exitStartIndex]);
        this.temp2.subLocal(this.PEv1Local);
        int n = exitEndIndex = enterEndIndex == vertexCount - 1 ? 0 : enterEndIndex + 1;
        if (exitEndIndex != exitStartIndex) {
            exitStartIndex = exitEndIndex;
            exitSepN = Vec2.dot(this.PEnLocal, this.temp2);
        }
        dirProj2 = Vec2.dot(this.temp, this.temp2);
        manifold.points[0].id.features.incidentEdge = enterEndIndex;
        manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
        manifold.points[0].id.features.referenceEdge = 0;
        manifold.points[0].id.features.flip = 0;
        if (dirProj1 > edge.getLength()) {
            manifold.points[0].localPoint1.set(this.PEv2Local);
            manifold.points[0].localPoint2.set(edge.getVertex2());
            ratio = (edge.getLength() - dirProj2) / (dirProj1 - dirProj2);
            manifold.points[0].separation = ratio > 1.1920929E-5f && ratio < 1.0f ? exitSepN * (1.0f - ratio) + enterSepN * ratio : enterSepN;
        } else {
            manifold.points[0].localPoint1.set(vertices[enterEndIndex]);
            XForm.mulTransToOut(xf2, XForm.mul(xf1, vertices[enterEndIndex]), manifold.points[0].localPoint2);
            manifold.points[0].separation = enterSepN;
        }
        manifold.points[1].id.features.incidentEdge = exitStartIndex;
        manifold.points[1].id.features.incidentVertex = Integer.MAX_VALUE;
        manifold.points[1].id.features.referenceEdge = 0;
        manifold.points[1].id.features.flip = 0;
        if (dirProj2 < 0.0f) {
            manifold.points[1].localPoint1.set(this.PEv1Local);
            manifold.points[1].localPoint2.set(edge.getVertex1());
            ratio = -dirProj1 / (dirProj2 - dirProj1);
            manifold.points[1].separation = ratio > 1.1920929E-5f && ratio < 1.0f ? enterSepN * (1.0f - ratio) + exitSepN * ratio : exitSepN;
        } else {
            manifold.points[1].localPoint1.set(vertices[exitStartIndex]);
            XForm.mulTransToOut(xf2, XForm.mul(xf1, vertices[exitStartIndex]), manifold.points[1].localPoint2);
            manifold.points[1].separation = exitSepN;
        }
    }

    static class ClipVertex {
        public final Vec2 v = new Vec2();
        public final ContactID id = new ContactID();
    }
}

