/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SegmentCollide;
import org.jbox2d.collision.shapes.CircleDef;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.pooling.TLVec2;

public class CircleShape
extends Shape {
    public float m_radius;
    public final Vec2 m_localPosition;
    private static final TLVec2 tlCenter = new TLVec2();
    private static final TLVec2 tlS = new TLVec2();
    private static final TLVec2 tlPosition = new TLVec2();
    private static final TLVec2 tlR = new TLVec2();
    private static final TLVec2 tlP = new TLVec2();

    public CircleShape(ShapeDef def) {
        super(def);
        assert (def.type == ShapeType.CIRCLE_SHAPE);
        CircleDef circleDef = (CircleDef)def;
        this.m_type = ShapeType.CIRCLE_SHAPE;
        this.m_localPosition = circleDef.localPosition.clone();
        this.m_radius = circleDef.radius;
    }

    @Override
    public void updateSweepRadius(Vec2 center) {
        float dx = this.m_localPosition.x - center.x;
        float dy = this.m_localPosition.y - center.y;
        this.m_sweepRadius = MathUtils.sqrt(dx * dx + dy * dy) + this.m_radius - 0.04f;
    }

    @Override
    public boolean testPoint(XForm transform, Vec2 p) {
        Vec2 center = (Vec2)tlCenter.get();
        Mat22.mulToOut(transform.R, this.m_localPosition, center);
        center.addLocal(transform.position);
        Vec2 d = center.subLocal(p).negateLocal();
        boolean ret = Vec2.dot(d, d) <= this.m_radius * this.m_radius;
        return ret;
    }

    @Override
    public SegmentCollide testSegment(XForm xf, RaycastResult out, Segment segment, float maxLambda) {
        Vec2 position = (Vec2)tlPosition.get();
        Vec2 s = (Vec2)tlS.get();
        Mat22.mulToOut(xf.R, this.m_localPosition, position);
        position.addLocal(xf.position);
        s.set(segment.p1);
        s.subLocal(position);
        float b = Vec2.dot(s, s) - this.m_radius * this.m_radius;
        if (b < 0.0f) {
            return SegmentCollide.STARTS_INSIDE_COLLIDE;
        }
        Vec2 r = (Vec2)tlR.get();
        r.set(segment.p2).subLocal(segment.p1);
        float c = Vec2.dot(s, r);
        float rr = Vec2.dot(r, r);
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return SegmentCollide.MISS_COLLIDE;
        }
        float a = -(c + MathUtils.sqrt(sigma));
        if (0.0f <= a && a <= maxLambda * rr) {
            out.lambda = a /= rr;
            out.normal.set(r).mulLocal(a).addLocal(s);
            out.normal.normalize();
            return SegmentCollide.HIT_COLLIDE;
        }
        return SegmentCollide.MISS_COLLIDE;
    }

    @Override
    public void computeAABB(AABB aabb, XForm transform) {
        Vec2 p = (Vec2)tlP.get();
        Mat22.mulToOut(transform.R, this.m_localPosition, p);
        p.addLocal(transform.position);
        aabb.lowerBound.x = p.x - this.m_radius;
        aabb.lowerBound.y = p.y - this.m_radius;
        aabb.upperBound.x = p.x + this.m_radius;
        aabb.upperBound.y = p.y + this.m_radius;
    }

    @Override
    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        float p1x = transform1.position.x + transform1.R.col1.x * this.m_localPosition.x + transform1.R.col2.x * this.m_localPosition.y;
        float p1y = transform1.position.y + transform1.R.col1.y * this.m_localPosition.x + transform1.R.col2.y * this.m_localPosition.y;
        float p2x = transform2.position.x + transform2.R.col1.x * this.m_localPosition.x + transform2.R.col2.x * this.m_localPosition.y;
        float p2y = transform2.position.y + transform2.R.col1.y * this.m_localPosition.x + transform2.R.col2.y * this.m_localPosition.y;
        float lowerx = p1x < p2x ? p1x : p2x;
        float lowery = p1y < p2y ? p1y : p2y;
        float upperx = p1x > p2x ? p1x : p2x;
        float uppery = p1y > p2y ? p1y : p2y;
        aabb.lowerBound.x = lowerx - this.m_radius;
        aabb.lowerBound.y = lowery - this.m_radius;
        aabb.upperBound.x = upperx + this.m_radius;
        aabb.upperBound.y = uppery + this.m_radius;
    }

    @Override
    public void computeMass(MassData massData) {
        massData.mass = this.m_density * (float)Math.PI * this.m_radius * this.m_radius;
        massData.center.set(this.m_localPosition);
        massData.I = massData.mass * (0.5f * this.m_radius * this.m_radius + Vec2.dot(this.m_localPosition, this.m_localPosition));
    }

    public float getRadius() {
        return this.m_radius;
    }

    public Vec2 getLocalPosition() {
        return this.m_localPosition.clone();
    }

    public Vec2 getMemberLocalPosition() {
        return this.m_localPosition;
    }

    @Override
    public float computeSubmergedArea(Vec2 normal, float offset, XForm xf, Vec2 c) {
        Vec2 p = (Vec2)tlP.get();
        XForm.mulToOut(xf, this.m_localPosition, p);
        float l = -(Vec2.dot(normal, p) - offset);
        if (l < -this.m_radius + 1.1920929E-7f) {
            return 0.0f;
        }
        if (l > this.m_radius) {
            c.set(p);
            return (float)Math.PI * this.m_radius * this.m_radius;
        }
        float r2 = this.m_radius * this.m_radius;
        float l2 = l * l;
        float area = (float)((double)r2 * (Math.asin(l / this.m_radius) + 1.5707963705062866) + (double)(l * MathUtils.sqrt(r2 - l2)));
        float com = -0.6666667f * MathUtils.pow(r2 - l2, 1.5f) / area;
        c.x = p.x + normal.x * com;
        c.y = p.y + normal.y * com;
        return area;
    }
}

