/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.TLVec2;

public class Segment {
    public final Vec2 p1 = new Vec2();
    public final Vec2 p2 = new Vec2();
    private static final TLVec2 tlR = new TLVec2();
    private static final TLVec2 tlD = new TLVec2();
    private static final TLVec2 tlN = new TLVec2();
    private static final TLVec2 tlB = new TLVec2();

    public String toString() {
        return "p1: " + this.p1 + "; p2: " + this.p2;
    }

    public boolean testSegment(RaycastResult out, Segment segment, float maxLambda) {
        Vec2 s = segment.p1;
        Vec2 r = ((Vec2)tlR.get()).set(segment.p2);
        r.subLocal(s);
        Vec2 d = ((Vec2)tlD.get()).set(this.p2);
        d.subLocal(this.p1);
        Vec2 n = (Vec2)tlN.get();
        Vec2.crossToOut(d, 1.0f, n);
        Vec2 b = (Vec2)tlB.get();
        float k_slop = 1.1920929E-5f;
        float denom = -Vec2.dot(r, n);
        if (denom > k_slop) {
            float mu2;
            b.set(s);
            b.subLocal(this.p1);
            float a = Vec2.dot(b, n);
            if (0.0f <= a && a <= maxLambda * denom && -k_slop * denom <= (mu2 = -r.x * b.y + r.y * b.x) && mu2 <= denom * (1.0f + k_slop)) {
                n.normalize();
                out.lambda = a /= denom;
                out.normal.set(n);
                return true;
            }
        }
        return false;
    }
}

