var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/* Generated from Java with JSweet 2.2.0-SNAPSHOT - http://www.jsweet.org */
var org;
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Creates an AABB object using the given bounding
             * vertices.
             * @param {org.jbox2d.common.Vec2} lowerVertex the bottom left vertex of the bounding box
             * @param maxVertex the top right vertex of the bounding box
             * @param {org.jbox2d.common.Vec2} upperVertex
             * @class
             */
            var AABB = (function () {
                function AABB(lowerVertex, upperVertex) {
                    var _this = this;
                    if (((lowerVertex != null && lowerVertex instanceof org.jbox2d.common.Vec2) || lowerVertex === null) && ((upperVertex != null && upperVertex instanceof org.jbox2d.common.Vec2) || upperVertex === null)) {
                        var __args = arguments;
                        if (this.lowerBound === undefined)
                            this.lowerBound = null;
                        if (this.upperBound === undefined)
                            this.upperBound = null;
                        if (this.lowerBound === undefined)
                            this.lowerBound = null;
                        if (this.upperBound === undefined)
                            this.upperBound = null;
                        (function () {
                            _this.lowerBound = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(lowerVertex);
                            _this.upperBound = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(upperVertex);
                        })();
                    }
                    else if (((lowerVertex != null && lowerVertex instanceof org.jbox2d.collision.AABB) || lowerVertex === null) && upperVertex === undefined) {
                        var __args = arguments;
                        var copy = __args[0];
                        {
                            var __args_1 = arguments;
                            var lowerVertex_1 = copy.lowerBound;
                            var upperVertex_1 = copy.upperBound;
                            if (this.lowerBound === undefined)
                                this.lowerBound = null;
                            if (this.upperBound === undefined)
                                this.upperBound = null;
                            if (this.lowerBound === undefined)
                                this.lowerBound = null;
                            if (this.upperBound === undefined)
                                this.upperBound = null;
                            (function () {
                                _this.lowerBound = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(lowerVertex_1);
                                _this.upperBound = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(upperVertex_1);
                            })();
                        }
                    }
                    else if (lowerVertex === undefined && upperVertex === undefined) {
                        var __args = arguments;
                        if (this.lowerBound === undefined)
                            this.lowerBound = null;
                        if (this.upperBound === undefined)
                            this.upperBound = null;
                        if (this.lowerBound === undefined)
                            this.lowerBound = null;
                        if (this.upperBound === undefined)
                            this.upperBound = null;
                        (function () {
                            _this.lowerBound = new org.jbox2d.common.Vec2();
                            _this.upperBound = new org.jbox2d.common.Vec2();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * Sets this object from the given object
                 * @param {org.jbox2d.collision.AABB} aabb the object to copy from
                 * @return {org.jbox2d.collision.AABB}
                 */
                AABB.prototype.set = function (aabb) {
                    this.lowerBound.set$org_jbox2d_common_Vec2(aabb.lowerBound);
                    this.upperBound.set$org_jbox2d_common_Vec2(aabb.upperBound);
                    return this;
                };
                /**
                 * Verify that the bounds are sorted
                 * @return {boolean}
                 */
                AABB.prototype.isValid = function () {
                    var dx = Math.fround(this.upperBound.x - this.lowerBound.x);
                    var dy = Math.fround(this.upperBound.y - this.lowerBound.y);
                    if (!(dx >= 0.0 && dy >= 0)) {
                        return false;
                    }
                    return this.lowerBound.isValid() && this.upperBound.isValid();
                };
                /**
                 * Check if AABBs overlap. djm optimized
                 * @param {org.jbox2d.collision.AABB} box
                 * @return {boolean}
                 */
                AABB.prototype.testOverlap = function (box) {
                    var d1x = Math.fround(box.lowerBound.x - this.upperBound.x);
                    var d1y = Math.fround(box.lowerBound.y - this.upperBound.y);
                    var d2x = Math.fround(this.lowerBound.x - box.upperBound.x);
                    var d2y = Math.fround(this.lowerBound.y - box.upperBound.y);
                    if (d1x > 0.0 || d1y > 0.0 || d2x > 0.0 || d2y > 0.0) {
                        return false;
                    }
                    return true;
                };
                /**
                 *
                 * @return {string}
                 */
                AABB.prototype.toString = function () {
                    var s = "" + this.lowerBound + " -> " + this.upperBound;
                    return s;
                };
                return AABB;
            }());
            collision.AABB = AABB;
            AABB["__class"] = "org.jbox2d.collision.AABB";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Used in BroadPhase
             * @param {org.jbox2d.collision.Bound} b
             * @class
             */
            var Bound = (function () {
                function Bound(b) {
                    var _this = this;
                    if (((b != null && b instanceof org.jbox2d.collision.Bound) || b === null)) {
                        var __args = arguments;
                        if (this.value === undefined)
                            this.value = 0;
                        if (this.proxyId === undefined)
                            this.proxyId = 0;
                        if (this.stabbingCount === undefined)
                            this.stabbingCount = 0;
                        if (this.value === undefined)
                            this.value = 0;
                        if (this.proxyId === undefined)
                            this.proxyId = 0;
                        if (this.stabbingCount === undefined)
                            this.stabbingCount = 0;
                        (function () {
                            _this.value = b.value;
                            _this.proxyId = b.proxyId;
                            _this.stabbingCount = b.stabbingCount;
                        })();
                    }
                    else if (b === undefined) {
                        var __args = arguments;
                        if (this.value === undefined)
                            this.value = 0;
                        if (this.proxyId === undefined)
                            this.proxyId = 0;
                        if (this.stabbingCount === undefined)
                            this.stabbingCount = 0;
                        if (this.value === undefined)
                            this.value = 0;
                        if (this.proxyId === undefined)
                            this.proxyId = 0;
                        if (this.stabbingCount === undefined)
                            this.stabbingCount = 0;
                        (function () {
                            _this.value = 0;
                            _this.proxyId = 0;
                            _this.stabbingCount = 0;
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                Bound.prototype.set = function (b) {
                    this.setValueInternal(b.value);
                    this.proxyId = b.proxyId;
                    this.stabbingCount = b.stabbingCount;
                };
                Bound.prototype.setValueInternal = function (val) {
                    this.value = val;
                };
                Bound.prototype.isLower = function () {
                    return (this.value & 1) === 0;
                };
                Bound.prototype.isUpper = function () {
                    return (this.value & 1) === 1;
                };
                /**
                 * swaps the values of this bound with the other bound
                 * @param {org.jbox2d.collision.Bound} other bound to swap values with
                 */
                Bound.prototype.swap = function (other) {
                    var value = this.value;
                    var proxyId = this.proxyId;
                    var stabbingCount = this.stabbingCount;
                    this.setValueInternal(other.value);
                    this.proxyId = other.proxyId;
                    this.stabbingCount = other.stabbingCount;
                    other.setValueInternal(value);
                    other.proxyId = proxyId;
                    other.stabbingCount = stabbingCount;
                };
                /**
                 *
                 * @return {string}
                 */
                Bound.prototype.toString = function () {
                    var ret = "Bound variable:\n";
                    ret += "value: " + this.value + "\n";
                    ret += "proxyId: " + this.proxyId + "\n";
                    ret += "stabbing count: " + this.stabbingCount + "\n";
                    return ret;
                };
                return Bound;
            }());
            collision.Bound = Bound;
            Bound["__class"] = "org.jbox2d.collision.Bound";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var BoundValues = (function () {
                function BoundValues() {
                    if (this.lowerValues === undefined)
                        this.lowerValues = null;
                    if (this.upperValues === undefined)
                        this.upperValues = null;
                    this.lowerValues = [null, null];
                    this.upperValues = [null, null];
                }
                return BoundValues;
            }());
            collision.BoundValues = BoundValues;
            BoundValues["__class"] = "org.jbox2d.collision.BoundValues";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Used in pair manager.
             * @class
             */
            var BufferedPair = (function () {
                function BufferedPair() {
                    if (this.proxyId1 === undefined)
                        this.proxyId1 = 0;
                    if (this.proxyId2 === undefined)
                        this.proxyId2 = 0;
                }
                /*private*/ BufferedPair.prototype.equals = function (other) {
                    return this.proxyId1 === other.proxyId1 && this.proxyId2 === other.proxyId2;
                };
                /*private*/ BufferedPair.prototype.minor = function (other) {
                    if (this.proxyId1 < other.proxyId1)
                        return true;
                    if (this.proxyId1 === other.proxyId1) {
                        return this.proxyId2 < other.proxyId2;
                    }
                    return false;
                };
                BufferedPair.prototype.compareTo = function (p) {
                    if (this.minor(p)) {
                        return -1;
                    }
                    else if (this.equals(p)) {
                        return 0;
                    }
                    else {
                        return 1;
                    }
                };
                return BufferedPair;
            }());
            collision.BufferedPair = BufferedPair;
            BufferedPair["__class"] = "org.jbox2d.collision.BufferedPair";
            BufferedPair["__interfaces"] = ["java.lang.Comparable"];
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * A few static final variables that don't fit anywhere else (globals in C++ code).
             * @class
             */
            var Collision = (function () {
                function Collision() {
                }
                Collision.NULL_FEATURE_$LI$ = function () { if (Collision.NULL_FEATURE == null)
                    Collision.NULL_FEATURE = 2147483647; return Collision.NULL_FEATURE; };
                ;
                return Collision;
            }());
            collision.Collision = Collision;
            Collision["__class"] = "org.jbox2d.collision.Collision";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Contact ids to facilitate warm starting.
             * @param {org.jbox2d.collision.ContactID} c
             * @class
             */
            var ContactID = (function () {
                function ContactID(c) {
                    var _this = this;
                    if (((c != null && c instanceof org.jbox2d.collision.ContactID) || c === null)) {
                        var __args = arguments;
                        if (this.key === undefined)
                            this.key = 0;
                        if (this.features === undefined)
                            this.features = null;
                        if (this.key === undefined)
                            this.key = 0;
                        if (this.features === undefined)
                            this.features = null;
                        (function () {
                            _this.key = c.key;
                            _this.features = new ContactID.Features(_this, c.features);
                        })();
                    }
                    else if (c === undefined) {
                        var __args = arguments;
                        if (this.key === undefined)
                            this.key = 0;
                        if (this.features === undefined)
                            this.features = null;
                        if (this.key === undefined)
                            this.key = 0;
                        if (this.features === undefined)
                            this.features = null;
                        (function () {
                            _this.key = 0;
                            _this.features = new ContactID.Features(_this);
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                ContactID.prototype.isEqual = function (cid) {
                    return cid.features.isEqual(this.features);
                };
                /**
                 * zeros out the data
                 */
                ContactID.prototype.zero = function () {
                    this.key = 0;
                    this.features.flip = 0;
                    this.features.incidentEdge = 0;
                    this.features.incidentVertex = 0;
                    this.features.referenceEdge = 0;
                };
                ContactID.prototype.set = function (c) {
                    this.key = c.key;
                    this.features.set(c.features);
                };
                return ContactID;
            }());
            collision.ContactID = ContactID;
            ContactID["__class"] = "org.jbox2d.collision.ContactID";
            (function (ContactID) {
                /**
                 * The features that intersect to form the contact point
                 * @param {org.jbox2d.collision.ContactID.Features} f
                 * @class
                 */
                var Features = (function () {
                    function Features(__parent, f) {
                        var _this = this;
                        if (((f != null && f instanceof org.jbox2d.collision.ContactID.Features) || f === null)) {
                            var __args = Array.prototype.slice.call(arguments, [1]);
                            if (this.referenceEdge === undefined)
                                this.referenceEdge = 0;
                            if (this.incidentEdge === undefined)
                                this.incidentEdge = 0;
                            if (this.incidentVertex === undefined)
                                this.incidentVertex = 0;
                            if (this.flip === undefined)
                                this.flip = 0;
                            this.__parent = __parent;
                            if (this.referenceEdge === undefined)
                                this.referenceEdge = 0;
                            if (this.incidentEdge === undefined)
                                this.incidentEdge = 0;
                            if (this.incidentVertex === undefined)
                                this.incidentVertex = 0;
                            if (this.flip === undefined)
                                this.flip = 0;
                            (function () {
                                _this.referenceEdge = f.referenceEdge;
                                _this.incidentEdge = f.incidentEdge;
                                _this.incidentVertex = f.incidentVertex;
                                _this.flip = f.flip;
                            })();
                        }
                        else if (f === undefined) {
                            var __args = Array.prototype.slice.call(arguments, [1]);
                            if (this.referenceEdge === undefined)
                                this.referenceEdge = 0;
                            if (this.incidentEdge === undefined)
                                this.incidentEdge = 0;
                            if (this.incidentVertex === undefined)
                                this.incidentVertex = 0;
                            if (this.flip === undefined)
                                this.flip = 0;
                            this.__parent = __parent;
                            if (this.referenceEdge === undefined)
                                this.referenceEdge = 0;
                            if (this.incidentEdge === undefined)
                                this.incidentEdge = 0;
                            if (this.incidentVertex === undefined)
                                this.incidentVertex = 0;
                            if (this.flip === undefined)
                                this.flip = 0;
                            (function () {
                                _this.referenceEdge = _this.incidentEdge = _this.incidentVertex = _this.flip = 0;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    Features.prototype.set = function (f) {
                        this.referenceEdge = f.referenceEdge;
                        this.incidentEdge = f.incidentEdge;
                        this.incidentVertex = f.incidentVertex;
                        this.flip = f.flip;
                    };
                    Features.prototype.isEqual = function (f) {
                        return (this.referenceEdge === f.referenceEdge && this.incidentEdge === f.incidentEdge && this.incidentVertex === f.incidentVertex && this.flip === f.flip);
                    };
                    /**
                     *
                     * @return {string}
                     */
                    Features.prototype.toString = function () {
                        var s = "Features: (" + this.flip + " ," + this.incidentEdge + " ," + this.incidentVertex + " ," + this.referenceEdge + ")";
                        return s;
                    };
                    return Features;
                }());
                ContactID.Features = Features;
                Features["__class"] = "org.jbox2d.collision.ContactID.Features";
            })(ContactID = collision.ContactID || (collision.ContactID = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Implements the GJK algorithm for computing distance between shapes.
             * @class
             */
            var Distance = (function () {
                function Distance() {
                    this.g_GJK_Iterations = 0;
                    /*private*/ this.p1s = [null, null, null];
                    /*private*/ this.p2s = [null, null, null];
                    /*private*/ this.points = [null, null, null];
                    /*private*/ this.v = new org.jbox2d.common.Vec2();
                    /*private*/ this.vNeg = new org.jbox2d.common.Vec2();
                    /*private*/ this.w = new org.jbox2d.common.Vec2();
                    /*private*/ this.w1 = new org.jbox2d.common.Vec2();
                    /*private*/ this.w2 = new org.jbox2d.common.Vec2();
                    /*private*/ this.p2r = new org.jbox2d.common.Vec2();
                    /*private*/ this.p2d = new org.jbox2d.common.Vec2();
                    /*private*/ this.distCCp1 = new org.jbox2d.common.Vec2();
                    /*private*/ this.distCCp2 = new org.jbox2d.common.Vec2();
                    /*private*/ this.distCCd = new org.jbox2d.common.Vec2();
                    /*private*/ this.cWorld = new org.jbox2d.common.Vec2();
                    /*private*/ this.ECcLocal = new org.jbox2d.common.Vec2();
                    /*private*/ this.ECvWorld = new org.jbox2d.common.Vec2();
                    /*private*/ this.ECd = new org.jbox2d.common.Vec2();
                    /*private*/ this.ECtemp = new org.jbox2d.common.Vec2();
                    /*private*/ this.point = new org.jbox2d.collision.Point();
                    /*private*/ this.CPp1 = new org.jbox2d.common.Vec2();
                    /*private*/ this.CPp2 = new org.jbox2d.common.Vec2();
                    /*private*/ this.CPd = new org.jbox2d.common.Vec2();
                    for (var i = 0; i < 3; ++i) {
                        {
                            this.p1s[i] = new org.jbox2d.common.Vec2();
                            this.p2s[i] = new org.jbox2d.common.Vec2();
                            this.points[i] = new org.jbox2d.common.Vec2();
                        }
                        ;
                    }
                }
                Distance.prototype.ProcessTwo = function (x1, x2, p1s, p2s, points) {
                    this.p2r.x = -points[1].x;
                    this.p2r.y = -points[1].y;
                    this.p2d.x = Math.fround(points[0].x - points[1].x);
                    this.p2d.y = Math.fround(points[0].y - points[1].y);
                    var length = this.p2d.normalize();
                    var lambda = org.jbox2d.common.Vec2.dot(this.p2r, this.p2d);
                    if (lambda <= 0.0 || length < org.jbox2d.common.Settings.EPSILON) {
                        x1.set$org_jbox2d_common_Vec2(p1s[1]);
                        x2.set$org_jbox2d_common_Vec2(p2s[1]);
                        p1s[0].set$org_jbox2d_common_Vec2(p1s[1]);
                        p2s[0].set$org_jbox2d_common_Vec2(p2s[1]);
                        points[0].set$org_jbox2d_common_Vec2(points[1]);
                        return 1;
                    }
                    lambda /= length;
                    x1.set$float$float(Math.fround(p1s[1].x + Math.fround(lambda * (Math.fround(p1s[0].x - p1s[1].x)))), Math.fround(p1s[1].y + Math.fround(lambda * (Math.fround(p1s[0].y - p1s[1].y)))));
                    x2.set$float$float(Math.fround(p2s[1].x + Math.fround(lambda * (Math.fround(p2s[0].x - p2s[1].x)))), Math.fround(p2s[1].y + Math.fround(lambda * (Math.fround(p2s[0].y - p2s[1].y)))));
                    return 2;
                };
                Distance.prototype.ProcessThree = function (x1, x2, p1s, p2s, points) {
                    var a = points[0];
                    var b = points[1];
                    var c = points[2];
                    var abx = Math.fround(b.x - a.x);
                    var aby = Math.fround(b.y - a.y);
                    var acx = Math.fround(c.x - a.x);
                    var acy = Math.fround(c.y - a.y);
                    var bcx = Math.fround(c.x - b.x);
                    var bcy = Math.fround(c.y - b.y);
                    var sn = -(Math.fround(Math.fround(a.x * abx) + Math.fround(a.y * aby)));
                    var sd = Math.fround(Math.fround(b.x * abx) + Math.fround(b.y * aby));
                    var tn = -(Math.fround(Math.fround(a.x * acx) + Math.fround(a.y * acy)));
                    var td = Math.fround(Math.fround(c.x * acx) + Math.fround(c.y * acy));
                    var un = -(Math.fround(Math.fround(b.x * bcx) + Math.fround(b.y * bcy)));
                    var ud = Math.fround(Math.fround(c.x * bcx) + Math.fround(c.y * bcy));
                    if (td <= 0.0 && ud <= 0.0) {
                        x1.set$org_jbox2d_common_Vec2(p1s[2]);
                        x2.set$org_jbox2d_common_Vec2(p2s[2]);
                        p1s[0].set$org_jbox2d_common_Vec2(p1s[2]);
                        p2s[0].set$org_jbox2d_common_Vec2(p2s[2]);
                        points[0].set$org_jbox2d_common_Vec2(points[2]);
                        return 1;
                    }
                    if (!(sn > 0.0 || tn > 0.0))
                        throw new Error("Assertion error line 82: assert sn > 0.0F || tn > 0.0F;");
                    ;
                    if (!(sd > 0.0 || un > 0.0))
                        throw new Error("Assertion error line 83: assert sd > 0.0F || un > 0.0F;");
                    ;
                    var n = Math.fround(Math.fround(abx * acy) - Math.fround(aby * acx));
                    var vc = Math.fround(n * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(a, b));
                    if (!(vc > 0.0 || sn > 0.0 || sd > 0.0))
                        throw new Error("Assertion error line 86: assert vc > 0.0F || sn > 0.0F || sd > 0.0F;");
                    ;
                    var va = Math.fround(n * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b, c));
                    if (va <= 0.0 && un >= 0.0 && ud >= 0.0 && Math.fround(un + ud) > 0.0) {
                        if (!(Math.fround(un + ud) > 0.0))
                            throw new Error("Assertion error line 89: assert un + ud > 0.0F;");
                        ;
                        var lambda = Math.fround(un / (Math.fround(un + ud)));
                        x1.set$float$float(Math.fround(p1s[1].x + Math.fround(lambda * (Math.fround(p1s[2].x - p1s[1].x)))), Math.fround(p1s[1].y + Math.fround(lambda * (Math.fround(p1s[2].y - p1s[1].y)))));
                        x2.set$float$float(Math.fround(p2s[1].x + Math.fround(lambda * (Math.fround(p2s[2].x - p2s[1].x)))), Math.fround(p2s[1].y + Math.fround(lambda * (Math.fround(p2s[2].y - p2s[1].y)))));
                        p1s[0].set$org_jbox2d_common_Vec2(p1s[2]);
                        p2s[0].set$org_jbox2d_common_Vec2(p2s[2]);
                        points[0].set$org_jbox2d_common_Vec2(points[2]);
                        return 2;
                    }
                    var vb = Math.fround(n * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(c, a));
                    if (vb <= 0.0 && tn >= 0.0 && td >= 0.0 && Math.fround(tn + td) > 0.0) {
                        if (!(Math.fround(tn + td) > 0.0))
                            throw new Error("Assertion error line 100: assert tn + td > 0.0F;");
                        ;
                        var lambda = Math.fround(tn / (Math.fround(tn + td)));
                        x1.set$float$float(Math.fround(p1s[0].x + Math.fround(lambda * (Math.fround(p1s[2].x - p1s[0].x)))), Math.fround(p1s[0].y + Math.fround(lambda * (Math.fround(p1s[2].y - p1s[0].y)))));
                        x2.set$float$float(Math.fround(p2s[0].x + Math.fround(lambda * (Math.fround(p2s[2].x - p2s[0].x)))), Math.fround(p2s[0].y + Math.fround(lambda * (Math.fround(p2s[2].y - p2s[0].y)))));
                        p1s[1].set$org_jbox2d_common_Vec2(p1s[2]);
                        p2s[1].set$org_jbox2d_common_Vec2(p2s[2]);
                        points[1].set$org_jbox2d_common_Vec2(points[2]);
                        return 2;
                    }
                    var denom = Math.fround(Math.fround(va + vb) + vc);
                    if (!(denom > 0.0))
                        throw new Error("Assertion error line 110: assert denom > 0.0F;");
                    ;
                    denom = Math.fround(1.0 / denom);
                    var u = Math.fround(va * denom);
                    var v = Math.fround(vb * denom);
                    var w = Math.fround(Math.fround(1.0 - u) - v);
                    x1.set$float$float(Math.fround(Math.fround(Math.fround(u * p1s[0].x) + Math.fround(v * p1s[1].x)) + Math.fround(w * p1s[2].x)), Math.fround(Math.fround(Math.fround(u * p1s[0].y) + Math.fround(v * p1s[1].y)) + Math.fround(w * p1s[2].y)));
                    x2.set$float$float(Math.fround(Math.fround(Math.fround(u * p2s[0].x) + Math.fround(v * p2s[1].x)) + Math.fround(w * p2s[2].x)), Math.fround(Math.fround(Math.fround(u * p2s[0].y) + Math.fround(v * p2s[1].y)) + Math.fround(w * p2s[2].y)));
                    return 3;
                };
                Distance.prototype.InPoints = function (w, points, pointCount) {
                    var k_tolerance = Math.fround(100.0 * org.jbox2d.common.Settings.EPSILON);
                    for (var i = 0; i < pointCount; ++i) {
                        {
                            var v = points[i];
                            var dx = org.jbox2d.common.MathUtils.abs(Math.fround(w.x - v.x));
                            var dy = org.jbox2d.common.MathUtils.abs(Math.fround(w.y - v.y));
                            var mx = org.jbox2d.common.MathUtils.max$float$float(org.jbox2d.common.MathUtils.abs(w.x), org.jbox2d.common.MathUtils.abs(points[i].x));
                            var my = org.jbox2d.common.MathUtils.max$float$float(org.jbox2d.common.MathUtils.abs(w.y), org.jbox2d.common.MathUtils.abs(points[i].y));
                            if (dx < Math.fround(k_tolerance * (Math.fround(mx + 1.0))) && dy < Math.fround(k_tolerance * (Math.fround(my + 1.0)))) {
                                return true;
                            }
                        }
                        ;
                    }
                    return false;
                };
                /**
                 * Distance between any two objects that implement SupportsGeneric Note that
                 * x1 and x2 are passed so that they may store results - they must be
                 * instantiated before being passed, and the contents will be lost.
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Set to closest point on shape1 (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Set to closest point on shape2 (result parameter)
                 * @param {*} shape1
                 * Shape to test
                 * @param {org.jbox2d.common.XForm} xf1
                 * Transform of shape1
                 * @param {*} shape2
                 * Shape to test
                 * @param {org.jbox2d.common.XForm} xf2
                 * Transform of shape2
                 * @return {number} the distance
                 */
                Distance.prototype.DistanceGeneric = function (x1, x2, shape1, xf1, shape2, xf2) {
                    var pointCount = 0;
                    shape1.getFirstVertexToOut(xf1, x1);
                    shape2.getFirstVertexToOut(xf2, x2);
                    var vSqr = 0.0;
                    var maxIterations = 20;
                    for (var iter = 0; iter < maxIterations; ++iter) {
                        {
                            this.v.set$float$float(Math.fround(x2.x - x1.x), Math.fround(x2.y - x1.y));
                            shape1.support(this.w1, xf1, this.v);
                            this.vNeg.set$float$float(-this.v.x, -this.v.y);
                            shape2.support(this.w2, xf2, this.vNeg);
                            vSqr = org.jbox2d.common.Vec2.dot(this.v, this.v);
                            this.w.set$float$float(Math.fround(this.w2.x - this.w1.x), Math.fround(this.w2.y - this.w1.y));
                            var vw = org.jbox2d.common.Vec2.dot(this.v, this.w);
                            if (Math.fround(vSqr - vw) <= Math.fround(0.01 * vSqr) || this.InPoints(this.w, this.points, pointCount)) {
                                if (pointCount === 0) {
                                    x1.set$org_jbox2d_common_Vec2(this.w1);
                                    x2.set$org_jbox2d_common_Vec2(this.w2);
                                }
                                this.g_GJK_Iterations = iter;
                                return org.jbox2d.common.MathUtils.sqrt(vSqr);
                            }
                            switch ((pointCount)) {
                                case 0:
                                    this.p1s[0].set$org_jbox2d_common_Vec2(this.w1);
                                    this.p2s[0].set$org_jbox2d_common_Vec2(this.w2);
                                    this.points[0].set$org_jbox2d_common_Vec2(this.w);
                                    x1.set$org_jbox2d_common_Vec2(this.p1s[0]);
                                    x2.set$org_jbox2d_common_Vec2(this.p2s[0]);
                                    ++pointCount;
                                    break;
                                case 1:
                                    this.p1s[1].set$org_jbox2d_common_Vec2(this.w1);
                                    this.p2s[1].set$org_jbox2d_common_Vec2(this.w2);
                                    this.points[1].set$org_jbox2d_common_Vec2(this.w);
                                    pointCount = this.ProcessTwo(x1, x2, this.p1s, this.p2s, this.points);
                                    break;
                                case 2:
                                    this.p1s[2].set$org_jbox2d_common_Vec2(this.w1);
                                    this.p2s[2].set$org_jbox2d_common_Vec2(this.w2);
                                    this.points[2].set$org_jbox2d_common_Vec2(this.w);
                                    pointCount = this.ProcessThree(x1, x2, this.p1s, this.p2s, this.points);
                                    break;
                            }
                            if (pointCount === 3) {
                                this.g_GJK_Iterations = iter;
                                return 0.0;
                            }
                            var maxSqr = -3.4028235E38;
                            for (var i = 0; i < pointCount; ++i) {
                                {
                                    maxSqr = org.jbox2d.common.MathUtils.max$float$float(maxSqr, org.jbox2d.common.Vec2.dot(this.points[i], this.points[i]));
                                }
                                ;
                            }
                            if (pointCount === 3 || vSqr <= Math.fround(Math.fround(100.0 * org.jbox2d.common.Settings.EPSILON) * maxSqr)) {
                                this.g_GJK_Iterations = iter;
                                var vx = Math.fround(x2.x - x1.x);
                                var vy = Math.fround(x2.y - x1.y);
                                vSqr = Math.fround(Math.fround(vx * vx) + Math.fround(vy * vy));
                                return org.jbox2d.common.MathUtils.sqrt(vSqr);
                            }
                        }
                        ;
                    }
                    this.g_GJK_Iterations = maxIterations;
                    return org.jbox2d.common.MathUtils.sqrt(vSqr);
                };
                /**
                 * distance between two circle shapes
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Closest point on shape1 is put here (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Closest point on shape2 is put here (result parameter)
                 * @param {org.jbox2d.collision.shapes.CircleShape} circle1
                 * @param {org.jbox2d.common.XForm} xf1
                 * Transform of first shape
                 * @param {org.jbox2d.collision.shapes.CircleShape} circle2
                 * @param {org.jbox2d.common.XForm} xf2
                 * Transform of second shape
                 * @return {number} the distance
                 */
                Distance.prototype.DistanceCC = function (x1, x2, circle1, xf1, circle2, xf2) {
                    org.jbox2d.common.XForm.mulToOut(xf1, circle1.getMemberLocalPosition(), this.distCCp1);
                    org.jbox2d.common.XForm.mulToOut(xf2, circle2.getMemberLocalPosition(), this.distCCp2);
                    this.distCCd.x = Math.fround(this.distCCp2.x - this.distCCp1.x);
                    this.distCCd.y = Math.fround(this.distCCp2.y - this.distCCp1.y);
                    var dSqr = org.jbox2d.common.Vec2.dot(this.distCCd, this.distCCd);
                    var r1 = Math.fround(circle1.getRadius() - org.jbox2d.common.Settings.toiSlop_$LI$());
                    var r2 = Math.fround(circle2.getRadius() - org.jbox2d.common.Settings.toiSlop_$LI$());
                    var r = Math.fround(r1 + r2);
                    if (dSqr > Math.fround(r * r)) {
                        var dLen = this.distCCd.normalize();
                        var distance = Math.fround(dLen - r);
                        x1.set$float$float(Math.fround(this.distCCp1.x + Math.fround(r1 * this.distCCd.x)), Math.fround(this.distCCp1.y + Math.fround(r1 * this.distCCd.y)));
                        x2.set$float$float(Math.fround(this.distCCp2.x - Math.fround(r2 * this.distCCd.x)), Math.fround(this.distCCp2.y - Math.fround(r2 * this.distCCd.y)));
                        return distance;
                    }
                    else if (dSqr > Math.fround(org.jbox2d.common.Settings.EPSILON * org.jbox2d.common.Settings.EPSILON)) {
                        this.distCCd.normalize();
                        x1.set$float$float(Math.fround(this.distCCp1.x + Math.fround(r1 * this.distCCd.x)), Math.fround(this.distCCp1.y + Math.fround(r1 * this.distCCd.y)));
                        x2.set$org_jbox2d_common_Vec2(x1);
                        return 0.0;
                    }
                    x1.set$org_jbox2d_common_Vec2(this.distCCp1);
                    x2.set$org_jbox2d_common_Vec2(x1);
                    return 0.0;
                };
                /**
                 * Distance bewteen an edge and a circle
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Closest point on shape1 is put here (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Closest point on shape2 is put here (result parameter)
                 * @param {org.jbox2d.collision.shapes.EdgeShape} edge
                 * @param {org.jbox2d.common.XForm} xf1
                 * xform of edge
                 * @param {org.jbox2d.collision.shapes.CircleShape} circle
                 * @param {org.jbox2d.common.XForm} xf2
                 * xform of circle
                 * @return {number} the distance
                 */
                Distance.prototype.DistanceEdgeCircle = function (x1, x2, edge, xf1, circle, xf2) {
                    var dSqr;
                    var dLen;
                    var r = Math.fround(circle.getRadius() - org.jbox2d.common.Settings.toiSlop_$LI$());
                    org.jbox2d.common.XForm.mulToOut(xf2, circle.getMemberLocalPosition(), this.cWorld);
                    org.jbox2d.common.XForm.mulTransToOut(xf1, this.cWorld, this.ECcLocal);
                    var dirDist = org.jbox2d.common.Vec2.dot(this.ECcLocal.sub(edge.getCoreVertex1()), edge.getDirectionVector());
                    if (dirDist <= 0.0) {
                        org.jbox2d.common.XForm.mulToOut(xf1, edge.getCoreVertex1(), this.ECvWorld);
                    }
                    else if (dirDist >= edge.getLength()) {
                        org.jbox2d.common.XForm.mulToOut(xf1, edge.getCoreVertex2(), this.ECvWorld);
                    }
                    else {
                        x1.set$org_jbox2d_common_Vec2(edge.getDirectionVector());
                        x1.mulLocal(dirDist).addLocal$org_jbox2d_common_Vec2(edge.getCoreVertex1());
                        org.jbox2d.common.XForm.mulToOut(xf1, x1, x1);
                        this.ECtemp.set$org_jbox2d_common_Vec2(this.ECcLocal);
                        this.ECtemp.subLocal(edge.getCoreVertex1());
                        dLen = org.jbox2d.common.Vec2.dot(this.ECtemp, edge.getNormalVector());
                        if (dLen < 0.0) {
                            if (dLen < -r) {
                                x2.set$org_jbox2d_common_Vec2(edge.getNormalVector());
                                x2.mulLocal(r).addLocal$org_jbox2d_common_Vec2(this.ECcLocal);
                                org.jbox2d.common.XForm.mulToOut(xf1, x2, x2);
                                return Math.fround(-dLen - r);
                            }
                            else {
                                x2.set$org_jbox2d_common_Vec2(x1);
                                return 0.0;
                            }
                        }
                        else {
                            if (dLen > r) {
                                x2.set$org_jbox2d_common_Vec2(edge.getNormalVector());
                                x2.mulLocal(r).subLocal(this.ECcLocal).negateLocal();
                                org.jbox2d.common.XForm.mulToOut(xf1, x2, x2);
                                return Math.fround(dLen - r);
                            }
                            else {
                                x2.set$org_jbox2d_common_Vec2(x1);
                                return 0.0;
                            }
                        }
                    }
                    x1.set$org_jbox2d_common_Vec2(this.ECvWorld);
                    this.ECd.set$org_jbox2d_common_Vec2(this.cWorld);
                    this.ECd.subLocal(this.ECvWorld);
                    dSqr = org.jbox2d.common.Vec2.dot(this.ECd, this.ECd);
                    if (dSqr > Math.fround(r * r)) {
                        dLen = this.ECd.normalize();
                        x2.set$org_jbox2d_common_Vec2(this.ECd);
                        x2.mulLocal(r).subLocal(this.cWorld).negateLocal();
                        return Math.fround(dLen - r);
                    }
                    else {
                        x2.set$org_jbox2d_common_Vec2(this.ECvWorld);
                        return 0.0;
                    }
                };
                /**
                 * Distance between a polygon and a circle
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Closest point on shape1 is put here (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Closest point on shape2 is put here (result parameter)
                 * @param {org.jbox2d.collision.shapes.PolygonShape} polygon
                 * @param {org.jbox2d.common.XForm} xf1
                 * xform of polygon
                 * @param {org.jbox2d.collision.shapes.CircleShape} circle
                 * @param {org.jbox2d.common.XForm} xf2
                 * xform of circle
                 * @return {number} the distance
                 */
                Distance.prototype.DistancePC = function (x1, x2, polygon, xf1, circle, xf2) {
                    this.point.p.set$float$float(Math.fround(Math.fround(xf2.position.x + Math.fround(xf2.R.col1.x * circle.m_localPosition.x)) + Math.fround(xf2.R.col2.x * circle.m_localPosition.y)), Math.fround(Math.fround(xf2.position.y + Math.fround(xf2.R.col1.y * circle.m_localPosition.x)) + Math.fround(xf2.R.col2.y * circle.m_localPosition.y)));
                    var distance = this.DistanceGeneric(x1, x2, polygon, xf1, this.point, org.jbox2d.common.XForm.identity_$LI$());
                    var r = Math.fround(circle.getRadius() - org.jbox2d.common.Settings.toiSlop_$LI$());
                    if (distance > r) {
                        distance -= r;
                        var dx = Math.fround(x2.x - x1.x);
                        var dy = Math.fround(x2.y - x1.y);
                        var length_1 = org.jbox2d.common.MathUtils.sqrt(Math.fround(Math.fround(dx * dx) + Math.fround(dy * dy)));
                        if (length_1 >= org.jbox2d.common.Settings.EPSILON) {
                            var invLength = Math.fround(1.0 / length_1);
                            dx *= invLength;
                            dy *= invLength;
                        }
                        x2.x -= Math.fround(r * dx);
                        x2.y -= Math.fround(r * dy);
                    }
                    else {
                        distance = 0.0;
                        x2.set$org_jbox2d_common_Vec2(x1);
                    }
                    return distance;
                };
                /**
                 * Distance between a polygon and a point
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Closest point on shape1 is put here (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Closest point on shape2 is put here (result parameter)
                 * @param {org.jbox2d.collision.shapes.PolygonShape} polygon
                 * @param {org.jbox2d.common.XForm} xf1
                 * xform of polygon
                 * @param {org.jbox2d.collision.shapes.PointShape} pt
                 * @param {org.jbox2d.common.XForm} xf2
                 * xform of point
                 * @return {number} the distance
                 */
                Distance.prototype.DistancePolygonPoint = function (x1, x2, polygon, xf1, pt, xf2) {
                    this.point.p.set$float$float(Math.fround(Math.fround(xf2.position.x + Math.fround(xf2.R.col1.x * pt.m_localPosition.x)) + Math.fround(xf2.R.col2.x * pt.m_localPosition.y)), Math.fround(Math.fround(xf2.position.y + Math.fround(xf2.R.col1.y * pt.m_localPosition.x)) + Math.fround(xf2.R.col2.y * pt.m_localPosition.y)));
                    var distance = this.DistanceGeneric(x1, x2, polygon, xf1, this.point, org.jbox2d.common.XForm.identity_$LI$());
                    var r = -org.jbox2d.common.Settings.toiSlop_$LI$();
                    if (distance > r) {
                        distance -= r;
                        var dx = Math.fround(x2.x - x1.x);
                        var dy = Math.fround(x2.y - x1.y);
                        var length_2 = org.jbox2d.common.MathUtils.sqrt(Math.fround(Math.fround(dx * dx) + Math.fround(dy * dy)));
                        if (length_2 >= org.jbox2d.common.Settings.EPSILON) {
                            var invLength = Math.fround(1.0 / length_2);
                            dx *= invLength;
                            dy *= invLength;
                        }
                        x2.x -= Math.fround(r * dx);
                        x2.y -= Math.fround(r * dy);
                    }
                    else {
                        distance = 0.0;
                        x2.set$org_jbox2d_common_Vec2(x1);
                    }
                    return distance;
                };
                /**
                 * Distance between a circle and a point
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Closest point on shape1 is put here (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Closest point on shape2 is put here (result parameter)
                 * @param {org.jbox2d.collision.shapes.CircleShape} circle1
                 * @param {org.jbox2d.common.XForm} xf1
                 * xform of circle
                 * @param {org.jbox2d.collision.shapes.PointShape} pt2
                 * @param {org.jbox2d.common.XForm} xf2
                 * xform of point
                 * @return {number} the distance
                 */
                Distance.prototype.DistanceCirclePoint = function (x1, x2, circle1, xf1, pt2, xf2) {
                    org.jbox2d.common.XForm.mulToOut(xf1, circle1.getMemberLocalPosition(), this.CPp1);
                    org.jbox2d.common.XForm.mulToOut(xf2, pt2.getMemberLocalPosition(), this.CPp2);
                    this.CPd.x = Math.fround(this.CPp2.x - this.CPp1.x);
                    this.CPd.y = Math.fround(this.CPp2.y - this.CPp1.y);
                    var dSqr = org.jbox2d.common.Vec2.dot(this.CPd, this.CPd);
                    var r1 = Math.fround(circle1.getRadius() - org.jbox2d.common.Settings.toiSlop_$LI$());
                    var r2 = -org.jbox2d.common.Settings.toiSlop_$LI$();
                    var r = Math.fround(r1 + r2);
                    if (dSqr > Math.fround(r * r)) {
                        var dLen = this.CPd.normalize();
                        var distance = Math.fround(dLen - r);
                        x1.set$float$float(Math.fround(this.CPp1.x + Math.fround(r1 * this.CPd.x)), Math.fround(this.CPp1.y + Math.fround(r1 * this.CPd.y)));
                        x2.set$float$float(Math.fround(this.CPp2.x - Math.fround(r2 * this.CPd.x)), Math.fround(this.CPp2.y - Math.fround(r2 * this.CPd.y)));
                        return distance;
                    }
                    else if (dSqr > Math.fround(org.jbox2d.common.Settings.EPSILON * org.jbox2d.common.Settings.EPSILON)) {
                        this.CPd.normalize();
                        x1.set$float$float(Math.fround(this.CPp1.x + Math.fround(r1 * this.CPd.x)), Math.fround(this.CPp1.y + Math.fround(r1 * this.CPd.y)));
                        x2.set$org_jbox2d_common_Vec2(x1);
                        return 0.0;
                    }
                    x1.set$org_jbox2d_common_Vec2(this.CPp1);
                    x2.set$org_jbox2d_common_Vec2(x1);
                    return 0.0;
                };
                /**
                 * Find the closest distance between shapes shape1 and shape2, and load the
                 * closest points into x1 and x2. Note that x1 and x2 are passed so that
                 * they may store results - they must be instantiated before being passed,
                 * and the contents will be lost.
                 *
                 * @param {org.jbox2d.common.Vec2} x1
                 * Closest point on shape1 is put here (result parameter)
                 * @param {org.jbox2d.common.Vec2} x2
                 * Closest point on shape2 is put here (result parameter)
                 * @param {org.jbox2d.collision.shapes.Shape} shape1
                 * First shape to test
                 * @param {org.jbox2d.common.XForm} xf1
                 * Transform of first shape
                 * @param {org.jbox2d.collision.shapes.Shape} shape2
                 * Second shape to test
                 * @param {org.jbox2d.common.XForm} xf2
                 * Transform of second shape
                 * @return {number} the distance
                 */
                Distance.prototype.distance = function (x1, x2, shape1, xf1, shape2, xf2) {
                    var type1 = shape1.getType();
                    var type2 = shape2.getType();
                    if (type1 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE) {
                        return this.DistanceCC(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE) {
                        return this.DistancePC(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE) {
                        return this.DistancePC(x2, x1, shape2, xf2, shape1, xf1);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE) {
                        return this.DistanceGeneric(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE) {
                        return this.DistanceEdgeCircle(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE) {
                        return this.DistanceEdgeCircle(x2, x1, shape2, xf2, shape1, xf1);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE) {
                        return this.DistanceGeneric(x2, x1, shape2, xf2, shape1, xf1);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE) {
                        return this.DistanceGeneric(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE) {
                        return 3.4028235E38;
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE) {
                        return this.DistanceCirclePoint(x2, x1, shape2, xf2, shape1, xf1);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE) {
                        return this.DistanceCirclePoint(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE) {
                        return this.DistancePolygonPoint(x2, x1, shape2, xf2, shape1, xf1);
                    }
                    else if (type1 === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE && type2 === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE) {
                        return this.DistancePolygonPoint(x1, x2, shape1, xf1, shape2, xf2);
                    }
                    return 0.0;
                };
                return Distance;
            }());
            collision.Distance = Distance;
            Distance["__class"] = "org.jbox2d.collision.Distance";
            var Point = (function () {
                function Point(_p) {
                    var _this = this;
                    if (((_p != null && _p instanceof org.jbox2d.common.Vec2) || _p === null)) {
                        var __args = arguments;
                        if (this.p === undefined)
                            this.p = null;
                        if (this.p === undefined)
                            this.p = null;
                        (function () {
                            _this.p = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(_p);
                        })();
                    }
                    else if (_p === undefined) {
                        var __args = arguments;
                        if (this.p === undefined)
                            this.p = null;
                        if (this.p === undefined)
                            this.p = null;
                        (function () {
                            _this.p = new org.jbox2d.common.Vec2();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                Point.prototype.support = function (dest, xf, v) {
                    dest.set$org_jbox2d_common_Vec2(this.p);
                };
                Point.prototype.getFirstVertexToOut = function (xf, out) {
                    out.set$org_jbox2d_common_Vec2(this.p);
                };
                return Point;
            }());
            collision.Point = Point;
            Point["__class"] = "org.jbox2d.collision.Point";
            Point["__interfaces"] = ["org.jbox2d.collision.SupportsGenericDistance"];
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * This holds contact filtering data.
             * @class
             */
            var FilterData = (function () {
                function FilterData() {
                    if (this.categoryBits === undefined)
                        this.categoryBits = 0;
                    if (this.maskBits === undefined)
                        this.maskBits = 0;
                    if (this.groupIndex === undefined)
                        this.groupIndex = 0;
                }
                FilterData.prototype.set = function (fd) {
                    this.categoryBits = fd.categoryBits;
                    this.maskBits = fd.maskBits;
                    this.groupIndex = fd.groupIndex;
                };
                return FilterData;
            }());
            collision.FilterData = FilterData;
            FilterData["__class"] = "org.jbox2d.collision.FilterData";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Creates this manifold as a copy of the other
             * @param {org.jbox2d.collision.Manifold} other
             * @class
             */
            var Manifold = (function () {
                function Manifold(other) {
                    var _this = this;
                    if (((other != null && other instanceof org.jbox2d.collision.Manifold) || other === null)) {
                        var __args = arguments;
                        if (this.points === undefined)
                            this.points = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.pointCount === undefined)
                            this.pointCount = 0;
                        if (this.points === undefined)
                            this.points = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.pointCount === undefined)
                            this.pointCount = 0;
                        (function () {
                            _this.points = (function (s) { var a = []; while (s-- > 0)
                                a.push(null); return a; })(org.jbox2d.common.Settings.maxManifoldPoints);
                            _this.normal = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(other.normal);
                            _this.pointCount = other.pointCount;
                            for (var i = 0; i < other.points.length; i++) {
                                {
                                    _this.points[i] = new org.jbox2d.collision.ManifoldPoint(other.points[i]);
                                }
                                ;
                            }
                        })();
                    }
                    else if (other === undefined) {
                        var __args = arguments;
                        if (this.points === undefined)
                            this.points = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.pointCount === undefined)
                            this.pointCount = 0;
                        if (this.points === undefined)
                            this.points = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.pointCount === undefined)
                            this.pointCount = 0;
                        (function () {
                            _this.points = (function (s) { var a = []; while (s-- > 0)
                                a.push(null); return a; })(org.jbox2d.common.Settings.maxManifoldPoints);
                            for (var i = 0; i < org.jbox2d.common.Settings.maxManifoldPoints; i++) {
                                {
                                    _this.points[i] = new org.jbox2d.collision.ManifoldPoint();
                                }
                                ;
                            }
                            _this.normal = new org.jbox2d.common.Vec2();
                            _this.pointCount = 0;
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * copies this manifold from the given one
                 * @param {org.jbox2d.collision.Manifold} cp manifold to copy from
                 * @return {org.jbox2d.collision.Manifold}
                 */
                Manifold.prototype.set = function (cp) {
                    for (var i = 0; i < cp.pointCount; i++) {
                        {
                            this.points[i].set(cp.points[i]);
                        }
                        ;
                    }
                    this.normal.set$org_jbox2d_common_Vec2(cp.normal);
                    this.pointCount = cp.pointCount;
                    return this;
                };
                return Manifold;
            }());
            collision.Manifold = Manifold;
            Manifold["__class"] = "org.jbox2d.collision.Manifold";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Creates a manifold point as a copy of the given point
             * @param {org.jbox2d.collision.ManifoldPoint} cp point to copy from
             * @class
             */
            var ManifoldPoint = (function () {
                function ManifoldPoint(cp) {
                    var _this = this;
                    if (((cp != null && cp instanceof org.jbox2d.collision.ManifoldPoint) || cp === null)) {
                        var __args = arguments;
                        if (this.localPoint1 === undefined)
                            this.localPoint1 = null;
                        if (this.localPoint2 === undefined)
                            this.localPoint2 = null;
                        if (this.separation === undefined)
                            this.separation = 0;
                        if (this.normalImpulse === undefined)
                            this.normalImpulse = 0;
                        if (this.tangentImpulse === undefined)
                            this.tangentImpulse = 0;
                        if (this.id === undefined)
                            this.id = null;
                        if (this.localPoint1 === undefined)
                            this.localPoint1 = null;
                        if (this.localPoint2 === undefined)
                            this.localPoint2 = null;
                        if (this.separation === undefined)
                            this.separation = 0;
                        if (this.normalImpulse === undefined)
                            this.normalImpulse = 0;
                        if (this.tangentImpulse === undefined)
                            this.tangentImpulse = 0;
                        if (this.id === undefined)
                            this.id = null;
                        (function () {
                            _this.localPoint1 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(cp.localPoint1);
                            _this.localPoint2 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(cp.localPoint2);
                            _this.separation = cp.separation;
                            _this.normalImpulse = cp.normalImpulse;
                            _this.tangentImpulse = cp.tangentImpulse;
                            _this.id = new org.jbox2d.collision.ContactID(cp.id);
                        })();
                    }
                    else if (cp === undefined) {
                        var __args = arguments;
                        if (this.localPoint1 === undefined)
                            this.localPoint1 = null;
                        if (this.localPoint2 === undefined)
                            this.localPoint2 = null;
                        if (this.separation === undefined)
                            this.separation = 0;
                        if (this.normalImpulse === undefined)
                            this.normalImpulse = 0;
                        if (this.tangentImpulse === undefined)
                            this.tangentImpulse = 0;
                        if (this.id === undefined)
                            this.id = null;
                        if (this.localPoint1 === undefined)
                            this.localPoint1 = null;
                        if (this.localPoint2 === undefined)
                            this.localPoint2 = null;
                        if (this.separation === undefined)
                            this.separation = 0;
                        if (this.normalImpulse === undefined)
                            this.normalImpulse = 0;
                        if (this.tangentImpulse === undefined)
                            this.tangentImpulse = 0;
                        if (this.id === undefined)
                            this.id = null;
                        (function () {
                            _this.localPoint1 = new org.jbox2d.common.Vec2();
                            _this.localPoint2 = new org.jbox2d.common.Vec2();
                            _this.separation = _this.normalImpulse = _this.tangentImpulse = 0.0;
                            _this.id = new org.jbox2d.collision.ContactID();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * Sets this manifold point form the given one
                 * @param {org.jbox2d.collision.ManifoldPoint} cp the point to copy from
                 */
                ManifoldPoint.prototype.set = function (cp) {
                    this.localPoint1.set$org_jbox2d_common_Vec2(cp.localPoint1);
                    this.localPoint2.set$org_jbox2d_common_Vec2(cp.localPoint2);
                    this.separation = cp.separation;
                    this.normalImpulse = cp.normalImpulse;
                    this.tangentImpulse = cp.tangentImpulse;
                    this.id.set(cp.id);
                };
                return ManifoldPoint;
            }());
            collision.ManifoldPoint = ManifoldPoint;
            ManifoldPoint["__class"] = "org.jbox2d.collision.ManifoldPoint";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Copies from the given mass data
             * @param {org.jbox2d.collision.MassData} md mass data to copy from
             * @class
             */
            var MassData = (function () {
                function MassData(md) {
                    var _this = this;
                    if (((md != null && md instanceof org.jbox2d.collision.MassData) || md === null)) {
                        var __args = arguments;
                        if (this.mass === undefined)
                            this.mass = 0;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.I === undefined)
                            this.I = 0;
                        if (this.mass === undefined)
                            this.mass = 0;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.I === undefined)
                            this.I = 0;
                        (function () {
                            _this.mass = md.mass;
                            _this.I = md.I;
                            _this.center = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(md.center);
                        })();
                    }
                    else if (md === undefined) {
                        var __args = arguments;
                        if (this.mass === undefined)
                            this.mass = 0;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.I === undefined)
                            this.I = 0;
                        if (this.mass === undefined)
                            this.mass = 0;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.I === undefined)
                            this.I = 0;
                        (function () {
                            _this.mass = _this.I = 0.0;
                            _this.center = new org.jbox2d.common.Vec2();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                MassData.prototype.set = function (argOther) {
                    this.mass = argOther.mass;
                    this.center.set$org_jbox2d_common_Vec2(argOther.center);
                    this.I = argOther.I;
                    return this;
                };
                /**
                 * Return a copy of this object.
                 * @return {org.jbox2d.collision.MassData}
                 */
                MassData.prototype.clone = function () {
                    return new MassData(this);
                };
                return MassData;
            }());
            collision.MassData = MassData;
            MassData["__class"] = "org.jbox2d.collision.MassData";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * creates OBB with the given data.  The arguments are cloned
             * before being placed in the object
             * @param {org.jbox2d.common.Mat22} _R
             * @param {org.jbox2d.common.Vec2} _center
             * @param {org.jbox2d.common.Vec2} _extents
             * @class
             */
            var OBB = (function () {
                function OBB(_R, _center, _extents) {
                    var _this = this;
                    if (((_R != null && _R instanceof org.jbox2d.common.Mat22) || _R === null) && ((_center != null && _center instanceof org.jbox2d.common.Vec2) || _center === null) && ((_extents != null && _extents instanceof org.jbox2d.common.Vec2) || _extents === null)) {
                        var __args = arguments;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.extents === undefined)
                            this.extents = null;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.extents === undefined)
                            this.extents = null;
                        (function () {
                            _this.R = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(_R);
                            _this.center = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(_center);
                            _this.extents = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(_extents);
                        })();
                    }
                    else if (((_R != null && _R instanceof org.jbox2d.collision.OBB) || _R === null) && _center === undefined && _extents === undefined) {
                        var __args = arguments;
                        var copy = __args[0];
                        {
                            var __args_2 = arguments;
                            var _R_1 = copy.R;
                            var _center_1 = copy.center;
                            var _extents_1 = copy.extents;
                            if (this.R === undefined)
                                this.R = null;
                            if (this.center === undefined)
                                this.center = null;
                            if (this.extents === undefined)
                                this.extents = null;
                            if (this.R === undefined)
                                this.R = null;
                            if (this.center === undefined)
                                this.center = null;
                            if (this.extents === undefined)
                                this.extents = null;
                            (function () {
                                _this.R = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(_R_1);
                                _this.center = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(_center_1);
                                _this.extents = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(_extents_1);
                            })();
                        }
                    }
                    else if (_R === undefined && _center === undefined && _extents === undefined) {
                        var __args = arguments;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.extents === undefined)
                            this.extents = null;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.center === undefined)
                            this.center = null;
                        if (this.extents === undefined)
                            this.extents = null;
                        (function () {
                            _this.R = new org.jbox2d.common.Mat22();
                            _this.center = new org.jbox2d.common.Vec2();
                            _this.extents = new org.jbox2d.common.Vec2();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * @return {org.jbox2d.collision.OBB} a copy
                 */
                OBB.prototype.clone = function () {
                    return new OBB(this);
                };
                return OBB;
            }());
            collision.OBB = OBB;
            OBB["__class"] = "org.jbox2d.collision.OBB";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            /**
             * Copy constructor
             * @param {org.jbox2d.collision.Pair} other
             * @class
             */
            var Pair = (function () {
                function Pair(other) {
                    var _this = this;
                    if (((other != null && other instanceof org.jbox2d.collision.Pair) || other === null)) {
                        var __args = arguments;
                        if (this.userData === undefined)
                            this.userData = null;
                        if (this.proxyId1 === undefined)
                            this.proxyId1 = 0;
                        if (this.proxyId2 === undefined)
                            this.proxyId2 = 0;
                        if (this.status === undefined)
                            this.status = 0;
                        if (this.next === undefined)
                            this.next = 0;
                        if (this.userData === undefined)
                            this.userData = null;
                        if (this.proxyId1 === undefined)
                            this.proxyId1 = 0;
                        if (this.proxyId2 === undefined)
                            this.proxyId2 = 0;
                        if (this.status === undefined)
                            this.status = 0;
                        if (this.next === undefined)
                            this.next = 0;
                        (function () {
                            _this.userData = other.userData;
                            _this.proxyId1 = other.proxyId1;
                            _this.proxyId2 = other.proxyId2;
                            _this.status = other.status;
                        })();
                    }
                    else if (other === undefined) {
                        var __args = arguments;
                        if (this.userData === undefined)
                            this.userData = null;
                        if (this.proxyId1 === undefined)
                            this.proxyId1 = 0;
                        if (this.proxyId2 === undefined)
                            this.proxyId2 = 0;
                        if (this.status === undefined)
                            this.status = 0;
                        if (this.next === undefined)
                            this.next = 0;
                        if (this.userData === undefined)
                            this.userData = null;
                        if (this.proxyId1 === undefined)
                            this.proxyId1 = 0;
                        if (this.proxyId2 === undefined)
                            this.proxyId2 = 0;
                        if (this.status === undefined)
                            this.status = 0;
                        if (this.next === undefined)
                            this.next = 0;
                    }
                    else
                        throw new Error('invalid overload');
                }
                Pair.prototype.setBuffered = function () {
                    this.status |= Pair.PAIR_BUFFERED;
                };
                Pair.prototype.clearBuffered = function () {
                    this.status &= ~Pair.PAIR_BUFFERED;
                };
                Pair.prototype.isBuffered = function () {
                    return (this.status & Pair.PAIR_BUFFERED) === Pair.PAIR_BUFFERED;
                };
                Pair.prototype.clearRemoved = function () {
                    this.status &= ~Pair.PAIR_REMOVED;
                };
                Pair.prototype.setRemoved = function () {
                    this.status |= Pair.PAIR_REMOVED;
                };
                Pair.prototype.isRemoved = function () {
                    return (this.status & Pair.PAIR_REMOVED) === Pair.PAIR_REMOVED;
                };
                Pair.prototype.setFinal = function () {
                    this.status |= Pair.PAIR_FINAL;
                };
                Pair.prototype.isFinal = function () {
                    return (this.status & Pair.PAIR_FINAL) === Pair.PAIR_FINAL;
                };
                Pair.prototype.compareTo = function (p) {
                    return this.proxyId1 - p.proxyId1;
                };
                return Pair;
            }());
            Pair.PAIR_BUFFERED = 1;
            Pair.PAIR_REMOVED = 2;
            Pair.PAIR_FINAL = 4;
            collision.Pair = Pair;
            Pair["__class"] = "org.jbox2d.collision.Pair";
            Pair["__interfaces"] = ["java.lang.Comparable"];
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var Proxy = (function () {
                function Proxy() {
                    if (this.lowerBounds === undefined)
                        this.lowerBounds = null;
                    if (this.upperBounds === undefined)
                        this.upperBounds = null;
                    if (this.overlapCount === undefined)
                        this.overlapCount = 0;
                    if (this.timeStamp === undefined)
                        this.timeStamp = 0;
                    if (this.categoryBits === undefined)
                        this.categoryBits = 0;
                    if (this.maskBits === undefined)
                        this.maskBits = 0;
                    if (this.groupIndex === undefined)
                        this.groupIndex = 0;
                    if (this.userData === undefined)
                        this.userData = null;
                    this.lowerBounds = [0, 0];
                    this.upperBounds = [0, 0];
                    this.lowerBounds[0] = this.lowerBounds[1] = 0;
                    this.upperBounds[0] = this.upperBounds[1] = 0;
                    this.overlapCount = org.jbox2d.collision.BroadPhase.INVALID_$LI$();
                    this.timeStamp = 0;
                }
                Proxy.prototype.getNext = function () {
                    return this.lowerBounds[0];
                };
                Proxy.prototype.setNext = function (next) {
                    this.lowerBounds[0] = next;
                };
                Proxy.prototype.isValid = function () {
                    return this.overlapCount !== org.jbox2d.collision.BroadPhase.INVALID_$LI$();
                };
                return Proxy;
            }());
            collision.Proxy = Proxy;
            Proxy["__class"] = "org.jbox2d.collision.Proxy";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var SegmentCollide;
            (function (SegmentCollide) {
                SegmentCollide[SegmentCollide["STARTS_INSIDE_COLLIDE"] = 0] = "STARTS_INSIDE_COLLIDE";
                SegmentCollide[SegmentCollide["MISS_COLLIDE"] = 1] = "MISS_COLLIDE";
                SegmentCollide[SegmentCollide["HIT_COLLIDE"] = 2] = "HIT_COLLIDE";
            })(SegmentCollide = collision.SegmentCollide || (collision.SegmentCollide = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * Circle/circle and circle/polygon overlap solver -
                 * for internal use only.
                 * @class
                 */
                var CollideCircle = (function () {
                    function CollideCircle() {
                        /*private*/ this.colCCP1 = new org.jbox2d.common.Vec2();
                        /*private*/ this.colCCP2 = new org.jbox2d.common.Vec2();
                        /*private*/ this.colCCD = new org.jbox2d.common.Vec2();
                        /*private*/ this.colCCP = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPCP1 = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPCP2 = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPCD = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPCP = new org.jbox2d.common.Vec2();
                        /*private*/ this.ECd = new org.jbox2d.common.Vec2();
                        /*private*/ this.ECc = new org.jbox2d.common.Vec2();
                        /*private*/ this.ECcLocal = new org.jbox2d.common.Vec2();
                    }
                    /**
                     * puts collision information of the two circles in the manifold
                     * @param {org.jbox2d.collision.Manifold} manifold
                     * @param {org.jbox2d.collision.shapes.CircleShape} circle1
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.CircleShape} circle2
                     * @param {org.jbox2d.common.XForm} xf2
                     */
                    CollideCircle.prototype.collideCircles = function (manifold, circle1, xf1, circle2, xf2) {
                        manifold.pointCount = 0;
                        org.jbox2d.common.XForm.mulToOut(xf1, circle1.getMemberLocalPosition(), this.colCCP1);
                        org.jbox2d.common.XForm.mulToOut(xf2, circle2.getMemberLocalPosition(), this.colCCP2);
                        this.colCCD.x = Math.fround(this.colCCP2.x - this.colCCP1.x);
                        this.colCCD.y = Math.fround(this.colCCP2.y - this.colCCP1.y);
                        var distSqr = org.jbox2d.common.Vec2.dot(this.colCCD, this.colCCD);
                        var r1 = circle1.getRadius();
                        var r2 = circle2.getRadius();
                        var radiusSum = Math.fround(r1 + r2);
                        if (distSqr > Math.fround(radiusSum * radiusSum)) {
                            return;
                        }
                        var separation;
                        if (distSqr < org.jbox2d.common.Settings.EPSILON) {
                            separation = -radiusSum;
                            manifold.normal.set$float$float(0.0, 1.0);
                        }
                        else {
                            var dist = org.jbox2d.common.MathUtils.sqrt(distSqr);
                            separation = Math.fround(dist - radiusSum);
                            var a = Math.fround(1.0 / dist);
                            manifold.normal.x = Math.fround(a * this.colCCD.x);
                            manifold.normal.y = Math.fround(a * this.colCCD.y);
                        }
                        manifold.pointCount = 1;
                        manifold.points[0].id.zero();
                        manifold.points[0].separation = separation;
                        this.colCCP1.addLocal$org_jbox2d_common_Vec2(manifold.normal.mul(r1));
                        this.colCCP2.subLocal(manifold.normal.mul(r2));
                        this.colCCP.x = Math.fround(0.5 * (Math.fround(this.colCCP1.x + this.colCCP2.x)));
                        this.colCCP.y = Math.fround(0.5 * (Math.fround(this.colCCP1.y + this.colCCP2.y)));
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.colCCP, manifold.points[0].localPoint1);
                        org.jbox2d.common.XForm.mulTransToOut(xf2, this.colCCP, manifold.points[0].localPoint2);
                    };
                    /**
                     * Puts collision information in the manifold about a collision between a point and a circle
                     * @param {org.jbox2d.collision.Manifold} manifold
                     * @param {org.jbox2d.collision.shapes.PointShape} point1
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.CircleShape} circle2
                     * @param {org.jbox2d.common.XForm} xf2
                     */
                    CollideCircle.prototype.collidePointAndCircle = function (manifold, point1, xf1, circle2, xf2) {
                        manifold.pointCount = 0;
                        org.jbox2d.common.XForm.mulToOut(xf1, point1.getMemberLocalPosition(), this.colPCP1);
                        org.jbox2d.common.XForm.mulToOut(xf2, circle2.getMemberLocalPosition(), this.colPCP2);
                        this.colPCD.x = Math.fround(this.colPCP2.x - this.colPCP1.x);
                        this.colPCD.y = Math.fround(this.colPCP2.y - this.colPCP1.y);
                        var distSqr = org.jbox2d.common.Vec2.dot(this.colPCD, this.colPCD);
                        var r2 = circle2.getRadius();
                        if (distSqr > Math.fround(r2 * r2)) {
                            return;
                        }
                        var separation;
                        if (distSqr < org.jbox2d.common.Settings.EPSILON) {
                            separation = -r2;
                            manifold.normal.set$float$float(0.0, 1.0);
                        }
                        else {
                            var dist = org.jbox2d.common.MathUtils.sqrt(distSqr);
                            separation = Math.fround(dist - r2);
                            var a = Math.fround(1.0 / dist);
                            manifold.normal.x = Math.fround(a * this.colPCD.x);
                            manifold.normal.y = Math.fround(a * this.colPCD.y);
                        }
                        manifold.pointCount = 1;
                        manifold.points[0].id.zero();
                        manifold.points[0].separation = separation;
                        this.colPCP2.subLocal(manifold.normal.mul(r2));
                        this.colPCP.x = Math.fround(0.5 * (Math.fround(this.colPCP1.x + this.colPCP2.x)));
                        this.colPCP.y = Math.fround(0.5 * (Math.fround(this.colPCP1.y + this.colPCP2.y)));
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.colPCP, manifold.points[0].localPoint1);
                        org.jbox2d.common.XForm.mulTransToOut(xf2, this.colPCP, manifold.points[0].localPoint2);
                    };
                    /**
                     * puts collision information about the collision of a polygon and a circle
                     * @param {org.jbox2d.collision.Manifold} manifold
                     * @param {org.jbox2d.collision.shapes.PolygonShape} polygon
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.CircleShape} circle
                     * @param {org.jbox2d.common.XForm} xf2
                     */
                    CollideCircle.prototype.collidePolygonAndCircle = function (manifold, polygon, xf1, circle, xf2) {
                        manifold.pointCount = 0;
                        var cx = Math.fround(Math.fround(xf2.position.x + Math.fround(xf2.R.col1.x * circle.m_localPosition.x)) + Math.fround(xf2.R.col2.x * circle.m_localPosition.y));
                        var cy = Math.fround(Math.fround(xf2.position.y + Math.fround(xf2.R.col1.y * circle.m_localPosition.x)) + Math.fround(xf2.R.col2.y * circle.m_localPosition.y));
                        var v1x = Math.fround(cx - xf1.position.x);
                        var v1y = Math.fround(cy - xf1.position.y);
                        var cLocalx = Math.fround(Math.fround(v1x * xf1.R.col1.x) + Math.fround(v1y * xf1.R.col1.y));
                        var cLocaly = Math.fround(Math.fround(v1x * xf1.R.col2.x) + Math.fround(v1y * xf1.R.col2.y));
                        var normalIndex = 0;
                        var separation = -3.4028235E38;
                        var radius = circle.getRadius();
                        var vertexCount = polygon.getVertexCount();
                        var vertices = polygon.getVertices();
                        var normals = polygon.getNormals();
                        for (var i = 0; i < vertexCount; ++i) {
                            {
                                var s = Math.fround(Math.fround(normals[i].x * (Math.fround(cLocalx - vertices[i].x))) + Math.fround(normals[i].y * (Math.fround(cLocaly - vertices[i].y))));
                                if (s > circle.m_radius) {
                                    return;
                                }
                                if (s > separation) {
                                    normalIndex = i;
                                    separation = s;
                                }
                            }
                            ;
                        }
                        if (separation < org.jbox2d.common.Settings.EPSILON) {
                            manifold.pointCount = 1;
                            manifold.normal.x = Math.fround(Math.fround(xf1.R.col1.x * normals[normalIndex].x) + Math.fround(xf1.R.col2.x * normals[normalIndex].y));
                            manifold.normal.y = Math.fround(Math.fround(xf1.R.col1.y * normals[normalIndex].x) + Math.fround(xf1.R.col2.y * normals[normalIndex].y));
                            manifold.points[0].id.features.incidentEdge = normalIndex;
                            manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.referenceEdge = 0;
                            manifold.points[0].id.features.flip = 0;
                            var positionx_1 = Math.fround(cx - Math.fround(manifold.normal.x * radius));
                            var positiony_1 = Math.fround(cy - Math.fround(manifold.normal.y * radius));
                            var v1x1_1 = Math.fround(positionx_1 - xf1.position.x);
                            var v1y1_1 = Math.fround(positiony_1 - xf1.position.y);
                            manifold.points[0].localPoint1.x = (Math.fround(Math.fround(v1x1_1 * xf1.R.col1.x) + Math.fround(v1y1_1 * xf1.R.col1.y)));
                            manifold.points[0].localPoint1.y = (Math.fround(Math.fround(v1x1_1 * xf1.R.col2.x) + Math.fround(v1y1_1 * xf1.R.col2.y)));
                            var v1x2_1 = Math.fround(positionx_1 - xf2.position.x);
                            var v1y2_1 = Math.fround(positiony_1 - xf2.position.y);
                            manifold.points[0].localPoint2.x = (Math.fround(Math.fround(v1x2_1 * xf2.R.col1.x) + Math.fround(v1y2_1 * xf2.R.col1.y)));
                            manifold.points[0].localPoint2.y = (Math.fround(Math.fround(v1x2_1 * xf2.R.col2.x) + Math.fround(v1y2_1 * xf2.R.col2.y)));
                            manifold.points[0].separation = Math.fround(separation - radius);
                            return;
                        }
                        var vertIndex1 = normalIndex;
                        var vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
                        var ex = Math.fround(vertices[vertIndex2].x - vertices[vertIndex1].x);
                        var ey = Math.fround(vertices[vertIndex2].y - vertices[vertIndex1].y);
                        var length = org.jbox2d.common.MathUtils.sqrt(Math.fround(Math.fround(ex * ex) + Math.fround(ey * ey)));
                        if (!((length > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 165: assert (length > Settings.EPSILON);");
                        ;
                        var invLength = Math.fround(1.0 / length);
                        ex *= invLength;
                        ey *= invLength;
                        var u = Math.fround(Math.fround((Math.fround(cLocalx - vertices[vertIndex1].x)) * ex) + Math.fround((Math.fround(cLocaly - vertices[vertIndex1].y)) * ey));
                        var px;
                        var py;
                        if (u <= 0.0) {
                            px = vertices[vertIndex1].x;
                            py = vertices[vertIndex1].y;
                            manifold.points[0].id.features.incidentEdge = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.incidentVertex = vertIndex1;
                        }
                        else if (u >= length) {
                            px = vertices[vertIndex2].x;
                            py = vertices[vertIndex2].y;
                            manifold.points[0].id.features.incidentEdge = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.incidentVertex = vertIndex2;
                        }
                        else {
                            px = vertices[vertIndex1].x;
                            py = vertices[vertIndex1].y;
                            px += Math.fround(u * ex);
                            py += Math.fround(u * ey);
                            manifold.points[0].id.features.incidentEdge = normalIndex;
                            manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                        }
                        var dx = Math.fround(cLocalx - px);
                        var dy = Math.fround(cLocaly - py);
                        var dist = org.jbox2d.common.MathUtils.sqrt(Math.fround(Math.fround(dx * dx) + Math.fround(dy * dy)));
                        if (dist > radius) {
                            return;
                        }
                        if (dist >= org.jbox2d.common.Settings.EPSILON) {
                            var invDist = Math.fround(1.0 / dist);
                            dx *= invDist;
                            dy *= invDist;
                        }
                        manifold.pointCount = 1;
                        manifold.normal.x = Math.fround(Math.fround(xf1.R.col1.x * dx) + Math.fround(xf1.R.col2.x * dy));
                        manifold.normal.y = Math.fround(Math.fround(xf1.R.col1.y * dx) + Math.fround(xf1.R.col2.y * dy));
                        var positionx = Math.fround(cx - Math.fround(manifold.normal.x * radius));
                        var positiony = Math.fround(cy - Math.fround(manifold.normal.y * radius));
                        var v1x1 = Math.fround(positionx - xf1.position.x);
                        var v1y1 = Math.fround(positiony - xf1.position.y);
                        manifold.points[0].localPoint1.x = (Math.fround(Math.fround(v1x1 * xf1.R.col1.x) + Math.fround(v1y1 * xf1.R.col1.y)));
                        manifold.points[0].localPoint1.y = (Math.fround(Math.fround(v1x1 * xf1.R.col2.x) + Math.fround(v1y1 * xf1.R.col2.y)));
                        var v1x2 = Math.fround(positionx - xf2.position.x);
                        var v1y2 = Math.fround(positiony - xf2.position.y);
                        manifold.points[0].localPoint2.x = (Math.fround(Math.fround(v1x2 * xf2.R.col1.x) + Math.fround(v1y2 * xf2.R.col1.y)));
                        manifold.points[0].localPoint2.y = (Math.fround(Math.fround(v1x2 * xf2.R.col2.x) + Math.fround(v1y2 * xf2.R.col2.y)));
                        manifold.points[0].separation = Math.fround(dist - radius);
                        manifold.points[0].id.features.referenceEdge = 0;
                        manifold.points[0].id.features.flip = 0;
                    };
                    /**
                     * puts collision information into the manifold from a circle and edge collision
                     * @param {org.jbox2d.collision.Manifold} manifold
                     * @param {org.jbox2d.collision.shapes.EdgeShape} edge
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.CircleShape} circle
                     * @param {org.jbox2d.common.XForm} xf2
                     */
                    CollideCircle.prototype.collideEdgeAndCircle = function (manifold, edge, xf1, circle, xf2) {
                        manifold.pointCount = 0;
                        org.jbox2d.common.XForm.mulToOut(xf2, circle.getMemberLocalPosition(), this.ECc);
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.ECc, this.ECcLocal);
                        var n = edge.getNormalVector();
                        var v1 = edge.getVertex1();
                        var v2 = edge.getVertex2();
                        var radius = circle.getRadius();
                        var separation;
                        this.ECd.set$org_jbox2d_common_Vec2(this.ECcLocal);
                        this.ECd.subLocal(v1);
                        var dirDist = org.jbox2d.common.Vec2.dot(this.ECd, edge.getDirectionVector());
                        if (dirDist <= 0) {
                            if (org.jbox2d.common.Vec2.dot(this.ECd, edge.getCorner1Vector()) < 0) {
                                return;
                            }
                            org.jbox2d.common.XForm.mulToOut(xf1, v1, this.ECd);
                            this.ECd.subLocal(this.ECc);
                            this.ECd.negateLocal();
                        }
                        else if (dirDist >= edge.getLength()) {
                            this.ECd.set$org_jbox2d_common_Vec2(this.ECcLocal);
                            this.ECd.subLocal(v2);
                            if (org.jbox2d.common.Vec2.dot(this.ECd, edge.getCorner2Vector()) > 0) {
                                return;
                            }
                            org.jbox2d.common.XForm.mulToOut(xf1, v2, this.ECd);
                            this.ECd.subLocal(this.ECc);
                            this.ECd.negateLocal();
                        }
                        else {
                            separation = org.jbox2d.common.Vec2.dot(this.ECd, n);
                            if (separation > radius || separation < -radius) {
                                return;
                            }
                            separation -= radius;
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, n, manifold.normal);
                            manifold.pointCount = 1;
                            manifold.points[0].id.zero();
                            manifold.points[0].separation = separation;
                            this.ECd.set$org_jbox2d_common_Vec2(manifold.normal);
                            this.ECd.mulLocal(radius);
                            this.ECc.subLocal(this.ECd);
                            org.jbox2d.common.XForm.mulTransToOut(xf1, this.ECc, manifold.points[0].localPoint1);
                            org.jbox2d.common.XForm.mulTransToOut(xf2, this.ECc, manifold.points[0].localPoint2);
                            return;
                        }
                        var distSqr = org.jbox2d.common.Vec2.dot(this.ECd, this.ECd);
                        if (distSqr > Math.fround(radius * radius)) {
                            return;
                        }
                        if (distSqr < org.jbox2d.common.Settings.EPSILON) {
                            separation = -radius;
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, n, manifold.normal);
                        }
                        else {
                            separation = Math.fround(this.ECd.normalize() - radius);
                            manifold.normal.set$org_jbox2d_common_Vec2(this.ECd);
                        }
                        manifold.pointCount = 1;
                        manifold.points[0].id.zero();
                        manifold.points[0].separation = separation;
                        this.ECd.set$org_jbox2d_common_Vec2(manifold.normal);
                        this.ECd.mulLocal(radius);
                        this.ECc.subLocal(this.ECd);
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.ECc, manifold.points[0].localPoint1);
                        org.jbox2d.common.XForm.mulTransToOut(xf2, this.ECc, manifold.points[0].localPoint2);
                    };
                    return CollideCircle;
                }());
                shapes.CollideCircle = CollideCircle;
                CollideCircle["__class"] = "org.jbox2d.collision.shapes.CollideCircle";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * Polygon overlap solver - for internal use.
                 * @class
                 */
                var CollidePoly = (function () {
                    function CollidePoly() {
                        /*private*/ this.normal1World = new org.jbox2d.common.Vec2();
                        /*private*/ this.dLocal1 = new org.jbox2d.common.Vec2();
                        /*private*/ this.mulTemp = new org.jbox2d.common.Vec2();
                        /*private*/ this.normal1 = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPPc = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPPcLocal = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPPsub = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPPe = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPPp = new org.jbox2d.common.Vec2();
                        /*private*/ this.colPPd = new org.jbox2d.common.Vec2();
                        /*private*/ this.PEv1 = new org.jbox2d.common.Vec2();
                        /*private*/ this.PEv2 = new org.jbox2d.common.Vec2();
                        /*private*/ this.PEn = new org.jbox2d.common.Vec2();
                        /*private*/ this.PEv1Local = new org.jbox2d.common.Vec2();
                        /*private*/ this.PEv2Local = new org.jbox2d.common.Vec2();
                        /*private*/ this.PEnLocal = new org.jbox2d.common.Vec2();
                        /*private*/ this.temp = new org.jbox2d.common.Vec2();
                        /*private*/ this.temp2 = new org.jbox2d.common.Vec2();
                        /*private*/ this.sideNormal = new org.jbox2d.common.Vec2();
                        /*private*/ this.frontNormal = new org.jbox2d.common.Vec2();
                        /*private*/ this.p_xf1 = new org.jbox2d.common.XForm();
                        /*private*/ this.p_xf2 = new org.jbox2d.common.XForm();
                    }
                    CollidePoly.prototype.clipSegmentToLine = function (vOut, vIn, normal, offset) {
                        var numOut = 0;
                        var distance0 = Math.fround(org.jbox2d.common.Vec2.dot(normal, vIn[0].v) - offset);
                        var distance1 = Math.fround(org.jbox2d.common.Vec2.dot(normal, vIn[1].v) - offset);
                        if (distance0 <= 0.0) {
                            vOut[numOut] = new CollidePoly.ClipVertex();
                            vOut[numOut].id.set(vIn[0].id);
                            vOut[numOut++].v.set$org_jbox2d_common_Vec2(vIn[0].v);
                        }
                        if (distance1 <= 0.0) {
                            vOut[numOut] = new CollidePoly.ClipVertex();
                            vOut[numOut].id.set(vIn[1].id);
                            vOut[numOut++].v.set$org_jbox2d_common_Vec2(vIn[1].v);
                        }
                        if (Math.fround(distance0 * distance1) < 0.0) {
                            var interp = Math.fround(distance0 / (Math.fround(distance0 - distance1)));
                            vOut[numOut] = new CollidePoly.ClipVertex();
                            vOut[numOut].v.x = Math.fround(vIn[0].v.x + Math.fround(interp * (Math.fround(vIn[1].v.x - vIn[0].v.x))));
                            vOut[numOut].v.y = Math.fround(vIn[0].v.y + Math.fround(interp * (Math.fround(vIn[1].v.y - vIn[0].v.y))));
                            if (distance0 > 0.0) {
                                vOut[numOut].id.set(vIn[0].id);
                            }
                            else {
                                vOut[numOut].id.set(vIn[1].id);
                            }
                            ++numOut;
                        }
                        return numOut;
                    };
                    CollidePoly.prototype.edgeSeparation = function (poly1, xf1, edge1, poly2, xf2) {
                        var count1 = poly1.getVertexCount();
                        var vertices1 = poly1.getVertices();
                        var normals1 = poly1.getNormals();
                        var count2 = poly2.getVertexCount();
                        var vertices2 = poly2.getVertices();
                        if (!((0 <= edge1 && edge1 < count1)))
                            throw new Error("Assertion error line 44: assert (0 <= edge1 && edge1 < count1);");
                        ;
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, normals1[edge1], this.normal1World);
                        var normal1x = org.jbox2d.common.Vec2.dot(this.normal1World, xf2.R.col1);
                        var normal1y = org.jbox2d.common.Vec2.dot(this.normal1World, xf2.R.col2);
                        var index = 0;
                        var minDot = 3.4028235E38;
                        for (var i = 0; i < count2; ++i) {
                            {
                                var dot = Math.fround(Math.fround(vertices2[i].x * normal1x) + Math.fround(vertices2[i].y * normal1y));
                                if (dot < minDot) {
                                    minDot = dot;
                                    index = i;
                                }
                            }
                            ;
                        }
                        var v = vertices1[edge1];
                        var v1x = Math.fround(Math.fround(xf1.position.x + Math.fround(xf1.R.col1.x * v.x)) + Math.fround(xf1.R.col2.x * v.y));
                        var v1y = Math.fround(Math.fround(xf1.position.y + Math.fround(xf1.R.col1.y * v.x)) + Math.fround(xf1.R.col2.y * v.y));
                        var v3 = vertices2[index];
                        var v2x = Math.fround(Math.fround(xf2.position.x + Math.fround(xf2.R.col1.x * v3.x)) + Math.fround(xf2.R.col2.x * v3.y));
                        var v2y = Math.fround(Math.fround(xf2.position.y + Math.fround(xf2.R.col1.y * v3.x)) + Math.fround(xf2.R.col2.y * v3.y));
                        var separation = Math.fround(Math.fround((Math.fround(v2x - v1x)) * this.normal1World.x) + Math.fround((Math.fround(v2y - v1y)) * this.normal1World.y));
                        return separation;
                    };
                    /**
                     * Find the max separation between poly1 and poly2 using face normals
                     * from poly1.
                     * @param {org.jbox2d.collision.shapes.PolygonShape} poly1
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.PolygonShape} poly2
                     * @param {org.jbox2d.common.XForm} xf2
                     * @return
                     * @return {org.jbox2d.collision.shapes.MaxSeparation}
                     */
                    CollidePoly.prototype.findMaxSeparation = function (poly1, xf1, poly2, xf2) {
                        var separation = new org.jbox2d.collision.shapes.MaxSeparation();
                        var count1 = poly1.getVertexCount();
                        var normals1 = poly1.getNormals();
                        var v = poly1.getCentroid();
                        var v1 = poly2.getCentroid();
                        var dx = Math.fround(Math.fround(Math.fround(xf2.position.x + Math.fround(xf2.R.col1.x * v1.x)) + Math.fround(xf2.R.col2.x * v1.y)) - (Math.fround(Math.fround(xf1.position.x + Math.fround(xf1.R.col1.x * v.x)) + Math.fround(xf1.R.col2.x * v.y))));
                        var dy = Math.fround(Math.fround(Math.fround(xf2.position.y + Math.fround(xf2.R.col1.y * v1.x)) + Math.fround(xf2.R.col2.y * v1.y)) - (Math.fround(Math.fround(xf1.position.y + Math.fround(xf1.R.col1.y * v.x)) + Math.fround(xf1.R.col2.y * v.y))));
                        var b = xf1.R.col1;
                        var b1 = xf1.R.col2;
                        this.dLocal1.x = (Math.fround(Math.fround(dx * b.x) + Math.fround(dy * b.y)));
                        this.dLocal1.y = (Math.fround(Math.fround(dx * b1.x) + Math.fround(dy * b1.y)));
                        var edge = 0;
                        var maxDot = -3.4028235E38;
                        for (var i = 0; i < count1; ++i) {
                            {
                                var dot = org.jbox2d.common.Vec2.dot(normals1[i], this.dLocal1);
                                if (dot > maxDot) {
                                    maxDot = dot;
                                    edge = i;
                                }
                            }
                            ;
                        }
                        var s = this.edgeSeparation(poly1, xf1, edge, poly2, xf2);
                        if (s > 0.0) {
                            separation.bestSeparation = s;
                            return separation;
                        }
                        var prevEdge = edge - 1 >= 0 ? edge - 1 : count1 - 1;
                        var sPrev = this.edgeSeparation(poly1, xf1, prevEdge, poly2, xf2);
                        if (sPrev > 0.0) {
                            separation.bestSeparation = sPrev;
                            return separation;
                        }
                        var nextEdge = edge + 1 < count1 ? edge + 1 : 0;
                        var sNext = this.edgeSeparation(poly1, xf1, nextEdge, poly2, xf2);
                        if (sNext > 0.0) {
                            separation.bestSeparation = sNext;
                            return separation;
                        }
                        var bestEdge;
                        var bestSeparation;
                        var increment;
                        if (sPrev > s && sPrev > sNext) {
                            increment = -1;
                            bestEdge = prevEdge;
                            bestSeparation = sPrev;
                        }
                        else if (sNext > s) {
                            increment = 1;
                            bestEdge = nextEdge;
                            bestSeparation = sNext;
                        }
                        else {
                            separation.bestFaceIndex = edge;
                            separation.bestSeparation = s;
                            return separation;
                        }
                        while ((true)) {
                            {
                                if (increment === -1) {
                                    edge = bestEdge - 1 >= 0 ? bestEdge - 1 : count1 - 1;
                                }
                                else {
                                    edge = bestEdge + 1 < count1 ? bestEdge + 1 : 0;
                                }
                                s = this.edgeSeparation(poly1, xf1, edge, poly2, xf2);
                                if (s > 0.0) {
                                    separation.bestSeparation = s;
                                    return separation;
                                }
                                if (s > bestSeparation) {
                                    bestEdge = edge;
                                    bestSeparation = s;
                                }
                                else {
                                    break;
                                }
                            }
                        }
                        ;
                        separation.bestFaceIndex = bestEdge;
                        separation.bestSeparation = bestSeparation;
                        return separation;
                    };
                    CollidePoly.prototype.findIncidentEdge = function (c, poly1, xf1, edge1, poly2, xf2) {
                        var count1 = poly1.getVertexCount();
                        var normals1 = poly1.getNormals();
                        var count2 = poly2.getVertexCount();
                        var vertices2 = poly2.getVertices();
                        var normals2 = poly2.getNormals();
                        if (!((0 <= edge1 && edge1 < count1)))
                            throw new Error("Assertion error line 166: assert (0 <= edge1 && edge1 < count1);");
                        ;
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, normals1[edge1], this.mulTemp);
                        org.jbox2d.common.Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf2.R, this.mulTemp, this.normal1);
                        var index = 0;
                        var minDot = 3.4028235E38;
                        for (var i = 0; i < count2; ++i) {
                            {
                                var dot = org.jbox2d.common.Vec2.dot(this.normal1, normals2[i]);
                                if (dot < minDot) {
                                    minDot = dot;
                                    index = i;
                                }
                            }
                            ;
                        }
                        var i1 = index;
                        var i2 = i1 + 1 < count2 ? i1 + 1 : 0;
                        c[0] = new CollidePoly.ClipVertex();
                        c[1] = new CollidePoly.ClipVertex();
                        org.jbox2d.common.XForm.mulToOut(xf2, vertices2[i1], c[0].v);
                        c[0].id.features.referenceEdge = edge1;
                        c[0].id.features.incidentEdge = i1;
                        c[0].id.features.incidentVertex = 0;
                        org.jbox2d.common.XForm.mulToOut(xf2, vertices2[i2], c[1].v);
                        c[1].id.features.referenceEdge = edge1;
                        c[1].id.features.incidentEdge = i2;
                        c[1].id.features.incidentVertex = 1;
                    };
                    CollidePoly.prototype.collidePolygons = function (manif, polyA, xfA, polyB, xfB) {
                        manif.pointCount = 0;
                        var sepA = this.findMaxSeparation(polyA, xfA, polyB, xfB);
                        if (sepA.bestSeparation > 0.0) {
                            return;
                        }
                        var sepB = this.findMaxSeparation(polyB, xfB, polyA, xfA);
                        if (sepB.bestSeparation > 0.0) {
                            return;
                        }
                        var poly1;
                        var poly2;
                        var xf1 = this.p_xf1;
                        var xf2 = this.p_xf2;
                        var edge1;
                        var flip;
                        var k_relativeTol = 0.98;
                        var k_absoluteTol = 0.001;
                        if (sepB.bestSeparation > Math.fround(Math.fround(k_relativeTol * sepA.bestSeparation) + k_absoluteTol)) {
                            poly1 = polyB;
                            poly2 = polyA;
                            xf1.set(xfB);
                            xf2.set(xfA);
                            edge1 = sepB.bestFaceIndex;
                            flip = 1;
                        }
                        else {
                            poly1 = polyA;
                            poly2 = polyB;
                            xf1.set(xfA);
                            xf2.set(xfB);
                            edge1 = sepA.bestFaceIndex;
                            flip = 0;
                        }
                        var incidentEdge = [null, null];
                        this.findIncidentEdge(incidentEdge, poly1, xf1, edge1, poly2, xf2);
                        var count1 = poly1.getVertexCount();
                        var vertices1 = poly1.getVertices();
                        var v11 = vertices1[edge1];
                        var v12 = edge1 + 1 < count1 ? vertices1[edge1 + 1] : vertices1[0];
                        var v1x = Math.fround(v12.x - v11.x);
                        var v1y = Math.fround(v12.y - v11.y);
                        this.sideNormal.set$float$float(Math.fround(Math.fround(xf1.R.col1.x * v1x) + Math.fround(xf1.R.col2.x * v1y)), Math.fround(Math.fround(xf1.R.col1.y * v1x) + Math.fround(xf1.R.col2.y * v1y)));
                        this.sideNormal.normalize();
                        this.frontNormal.set$float$float(this.sideNormal.y, -this.sideNormal.x);
                        var v11x = Math.fround(Math.fround(xf1.position.x + Math.fround(xf1.R.col1.x * v11.x)) + Math.fround(xf1.R.col2.x * v11.y));
                        var v11y = Math.fround(Math.fround(xf1.position.y + Math.fround(xf1.R.col1.y * v11.x)) + Math.fround(xf1.R.col2.y * v11.y));
                        var v12x = Math.fround(Math.fround(xf1.position.x + Math.fround(xf1.R.col1.x * v12.x)) + Math.fround(xf1.R.col2.x * v12.y));
                        var v12y = Math.fround(Math.fround(xf1.position.y + Math.fround(xf1.R.col1.y * v12.x)) + Math.fround(xf1.R.col2.y * v12.y));
                        var frontOffset = Math.fround(Math.fround(this.frontNormal.x * v11x) + Math.fround(this.frontNormal.y * v11y));
                        var sideOffset1 = -(Math.fround(Math.fround(this.sideNormal.x * v11x) + Math.fround(this.sideNormal.y * v11y)));
                        var sideOffset2 = Math.fround(Math.fround(this.sideNormal.x * v12x) + Math.fround(this.sideNormal.y * v12y));
                        var clipPoints1 = [null, null];
                        var clipPoints2 = [null, null];
                        var np;
                        np = this.clipSegmentToLine(clipPoints1, incidentEdge, this.sideNormal.negate(), sideOffset1);
                        if (np < 2) {
                            return;
                        }
                        np = this.clipSegmentToLine(clipPoints2, clipPoints1, this.sideNormal, sideOffset2);
                        if (np < 2) {
                            return;
                        }
                        manif.normal.set$org_jbox2d_common_Vec2(this.frontNormal);
                        if (flip !== 0) {
                            manif.normal.negateLocal();
                        }
                        var pointCount = 0;
                        for (var i = 0; i < org.jbox2d.common.Settings.maxManifoldPoints; ++i) {
                            {
                                var separation = Math.fround(org.jbox2d.common.Vec2.dot(this.frontNormal, clipPoints2[i].v) - frontOffset);
                                if (separation <= 0.0) {
                                    var cp = manif.points[pointCount];
                                    cp.separation = separation;
                                    var vec = clipPoints2[i].v;
                                    var u1x = Math.fround(vec.x - xfA.position.x);
                                    var u1y = Math.fround(vec.y - xfA.position.y);
                                    cp.localPoint1.x = (Math.fround(Math.fround(u1x * xfA.R.col1.x) + Math.fround(u1y * xfA.R.col1.y)));
                                    cp.localPoint1.y = (Math.fround(Math.fround(u1x * xfA.R.col2.x) + Math.fround(u1y * xfA.R.col2.y)));
                                    u1x = Math.fround(vec.x - xfB.position.x);
                                    u1y = Math.fround(vec.y - xfB.position.y);
                                    cp.localPoint2.x = (Math.fround(Math.fround(u1x * xfB.R.col1.x) + Math.fround(u1y * xfB.R.col1.y)));
                                    cp.localPoint2.y = (Math.fround(Math.fround(u1x * xfB.R.col2.x) + Math.fround(u1y * xfB.R.col2.y)));
                                    cp.id.set(clipPoints2[i].id);
                                    cp.id.features.flip = flip;
                                    ++pointCount;
                                }
                            }
                            ;
                        }
                        manif.pointCount = pointCount;
                        return;
                    };
                    /**
                     * puts collision information into the manifold about the collision between a polygon and a point
                     * @param {org.jbox2d.collision.Manifold} manifold
                     * @param {org.jbox2d.collision.shapes.PolygonShape} polygon
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.PointShape} point
                     * @param {org.jbox2d.common.XForm} xf2
                     */
                    CollidePoly.prototype.collidePolygonAndPoint = function (manifold, polygon, xf1, point, xf2) {
                        manifold.pointCount = 0;
                        org.jbox2d.common.XForm.mulToOut(xf2, point.getMemberLocalPosition(), this.colPPc);
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.colPPc, this.colPPcLocal);
                        var normalIndex = 0;
                        var separation = -3.4028235E38;
                        var vertexCount = polygon.getVertexCount();
                        var vertices = polygon.getVertices();
                        var normals = polygon.getNormals();
                        for (var i = 0; i < vertexCount; ++i) {
                            {
                                this.colPPsub.set$org_jbox2d_common_Vec2(this.colPPcLocal);
                                this.colPPsub.subLocal(vertices[i]);
                                var s = org.jbox2d.common.Vec2.dot(normals[i], this.colPPsub);
                                if (s > 0) {
                                    return;
                                }
                                if (s > separation) {
                                    normalIndex = i;
                                    separation = s;
                                }
                            }
                            ;
                        }
                        if (separation < org.jbox2d.common.Settings.EPSILON) {
                            manifold.pointCount = 1;
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, normals[normalIndex], manifold.normal);
                            manifold.points[0].id.features.incidentEdge = normalIndex;
                            manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.referenceEdge = 0;
                            manifold.points[0].id.features.flip = 0;
                            var position_1 = this.colPPc;
                            org.jbox2d.common.XForm.mulTransToOut(xf1, position_1, manifold.points[0].localPoint1);
                            org.jbox2d.common.XForm.mulTransToOut(xf2, position_1, manifold.points[0].localPoint2);
                            manifold.points[0].separation = separation;
                            return;
                        }
                        var vertIndex1 = normalIndex;
                        var vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
                        this.colPPe.set$org_jbox2d_common_Vec2(vertices[vertIndex2]);
                        this.colPPe.subLocal(vertices[vertIndex1]);
                        var length = this.colPPe.normalize();
                        if (!((length > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 341: assert (length > Settings.EPSILON);");
                        ;
                        this.colPPsub.set$org_jbox2d_common_Vec2(this.colPPcLocal);
                        this.colPPsub.subLocal(vertices[vertIndex1]);
                        var u = org.jbox2d.common.Vec2.dot(this.colPPsub, this.colPPe);
                        this.colPPp.setZero();
                        if (u <= 0.0) {
                            this.colPPp.set$org_jbox2d_common_Vec2(vertices[vertIndex1]);
                            manifold.points[0].id.features.incidentEdge = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.incidentVertex = vertIndex1;
                        }
                        else if (u >= length) {
                            this.colPPp.set$org_jbox2d_common_Vec2(vertices[vertIndex2]);
                            manifold.points[0].id.features.incidentEdge = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.incidentVertex = vertIndex2;
                        }
                        else {
                            this.colPPp.set$org_jbox2d_common_Vec2(vertices[vertIndex1]);
                            this.colPPp.x += Math.fround(u * this.colPPe.x);
                            this.colPPp.y += Math.fround(u * this.colPPe.y);
                            manifold.points[0].id.features.incidentEdge = normalIndex;
                            manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                        }
                        this.colPPd.set$org_jbox2d_common_Vec2(this.colPPcLocal);
                        this.colPPd.subLocal(this.colPPp);
                        var dist = this.colPPd.normalize();
                        if (dist > 0) {
                            return;
                        }
                        manifold.pointCount = 1;
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, this.colPPd, manifold.normal);
                        var position = this.colPPc;
                        org.jbox2d.common.XForm.mulTransToOut(xf1, position, manifold.points[0].localPoint1);
                        org.jbox2d.common.XForm.mulTransToOut(xf2, position, manifold.points[0].localPoint2);
                        manifold.points[0].separation = dist;
                        manifold.points[0].id.features.referenceEdge = 0;
                        manifold.points[0].id.features.flip = 0;
                    };
                    /**
                     * puts collision information into the manifold about a collision between
                     * a polygon and an edge
                     * @param {org.jbox2d.collision.Manifold} manifold
                     * @param {org.jbox2d.collision.shapes.PolygonShape} polygon
                     * @param {org.jbox2d.common.XForm} xf1
                     * @param {org.jbox2d.collision.shapes.EdgeShape} edge
                     * @param {org.jbox2d.common.XForm} xf2
                     */
                    CollidePoly.prototype.collidePolyAndEdge = function (manifold, polygon, xf1, edge, xf2) {
                        manifold.pointCount = 0;
                        org.jbox2d.common.XForm.mulToOut(xf2, edge.getVertex1(), this.PEv1);
                        org.jbox2d.common.XForm.mulToOut(xf2, edge.getVertex2(), this.PEv2);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf2.R, edge.getNormalVector(), this.PEn);
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.PEv1, this.PEv1Local);
                        org.jbox2d.common.XForm.mulTransToOut(xf1, this.PEv2, this.PEv2Local);
                        org.jbox2d.common.Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, this.PEn, this.PEnLocal);
                        var separation1;
                        var separationIndex1 = -1;
                        var separationMax1 = -3.4028235E38;
                        var separation2;
                        var separationIndex2 = -1;
                        var separationMax2 = -3.4028235E38;
                        var separationMax = -3.4028235E38;
                        var separationV1 = false;
                        var separationIndex = -1;
                        var vertexCount = polygon.getVertexCount();
                        var vertices = polygon.getVertices();
                        var normals = polygon.getNormals();
                        var enterStartIndex = -1;
                        var enterEndIndex = -1;
                        var exitStartIndex = -1;
                        var exitEndIndex = -1;
                        var prevSepN = 0.0;
                        var nextSepN = 0.0;
                        var enterSepN = 0.0;
                        var exitSepN = 0.0;
                        var deepestSepN = 3.4028235E38;
                        this.temp.set$org_jbox2d_common_Vec2(vertices[vertexCount - 1]);
                        this.temp.subLocal(this.PEv1Local);
                        prevSepN = org.jbox2d.common.Vec2.dot(this.temp, this.PEnLocal);
                        for (var i = 0; i < vertexCount; i++) {
                            {
                                this.temp.set$org_jbox2d_common_Vec2(this.PEv1Local);
                                this.temp.subLocal(vertices[i]);
                                separation1 = org.jbox2d.common.Vec2.dot(this.temp, normals[i]);
                                this.temp.set$org_jbox2d_common_Vec2(this.PEv2Local);
                                this.temp.subLocal(vertices[i]);
                                separation2 = org.jbox2d.common.Vec2.dot(this.temp, normals[i]);
                                if (separation2 < separation1) {
                                    if (separation2 > separationMax) {
                                        separationMax = separation2;
                                        separationV1 = false;
                                        separationIndex = i;
                                    }
                                }
                                else {
                                    if (separation1 > separationMax) {
                                        separationMax = separation1;
                                        separationV1 = true;
                                        separationIndex = i;
                                    }
                                }
                                if (separation1 > separationMax1) {
                                    separationMax1 = separation1;
                                    separationIndex1 = i;
                                }
                                if (separation2 > separationMax2) {
                                    separationMax2 = separation2;
                                    separationIndex2 = i;
                                }
                                this.temp.set$org_jbox2d_common_Vec2(vertices[i]);
                                this.temp.subLocal(this.PEv1Local);
                                nextSepN = org.jbox2d.common.Vec2.dot(this.temp, this.PEnLocal);
                                if (nextSepN >= 0.0 && prevSepN < 0.0) {
                                    exitStartIndex = (i === 0) ? vertexCount - 1 : i - 1;
                                    exitEndIndex = i;
                                    exitSepN = prevSepN;
                                }
                                else if (nextSepN < 0.0 && prevSepN >= 0.0) {
                                    enterStartIndex = (i === 0) ? vertexCount - 1 : i - 1;
                                    enterEndIndex = i;
                                    enterSepN = nextSepN;
                                }
                                if (nextSepN < deepestSepN) {
                                    deepestSepN = nextSepN;
                                }
                                prevSepN = nextSepN;
                            }
                            ;
                        }
                        if (enterStartIndex === -1) {
                            return;
                        }
                        if (separationMax > 0.0) {
                            return;
                        }
                        if ((separationV1 && edge.corner1IsConvex()) || (!separationV1 && edge.corner2IsConvex())) {
                            if (separationMax > Math.fround(deepestSepN + org.jbox2d.common.Settings.linearSlop_$LI$())) {
                                if (separationV1) {
                                    org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf2.R, edge.getCorner1Vector(), this.temp);
                                    org.jbox2d.common.Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, this.temp, this.temp);
                                    if (org.jbox2d.common.Vec2.dot(normals[separationIndex1], this.temp) >= 0.0) {
                                        return;
                                    }
                                }
                                else {
                                    org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf2.R, edge.getCorner2Vector(), this.temp);
                                    org.jbox2d.common.Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, this.temp, this.temp);
                                    if (org.jbox2d.common.Vec2.dot(normals[separationIndex2], this.temp) <= 0.0) {
                                        return;
                                    }
                                }
                                manifold.pointCount = 1;
                                org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(xf1.R, normals[separationIndex], manifold.normal);
                                manifold.points[0].separation = separationMax;
                                manifold.points[0].id.features.incidentEdge = separationIndex;
                                manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                                manifold.points[0].id.features.referenceEdge = 0;
                                manifold.points[0].id.features.flip = 0;
                                if (separationV1) {
                                    manifold.points[0].localPoint1.set$org_jbox2d_common_Vec2(this.PEv1Local);
                                    manifold.points[0].localPoint2.set$org_jbox2d_common_Vec2(edge.getVertex1());
                                }
                                else {
                                    manifold.points[0].localPoint1.set$org_jbox2d_common_Vec2(this.PEv2Local);
                                    manifold.points[0].localPoint2.set$org_jbox2d_common_Vec2(edge.getVertex2());
                                }
                                return;
                            }
                        }
                        this.temp.set$org_jbox2d_common_Vec2(this.PEn);
                        this.temp.mulLocal(-1.0);
                        manifold.normal.set$org_jbox2d_common_Vec2(this.temp);
                        if (enterEndIndex === exitStartIndex) {
                            manifold.pointCount = 1;
                            manifold.points[0].id.features.incidentEdge = enterEndIndex;
                            manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                            manifold.points[0].id.features.referenceEdge = 0;
                            manifold.points[0].id.features.flip = 0;
                            manifold.points[0].localPoint1.set$org_jbox2d_common_Vec2(vertices[enterEndIndex]);
                            org.jbox2d.common.XForm.mulTransToOut(xf2, org.jbox2d.common.XForm.mul(xf1, vertices[enterEndIndex]), manifold.points[0].localPoint2);
                            manifold.points[0].separation = enterSepN;
                            return;
                        }
                        manifold.pointCount = 2;
                        org.jbox2d.common.Vec2.crossToOut$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2(this.PEnLocal, -1.0, this.temp);
                        this.temp2.set$org_jbox2d_common_Vec2(vertices[enterEndIndex]);
                        this.temp2.subLocal(this.PEv1Local);
                        var dirProj1 = org.jbox2d.common.Vec2.dot(this.temp, this.temp2);
                        var dirProj2 = 0.0;
                        this.temp2.set$org_jbox2d_common_Vec2(vertices[exitStartIndex]);
                        this.temp2.subLocal(this.PEv1Local);
                        exitEndIndex = (enterEndIndex === vertexCount - 1) ? 0 : enterEndIndex + 1;
                        if (exitEndIndex !== exitStartIndex) {
                            exitStartIndex = exitEndIndex;
                            exitSepN = org.jbox2d.common.Vec2.dot(this.PEnLocal, this.temp2);
                        }
                        dirProj2 = org.jbox2d.common.Vec2.dot(this.temp, this.temp2);
                        manifold.points[0].id.features.incidentEdge = enterEndIndex;
                        manifold.points[0].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                        manifold.points[0].id.features.referenceEdge = 0;
                        manifold.points[0].id.features.flip = 0;
                        if (dirProj1 > edge.getLength()) {
                            manifold.points[0].localPoint1.set$org_jbox2d_common_Vec2(this.PEv2Local);
                            manifold.points[0].localPoint2.set$org_jbox2d_common_Vec2(edge.getVertex2());
                            var ratio = Math.fround((Math.fround(edge.getLength() - dirProj2)) / (Math.fround(dirProj1 - dirProj2)));
                            if (ratio > Math.fround(100.0 * org.jbox2d.common.Settings.EPSILON) && ratio < 1.0) {
                                manifold.points[0].separation = Math.fround(Math.fround(exitSepN * (Math.fround(1.0 - ratio))) + Math.fround(enterSepN * ratio));
                            }
                            else {
                                manifold.points[0].separation = enterSepN;
                            }
                        }
                        else {
                            manifold.points[0].localPoint1.set$org_jbox2d_common_Vec2(vertices[enterEndIndex]);
                            org.jbox2d.common.XForm.mulTransToOut(xf2, org.jbox2d.common.XForm.mul(xf1, vertices[enterEndIndex]), manifold.points[0].localPoint2);
                            manifold.points[0].separation = enterSepN;
                        }
                        manifold.points[1].id.features.incidentEdge = exitStartIndex;
                        manifold.points[1].id.features.incidentVertex = org.jbox2d.collision.Collision.NULL_FEATURE_$LI$();
                        manifold.points[1].id.features.referenceEdge = 0;
                        manifold.points[1].id.features.flip = 0;
                        if (dirProj2 < 0.0) {
                            manifold.points[1].localPoint1.set$org_jbox2d_common_Vec2(this.PEv1Local);
                            manifold.points[1].localPoint2.set$org_jbox2d_common_Vec2(edge.getVertex1());
                            var ratio = Math.fround((-dirProj1) / (Math.fround(dirProj2 - dirProj1)));
                            if (ratio > Math.fround(100.0 * org.jbox2d.common.Settings.EPSILON) && ratio < 1.0) {
                                manifold.points[1].separation = Math.fround(Math.fround(enterSepN * (Math.fround(1.0 - ratio))) + Math.fround(exitSepN * ratio));
                            }
                            else {
                                manifold.points[1].separation = exitSepN;
                            }
                        }
                        else {
                            manifold.points[1].localPoint1.set$org_jbox2d_common_Vec2(vertices[exitStartIndex]);
                            org.jbox2d.common.XForm.mulTransToOut(xf2, org.jbox2d.common.XForm.mul(xf1, vertices[exitStartIndex]), manifold.points[1].localPoint2);
                            manifold.points[1].separation = exitSepN;
                        }
                    };
                    return CollidePoly;
                }());
                shapes.CollidePoly = CollidePoly;
                CollidePoly["__class"] = "org.jbox2d.collision.shapes.CollidePoly";
                (function (CollidePoly) {
                    var ClipVertex = (function () {
                        function ClipVertex() {
                            if (this.v === undefined)
                                this.v = null;
                            if (this.id === undefined)
                                this.id = null;
                            this.v = new org.jbox2d.common.Vec2();
                            this.id = new org.jbox2d.collision.ContactID();
                        }
                        return ClipVertex;
                    }());
                    CollidePoly.ClipVertex = ClipVertex;
                    ClipVertex["__class"] = "org.jbox2d.collision.shapes.CollidePoly.ClipVertex";
                })(CollidePoly = shapes.CollidePoly || (shapes.CollidePoly = {}));
                /**
                 * Holder class used internally in CollidePoly
                 * @class
                 */
                var MaxSeparation = (function () {
                    function MaxSeparation() {
                        if (this.bestFaceIndex === undefined)
                            this.bestFaceIndex = 0;
                        if (this.bestSeparation === undefined)
                            this.bestSeparation = 0;
                    }
                    return MaxSeparation;
                }());
                shapes.MaxSeparation = MaxSeparation;
                MaxSeparation["__class"] = "org.jbox2d.collision.shapes.MaxSeparation";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * Superclass for shape definitions.
                 * You should usually use CircleDef or
                 * PolygonDef to define concrete shapes.
                 * @class
                 */
                var ShapeDef = (function () {
                    function ShapeDef() {
                        if (this.type === undefined)
                            this.type = null;
                        if (this.userData === undefined)
                            this.userData = null;
                        if (this.friction === undefined)
                            this.friction = 0;
                        if (this.restitution === undefined)
                            this.restitution = 0;
                        if (this.density === undefined)
                            this.density = 0;
                        if (this.filter === undefined)
                            this.filter = null;
                        if (this.isSensor === undefined)
                            this.isSensor = false;
                        this.type = org.jbox2d.collision.shapes.ShapeType.UNKNOWN_SHAPE;
                        this.userData = null;
                        this.friction = 0.2;
                        this.restitution = 0.0;
                        this.density = 0.0;
                        this.filter = new org.jbox2d.collision.FilterData();
                        this.filter.categoryBits = 1;
                        this.filter.maskBits = 65535;
                        this.filter.groupIndex = 0;
                        this.isSensor = false;
                    }
                    return ShapeDef;
                }());
                shapes.ShapeDef = ShapeDef;
                ShapeDef["__class"] = "org.jbox2d.collision.shapes.ShapeDef";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                var ShapeType;
                (function (ShapeType) {
                    ShapeType[ShapeType["UNKNOWN_SHAPE"] = 0] = "UNKNOWN_SHAPE";
                    ShapeType[ShapeType["CIRCLE_SHAPE"] = 1] = "CIRCLE_SHAPE";
                    ShapeType[ShapeType["POLYGON_SHAPE"] = 2] = "POLYGON_SHAPE";
                    ShapeType[ShapeType["POINT_SHAPE"] = 3] = "POINT_SHAPE";
                    ShapeType[ShapeType["EDGE_SHAPE"] = 4] = "EDGE_SHAPE";
                    ShapeType[ShapeType["SHAPE_TYPE_COUNT"] = 5] = "SHAPE_TYPE_COUNT";
                })(ShapeType = shapes.ShapeType || (shapes.ShapeType = {}));
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * Similar to javax.vecmath.Color3f holder
             * @author ewjordan
             * @param {number} r
             * @param {number} g
             * @param {number} b
             * @class
             */
            var Color3f = (function () {
                function Color3f(r, g, b) {
                    if (this.x === undefined)
                        this.x = 0;
                    if (this.y === undefined)
                        this.y = 0;
                    if (this.z === undefined)
                        this.z = 0;
                    this.x = r;
                    this.y = g;
                    this.z = b;
                }
                Color3f.WHITE_$LI$ = function () { if (Color3f.WHITE == null)
                    Color3f.WHITE = new Color3f(255, 255, 255); return Color3f.WHITE; };
                ;
                Color3f.BLACK_$LI$ = function () { if (Color3f.BLACK == null)
                    Color3f.BLACK = new Color3f(0, 0, 0); return Color3f.BLACK; };
                ;
                Color3f.BLUE_$LI$ = function () { if (Color3f.BLUE == null)
                    Color3f.BLUE = new Color3f(0, 0, 255); return Color3f.BLUE; };
                ;
                Color3f.GREEN_$LI$ = function () { if (Color3f.GREEN == null)
                    Color3f.GREEN = new Color3f(0, 255, 0); return Color3f.GREEN; };
                ;
                Color3f.RED_$LI$ = function () { if (Color3f.RED == null)
                    Color3f.RED = new Color3f(255, 0, 0); return Color3f.RED; };
                ;
                return Color3f;
            }());
            common.Color3f = Color3f;
            Color3f["__class"] = "org.jbox2d.common.Color3f";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * Create a matrix from four floats.
             * @param {number} col1x
             * @param {number} col2x
             * @param {number} col1y
             * @param {number} col2y
             * @class
             * @author ewjordan
             */
            var Mat22 = (function () {
                function Mat22(col1x, col2x, col1y, col2y) {
                    var _this = this;
                    if (((typeof col1x === 'number') || col1x === null) && ((typeof col2x === 'number') || col2x === null) && ((typeof col1y === 'number') || col1y === null) && ((typeof col2y === 'number') || col2y === null)) {
                        var __args = arguments;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        (function () {
                            _this.col1 = new org.jbox2d.common.Vec2(col1x, col1y);
                            _this.col2 = new org.jbox2d.common.Vec2(col2x, col2y);
                        })();
                    }
                    else if (((col1x != null && col1x instanceof org.jbox2d.common.Vec2) || col1x === null) && ((col2x != null && col2x instanceof org.jbox2d.common.Vec2) || col2x === null) && col1y === undefined && col2y === undefined) {
                        var __args = arguments;
                        var c1_1 = __args[0];
                        var c2_1 = __args[1];
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        (function () {
                            _this.col1 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(c1_1);
                            _this.col2 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(c2_1);
                        })();
                    }
                    else if (col1x === undefined && col2x === undefined && col1y === undefined && col2y === undefined) {
                        var __args = arguments;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        (function () {
                            _this.col1 = new org.jbox2d.common.Vec2();
                            _this.col2 = new org.jbox2d.common.Vec2();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * Convert the matrix to printable format.
                 * @return {string}
                 */
                Mat22.prototype.toString = function () {
                    var s = "";
                    s += "[" + this.col1.x + "," + this.col2.x + "]\n";
                    s += "[" + this.col1.y + "," + this.col2.y + "]";
                    return s;
                };
                Mat22.prototype.set$org_jbox2d_common_Mat22 = function (m) {
                    this.col1.x = m.col1.x;
                    this.col1.y = m.col1.y;
                    this.col2.x = m.col2.x;
                    this.col2.y = m.col2.y;
                    return this;
                };
                Mat22.prototype.set$float$float$float$float = function (col1x, col2x, col1y, col2y) {
                    this.col1.x = col1x;
                    this.col1.y = col1y;
                    this.col2.x = col2x;
                    this.col2.y = col2y;
                    return this;
                };
                Mat22.prototype.set = function (col1x, col2x, col1y, col2y) {
                    if (((typeof col1x === 'number') || col1x === null) && ((typeof col2x === 'number') || col2x === null) && ((typeof col1y === 'number') || col1y === null) && ((typeof col2y === 'number') || col2y === null)) {
                        return this.set$float$float$float$float(col1x, col2x, col1y, col2y);
                    }
                    else if (((col1x != null && col1x instanceof org.jbox2d.common.Vec2) || col1x === null) && ((col2x != null && col2x instanceof org.jbox2d.common.Vec2) || col2x === null) && col1y === undefined && col2y === undefined) {
                        return this.set$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(col1x, col2x);
                    }
                    else if (((col1x != null && col1x instanceof org.jbox2d.common.Mat22) || col1x === null) && col2x === undefined && col1y === undefined && col2y === undefined) {
                        return this.set$org_jbox2d_common_Mat22(col1x);
                    }
                    else if (((typeof col1x === 'number') || col1x === null) && col2x === undefined && col1y === undefined && col2y === undefined) {
                        return this.set$float(col1x);
                    }
                    else
                        throw new Error('invalid overload');
                };
                /**
                 * Return a clone of this matrix.
                 * djm fixed double allocation
                 * @return {org.jbox2d.common.Mat22}
                 */
                Mat22.prototype.clone = function () {
                    return new Mat22(this.col1, this.col2);
                };
                Mat22.prototype.set$float = function (angle) {
                    var c = org.jbox2d.common.MathUtils.cos(angle);
                    var s = org.jbox2d.common.MathUtils.sin(angle);
                    this.col1.x = c;
                    this.col2.x = -s;
                    this.col1.y = s;
                    this.col2.y = c;
                };
                /**
                 * Set as the identity matrix.
                 */
                Mat22.prototype.setIdentity = function () {
                    this.col1.x = 1.0;
                    this.col2.x = 0.0;
                    this.col1.y = 0.0;
                    this.col2.y = 1.0;
                };
                /**
                 * Set as the zero matrix.
                 */
                Mat22.prototype.setZero = function () {
                    this.col1.x = 0.0;
                    this.col2.x = 0.0;
                    this.col1.y = 0.0;
                    this.col2.y = 0.0;
                };
                Mat22.prototype.set$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (c1, c2) {
                    this.col1.x = c1.x;
                    this.col2.x = c2.x;
                    this.col1.y = c1.y;
                    this.col2.y = c2.y;
                };
                /**
                 * Returns the inverted Mat22 - does NOT invert the matrix locally!
                 * @return {org.jbox2d.common.Mat22}
                 */
                Mat22.prototype.invert = function () {
                    var a = this.col1.x;
                    var b = this.col2.x;
                    var c = this.col1.y;
                    var d = this.col2.y;
                    var B = new Mat22();
                    var det = Math.fround(Math.fround(a * d) - Math.fround(b * c));
                    det = Math.fround(1.0 / det);
                    B.col1.x = Math.fround(det * d);
                    B.col2.x = Math.fround(-det * b);
                    B.col1.y = Math.fround(-det * c);
                    B.col2.y = Math.fround(det * a);
                    return B;
                };
                Mat22.prototype.invertLocal = function () {
                    var a = this.col1.x;
                    var b = this.col2.x;
                    var c = this.col1.y;
                    var d = this.col2.y;
                    var det = Math.fround(Math.fround(a * d) - Math.fround(b * c));
                    det = Math.fround(1.0 / det);
                    this.col1.x = Math.fround(det * d);
                    this.col2.x = Math.fround(-det * b);
                    this.col1.y = Math.fround(-det * c);
                    this.col2.y = Math.fround(det * a);
                    return this;
                };
                Mat22.prototype.invertToOut = function (out) {
                    var a = this.col1.x;
                    var b = this.col2.x;
                    var c = this.col1.y;
                    var d = this.col2.y;
                    var det = Math.fround(Math.fround(a * d) - Math.fround(b * c));
                    det = Math.fround(1.0 / det);
                    out.col1.x = Math.fround(det * d);
                    out.col2.x = Math.fround(-det * b);
                    out.col1.y = Math.fround(-det * c);
                    out.col2.y = Math.fround(det * a);
                };
                /**
                 * Return the matrix composed of the absolute values of all elements.
                 * djm: fixed double allocation
                 * @return {org.jbox2d.common.Mat22} Absolute value matrix
                 */
                Mat22.prototype.abs = function () {
                    return new Mat22(org.jbox2d.common.MathUtils.abs(this.col1.x), org.jbox2d.common.MathUtils.abs(this.col2.x), org.jbox2d.common.MathUtils.abs(this.col1.y), org.jbox2d.common.MathUtils.abs(this.col2.y));
                };
                Mat22.prototype.absLocal = function () {
                    this.col1.absLocal();
                    this.col2.absLocal();
                };
                /**
                 * Return the matrix composed of the absolute values of all elements.
                 * @return {org.jbox2d.common.Mat22} Absolute value matrix
                 * @param {org.jbox2d.common.Mat22} R
                 */
                Mat22.abs = function (R) {
                    return R.abs();
                };
                Mat22.absToOut = function (R, out) {
                    out.col1.x = org.jbox2d.common.MathUtils.abs(R.col1.x);
                    out.col1.y = org.jbox2d.common.MathUtils.abs(R.col1.y);
                    out.col2.x = org.jbox2d.common.MathUtils.abs(R.col2.x);
                    out.col2.y = org.jbox2d.common.MathUtils.abs(R.col2.y);
                };
                Mat22.prototype.mul$org_jbox2d_common_Vec2 = function (v) {
                    return new org.jbox2d.common.Vec2(Math.fround(Math.fround(this.col1.x * v.x) + Math.fround(this.col2.x * v.y)), Math.fround(Math.fround(this.col1.y * v.x) + Math.fround(this.col2.y * v.y)));
                };
                /**
                 * Multiply a vector by this matrix.
                 * @param {org.jbox2d.common.Vec2} v Vector to multiply by matrix.
                 * @return {org.jbox2d.common.Vec2} Resulting vector
                 */
                Mat22.prototype.mul = function (v) {
                    if (((v != null && v instanceof org.jbox2d.common.Vec2) || v === null)) {
                        return this.mul$org_jbox2d_common_Vec2(v);
                    }
                    else if (((v != null && v instanceof org.jbox2d.common.Mat22) || v === null)) {
                        return this.mul$org_jbox2d_common_Mat22(v);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.prototype.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (v, out) {
                    var tempy = Math.fround(Math.fround(this.col1.y * v.x) + Math.fround(this.col2.y * v.y));
                    out.x = Math.fround(Math.fround(this.col1.x * v.x) + Math.fround(this.col2.x * v.y));
                    out.y = tempy;
                };
                Mat22.prototype.mulToOut = function (v, out) {
                    if (((v != null && v instanceof org.jbox2d.common.Vec2) || v === null) && ((out != null && out instanceof org.jbox2d.common.Vec2) || out === null)) {
                        return this.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(v, out);
                    }
                    else if (((v != null && v instanceof org.jbox2d.common.Mat22) || v === null) && ((out != null && out instanceof org.jbox2d.common.Mat22) || out === null)) {
                        return this.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(v, out);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.prototype.mul$org_jbox2d_common_Mat22 = function (R) {
                    var C = new Mat22();
                    C.col1.x = Math.fround(Math.fround(this.col1.x * R.col1.x) + Math.fround(this.col2.x * R.col1.y));
                    C.col1.y = Math.fround(Math.fround(this.col1.y * R.col1.x) + Math.fround(this.col2.y * R.col1.y));
                    C.col2.x = Math.fround(Math.fround(this.col1.x * R.col2.x) + Math.fround(this.col2.x * R.col2.y));
                    C.col2.y = Math.fround(Math.fround(this.col1.y * R.col2.x) + Math.fround(this.col2.y * R.col2.y));
                    return C;
                };
                Mat22.prototype.mulLocal = function (R) {
                    this.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(R, this);
                    return this;
                };
                Mat22.prototype.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22 = function (R, out) {
                    var tempy1 = Math.fround(Math.fround(this.col1.y * R.col1.x) + Math.fround(this.col2.y * R.col1.y));
                    var tempx1 = Math.fround(Math.fround(this.col1.x * R.col1.x) + Math.fround(this.col2.x * R.col1.y));
                    out.col1.x = tempx1;
                    out.col1.y = tempy1;
                    var tempy2 = Math.fround(Math.fround(this.col1.y * R.col2.x) + Math.fround(this.col2.y * R.col2.y));
                    var tempx2 = Math.fround(Math.fround(this.col1.x * R.col2.x) + Math.fround(this.col2.x * R.col2.y));
                    out.col2.x = tempx2;
                    out.col2.y = tempy2;
                };
                Mat22.prototype.mulTrans$org_jbox2d_common_Mat22 = function (B) {
                    var C = new Mat22();
                    C.col1.x = org.jbox2d.common.Vec2.dot(this.col1, B.col1);
                    C.col1.y = org.jbox2d.common.Vec2.dot(this.col2, B.col1);
                    C.col2.x = org.jbox2d.common.Vec2.dot(this.col1, B.col2);
                    C.col2.y = org.jbox2d.common.Vec2.dot(this.col2, B.col2);
                    return C;
                };
                /**
                 * Multiply another matrix by the transpose of this one (transpose of this one on left).
                 * djm: optimized
                 * @param {org.jbox2d.common.Mat22} B
                 * @return
                 * @return {org.jbox2d.common.Mat22}
                 */
                Mat22.prototype.mulTrans = function (B) {
                    if (((B != null && B instanceof org.jbox2d.common.Mat22) || B === null)) {
                        return this.mulTrans$org_jbox2d_common_Mat22(B);
                    }
                    else if (((B != null && B instanceof org.jbox2d.common.Vec2) || B === null)) {
                        return this.mulTrans$org_jbox2d_common_Vec2(B);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.prototype.mulTransLocal = function (B) {
                    this.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(B, this);
                    return this;
                };
                Mat22.prototype.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22 = function (B, out) {
                    var x1 = Math.fround(Math.fround(this.col1.x * B.col1.x) + Math.fround(this.col1.y * B.col1.y));
                    var y1 = Math.fround(Math.fround(this.col2.x * B.col1.x) + Math.fround(this.col2.y * B.col1.y));
                    var x2 = Math.fround(Math.fround(this.col1.x * B.col2.x) + Math.fround(this.col1.y * B.col2.y));
                    var y2 = Math.fround(Math.fround(this.col2.x * B.col2.x) + Math.fround(this.col2.y * B.col2.y));
                    out.col1.x = x1;
                    out.col2.x = x2;
                    out.col1.y = y1;
                    out.col2.y = y2;
                };
                Mat22.prototype.mulTransToOut = function (B, out) {
                    if (((B != null && B instanceof org.jbox2d.common.Mat22) || B === null) && ((out != null && out instanceof org.jbox2d.common.Mat22) || out === null)) {
                        return this.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(B, out);
                    }
                    else if (((B != null && B instanceof org.jbox2d.common.Vec2) || B === null) && ((out != null && out instanceof org.jbox2d.common.Vec2) || out === null)) {
                        return this.mulTransToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(B, out);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.prototype.mulTrans$org_jbox2d_common_Vec2 = function (v) {
                    return new org.jbox2d.common.Vec2((Math.fround(Math.fround(v.x * this.col1.x) + Math.fround(v.y * this.col1.y))), (Math.fround(Math.fround(v.x * this.col2.x) + Math.fround(v.y * this.col2.y))));
                };
                Mat22.prototype.mulTransToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (v, out) {
                    out.x = Math.fround(Math.fround(v.x * this.col1.x) + Math.fround(v.y * this.col1.y));
                    out.y = org.jbox2d.common.Vec2.dot(v, this.col2);
                };
                /**
                 * Add this matrix to B, return the result.
                 * @param {org.jbox2d.common.Mat22} B
                 * @return
                 * @return {org.jbox2d.common.Mat22}
                 */
                Mat22.prototype.add = function (B) {
                    var m = new Mat22();
                    m.col1.x = Math.fround(this.col1.x + B.col1.x);
                    m.col1.y = Math.fround(this.col1.y + B.col1.y);
                    m.col2.x = Math.fround(this.col2.x + B.col2.x);
                    m.col2.y = Math.fround(this.col2.y + B.col2.y);
                    return m;
                };
                /**
                 * Add B to this matrix locally.
                 * @param {org.jbox2d.common.Mat22} B
                 * @return
                 * @return {org.jbox2d.common.Mat22}
                 */
                Mat22.prototype.addLocal = function (B) {
                    this.col1.x += B.col1.x;
                    this.col1.y += B.col1.y;
                    this.col2.x += B.col2.x;
                    this.col2.y += B.col2.y;
                    return this;
                };
                /**
                 * Solve A * x = b where A = this matrix.
                 * @return {org.jbox2d.common.Vec2} The vector x that solves the above equation.
                 * @param {org.jbox2d.common.Vec2} b
                 */
                Mat22.prototype.solve = function (b) {
                    var a11 = this.col1.x;
                    var a12 = this.col2.x;
                    var a21 = this.col1.y;
                    var a22 = this.col2.y;
                    var det = Math.fround(Math.fround(a11 * a22) - Math.fround(a12 * a21));
                    if (!((det !== 0.0)))
                        throw new Error("Assertion error line 365: assert (det != 0.0F);");
                    ;
                    det = Math.fround(1.0 / det);
                    var x = new org.jbox2d.common.Vec2(Math.fround(det * (Math.fround(Math.fround(a22 * b.x) - Math.fround(a12 * b.y)))), Math.fround(det * (Math.fround(Math.fround(a11 * b.y) - Math.fround(a21 * b.x)))));
                    return x;
                };
                Mat22.prototype.solveToOut = function (b, out) {
                    var a11 = this.col1.x;
                    var a12 = this.col2.x;
                    var a21 = this.col1.y;
                    var a22 = this.col2.y;
                    var det = Math.fround(Math.fround(a11 * a22) - Math.fround(a12 * a21));
                    if (!((det !== 0.0)))
                        throw new Error("Assertion error line 377: assert (det != 0.0F);");
                    ;
                    det = Math.fround(1.0 / det);
                    var tempy = Math.fround(det * (Math.fround(Math.fround(a11 * b.y) - Math.fround(a21 * b.x))));
                    out.x = Math.fround(det * (Math.fround(Math.fround(a22 * b.x) - Math.fround(a12 * b.y))));
                    out.y = tempy;
                };
                Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2 = function (R, v) {
                    return new org.jbox2d.common.Vec2(Math.fround(Math.fround(R.col1.x * v.x) + Math.fround(R.col2.x * v.y)), Math.fround(Math.fround(R.col1.y * v.x) + Math.fround(R.col2.y * v.y)));
                };
                Mat22.mul = function (R, v) {
                    if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Vec2) || v === null)) {
                        return org.jbox2d.common.Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2(R, v);
                    }
                    else if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Mat22) || v === null)) {
                        return org.jbox2d.common.Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(R, v);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (R, v, out) {
                    var tempy = Math.fround(Math.fround(R.col1.y * v.x) + Math.fround(R.col2.y * v.y));
                    out.x = Math.fround(Math.fround(R.col1.x * v.x) + Math.fround(R.col2.x * v.y));
                    out.y = tempy;
                };
                Mat22.mulToOut = function (R, v, out) {
                    if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Vec2) || v === null) && ((out != null && out instanceof org.jbox2d.common.Vec2) || out === null)) {
                        return org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(R, v, out);
                    }
                    else if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Mat22) || v === null) && ((out != null && out instanceof org.jbox2d.common.Mat22) || out === null)) {
                        return org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(R, v, out);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22 = function (A, B) {
                    var C = new Mat22();
                    C.col1.x = Math.fround(Math.fround(A.col1.x * B.col1.x) + Math.fround(A.col2.x * B.col1.y));
                    C.col1.y = Math.fround(Math.fround(A.col1.y * B.col1.x) + Math.fround(A.col2.y * B.col1.y));
                    C.col2.x = Math.fround(Math.fround(A.col1.x * B.col2.x) + Math.fround(A.col2.x * B.col2.y));
                    C.col2.y = Math.fround(Math.fround(A.col1.y * B.col2.x) + Math.fround(A.col2.y * B.col2.y));
                    return C;
                };
                Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22 = function (A, B, out) {
                    var tempy1 = Math.fround(Math.fround(A.col1.y * B.col1.x) + Math.fround(A.col2.y * B.col1.y));
                    var tempx1 = Math.fround(Math.fround(A.col1.x * B.col1.x) + Math.fround(A.col2.x * B.col1.y));
                    var tempy2 = Math.fround(Math.fround(A.col1.y * B.col2.x) + Math.fround(A.col2.y * B.col2.y));
                    var tempx2 = Math.fround(Math.fround(A.col1.x * B.col2.x) + Math.fround(A.col2.x * B.col2.y));
                    out.col1.x = tempx1;
                    out.col1.y = tempy1;
                    out.col2.x = tempx2;
                    out.col2.y = tempy2;
                };
                Mat22.mulTrans$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2 = function (R, v) {
                    return new org.jbox2d.common.Vec2((Math.fround(Math.fround(v.x * R.col1.x) + Math.fround(v.y * R.col1.y))), (Math.fround(Math.fround(v.x * R.col2.x) + Math.fround(v.y * R.col2.y))));
                };
                Mat22.mulTrans = function (R, v) {
                    if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Vec2) || v === null)) {
                        return org.jbox2d.common.Mat22.mulTrans$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2(R, v);
                    }
                    else if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Mat22) || v === null)) {
                        return org.jbox2d.common.Mat22.mulTrans$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(R, v);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (R, v, out) {
                    var outx = Math.fround(Math.fround(v.x * R.col1.x) + Math.fround(v.y * R.col1.y));
                    out.y = Math.fround(Math.fround(v.x * R.col2.x) + Math.fround(v.y * R.col2.y));
                    out.x = outx;
                };
                Mat22.mulTransToOut = function (R, v, out) {
                    if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Vec2) || v === null) && ((out != null && out instanceof org.jbox2d.common.Vec2) || out === null)) {
                        return org.jbox2d.common.Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(R, v, out);
                    }
                    else if (((R != null && R instanceof org.jbox2d.common.Mat22) || R === null) && ((v != null && v instanceof org.jbox2d.common.Mat22) || v === null) && ((out != null && out instanceof org.jbox2d.common.Mat22) || out === null)) {
                        return org.jbox2d.common.Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22(R, v, out);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.mulTrans$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22 = function (A, B) {
                    var C = new Mat22();
                    C.col1.x = Math.fround(Math.fround(A.col1.x * B.col1.x) + Math.fround(A.col1.y * B.col1.y));
                    C.col1.y = Math.fround(Math.fround(A.col2.x * B.col1.x) + Math.fround(A.col2.y * B.col1.y));
                    C.col2.x = Math.fround(Math.fround(A.col1.x * B.col2.x) + Math.fround(A.col1.y * B.col2.y));
                    C.col2.y = Math.fround(Math.fround(A.col2.x * B.col2.x) + Math.fround(A.col2.y * B.col2.y));
                    return C;
                };
                Mat22.mulTransToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22$org_jbox2d_common_Mat22 = function (A, B, out) {
                    var x1 = Math.fround(Math.fround(A.col1.x * B.col1.x) + Math.fround(A.col1.y * B.col1.y));
                    var y1 = Math.fround(Math.fround(A.col2.x * B.col1.x) + Math.fround(A.col2.y * B.col1.y));
                    var x2 = Math.fround(Math.fround(A.col1.x * B.col2.x) + Math.fround(A.col1.y * B.col2.y));
                    var y2 = Math.fround(Math.fround(A.col2.x * B.col2.x) + Math.fround(A.col2.y * B.col2.y));
                    out.col1.x = x1;
                    out.col1.y = y1;
                    out.col2.x = x2;
                    out.col2.y = y2;
                };
                Mat22.createRotationalTransform$float = function (angle) {
                    var mat = new Mat22();
                    var c = org.jbox2d.common.MathUtils.cos(angle);
                    var s = org.jbox2d.common.MathUtils.sin(angle);
                    mat.col1.x = c;
                    mat.col2.x = -s;
                    mat.col1.y = s;
                    mat.col2.y = c;
                    return mat;
                };
                Mat22.createRotationalTransform$float$org_jbox2d_common_Mat22 = function (angle, out) {
                    var c = org.jbox2d.common.MathUtils.cos(angle);
                    var s = org.jbox2d.common.MathUtils.sin(angle);
                    out.col1.x = c;
                    out.col2.x = -s;
                    out.col1.y = s;
                    out.col2.y = c;
                };
                Mat22.createRotationalTransform = function (angle, out) {
                    if (((typeof angle === 'number') || angle === null) && ((out != null && out instanceof org.jbox2d.common.Mat22) || out === null)) {
                        return org.jbox2d.common.Mat22.createRotationalTransform$float$org_jbox2d_common_Mat22(angle, out);
                    }
                    else if (((typeof angle === 'number') || angle === null) && out === undefined) {
                        return org.jbox2d.common.Mat22.createRotationalTransform$float(angle);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Mat22.createScaleTransform$float = function (scale) {
                    var mat = new Mat22();
                    mat.col1.x = scale;
                    mat.col2.y = scale;
                    return mat;
                };
                Mat22.createScaleTransform$float$float = function (scaleX, scaleY) {
                    var mat = new Mat22();
                    mat.col1.x = scaleX;
                    mat.col2.y = scaleY;
                    return mat;
                };
                Mat22.createScaleTransform$float$org_jbox2d_common_Mat22 = function (scale, out) {
                    out.col1.x = scale;
                    out.col1.y = 0;
                    out.col2.x = 0;
                    out.col2.y = scale;
                };
                Mat22.createScaleTransform$float$float$org_jbox2d_common_Mat22 = function (scaleX, scaleY, out) {
                    out.col1.x = scaleX;
                    out.col1.y = 0;
                    out.col2.x = 0;
                    out.col2.y = scaleY;
                };
                Mat22.createScaleTransform = function (scaleX, scaleY, out) {
                    if (((typeof scaleX === 'number') || scaleX === null) && ((typeof scaleY === 'number') || scaleY === null) && ((out != null && out instanceof org.jbox2d.common.Mat22) || out === null)) {
                        return org.jbox2d.common.Mat22.createScaleTransform$float$float$org_jbox2d_common_Mat22(scaleX, scaleY, out);
                    }
                    else if (((typeof scaleX === 'number') || scaleX === null) && ((scaleY != null && scaleY instanceof org.jbox2d.common.Mat22) || scaleY === null) && out === undefined) {
                        return org.jbox2d.common.Mat22.createScaleTransform$float$org_jbox2d_common_Mat22(scaleX, scaleY);
                    }
                    else if (((typeof scaleX === 'number') || scaleX === null) && ((typeof scaleY === 'number') || scaleY === null) && out === undefined) {
                        return org.jbox2d.common.Mat22.createScaleTransform$float$float(scaleX, scaleY);
                    }
                    else if (((typeof scaleX === 'number') || scaleX === null) && scaleY === undefined && out === undefined) {
                        return org.jbox2d.common.Mat22.createScaleTransform$float(scaleX);
                    }
                    else
                        throw new Error('invalid overload');
                };
                return Mat22;
            }());
            common.Mat22 = Mat22;
            Mat22["__class"] = "org.jbox2d.common.Mat22";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            var Mat33 = (function () {
                function Mat33(argCol1, argCol2, argCol3) {
                    var _this = this;
                    /*private*/ this.temp = new org.jbox2d.common.Vec3();
                    if (((argCol1 != null && argCol1 instanceof org.jbox2d.common.Vec3) || argCol1 === null) && ((argCol2 != null && argCol2 instanceof org.jbox2d.common.Vec3) || argCol2 === null) && ((argCol3 != null && argCol3 instanceof org.jbox2d.common.Vec3) || argCol3 === null)) {
                        var __args = arguments;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col3 === undefined)
                            this.col3 = null;
                        this.temp = new org.jbox2d.common.Vec3();
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col3 === undefined)
                            this.col3 = null;
                        (function () {
                            _this.col1 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(argCol1);
                            _this.col2 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(argCol2);
                            _this.col3 = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(argCol3);
                        })();
                    }
                    else if (argCol1 === undefined && argCol2 === undefined && argCol3 === undefined) {
                        var __args = arguments;
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col3 === undefined)
                            this.col3 = null;
                        this.temp = new org.jbox2d.common.Vec3();
                        if (this.col1 === undefined)
                            this.col1 = null;
                        if (this.col2 === undefined)
                            this.col2 = null;
                        if (this.col3 === undefined)
                            this.col3 = null;
                        (function () {
                            _this.col1 = new org.jbox2d.common.Vec3();
                            _this.col2 = new org.jbox2d.common.Vec3();
                            _this.col3 = new org.jbox2d.common.Vec3();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                Mat33.prototype.setZero = function () {
                    this.col1.setZero();
                    this.col2.setZero();
                    this.col3.setZero();
                };
                Mat33.mul = function (A, v) {
                    return new org.jbox2d.common.Vec3(Math.fround(Math.fround(Math.fround(Math.fround(v.x * A.col1.x) + Math.fround(v.y * A.col2.x)) + v.z) + A.col3.x), Math.fround(Math.fround(Math.fround(v.x * A.col1.y) + Math.fround(v.y * A.col2.y)) + Math.fround(v.z * A.col3.y)), Math.fround(Math.fround(Math.fround(v.x * A.col1.z) + Math.fround(v.y * A.col2.z)) + Math.fround(v.z * A.col3.z)));
                };
                Mat33.mulToOut = function (A, v, out) {
                    var tempy = Math.fround(Math.fround(Math.fround(v.x * A.col1.y) + Math.fround(v.y * A.col2.y)) + Math.fround(v.z * A.col3.y));
                    var tempz = Math.fround(Math.fround(Math.fround(v.x * A.col1.z) + Math.fround(v.y * A.col2.z)) + Math.fround(v.z * A.col3.z));
                    out.x = Math.fround(Math.fround(Math.fround(Math.fround(v.x * A.col1.x) + Math.fround(v.y * A.col2.x)) + v.z) + A.col3.x);
                    out.y = tempy;
                    out.z = tempz;
                };
                Mat33.prototype.solve = function (b) {
                    org.jbox2d.common.Vec3.crossToOut(this.col1, this.col2, this.temp);
                    var det = org.jbox2d.common.Vec3.dot(this.col1, this.temp);
                    if (!((det !== 0.0)))
                        throw new Error("Assertion error line 64: assert (det != 0.0F);");
                    ;
                    det = Math.fround(1.0 / det);
                    var x = new org.jbox2d.common.Vec3();
                    org.jbox2d.common.Vec3.crossToOut(this.col2, this.col3, this.temp);
                    x.x = Math.fround(det * org.jbox2d.common.Vec3.dot(b, this.temp));
                    org.jbox2d.common.Vec3.crossToOut(b, this.col3, this.temp);
                    x.y = Math.fround(det * org.jbox2d.common.Vec3.dot(this.col1, this.temp));
                    org.jbox2d.common.Vec3.crossToOut(this.col2, b, this.temp);
                    x.z = Math.fround(det * org.jbox2d.common.Vec3.dot(this.col1, this.temp));
                    return x;
                };
                Mat33.prototype.solveToOut = function (b, out) {
                    org.jbox2d.common.Vec3.crossToOut(this.col1, this.col2, out);
                    var det = org.jbox2d.common.Vec3.dot(this.col1, out);
                    if (!((det !== 0.0)))
                        throw new Error("Assertion error line 79: assert (det != 0.0F);");
                    ;
                    det = Math.fround(1.0 / det);
                    org.jbox2d.common.Vec3.crossToOut(this.col2, this.col3, out);
                    var tempx = Math.fround(det * org.jbox2d.common.Vec3.dot(b, out));
                    org.jbox2d.common.Vec3.crossToOut(b, this.col3, out);
                    var tempy = Math.fround(det * org.jbox2d.common.Vec3.dot(this.col1, out));
                    org.jbox2d.common.Vec3.crossToOut(this.col2, b, out);
                    var tempz = Math.fround(det * org.jbox2d.common.Vec3.dot(this.col1, out));
                    out.x = tempx;
                    out.y = tempy;
                    out.z = tempz;
                };
                return Mat33;
            }());
            common.Mat33 = Mat33;
            Mat33["__class"] = "org.jbox2d.common.Mat33";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            var RaycastResult = (function () {
                function RaycastResult() {
                    this.lambda = 0.0;
                    this.normal = new org.jbox2d.common.Vec2();
                }
                RaycastResult.prototype.set = function (argOther) {
                    this.lambda = argOther.lambda;
                    this.normal.set$org_jbox2d_common_Vec2(argOther.normal);
                    return this;
                };
                return RaycastResult;
            }());
            common.RaycastResult = RaycastResult;
            RaycastResult["__class"] = "org.jbox2d.common.RaycastResult";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * Global tuning constants based on MKS units and various integer maximums (vertices per shape, pairs, etc.).
             * @class
             */
            var Settings = (function () {
                function Settings() {
                }
                Settings.pi_$LI$ = function () { if (Settings.pi == null)
                    Settings.pi = Math.fround(Math.PI); return Settings.pi; };
                ;
                Settings.SINCOS_LUT_LENGTH_$LI$ = function () { if (Settings.SINCOS_LUT_LENGTH == null)
                    Settings.SINCOS_LUT_LENGTH = (Math.ceil(Math.PI * 2 / Settings.SINCOS_LUT_PRECISION) | 0); return Settings.SINCOS_LUT_LENGTH; };
                ;
                Settings.maxPairs_$LI$ = function () { if (Settings.maxPairs == null)
                    Settings.maxPairs = 64 * Settings.maxProxies; return Settings.maxPairs; };
                ;
                Settings.linearSlop_$LI$ = function () { if (Settings.linearSlop == null)
                    Settings.linearSlop = Math.fround(0.005 * Settings.lengthUnitsPerMeter); return Settings.linearSlop; };
                ;
                Settings.angularSlop_$LI$ = function () { if (Settings.angularSlop == null)
                    Settings.angularSlop = Math.fround(Math.fround(2.0 / 180.0) * Settings.pi_$LI$()); return Settings.angularSlop; };
                ;
                Settings.velocityThreshold_$LI$ = function () { if (Settings.velocityThreshold == null)
                    Settings.velocityThreshold = Math.fround(Math.fround(1.0 * Settings.lengthUnitsPerMeter) / Settings.timeUnitsPerSecond); return Settings.velocityThreshold; };
                ;
                Settings.maxLinearCorrection_$LI$ = function () { if (Settings.maxLinearCorrection == null)
                    Settings.maxLinearCorrection = Math.fround(0.2 * Settings.lengthUnitsPerMeter); return Settings.maxLinearCorrection; };
                ;
                Settings.maxAngularCorrection_$LI$ = function () { if (Settings.maxAngularCorrection == null)
                    Settings.maxAngularCorrection = Math.fround(Math.fround(8.0 / 180.0) * Settings.pi_$LI$()); return Settings.maxAngularCorrection; };
                ;
                Settings.timeToSleep_$LI$ = function () { if (Settings.timeToSleep == null)
                    Settings.timeToSleep = Math.fround(0.5 * Settings.timeUnitsPerSecond); return Settings.timeToSleep; };
                ;
                Settings.linearSleepTolerance_$LI$ = function () { if (Settings.linearSleepTolerance == null)
                    Settings.linearSleepTolerance = Math.fround(Math.fround(0.01 * Settings.lengthUnitsPerMeter) / Settings.timeUnitsPerSecond); return Settings.linearSleepTolerance; };
                ;
                Settings.angularSleepTolerance_$LI$ = function () { if (Settings.angularSleepTolerance == null)
                    Settings.angularSleepTolerance = Math.fround(Math.fround(2.0 / 180.0) / Settings.timeUnitsPerSecond); return Settings.angularSleepTolerance; };
                ;
                Settings.toiSlop_$LI$ = function () { if (Settings.toiSlop == null)
                    Settings.toiSlop = Math.fround(8.0 * Settings.linearSlop_$LI$()); return Settings.toiSlop; };
                ;
                Settings.maxLinearVelocitySquared_$LI$ = function () { if (Settings.maxLinearVelocitySquared == null)
                    Settings.maxLinearVelocitySquared = Math.fround(Settings.maxLinearVelocity * Settings.maxLinearVelocity); return Settings.maxLinearVelocitySquared; };
                ;
                Settings.maxAngularVelocitySquared_$LI$ = function () { if (Settings.maxAngularVelocitySquared == null)
                    Settings.maxAngularVelocitySquared = Math.fround(Settings.maxAngularVelocity * Settings.maxAngularVelocity); return Settings.maxAngularVelocitySquared; };
                ;
                return Settings;
            }());
            /**
             * A "close to zero" float epsilon value for use
             */
            Settings.EPSILON = 1.1920929E-7;
            /**
             * needs to be final, or will slow down math methods
             */
            Settings.FAST_MATH = true;
            Settings.SINCOS_LUT_ENABLED = true;
            /**
             * smaller the precision, the larger the table.  If
             * a small table is used (eg, precision is .006 or greater),
             * make sure you set the table to lerp it's results.  Accuracy chart
             * is in the MathUtils source.  Or, run the tests
             * yourself in {@link org.jbox2d.testbed.mathtests.SinCosTest}.</br>
             * </br>
             * Good lerp precision values:
             * <ul><li>.0092</li>
             * <li>.008201</li>
             * <li>.005904</li>
             * <li>.005204</li>
             * <li>.004305</li>
             * <li>.002807</li>
             * <li>.001508</li>
             * <li>9.32500E-4</li>
             * <li>7.48000E-4</li>
             * <li>8.47000E-4</li>
             * <li>.0005095</li>
             * <li>.0001098</li>
             * <li>9.50499E-5</li>
             * <li>6.08500E-5</li>
             * <li>3.07000E-5</li>
             * <li>1.53999E-5</li></ul>
             *
             */
            Settings.SINCOS_LUT_PRECISION = 0.00131;
            /**
             * Use if the table's precision is large (eg .006 or greater).
             * Although it is more expensive, it greatly increases
             * accuracy.  Look in the MathUtils source for some test results
             * on the accuracy and speed of lerp vs non lerp.  Or, run the tests
             * yourself in {@link org.jbox2d.testbed.mathtests.SinCosTest}.
             */
            Settings.SINCOS_LUT_LERP = false;
            Settings.lengthUnitsPerMeter = 1.0;
            Settings.massUnitsPerKilogram = 1.0;
            Settings.timeUnitsPerSecond = 1.0;
            Settings.maxManifoldPoints = 2;
            Settings.maxShapesPerBody = 64;
            Settings.maxPolygonVertices = 8;
            /**
             * Must be a power of two.
             */
            Settings.maxProxies = 64;
            /**
             * This scale factor controls how fast overlap is resolved. Ideally this would be 1 so
             * that overlap is removed in one time step. However using values close to 1 often lead
             * to overshoot.
             */
            Settings.contactBaumgarte = 0.2;
            /**
             * The maximum linear velocity of a body. This limit is very large and is used
             * to prevent numerical problems. You shouldn't need to adjust this.
             */
            Settings.maxLinearVelocity = 200.0;
            /**
             * The maximum angular velocity of a body. This limit is very large and is used
             * to prevent numerical problems. You shouldn't need to adjust this.
             */
            Settings.maxAngularVelocity = 250.0;
            /**
             * Maximum number of contacts to be handled to solve a TOI island.
             */
            Settings.maxTOIContactsPerIsland = 32;
            /**
             * Maximum number of joints to be handled to solve a TOI island.
             */
            Settings.maxTOIJointsPerIsland = 0;
            common.Settings = Settings;
            Settings["__class"] = "org.jbox2d.common.Settings";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * Primarily for internal use.
             * <BR><BR>
             * Describes the motion of a body/shape for TOI computation.
             * Shapes are defined with respect to the body origin, which may
             * not coincide with the center of mass. However, to support dynamics
             * we must interpolate the center of mass position.
             *
             * @class
             */
            var Sweep = (function () {
                function Sweep() {
                    if (this.localCenter === undefined)
                        this.localCenter = null;
                    if (this.c0 === undefined)
                        this.c0 = null;
                    if (this.c === undefined)
                        this.c = null;
                    if (this.a0 === undefined)
                        this.a0 = 0;
                    if (this.a === undefined)
                        this.a = 0;
                    if (this.t0 === undefined)
                        this.t0 = 0;
                    this.localCenter = new org.jbox2d.common.Vec2();
                    this.c0 = new org.jbox2d.common.Vec2();
                    this.c = new org.jbox2d.common.Vec2();
                }
                Sweep.prototype.toString = function () {
                    var s = "Sweep:\nlocalCenter: " + this.localCenter + "\n";
                    s += "c0: " + this.c0 + ", c: " + this.c + "\n";
                    s += "a0: " + this.a0 + ", a: " + this.a + "\n";
                    s += "t0: " + this.t0 + "\n";
                    return s;
                };
                Sweep.prototype.set = function (argCloneFrom) {
                    this.localCenter.set$org_jbox2d_common_Vec2(argCloneFrom.localCenter);
                    this.c0.set$org_jbox2d_common_Vec2(argCloneFrom.c0);
                    this.c.set$org_jbox2d_common_Vec2(argCloneFrom.c);
                    this.a0 = argCloneFrom.a0;
                    this.a = argCloneFrom.a;
                    this.t0 = argCloneFrom.t0;
                    return this;
                };
                /**
                 * Get the interpolated transform at a specific time.
                 * @param {org.jbox2d.common.XForm} xf the result is placed here - must not be null
                 * @param {number} t the normalized time in [0,1].
                 */
                Sweep.prototype.getXForm = function (xf, t) {
                    if (!((xf != null)))
                        throw new Error("Assertion error line 79: assert (xf != null);");
                    ;
                    if (Math.fround(1.0 - this.t0) > org.jbox2d.common.Settings.EPSILON) {
                        var alpha = Math.fround((Math.fround(t - this.t0)) / (Math.fround(1.0 - this.t0)));
                        xf.position.x = Math.fround(Math.fround((Math.fround(1.0 - alpha)) * this.c0.x) + Math.fround(alpha * this.c.x));
                        xf.position.y = Math.fround(Math.fround((Math.fround(1.0 - alpha)) * this.c0.y) + Math.fround(alpha * this.c.y));
                        var angle = Math.fround(Math.fround((Math.fround(1.0 - alpha)) * this.a0) + Math.fround(alpha * this.a));
                        xf.R.set$float(angle);
                    }
                    else {
                        xf.position.set$org_jbox2d_common_Vec2(this.c);
                        xf.R.set$float(this.a);
                    }
                    xf.position.x -= Math.fround(Math.fround(xf.R.col1.x * this.localCenter.x) + Math.fround(xf.R.col2.x * this.localCenter.y));
                    xf.position.y -= Math.fround(Math.fround(xf.R.col1.y * this.localCenter.x) + Math.fround(xf.R.col2.y * this.localCenter.y));
                };
                /**
                 *
                 * Advance the sweep forward, yielding a new initial state.
                 * @param {number} t the new initial time.
                 */
                Sweep.prototype.advance = function (t) {
                    if (this.t0 < t && Math.fround(1.0 - this.t0) > org.jbox2d.common.Settings.EPSILON) {
                        var alpha = Math.fround((Math.fround(t - this.t0)) / (Math.fround(1.0 - this.t0)));
                        this.c0.x = Math.fround(Math.fround((Math.fround(1.0 - alpha)) * this.c0.x) + Math.fround(alpha * this.c.x));
                        this.c0.y = Math.fround(Math.fround((Math.fround(1.0 - alpha)) * this.c0.y) + Math.fround(alpha * this.c.y));
                        this.a0 = Math.fround(Math.fround((Math.fround(1.0 - alpha)) * this.a0) + Math.fround(alpha * this.a));
                        this.t0 = t;
                    }
                };
                return Sweep;
            }());
            common.Sweep = Sweep;
            Sweep["__class"] = "org.jbox2d.common.Sweep";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * A 2-dimensional vector class.  Used heavily in JBox2d.
             * djm: added ToOut methods
             * @param {number} x
             * @param {number} y
             * @class
             */
            var Vec2 = (function () {
                function Vec2(x, y) {
                    var _this = this;
                    if (((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null)) {
                        var __args = arguments;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        (function () {
                            if (Vec2.watchCreations) {
                                ++Vec2.creationCount;
                            }
                            _this.x = x;
                            _this.y = y;
                        })();
                    }
                    else if (((x != null && x instanceof org.jbox2d.common.Vec2) || x === null) && y === undefined) {
                        var __args = arguments;
                        var toCopy = __args[0];
                        {
                            var __args_3 = arguments;
                            var x_1 = toCopy.x;
                            var y_1 = toCopy.y;
                            if (this.x === undefined)
                                this.x = 0;
                            if (this.y === undefined)
                                this.y = 0;
                            if (this.x === undefined)
                                this.x = 0;
                            if (this.y === undefined)
                                this.y = 0;
                            (function () {
                                if (Vec2.watchCreations) {
                                    ++Vec2.creationCount;
                                }
                                _this.x = x_1;
                                _this.y = y_1;
                            })();
                        }
                    }
                    else if (x === undefined && y === undefined) {
                        var __args = arguments;
                        {
                            var __args_4 = arguments;
                            var x_2 = 0;
                            var y_2 = 0;
                            if (this.x === undefined)
                                this.x = 0;
                            if (this.y === undefined)
                                this.y = 0;
                            if (this.x === undefined)
                                this.x = 0;
                            if (this.y === undefined)
                                this.y = 0;
                            (function () {
                                if (Vec2.watchCreations) {
                                    ++Vec2.creationCount;
                                }
                                _this.x = x_2;
                                _this.y = y_2;
                            })();
                        }
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * Zero out this vector.
                 */
                Vec2.prototype.setZero = function () {
                    this.x = 0.0;
                    this.y = 0.0;
                };
                Vec2.prototype.set$float$float = function (x, y) {
                    this.x = x;
                    this.y = y;
                };
                /**
                 * Set the vector component-wise.
                 * @param {number} x
                 * @param {number} y
                 */
                Vec2.prototype.set = function (x, y) {
                    if (((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null)) {
                        return this.set$float$float(x, y);
                    }
                    else if (((x != null && x instanceof org.jbox2d.common.Vec2) || x === null) && y === undefined) {
                        return this.set$org_jbox2d_common_Vec2(x);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Vec2.prototype.set$org_jbox2d_common_Vec2 = function (v) {
                    this.x = v.x;
                    this.y = v.y;
                    return this;
                };
                /**
                 * Return the sum of this vector and another; does not alter either one.
                 * @param {org.jbox2d.common.Vec2} v
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.add = function (v) {
                    return new Vec2(Math.fround(this.x + v.x), Math.fround(this.y + v.y));
                };
                /**
                 * Return the difference of this vector and another; does not alter either one.
                 * @param {org.jbox2d.common.Vec2} v
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.sub = function (v) {
                    return new Vec2(Math.fround(this.x - v.x), Math.fround(this.y - v.y));
                };
                /**
                 * Return this vector multiplied by a scalar; does not alter this vector.
                 * @param {number} a
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.mul = function (a) {
                    return new Vec2(Math.fround(this.x * a), Math.fround(this.y * a));
                };
                /**
                 * Return the negation of this vector; does not alter this vector.
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.negate = function () {
                    return new Vec2(-this.x, -this.y);
                };
                /**
                 * Flip the vector and return it - alters this vector.
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.negateLocal = function () {
                    this.x = -this.x;
                    this.y = -this.y;
                    return this;
                };
                Vec2.prototype.addLocal$org_jbox2d_common_Vec2 = function (v) {
                    this.x += v.x;
                    this.y += v.y;
                    return this;
                };
                Vec2.prototype.addLocal$float$float = function (x, y) {
                    this.x += x;
                    this.y += y;
                    return this;
                };
                /**
                 * Adds values to this vector and returns result - alters this vector.
                 * @param {number} x
                 * @param {number} y
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.addLocal = function (x, y) {
                    if (((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null)) {
                        return this.addLocal$float$float(x, y);
                    }
                    else if (((x != null && x instanceof org.jbox2d.common.Vec2) || x === null) && y === undefined) {
                        return this.addLocal$org_jbox2d_common_Vec2(x);
                    }
                    else
                        throw new Error('invalid overload');
                };
                /**
                 * Subtract another vector from this one and return result - alters this vector.
                 * @param {org.jbox2d.common.Vec2} v
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.subLocal = function (v) {
                    this.x -= v.x;
                    this.y -= v.y;
                    return this;
                };
                /**
                 * Multiply this vector by a number and return result - alters this vector.
                 * @param {number} a
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.mulLocal = function (a) {
                    this.x *= a;
                    this.y *= a;
                    return this;
                };
                /**
                 * Return the length of this vector.
                 * @return {number}
                 */
                Vec2.prototype.length = function () {
                    return org.jbox2d.common.MathUtils.sqrt(Math.fround(Math.fround(this.x * this.x) + Math.fround(this.y * this.y)));
                };
                /**
                 * Return the squared length of this vector.
                 * @return {number}
                 */
                Vec2.prototype.lengthSquared = function () {
                    return (Math.fround(Math.fround(this.x * this.x) + Math.fround(this.y * this.y)));
                };
                /**
                 * Normalize this vector and return the length before normalization.  Alters this vector.
                 * @return {number}
                 */
                Vec2.prototype.normalize = function () {
                    var length = this.length();
                    if (length < org.jbox2d.common.Settings.EPSILON) {
                        return 0.0;
                    }
                    var invLength = Math.fround(1.0 / length);
                    this.x *= invLength;
                    this.y *= invLength;
                    return length;
                };
                /**
                 * True if the vector represents a pair of valid, non-infinite floating point numbers.
                 * @return {boolean}
                 */
                Vec2.prototype.isValid = function () {
                    return this.x !== NaN && this.x !== -Infinity && this.x !== Infinity && this.y !== NaN && this.y !== -Infinity && this.y !== Infinity;
                };
                /**
                 * Return a new vector that has positive components.
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.abs = function () {
                    return new Vec2(org.jbox2d.common.MathUtils.abs(this.x), org.jbox2d.common.MathUtils.abs(this.y));
                };
                Vec2.prototype.absLocal = function () {
                    this.x = org.jbox2d.common.MathUtils.abs(this.x);
                    this.y = org.jbox2d.common.MathUtils.abs(this.y);
                };
                /**
                 *
                 * @return {org.jbox2d.common.Vec2}
                 */
                Vec2.prototype.clone = function () {
                    return new Vec2(this.x, this.y);
                };
                /**
                 *
                 * @return {string}
                 */
                Vec2.prototype.toString = function () {
                    return "(" + this.x + "," + this.y + ")";
                };
                Vec2.abs = function (a) {
                    return new Vec2(org.jbox2d.common.MathUtils.abs(a.x), org.jbox2d.common.MathUtils.abs(a.y));
                };
                Vec2.absToOut = function (a, out) {
                    out.x = org.jbox2d.common.MathUtils.abs(a.x);
                    out.y = org.jbox2d.common.MathUtils.abs(a.y);
                };
                Vec2.dot = function (a, b) {
                    return Math.fround(Math.fround(a.x * b.x) + Math.fround(a.y * b.y));
                };
                Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (a, b) {
                    return Math.fround(Math.fround(a.x * b.y) - Math.fround(a.y * b.x));
                };
                Vec2.cross = function (a, b) {
                    if (((a != null && a instanceof org.jbox2d.common.Vec2) || a === null) && ((b != null && b instanceof org.jbox2d.common.Vec2) || b === null)) {
                        return org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(a, b);
                    }
                    else if (((a != null && a instanceof org.jbox2d.common.Vec2) || a === null) && ((typeof b === 'number') || b === null)) {
                        return org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$float(a, b);
                    }
                    else if (((typeof a === 'number') || a === null) && ((b != null && b instanceof org.jbox2d.common.Vec2) || b === null)) {
                        return org.jbox2d.common.Vec2.cross$float$org_jbox2d_common_Vec2(a, b);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Vec2.cross$org_jbox2d_common_Vec2$float = function (a, s) {
                    return new Vec2(Math.fround(s * a.y), Math.fround(-s * a.x));
                };
                Vec2.crossToOut$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2 = function (a, s, out) {
                    var tempy = Math.fround(-s * a.x);
                    out.x = Math.fround(s * a.y);
                    out.y = tempy;
                };
                Vec2.crossToOut = function (a, s, out) {
                    if (((a != null && a instanceof org.jbox2d.common.Vec2) || a === null) && ((typeof s === 'number') || s === null) && ((out != null && out instanceof org.jbox2d.common.Vec2) || out === null)) {
                        return org.jbox2d.common.Vec2.crossToOut$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2(a, s, out);
                    }
                    else if (((typeof a === 'number') || a === null) && ((s != null && s instanceof org.jbox2d.common.Vec2) || s === null) && ((out != null && out instanceof org.jbox2d.common.Vec2) || out === null)) {
                        return org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(a, s, out);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Vec2.cross$float$org_jbox2d_common_Vec2 = function (s, a) {
                    return new Vec2(Math.fround(-s * a.y), Math.fround(s * a.x));
                };
                Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (s, a, out) {
                    var tempY = Math.fround(s * a.x);
                    out.x = Math.fround(-s * a.y);
                    out.y = tempY;
                };
                Vec2.negateToOut = function (a, out) {
                    out.x = -a.x;
                    out.y = -a.y;
                };
                Vec2.min = function (a, b) {
                    return new Vec2(a.x < b.x ? a.x : b.x, a.y < b.y ? a.y : b.y);
                };
                Vec2.max = function (a, b) {
                    return new Vec2(a.x > b.x ? a.x : b.x, a.y > b.y ? a.y : b.y);
                };
                Vec2.minToOut = function (a, b, out) {
                    out.x = a.x < b.x ? a.x : b.x;
                    out.y = a.y < b.y ? a.y : b.y;
                };
                Vec2.maxToOut = function (a, b, out) {
                    out.x = a.x > b.x ? a.x : b.x;
                    out.y = a.y > b.y ? a.y : b.y;
                };
                /**
                 * @see java.lang.Object#hashCode()
                 * @return {number}
                 */
                Vec2.prototype.hashCode = function () {
                    var prime = 31;
                    var result = 1;
                    result = prime * result + (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.x);
                    result = prime * result + (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.y);
                    return result;
                };
                /**
                 * @see java.lang.Object#equals(java.lang.Object)
                 * @param {*} obj
                 * @return {boolean}
                 */
                Vec2.prototype.equals = function (obj) {
                    if (this === obj)
                        return true;
                    if (obj == null)
                        return false;
                    if (this.constructor !== obj.constructor)
                        return false;
                    var other = obj;
                    if ((function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.x) !== (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(other.x))
                        return false;
                    if ((function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.y) !== (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(other.y))
                        return false;
                    return true;
                };
                return Vec2;
            }());
            /**
             * Should we count Vec2 creations?
             */
            Vec2.watchCreations = true;
            /**
             * Running count of Vec2 creations.  Must be zeroed out
             * manually (perhaps at start of time step).  Incremented
             * in Vec2 constructor if watchCreations flag is true.
             * <BR><BR>
             * Mainly used for optimization purposes, since temporary
             * Vec2 creation is often a bottleneck.
             */
            Vec2.creationCount = 0;
            common.Vec2 = Vec2;
            Vec2["__class"] = "org.jbox2d.common.Vec2";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            var Vec3 = (function () {
                function Vec3(argX, argY, argZ) {
                    var _this = this;
                    if (((typeof argX === 'number') || argX === null) && ((typeof argY === 'number') || argY === null) && ((typeof argZ === 'number') || argZ === null)) {
                        var __args = arguments;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.z === undefined)
                            this.z = 0;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.z === undefined)
                            this.z = 0;
                        (function () {
                            _this.x = argX;
                            _this.y = argY;
                            _this.z = argZ;
                        })();
                    }
                    else if (((argX != null && argX instanceof org.jbox2d.common.Vec3) || argX === null) && argY === undefined && argZ === undefined) {
                        var __args = arguments;
                        var argCopy_1 = __args[0];
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.z === undefined)
                            this.z = 0;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.z === undefined)
                            this.z = 0;
                        (function () {
                            _this.x = argCopy_1.x;
                            _this.y = argCopy_1.y;
                            _this.z = argCopy_1.z;
                        })();
                    }
                    else if (argX === undefined && argY === undefined && argZ === undefined) {
                        var __args = arguments;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.z === undefined)
                            this.z = 0;
                        if (this.x === undefined)
                            this.x = 0;
                        if (this.y === undefined)
                            this.y = 0;
                        if (this.z === undefined)
                            this.z = 0;
                        (function () {
                            _this.x = _this.y = _this.z = 0.0;
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                Vec3.prototype.set = function (argVec) {
                    this.x = argVec.x;
                    this.y = argVec.y;
                    this.z = argVec.z;
                };
                Vec3.prototype.addLocal = function (argVec) {
                    this.x += argVec.x;
                    this.y += argVec.y;
                    this.z += argVec.z;
                    return this;
                };
                Vec3.prototype.add = function (argVec) {
                    return new Vec3(Math.fround(this.x + argVec.x), Math.fround(this.y + argVec.y), Math.fround(this.z + argVec.z));
                };
                Vec3.prototype.subLocal = function (argVec) {
                    this.x -= argVec.x;
                    this.y -= argVec.y;
                    this.z -= argVec.z;
                    return this;
                };
                Vec3.prototype.sub = function (argVec) {
                    return new Vec3(Math.fround(this.x - argVec.x), Math.fround(this.y - argVec.y), Math.fround(this.z - argVec.z));
                };
                Vec3.prototype.mulLocal = function (argScalar) {
                    this.x *= argScalar;
                    this.y *= argScalar;
                    this.z *= argScalar;
                    return this;
                };
                Vec3.prototype.mul = function (argScalar) {
                    return new Vec3(Math.fround(this.x * argScalar), Math.fround(this.y * argScalar), Math.fround(this.z * argScalar));
                };
                Vec3.prototype.negate = function () {
                    return new Vec3(-this.x, -this.y, -this.z);
                };
                Vec3.prototype.negateLocal = function () {
                    this.x *= -1;
                    this.y *= -1;
                    this.z *= -1;
                    return this;
                };
                Vec3.prototype.setZero = function () {
                    this.x = 0;
                    this.y = 0;
                    this.z = 0;
                };
                Vec3.prototype.clone = function () {
                    return new Vec3(this);
                };
                /**
                 * @see java.lang.Object#hashCode()
                 * @return {number}
                 */
                Vec3.prototype.hashCode = function () {
                    var prime = 31;
                    var result = 1;
                    result = prime * result + (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.x);
                    result = prime * result + (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.y);
                    result = prime * result + (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.z);
                    return result;
                };
                /**
                 * @see java.lang.Object#equals(java.lang.Object)
                 * @param {*} obj
                 * @return {boolean}
                 */
                Vec3.prototype.equals = function (obj) {
                    if (this === obj)
                        return true;
                    if (obj == null)
                        return false;
                    if (this.constructor !== obj.constructor)
                        return false;
                    var other = obj;
                    if ((function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.x) !== (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(other.x))
                        return false;
                    if ((function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.y) !== (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(other.y))
                        return false;
                    if ((function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(this.z) !== (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(other.z))
                        return false;
                    return true;
                };
                Vec3.dot = function (a, b) {
                    return Math.fround(Math.fround(Math.fround(a.x * b.x) + Math.fround(a.y * b.y)) + Math.fround(a.z * b.z));
                };
                Vec3.cross = function (a, b) {
                    return new Vec3(Math.fround(Math.fround(a.y * b.z) - Math.fround(a.z * b.y)), Math.fround(Math.fround(a.z * b.x) - Math.fround(a.x * b.z)), Math.fround(Math.fround(a.x * b.y) - Math.fround(a.y * b.x)));
                };
                Vec3.crossToOut = function (a, b, out) {
                    var tempy = Math.fround(Math.fround(a.z * b.x) - Math.fround(a.x * b.z));
                    var tempz = Math.fround(Math.fround(a.x * b.y) - Math.fround(a.y * b.x));
                    out.x = Math.fround(Math.fround(a.y * b.z) - Math.fround(a.z * b.y));
                    out.y = tempy;
                    out.z = tempz;
                };
                return Vec3;
            }());
            common.Vec3 = Vec3;
            Vec3["__class"] = "org.jbox2d.common.Vec3";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * Initialize using a position vector and a rotation matrix.
             * @param {org.jbox2d.common.Vec2} _position
             * @param {org.jbox2d.common.Mat22} _R
             * @class
             */
            var XForm = (function () {
                function XForm(_position, _R) {
                    var _this = this;
                    if (((_position != null && _position instanceof org.jbox2d.common.Vec2) || _position === null) && ((_R != null && _R instanceof org.jbox2d.common.Mat22) || _R === null)) {
                        var __args = arguments;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.R === undefined)
                            this.R = null;
                        (function () {
                            _this.position = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(_position);
                            _this.R = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(_R);
                        })();
                    }
                    else if (((_position != null && _position instanceof org.jbox2d.common.XForm) || _position === null) && _R === undefined) {
                        var __args = arguments;
                        var xf_1 = __args[0];
                        if (this.position === undefined)
                            this.position = null;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.R === undefined)
                            this.R = null;
                        (function () {
                            _this.position = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(xf_1.position);
                            _this.R = (function (o) { if (o.clone != undefined) {
                                return o.clone();
                            }
                            else {
                                var clone = Object.create(o);
                                for (var p in o) {
                                    if (o.hasOwnProperty(p))
                                        clone[p] = o[p];
                                }
                                return clone;
                            } })(xf_1.R);
                        })();
                    }
                    else if (_position === undefined && _R === undefined) {
                        var __args = arguments;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.R === undefined)
                            this.R = null;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.R === undefined)
                            this.R = null;
                        (function () {
                            _this.position = new org.jbox2d.common.Vec2();
                            _this.R = new org.jbox2d.common.Mat22();
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                XForm.__static_initialize = function () { if (!XForm.__static_initialized) {
                    XForm.__static_initialized = true;
                    XForm.__static_initializer_0();
                } };
                XForm.identity_$LI$ = function () { XForm.__static_initialize(); return XForm.identity; };
                ;
                XForm.__static_initializer_0 = function () {
                    XForm.identity = new XForm();
                    XForm.identity_$LI$().setIdentity();
                };
                /**
                 * Set this to equal another transform.
                 * @param {org.jbox2d.common.XForm} xf
                 * @return {org.jbox2d.common.XForm}
                 */
                XForm.prototype.set = function (xf) {
                    this.position.set$org_jbox2d_common_Vec2(xf.position);
                    this.R.set$org_jbox2d_common_Mat22(xf.R);
                    return this;
                };
                /**
                 * Set this to the identity transform.
                 */
                XForm.prototype.setIdentity = function () {
                    this.position.setZero();
                    this.R.setIdentity();
                };
                XForm.mul = function (T, v) {
                    return new org.jbox2d.common.Vec2(Math.fround(Math.fround(T.position.x + Math.fround(T.R.col1.x * v.x)) + Math.fround(T.R.col2.x * v.y)), Math.fround(Math.fround(T.position.y + Math.fround(T.R.col1.y * v.x)) + Math.fround(T.R.col2.y * v.y)));
                };
                XForm.mulToOut = function (T, v, out) {
                    var tempy = Math.fround(Math.fround(T.position.y + Math.fround(T.R.col1.y * v.x)) + Math.fround(T.R.col2.y * v.y));
                    out.x = Math.fround(Math.fround(T.position.x + Math.fround(T.R.col1.x * v.x)) + Math.fround(T.R.col2.x * v.y));
                    out.y = tempy;
                };
                XForm.mulTrans = function (T, v) {
                    var v1x = Math.fround(v.x - T.position.x);
                    var v1y = Math.fround(v.y - T.position.y);
                    var b = T.R.col1;
                    var b1 = T.R.col2;
                    return new org.jbox2d.common.Vec2((Math.fround(Math.fround(v1x * b.x) + Math.fround(v1y * b.y))), (Math.fround(Math.fround(v1x * b1.x) + Math.fround(v1y * b1.y))));
                };
                XForm.mulTransToOut = function (T, v, out) {
                    var v1x = Math.fround(v.x - T.position.x);
                    var v1y = Math.fround(v.y - T.position.y);
                    var b = T.R.col1;
                    var b1 = T.R.col2;
                    var tempy = Math.fround(Math.fround(v1x * b1.x) + Math.fround(v1y * b1.y));
                    out.x = Math.fround(Math.fround(v1x * b.x) + Math.fround(v1y * b.y));
                    out.y = tempy;
                };
                /**
                 *
                 * @return {string}
                 */
                XForm.prototype.toString = function () {
                    var s = "XForm:\n";
                    s += "Position: " + this.position + "\n";
                    s += "R: \n" + this.R + "\n";
                    return s;
                };
                return XForm;
            }());
            XForm.__static_initialized = false;
            common.XForm = XForm;
            XForm["__class"] = "org.jbox2d.common.XForm";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            /**
             * Default body definition.  Defines a body with the following characteristics:
             * <UL>
             * <LI>Zero mass/inertia (you can set this later on the Body with setMassFromShapes)
             * <LI>null userData
             * <LI>Position of (0.0f, 0.0f)
             * <LI>Zero rotation
             * <LI>Zero damping (linear + angular)
             * <LI>Able to sleep, but not sleeping to start
             * <LI>Able to rotate
             * <LI>Not a bullet
             * </UL>
             * @class
             */
            var BodyDef = (function () {
                function BodyDef() {
                    if (this.massData === undefined)
                        this.massData = null;
                    if (this.userData === undefined)
                        this.userData = null;
                    if (this.position === undefined)
                        this.position = null;
                    if (this.angle === undefined)
                        this.angle = 0;
                    if (this.linearDamping === undefined)
                        this.linearDamping = 0;
                    if (this.angularDamping === undefined)
                        this.angularDamping = 0;
                    if (this.allowSleep === undefined)
                        this.allowSleep = false;
                    if (this.isSleeping === undefined)
                        this.isSleeping = false;
                    if (this.fixedRotation === undefined)
                        this.fixedRotation = false;
                    if (this.isBullet === undefined)
                        this.isBullet = false;
                    this.massData = new org.jbox2d.collision.MassData();
                    this.massData.center.setZero();
                    this.massData.mass = 0.0;
                    this.massData.I = 0.0;
                    this.userData = null;
                    this.position = new org.jbox2d.common.Vec2(0.0, 0.0);
                    this.angle = 0.0;
                    this.linearDamping = 0.0;
                    this.angularDamping = 0.0;
                    this.allowSleep = true;
                    this.isSleeping = false;
                    this.fixedRotation = false;
                    this.isBullet = false;
                }
                return BodyDef;
            }());
            dynamics.BodyDef = BodyDef;
            BodyDef["__class"] = "org.jbox2d.dynamics.BodyDef";
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            /**
             * Create a BodyGroup from a group of bodies.
             * @param {Array} bodies
             * @class
             * @author eric
             */
            var BodyGroup = (function () {
                function BodyGroup() {
                    var bodies = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        bodies[_i] = arguments[_i];
                    }
                    var _this = this;
                    /*private*/ this.children = ([]);
                    /*private*/ this.bodies = ([]);
                    if (((bodies != null && bodies instanceof Array && (bodies.length == 0 || bodies[0] == null || (bodies[0] != null && bodies[0] instanceof org.jbox2d.dynamics.Body))) || bodies === null)) {
                        var __args = arguments;
                        if (this.world === undefined)
                            this.world = null;
                        this.children = ([]);
                        this.bodies = ([]);
                        if (this.world === undefined)
                            this.world = null;
                        (function () {
                            var w = null;
                            for (var index121 = 0; index121 < bodies.length; index121++) {
                                var b = bodies[index121];
                                {
                                    /* add */ (function (s, e) { if (s.indexOf(e) == -1) {
                                        s.push(e);
                                        return true;
                                    }
                                    else {
                                        return false;
                                    } })(_this.bodies, b);
                                    if (w == null)
                                        w = b.getWorld();
                                    else if (b.getWorld() !== w) {
                                        console.info("Cannot add bodies from different worlds to a BodyGroup");
                                        if (!((false)))
                                            throw new Error("Assertion error line 30: assert (false) : 'Cannot add bodies from different worlds to a BodyGroup';");
                                        ;
                                    }
                                }
                            }
                            _this.world = w;
                        })();
                    }
                    else if (((bodies != null && bodies instanceof Array && (bodies.length == 0 || bodies[0] == null || (bodies[0] != null && bodies[0] instanceof org.jbox2d.dynamics.BodyGroup))) || bodies === null)) {
                        var __args = arguments;
                        var groups_1 = __args[0];
                        if (this.world === undefined)
                            this.world = null;
                        this.children = ([]);
                        this.bodies = ([]);
                        if (this.world === undefined)
                            this.world = null;
                        (function () {
                            var w = null;
                            for (var index122 = 0; index122 < groups_1.length; index122++) {
                                var bg = groups_1[index122];
                                {
                                    /* add */ (function (s, e) { if (s.indexOf(e) == -1) {
                                        s.push(e);
                                        return true;
                                    }
                                    else {
                                        return false;
                                    } })(_this.children, bg);
                                    if (w == null)
                                        w = bg.getWorld();
                                    else if (bg.getWorld() !== w) {
                                        console.info("Cannot add BodyGroups from different worlds to a BodyGroup");
                                        if (!((false)))
                                            throw new Error("Assertion error line 51: assert (false) : 'Cannot add BodyGroups from different worlds to a BodyGroup';");
                                        ;
                                    }
                                }
                            }
                            _this.world = w;
                        })();
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * Get child BodyGroups. Does not return children-of-children.
                 * @return {org.jbox2d.dynamics.BodyGroup[]}
                 */
                BodyGroup.prototype.getChildren = function () {
                    return this.children;
                };
                /**
                 * Get bodies. Does not return bodies that are members of child BodyGroups.
                 *
                 * @see #getBodiesDeep()
                 * @return {org.jbox2d.dynamics.Body[]}
                 */
                BodyGroup.prototype.getBodies = function () {
                    return this.bodies;
                };
                /**
                 * Get all bodies in this group and all children, recursively.
                 *
                 * @see #getBodies() for non-recursive version
                 * @return {org.jbox2d.dynamics.Body[]}
                 */
                BodyGroup.prototype.getBodiesDeep = function () {
                    var res = ([]);
                    /* addAll */ (function (l1, l2) { return l1.push.apply(l1, l2); })(res, this.bodies);
                    for (var index123 = 0; index123 < this.children.length; index123++) {
                        var bg = this.children[index123];
                        {
                            /* addAll */ (function (l1, l2) { return l1.push.apply(l1, l2); })(res, bg.getBodiesDeep());
                        }
                    }
                    return res;
                };
                /**
                 * @return {org.jbox2d.dynamics.World} the world this BodyGroup lives in
                 */
                BodyGroup.prototype.getWorld = function () {
                    return this.world;
                };
                /**
                 * Create a BodyGroup by traversing the joint tree from a seed body.
                 *
                 * @param {org.jbox2d.dynamics.Body} seed
                 * @return {org.jbox2d.dynamics.BodyGroup}
                 */
                BodyGroup.fromSeedConnectedByJoints = function (seed) {
                    var bodies = seed.getConnectedDynamicBodyIsland();
                    return new (__Function.prototype.bind.apply(BodyGroup, [null].concat(bodies.slice(0))));
                };
                return BodyGroup;
            }());
            dynamics.BodyGroup = BodyGroup;
            BodyGroup["__class"] = "org.jbox2d.dynamics.BodyGroup";
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var BoundaryResponse;
            (function (BoundaryResponse) {
                BoundaryResponse[BoundaryResponse["FREEZE_BODY"] = 0] = "FREEZE_BODY";
                BoundaryResponse[BoundaryResponse["DESTROY_BODY"] = 1] = "DESTROY_BODY";
            })(BoundaryResponse = dynamics.BoundaryResponse || (dynamics.BoundaryResponse = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                /**
                 * Base class for contacts between shapes.
                 * @author ewjordan
                 * @param {org.jbox2d.collision.shapes.Shape} s1
                 * @param {org.jbox2d.collision.shapes.Shape} s2
                 * @class
                 */
                var Contact = (function () {
                    function Contact(s1, s2) {
                        var _this = this;
                        if (((s1 != null && s1 instanceof org.jbox2d.collision.shapes.Shape) || s1 === null) && ((s2 != null && s2 instanceof org.jbox2d.collision.shapes.Shape) || s2 === null)) {
                            var __args = arguments;
                            {
                                var __args_5 = arguments;
                                if (this.m_world === undefined)
                                    this.m_world = null;
                                if (this.m_prev === undefined)
                                    this.m_prev = null;
                                if (this.m_next === undefined)
                                    this.m_next = null;
                                if (this.m_node1 === undefined)
                                    this.m_node1 = null;
                                if (this.m_node2 === undefined)
                                    this.m_node2 = null;
                                if (this.m_shape1 === undefined)
                                    this.m_shape1 = null;
                                if (this.m_shape2 === undefined)
                                    this.m_shape2 = null;
                                if (this.m_friction === undefined)
                                    this.m_friction = 0;
                                if (this.m_restitution === undefined)
                                    this.m_restitution = 0;
                                if (this.m_flags === undefined)
                                    this.m_flags = 0;
                                if (this.m_manifoldCount === undefined)
                                    this.m_manifoldCount = 0;
                                if (this.m_toi === undefined)
                                    this.m_toi = 0;
                                if (this.m_world === undefined)
                                    this.m_world = null;
                                if (this.m_prev === undefined)
                                    this.m_prev = null;
                                if (this.m_next === undefined)
                                    this.m_next = null;
                                if (this.m_node1 === undefined)
                                    this.m_node1 = null;
                                if (this.m_node2 === undefined)
                                    this.m_node2 = null;
                                if (this.m_shape1 === undefined)
                                    this.m_shape1 = null;
                                if (this.m_shape2 === undefined)
                                    this.m_shape2 = null;
                                if (this.m_friction === undefined)
                                    this.m_friction = 0;
                                if (this.m_restitution === undefined)
                                    this.m_restitution = 0;
                                if (this.m_flags === undefined)
                                    this.m_flags = 0;
                                if (this.m_manifoldCount === undefined)
                                    this.m_manifoldCount = 0;
                                if (this.m_toi === undefined)
                                    this.m_toi = 0;
                                (function () {
                                    _this.m_node1 = new org.jbox2d.dynamics.contacts.ContactEdge();
                                    _this.m_node2 = new org.jbox2d.dynamics.contacts.ContactEdge();
                                })();
                            }
                            (function () {
                                _this.m_flags = 0;
                                if (s1.isSensor() || s2.isSensor()) {
                                    _this.m_flags |= Contact.e_nonSolidFlag;
                                }
                                _this.m_shape1 = s1;
                                _this.m_shape2 = s2;
                                _this.m_manifoldCount = 0;
                                _this.m_friction = org.jbox2d.common.MathUtils.sqrt(Math.fround(_this.m_shape1.m_friction * _this.m_shape2.m_friction));
                                _this.m_restitution = org.jbox2d.common.MathUtils.max$float$float(_this.m_shape1.m_restitution, _this.m_shape2.m_restitution);
                                _this.m_prev = null;
                                _this.m_next = null;
                                _this.m_node1.contact = null;
                                _this.m_node1.prev = null;
                                _this.m_node1.next = null;
                                _this.m_node1.other = null;
                                _this.m_node2.contact = null;
                                _this.m_node2.prev = null;
                                _this.m_node2.next = null;
                                _this.m_node2.other = null;
                            })();
                        }
                        else if (s1 === undefined && s2 === undefined) {
                            var __args = arguments;
                            if (this.m_world === undefined)
                                this.m_world = null;
                            if (this.m_prev === undefined)
                                this.m_prev = null;
                            if (this.m_next === undefined)
                                this.m_next = null;
                            if (this.m_node1 === undefined)
                                this.m_node1 = null;
                            if (this.m_node2 === undefined)
                                this.m_node2 = null;
                            if (this.m_shape1 === undefined)
                                this.m_shape1 = null;
                            if (this.m_shape2 === undefined)
                                this.m_shape2 = null;
                            if (this.m_friction === undefined)
                                this.m_friction = 0;
                            if (this.m_restitution === undefined)
                                this.m_restitution = 0;
                            if (this.m_flags === undefined)
                                this.m_flags = 0;
                            if (this.m_manifoldCount === undefined)
                                this.m_manifoldCount = 0;
                            if (this.m_toi === undefined)
                                this.m_toi = 0;
                            if (this.m_world === undefined)
                                this.m_world = null;
                            if (this.m_prev === undefined)
                                this.m_prev = null;
                            if (this.m_next === undefined)
                                this.m_next = null;
                            if (this.m_node1 === undefined)
                                this.m_node1 = null;
                            if (this.m_node2 === undefined)
                                this.m_node2 = null;
                            if (this.m_shape1 === undefined)
                                this.m_shape1 = null;
                            if (this.m_shape2 === undefined)
                                this.m_shape2 = null;
                            if (this.m_friction === undefined)
                                this.m_friction = 0;
                            if (this.m_restitution === undefined)
                                this.m_restitution = 0;
                            if (this.m_flags === undefined)
                                this.m_flags = 0;
                            if (this.m_manifoldCount === undefined)
                                this.m_manifoldCount = 0;
                            if (this.m_toi === undefined)
                                this.m_toi = 0;
                            (function () {
                                _this.m_node1 = new org.jbox2d.dynamics.contacts.ContactEdge();
                                _this.m_node2 = new org.jbox2d.dynamics.contacts.ContactEdge();
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    /**
                     * Get the number of manifolds. This is 0 or 1 between convex shapes.
                     * This may be greater than 1 for convex-vs-concave shapes. Each
                     * manifold holds up to two contact points with a shared contact normal.
                     * @return {number}
                     */
                    Contact.prototype.getManifoldCount = function () {
                        return this.m_manifoldCount;
                    };
                    Contact.prototype.isSolid = function () {
                        return (this.m_flags & Contact.e_nonSolidFlag) === 0;
                    };
                    Contact.prototype.getNext = function () {
                        return this.m_next;
                    };
                    Contact.prototype.getShape1 = function () {
                        return this.m_shape1;
                    };
                    Contact.prototype.getShape2 = function () {
                        return this.m_shape2;
                    };
                    Contact.prototype.update = function (listener) {
                        var oldCount = this.getManifoldCount();
                        this.evaluate(listener);
                        var newCount = this.getManifoldCount();
                        var body1 = this.m_shape1.getBody();
                        var body2 = this.m_shape2.getBody();
                        if (newCount === 0 && oldCount > 0) {
                            body1.wakeUp();
                            body2.wakeUp();
                        }
                        if (body1.isStatic() || body1.isBullet() || body2.isStatic() || body2.isBullet()) {
                            this.m_flags &= ~Contact.e_slowFlag;
                        }
                        else {
                            this.m_flags |= Contact.e_slowFlag;
                        }
                    };
                    Contact.initializeRegisters = function () {
                        Contact.s_registers = ([]);
                        Contact.addType(new org.jbox2d.dynamics.contacts.CircleContact(), org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE, org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE);
                        Contact.addType(new org.jbox2d.dynamics.contacts.PolyAndCircleContact(), org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE, org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE);
                        Contact.addType(new org.jbox2d.dynamics.contacts.PolyContact(), org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE, org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE);
                        Contact.addType(new org.jbox2d.dynamics.contacts.PolyAndEdgeContact(), org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE, org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE);
                        Contact.addType(new org.jbox2d.dynamics.contacts.EdgeAndCircleContact(), org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE, org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE);
                        Contact.addType(new org.jbox2d.dynamics.contacts.PointAndCircleContact(), org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE, org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE);
                        Contact.addType(new org.jbox2d.dynamics.contacts.PointAndPolyContact(), org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE, org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE);
                    };
                    Contact.addType = function (createFcn, type1, type2) {
                        var cr = new org.jbox2d.dynamics.contacts.ContactRegister();
                        cr.s1 = type1;
                        cr.s2 = type2;
                        cr.createFcn = createFcn;
                        cr.primary = true;
                        /* add */ (Contact.s_registers.push(cr) > 0);
                        if (type1 !== type2) {
                            var cr2 = new org.jbox2d.dynamics.contacts.ContactRegister();
                            cr2.s2 = type1;
                            cr2.s1 = type2;
                            cr2.createFcn = createFcn;
                            cr2.primary = false;
                            /* add */ (Contact.s_registers.push(cr2) > 0);
                        }
                    };
                    Contact.createContact = function (shape1, shape2) {
                        if (Contact.s_initialized === false) {
                            Contact.initializeRegisters();
                            Contact.s_initialized = true;
                        }
                        var type1 = shape1.m_type;
                        var type2 = shape2.m_type;
                        var register = Contact.getContactRegister(type1, type2);
                        if (register != null) {
                            if (register.primary) {
                                return register.createFcn.create(shape1, shape2);
                            }
                            else {
                                var c = register.createFcn.create(shape2, shape1);
                                for (var i = 0; i < c.getManifoldCount(); ++i) {
                                    {
                                        var m = c.getManifolds()[i];
                                        m.normal.negateLocal();
                                    }
                                    ;
                                }
                                return c;
                            }
                        }
                        else {
                            return null;
                        }
                    };
                    /*private*/ Contact.getContactRegister = function (type1, type2) {
                        for (var i = 0; i < Contact.s_registers.length; ++i) {
                            {
                                var cr = Contact.s_registers[i];
                                if (cr.s1 === type1 && cr.s2 === type2) {
                                    return cr;
                                }
                            }
                            ;
                        }
                        return null;
                    };
                    Contact.destroy = function (contact) {
                        if (!((Contact.s_initialized === true)))
                            throw new Error("Assertion error line 269: assert (s_initialized == true);");
                        ;
                        if (contact.getManifoldCount() > 0) {
                            contact.getShape1().getBody().wakeUp();
                            contact.getShape2().getBody().wakeUp();
                        }
                    };
                    return Contact;
                }());
                Contact.e_nonSolidFlag = 1;
                Contact.e_slowFlag = 2;
                Contact.e_islandFlag = 4;
                Contact.e_toiFlag = 8;
                Contact.s_registers = null;
                Contact.s_initialized = false;
                contacts.Contact = Contact;
                Contact["__class"] = "org.jbox2d.dynamics.contacts.Contact";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var ContactConstraint = (function () {
                    function ContactConstraint() {
                        if (this.points === undefined)
                            this.points = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.manifold === undefined)
                            this.manifold = null;
                        if (this.body1 === undefined)
                            this.body1 = null;
                        if (this.body2 === undefined)
                            this.body2 = null;
                        if (this.friction === undefined)
                            this.friction = 0;
                        if (this.restitution === undefined)
                            this.restitution = 0;
                        if (this.pointCount === undefined)
                            this.pointCount = 0;
                        this.points = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(org.jbox2d.common.Settings.maxManifoldPoints);
                        for (var i = 0; i < org.jbox2d.common.Settings.maxManifoldPoints; i++) {
                            {
                                this.points[i] = new org.jbox2d.dynamics.contacts.ContactConstraintPoint();
                            }
                            ;
                        }
                        this.pointCount = 0;
                        this.normal = new org.jbox2d.common.Vec2();
                        this.manifold = new org.jbox2d.collision.Manifold();
                    }
                    ContactConstraint.prototype.set = function (cp) {
                        this.pointCount = cp.pointCount;
                        this.normal.set$org_jbox2d_common_Vec2(cp.normal);
                        this.manifold.set(cp.manifold);
                        this.friction = cp.friction;
                        this.restitution = cp.restitution;
                        this.body1 = cp.body1;
                        this.body2 = cp.body2;
                        for (var i = 0; i < cp.pointCount; i++) {
                            {
                                this.points[i].set(cp.points[i]);
                            }
                            ;
                        }
                    };
                    return ContactConstraint;
                }());
                contacts.ContactConstraint = ContactConstraint;
                ContactConstraint["__class"] = "org.jbox2d.dynamics.contacts.ContactConstraint";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var ContactConstraintPoint = (function () {
                    function ContactConstraintPoint() {
                        if (this.localAnchor1 === undefined)
                            this.localAnchor1 = null;
                        if (this.localAnchor2 === undefined)
                            this.localAnchor2 = null;
                        if (this.r1 === undefined)
                            this.r1 = null;
                        if (this.r2 === undefined)
                            this.r2 = null;
                        if (this.normalImpulse === undefined)
                            this.normalImpulse = 0;
                        if (this.tangentImpulse === undefined)
                            this.tangentImpulse = 0;
                        if (this.positionImpulse === undefined)
                            this.positionImpulse = 0;
                        if (this.normalMass === undefined)
                            this.normalMass = 0;
                        if (this.tangentMass === undefined)
                            this.tangentMass = 0;
                        if (this.equalizedMass === undefined)
                            this.equalizedMass = 0;
                        if (this.separation === undefined)
                            this.separation = 0;
                        if (this.velocityBias === undefined)
                            this.velocityBias = 0;
                        this.localAnchor1 = new org.jbox2d.common.Vec2();
                        this.localAnchor2 = new org.jbox2d.common.Vec2();
                        this.r1 = new org.jbox2d.common.Vec2();
                        this.r2 = new org.jbox2d.common.Vec2();
                    }
                    ContactConstraintPoint.prototype.set = function (cp) {
                        this.localAnchor1.set$org_jbox2d_common_Vec2(cp.localAnchor1);
                        this.localAnchor2.set$org_jbox2d_common_Vec2(cp.localAnchor2);
                        this.r1.set$org_jbox2d_common_Vec2(cp.r1);
                        this.r2.set$org_jbox2d_common_Vec2(cp.r2);
                        this.normalImpulse = cp.normalImpulse;
                        this.tangentImpulse = cp.tangentImpulse;
                        this.positionImpulse = cp.positionImpulse;
                        this.normalMass = cp.normalMass;
                        this.tangentMass = cp.tangentMass;
                        this.equalizedMass = cp.equalizedMass;
                        this.separation = cp.separation;
                        this.velocityBias = cp.velocityBias;
                    };
                    return ContactConstraintPoint;
                }());
                contacts.ContactConstraintPoint = ContactConstraintPoint;
                ContactConstraintPoint["__class"] = "org.jbox2d.dynamics.contacts.ContactConstraintPoint";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                /**
                 * A contact edge is used to connect bodies and contacts together
                 * in a contact graph where each body is a node and each contact
                 * is an edge. A contact edge belongs to a doubly linked list
                 * maintained in each attached body. Each contact has two contact
                 * nodes, one for each attached body.
                 * @class
                 */
                var ContactEdge = (function () {
                    function ContactEdge() {
                        if (this.other === undefined)
                            this.other = null;
                        if (this.contact === undefined)
                            this.contact = null;
                        if (this.prev === undefined)
                            this.prev = null;
                        if (this.next === undefined)
                            this.next = null;
                    }
                    ContactEdge.prototype.set = function (argToCopy) {
                        this.other = argToCopy.other;
                        this.contact = argToCopy.contact;
                        this.prev = argToCopy.prev;
                        this.next = argToCopy.next;
                    };
                    return ContactEdge;
                }());
                contacts.ContactEdge = ContactEdge;
                ContactEdge["__class"] = "org.jbox2d.dynamics.contacts.ContactEdge";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var ContactPoint = (function () {
                    function ContactPoint() {
                        if (this.shape1 === undefined)
                            this.shape1 = null;
                        if (this.shape2 === undefined)
                            this.shape2 = null;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.velocity === undefined)
                            this.velocity = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.separation === undefined)
                            this.separation = 0;
                        if (this.friction === undefined)
                            this.friction = 0;
                        if (this.restitution === undefined)
                            this.restitution = 0;
                        if (this.id === undefined)
                            this.id = null;
                        this.position = new org.jbox2d.common.Vec2();
                        this.normal = new org.jbox2d.common.Vec2();
                        this.velocity = new org.jbox2d.common.Vec2();
                        this.id = new org.jbox2d.collision.ContactID();
                    }
                    return ContactPoint;
                }());
                contacts.ContactPoint = ContactPoint;
                ContactPoint["__class"] = "org.jbox2d.dynamics.contacts.ContactPoint";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var ContactRegister = (function () {
                    function ContactRegister() {
                        if (this.s1 === undefined)
                            this.s1 = null;
                        if (this.s2 === undefined)
                            this.s2 = null;
                        if (this.createFcn === undefined)
                            this.createFcn = null;
                        if (this.primary === undefined)
                            this.primary = false;
                    }
                    return ContactRegister;
                }());
                contacts.ContactRegister = ContactRegister;
                ContactRegister["__class"] = "org.jbox2d.dynamics.contacts.ContactRegister";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                /**
                 * This structure is used to report contact point results.
                 * @class
                 */
                var ContactResult = (function () {
                    function ContactResult() {
                        if (this.shape1 === undefined)
                            this.shape1 = null;
                        if (this.shape2 === undefined)
                            this.shape2 = null;
                        if (this.position === undefined)
                            this.position = null;
                        if (this.normal === undefined)
                            this.normal = null;
                        if (this.normalImpulse === undefined)
                            this.normalImpulse = 0;
                        if (this.tangentImpulse === undefined)
                            this.tangentImpulse = 0;
                        if (this.id === undefined)
                            this.id = null;
                        this.position = new org.jbox2d.common.Vec2();
                        this.normal = new org.jbox2d.common.Vec2();
                        this.id = new org.jbox2d.collision.ContactID();
                    }
                    return ContactResult;
                }());
                contacts.ContactResult = ContactResult;
                ContactResult["__class"] = "org.jbox2d.dynamics.contacts.ContactResult";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts_1) {
                var ContactSolver = (function () {
                    function ContactSolver() {
                        if (this.m_step === undefined)
                            this.m_step = null;
                        if (this.m_constraints === undefined)
                            this.m_constraints = null;
                        if (this.m_constraintCount === undefined)
                            this.m_constraintCount = 0;
                    }
                    ContactSolver.prototype.init = function (step, contacts, contactCount) {
                        this.m_step = step;
                        this.m_constraintCount = 0;
                        for (var i = 0; i < contactCount; i++) {
                            {
                                if (!((contacts[i].isSolid())))
                                    throw new Error("Assertion error line 19: assert (contacts[i].isSolid());");
                                ;
                                this.m_constraintCount += contacts[i].getManifoldCount();
                            }
                            ;
                        }
                        this.m_constraints = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(this.m_constraintCount);
                        for (var i = 0; i < this.m_constraintCount; i++) {
                            {
                                this.m_constraints[i] = new org.jbox2d.dynamics.contacts.ContactConstraint();
                            }
                            ;
                        }
                        var count = 0;
                        for (var i = 0; i < contactCount; i++) {
                            {
                                var contact = contacts[i];
                                var b1 = contact.m_shape1.getBody();
                                var b2 = contact.m_shape2.getBody();
                                var manifoldCount = contact.getManifoldCount();
                                var manifolds = contact.getManifolds();
                                var friction = contact.m_friction;
                                var restitution = contact.m_restitution;
                                var v1 = b1.m_linearVelocity;
                                var v2 = b2.m_linearVelocity;
                                var w1 = b1.m_angularVelocity;
                                var w2 = b2.m_angularVelocity;
                                for (var j = 0; j < manifoldCount; ++j) {
                                    {
                                        var manifold = manifolds[j];
                                        if (!((manifold.pointCount > 0)))
                                            throw new Error("Assertion error line 41: assert (manifold.pointCount > 0) : 'Manifold ' + j + ' has length 0';");
                                        ;
                                        var normal = manifold.normal;
                                        if (!((count < this.m_constraintCount)))
                                            throw new Error("Assertion error line 43: assert (count < m_constraintCount);");
                                        ;
                                        var c = this.m_constraints[count];
                                        c.body1 = b1;
                                        c.body2 = b2;
                                        c.manifold = manifold;
                                        c.normal.set$org_jbox2d_common_Vec2(normal);
                                        c.pointCount = manifold.pointCount;
                                        c.friction = friction;
                                        c.restitution = restitution;
                                        for (var k = 0; k < c.pointCount; ++k) {
                                            {
                                                var cp = manifold.points[k];
                                                var ccp = c.points[k];
                                                ccp.normalImpulse = cp.normalImpulse;
                                                ccp.tangentImpulse = cp.tangentImpulse;
                                                ccp.separation = cp.separation;
                                                ccp.positionImpulse = 0.0;
                                                ccp.localAnchor1.set$org_jbox2d_common_Vec2(cp.localPoint1);
                                                ccp.localAnchor2.set$org_jbox2d_common_Vec2(cp.localPoint2);
                                                var v3x = Math.fround(cp.localPoint1.x - b1.m_sweep.localCenter.x);
                                                var v3y = Math.fround(cp.localPoint1.y - b1.m_sweep.localCenter.y);
                                                ccp.r1.set$float$float(Math.fround(Math.fround(b1.m_xf.R.col1.x * v3x) + Math.fround(b1.m_xf.R.col2.x * v3y)), Math.fround(Math.fround(b1.m_xf.R.col1.y * v3x) + Math.fround(b1.m_xf.R.col2.y * v3y)));
                                                var v4x = Math.fround(cp.localPoint2.x - b2.m_sweep.localCenter.x);
                                                var v4y = Math.fround(cp.localPoint2.y - b2.m_sweep.localCenter.y);
                                                ccp.r2.set$float$float(Math.fround(Math.fround(b2.m_xf.R.col1.x * v4x) + Math.fround(b2.m_xf.R.col2.x * v4y)), Math.fround(Math.fround(b2.m_xf.R.col1.y * v4x) + Math.fround(b2.m_xf.R.col2.y * v4y)));
                                                var rn1 = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(ccp.r1, normal);
                                                var rn2 = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(ccp.r2, normal);
                                                rn1 *= rn1;
                                                rn2 *= rn2;
                                                var kNormal = Math.fround(Math.fround(Math.fround(b1.m_invMass + b2.m_invMass) + Math.fround(b1.m_invI * rn1)) + Math.fround(b2.m_invI * rn2));
                                                if (!((kNormal > org.jbox2d.common.Settings.EPSILON)))
                                                    throw new Error("Assertion error line 72: assert (kNormal > Settings.EPSILON) : 'kNormal was ' + kNormal;");
                                                ;
                                                ccp.normalMass = Math.fround(1.0 / kNormal);
                                                var kEqualized = Math.fround(Math.fround(b1.m_mass * b1.m_invMass) + Math.fround(b2.m_mass * b2.m_invMass));
                                                kEqualized += Math.fround(Math.fround(Math.fround(b1.m_mass * b1.m_invI) * rn1) + Math.fround(Math.fround(b2.m_mass * b2.m_invI) * rn2));
                                                if (!((kEqualized > org.jbox2d.common.Settings.EPSILON)))
                                                    throw new Error("Assertion error line 76: assert (kEqualized > Settings.EPSILON) : 'kEqualized was ' + kEqualized;");
                                                ;
                                                ccp.equalizedMass = Math.fround(1.0 / kEqualized);
                                                var tangentx = normal.y;
                                                var tangenty = -normal.x;
                                                var a = ccp.r1;
                                                var rt1 = Math.fround(Math.fround(a.x * tangenty) - Math.fround(a.y * tangentx));
                                                var a1 = ccp.r2;
                                                var rt2 = Math.fround(Math.fround(a1.x * tangenty) - Math.fround(a1.y * tangentx));
                                                rt1 *= rt1;
                                                rt2 *= rt2;
                                                var kTangent = Math.fround(Math.fround(Math.fround(b1.m_invMass + b2.m_invMass) + Math.fround(b1.m_invI * rt1)) + Math.fround(b2.m_invI * rt2));
                                                if (!((kTangent > org.jbox2d.common.Settings.EPSILON)))
                                                    throw new Error("Assertion error line 87: assert (kTangent > Settings.EPSILON);");
                                                ;
                                                ccp.tangentMass = Math.fround(1.0 / kTangent);
                                                ccp.velocityBias = 0.0;
                                                if (ccp.separation > 0.0) {
                                                    ccp.velocityBias = Math.fround(-60.0 * ccp.separation);
                                                }
                                                var a2 = ccp.r2;
                                                var a3 = ccp.r1;
                                                var bufferx = Math.fround(Math.fround(Math.fround(Math.fround(-w2 * a2.y) - (Math.fround(-w1 * a3.y))) + v2.x) - v1.x);
                                                var buffery = Math.fround(Math.fround(Math.fround(Math.fround(w2 * a2.x) - Math.fround(w1 * a3.x)) + v2.y) - v1.y);
                                                var vRel = Math.fround(Math.fround(c.normal.x * bufferx) + Math.fround(c.normal.y * buffery));
                                                if (vRel < -org.jbox2d.common.Settings.velocityThreshold_$LI$()) {
                                                    ccp.velocityBias += Math.fround(-c.restitution * vRel);
                                                }
                                            }
                                            ;
                                        }
                                        ++count;
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                        if (!((count === this.m_constraintCount)))
                            throw new Error("Assertion error line 105: assert (count == m_constraintCount);");
                        ;
                    };
                    ContactSolver.prototype.initVelocityConstraints = function (step) {
                        for (var i = 0; i < this.m_constraintCount; ++i) {
                            {
                                var c = this.m_constraints[i];
                                var b1 = c.body1;
                                var b2 = c.body2;
                                var invMass1 = b1.m_invMass;
                                var invI1 = b1.m_invI;
                                var invMass2 = b2.m_invMass;
                                var invI2 = b2.m_invI;
                                var normalx = c.normal.x;
                                var normaly = c.normal.y;
                                var tangentx = normaly;
                                var tangenty = -normalx;
                                if (step.warmStarting) {
                                    for (var j = 0; j < c.pointCount; ++j) {
                                        {
                                            var ccp = c.points[j];
                                            ccp.normalImpulse *= step.dtRatio;
                                            ccp.tangentImpulse *= step.dtRatio;
                                            var px = (Math.fround(Math.fround(ccp.normalImpulse * normalx) + Math.fround(ccp.tangentImpulse * tangentx)));
                                            var py = (Math.fround(Math.fround(ccp.normalImpulse * normaly) + Math.fround(ccp.tangentImpulse * tangenty)));
                                            b1.m_angularVelocity -= Math.fround(invI1 * (Math.fround(Math.fround(ccp.r1.x * py) - Math.fround(ccp.r1.y * px))));
                                            b1.m_linearVelocity.x -= Math.fround(px * invMass1);
                                            b1.m_linearVelocity.y -= Math.fround(py * invMass1);
                                            b2.m_angularVelocity += Math.fround(invI2 * (Math.fround(Math.fround(ccp.r2.x * py) - Math.fround(ccp.r2.y * px))));
                                            b2.m_linearVelocity.x += Math.fround(px * invMass2);
                                            b2.m_linearVelocity.y += Math.fround(py * invMass2);
                                        }
                                        ;
                                    }
                                }
                                else {
                                    for (var j = 0; j < c.pointCount; ++j) {
                                        {
                                            var ccp = c.points[j];
                                            ccp.normalImpulse = 0.0;
                                            ccp.tangentImpulse = 0.0;
                                        }
                                        ;
                                    }
                                }
                            }
                            ;
                        }
                    };
                    ContactSolver.prototype.solveVelocityConstraints = function () {
                        for (var i = 0; i < this.m_constraintCount; ++i) {
                            {
                                var c = this.m_constraints[i];
                                var b1 = c.body1;
                                var b2 = c.body2;
                                var w1 = b1.m_angularVelocity;
                                var w2 = b2.m_angularVelocity;
                                var v1x = b1.m_linearVelocity.x;
                                var v1y = b1.m_linearVelocity.y;
                                var v2x = b2.m_linearVelocity.x;
                                var v2y = b2.m_linearVelocity.y;
                                var invMass1 = b1.m_invMass;
                                var invI1 = b1.m_invI;
                                var invMass2 = b2.m_invMass;
                                var invI2 = b2.m_invI;
                                var normalx = c.normal.x;
                                var normaly = c.normal.y;
                                var tangentx = normaly;
                                var tangenty = -normalx;
                                var friction = c.friction;
                                for (var j = 0; j < c.pointCount; ++j) {
                                    {
                                        var ccp = c.points[j];
                                        var dvx = Math.fround(Math.fround(Math.fround(v2x - Math.fround(w2 * ccp.r2.y)) - v1x) + Math.fround(w1 * ccp.r1.y));
                                        var dvy = Math.fround(Math.fround(Math.fround(v2y + Math.fround(w2 * ccp.r2.x)) - v1y) - Math.fround(w1 * ccp.r1.x));
                                        var vn = Math.fround(Math.fround(dvx * normalx) + Math.fround(dvy * normaly));
                                        var lambda = Math.fround(-ccp.normalMass * (Math.fround(vn - ccp.velocityBias)));
                                        var newImpulse = org.jbox2d.common.MathUtils.max$float$float(Math.fround(ccp.normalImpulse + lambda), 0.0);
                                        lambda = Math.fround(newImpulse - ccp.normalImpulse);
                                        var Px = Math.fround(lambda * normalx);
                                        var Py = Math.fround(lambda * normaly);
                                        v1x -= Math.fround(invMass1 * Px);
                                        v1y -= Math.fround(invMass1 * Py);
                                        w1 -= Math.fround(invI1 * (Math.fround(Math.fround(ccp.r1.x * Py) - Math.fround(ccp.r1.y * Px))));
                                        v2x += Math.fround(invMass2 * Px);
                                        v2y += Math.fround(invMass2 * Py);
                                        w2 += Math.fround(invI2 * (Math.fround(Math.fround(ccp.r2.x * Py) - Math.fround(ccp.r2.y * Px))));
                                        ccp.normalImpulse = newImpulse;
                                    }
                                    ;
                                }
                                for (var j = 0; j < c.pointCount; ++j) {
                                    {
                                        var ccp = c.points[j];
                                        var dvx = Math.fround(Math.fround(Math.fround(v2x - Math.fround(w2 * ccp.r2.y)) - v1x) + Math.fround(w1 * ccp.r1.y));
                                        var dvy = Math.fround(Math.fround(Math.fround(v2y + Math.fround(w2 * ccp.r2.x)) - v1y) - Math.fround(w1 * ccp.r1.x));
                                        var vt = Math.fround(Math.fround(dvx * tangentx) + Math.fround(dvy * tangenty));
                                        var lambda = Math.fround(ccp.tangentMass * (-vt));
                                        var maxFriction = Math.fround(friction * ccp.normalImpulse);
                                        var newImpulse = org.jbox2d.common.MathUtils.max$float$float(-maxFriction, org.jbox2d.common.MathUtils.min(Math.fround(ccp.tangentImpulse + lambda), maxFriction));
                                        lambda = Math.fround(newImpulse - ccp.tangentImpulse);
                                        var px = Math.fround(lambda * tangentx);
                                        var py = Math.fround(lambda * tangenty);
                                        v1x -= Math.fround(px * invMass1);
                                        v1y -= Math.fround(py * invMass1);
                                        w1 -= Math.fround(invI1 * (Math.fround(Math.fround(ccp.r1.x * py) - Math.fround(ccp.r1.y * px))));
                                        v2x += Math.fround(px * invMass2);
                                        v2y += Math.fround(py * invMass2);
                                        w2 += Math.fround(invI2 * (Math.fround(Math.fround(ccp.r2.x * py) - Math.fround(ccp.r2.y * px))));
                                        ccp.tangentImpulse = newImpulse;
                                    }
                                    ;
                                }
                                b1.m_linearVelocity.x = v1x;
                                b1.m_linearVelocity.y = v1y;
                                b1.m_angularVelocity = w1;
                                b2.m_linearVelocity.x = v2x;
                                b2.m_linearVelocity.y = v2y;
                                b2.m_angularVelocity = w2;
                            }
                            ;
                        }
                    };
                    ContactSolver.prototype.finalizeVelocityConstraints = function () {
                        for (var i = 0; i < this.m_constraintCount; ++i) {
                            {
                                var c = this.m_constraints[i];
                                var m = c.manifold;
                                for (var j = 0; j < c.pointCount; ++j) {
                                    {
                                        m.points[j].normalImpulse = c.points[j].normalImpulse;
                                        m.points[j].tangentImpulse = c.points[j].tangentImpulse;
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                    };
                    ContactSolver.prototype.solvePositionConstraints = function (baumgarte) {
                        var minSeparation = 0.0;
                        for (var i = 0; i < this.m_constraintCount; ++i) {
                            {
                                var c = this.m_constraints[i];
                                var b1 = c.body1;
                                var b2 = c.body2;
                                var invMass1 = Math.fround(b1.m_mass * b1.m_invMass);
                                var invI1 = Math.fround(b1.m_mass * b1.m_invI);
                                var invMass2 = Math.fround(b2.m_mass * b2.m_invMass);
                                var invI2 = Math.fround(b2.m_mass * b2.m_invI);
                                var normal = c.normal;
                                for (var j = 0; j < c.pointCount; ++j) {
                                    {
                                        var ccp = c.points[j];
                                        var vx = Math.fround(ccp.localAnchor1.x - b1.m_sweep.localCenter.x);
                                        var vy = Math.fround(ccp.localAnchor1.y - b1.m_sweep.localCenter.y);
                                        var r1x = Math.fround(Math.fround(b1.m_xf.R.col1.x * vx) + Math.fround(b1.m_xf.R.col2.x * vy));
                                        var r1y = Math.fround(Math.fround(b1.m_xf.R.col1.y * vx) + Math.fround(b1.m_xf.R.col2.y * vy));
                                        vx = Math.fround(ccp.localAnchor2.x - b2.m_sweep.localCenter.x);
                                        vy = Math.fround(ccp.localAnchor2.y - b2.m_sweep.localCenter.y);
                                        var r2x = Math.fround(Math.fround(b2.m_xf.R.col1.x * vx) + Math.fround(b2.m_xf.R.col2.x * vy));
                                        var r2y = Math.fround(Math.fround(b2.m_xf.R.col1.y * vx) + Math.fround(b2.m_xf.R.col2.y * vy));
                                        var dpx = Math.fround(Math.fround(Math.fround(b2.m_sweep.c.x + r2x) - b1.m_sweep.c.x) - r1x);
                                        var dpy = Math.fround(Math.fround(Math.fround(b2.m_sweep.c.y + r2y) - b1.m_sweep.c.y) - r1y);
                                        var separation = Math.fround(Math.fround(Math.fround(dpx * normal.x) + Math.fround(dpy * normal.y)) + ccp.separation);
                                        minSeparation = org.jbox2d.common.MathUtils.min(minSeparation, separation);
                                        var C = Math.fround(baumgarte * org.jbox2d.common.MathUtils.clamp$float$float$float(Math.fround(separation + org.jbox2d.common.Settings.linearSlop_$LI$()), -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), 0.0));
                                        var dImpulse = Math.fround(-ccp.equalizedMass * C);
                                        var impulse0 = ccp.positionImpulse;
                                        ccp.positionImpulse = org.jbox2d.common.MathUtils.max$float$float(Math.fround(impulse0 + dImpulse), 0.0);
                                        dImpulse = Math.fround(ccp.positionImpulse - impulse0);
                                        var impulsex = Math.fround(dImpulse * normal.x);
                                        var impulsey = Math.fround(dImpulse * normal.y);
                                        b1.m_sweep.c.x -= Math.fround(invMass1 * impulsex);
                                        b1.m_sweep.c.y -= Math.fround(invMass1 * impulsey);
                                        b1.m_sweep.a -= Math.fround(invI1 * (Math.fround(Math.fround(r1x * impulsey) - Math.fround(r1y * impulsex))));
                                        b1.synchronizeTransform();
                                        b2.m_sweep.c.x += Math.fround(invMass2 * impulsex);
                                        b2.m_sweep.c.y += Math.fround(invMass2 * impulsey);
                                        b2.m_sweep.a += Math.fround(invI2 * (Math.fround(Math.fround(r2x * impulsey) - Math.fround(r2y * impulsex))));
                                        b2.synchronizeTransform();
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                        return minSeparation >= Math.fround(-1.5 * org.jbox2d.common.Settings.linearSlop_$LI$());
                    };
                    return ContactSolver;
                }());
                contacts_1.ContactSolver = ContactSolver;
                ContactSolver["__class"] = "org.jbox2d.dynamics.contacts.ContactSolver";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var controllers;
            (function (controllers) {
                /**
                 *
                 * Base class for controllers. Controllers are a convience for encapsulating common
                 * per-step functionality.
                 * @class
                 */
                var Controller = (function () {
                    function Controller(def) {
                        if (this.m_world === undefined)
                            this.m_world = null;
                        if (this.m_bodyList === undefined)
                            this.m_bodyList = null;
                        if (this.m_bodyCount === undefined)
                            this.m_bodyCount = 0;
                        if (this.m_prev === undefined)
                            this.m_prev = null;
                        if (this.m_next === undefined)
                            this.m_next = null;
                        this.m_world = null;
                        this.m_bodyList = null;
                        this.m_bodyCount = 0;
                        this.m_prev = null;
                        this.m_next = null;
                    }
                    /**
                     * Controllers override this to implement per-step functionality.
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    Controller.prototype.step = function (step) {
                    };
                    /**
                     * Controllers override this to provide debug drawing.
                     * @param {org.jbox2d.dynamics.DebugDraw} debugDraw
                     */
                    Controller.prototype.draw = function (debugDraw) {
                    };
                    /**
                     * Adds a body to the controller list.
                     * @param {org.jbox2d.dynamics.Body} body
                     */
                    Controller.prototype.addBody = function (body) {
                        var edge = new org.jbox2d.dynamics.controllers.ControllerEdge();
                        edge.body = body;
                        edge.controller = this;
                        edge.nextBody = this.m_bodyList;
                        edge.prevBody = null;
                        if (this.m_bodyList != null) {
                            this.m_bodyList.prevBody = edge;
                        }
                        this.m_bodyList = edge;
                        ++this.m_bodyCount;
                        edge.nextController = body.m_controllerList;
                        edge.prevController = null;
                        if (body.m_controllerList != null)
                            body.m_controllerList.prevController = edge;
                        body.m_controllerList = edge;
                    };
                    /**
                     * Removes a body from the controller list.
                     * @param {org.jbox2d.dynamics.Body} body
                     */
                    Controller.prototype.removeBody = function (body) {
                        if (!((this.m_bodyCount > 0)))
                            throw new Error("Assertion error line 49: assert (m_bodyCount > 0);");
                        ;
                        var edge = this.m_bodyList;
                        while ((edge != null && edge.body !== body)) {
                            {
                                edge = edge.nextBody;
                            }
                        }
                        ;
                        if (!((edge != null)))
                            throw new Error("Assertion error line 54: assert (edge != null);");
                        ;
                        if (edge.prevBody != null) {
                            edge.prevBody.nextBody = edge.nextBody;
                        }
                        if (edge.nextBody != null) {
                            edge.nextBody.prevBody = edge.prevBody;
                        }
                        if (edge === this.m_bodyList) {
                            this.m_bodyList = edge.nextBody;
                        }
                        --this.m_bodyCount;
                        if (edge.prevController != null)
                            edge.prevController.nextController = edge.nextController;
                        if (edge.nextController != null)
                            edge.nextController.prevController = edge.prevController;
                        if (edge === body.m_controllerList)
                            body.m_controllerList = edge.nextController;
                    };
                    /**
                     * Removes all bodies from the controller list.
                     */
                    Controller.prototype.clear = function () {
                        while ((this.m_bodyList != null)) {
                            {
                                var edge = this.m_bodyList;
                                this.m_bodyList = edge.nextBody;
                                if (edge.prevController != null)
                                    edge.prevController.nextController = edge.nextController;
                                if (edge.nextController != null)
                                    edge.nextController.prevController = edge.prevController;
                                if (edge === edge.body.m_controllerList)
                                    edge.body.m_controllerList = edge.nextController;
                            }
                        }
                        ;
                        this.m_bodyCount = 0;
                    };
                    /**
                     * Get the next controller in the world's body list.
                     * @return {org.jbox2d.dynamics.controllers.Controller}
                     */
                    Controller.prototype.getNext = function () {
                        return this.m_next;
                    };
                    /**
                     * Get the parent world of this body.
                     * @return {org.jbox2d.dynamics.World}
                     */
                    Controller.prototype.getWorld = function () {
                        return this.m_world;
                    };
                    /**
                     * Get the attached body list
                     * @return {org.jbox2d.dynamics.controllers.ControllerEdge}
                     */
                    Controller.prototype.getBodyList = function () {
                        return this.m_bodyList;
                    };
                    return Controller;
                }());
                controllers.Controller = Controller;
                Controller["__class"] = "org.jbox2d.dynamics.controllers.Controller";
            })(controllers = dynamics.controllers || (dynamics.controllers = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var controllers;
            (function (controllers) {
                /**
                 * @author eric
                 * @class
                 */
                var ControllerDef = (function () {
                    function ControllerDef() {
                    }
                    return ControllerDef;
                }());
                controllers.ControllerDef = ControllerDef;
                ControllerDef["__class"] = "org.jbox2d.dynamics.controllers.ControllerDef";
            })(controllers = dynamics.controllers || (dynamics.controllers = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var controllers;
            (function (controllers) {
                /**
                 * @author eric
                 * @class
                 */
                var ControllerEdge = (function () {
                    function ControllerEdge() {
                        if (this.controller === undefined)
                            this.controller = null;
                        if (this.body === undefined)
                            this.body = null;
                        if (this.prevBody === undefined)
                            this.prevBody = null;
                        if (this.nextBody === undefined)
                            this.nextBody = null;
                        if (this.prevController === undefined)
                            this.prevController = null;
                        if (this.nextController === undefined)
                            this.nextController = null;
                    }
                    return ControllerEdge;
                }());
                controllers.ControllerEdge = ControllerEdge;
                ControllerEdge["__class"] = "org.jbox2d.dynamics.controllers.ControllerEdge";
            })(controllers = dynamics.controllers || (dynamics.controllers = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            /**
             * Implement this abstract class to allow JBox2d to
             * automatically draw your physics for debugging purposes.
             * Not intended to replace your own custom rendering
             * routines!
             * @param {*} viewport
             * @class
             */
            var DebugDraw = (function () {
                function DebugDraw(viewport) {
                    if (this.m_drawFlags === undefined)
                        this.m_drawFlags = 0;
                    if (this.viewportTransform === undefined)
                        this.viewportTransform = null;
                    this.m_drawFlags = 0;
                    this.viewportTransform = viewport;
                }
                DebugDraw.prototype.setFlags = function (flags) {
                    this.m_drawFlags = flags;
                };
                DebugDraw.prototype.getFlags = function () {
                    return this.m_drawFlags;
                };
                DebugDraw.prototype.appendFlags = function (flags) {
                    this.m_drawFlags |= flags;
                };
                DebugDraw.prototype.clearFlags = function (flags) {
                    this.m_drawFlags &= ~flags;
                };
                DebugDraw.prototype.getViewportTranform = function () {
                    return this.viewportTransform;
                };
                /**
                 * @param {number} x
                 * @param {number} y
                 * @param {number} scale
                 * @see IViewportTransform#setCamera(float, float, float)
                 */
                DebugDraw.prototype.setCamera = function (x, y, scale) {
                    this.viewportTransform.setCamera(x, y, scale);
                };
                DebugDraw.prototype.getScreenToWorldToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (argScreen, argWorld) {
                    this.viewportTransform.getScreenToWorld(argScreen, argWorld);
                };
                DebugDraw.prototype.getWorldToScreenToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (argWorld, argScreen) {
                    this.viewportTransform.getWorldToScreen(argWorld, argScreen);
                };
                DebugDraw.prototype.getWorldToScreenToOut$float$float$org_jbox2d_common_Vec2 = function (worldX, worldY, argScreen) {
                    argScreen.set$float$float(worldX, worldY);
                    this.viewportTransform.getWorldToScreen(argScreen, argScreen);
                };
                /**
                 * Takes the world coordinates and puts the corresponding screen
                 * coordinates in argScreen.
                 * @param {number} worldX
                 * @param {number} worldY
                 * @param {org.jbox2d.common.Vec2} argScreen
                 */
                DebugDraw.prototype.getWorldToScreenToOut = function (worldX, worldY, argScreen) {
                    if (((typeof worldX === 'number') || worldX === null) && ((typeof worldY === 'number') || worldY === null) && ((argScreen != null && argScreen instanceof org.jbox2d.common.Vec2) || argScreen === null)) {
                        return this.getWorldToScreenToOut$float$float$org_jbox2d_common_Vec2(worldX, worldY, argScreen);
                    }
                    else if (((worldX != null && worldX instanceof org.jbox2d.common.Vec2) || worldX === null) && ((worldY != null && worldY instanceof org.jbox2d.common.Vec2) || worldY === null) && argScreen === undefined) {
                        return this.getWorldToScreenToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(worldX, worldY);
                    }
                    else
                        throw new Error('invalid overload');
                };
                DebugDraw.prototype.getWorldToScreen$org_jbox2d_common_Vec2 = function (argWorld) {
                    var screen = new org.jbox2d.common.Vec2();
                    this.viewportTransform.getWorldToScreen(argWorld, screen);
                    return screen;
                };
                DebugDraw.prototype.getWorldToScreen$float$float = function (worldX, worldY) {
                    var argScreen = new org.jbox2d.common.Vec2(worldX, worldY);
                    this.viewportTransform.getWorldToScreen(argScreen, argScreen);
                    return argScreen;
                };
                /**
                 * Takes the world coordinates and returns the screen
                 * coordinates.
                 * @param {number} worldX
                 * @param {number} worldY
                 * @return {org.jbox2d.common.Vec2}
                 */
                DebugDraw.prototype.getWorldToScreen = function (worldX, worldY) {
                    if (((typeof worldX === 'number') || worldX === null) && ((typeof worldY === 'number') || worldY === null)) {
                        return this.getWorldToScreen$float$float(worldX, worldY);
                    }
                    else if (((worldX != null && worldX instanceof org.jbox2d.common.Vec2) || worldX === null) && worldY === undefined) {
                        return this.getWorldToScreen$org_jbox2d_common_Vec2(worldX);
                    }
                    else
                        throw new Error('invalid overload');
                };
                DebugDraw.prototype.getScreenToWorldToOut$float$float$org_jbox2d_common_Vec2 = function (screenX, screenY, argWorld) {
                    argWorld.set$float$float(screenX, screenY);
                    this.viewportTransform.getScreenToWorld(argWorld, argWorld);
                };
                /**
                 * takes the screen coordinates and puts the corresponding
                 * world coordinates in argWorld.
                 * @param {number} screenX
                 * @param {number} screenY
                 * @param {org.jbox2d.common.Vec2} argWorld
                 */
                DebugDraw.prototype.getScreenToWorldToOut = function (screenX, screenY, argWorld) {
                    if (((typeof screenX === 'number') || screenX === null) && ((typeof screenY === 'number') || screenY === null) && ((argWorld != null && argWorld instanceof org.jbox2d.common.Vec2) || argWorld === null)) {
                        return this.getScreenToWorldToOut$float$float$org_jbox2d_common_Vec2(screenX, screenY, argWorld);
                    }
                    else if (((screenX != null && screenX instanceof org.jbox2d.common.Vec2) || screenX === null) && ((screenY != null && screenY instanceof org.jbox2d.common.Vec2) || screenY === null) && argWorld === undefined) {
                        return this.getScreenToWorldToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(screenX, screenY);
                    }
                    else
                        throw new Error('invalid overload');
                };
                DebugDraw.prototype.getScreenToWorld$org_jbox2d_common_Vec2 = function (argScreen) {
                    var world = new org.jbox2d.common.Vec2();
                    this.viewportTransform.getScreenToWorld(argScreen, world);
                    return world;
                };
                DebugDraw.prototype.getScreenToWorld$float$float = function (screenX, screenY) {
                    var screen = new org.jbox2d.common.Vec2(screenX, screenY);
                    this.viewportTransform.getScreenToWorld(screen, screen);
                    return screen;
                };
                /**
                 * takes the screen coordinates and returns the
                 * world coordinates.
                 * @param {number} screenX
                 * @param {number} screenY
                 * @return {org.jbox2d.common.Vec2}
                 */
                DebugDraw.prototype.getScreenToWorld = function (screenX, screenY) {
                    if (((typeof screenX === 'number') || screenX === null) && ((typeof screenY === 'number') || screenY === null)) {
                        return this.getScreenToWorld$float$float(screenX, screenY);
                    }
                    else if (((screenX != null && screenX instanceof org.jbox2d.common.Vec2) || screenX === null) && screenY === undefined) {
                        return this.getScreenToWorld$org_jbox2d_common_Vec2(screenX);
                    }
                    else
                        throw new Error('invalid overload');
                };
                return DebugDraw;
            }());
            DebugDraw.e_shapeBit = 1;
            DebugDraw.e_jointBit = 2;
            DebugDraw.e_coreShapeBit = 4;
            DebugDraw.e_aabbBit = 8;
            DebugDraw.e_obbBit = 16;
            DebugDraw.e_pairBit = 32;
            DebugDraw.e_centerOfMassBit = 64;
            DebugDraw.e_controllerBit = 128;
            dynamics.DebugDraw = DebugDraw;
            DebugDraw["__class"] = "org.jbox2d.dynamics.DebugDraw";
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            /**
             * Default sample implementation of ContactFilter.
             * @class
             */
            var DefaultContactFilter = (function () {
                function DefaultContactFilter() {
                }
                /**
                 * Return true if contact calculations should be performed between these two shapes.
                 * If you implement your own collision filter you may want to build from this implementation.
                 * @param {org.jbox2d.collision.shapes.Shape} shape1
                 * @param {org.jbox2d.collision.shapes.Shape} shape2
                 * @return {boolean}
                 */
                DefaultContactFilter.prototype.shouldCollide = function (shape1, shape2) {
                    var filter1 = shape1.getFilterData();
                    var filter2 = shape2.getFilterData();
                    if (filter1.groupIndex === filter2.groupIndex && filter1.groupIndex !== 0) {
                        return filter1.groupIndex > 0;
                    }
                    var collide = (filter1.maskBits & filter2.categoryBits) !== 0 && (filter1.categoryBits & filter2.maskBits) !== 0;
                    return collide;
                };
                DefaultContactFilter.prototype.rayCollide = function (userData, shape) {
                    if (userData == null) {
                        return true;
                    }
                    return this.shouldCollide(userData, shape);
                };
                return DefaultContactFilter;
            }());
            dynamics.DefaultContactFilter = DefaultContactFilter;
            DefaultContactFilter["__class"] = "org.jbox2d.dynamics.DefaultContactFilter";
            DefaultContactFilter["__interfaces"] = ["org.jbox2d.dynamics.ContactFilter"];
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var Jacobian = (function () {
                    function Jacobian() {
                        if (this.linear1 === undefined)
                            this.linear1 = null;
                        if (this.angular1 === undefined)
                            this.angular1 = 0;
                        if (this.linear2 === undefined)
                            this.linear2 = null;
                        if (this.angular2 === undefined)
                            this.angular2 = 0;
                        this.linear1 = new org.jbox2d.common.Vec2();
                        this.linear2 = new org.jbox2d.common.Vec2();
                        this.angular1 = 0;
                        this.angular2 = 0;
                    }
                    Jacobian.prototype.setZero = function () {
                        this.linear1.setZero();
                        this.angular1 = 0.0;
                        this.linear2.setZero();
                        this.angular2 = 0.0;
                    };
                    Jacobian.prototype.set = function (x1, a1, x2, a2) {
                        this.linear1.set$org_jbox2d_common_Vec2(x1);
                        this.angular1 = a1;
                        this.linear2.set$org_jbox2d_common_Vec2(x2);
                        this.angular2 = a2;
                    };
                    Jacobian.prototype.compute = function (x1, a1, x2, a2) {
                        return Math.fround(Math.fround(Math.fround(org.jbox2d.common.Vec2.dot(this.linear1, x1) + Math.fround(this.angular1 * a1)) + org.jbox2d.common.Vec2.dot(this.linear2, x2)) + Math.fround(this.angular2 * a2));
                    };
                    return Jacobian;
                }());
                joints.Jacobian = Jacobian;
                Jacobian["__class"] = "org.jbox2d.dynamics.joints.Jacobian";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * Base class for all Joints
                 * @param {org.jbox2d.dynamics.joints.JointDef} description
                 * @class
                 */
                var Joint = (function () {
                    function Joint(description) {
                        if (this.m_type === undefined)
                            this.m_type = null;
                        if (this.m_prev === undefined)
                            this.m_prev = null;
                        if (this.m_next === undefined)
                            this.m_next = null;
                        if (this.m_node1 === undefined)
                            this.m_node1 = null;
                        if (this.m_node2 === undefined)
                            this.m_node2 = null;
                        if (this.m_body1 === undefined)
                            this.m_body1 = null;
                        if (this.m_body2 === undefined)
                            this.m_body2 = null;
                        if (this.m_islandFlag === undefined)
                            this.m_islandFlag = false;
                        if (this.m_collideConnected === undefined)
                            this.m_collideConnected = false;
                        if (this.m_userData === undefined)
                            this.m_userData = null;
                        if (this.m_inv_dt === undefined)
                            this.m_inv_dt = 0;
                        this.m_type = description.type;
                        this.m_prev = null;
                        this.m_next = null;
                        this.m_node1 = new org.jbox2d.dynamics.joints.JointEdge();
                        this.m_node2 = new org.jbox2d.dynamics.joints.JointEdge();
                        this.m_body1 = description.body1;
                        this.m_body2 = description.body2;
                        this.m_collideConnected = description.collideConnected;
                        this.m_islandFlag = false;
                        this.m_userData = description.userData;
                    }
                    Joint.destroy = function (j) {
                        j.destructor();
                        return;
                    };
                    Joint.prototype.destructor = function () {
                    };
                    Joint.create = function (description) {
                        var joint = null;
                        if (description.type === org.jbox2d.dynamics.joints.JointType.DISTANCE_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.DistanceJoint(description);
                        }
                        else if (description.type === org.jbox2d.dynamics.joints.JointType.MOUSE_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.MouseJoint(description);
                        }
                        else if (description.type === org.jbox2d.dynamics.joints.JointType.PRISMATIC_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.PrismaticJoint(description);
                        }
                        else if (description.type === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.RevoluteJoint(description);
                        }
                        else if (description.type === org.jbox2d.dynamics.joints.JointType.PULLEY_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.PulleyJoint(description);
                        }
                        else if (description.type === org.jbox2d.dynamics.joints.JointType.GEAR_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.GearJoint(description);
                        }
                        else if (description.type === org.jbox2d.dynamics.joints.JointType.CONSTANT_VOLUME_JOINT) {
                            joint = new org.jbox2d.dynamics.joints.ConstantVolumeJoint(description);
                        }
                        else {
                            if (!(false))
                                throw new Error("Assertion error line 79: assert false;");
                            ;
                        }
                        return joint;
                    };
                    /**
                     * Get the type of the concrete joint.
                     * @return {org.jbox2d.dynamics.joints.JointType}
                     */
                    Joint.prototype.getType = function () {
                        return this.m_type;
                    };
                    /**
                     * Get the first body attached to this joint.
                     * @return {org.jbox2d.dynamics.Body}
                     */
                    Joint.prototype.getBody1 = function () {
                        return this.m_body1;
                    };
                    /**
                     * Get the second body attached to this joint.
                     * @return {org.jbox2d.dynamics.Body}
                     */
                    Joint.prototype.getBody2 = function () {
                        return this.m_body2;
                    };
                    /**
                     * Get the next joint the world joint list.
                     * @return {org.jbox2d.dynamics.joints.Joint}
                     */
                    Joint.prototype.getNext = function () {
                        return this.m_next;
                    };
                    /**
                     * Get the user data pointer.
                     * @return {*}
                     */
                    Joint.prototype.getUserData = function () {
                        return this.m_userData;
                    };
                    /**
                     * Set the user data pointer.
                     * @param {*} o
                     */
                    Joint.prototype.setUserData = function (o) {
                        this.m_userData = o;
                    };
                    Joint.prototype.initPositionConstraints = function () {
                        return;
                    };
                    return Joint;
                }());
                joints.Joint = Joint;
                Joint["__class"] = "org.jbox2d.dynamics.joints.Joint";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * Base class for all joint definitions
                 * @class
                 */
                var JointDef = (function () {
                    function JointDef() {
                        if (this.type === undefined)
                            this.type = null;
                        if (this.body1 === undefined)
                            this.body1 = null;
                        if (this.body2 === undefined)
                            this.body2 = null;
                        if (this.userData === undefined)
                            this.userData = null;
                        if (this.collideConnected === undefined)
                            this.collideConnected = false;
                        this.type = org.jbox2d.dynamics.joints.JointType.UNKNOWN_JOINT;
                        this.body1 = null;
                        this.body2 = null;
                        this.userData = null;
                        this.collideConnected = false;
                    }
                    return JointDef;
                }());
                joints.JointDef = JointDef;
                JointDef["__class"] = "org.jbox2d.dynamics.joints.JointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var JointEdge = (function () {
                    function JointEdge() {
                        if (this.other === undefined)
                            this.other = null;
                        if (this.joint === undefined)
                            this.joint = null;
                        if (this.prev === undefined)
                            this.prev = null;
                        if (this.next === undefined)
                            this.next = null;
                    }
                    return JointEdge;
                }());
                joints.JointEdge = JointEdge;
                JointEdge["__class"] = "org.jbox2d.dynamics.joints.JointEdge";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var JointType;
                (function (JointType) {
                    JointType[JointType["UNKNOWN_JOINT"] = 0] = "UNKNOWN_JOINT";
                    JointType[JointType["REVOLUTE_JOINT"] = 1] = "REVOLUTE_JOINT";
                    JointType[JointType["PRISMATIC_JOINT"] = 2] = "PRISMATIC_JOINT";
                    JointType[JointType["DISTANCE_JOINT"] = 3] = "DISTANCE_JOINT";
                    JointType[JointType["PULLEY_JOINT"] = 4] = "PULLEY_JOINT";
                    JointType[JointType["MOUSE_JOINT"] = 5] = "MOUSE_JOINT";
                    JointType[JointType["GEAR_JOINT"] = 6] = "GEAR_JOINT";
                    JointType[JointType["CONSTANT_VOLUME_JOINT"] = 7] = "CONSTANT_VOLUME_JOINT";
                })(JointType = joints.JointType || (joints.JointType = {}));
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var LimitState;
                (function (LimitState) {
                    LimitState[LimitState["INACTIVE_LIMIT"] = 0] = "INACTIVE_LIMIT";
                    LimitState[LimitState["AT_LOWER_LIMIT"] = 1] = "AT_LOWER_LIMIT";
                    LimitState[LimitState["AT_UPPER_LIMIT"] = 2] = "AT_UPPER_LIMIT";
                    LimitState[LimitState["EQUAL_LIMITS"] = 3] = "EQUAL_LIMITS";
                })(LimitState = joints.LimitState || (joints.LimitState = {}));
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            /**
             * A holder for time step information.
             * @class
             */
            var TimeStep = (function () {
                function TimeStep() {
                    if (this.dt === undefined)
                        this.dt = 0;
                    if (this.inv_dt === undefined)
                        this.inv_dt = 0;
                    if (this.dtRatio === undefined)
                        this.dtRatio = 0;
                    if (this.warmStarting === undefined)
                        this.warmStarting = false;
                    if (this.positionCorrection === undefined)
                        this.positionCorrection = false;
                    if (this.maxIterations === undefined)
                        this.maxIterations = 0;
                }
                return TimeStep;
            }());
            dynamics.TimeStep = TimeStep;
            TimeStep["__class"] = "org.jbox2d.dynamics.TimeStep";
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            /**
             * Set of static methods for creating more complex bodies easily.
             * @class
             */
            var BodyUtils = (function () {
                function BodyUtils() {
                }
                return BodyUtils;
            }());
            p5.BodyUtils = BodyUtils;
            BodyUtils["__class"] = "org.jbox2d.p5.BodyUtils";
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            /**
             * A class to hold static methods for applying forces to bodies / shapes /
             * objects in various ways. If you find yourself duplicating code to do things
             * like this, then add it here!
             *
             * @author Greg
             *
             * @class
             */
            var ForceUtils = (function () {
                function ForceUtils() {
                }
                /**
                 * Pushes a body towards the specified location.
                 * @param {org.jbox2d.dynamics.Body} b
                 * @param {org.jbox2d.common.Vec2} worldTarget
                 * @param {number} force
                 */
                ForceUtils.prototype.pushTowards = function (b, worldTarget, force) {
                    var bodyVec = b.getMemberWorldCenter();
                    worldTarget.subLocal(bodyVec);
                    worldTarget.normalize();
                    worldTarget.mulLocal(Math.fround(force));
                    b.applyForce(worldTarget, bodyVec);
                };
                /**
                 * Pushes a body in the specified direction.
                 * @param {org.jbox2d.dynamics.Body} b
                 * @param {org.jbox2d.common.Vec2} dir
                 * @param {number} force
                 */
                ForceUtils.prototype.push = function (b, dir, force) {
                    var bodyVec = b.getMemberWorldCenter();
                    dir.normalize();
                    if (force > 0) {
                        dir.mulLocal(Math.fround(force));
                    }
                    b.applyForce(dir, bodyVec);
                };
                return ForceUtils;
            }());
            p5.ForceUtils = ForceUtils;
            ForceUtils["__class"] = "org.jbox2d.p5.ForceUtils";
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            /**
             * Tracks the reaction force of a given joint, and destroys the joint if the reaction force is above
             * a given threshold AND is between the minimum and maximum allowable angles. This is useful for creating
             * mouse-controlled joints where the "release" should only happen in one direction, and when a certain
             * force threshold is reached.
             * @author Greg
             * @param {org.jbox2d.dynamics.joints.Joint} joint
             * @param {number} reactionThreshold
             * @class
             */
            var JointBreaker = (function () {
                function JointBreaker(joint, reactionThreshold) {
                    if (this.joint === undefined)
                        this.joint = null;
                    if (this.reactionThreshold === undefined)
                        this.reactionThreshold = 0;
                    if (this.angleLo === undefined)
                        this.angleLo = 0;
                    if (this.angleHi === undefined)
                        this.angleHi = 0;
                    this.joint = joint;
                    this.reactionThreshold = reactionThreshold;
                }
                JointBreaker.prototype.step = function (dt, iterations) {
                    if (this.joint != null) {
                        var force = this.joint.getReactionForce();
                        var forceAngle = org.jbox2d.p5.PhysicsUtils.angle$org_jbox2d_common_Vec2(force);
                        var forceMag = force.length();
                        if (forceMag > this.reactionThreshold) {
                            if (this.angleLo === this.angleHi || (forceAngle >= this.angleLo && forceAngle <= this.angleHi)) {
                                this.joint.getBody1().getWorld().destroyJoint(this.joint);
                                this.joint = null;
                                this.joint.getBody1().getWorld().unregisterPostStep(this);
                            }
                        }
                    }
                };
                /**
                 * Sets the range of angles between which this jointbreaker will break the joint. Angles are in radians,
                 * relative to due east.
                 * @param {number} lo
                 * @param {number} hi
                 */
                JointBreaker.prototype.setAngleLimits = function (lo, hi) {
                    this.angleLo = lo;
                    this.angleHi = hi;
                };
                return JointBreaker;
            }());
            p5.JointBreaker = JointBreaker;
            JointBreaker["__class"] = "org.jbox2d.p5.JointBreaker";
            JointBreaker["__interfaces"] = ["org.jbox2d.dynamics.Steppable"];
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            var JointUtils = (function () {
                function JointUtils() {
                }
                JointUtils.createDistanceJoint$org_jbox2d_dynamics_World$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (w, pA, pB) {
                    var bodies = JointUtils.getTwoDistinctBodies(w, pA, pB);
                    if (bodies == null || bodies.length !== 2)
                        return null;
                    var jd = new org.jbox2d.dynamics.joints.DistanceJointDef();
                    jd.initialize(bodies[0], bodies[1], pA, pB);
                    return w.createJoint(jd);
                };
                /**
                 * Creates a distance joint between bodies that touch the given points,
                 * anchored at those points. Returns null if there are not two different
                 * bodies at the points given. Behavior is undetermined if more than one
                 * body touches a point.
                 *
                 * @param {org.jbox2d.dynamics.World} w
                 * World to add joint to and read bodies from
                 * @param {org.jbox2d.common.Vec2} pA
                 * First point to attach to
                 * @param {org.jbox2d.common.Vec2} pB
                 * Second point to attach to
                 * @return {org.jbox2d.dynamics.joints.DistanceJoint} Joint created, or null if impossible to create the joint
                 */
                JointUtils.createDistanceJoint = function (w, pA, pB) {
                    if (((w != null && w instanceof org.jbox2d.dynamics.World) || w === null) && ((pA != null && pA instanceof org.jbox2d.common.Vec2) || pA === null) && ((pB != null && pB instanceof org.jbox2d.common.Vec2) || pB === null)) {
                        return org.jbox2d.p5.JointUtils.createDistanceJoint$org_jbox2d_dynamics_World$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(w, pA, pB);
                    }
                    else if (((w != null && w instanceof org.jbox2d.dynamics.Body) || w === null) && ((pA != null && pA instanceof org.jbox2d.dynamics.Body) || pA === null) && pB === undefined) {
                        return org.jbox2d.p5.JointUtils.createDistanceJoint$org_jbox2d_dynamics_Body$org_jbox2d_dynamics_Body(w, pA);
                    }
                    else
                        throw new Error('invalid overload');
                };
                JointUtils.createDistanceJoint$org_jbox2d_dynamics_Body$org_jbox2d_dynamics_Body = function (a, b) {
                    var jd = new org.jbox2d.dynamics.joints.DistanceJointDef();
                    jd.body1 = a;
                    jd.body2 = b;
                    var length = a.getMemberPosition().subLocal(b.getMemberPosition()).length();
                    jd.length = length;
                    var j = a.getWorld().createJoint(jd);
                    return j;
                };
                /**
                 * Creates a RevoluteJoint between two bodies that rotates around a given
                 * point in World coordinates.
                 *
                 * @param {org.jbox2d.dynamics.Body} a
                 * @param {org.jbox2d.dynamics.Body} b
                 * @param {org.jbox2d.common.Vec2} worldCenter
                 * @return
                 * @return {org.jbox2d.dynamics.joints.RevoluteJoint}
                 */
                JointUtils.createRevoluteJoint = function (a, b, worldCenter) {
                    var jd = new org.jbox2d.dynamics.joints.RevoluteJointDef();
                    jd.body1 = a;
                    jd.body2 = b;
                    jd.localAnchor1 = a.getLocalPoint(worldCenter);
                    jd.localAnchor2 = b.getLocalPoint(worldCenter);
                    var j = a.getWorld().createJoint(jd);
                    return j;
                };
                /**
                 * <p>
                 * Finds a pair of non-identical bodies that have shapes touching points pA
                 * and pB, loaded resp. into the 0th and 1st elements of the returned array.
                 * Returns null array if no such pair exists.
                 * </p>
                 * <p>
                 * This method is useful for creating joints based on location, where the
                 * two bodies in a joint must be distinct.
                 * </p>
                 *
                 * @param {org.jbox2d.dynamics.World} w
                 * @param {org.jbox2d.common.Vec2} pA
                 * @param {org.jbox2d.common.Vec2} pB
                 * @return {Array} a Body array containing two distinct bodies, or NULL if no
                 * distinct bodies exist at the given points.
                 * @private
                 */
                /*private*/ JointUtils.getTwoDistinctBodies = function (w, pA, pB) {
                    var aabb1 = new org.jbox2d.collision.AABB(new org.jbox2d.common.Vec2(Math.fround(pA.x - 0.001), Math.fround(pA.y - 0.001)), new org.jbox2d.common.Vec2(Math.fround(pA.x + 0.001), Math.fround(pA.y + 0.001)));
                    var aabb2 = new org.jbox2d.collision.AABB(new org.jbox2d.common.Vec2(Math.fround(pB.x - 0.001), Math.fround(pB.y - 0.001)), new org.jbox2d.common.Vec2(Math.fround(pB.x + 0.001), Math.fround(pB.y + 0.001)));
                    var maxCount = 10;
                    var shapes1 = w.query(aabb1, maxCount);
                    if (shapes1[0] == null)
                        return null;
                    var shapes2 = w.query(aabb2, maxCount);
                    if (shapes2[0] == null)
                        return null;
                    var found = false;
                    var i = 0;
                    var j = 0;
                    var body1 = null;
                    var body2 = null;
                    while ((!found)) {
                        {
                            if (i >= shapes1.length || shapes1[i] == null)
                                return null;
                            if (shapes1[i].testPoint(shapes1[i].getBody().getMemberXForm(), pA))
                                body1 = shapes1[i++].getBody();
                            for (j = 0; j < shapes2.length; ++j) {
                                {
                                    if (shapes2[j] == null)
                                        break;
                                    if (shapes2[j].testPoint(shapes2[j].getBody().getMemberXForm(), pB))
                                        body2 = shapes2[j].getBody();
                                    if (body2 !== body1) {
                                        found = true;
                                        break;
                                    }
                                }
                                ;
                            }
                        }
                    }
                    ;
                    if (body1 == null || body2 == null)
                        return null;
                    var bodies = [body1, body2];
                    return bodies;
                };
                return JointUtils;
            }());
            p5.JointUtils = JointUtils;
            JointUtils["__class"] = "org.jbox2d.p5.JointUtils";
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            /**
             * Set up a physics world.
             *
             * @param {*} parent The PApplet this physics world should use
             * @param {number} gravX The x component of gravity, in meters/sec^2
             * @param {number} gravY The y component of gravity, in meters/sec^2
             * @param {number} screenAABBWidth The world's width, in pixels - should be significantly larger than the area you intend to use
             * @param {number} screenAABBHeight The world's height, in pixels - should be significantly larger than the area you intend to use
             * @param {number} borderBoxWidth The containing box's width - should be smaller than the world width, so that no object can escape
             * @param {number} borderBoxHeight The containing box's height - should be smaller than the world height, so that no object can escape
             * @param {number} pixelsPerMeter Pixels per physical meter
             * @param {number} screenW
             * @param {number} screenH
             * @class
             * @author ewjordan
             */
            var Physics = (function () {
                function Physics(parent, screenW, screenH, gravX, gravY, screenAABBWidth, screenAABBHeight, borderBoxWidth, borderBoxHeight, pixelsPerMeter) {
                    var _this = this;
                    if (((parent != null && (parent["__interfaces"] != null && parent["__interfaces"].indexOf("def.processing.core.PApplet") >= 0 || parent.constructor != null && parent.constructor["__interfaces"] != null && parent.constructor["__interfaces"].indexOf("def.processing.core.PApplet") >= 0)) || parent === null) && ((typeof screenW === 'number') || screenW === null) && ((typeof screenH === 'number') || screenH === null) && ((typeof gravX === 'number') || gravX === null) && ((typeof gravY === 'number') || gravY === null) && ((typeof screenAABBWidth === 'number') || screenAABBWidth === null) && ((typeof screenAABBHeight === 'number') || screenAABBHeight === null) && ((typeof borderBoxWidth === 'number') || borderBoxWidth === null) && ((typeof borderBoxHeight === 'number') || borderBoxHeight === null) && ((typeof pixelsPerMeter === 'number') || pixelsPerMeter === null)) {
                        var __args = arguments;
                        if (this.m_world === undefined)
                            this.m_world = null;
                        if (this.m_parent === undefined)
                            this.m_parent = null;
                        if (this.m_draw === undefined)
                            this.m_draw = null;
                        if (this.m_gravity === undefined)
                            this.m_gravity = null;
                        if (this.m_worldAABB === undefined)
                            this.m_worldAABB = null;
                        if (this.m_settings === undefined)
                            this.m_settings = null;
                        if (this.m_border === undefined)
                            this.m_border = null;
                        if (this.m_density === undefined)
                            this.m_density = 0;
                        if (this.m_restitution === undefined)
                            this.m_restitution = 0;
                        if (this.m_friction === undefined)
                            this.m_friction = 0;
                        if (this.m_bullet === undefined)
                            this.m_bullet = false;
                        if (this.m_sensor === undefined)
                            this.m_sensor = false;
                        if (this.m_customRenderingMethod === undefined)
                            this.m_customRenderingMethod = null;
                        if (this.m_customRenderingObject === undefined)
                            this.m_customRenderingObject = null;
                        if (this.m_world === undefined)
                            this.m_world = null;
                        if (this.m_parent === undefined)
                            this.m_parent = null;
                        if (this.m_draw === undefined)
                            this.m_draw = null;
                        if (this.m_gravity === undefined)
                            this.m_gravity = null;
                        if (this.m_worldAABB === undefined)
                            this.m_worldAABB = null;
                        if (this.m_settings === undefined)
                            this.m_settings = null;
                        if (this.m_border === undefined)
                            this.m_border = null;
                        if (this.m_density === undefined)
                            this.m_density = 0;
                        if (this.m_restitution === undefined)
                            this.m_restitution = 0;
                        if (this.m_friction === undefined)
                            this.m_friction = 0;
                        if (this.m_bullet === undefined)
                            this.m_bullet = false;
                        if (this.m_sensor === undefined)
                            this.m_sensor = false;
                        if (this.m_customRenderingMethod === undefined)
                            this.m_customRenderingMethod = null;
                        if (this.m_customRenderingObject === undefined)
                            this.m_customRenderingObject = null;
                        (function () {
                            _this.m_parent = parent;
                            _this.m_draw = new org.jbox2d.testbed.ProcessingDebugDraw(_this.m_parent);
                            _this.m_gravity = new org.jbox2d.common.Vec2(gravX, gravY);
                            _this.m_draw.setCamera(0, 0, pixelsPerMeter);
                            var minWorldAABB = new org.jbox2d.common.Vec2(Math.fround(Math.fround(-screenAABBWidth * 0.5) / pixelsPerMeter), Math.fround(Math.fround(-screenAABBHeight * 0.5) / pixelsPerMeter));
                            var maxWorldAABB = minWorldAABB.mul(-1.0);
                            var doSleep = true;
                            _this.m_world = new org.jbox2d.dynamics.World(new org.jbox2d.collision.AABB(minWorldAABB, maxWorldAABB), _this.m_gravity, doSleep);
                            _this.m_world.setDebugDraw(_this.m_draw);
                            _this.m_world.setDrawDebugData(false);
                            _this.m_settings = new org.jbox2d.testbed.TestSettings();
                            _this.setDensity(0.0);
                            _this.setRestitution(0.1);
                            _this.setFriction(0.4);
                            _this.setBullet(false);
                            _this.setSensor(false);
                            _this.m_border = _this.createHollowBox(Math.fround(screenW * 0.5), Math.fround(screenH * 0.5), borderBoxWidth, borderBoxHeight, 10.0);
                            parent.registerMethod("draw", _this);
                        })();
                    }
                    else if (((parent != null && (parent["__interfaces"] != null && parent["__interfaces"].indexOf("def.processing.core.PApplet") >= 0 || parent.constructor != null && parent.constructor["__interfaces"] != null && parent.constructor["__interfaces"].indexOf("def.processing.core.PApplet") >= 0)) || parent === null) && ((typeof screenW === 'number') || screenW === null) && ((typeof screenH === 'number') || screenH === null) && gravX === undefined && gravY === undefined && screenAABBWidth === undefined && screenAABBHeight === undefined && borderBoxWidth === undefined && borderBoxHeight === undefined && pixelsPerMeter === undefined) {
                        var __args = arguments;
                        {
                            var __args_6 = arguments;
                            var gravX_1 = 0.0;
                            var gravY_1 = -10.0;
                            var screenAABBWidth_1 = Math.fround(2 * __args_6[1]);
                            var screenAABBHeight_1 = Math.fround(2 * __args_6[2]);
                            var borderBoxWidth_1 = __args_6[1];
                            var borderBoxHeight_1 = __args_6[2];
                            var pixelsPerMeter_1 = 10.0;
                            if (this.m_world === undefined)
                                this.m_world = null;
                            if (this.m_parent === undefined)
                                this.m_parent = null;
                            if (this.m_draw === undefined)
                                this.m_draw = null;
                            if (this.m_gravity === undefined)
                                this.m_gravity = null;
                            if (this.m_worldAABB === undefined)
                                this.m_worldAABB = null;
                            if (this.m_settings === undefined)
                                this.m_settings = null;
                            if (this.m_border === undefined)
                                this.m_border = null;
                            if (this.m_density === undefined)
                                this.m_density = 0;
                            if (this.m_restitution === undefined)
                                this.m_restitution = 0;
                            if (this.m_friction === undefined)
                                this.m_friction = 0;
                            if (this.m_bullet === undefined)
                                this.m_bullet = false;
                            if (this.m_sensor === undefined)
                                this.m_sensor = false;
                            if (this.m_customRenderingMethod === undefined)
                                this.m_customRenderingMethod = null;
                            if (this.m_customRenderingObject === undefined)
                                this.m_customRenderingObject = null;
                            if (this.m_world === undefined)
                                this.m_world = null;
                            if (this.m_parent === undefined)
                                this.m_parent = null;
                            if (this.m_draw === undefined)
                                this.m_draw = null;
                            if (this.m_gravity === undefined)
                                this.m_gravity = null;
                            if (this.m_worldAABB === undefined)
                                this.m_worldAABB = null;
                            if (this.m_settings === undefined)
                                this.m_settings = null;
                            if (this.m_border === undefined)
                                this.m_border = null;
                            if (this.m_density === undefined)
                                this.m_density = 0;
                            if (this.m_restitution === undefined)
                                this.m_restitution = 0;
                            if (this.m_friction === undefined)
                                this.m_friction = 0;
                            if (this.m_bullet === undefined)
                                this.m_bullet = false;
                            if (this.m_sensor === undefined)
                                this.m_sensor = false;
                            if (this.m_customRenderingMethod === undefined)
                                this.m_customRenderingMethod = null;
                            if (this.m_customRenderingObject === undefined)
                                this.m_customRenderingObject = null;
                            (function () {
                                _this.m_parent = parent;
                                _this.m_draw = new org.jbox2d.testbed.ProcessingDebugDraw(_this.m_parent);
                                _this.m_gravity = new org.jbox2d.common.Vec2(gravX_1, gravY_1);
                                _this.m_draw.setCamera(0, 0, pixelsPerMeter_1);
                                var minWorldAABB = new org.jbox2d.common.Vec2(Math.fround(Math.fround(-screenAABBWidth_1 * 0.5) / pixelsPerMeter_1), Math.fround(Math.fround(-screenAABBHeight_1 * 0.5) / pixelsPerMeter_1));
                                var maxWorldAABB = minWorldAABB.mul(-1.0);
                                var doSleep = true;
                                _this.m_world = new org.jbox2d.dynamics.World(new org.jbox2d.collision.AABB(minWorldAABB, maxWorldAABB), _this.m_gravity, doSleep);
                                _this.m_world.setDebugDraw(_this.m_draw);
                                _this.m_world.setDrawDebugData(false);
                                _this.m_settings = new org.jbox2d.testbed.TestSettings();
                                _this.setDensity(0.0);
                                _this.setRestitution(0.1);
                                _this.setFriction(0.4);
                                _this.setBullet(false);
                                _this.setSensor(false);
                                _this.m_border = _this.createHollowBox(Math.fround(screenW * 0.5), Math.fround(screenH * 0.5), borderBoxWidth_1, borderBoxHeight_1, 10.0);
                                parent.registerMethod("draw", _this);
                            })();
                        }
                    }
                    else
                        throw new Error('invalid overload');
                }
                /**
                 * Called automatically by Processing.
                 */
                Physics.prototype.draw = function () {
                    this.m_world.setWarmStarting(this.m_settings.enableWarmStarting);
                    this.m_world.setPositionCorrection(this.m_settings.enablePositionCorrection);
                    this.m_world.setContinuousPhysics(this.m_settings.enableTOI);
                    this.m_world.step(Math.fround(1.0 / this.m_settings.hz), this.m_settings.iterationCount);
                    if (this.m_customRenderingMethod == null) {
                        this.defaultDraw(this.m_world);
                    }
                    else {
                        try {
                            /* invoke */ this.m_customRenderingMethod.fn.apply(this.m_customRenderingObject, [this.m_world]);
                        }
                        catch (e) {
                            console.error("error " + e);
                            console.error(e.message, e);
                            this.m_parent.exit();
                        }
                        ;
                    }
                };
                /**
                 * For advanced users only.
                 * <BR><BR>
                 * Set a custom rendering method to be called.  Use this
                 * if the default renderer is not drawing things the way
                 * you like, or if you need more flexibility.  This
                 * will allow a very modular approach to rendering, whereby
                 * you can change the entire graphical style on the fly by
                 * switching the render function.  Hopefully some people a
                 * lot more graphically skilled than I am will provide some
                 * cool looking functions for this purpose!
                 * <BR><BR>
                 * The method is set through Java's reflection API, so you
                 * may call any method that takes a World object as a parameter.
                 * The usual Java way is to force implementation of an interace,
                 * but this way you can write things in a simpler manner, within
                 * the PDE and without multiple tabs or pure Java.
                 * Just pass the object that has the method along with the name
                 * of the method.
                 * <BR><BR>
                 * e.g. if you have the following method defined in your
                 * sketch:
                 * <pre>
                 * void myDrawMethod(World world) {
                 * // Do a bunch of stuff
                 * }
                 * </pre>
                 * then inside either the draw or setup functions you could write:
                 * <pre>
                 * setCustomRenderingMethod(this, "myDrawMethod");</pre>
                 * to register that function.  Use unsetCustomRenderingMethod() to
                 * go back to the default renderer.
                 * <BR><BR>
                 * If you're interested in writing your own renderer, you'll likely need
                 * to look at the source code, which you can get to from http://www.jbox2d.org.
                 * In particular, the org.jbox2d.dynamics.World file has a drawDebugData()
                 * function, which, after some preprocessing, makes some calls out to
                 * org.jbox2d.testbed.ProcessingDebugDraw to do the actual drawing.  That
                 * should give you a place to start from, at least.
                 * <BR><BR>
                 * Note also that this rendering method has nothing to do with
                 * Java2d vs. P3D vs. OpenGL - that choice is made at the
                 * beginning of your sketch, and this library won't let you change it!
                 * This functionality merely relates to the way bodies and shapes
                 * are translated into drawing calls; the drawing calls themselves
                 * rely on whatever renderer you chose in your size() function.
                 * <BR><BR>
                 * @param {*} object The object in which your method is defined ('this' should work if
                 * the object is defined in a .pde file and not within a class)
                 * @param {string} methodName The name of the method (without the parenthesis) to call
                 */
                Physics.prototype.setCustomRenderingMethod = function (object, methodName) {
                    var c = object.constructor;
                    try {
                        var methodArgs = [org.jbox2d.dynamics.World];
                        var method = (function (c, p) { if (c.prototype.hasOwnProperty(p) && typeof c.prototype[p] == 'function')
                            return { owner: c, name: p, fn: c.prototype[p] };
                        else
                            return null; })(c, methodName);
                        this.m_customRenderingObject = object;
                        this.m_customRenderingMethod = method;
                    }
                    catch (e) {
                        console.error("Could not register " + methodName + "(World) for " + object + ", make sure the method name is spelled correctly and that the method takes a World object as an argument!" + e);
                        console.error(e.message, e);
                    }
                    ;
                };
                /**
                 * Clear any custom rendering method that has been set, and
                 * revert to the default Box2d debug renderer.
                 */
                Physics.prototype.unsetCustomRenderingMethod = function () {
                    this.m_customRenderingMethod = null;
                    this.m_customRenderingObject = null;
                };
                /**
                 * Draws the scene using the default render options.
                 * Automatically called by the engine unless you have
                 * specified your own rendering routine.
                 * @param {org.jbox2d.dynamics.World} world
                 */
                Physics.prototype.defaultDraw = function (world) {
                    this.m_draw.setFlags(0);
                    if (this.m_settings.drawShapes)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_shapeBit);
                    if (this.m_settings.drawJoints)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_jointBit);
                    if (this.m_settings.drawCoreShapes)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_coreShapeBit);
                    if (this.m_settings.drawAABBs)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_aabbBit);
                    if (this.m_settings.drawOBBs)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_obbBit);
                    if (this.m_settings.drawPairs)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_pairBit);
                    if (this.m_settings.drawCOMs)
                        this.m_draw.appendFlags(org.jbox2d.dynamics.DebugDraw.e_centerOfMassBit);
                    world.setDrawDebugData(true);
                    world.drawDebugData();
                    world.setDrawDebugData(false);
                };
                /**
                 * Get an editable copy of the current TestSettings so
                 * that you may change certain aspects of the simulation
                 * and display.  You do not need to re-set anything after
                 * editing these settings, the changes take effect immediately.
                 * <BR><BR>
                 * The list of useful fields in the TestSettings objects follows:
                 * <pre>
                 * public int hz; // "frame" rate of physics simulation - best to leave at 60
                 * public int iterationCount; // number of constraint iterations - set to 10 normally
                 * public boolean enableWarmStarting; // makes constraints work better by reusing last results
                 * public boolean enablePositionCorrection; // leave this on...without it, things turn to mush
                 * public boolean enableTOI; // enable/disable continuous collision detection
                 * public boolean drawShapes;
                 * public boolean drawJoints;
                 * public boolean drawCoreShapes;
                 * public boolean drawOBBs;
                 * public boolean drawCOMs;
                 * public boolean drawImpulses;
                 * public boolean drawAABBs;
                 * public boolean drawPairs;
                 * public boolean drawContactPoints;
                 * public boolean drawContactNormals;
                 * public boolean drawContactForces;
                 * public boolean drawFrictionForces;
                 * </pre>
                 * Note: the drawing settings only affect the default debug renderer.
                 * If you have specified your own renderer, you will have to manually
                 * read off and apply these settings if you wish to use them.
                 * @return {org.jbox2d.testbed.TestSettings} A reference to the active TestSettings object
                 */
                Physics.prototype.getSettings = function () {
                    return this.m_settings;
                };
                /**
                 * Create a hollow box of the given screen dimensions.
                 * @param {number} centerX Center of box x coordinate (in screen coordinates)
                 * @param {number} centerY Center of box y coordinate (in screen coordinates)
                 * @param {number} width Width of box (screen scale)
                 * @param {number} height Height of box (screen scale)
                 * @param {number} thickness Thickness of box edge (screen scale)
                 * @return
                 * @return {Array}
                 */
                Physics.prototype.createHollowBox = function (centerX, centerY, width, height, thickness) {
                    var result = [null, null, null, null];
                    result[0] = this.createRect(Math.fround(Math.fround(centerX - Math.fround(width * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY - Math.fround(height * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerX - Math.fround(width * 0.5)) + Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY + Math.fround(height * 0.5)) + Math.fround(thickness * 0.5)));
                    result[1] = this.createRect(Math.fround(Math.fround(centerX + Math.fround(width * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY - Math.fround(height * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerX + Math.fround(width * 0.5)) + Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY + Math.fround(height * 0.5)) + Math.fround(thickness * 0.5)));
                    result[2] = this.createRect(Math.fround(Math.fround(centerX - Math.fround(width * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY + Math.fround(height * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerX + Math.fround(width * 0.5)) + Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY + Math.fround(height * 0.5)) + Math.fround(thickness * 0.5)));
                    result[3] = this.createRect(Math.fround(Math.fround(centerX - Math.fround(width * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY - Math.fround(height * 0.5)) - Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerX + Math.fround(width * 0.5)) + Math.fround(thickness * 0.5)), Math.fround(Math.fround(centerY - Math.fround(height * 0.5)) + Math.fround(thickness * 0.5)));
                    return result;
                };
                /**
                 * Create a rectangle given by screen coordinates of corners.
                 * @param {number} x0
                 * @param {number} y0
                 * @param {number} x1
                 * @param {number} y1
                 * @return
                 * @return {org.jbox2d.dynamics.Body}
                 */
                Physics.prototype.createRect = function (x0, y0, x1, y1) {
                    var cxs = Math.fround((Math.fround(x0 + x1)) * 0.5);
                    var cys = Math.fround((Math.fround(y0 + y1)) * 0.5);
                    var wxs = org.jbox2d.common.MathUtils.abs(Math.fround(x1 - x0));
                    var wys = org.jbox2d.common.MathUtils.abs(Math.fround(y1 - y0));
                    var center = this.screenToWorld$float$float(cxs, cys);
                    var halfWidthWorld = Math.fround(0.5 * this.screenToWorld$float$org_jbox2d_common_Vec2(wxs, new org.jbox2d.common.Vec2(1, 0)));
                    var halfHeightWorld = Math.fround(0.5 * this.screenToWorld$float$org_jbox2d_common_Vec2(wys, new org.jbox2d.common.Vec2(1, 0)));
                    var pd = new org.jbox2d.collision.shapes.PolygonDef();
                    pd.setAsBox$float$float(halfWidthWorld, halfHeightWorld);
                    this.setShapeDefProperties(pd);
                    var bd = new org.jbox2d.dynamics.BodyDef();
                    this.setBodyDefProperties(bd);
                    var b = this.m_world.createBody(bd);
                    b.createShape(pd);
                    if (this.m_density > 0.0)
                        b.setMassFromShapes();
                    b.setXForm(center, 0.0);
                    return b;
                };
                /**
                 * Create a circle in screen coordinates
                 * @param {number} x
                 * @param {number} y
                 * @param {number} r
                 * @return
                 * @return {org.jbox2d.dynamics.Body}
                 */
                Physics.prototype.createCircle = function (x, y, r) {
                    var center = this.screenToWorld$float$float(x, y);
                    var rad = this.screenToWorld$float$org_jbox2d_common_Vec2(r, new org.jbox2d.common.Vec2(1, 0));
                    var cd = new org.jbox2d.collision.shapes.CircleDef();
                    cd.radius = rad;
                    this.setShapeDefProperties(cd);
                    var bd = new org.jbox2d.dynamics.BodyDef();
                    this.setBodyDefProperties(bd);
                    var b = this.m_world.createBody(bd);
                    b.createShape(cd);
                    if (this.m_density > 0.0)
                        b.setMassFromShapes();
                    b.setXForm(center, 0.0);
                    return b;
                };
                /**
                 * Create a polygon based on vertices.
                 * <BR><BR>
                 * Polygons must be:
                 * <ul>
                 * <li>Ordered clockwise in screen coordinates (which
                 * becomes counterclockwise in world coordinates).
                 * <li>Non self-intersecting.
                 * <li>Convex
                 * </ul>
                 * Failure to adhere to any of these restrictions may cause
                 * simulation crashes or problems.  In particular, if your
                 * objects are showing up as static objects instead of dynamic
                 * ones, and are not colliding correctly, you have probably
                 * not met the clockwise ordering requirement.
                 * <BR><BR>
                 * This can be called with any number of vertices passed as
                 * pairs of interleaved floats, for instance:
                 * <pre>
                 * createPolygon(x0,y0,x1,y1,x2,y2,x3,y3);</pre>
                 * or
                 * <pre>
                 * createPolygon(x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5);</pre>
                 * or
                 * <pre>
                 * float[] xyInterleaved = {x0,y0,x1,y1,x2,y2,x3,y3,x4,y4};
                 * createPolygon(xyInterleaved);</pre>
                 * are all fine.
                 * @param {Array} vertices Any number of pairs of x,y floats, or an array of the same (screen coordinates)
                 * @return
                 * @return {org.jbox2d.dynamics.Body}
                 */
                Physics.prototype.createPolygon = function () {
                    var vertices = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        vertices[_i] = arguments[_i];
                    }
                    if (vertices.length % 2 !== 0)
                        throw Object.defineProperty(new Error("Vertices must be given as pairs of x,y coordinates, but number of passed parameters was odd."), '__classes', { configurable: true, value: ['java.lang.Throwable', 'java.lang.Object', 'java.lang.RuntimeException', 'java.lang.IllegalArgumentException', 'java.lang.Exception'] });
                    var nVertices = (vertices.length / 2 | 0);
                    var pd = new org.jbox2d.collision.shapes.PolygonDef();
                    for (var i = 0; i < nVertices; ++i) {
                        {
                            var v = this.screenToWorld$float$float(vertices[2 * i], vertices[2 * i + 1]);
                            pd.addVertex(v);
                        }
                        ;
                    }
                    this.setShapeDefProperties(pd);
                    var bd = new org.jbox2d.dynamics.BodyDef();
                    this.setBodyDefProperties(bd);
                    var b = this.m_world.createBody(bd);
                    b.createShape(pd);
                    if (this.m_density > 0.0)
                        b.setMassFromShapes();
                    return b;
                };
                /**
                 * Create a distance (stick) joint between two bodies
                 * that holds the specified points at a constant distance.
                 * <BR><BR>
                 * Once the distance joint is created, it may be turned into
                 * a "soft" distance joint by using DistanceJoint::setFrequencyHz(float)
                 * to set the frequency to a non-zero value, and using
                 * DistanceJoint::setDampingRatio(float) to tune the damping constant.
                 * <BR><BR>
                 * Distance joints do not support joint limits or motors.
                 * @param {org.jbox2d.dynamics.Body} a First body
                 * @param {org.jbox2d.dynamics.Body} b Second body
                 * @param {number} xa x component of anchor point on first body (screen coordinates)
                 * @param {number} ya y component of anchor point on first body (screen coordinates)
                 * @param {number} xb x component of anchor point on second body (screen coordinates)
                 * @param {number} yb y component of anchor point on second body (screen coordinates)
                 * @return {org.jbox2d.dynamics.joints.DistanceJoint} Newly created DistanceJoint
                 */
                Physics.prototype.createDistanceJoint = function (a, b, xa, ya, xb, yb) {
                    var va = this.screenToWorld$float$float(xa, ya);
                    var vb = this.screenToWorld$float$float(xb, yb);
                    var jd = new org.jbox2d.dynamics.joints.DistanceJointDef();
                    jd.initialize(a, b, va, vb);
                    return this.m_world.createJoint(jd);
                };
                /**
                 * Create a revolute (pin) joint between the two bodies
                 * at the given position.
                 * <BR><BR>
                 * Joint limits and motors may be set once the joint is created.
                 * @param {org.jbox2d.dynamics.Body} a First body
                 * @param {org.jbox2d.dynamics.Body} b Second body
                 * @param {number} x x coordinate of pin joint location (screen coordinates)
                 * @param {number} y y coordinate of pin joint location (screen coordinates)
                 * @return {org.jbox2d.dynamics.joints.RevoluteJoint} Newly created RevoluteJoint
                 */
                Physics.prototype.createRevoluteJoint = function (a, b, x, y) {
                    var v = this.screenToWorld$float$float(x, y);
                    return org.jbox2d.p5.JointUtils.createRevoluteJoint(a, b, v);
                };
                /**
                 * Create a prismatic (piston) joint between two bodies
                 * that allows movement in the given direction.
                 * <BR><BR>
                 * dirX and dirY can be given in screen coordinates or
                 * world coordinates, scaling does not matter.
                 * <BR><BR>
                 * Joint limits and motors may be set once the joint is created.
                 * @param {org.jbox2d.dynamics.Body} a First body
                 * @param {org.jbox2d.dynamics.Body} b Second body
                 * @param {number} dirX x component of allowed movement direction
                 * @param {number} dirY y component of allowed movement direction
                 * @return {org.jbox2d.dynamics.joints.PrismaticJoint} Newly created PrismaticJoint
                 */
                Physics.prototype.createPrismaticJoint = function (a, b, dirX, dirY) {
                    var dir = new org.jbox2d.common.Vec2(dirX, dirY);
                    dir.normalize();
                    var pjd = new org.jbox2d.dynamics.joints.PrismaticJointDef();
                    pjd.initialize(a, b, (a.getMemberWorldCenter().add(b.getMemberWorldCenter())).mul(0.5), dir);
                    return this.m_world.createJoint(pjd);
                };
                /**
                 * Create a pulley joint between the
                 * The pulley joint is connected to two bodies and two fixed ground points.
                 * The pulley supports a ratio such that:
                 * length1 + ratio * length2 = constant
                 * Yes, the force transmitted is scaled by the ratio.
                 * <BR><BR>
                 * The ground anchors are the points where the "rope" touches the pulley,
                 * and the anchors are the points on the bodies where the rope is attached.
                 * <BR><BR>
                 * Joint limits may be set after the joint is created.
                 * @param {org.jbox2d.dynamics.Body} a First body
                 * @param {org.jbox2d.dynamics.Body} b Second body
                 * @param {number} groundAnchorAx x coordinate of (fixed) ground anchor for body a, in screen coordinates
                 * @param {number} groundAnchorAy y coordinate of (fixed) ground anchor for body a, in screen coordinates
                 * @param {number} groundAnchorBx x coordinate of (fixed) ground anchor for body b, in screen coordinates
                 * @param {number} groundAnchorBy y coordinate of (fixed) ground anchor for body b, in screen coordinates
                 * @param {number} anchorAx x coordinate of body anchor for body a, in screen coordinates
                 * @param {number} anchorAy y coordinate of body anchor for body a, in screen coordinates
                 * @param {number} anchorBx x coordinate of body anchor for body b, in screen coordinates
                 * @param {number} anchorBy y coordinate of body anchor for body b, in screen coordinates
                 * @param {number} ratio "Block and tackle" ratio
                 * @return {org.jbox2d.dynamics.joints.PulleyJoint} Newly created PulleyJoint
                 */
                Physics.prototype.createPulleyJoint = function (a, b, groundAnchorAx, groundAnchorAy, groundAnchorBx, groundAnchorBy, anchorAx, anchorAy, anchorBx, anchorBy, ratio) {
                    var gA = this.screenToWorld$float$float(groundAnchorAx, groundAnchorAy);
                    var gB = this.screenToWorld$float$float(groundAnchorBx, groundAnchorBy);
                    var aA = this.screenToWorld$float$float(anchorAx, anchorAy);
                    var aB = this.screenToWorld$float$float(anchorBx, anchorBy);
                    var pjd = new org.jbox2d.dynamics.joints.PulleyJointDef();
                    pjd.initialize(a, b, gA, gB, aA, aB, ratio);
                    return this.m_world.createJoint(pjd);
                };
                /**
                 * Create a gear joint, which binds together two existing
                 * revolute or prismatic joints (any combination will work).
                 * The provided joints must attach a dynamic body to a static body.
                 * <BR><BR>
                 * A gear joint is used to connect two joints together. Either joint
                 * can be a revolute or prismatic joint. You specify a gear ratio
                 * to bind the motions together:
                 * coordinate1 + ratio * coordinate2 = constant
                 * The ratio can be negative or positive. If one joint is a revolute joint
                 * and the other joint is a prismatic joint, then the ratio will have units
                 * of length or units of 1/length.
                 * <BR><em>Warning</em>: The revolute and prismatic joints must be attached to
                 * fixed bodies (which must be body1 on those joints).
                 * @param {org.jbox2d.dynamics.joints.Joint} pj1 First joint (revolute or prismatic)
                 * @param {org.jbox2d.dynamics.joints.Joint} pj2 Second joint (revolute or prismatic)
                 * @param {number} ratio Gear ratio
                 * @return {org.jbox2d.dynamics.joints.GearJoint} Newly created GearJoint
                 */
                Physics.prototype.createGearJoint = function (pj1, pj2, ratio) {
                    if (!(pj1.getType() === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT || pj1.getType() === org.jbox2d.dynamics.joints.JointType.PRISMATIC_JOINT)) {
                        throw Object.defineProperty(new Error("Gear joints can only be created between combinations of revolute and prismatic joints."), '__classes', { configurable: true, value: ['java.lang.Throwable', 'java.lang.Object', 'java.lang.RuntimeException', 'java.lang.IllegalArgumentException', 'java.lang.Exception'] });
                    }
                    else if (!(pj1.getType() === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT || pj1.getType() === org.jbox2d.dynamics.joints.JointType.PRISMATIC_JOINT)) {
                        throw Object.defineProperty(new Error("Gear joints can only be created between combinations of revolute and prismatic joints."), '__classes', { configurable: true, value: ['java.lang.Throwable', 'java.lang.Object', 'java.lang.RuntimeException', 'java.lang.IllegalArgumentException', 'java.lang.Exception'] });
                    }
                    var gjd = new org.jbox2d.dynamics.joints.GearJointDef();
                    gjd.joint1 = pj1;
                    gjd.joint2 = pj2;
                    gjd.ratio = ratio;
                    return this.m_world.createJoint(gjd);
                };
                /**
                 * Sets the body def properties based on the current state
                 * of the physics handler.
                 *
                 * @param {org.jbox2d.dynamics.BodyDef} bd
                 * @private
                 */
                /*private*/ Physics.prototype.setBodyDefProperties = function (bd) {
                    bd.isBullet = this.m_bullet;
                };
                /**
                 * Sets the shape def properties based on the current state
                 * of the physics handler.
                 *
                 * @param {org.jbox2d.collision.shapes.ShapeDef} sd Shape def to set
                 * @private
                 */
                /*private*/ Physics.prototype.setShapeDefProperties = function (sd) {
                    sd.density = this.m_density;
                    sd.friction = this.m_friction;
                    sd.restitution = this.m_restitution;
                    sd.isSensor = this.m_sensor;
                };
                /**
                 * Set the density used for newly created shapes.
                 * @param {number} d
                 */
                Physics.prototype.setDensity = function (d) {
                    this.m_density = d;
                };
                /**
                 * Get the density being used for newly created shapes.
                 * @return
                 * @return {number}
                 */
                Physics.prototype.getDensity = function () {
                    return this.m_density;
                };
                /**
                 * Set the restitution used for newly created shapes.
                 * @param {number} r
                 */
                Physics.prototype.setRestitution = function (r) {
                    this.m_restitution = r;
                };
                /**
                 * Get the restitution being used for newly created shapes.
                 * @return
                 * @return {number}
                 */
                Physics.prototype.getRestitution = function () {
                    return this.m_restitution;
                };
                /**
                 * Set the friction used for newly created shapes.
                 * @param {number} f
                 */
                Physics.prototype.setFriction = function (f) {
                    this.m_friction = f;
                };
                /**
                 * Get the friction being used for newly created shapes.
                 * @return
                 * @return {number}
                 */
                Physics.prototype.getFriction = function () {
                    return this.m_friction;
                };
                /**
                 * Get the viewport transform, which transforms (moves, scales, and rotates)
                 * the world to show us what we see in our window.
                 * @return
                 * @return {*}
                 */
                Physics.prototype.getViewportTransform = function () {
                    return this.m_draw.getViewportTranform();
                };
                /**
                 * Set to true to create new bodies as "bullets,"
                 * which use (slower) continuous collision detection
                 * against other moving bodies.
                 * <BR><BR>
                 * <em>Warning:</em> continuous collision detection between
                 * moving bodies is slow, and should be used sparingly.  All
                 * bodies use continuous collision detection against static
                 * scenery, so for most purposes your bodies should not be
                 * marked as bullets.
                 * @param {boolean} bullet
                 */
                Physics.prototype.setBullet = function (bullet) {
                    this.m_bullet = bullet;
                };
                /**
                 * Are newly created bodies being created as bullets?
                 * @return {boolean}
                 */
                Physics.prototype.getBullet = function () {
                    return this.m_bullet;
                };
                /**
                 * Set to true to create new shapes as sensors.  Sensors
                 * do not respond to collisions physically, but they
                 * generate contact events.  This can be useful if you
                 * need to check whether a body is in a certain geometrical
                 * area.
                 * @param {boolean} sensor
                 */
                Physics.prototype.setSensor = function (sensor) {
                    this.m_sensor = sensor;
                };
                /**
                 * Are newly created shapes being created as sensors?
                 * @return {boolean}
                 */
                Physics.prototype.getSensor = function () {
                    return this.m_sensor;
                };
                /**
                 * Destroy this world, unregistering it from the PApplet.
                 * If this is not called, the world will still be active
                 * and simulating, as upon creation it is registered with
                 * the PApplet's draw events.
                 */
                Physics.prototype.destroy = function () {
                    this.m_parent.unregisterMethod("draw", this);
                };
                /**
                 * Get the current physics world.
                 * <BR><BR>
                 * <em>Warning:</em> anything involving a World object directly
                 * is not strictly supported as part of this Processing library.
                 * It <em>is</em> supported as part of JBox2d, however, so there
                 * is quite a bit you can do, and you can always ask for help if
                 * you run into trouble.  Note that all coordinates and vectors
                 * in JBox2d proper are in world coordinates, not screen coordinates,
                 * so you will likely need to use the screenToWorld and worldToScreen
                 * functions to convert back and forth as necessary.
                 * @return {org.jbox2d.dynamics.World} The active physics world
                 */
                Physics.prototype.getWorld = function () {
                    return this.m_world;
                };
                /**
                 *
                 * Get the border Body[] array, or null
                 * if the border has been removed.
                 * @return {Array}
                 */
                Physics.prototype.getBorder = function () {
                    return this.m_border;
                };
                /**
                 * Remove the solid border if it exists.
                 */
                Physics.prototype.removeBorder = function () {
                    if (this.m_border == null)
                        return;
                    for (var i = 0; i < this.m_border.length; ++i) {
                        {
                            this.removeBody(this.m_border[i]);
                        }
                        ;
                    }
                    this.m_border = null;
                };
                /**
                 * Remove a body from the world.
                 * @param {org.jbox2d.dynamics.Body} b
                 */
                Physics.prototype.removeBody = function (b) {
                    this.m_world.destroyBody(b);
                };
                /**
                 * Remove a joint from the world.
                 * @param {org.jbox2d.dynamics.joints.Joint} j
                 */
                Physics.prototype.removeJoint = function (j) {
                    this.m_world.destroyJoint(j);
                };
                Physics.prototype.applyForce$org_jbox2d_dynamics_Body$float$float = function (b, fx, fy) {
                    var fv = this.screenToWorldVector$float$float(fx, fy);
                    b.applyForce(fv, b.getMemberWorldCenter());
                };
                Physics.prototype.applyForce$org_jbox2d_dynamics_Body$org_jbox2d_common_Vec2 = function (b, f) {
                    b.applyForce(this.screenToWorldVector$org_jbox2d_common_Vec2(f), b.getMemberWorldCenter());
                };
                Physics.prototype.applyForce$org_jbox2d_dynamics_Body$float$float$float$float = function (b, fx, fy, pointX, pointY) {
                    var fv = this.screenToWorldVector$float$float(fx, fy);
                    var point = this.screenToWorld$float$float(pointX, pointY);
                    b.applyForce(fv, point);
                };
                /**
                 * Apply a force to a body at a point.
                 * @param {org.jbox2d.dynamics.Body} b Body you wish to apply force to
                 * @param {number} fx x component of force (in pixel units)
                 * @param {number} fy y component of force (in pixel units)
                 * @param {number} pointX x coordinate of application point (in screen/pixel coordinates)
                 * @param {number} pointY y coordinate of application point (in screen/pixel coordinates)
                 */
                Physics.prototype.applyForce = function (b, fx, fy, pointX, pointY) {
                    if (((b != null && b instanceof org.jbox2d.dynamics.Body) || b === null) && ((typeof fx === 'number') || fx === null) && ((typeof fy === 'number') || fy === null) && ((typeof pointX === 'number') || pointX === null) && ((typeof pointY === 'number') || pointY === null)) {
                        return this.applyForce$org_jbox2d_dynamics_Body$float$float$float$float(b, fx, fy, pointX, pointY);
                    }
                    else if (((b != null && b instanceof org.jbox2d.dynamics.Body) || b === null) && ((fx != null && fx instanceof org.jbox2d.common.Vec2) || fx === null) && ((fy != null && fy instanceof org.jbox2d.common.Vec2) || fy === null) && pointX === undefined && pointY === undefined) {
                        return this.applyForce$org_jbox2d_dynamics_Body$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b, fx, fy);
                    }
                    else if (((b != null && b instanceof org.jbox2d.dynamics.Body) || b === null) && ((typeof fx === 'number') || fx === null) && ((typeof fy === 'number') || fy === null) && pointX === undefined && pointY === undefined) {
                        return this.applyForce$org_jbox2d_dynamics_Body$float$float(b, fx, fy);
                    }
                    else if (((b != null && b instanceof org.jbox2d.dynamics.Body) || b === null) && ((fx != null && fx instanceof org.jbox2d.common.Vec2) || fx === null) && fy === undefined && pointX === undefined && pointY === undefined) {
                        return this.applyForce$org_jbox2d_dynamics_Body$org_jbox2d_common_Vec2(b, fx);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Physics.prototype.applyForce$org_jbox2d_dynamics_Body$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (b, f, point) {
                    b.applyForce(this.screenToWorldVector$org_jbox2d_common_Vec2(f), this.screenToWorld$org_jbox2d_common_Vec2(point));
                };
                /**
                 *
                 * Get the location of the body's origin (screen coordinates) -
                 * note that this does <em>not</em> usually correspond to the
                 * center of mass position, which may be obtained by calling
                 * {@link #getCMPosition(Body)}.
                 * @param {org.jbox2d.dynamics.Body} b
                 * @return
                 * @return {org.jbox2d.common.Vec2}
                 */
                Physics.prototype.getPosition = function (b) {
                    return this.worldToScreen$org_jbox2d_common_Vec2(b.getMemberPosition());
                };
                /**
                 * Get the center of mass position (screen coordinates)
                 * @param {org.jbox2d.dynamics.Body} b
                 * @return {org.jbox2d.common.Vec2}
                 */
                Physics.prototype.getCMPosition = function (b) {
                    return this.worldToScreen$org_jbox2d_common_Vec2(b.getMemberWorldCenter());
                };
                /**
                 * Get the angle (in radians)
                 * @param {org.jbox2d.dynamics.Body} b
                 * @return {number}
                 */
                Physics.prototype.getAngle = function (b) {
                    return b.getAngle();
                };
                /**
                 * Screen space to world space conversion for position.
                 * @param {number} x
                 * @param {number} y
                 * @return {number}
                 */
                Physics.prototype.screenToWorldX = function (x, y) {
                    return this.m_draw.getScreenToWorld$float$float(x, y).x;
                };
                /**
                 * Screen space to world space conversion for position.
                 * @param {number} x
                 * @param {number} y
                 * @return {number}
                 */
                Physics.prototype.screenToWorldY = function (x, y) {
                    return this.m_draw.getScreenToWorld$float$float(x, y).y;
                };
                Physics.prototype.screenToWorld$float$float = function (x, y) {
                    return this.m_draw.getScreenToWorld$float$float(x, y);
                };
                Physics.prototype.screenToWorld$org_jbox2d_common_Vec2 = function (v) {
                    return this.m_draw.getScreenToWorld$org_jbox2d_common_Vec2(v);
                };
                Physics.prototype.screenToWorld$float$org_jbox2d_common_Vec2 = function (length, vector) {
                    var ret = new org.jbox2d.common.Vec2(vector);
                    ret.normalize();
                    ret.mulLocal(length);
                    this.m_draw.getViewportTranform().vectorInverseTransform(ret, ret);
                    return ret.length();
                };
                /**
                 * Screen length to world length, on the given vector direction
                 * @param {number} length
                 * @param {org.jbox2d.common.Vec2} vector
                 * @return {number}
                 */
                Physics.prototype.screenToWorld = function (length, vector) {
                    if (((typeof length === 'number') || length === null) && ((vector != null && vector instanceof org.jbox2d.common.Vec2) || vector === null)) {
                        return this.screenToWorld$float$org_jbox2d_common_Vec2(length, vector);
                    }
                    else if (((typeof length === 'number') || length === null) && ((typeof vector === 'number') || vector === null)) {
                        return this.screenToWorld$float$float(length, vector);
                    }
                    else if (((length != null && length instanceof org.jbox2d.common.Vec2) || length === null) && vector === undefined) {
                        return this.screenToWorld$org_jbox2d_common_Vec2(length);
                    }
                    else
                        throw new Error('invalid overload');
                };
                /**
                 * World space to screen space conversion for position.
                 * @param {number} x
                 * @param {number} y
                 * @return {number}
                 */
                Physics.prototype.worldToScreenX = function (x, y) {
                    return this.m_draw.getWorldToScreen$float$float(x, y).x;
                };
                /**
                 * World space to screen space conversion for position.
                 * @param {number} x
                 * @param {number} y
                 * @return {number}
                 */
                Physics.prototype.worldToScreenY = function (x, y) {
                    return this.m_draw.getWorldToScreen$float$float(x, y).y;
                };
                Physics.prototype.worldToScreen$float$float = function (x, y) {
                    return this.m_draw.getWorldToScreen$float$float(x, y);
                };
                Physics.prototype.worldToScreen$org_jbox2d_common_Vec2 = function (v) {
                    return this.m_draw.getWorldToScreen$org_jbox2d_common_Vec2(v);
                };
                Physics.prototype.worldToScreen$float$org_jbox2d_common_Vec2 = function (length, vector) {
                    var ret = new org.jbox2d.common.Vec2(vector);
                    ret.normalize();
                    ret.mulLocal(length);
                    this.m_draw.getViewportTranform().vectorTransform(ret, ret);
                    return ret.length();
                };
                /**
                 * World length to screen length, on the given vector direction
                 * @param {number} length
                 * @param {org.jbox2d.common.Vec2} vector
                 * @return {number}
                 */
                Physics.prototype.worldToScreen = function (length, vector) {
                    if (((typeof length === 'number') || length === null) && ((vector != null && vector instanceof org.jbox2d.common.Vec2) || vector === null)) {
                        return this.worldToScreen$float$org_jbox2d_common_Vec2(length, vector);
                    }
                    else if (((typeof length === 'number') || length === null) && ((typeof vector === 'number') || vector === null)) {
                        return this.worldToScreen$float$float(length, vector);
                    }
                    else if (((length != null && length instanceof org.jbox2d.common.Vec2) || length === null) && vector === undefined) {
                        return this.worldToScreen$org_jbox2d_common_Vec2(length);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Physics.prototype.screenToWorldVector$org_jbox2d_common_Vec2 = function (screenV) {
                    var ret = new org.jbox2d.common.Vec2();
                    this.m_draw.getViewportTranform().vectorInverseTransform(screenV, ret);
                    if (this.m_draw.getViewportTranform().isYFlip()) {
                        ret.y *= -1;
                    }
                    return ret;
                };
                Physics.prototype.screenToWorldVector$float$float = function (sx, sy) {
                    var ret = new org.jbox2d.common.Vec2(sx, sy);
                    this.m_draw.getViewportTranform().vectorInverseTransform(ret, ret);
                    if (this.m_draw.getViewportTranform().isYFlip()) {
                        ret.y *= -1;
                    }
                    return ret;
                };
                Physics.prototype.screenToWorldVector = function (sx, sy) {
                    if (((typeof sx === 'number') || sx === null) && ((typeof sy === 'number') || sy === null)) {
                        return this.screenToWorldVector$float$float(sx, sy);
                    }
                    else if (((sx != null && sx instanceof org.jbox2d.common.Vec2) || sx === null) && sy === undefined) {
                        return this.screenToWorldVector$org_jbox2d_common_Vec2(sx);
                    }
                    else
                        throw new Error('invalid overload');
                };
                Physics.prototype.worldToScreenVector$org_jbox2d_common_Vec2 = function (worldV) {
                    var ret = new org.jbox2d.common.Vec2();
                    this.m_draw.getViewportTranform().vectorTransform(worldV, ret);
                    if (this.m_draw.getViewportTranform().isYFlip()) {
                        ret.y *= -1;
                    }
                    return ret;
                };
                Physics.prototype.worldToScreenVector$float$float = function (wx, wy) {
                    var ret = new org.jbox2d.common.Vec2(wx, wy);
                    this.m_draw.getViewportTranform().vectorTransform(ret, ret);
                    if (this.m_draw.getViewportTranform().isYFlip()) {
                        ret.y *= -1;
                    }
                    return ret;
                };
                Physics.prototype.worldToScreenVector = function (wx, wy) {
                    if (((typeof wx === 'number') || wx === null) && ((typeof wy === 'number') || wy === null)) {
                        return this.worldToScreenVector$float$float(wx, wy);
                    }
                    else if (((wx != null && wx instanceof org.jbox2d.common.Vec2) || wx === null) && wy === undefined) {
                        return this.worldToScreenVector$org_jbox2d_common_Vec2(wx);
                    }
                    else
                        throw new Error('invalid overload');
                };
                return Physics;
            }());
            p5.Physics = Physics;
            Physics["__class"] = "org.jbox2d.p5.Physics";
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            var PhysicsUtils = (function () {
                function PhysicsUtils() {
                }
                /**
                 * In case you want to do something to a body during each creation (such as add an Actor object),
                 * you can override the PhysicsUtils class and override this method.
                 * @return
                 * @return {org.jbox2d.dynamics.BodyDef}
                 */
                PhysicsUtils.newBodyDef = function () {
                    var bd = new org.jbox2d.dynamics.BodyDef();
                    return bd;
                };
                PhysicsUtils.angle$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (a, b) {
                    var theta = Math.fround((Math.atan2(b.y, b.x) - Math.atan2(a.y, a.x)));
                    return theta;
                };
                /**
                 * Returns the clockwise angle from vector A to vector B.
                 * @param {org.jbox2d.common.Vec2} a
                 * @param {org.jbox2d.common.Vec2} b
                 * @return
                 * @return {number}
                 */
                PhysicsUtils.angle = function (a, b) {
                    if (((a != null && a instanceof org.jbox2d.common.Vec2) || a === null) && ((b != null && b instanceof org.jbox2d.common.Vec2) || b === null)) {
                        return org.jbox2d.p5.PhysicsUtils.angle$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(a, b);
                    }
                    else if (((a != null && a instanceof org.jbox2d.common.Vec2) || a === null) && b === undefined) {
                        return org.jbox2d.p5.PhysicsUtils.angle$org_jbox2d_common_Vec2(a);
                    }
                    else
                        throw new Error('invalid overload');
                };
                PhysicsUtils.angle$org_jbox2d_common_Vec2 = function (a) {
                    return PhysicsUtils.angle$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(new org.jbox2d.common.Vec2(1, 0), a);
                };
                return PhysicsUtils;
            }());
            p5.PhysicsUtils = PhysicsUtils;
            PhysicsUtils["__class"] = "org.jbox2d.p5.PhysicsUtils";
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var p5;
        (function (p5) {
            /**
             * A general class for holding static methods that do things with or to
             * polygons. Things like convex decomposition, polygon merging, &etc...
             *
             * @author Greg
             *
             * @class
             */
            var PolygonUtils = (function () {
                function PolygonUtils() {
                }
                return PolygonUtils;
            }());
            p5.PolygonUtils = PolygonUtils;
            PolygonUtils["__class"] = "org.jbox2d.p5.PolygonUtils";
        })(p5 = jbox2d.p5 || (jbox2d.p5 = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var arrays;
            (function (arrays) {
                var DynamicTLArray = (function () {
                    function DynamicTLArray() {
                        /*private*/ this.tlMap = ((function () { var __o = new DynamicTLArray.TLHashMap(); __o.__delegate = new DynamicTLArray.TLHashMap(); return __o; })());
                    }
                    DynamicTLArray.prototype.get = function (argLength) {
                        if (!((argLength > 0)))
                            throw new Error("Assertion error line 6: assert (argLength > 0);");
                        ;
                        var map = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(this.tlMap);
                        if (!(function (m, k) { if (m.entries == null)
                            m.entries = []; for (var i = 0; i < m.entries.length; i++)
                            if (m.entries[i].key.equals != null && m.entries[i].key.equals(k) || m.entries[i].key === k) {
                                return true;
                            } return false; })(map, argLength)) {
                            /* put */ (function (m, k, v) { if (m.entries == null)
                                m.entries = []; for (var i = 0; i < m.entries.length; i++)
                                if (m.entries[i].key.equals != null && m.entries[i].key.equals(k) || m.entries[i].key === k) {
                                    m.entries[i].value = v;
                                    return;
                                } m.entries.push({ key: k, value: v, getKey: function () { return this.key; }, getValue: function () { return this.value; } }); })(map, argLength, this.getInitializedArray(argLength));
                        }
                        if (!(((function (m, k) { if (m.entries == null)
                            m.entries = []; for (var i = 0; i < m.entries.length; i++)
                            if (m.entries[i].key.equals != null && m.entries[i].key.equals(k) || m.entries[i].key === k) {
                                return m.entries[i].value;
                            } return null; })(map, argLength).length === argLength)))
                            throw new Error("Assertion error line 11: assert (map.get(argLength).length == argLength) : 'Array not built of correct length';");
                        ;
                        return (function (m, k) { if (m.entries == null)
                            m.entries = []; for (var i = 0; i < m.entries.length; i++)
                            if (m.entries[i].key.equals != null && m.entries[i].key.equals(k) || m.entries[i].key === k) {
                                return m.entries[i].value;
                            } return null; })(map, argLength);
                    };
                    DynamicTLArray.prototype.recycle = function (argArray) {
                    };
                    return DynamicTLArray;
                }());
                arrays.DynamicTLArray = DynamicTLArray;
                DynamicTLArray["__class"] = "org.jbox2d.pooling.arrays.DynamicTLArray";
                (function (DynamicTLArray) {
                    var TLHashMap = (function () {
                        function TLHashMap() {
                        }
                        TLHashMap.prototype.initialValue = function () {
                            return ({});
                        };
                        return TLHashMap;
                    }());
                    DynamicTLArray.TLHashMap = TLHashMap;
                    TLHashMap["__class"] = "org.jbox2d.pooling.arrays.DynamicTLArray.TLHashMap";
                })(DynamicTLArray = arrays.DynamicTLArray || (arrays.DynamicTLArray = {}));
            })(arrays = pooling.arrays || (pooling.arrays = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var SingletonPool = (function () {
                function SingletonPool() {
                }
                SingletonPool.pool_$LI$ = function () { if (SingletonPool.pool == null)
                    SingletonPool.pool = (function () { var __o = new SingletonPool.Pool(); __o.__delegate = new SingletonPool.Pool(); return __o; })(); return SingletonPool.pool; };
                ;
                SingletonPool.getCollideCircle = function () {
                    return (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(SingletonPool.pool_$LI$()).collideCircle;
                };
                SingletonPool.getCollidePoly = function () {
                    return (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(SingletonPool.pool_$LI$()).collidePoly;
                };
                SingletonPool.getDistance = function () {
                    return (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(SingletonPool.pool_$LI$()).distance;
                };
                return SingletonPool;
            }());
            pooling.SingletonPool = SingletonPool;
            SingletonPool["__class"] = "org.jbox2d.pooling.SingletonPool";
            (function (SingletonPool) {
                var Singletons = (function () {
                    function Singletons() {
                        this.collideCircle = new org.jbox2d.collision.shapes.CollideCircle();
                        this.collidePoly = new org.jbox2d.collision.shapes.CollidePoly();
                        this.distance = new org.jbox2d.collision.Distance();
                    }
                    return Singletons;
                }());
                SingletonPool.Singletons = Singletons;
                Singletons["__class"] = "org.jbox2d.pooling.SingletonPool.Singletons";
                var Pool = (function () {
                    function Pool() {
                    }
                    Pool.prototype.initialValue = function () {
                        return new SingletonPool.Singletons();
                    };
                    return Pool;
                }());
                SingletonPool.Pool = Pool;
                Pool["__class"] = "org.jbox2d.pooling.SingletonPool.Pool";
            })(SingletonPool = pooling.SingletonPool || (pooling.SingletonPool = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var stacks;
            (function (stacks) {
                var DynamicTLStack = (function () {
                    function DynamicTLStack() {
                        /*private*/ this.tlStack = ((function () { var __o = new org.jbox2d.pooling.TLStack(); __o.__delegate = new org.jbox2d.pooling.TLStack(); return __o; })());
                    }
                    DynamicTLStack.prototype.get = function () {
                        var stack = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(this.tlStack);
                        if ((stack.length == 0)) {
                            /* push */ (stack.push(this.newObjectInstance()) > 0);
                            /* push */ (stack.push(this.newObjectInstance()) > 0);
                            /* push */ (stack.push(this.newObjectInstance()) > 0);
                        }
                        return stack.pop();
                    };
                    DynamicTLStack.prototype.recycle = function (argObject) {
                        /* push */ ((function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(this.tlStack).push(argObject) > 0);
                    };
                    return DynamicTLStack;
                }());
                stacks.DynamicTLStack = DynamicTLStack;
                DynamicTLStack["__class"] = "org.jbox2d.pooling.stacks.DynamicTLStack";
            })(stacks = pooling.stacks || (pooling.stacks = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLAABB = (function () {
                function TLAABB() {
                }
                TLAABB.prototype.initialValue = function () {
                    return new org.jbox2d.collision.AABB();
                };
                return TLAABB;
            }());
            pooling.TLAABB = TLAABB;
            TLAABB["__class"] = "org.jbox2d.pooling.TLAABB";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLBoundValues = (function () {
                function TLBoundValues() {
                }
                TLBoundValues.prototype.initialValue = function () {
                    return new org.jbox2d.collision.BoundValues();
                };
                return TLBoundValues;
            }());
            pooling.TLBoundValues = TLBoundValues;
            TLBoundValues["__class"] = "org.jbox2d.pooling.TLBoundValues";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLContactPoint = (function () {
                function TLContactPoint() {
                }
                TLContactPoint.prototype.initialValue = function () {
                    return new org.jbox2d.dynamics.contacts.ContactPoint();
                };
                return TLContactPoint;
            }());
            pooling.TLContactPoint = TLContactPoint;
            TLContactPoint["__class"] = "org.jbox2d.pooling.TLContactPoint";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLContactSolver = (function () {
                function TLContactSolver() {
                }
                TLContactSolver.prototype.initialValue = function () {
                    return new org.jbox2d.dynamics.contacts.ContactSolver();
                };
                return TLContactSolver;
            }());
            pooling.TLContactSolver = TLContactSolver;
            TLContactSolver["__class"] = "org.jbox2d.pooling.TLContactSolver";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLManifold = (function () {
                function TLManifold() {
                }
                TLManifold.prototype.initialValue = function () {
                    return new org.jbox2d.collision.Manifold();
                };
                return TLManifold;
            }());
            pooling.TLManifold = TLManifold;
            TLManifold["__class"] = "org.jbox2d.pooling.TLManifold";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLMassData = (function () {
                function TLMassData() {
                }
                TLMassData.prototype.initialValue = function () {
                    return new org.jbox2d.collision.MassData();
                };
                return TLMassData;
            }());
            pooling.TLMassData = TLMassData;
            TLMassData["__class"] = "org.jbox2d.pooling.TLMassData";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLMat22 = (function () {
                function TLMat22() {
                }
                TLMat22.prototype.initialValue = function () {
                    return new org.jbox2d.common.Mat22();
                };
                return TLMat22;
            }());
            pooling.TLMat22 = TLMat22;
            TLMat22["__class"] = "org.jbox2d.pooling.TLMat22";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLStack = (function () {
                function TLStack() {
                }
                TLStack.prototype.initialValue = function () {
                    return ([]);
                };
                return TLStack;
            }());
            pooling.TLStack = TLStack;
            TLStack["__class"] = "org.jbox2d.pooling.TLStack";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLTimeStep = (function () {
                function TLTimeStep() {
                }
                /**
                 *
                 * @return {org.jbox2d.dynamics.TimeStep}
                 */
                TLTimeStep.prototype.initialValue = function () {
                    return new org.jbox2d.dynamics.TimeStep();
                };
                return TLTimeStep;
            }());
            pooling.TLTimeStep = TLTimeStep;
            TLTimeStep["__class"] = "org.jbox2d.pooling.TLTimeStep";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLVec2 = (function () {
                function TLVec2() {
                }
                TLVec2.prototype.initialValue = function () {
                    return new org.jbox2d.common.Vec2();
                };
                return TLVec2;
            }());
            pooling.TLVec2 = TLVec2;
            TLVec2["__class"] = "org.jbox2d.pooling.TLVec2";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var TLXForm = (function () {
                function TLXForm() {
                }
                TLXForm.prototype.initialValue = function () {
                    return new org.jbox2d.common.XForm();
                };
                return TLXForm;
            }());
            pooling.TLXForm = TLXForm;
            TLXForm["__class"] = "org.jbox2d.pooling.TLXForm";
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var testbed;
        (function (testbed) {
            /**
             * Holder for storing contact information.
             * @class
             */
            var ExampleContactPoint = (function () {
                function ExampleContactPoint() {
                    this.normal = new org.jbox2d.common.Vec2();
                    this.position = new org.jbox2d.common.Vec2();
                    this.velocity = new org.jbox2d.common.Vec2();
                    this.id = new org.jbox2d.collision.ContactID();
                    if (this.shape1 === undefined)
                        this.shape1 = null;
                    if (this.shape2 === undefined)
                        this.shape2 = null;
                    if (this.state === undefined)
                        this.state = 0;
                }
                return ExampleContactPoint;
            }());
            testbed.ExampleContactPoint = ExampleContactPoint;
            ExampleContactPoint["__class"] = "org.jbox2d.testbed.ExampleContactPoint";
        })(testbed = jbox2d.testbed || (jbox2d.testbed = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var testbed;
        (function (testbed) {
            var mathtests;
            (function (mathtests) {
                var SinCosTable = (function () {
                    function SinCosTable(argPrecision) {
                        if (this.precision === undefined)
                            this.precision = 0;
                        if (this.tableLength === undefined)
                            this.tableLength = 0;
                        if (this.sinLUT === undefined)
                            this.sinLUT = null;
                        this.precision = argPrecision;
                        this.tableLength = (Math.ceil(Math.fround(SinCosTable.TWOPI_$LI$() / this.precision)) | 0);
                        this.sinLUT = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(this.tableLength);
                        for (var i = 0; i < this.tableLength; i++) {
                            {
                                this.sinLUT[i] = Math.fround(Math.sin(Math.fround(i * this.precision)));
                            }
                            ;
                        }
                    }
                    SinCosTable.TWOPI_$LI$ = function () { if (SinCosTable.TWOPI == null)
                        SinCosTable.TWOPI = Math.fround((Math.PI * 2)); return SinCosTable.TWOPI; };
                    ;
                    SinCosTable.prototype.sin = function (x) {
                        x %= SinCosTable.TWOPI_$LI$();
                        if (SinCosTable.LERP_LOOKUP) {
                            x /= this.precision;
                            var index = (x | 0);
                            if (index !== 0) {
                                x %= index;
                            }
                            if (index === this.tableLength - 1) {
                                return (Math.fround(Math.fround((Math.fround(1 - x)) * this.sinLUT[index]) + Math.fround(x * this.sinLUT[0])));
                            }
                            else {
                                return (Math.fround(Math.fround((Math.fround(1 - x)) * this.sinLUT[index]) + Math.fround(x * this.sinLUT[index + 1])));
                            }
                        }
                        else {
                            return this.sinLUT[org.jbox2d.common.MathUtils.round(Math.fround(x / this.precision)) % this.tableLength];
                        }
                    };
                    return SinCosTable;
                }());
                SinCosTable.LERP_LOOKUP = true;
                mathtests.SinCosTable = SinCosTable;
                SinCosTable["__class"] = "org.jbox2d.testbed.mathtests.SinCosTable";
            })(mathtests = testbed.mathtests || (testbed.mathtests = {}));
        })(testbed = jbox2d.testbed || (jbox2d.testbed = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var testbed;
        (function (testbed) {
            /**
             * Settings for the current test.  Mostly self-explanatory.
             * <BR><BR>
             * The settings from here are applied during AbstractExample::step().
             * @class
             */
            var TestSettings = (function () {
                function TestSettings() {
                    if (this.hz === undefined)
                        this.hz = 0;
                    if (this.iterationCount === undefined)
                        this.iterationCount = 0;
                    if (this.enableWarmStarting === undefined)
                        this.enableWarmStarting = false;
                    if (this.enablePositionCorrection === undefined)
                        this.enablePositionCorrection = false;
                    if (this.enableTOI === undefined)
                        this.enableTOI = false;
                    if (this.pause === undefined)
                        this.pause = false;
                    if (this.singleStep === undefined)
                        this.singleStep = false;
                    if (this.drawShapes === undefined)
                        this.drawShapes = false;
                    if (this.drawJoints === undefined)
                        this.drawJoints = false;
                    if (this.drawCoreShapes === undefined)
                        this.drawCoreShapes = false;
                    if (this.drawOBBs === undefined)
                        this.drawOBBs = false;
                    if (this.drawCOMs === undefined)
                        this.drawCOMs = false;
                    if (this.drawStats === undefined)
                        this.drawStats = false;
                    if (this.drawImpulses === undefined)
                        this.drawImpulses = false;
                    if (this.drawAABBs === undefined)
                        this.drawAABBs = false;
                    if (this.drawPairs === undefined)
                        this.drawPairs = false;
                    if (this.drawContactPoints === undefined)
                        this.drawContactPoints = false;
                    if (this.drawContactNormals === undefined)
                        this.drawContactNormals = false;
                    if (this.drawContactForces === undefined)
                        this.drawContactForces = false;
                    if (this.drawFrictionForces === undefined)
                        this.drawFrictionForces = false;
                    if (this.drawControllers === undefined)
                        this.drawControllers = false;
                    this.hz = 60;
                    this.iterationCount = 10;
                    this.drawStats = true;
                    this.drawAABBs = false;
                    this.drawPairs = false;
                    this.drawShapes = true;
                    this.drawJoints = true;
                    this.drawCoreShapes = false;
                    this.drawContactPoints = false;
                    this.drawContactNormals = false;
                    this.drawContactForces = false;
                    this.drawFrictionForces = false;
                    this.drawOBBs = false;
                    this.drawCOMs = false;
                    this.enableWarmStarting = true;
                    this.enablePositionCorrection = true;
                    this.enableTOI = true;
                    this.drawControllers = true;
                    this.pause = false;
                    this.singleStep = false;
                }
                return TestSettings;
            }());
            testbed.TestSettings = TestSettings;
            TestSettings["__class"] = "org.jbox2d.testbed.TestSettings";
        })(testbed = jbox2d.testbed || (jbox2d.testbed = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var testbed;
        (function (testbed) {
            var timingTests;
            (function (timingTests) {
                /**
                 * Benchmark - piston example (constantly bumping a bunch of
                 * circles and boxes).  Should be a decent mix of circle and
                 * polygon collisions/contacts, though very little joint work.
                 *
                 * Rev 129 performance summary (details below class definition in source code):
                 *
                 * No bullets:
                 * 1.6 Average FPS: 			390.21332
                 * 1.6 -server Average FPS: 	470.05365
                 *
                 * (131+: with 1024M heap, 1.6 -server: 578.7675 FPS!)
                 *
                 * All bullets:
                 * 1.6 Average FPS: 			185.98808
                 * 1.6 -server Average FPS: 	221.55266
                 *
                 *
                 * (C++ performance for no bullets is ~708 FPS, for comparison's sake)
                 * @author eric
                 * @class
                 */
                var PistonBenchmark = (function () {
                    function PistonBenchmark() {
                        if (this.m_joint1 === undefined)
                            this.m_joint1 = null;
                        if (this.m_joint2 === undefined)
                            this.m_joint2 = null;
                    }
                    PistonBenchmark.prototype.create = function (world) {
                        {
                            var sd = new org.jbox2d.collision.shapes.PolygonDef();
                            sd.setAsBox$float$float(0.5, 2.0);
                            sd.density = 1.0;
                            var rjd = new org.jbox2d.dynamics.joints.RevoluteJointDef();
                            var prevBody = world.getGroundBody();
                            var bd = new org.jbox2d.dynamics.BodyDef();
                            bd.position.set$float$float(0.0, 7.0);
                            var body = world.createBody(bd);
                            body.createShape(sd);
                            body.setMassFromShapes();
                            rjd.initialize(prevBody, body, new org.jbox2d.common.Vec2(0.0, 5.0));
                            rjd.motorSpeed = Math.fround(1.0 * 3.1415);
                            rjd.maxMotorTorque = 3.4028235E38;
                            rjd.enableMotor = true;
                            this.m_joint1 = world.createJoint(rjd);
                            prevBody = body;
                            sd.setAsBox$float$float(0.5, 4.0);
                            bd.position.set$float$float(0.0, 13.0);
                            body = world.createBody(bd);
                            body.createShape(sd);
                            body.setMassFromShapes();
                            rjd.initialize(prevBody, body, new org.jbox2d.common.Vec2(0.0, 9.0));
                            rjd.enableMotor = false;
                            world.createJoint(rjd);
                            prevBody = body;
                            sd.setAsBox$float$float(5.0, 1.5);
                            bd.position.set$float$float(0.0, 17.0);
                            body = world.createBody(bd);
                            body.createShape(sd);
                            body.setMassFromShapes();
                            rjd.initialize(prevBody, body, new org.jbox2d.common.Vec2(0.0, 17.0));
                            world.createJoint(rjd);
                            var pjd = new org.jbox2d.dynamics.joints.PrismaticJointDef();
                            pjd.initialize(world.getGroundBody(), body, new org.jbox2d.common.Vec2(0.0, 17.0), new org.jbox2d.common.Vec2(0.0, 1.0));
                            pjd.enableMotor = false;
                            this.m_joint2 = world.createJoint(pjd);
                            for (var i = 0; i < 100; ++i) {
                                {
                                    sd.setAsBox$float$float(0.4, 0.3);
                                    sd.density = 0.1;
                                    bd.position.set$float$float(-1.0, Math.fround(23.0 + i));
                                    if (PistonBenchmark.BULLETS)
                                        bd.isBullet = true;
                                    else
                                        bd.isBullet = false;
                                    body = world.createBody(bd);
                                    body.createShape(sd);
                                    body.setMassFromShapes();
                                }
                                ;
                            }
                            var cd = new org.jbox2d.collision.shapes.CircleDef();
                            cd.density = 2.0;
                            cd.radius = 0.36;
                            for (var i = 0; i < 100; ++i) {
                                {
                                    bd.position.set$float$float(1.0, Math.fround(23.0 + i));
                                    if (PistonBenchmark.BULLETS)
                                        bd.isBullet = true;
                                    else
                                        bd.isBullet = false;
                                    body = world.createBody(bd);
                                    body.createShape(cd);
                                    body.setMassFromShapes();
                                }
                                ;
                            }
                            sd.density = 0.0;
                            sd.friction = 0.0;
                            sd.setAsBox$float$float(1.0, 100.0);
                            bd = new org.jbox2d.dynamics.BodyDef();
                            bd.position.set$float$float(-6.1, 50.0);
                            var bod = world.createBody(bd);
                            bod.createShape(sd);
                            bd.position.set$float$float(6.1, 50.0);
                            bod = world.createBody(bd);
                            bod.createShape(sd);
                        }
                        ;
                    };
                    PistonBenchmark.prototype.toString = function () {
                        return "Piston test";
                    };
                    return PistonBenchmark;
                }());
                PistonBenchmark.BULLETS = false;
                timingTests.PistonBenchmark = PistonBenchmark;
                PistonBenchmark["__class"] = "org.jbox2d.testbed.timingTests.PistonBenchmark";
                PistonBenchmark["__interfaces"] = ["org.jbox2d.testbed.timingTests.SimpleTest"];
            })(timingTests = testbed.timingTests || (testbed.timingTests = {}));
        })(testbed = jbox2d.testbed || (jbox2d.testbed = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var blob;
            (function (blob) {
                /**
                 * BlobMaker offers a static API for the creation of blobs.
                 * @class
                 */
                var BlobMaker = (function () {
                    function BlobMaker() {
                    }
                    BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World = function (s, c, w) {
                        BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World$float$float(s, c, w, 1.0, 1.0);
                    };
                    BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World$float$float = function (s, c, w, scaleX, scaleY) {
                        BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World$float$float$float$float(s, c, w, scaleX, scaleY, 0.0, 0.0);
                    };
                    BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World$float$float$float$float = function (s, c, w, scaleX, scaleY, transX, transY) {
                        var aabb = c.getAABB();
                        while ((transX > 0.0)) {
                            transX -= scaleX;
                        }
                        ;
                        while ((transY > 0.0)) {
                            transY -= scaleY;
                        }
                        ;
                        var xMin = Math.fround(aabb.lowerBound.x + transX);
                        var yMin = Math.fround(aabb.lowerBound.y + transY);
                        var nWidth = (Math.ceil(Math.fround((Math.fround(aabb.upperBound.x - xMin)) / scaleX)) | 0);
                        var nHeight = (Math.ceil(Math.fround((Math.fround(aabb.upperBound.y - yMin)) / scaleY)) | 0);
                        nWidth += 3;
                        nHeight += 3;
                        var nPerCell = s.points.length;
                        var nPoints = nPerCell * nWidth * nHeight;
                        console.info(nWidth + " " + nHeight);
                        var bodies = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(nPoints);
                        var cd = new org.jbox2d.collision.shapes.CircleDef();
                        cd.radius = BlobMaker.pointRadius;
                        cd.density = BlobMaker.pointDensity;
                        cd.friction = BlobMaker.pointFriction;
                        var index = 0;
                        for (var j = 0; j < nHeight; ++j) {
                            {
                                var yStart = Math.fround(Math.fround(yMin + transY) + Math.fround(j * scaleY));
                                for (var i = 0; i < nWidth; ++i) {
                                    {
                                        var xStart = Math.fround(Math.fround(xMin + transX) + Math.fround(i * scaleX));
                                        for (var k = 0; k < nPerCell; ++k) {
                                            {
                                                var position = new org.jbox2d.common.Vec2(Math.fround(/* get */ s.points[k].position.x + xStart), Math.fround(/* get */ s.points[k].position.y + yStart));
                                                if (!c.containsPoint(position)) {
                                                    bodies[index++] = null;
                                                    continue;
                                                }
                                                var bd = new org.jbox2d.dynamics.BodyDef();
                                                bd.position = position;
                                                bd.fixedRotation = false;
                                                bd.angularDamping = 0.2;
                                                bodies[index] = w.createBody(bd);
                                                bodies[index].createShape(cd);
                                                bodies[index].setMassFromShapes();
                                                ++index;
                                            }
                                            ;
                                        }
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                        for (var j = 0; j < nHeight; ++j) {
                            {
                                var rowStartIndex = j * nWidth * nPerCell;
                                for (var i = 0; i < nWidth; ++i) {
                                    {
                                        var boxStartIndex = rowStartIndex + i * nPerCell;
                                        var indexUR = -(nWidth - 1) * nPerCell + boxStartIndex;
                                        var indexR = nPerCell + boxStartIndex;
                                        var indexDR = (nWidth + 1) * nPerCell + boxStartIndex;
                                        var indexD = nWidth * nPerCell + boxStartIndex;
                                        for (var k = 0; k < s.connections.length; ++k) {
                                            {
                                                var iiff = s.connections[k];
                                                var a = iiff.a + boxStartIndex;
                                                var b = iiff.b + boxStartIndex;
                                                var freq = iiff.c;
                                                var damp = iiff.d;
                                                BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                                            }
                                            ;
                                        }
                                        for (var k = 0; k < s.connectionsR.length; ++k) {
                                            {
                                                var iiff = s.connectionsR[k];
                                                var a = iiff.a + boxStartIndex;
                                                var b = iiff.b + indexR;
                                                var freq = iiff.c;
                                                var damp = iiff.d;
                                                BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                                            }
                                            ;
                                        }
                                        for (var k = 0; k < s.connectionsDR.length; ++k) {
                                            {
                                                var iiff = s.connectionsDR[k];
                                                var a = iiff.a + boxStartIndex;
                                                var b = iiff.b + indexDR;
                                                var freq = iiff.c;
                                                var damp = iiff.d;
                                                BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                                            }
                                            ;
                                        }
                                        for (var k = 0; k < s.connectionsD.length; ++k) {
                                            {
                                                var iiff = s.connectionsD[k];
                                                var a = iiff.a + boxStartIndex;
                                                var b = iiff.b + indexD;
                                                var freq = iiff.c;
                                                var damp = iiff.d;
                                                BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                                            }
                                            ;
                                        }
                                        for (var k = 0; k < s.connectionsUR.length; ++k) {
                                            {
                                                if (j === 0)
                                                    break;
                                                var iiff = s.connectionsUR[k];
                                                var a = iiff.a + boxStartIndex;
                                                var b = iiff.b + indexUR;
                                                var freq = iiff.c;
                                                var damp = iiff.d;
                                                BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                                            }
                                            ;
                                        }
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                    };
                    /**
                     * Creates a blob in a given physics world.
                     * Applies the specified x/y scaling to the structure before fill.
                     * <BR><BR>
                     * The fill procedure aligns the structure with the upper
                     * left corner of the container AABB, applies the scaling,
                     * shifts the cell by the requested translation amounts,
                     * then repeats the structure until the AABB is filled,
                     * testing at each point whether the container is supposed
                     * to have geometry there.
                     * @param {org.jbox2d.util.blob.BlobStructure} s The BlobStructure definition
                     * @param {*} c The BlobContainer that specifies the geometry to fill
                     * @param {org.jbox2d.dynamics.World} w The World to create the blob in
                     * @param {number} scaleX The world width of one repeating cell of the structure
                     * @param {number} scaleY The world height of one repeating cell of the structure
                     * @param {number} transX The world x offset of the cells from the AABB edge
                     * @param {number} transY The world y offset of the cells from the AABB edge
                     */
                    BlobMaker.createBlob = function (s, c, w, scaleX, scaleY, transX, transY) {
                        if (((s != null && s instanceof org.jbox2d.util.blob.BlobStructure) || s === null) && ((c != null && (c["__interfaces"] != null && c["__interfaces"].indexOf("org.jbox2d.util.blob.BlobContainer") >= 0 || c.constructor != null && c.constructor["__interfaces"] != null && c.constructor["__interfaces"].indexOf("org.jbox2d.util.blob.BlobContainer") >= 0)) || c === null) && ((w != null && w instanceof org.jbox2d.dynamics.World) || w === null) && ((typeof scaleX === 'number') || scaleX === null) && ((typeof scaleY === 'number') || scaleY === null) && ((typeof transX === 'number') || transX === null) && ((typeof transY === 'number') || transY === null)) {
                            return org.jbox2d.util.blob.BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World$float$float$float$float(s, c, w, scaleX, scaleY, transX, transY);
                        }
                        else if (((s != null && s instanceof org.jbox2d.util.blob.BlobStructure) || s === null) && ((c != null && (c["__interfaces"] != null && c["__interfaces"].indexOf("org.jbox2d.util.blob.BlobContainer") >= 0 || c.constructor != null && c.constructor["__interfaces"] != null && c.constructor["__interfaces"].indexOf("org.jbox2d.util.blob.BlobContainer") >= 0)) || c === null) && ((w != null && w instanceof org.jbox2d.dynamics.World) || w === null) && ((typeof scaleX === 'number') || scaleX === null) && ((typeof scaleY === 'number') || scaleY === null) && transX === undefined && transY === undefined) {
                            return org.jbox2d.util.blob.BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World$float$float(s, c, w, scaleX, scaleY);
                        }
                        else if (((s != null && s instanceof org.jbox2d.util.blob.BlobStructure) || s === null) && ((c != null && (c["__interfaces"] != null && c["__interfaces"].indexOf("org.jbox2d.util.blob.BlobContainer") >= 0 || c.constructor != null && c.constructor["__interfaces"] != null && c.constructor["__interfaces"].indexOf("org.jbox2d.util.blob.BlobContainer") >= 0)) || c === null) && ((w != null && w instanceof org.jbox2d.dynamics.World) || w === null) && scaleX === undefined && scaleY === undefined && transX === undefined && transY === undefined) {
                            return org.jbox2d.util.blob.BlobMaker.createBlob$org_jbox2d_util_blob_BlobStructure$org_jbox2d_util_blob_BlobContainer$org_jbox2d_dynamics_World(s, c, w);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    /*private*/ BlobMaker.createConnection = function (bodies, a, b, frequency, damping, w) {
                        if (a >= bodies.length || b >= bodies.length || bodies[a] == null || bodies[b] == null)
                            return null;
                        var jd = new org.jbox2d.dynamics.joints.DistanceJointDef();
                        jd.collideConnected = false;
                        jd.dampingRatio = damping;
                        jd.frequencyHz = frequency;
                        jd.initialize(bodies[a], bodies[b], bodies[a].getMemberPosition(), bodies[b].getMemberPosition());
                        return w.createJoint(jd);
                    };
                    return BlobMaker;
                }());
                BlobMaker.pointRadius = 3.0;
                BlobMaker.pointDensity = 1.0;
                BlobMaker.pointFriction = 0.5;
                blob.BlobMaker = BlobMaker;
                BlobMaker["__class"] = "org.jbox2d.util.blob.BlobMaker";
            })(blob = util.blob || (util.blob = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var blob;
            (function (blob) {
                var BlobPoint = (function () {
                    function BlobPoint(x, y) {
                        this.mass = 1.0;
                        if (this.position === undefined)
                            this.position = null;
                        this.position = new org.jbox2d.common.Vec2(x, y);
                    }
                    return BlobPoint;
                }());
                blob.BlobPoint = BlobPoint;
                BlobPoint["__class"] = "org.jbox2d.util.blob.BlobPoint";
            })(blob = util.blob || (util.blob = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var blob;
            (function (blob) {
                /**
                 * <p>Class for a toroidal repeating blob structure.
                 * Should be subclassed with code to initialize
                 * the structure in appropriate ways, such as for
                 * a hexagonal lattice or a uniform grid.</p>
                 * <p>Blobs are defined within an AABB from
                 * (0,0)->(1,1) that is then repeated to fill the
                 * full space after scaling (using the BlobMaker methods).
                 * The connections list keeps track of pairs of BlobPoints
                 * by index that are connected, and the connections* lists keep
                 * track of connections outside the AABB (to the
                 * corresponding points in the next regions).
                 * </p>
                 * <p>
                 * Connections should only be defined once per pair.
                 * </p>
                 * <p>
                 * This class does not allow for arbitrary repeated structures,
                 * but most structures of interest will be expressible
                 * as toroidally repeating in this way.
                 * </p>
                 * @class
                 */
                var BlobStructure = (function () {
                    function BlobStructure() {
                        this.currentFrequency = 10.0;
                        this.currentDamping = 0.9;
                        if (this.points === undefined)
                            this.points = null;
                        if (this.connections === undefined)
                            this.connections = null;
                        if (this.connectionsR === undefined)
                            this.connectionsR = null;
                        if (this.connectionsDR === undefined)
                            this.connectionsDR = null;
                        if (this.connectionsD === undefined)
                            this.connectionsD = null;
                        if (this.connectionsUR === undefined)
                            this.connectionsUR = null;
                        this.points = ([]);
                        this.connections = ([]);
                        this.connectionsR = ([]);
                        this.connectionsDR = ([]);
                        this.connectionsD = ([]);
                        this.connectionsUR = ([]);
                    }
                    BlobStructure.prototype.updateSprings = function () {
                        for (var index124 = 0; index124 < this.connections.length; index124++) {
                            var iiff = this.connections[index124];
                            {
                                iiff.c = this.currentFrequency;
                                iiff.d = this.currentDamping;
                            }
                        }
                        for (var index125 = 0; index125 < this.connectionsR.length; index125++) {
                            var iiff = this.connectionsR[index125];
                            {
                                iiff.c = this.currentFrequency;
                                iiff.d = this.currentDamping;
                            }
                        }
                        for (var index126 = 0; index126 < this.connectionsDR.length; index126++) {
                            var iiff = this.connectionsDR[index126];
                            {
                                iiff.c = this.currentFrequency;
                                iiff.d = this.currentDamping;
                            }
                        }
                        for (var index127 = 0; index127 < this.connectionsD.length; index127++) {
                            var iiff = this.connectionsD[index127];
                            {
                                iiff.c = this.currentFrequency;
                                iiff.d = this.currentDamping;
                            }
                        }
                        for (var index128 = 0; index128 < this.connectionsUR.length; index128++) {
                            var iiff = this.connectionsUR[index128];
                            {
                                iiff.c = this.currentFrequency;
                                iiff.d = this.currentDamping;
                            }
                        }
                    };
                    BlobStructure.prototype.setSpringFrequency = function (freq) {
                        this.currentFrequency = freq;
                        this.updateSprings();
                    };
                    BlobStructure.prototype.getSpringFrequency = function () {
                        return this.currentFrequency;
                    };
                    BlobStructure.prototype.setSpringDamping = function (damp) {
                        this.currentDamping = damp;
                        this.updateSprings();
                    };
                    BlobStructure.prototype.getSpringDamping = function () {
                        return this.currentDamping;
                    };
                    BlobStructure.prototype.addPoint = function (p) {
                        if (p.position.x < 0.0 || p.position.x > 1.0 || p.position.y < 0.0 || p.position.y > 1.0)
                            throw Object.defineProperty(new Error("Points must be within (0,0)->(1,1) in a BlobStructure."), '__classes', { configurable: true, value: ['java.lang.Throwable', 'java.lang.Object', 'java.lang.RuntimeException', 'java.lang.Exception'] });
                        /* add */ (this.points.push(p) > 0);
                        return this.points.indexOf(p);
                    };
                    BlobStructure.prototype.addConnection$int$int = function (a, b) {
                        /* add */ (this.connections.push(new BlobStructure.IntIntFloatFloat(this, a, b, this.currentFrequency, this.currentDamping)) > 0);
                    };
                    BlobStructure.prototype.addConnection$int$int$org_jbox2d_util_blob_BlobStructure_Region = function (a, b, r) {
                        switch ((r)) {
                            case org.jbox2d.util.blob.BlobStructure.Region.CENTER:
                                this.addConnection$int$int(a, b);
                                break;
                            case org.jbox2d.util.blob.BlobStructure.Region.RIGHT:
                                /* add */ (this.connectionsR.push(new BlobStructure.IntIntFloatFloat(this, a, b, this.currentFrequency, this.currentDamping)) > 0);
                                break;
                            case org.jbox2d.util.blob.BlobStructure.Region.DOWN_RIGHT:
                                /* add */ (this.connectionsDR.push(new BlobStructure.IntIntFloatFloat(this, a, b, this.currentFrequency, this.currentDamping)) > 0);
                                break;
                            case org.jbox2d.util.blob.BlobStructure.Region.DOWN:
                                /* add */ (this.connectionsD.push(new BlobStructure.IntIntFloatFloat(this, a, b, this.currentFrequency, this.currentDamping)) > 0);
                                break;
                            case org.jbox2d.util.blob.BlobStructure.Region.UP_RIGHT:
                                /* add */ (this.connectionsUR.push(new BlobStructure.IntIntFloatFloat(this, a, b, this.currentFrequency, this.currentDamping)) > 0);
                                break;
                        }
                    };
                    /**
                     *
                     * Add a connection between point at index a in the fundamental domain
                     * and point at index b in region r.
                     * <BR><BR>
                     * Point indices can be obtained when points are added by storing the
                     * return value of the addPoint method.
                     * @param {number} a
                     * @param {number} b
                     * @param {org.jbox2d.util.blob.BlobStructure.Region} r
                     */
                    BlobStructure.prototype.addConnection = function (a, b, r) {
                        if (((typeof a === 'number') || a === null) && ((typeof b === 'number') || b === null) && ((typeof r === 'number') || r === null)) {
                            return this.addConnection$int$int$org_jbox2d_util_blob_BlobStructure_Region(a, b, r);
                        }
                        else if (((typeof a === 'number') || a === null) && ((typeof b === 'number') || b === null) && r === undefined) {
                            return this.addConnection$int$int(a, b);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    return BlobStructure;
                }());
                blob.BlobStructure = BlobStructure;
                BlobStructure["__class"] = "org.jbox2d.util.blob.BlobStructure";
                (function (BlobStructure) {
                    var IntIntFloatFloat = (function () {
                        function IntIntFloatFloat(__parent, _a, _b, _c, _d) {
                            this.__parent = __parent;
                            if (this.a === undefined)
                                this.a = 0;
                            if (this.b === undefined)
                                this.b = 0;
                            if (this.c === undefined)
                                this.c = 0;
                            if (this.d === undefined)
                                this.d = 0;
                            this.a = _a;
                            this.b = _b;
                            this.c = _c;
                            this.d = _d;
                        }
                        return IntIntFloatFloat;
                    }());
                    BlobStructure.IntIntFloatFloat = IntIntFloatFloat;
                    IntIntFloatFloat["__class"] = "org.jbox2d.util.blob.BlobStructure.IntIntFloatFloat";
                    /**
                     * Determines what region in toroidal space we're referring to.
                     * @enum
                     * @property {org.jbox2d.util.blob.BlobStructure.Region} DOWN
                     * @property {org.jbox2d.util.blob.BlobStructure.Region} RIGHT
                     * @property {org.jbox2d.util.blob.BlobStructure.Region} DOWN_RIGHT
                     * @property {org.jbox2d.util.blob.BlobStructure.Region} UP_RIGHT
                     * @property {org.jbox2d.util.blob.BlobStructure.Region} CENTER
                     * @class
                     */
                    var Region;
                    (function (Region) {
                        Region[Region["DOWN"] = 0] = "DOWN";
                        Region[Region["RIGHT"] = 1] = "RIGHT";
                        Region[Region["DOWN_RIGHT"] = 2] = "DOWN_RIGHT";
                        Region[Region["UP_RIGHT"] = 3] = "UP_RIGHT";
                        Region[Region["CENTER"] = 4] = "CENTER";
                    })(Region = BlobStructure.Region || (BlobStructure.Region = {}));
                })(BlobStructure = blob.BlobStructure || (blob.BlobStructure = {}));
            })(blob = util.blob || (util.blob = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var blob;
            (function (blob) {
                /**
                 * A circular blob container specified by radius and center.
                 * @param {org.jbox2d.common.Vec2} _center
                 * @param {number} _radius
                 * @class
                 */
                var CircularBlobContainer = (function () {
                    function CircularBlobContainer(_center, _radius) {
                        if (this.centerX === undefined)
                            this.centerX = 0;
                        if (this.centerY === undefined)
                            this.centerY = 0;
                        if (this.radius === undefined)
                            this.radius = 0;
                        if (this.radiusSqr === undefined)
                            this.radiusSqr = 0;
                        this.centerX = _center.x;
                        this.centerY = _center.y;
                        this.radius = _radius;
                        this.radiusSqr = Math.fround(_radius * _radius);
                    }
                    CircularBlobContainer.prototype.getRadius = function () {
                        return this.radius;
                    };
                    CircularBlobContainer.prototype.setRadius = function (r) {
                        this.radius = r;
                        this.radiusSqr = Math.fround(r * r);
                    };
                    CircularBlobContainer.prototype.getCenter = function () {
                        return new org.jbox2d.common.Vec2(this.centerX, this.centerY);
                    };
                    CircularBlobContainer.prototype.setCenter = function (c) {
                        this.centerX = c.x;
                        this.centerY = c.y;
                    };
                    CircularBlobContainer.prototype.containsPoint = function (p) {
                        var distSqr = Math.fround(Math.fround((Math.fround(p.x - this.centerX)) * (Math.fround(p.x - this.centerX))) + Math.fround((Math.fround(p.y - this.centerY)) * (Math.fround(p.y - this.centerY))));
                        if (distSqr > this.radiusSqr)
                            return false;
                        return true;
                    };
                    CircularBlobContainer.prototype.getAABB = function () {
                        var min = new org.jbox2d.common.Vec2(Math.fround(this.centerX - Math.fround(this.radius * 1.2)), Math.fround(this.centerY - Math.fround(this.radius * 1.2)));
                        var max = new org.jbox2d.common.Vec2(Math.fround(this.centerX + Math.fround(this.radius * 1.2)), Math.fround(this.centerY + Math.fround(this.radius * 1.2)));
                        return new org.jbox2d.collision.AABB(min, max);
                    };
                    return CircularBlobContainer;
                }());
                blob.CircularBlobContainer = CircularBlobContainer;
                CircularBlobContainer["__class"] = "org.jbox2d.util.blob.CircularBlobContainer";
                CircularBlobContainer["__interfaces"] = ["org.jbox2d.util.blob.BlobContainer"];
            })(blob = util.blob || (util.blob = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var blob;
            (function (blob) {
                /**
                 * A donut blob container specified by two radii and a center.
                 * @param {org.jbox2d.common.Vec2} _center
                 * @param {number} _radiusSmall
                 * @param {number} _radiusLarge
                 * @class
                 */
                var DonutBlobContainer = (function () {
                    function DonutBlobContainer(_center, _radiusSmall, _radiusLarge) {
                        if (this.centerX === undefined)
                            this.centerX = 0;
                        if (this.centerY === undefined)
                            this.centerY = 0;
                        if (this.radiusLarge === undefined)
                            this.radiusLarge = 0;
                        if (this.radiusSmallSqr === undefined)
                            this.radiusSmallSqr = 0;
                        if (this.radiusLargeSqr === undefined)
                            this.radiusLargeSqr = 0;
                        this.centerX = _center.x;
                        this.centerY = _center.y;
                        this.radiusLarge = _radiusLarge;
                        this.radiusSmallSqr = Math.fround(_radiusSmall * _radiusSmall);
                        this.radiusLargeSqr = Math.fround(_radiusLarge * _radiusLarge);
                    }
                    DonutBlobContainer.prototype.containsPoint = function (p) {
                        var distSqr = Math.fround(Math.fround((Math.fround(p.x - this.centerX)) * (Math.fround(p.x - this.centerX))) + Math.fround((Math.fround(p.y - this.centerY)) * (Math.fround(p.y - this.centerY))));
                        if (distSqr > this.radiusLargeSqr)
                            return false;
                        if (distSqr < this.radiusSmallSqr)
                            return false;
                        return true;
                    };
                    DonutBlobContainer.prototype.getAABB = function () {
                        var min = new org.jbox2d.common.Vec2(Math.fround(this.centerX - Math.fround(1.2 * this.radiusLarge)), Math.fround(this.centerY - Math.fround(1.2 * this.radiusLarge)));
                        var max = new org.jbox2d.common.Vec2(Math.fround(this.centerX + Math.fround(1.2 * this.radiusLarge)), Math.fround(this.centerY + Math.fround(1.2 * this.radiusLarge)));
                        return new org.jbox2d.collision.AABB(min, max);
                    };
                    return DonutBlobContainer;
                }());
                blob.DonutBlobContainer = DonutBlobContainer;
                DonutBlobContainer["__class"] = "org.jbox2d.util.blob.DonutBlobContainer";
                DonutBlobContainer["__interfaces"] = ["org.jbox2d.util.blob.BlobContainer"];
            })(blob = util.blob || (util.blob = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var nonconvex;
            (function (nonconvex) {
                var Triangle = (function () {
                    function Triangle(x1, y1, x2, y2, x3, y3) {
                        var _this = this;
                        if (((typeof x1 === 'number') || x1 === null) && ((typeof y1 === 'number') || y1 === null) && ((typeof x2 === 'number') || x2 === null) && ((typeof y2 === 'number') || y2 === null) && ((typeof x3 === 'number') || x3 === null) && ((typeof y3 === 'number') || y3 === null)) {
                            var __args = arguments;
                            {
                                var __args_7 = arguments;
                                if (this.x === undefined)
                                    this.x = null;
                                if (this.y === undefined)
                                    this.y = null;
                                if (this.x === undefined)
                                    this.x = null;
                                if (this.y === undefined)
                                    this.y = null;
                                (function () {
                                    _this.x = [0, 0, 0];
                                    _this.y = [0, 0, 0];
                                })();
                            }
                            (function () {
                                var dx1 = Math.fround(x2 - x1);
                                var dx2 = Math.fround(x3 - x1);
                                var dy1 = Math.fround(y2 - y1);
                                var dy2 = Math.fround(y3 - y1);
                                var cross = Math.fround(Math.fround(dx1 * dy2) - Math.fround(dx2 * dy1));
                                var ccw = (cross > 0);
                                if (ccw) {
                                    _this.x[0] = x1;
                                    _this.x[1] = x2;
                                    _this.x[2] = x3;
                                    _this.y[0] = y1;
                                    _this.y[1] = y2;
                                    _this.y[2] = y3;
                                }
                                else {
                                    _this.x[0] = x1;
                                    _this.x[1] = x3;
                                    _this.x[2] = x2;
                                    _this.y[0] = y1;
                                    _this.y[1] = y3;
                                    _this.y[2] = y2;
                                }
                            })();
                        }
                        else if (x1 === undefined && y1 === undefined && x2 === undefined && y2 === undefined && x3 === undefined && y3 === undefined) {
                            var __args = arguments;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            (function () {
                                _this.x = [0, 0, 0];
                                _this.y = [0, 0, 0];
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    Triangle.prototype.set = function (t) {
                        this.x[0] = t.x[0];
                        this.x[1] = t.x[1];
                        this.x[2] = t.x[2];
                        this.y[0] = t.y[0];
                        this.y[1] = t.y[1];
                        this.y[2] = t.y[2];
                    };
                    Triangle.prototype.containsPoint = function (_x, _y) {
                        var vx2 = Math.fround(_x - this.x[0]);
                        var vy2 = Math.fround(_y - this.y[0]);
                        var vx1 = Math.fround(this.x[1] - this.x[0]);
                        var vy1 = Math.fround(this.y[1] - this.y[0]);
                        var vx0 = Math.fround(this.x[2] - this.x[0]);
                        var vy0 = Math.fround(this.y[2] - this.y[0]);
                        var dot00 = Math.fround(Math.fround(vx0 * vx0) + Math.fround(vy0 * vy0));
                        var dot01 = Math.fround(Math.fround(vx0 * vx1) + Math.fround(vy0 * vy1));
                        var dot02 = Math.fround(Math.fround(vx0 * vx2) + Math.fround(vy0 * vy2));
                        var dot11 = Math.fround(Math.fround(vx1 * vx1) + Math.fround(vy1 * vy1));
                        var dot12 = Math.fround(Math.fround(vx1 * vx2) + Math.fround(vy1 * vy2));
                        var invDenom = Math.fround(1.0 / (Math.fround(Math.fround(dot00 * dot11) - Math.fround(dot01 * dot01))));
                        var u = Math.fround((Math.fround(Math.fround(dot11 * dot02) - Math.fround(dot01 * dot12))) * invDenom);
                        var v = Math.fround((Math.fround(Math.fround(dot00 * dot12) - Math.fround(dot01 * dot02))) * invDenom);
                        return ((u >= 0) && (v >= 0) && (Math.fround(u + v) <= 1));
                    };
                    return Triangle;
                }());
                nonconvex.Triangle = Triangle;
                Triangle["__class"] = "org.jbox2d.util.nonconvex.Triangle";
            })(nonconvex = util.nonconvex || (util.nonconvex = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var sph;
            (function (sph) {
                var Parameter = (function () {
                    function Parameter(p) {
                        var _this = this;
                        if (((p != null && p instanceof org.jbox2d.util.sph.Parameter) || p === null)) {
                            var __args = arguments;
                            if (this.numPts === undefined)
                                this.numPts = 0;
                            if (this.velocityScale === undefined)
                                this.velocityScale = 0;
                            if (this.initVel === undefined)
                                this.initVel = null;
                            if (this.initMass === undefined)
                                this.initMass = 0;
                            if (this.initDensity === undefined)
                                this.initDensity = 0;
                            if (this.initPressure === undefined)
                                this.initPressure = 0;
                            if (this.initPtSpacing === undefined)
                                this.initPtSpacing = 0;
                            if (this.h === undefined)
                                this.h = 0;
                            if (this.c === undefined)
                                this.c = 0;
                            if (this.machNum === undefined)
                                this.machNum = 0;
                            if (this.betaMax === undefined)
                                this.betaMax = 0;
                            if (this.nu === undefined)
                                this.nu = 0;
                            if (this.bodyFX === undefined)
                                this.bodyFX = 0;
                            if (this.bodyFY === undefined)
                                this.bodyFY = 0;
                            if (this.densityVariation === undefined)
                                this.densityVariation = 0;
                            if (this.lengthScale === undefined)
                                this.lengthScale = 0;
                            if (this.firstOutput === undefined)
                                this.firstOutput = 0;
                            if (this.outputEvery === undefined)
                                this.outputEvery = 0;
                            if (this.numSteps === undefined)
                                this.numSteps = 0;
                            if (this.deltaT === undefined)
                                this.deltaT = 0;
                            if (this.numPts === undefined)
                                this.numPts = 0;
                            if (this.velocityScale === undefined)
                                this.velocityScale = 0;
                            if (this.initVel === undefined)
                                this.initVel = null;
                            if (this.initMass === undefined)
                                this.initMass = 0;
                            if (this.initDensity === undefined)
                                this.initDensity = 0;
                            if (this.initPressure === undefined)
                                this.initPressure = 0;
                            if (this.initPtSpacing === undefined)
                                this.initPtSpacing = 0;
                            if (this.h === undefined)
                                this.h = 0;
                            if (this.c === undefined)
                                this.c = 0;
                            if (this.machNum === undefined)
                                this.machNum = 0;
                            if (this.betaMax === undefined)
                                this.betaMax = 0;
                            if (this.nu === undefined)
                                this.nu = 0;
                            if (this.bodyFX === undefined)
                                this.bodyFX = 0;
                            if (this.bodyFY === undefined)
                                this.bodyFY = 0;
                            if (this.densityVariation === undefined)
                                this.densityVariation = 0;
                            if (this.lengthScale === undefined)
                                this.lengthScale = 0;
                            if (this.firstOutput === undefined)
                                this.firstOutput = 0;
                            if (this.outputEvery === undefined)
                                this.outputEvery = 0;
                            if (this.numSteps === undefined)
                                this.numSteps = 0;
                            if (this.deltaT === undefined)
                                this.deltaT = 0;
                            (function () {
                                _this.numPts = p.numPts;
                                _this.velocityScale = p.velocityScale;
                                _this.initVel = p.initVel;
                                _this.initMass = p.initMass;
                                _this.initDensity = p.initDensity;
                                _this.initPressure = p.initPressure;
                                _this.initPtSpacing = p.initPtSpacing;
                                _this.h = p.h;
                                _this.c = p.c;
                                _this.machNum = p.machNum;
                                _this.betaMax = p.betaMax;
                                _this.nu = p.nu;
                                _this.bodyFX = p.bodyFX;
                                _this.bodyFY = p.bodyFY;
                                _this.densityVariation = p.densityVariation;
                                _this.lengthScale = p.lengthScale;
                                _this.firstOutput = p.firstOutput;
                                _this.outputEvery = p.outputEvery;
                                _this.numSteps = p.numSteps;
                                _this.deltaT = p.deltaT;
                            })();
                        }
                        else if (p === undefined) {
                            var __args = arguments;
                            if (this.numPts === undefined)
                                this.numPts = 0;
                            if (this.velocityScale === undefined)
                                this.velocityScale = 0;
                            if (this.initVel === undefined)
                                this.initVel = null;
                            if (this.initMass === undefined)
                                this.initMass = 0;
                            if (this.initDensity === undefined)
                                this.initDensity = 0;
                            if (this.initPressure === undefined)
                                this.initPressure = 0;
                            if (this.initPtSpacing === undefined)
                                this.initPtSpacing = 0;
                            if (this.h === undefined)
                                this.h = 0;
                            if (this.c === undefined)
                                this.c = 0;
                            if (this.machNum === undefined)
                                this.machNum = 0;
                            if (this.betaMax === undefined)
                                this.betaMax = 0;
                            if (this.nu === undefined)
                                this.nu = 0;
                            if (this.bodyFX === undefined)
                                this.bodyFX = 0;
                            if (this.bodyFY === undefined)
                                this.bodyFY = 0;
                            if (this.densityVariation === undefined)
                                this.densityVariation = 0;
                            if (this.lengthScale === undefined)
                                this.lengthScale = 0;
                            if (this.firstOutput === undefined)
                                this.firstOutput = 0;
                            if (this.outputEvery === undefined)
                                this.outputEvery = 0;
                            if (this.numSteps === undefined)
                                this.numSteps = 0;
                            if (this.deltaT === undefined)
                                this.deltaT = 0;
                            if (this.numPts === undefined)
                                this.numPts = 0;
                            if (this.velocityScale === undefined)
                                this.velocityScale = 0;
                            if (this.initVel === undefined)
                                this.initVel = null;
                            if (this.initMass === undefined)
                                this.initMass = 0;
                            if (this.initDensity === undefined)
                                this.initDensity = 0;
                            if (this.initPressure === undefined)
                                this.initPressure = 0;
                            if (this.initPtSpacing === undefined)
                                this.initPtSpacing = 0;
                            if (this.h === undefined)
                                this.h = 0;
                            if (this.c === undefined)
                                this.c = 0;
                            if (this.machNum === undefined)
                                this.machNum = 0;
                            if (this.betaMax === undefined)
                                this.betaMax = 0;
                            if (this.nu === undefined)
                                this.nu = 0;
                            if (this.bodyFX === undefined)
                                this.bodyFX = 0;
                            if (this.bodyFY === undefined)
                                this.bodyFY = 0;
                            if (this.densityVariation === undefined)
                                this.densityVariation = 0;
                            if (this.lengthScale === undefined)
                                this.lengthScale = 0;
                            if (this.firstOutput === undefined)
                                this.firstOutput = 0;
                            if (this.outputEvery === undefined)
                                this.outputEvery = 0;
                            if (this.numSteps === undefined)
                                this.numSteps = 0;
                            if (this.deltaT === undefined)
                                this.deltaT = 0;
                            (function () {
                                _this.numPts = 0;
                                _this.velocityScale = 0;
                                _this.initVel = new org.jbox2d.common.Vec2(0, 0);
                                _this.initMass = 0;
                                _this.initDensity = 0;
                                _this.initPressure = 0;
                                _this.initPtSpacing = 0;
                                _this.h = 0;
                                _this.c = 0;
                                _this.machNum = 0;
                                _this.deltaT = 0;
                                _this.outputEvery = 0;
                                _this.betaMax = 0;
                                _this.numSteps = 0;
                                _this.firstOutput = 0;
                                _this.nu = 0;
                                _this.bodyFX = 0;
                                _this.bodyFY = 0;
                                _this.densityVariation = 0;
                                _this.lengthScale = 0;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    return Parameter;
                }());
                sph.Parameter = Parameter;
                Parameter["__class"] = "org.jbox2d.util.sph.Parameter";
            })(sph = util.sph || (util.sph = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var sph;
            (function (sph) {
                var Particle = (function () {
                    function Particle(p, v, m) {
                        var _this = this;
                        if (((p != null && p instanceof org.jbox2d.common.Vec2) || p === null) && ((v != null && v instanceof org.jbox2d.common.Vec2) || v === null) && ((typeof m === 'number') || m === null)) {
                            var __args = arguments;
                            if (this.pos === undefined)
                                this.pos = null;
                            if (this.vel === undefined)
                                this.vel = null;
                            if (this.mass === undefined)
                                this.mass = 0;
                            if (this.deleted === undefined)
                                this.deleted = 0;
                            if (this.pos === undefined)
                                this.pos = null;
                            if (this.vel === undefined)
                                this.vel = null;
                            if (this.mass === undefined)
                                this.mass = 0;
                            if (this.deleted === undefined)
                                this.deleted = 0;
                            (function () {
                                _this.pos = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p_1 in o) {
                                        if (o.hasOwnProperty(p_1))
                                            clone[p_1] = o[p_1];
                                    }
                                    return clone;
                                } })(p);
                                _this.vel = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p_2 in o) {
                                        if (o.hasOwnProperty(p_2))
                                            clone[p_2] = o[p_2];
                                    }
                                    return clone;
                                } })(v);
                                _this.mass = m;
                            })();
                        }
                        else if (((p != null && p instanceof org.jbox2d.util.sph.Particle) || p === null) && v === undefined && m === undefined) {
                            var __args = arguments;
                            var P_1 = __args[0];
                            if (this.pos === undefined)
                                this.pos = null;
                            if (this.vel === undefined)
                                this.vel = null;
                            if (this.mass === undefined)
                                this.mass = 0;
                            if (this.deleted === undefined)
                                this.deleted = 0;
                            if (this.pos === undefined)
                                this.pos = null;
                            if (this.vel === undefined)
                                this.vel = null;
                            if (this.mass === undefined)
                                this.mass = 0;
                            if (this.deleted === undefined)
                                this.deleted = 0;
                            (function () {
                                _this.pos = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p_3 in o) {
                                        if (o.hasOwnProperty(p_3))
                                            clone[p_3] = o[p_3];
                                    }
                                    return clone;
                                } })(P_1.pos);
                                _this.vel = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p_4 in o) {
                                        if (o.hasOwnProperty(p_4))
                                            clone[p_4] = o[p_4];
                                    }
                                    return clone;
                                } })(P_1.vel);
                                _this.mass = P_1.mass;
                                _this.deleted = P_1.deleted;
                            })();
                        }
                        else if (p === undefined && v === undefined && m === undefined) {
                            var __args = arguments;
                            if (this.pos === undefined)
                                this.pos = null;
                            if (this.vel === undefined)
                                this.vel = null;
                            if (this.mass === undefined)
                                this.mass = 0;
                            if (this.deleted === undefined)
                                this.deleted = 0;
                            if (this.pos === undefined)
                                this.pos = null;
                            if (this.vel === undefined)
                                this.vel = null;
                            if (this.mass === undefined)
                                this.mass = 0;
                            if (this.deleted === undefined)
                                this.deleted = 0;
                            (function () {
                                _this.pos = new org.jbox2d.common.Vec2();
                                _this.vel = new org.jbox2d.common.Vec2();
                                _this.mass = 0.0;
                                _this.deleted = 1;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    Particle.prototype.deleteParticle = function () {
                        this.deleted = 1;
                    };
                    Particle.prototype.undeleteParticle = function () {
                        this.deleted = 0;
                    };
                    Particle.prototype.isEmpty = function () {
                        return ((this.deleted !== 0) ? true : false);
                    };
                    return Particle;
                }());
                sph.Particle = Particle;
                Particle["__class"] = "org.jbox2d.util.sph.Particle";
            })(sph = util.sph || (util.sph = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var sph;
            (function (sph) {
                var SPHGroup = (function () {
                    function SPHGroup(nParts, aabb, parent, tStep) {
                        if (this.t === undefined)
                            this.t = null;
                        if (this.param === undefined)
                            this.param = null;
                        this.param = new org.jbox2d.util.sph.Parameter();
                        this.param.numPts = nParts;
                        this.param.initVel = new org.jbox2d.common.Vec2(0.0, 0.0);
                        this.param.machNum = 0.5;
                        this.param.initDensity = 1000.0;
                        this.param.initPressure = 10000.0;
                        this.param.nu = 1000.0;
                        this.param.deltaT = tStep;
                        this.param.numSteps = 500000;
                        this.param.outputEvery = 5000;
                        this.param.firstOutput = 0;
                        this.param.densityVariation = 0.3;
                        this.param.lengthScale = 1000.0;
                        this.param.bodyFX = 0.0;
                        this.param.bodyFY = 0.0;
                        this.param.c = 1.0;
                        this.param.h = 1000.0;
                        this.t = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(nParts);
                        for (var i = 0; i < nParts; ++i) {
                            {
                                var x = parent.random(aabb.lowerBound.x, aabb.upperBound.x);
                                var y = parent.random(aabb.lowerBound.y, aabb.upperBound.y);
                                this.t[i] = new org.jbox2d.util.sph.SmoothParticle();
                                this.t[i].pos.set$org_jbox2d_common_Vec2(new org.jbox2d.common.Vec2(x, y));
                                this.t[i].vel.set$org_jbox2d_common_Vec2(this.param.initVel);
                                this.t[i].mass = (1.0);
                                this.t[i].setDensity(this.param.initDensity);
                                this.t[i].setPressure(this.param.initPressure);
                                this.t[i].setSmoothingLength(this.param.h);
                                this.t[i].setSpeedSound(this.param.c);
                                this.t[i].undeleteParticle();
                                this.t[i].ID = i;
                                this.t[i].setShapeID(-1);
                            }
                            ;
                        }
                    }
                    /**
                     * This method calculates the pressure of each particle
                     */
                    SPHGroup.prototype.calcPressure = function () {
                        for (var i = 0; i < this.t.length; i++) {
                            {
                                if (!this.t[i].isEmpty()) {
                                    this.t[i].setMinMaxDensity();
                                    this.t[i].calcPressure(this.param);
                                }
                            }
                            ;
                        }
                    };
                    /**
                     * Calculates SPH density/velocity contributions to p1 as a result of p2.
                     * @param {org.jbox2d.util.sph.SmoothParticle} p1
                     * @param {org.jbox2d.util.sph.SmoothParticle} p2
                     */
                    SPHGroup.prototype.calcSPHEquations = function (p1, p2) {
                        if (p1.isEmpty() || p2.isEmpty())
                            console.info("Panic!  Particle is empty!");
                        var v_aB = new org.jbox2d.common.Vec2((Math.fround(p1.vel.x - p2.vel.x)), (Math.fround(p1.vel.y - p2.vel.y)));
                        p1.calcChangeDensity(p2, v_aB);
                        p1.calcChangeVelocity(p2, v_aB, this.param);
                        p1.addForceX(this.param);
                        p1.addForceY(this.param);
                    };
                    /**
                     * Calculates the correct timestep given the current setup of the system, prints
                     * a message if the current time step is too large.
                     */
                    SPHGroup.prototype.calcCorrectDeltaT = function () {
                        var i = 0;
                        var accelX = 0;
                        var accelY = 0;
                        var maxAccelSquared = 0;
                        var accelSquared = 0;
                        maxAccelSquared = 0;
                        for (i = 0; i < this.t.length; i++) {
                            {
                                if (!this.t[i].isEmpty()) {
                                    accelX = this.t[i].getChangeVelocityX();
                                    accelY = this.t[i].getChangeVelocityY();
                                    accelSquared = accelX * accelX + accelY * accelY;
                                    if (accelSquared > maxAccelSquared)
                                        maxAccelSquared = accelSquared;
                                }
                            }
                            ;
                        }
                        var calcDeltaT = 10000000;
                        if (maxAccelSquared > 0.0) {
                            calcDeltaT = 0.25 * Math.sqrt(this.param.h / Math.sqrt(maxAccelSquared));
                        }
                        if (calcDeltaT < this.param.deltaT) {
                            console.info("current DT: " + this.param.deltaT + " is not small enough.");
                            console.info("It should be: " + calcDeltaT);
                        }
                    };
                    /**
                     * Handle a time step, including SPH forces
                     */
                    SPHGroup.prototype.updateParticles = function () {
                        this.calcPressure();
                        for (var i = 0; i < this.t.length; ++i) {
                            {
                                this.t[i].zeroSPHVars();
                                for (var j = 0; j < this.t.length; ++j) {
                                    {
                                        if (i === j)
                                            continue;
                                        this.calcSPHEquations(this.t[i], this.t[j]);
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                        var dt = Math.fround(this.param.deltaT);
                        for (var i = 0; i < this.t.length; ++i) {
                            {
                                var p = this.t[i];
                                p.vel.x += Math.fround(Math.fround(p.getChangeVelocityX()) * dt);
                                p.vel.y += Math.fround(Math.fround(p.getChangeVelocityY()) * dt);
                                p.density += Math.fround(Math.fround(p.getChangeDensity()) * dt);
                                p.pos.x += Math.fround(p.vel.x * dt);
                                p.pos.y += Math.fround(p.vel.y * dt);
                                console.info(p.getChangeVelocityY());
                            }
                            ;
                        }
                    };
                    return SPHGroup;
                }());
                sph.SPHGroup = SPHGroup;
                SPHGroup["__class"] = "org.jbox2d.util.sph.SPHGroup";
            })(sph = util.sph || (util.sph = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * creates the circle definition at the given point with
                 * a radius of 1
                 * @param {org.jbox2d.common.Vec2} argVec
                 * @class
                 * @extends org.jbox2d.collision.shapes.ShapeDef
                 */
                var CircleDef = (function (_super) {
                    __extends(CircleDef, _super);
                    function CircleDef(argVec) {
                        var _this = this;
                        if (((argVec != null && argVec instanceof org.jbox2d.common.Vec2) || argVec === null)) {
                            var __args = arguments;
                            _this = _super.call(this) || this;
                            if (_this.radius === undefined)
                                _this.radius = 0;
                            if (_this.localPosition === undefined)
                                _this.localPosition = null;
                            if (_this.radius === undefined)
                                _this.radius = 0;
                            if (_this.localPosition === undefined)
                                _this.localPosition = null;
                            (function () {
                                _this.localPosition = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(argVec);
                                _this.type = org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE;
                                _this.radius = 1.0;
                            })();
                        }
                        else if (argVec === undefined) {
                            var __args = arguments;
                            _this = _super.call(this) || this;
                            if (_this.radius === undefined)
                                _this.radius = 0;
                            if (_this.localPosition === undefined)
                                _this.localPosition = null;
                            if (_this.radius === undefined)
                                _this.radius = 0;
                            if (_this.localPosition === undefined)
                                _this.localPosition = null;
                            (function () {
                                _this.type = org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE;
                                _this.localPosition = new org.jbox2d.common.Vec2(0.0, 0.0);
                                _this.radius = 1.0;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                        return _this;
                    }
                    return CircleDef;
                }(org.jbox2d.collision.shapes.ShapeDef));
                shapes.CircleDef = CircleDef;
                CircleDef["__class"] = "org.jbox2d.collision.shapes.CircleDef";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                var EdgeChainDef = (function (_super) {
                    __extends(EdgeChainDef, _super);
                    function EdgeChainDef() {
                        var _this = _super.call(this) || this;
                        if (_this.vertices === undefined)
                            _this.vertices = null;
                        if (_this.isALoop === undefined)
                            _this.isALoop = false;
                        _this.type = org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE;
                        _this.isALoop = true;
                        _this.vertices = ([]);
                        return _this;
                    }
                    /**
                     * Add a vertex to the chain.
                     * @param {org.jbox2d.common.Vec2} newV
                     */
                    EdgeChainDef.prototype.addVertex = function (newV) {
                        /* add */ (this.vertices.push(newV) > 0);
                    };
                    /**
                     * Get the number of vertices in the chain.
                     * @return
                     * @return {number}
                     */
                    EdgeChainDef.prototype.getVertexCount = function () {
                        return this.vertices.length;
                    };
                    /**
                     * Is the chain a closed loop?  If so,
                     * an extra edge will be created between the
                     * first and last vertices.
                     * @return {boolean}
                     */
                    EdgeChainDef.prototype.isLoop = function () {
                        return this.isALoop;
                    };
                    /**
                     * Set whether an extra edge should be
                     * created between first and last vertices.
                     * @param {boolean} isLoop True if the chain should be a closed loop
                     */
                    EdgeChainDef.prototype.setIsLoop = function (isLoop) {
                        this.isALoop = isLoop;
                    };
                    /**
                     * Return the raw vertex list.  Modifications
                     * will effect the edge chain.
                     * @return
                     * @return {org.jbox2d.common.Vec2[]}
                     */
                    EdgeChainDef.prototype.getVertices = function () {
                        return this.vertices;
                    };
                    return EdgeChainDef;
                }(org.jbox2d.collision.shapes.ShapeDef));
                shapes.EdgeChainDef = EdgeChainDef;
                EdgeChainDef["__class"] = "org.jbox2d.collision.shapes.EdgeChainDef";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * Point shape definition.
                 * @class
                 * @extends org.jbox2d.collision.shapes.ShapeDef
                 */
                var PointDef = (function (_super) {
                    __extends(PointDef, _super);
                    function PointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.localPosition === undefined)
                            _this.localPosition = null;
                        if (_this.mass === undefined)
                            _this.mass = 0;
                        _this.type = org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE;
                        _this.localPosition = new org.jbox2d.common.Vec2(0.0, 0.0);
                        _this.mass = 0.0;
                        return _this;
                    }
                    return PointDef;
                }(org.jbox2d.collision.shapes.ShapeDef));
                shapes.PointDef = PointDef;
                PointDef["__class"] = "org.jbox2d.collision.shapes.PointDef";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * Convex polygon. The vertices must be in CCW order for a right-handed
                 * coordinate system with the z-axis coming out of the screen.
                 * Add vertices using PolygonDef.add(Vec2),
                 * and create the polygon shape using Body::createShape(ShapeDef).
                 * @class
                 * @extends org.jbox2d.collision.shapes.ShapeDef
                 */
                var PolygonDef = (function (_super) {
                    __extends(PolygonDef, _super);
                    function PolygonDef() {
                        var _this = _super.call(this) || this;
                        if (_this.vertices === undefined)
                            _this.vertices = null;
                        _this.type = org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE;
                        _this.vertices = ([]);
                        return _this;
                    }
                    PolygonDef.prototype.set = function (copyMe) {
                        this.density = copyMe.density;
                        this.filter = new org.jbox2d.collision.FilterData();
                        this.filter.set(copyMe.filter);
                        this.friction = copyMe.friction;
                        this.isSensor = copyMe.isSensor;
                        this.restitution = copyMe.restitution;
                        this.type = copyMe.type;
                        this.userData = copyMe.userData;
                        this.vertices = ([]);
                        for (var i = 0; i < copyMe.vertices.length; ++i) {
                            {
                                this.addVertex(/* clone */ /* clone */ (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p in o) {
                                        if (o.hasOwnProperty(p))
                                            clone[p] = o[p];
                                    }
                                    return clone;
                                } })(/* get */ copyMe.vertices[i]));
                            }
                            ;
                        }
                    };
                    /**
                     * Add a vertex to the polygon.
                     * @param {org.jbox2d.common.Vec2} v
                     */
                    PolygonDef.prototype.addVertex = function (v) {
                        /* add */ (this.vertices.push(v) > 0);
                    };
                    /**
                     * Removes all vertices.
                     */
                    PolygonDef.prototype.clearVertices = function () {
                        /* clear */ (this.vertices.length = 0);
                    };
                    /**
                     * Return the vertex list as an array.
                     * @return {Array}
                     */
                    PolygonDef.prototype.getVertexArray = function () {
                        return this.vertices.slice(0);
                    };
                    /**
                     * Return the vertex list as a List<Vec2>.
                     * @return {org.jbox2d.common.Vec2[]}
                     */
                    PolygonDef.prototype.getVertexList = function () {
                        return this.vertices;
                    };
                    PolygonDef.prototype.setAsBox$float$float = function (hx, hy) {
                        /* clear */ (this.vertices.length = 0);
                        /* add */ (this.vertices.push(new org.jbox2d.common.Vec2(-hx, -hy)) > 0);
                        /* add */ (this.vertices.push(new org.jbox2d.common.Vec2(hx, -hy)) > 0);
                        /* add */ (this.vertices.push(new org.jbox2d.common.Vec2(hx, hy)) > 0);
                        /* add */ (this.vertices.push(new org.jbox2d.common.Vec2(-hx, hy)) > 0);
                    };
                    PolygonDef.prototype.setAsBox$float$float$org_jbox2d_common_Vec2$float = function (hx, hy, center, angle) {
                        this.setAsBox$float$float(hx, hy);
                        var xf = new org.jbox2d.common.XForm();
                        xf.position.set$org_jbox2d_common_Vec2(center);
                        xf.R.set$float(angle);
                        for (var i = 0; i < this.vertices.length; ++i) {
                            {
                                org.jbox2d.common.XForm.mulToOut(xf, /* get */ this.vertices[i], /* get */ this.vertices[i]);
                            }
                            ;
                        }
                    };
                    /**
                     * Build vertices to represent an oriented box.
                     * @param {number} hx the half-width.
                     * @param {number} hy the half-height.
                     * @param {org.jbox2d.common.Vec2} center the center of the box in local coordinates.
                     * @param {number} angle the rotation of the box in local coordinates.
                     */
                    PolygonDef.prototype.setAsBox = function (hx, hy, center, angle) {
                        if (((typeof hx === 'number') || hx === null) && ((typeof hy === 'number') || hy === null) && ((center != null && center instanceof org.jbox2d.common.Vec2) || center === null) && ((typeof angle === 'number') || angle === null)) {
                            return this.setAsBox$float$float$org_jbox2d_common_Vec2$float(hx, hy, center, angle);
                        }
                        else if (((typeof hx === 'number') || hx === null) && ((typeof hy === 'number') || hy === null) && center === undefined && angle === undefined) {
                            return this.setAsBox$float$float(hx, hy);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    /**
                     * Return the number of vertices.
                     * @return {number}
                     */
                    PolygonDef.prototype.getVertexCount = function () {
                        return this.vertices.length;
                    };
                    return PolygonDef;
                }(org.jbox2d.collision.shapes.ShapeDef));
                shapes.PolygonDef = PolygonDef;
                PolygonDef["__class"] = "org.jbox2d.collision.shapes.PolygonDef";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var PairManager = (function () {
                function PairManager() {
                    if (this.m_pairs === undefined)
                        this.m_pairs = null;
                    if (this.m_pairCount === undefined)
                        this.m_pairCount = 0;
                    if (this.m_hashTable === undefined)
                        this.m_hashTable = null;
                    if (this.m_broadPhase === undefined)
                        this.m_broadPhase = null;
                    if (this.m_callback === undefined)
                        this.m_callback = null;
                    if (this.m_freePair === undefined)
                        this.m_freePair = 0;
                    if (this.m_pairBuffer === undefined)
                        this.m_pairBuffer = null;
                    if (this.m_pairBufferCount === undefined)
                        this.m_pairBufferCount = 0;
                    this.m_pairs = (function (s) { var a = []; while (s-- > 0)
                        a.push(null); return a; })(org.jbox2d.common.Settings.maxPairs_$LI$());
                    this.m_hashTable = (function (s) { var a = []; while (s-- > 0)
                        a.push(0); return a; })(PairManager.TABLE_CAPACITY_$LI$());
                    this.m_pairBuffer = (function (s) { var a = []; while (s-- > 0)
                        a.push(null); return a; })(org.jbox2d.common.Settings.maxPairs_$LI$());
                    if (!(org.jbox2d.common.MathUtils.isPowerOfTwo(PairManager.TABLE_CAPACITY_$LI$()) === true))
                        throw new Error("Assertion error line 39: assert MathUtils.isPowerOfTwo(PairManager.TABLE_CAPACITY) == true;");
                    ;
                    if (!(PairManager.TABLE_CAPACITY_$LI$() >= org.jbox2d.common.Settings.maxPairs_$LI$()))
                        throw new Error("Assertion error line 40: assert PairManager.TABLE_CAPACITY >= Settings.maxPairs;");
                    ;
                    for (var i = 0; i < PairManager.TABLE_CAPACITY_$LI$(); ++i) {
                        {
                            this.m_hashTable[i] = PairManager.NULL_PAIR_$LI$();
                        }
                        ;
                    }
                    this.m_freePair = 0;
                    for (var i = 0; i < org.jbox2d.common.Settings.maxPairs_$LI$(); ++i) {
                        {
                            this.m_pairs[i] = new org.jbox2d.collision.Pair();
                            this.m_pairs[i].proxyId1 = PairManager.NULL_PROXY_$LI$();
                            this.m_pairs[i].proxyId2 = PairManager.NULL_PROXY_$LI$();
                            this.m_pairs[i].userData = null;
                            this.m_pairs[i].status = 0;
                            this.m_pairs[i].next = i + 1;
                            this.m_pairBuffer[i] = new org.jbox2d.collision.BufferedPair();
                        }
                        ;
                    }
                    this.m_pairs[org.jbox2d.common.Settings.maxPairs_$LI$() - 1].next = PairManager.NULL_PAIR_$LI$();
                    this.m_pairCount = 0;
                    this.m_pairBufferCount = 0;
                }
                PairManager.NULL_PAIR_$LI$ = function () { if (PairManager.NULL_PAIR == null)
                    PairManager.NULL_PAIR = 2147483647; return PairManager.NULL_PAIR; };
                ;
                PairManager.NULL_PROXY_$LI$ = function () { if (PairManager.NULL_PROXY == null)
                    PairManager.NULL_PROXY = 2147483647; return PairManager.NULL_PROXY; };
                ;
                PairManager.TABLE_CAPACITY_$LI$ = function () { if (PairManager.TABLE_CAPACITY == null)
                    PairManager.TABLE_CAPACITY = org.jbox2d.common.Settings.maxPairs_$LI$(); return PairManager.TABLE_CAPACITY; };
                ;
                PairManager.TABLE_MASK_$LI$ = function () { if (PairManager.TABLE_MASK == null)
                    PairManager.TABLE_MASK = PairManager.TABLE_CAPACITY_$LI$() - 1; return PairManager.TABLE_MASK; };
                ;
                PairManager.prototype.initialize = function (broadPhase, callback) {
                    this.m_broadPhase = broadPhase;
                    this.m_callback = callback;
                };
                PairManager.prototype.addPair = function (proxyId1, proxyId2) {
                    if (proxyId1 > proxyId2) {
                        proxyId1 += proxyId2;
                        proxyId2 = proxyId1 - proxyId2;
                        proxyId1 -= proxyId2;
                    }
                    var hash = this.hash(proxyId1, proxyId2) & PairManager.TABLE_MASK_$LI$();
                    var pair = this.find$int$int$int(proxyId1, proxyId2, hash);
                    if (pair != null) {
                        return pair;
                    }
                    if (!((this.m_pairCount < org.jbox2d.common.Settings.maxPairs_$LI$())))
                        throw new Error("Assertion error line 75: assert (m_pairCount < Settings.maxPairs) : 'Too many pairs (' + m_pairCount + ' shape AABB overlaps) - this usually means you have too many bodies, or you need to increase Settings.maxPairs.';");
                    ;
                    if (!((this.m_freePair !== PairManager.NULL_PAIR_$LI$())))
                        throw new Error("Assertion error line 76: assert (m_freePair != PairManager.NULL_PAIR);");
                    ;
                    var pairIndex = this.m_freePair;
                    pair = this.m_pairs[pairIndex];
                    this.m_freePair = pair.next;
                    pair.proxyId1 = proxyId1;
                    pair.proxyId2 = proxyId2;
                    pair.status = 0;
                    pair.userData = null;
                    pair.next = this.m_hashTable[hash];
                    this.m_hashTable[hash] = pairIndex;
                    ++this.m_pairCount;
                    return pair;
                };
                PairManager.prototype.removePair = function (proxyId1, proxyId2) {
                    if (!((this.m_pairCount > 0)))
                        throw new Error("Assertion error line 91: assert (m_pairCount > 0);");
                    ;
                    if (proxyId1 > proxyId2) {
                        proxyId1 += proxyId2;
                        proxyId2 = proxyId1 - proxyId2;
                        proxyId1 -= proxyId2;
                    }
                    var hash = this.hash(proxyId1, proxyId2) & PairManager.TABLE_MASK_$LI$();
                    if (org.jbox2d.collision.BroadPhase.debugPrint) {
                        console.info("removePair(" + proxyId1 + "," + proxyId2 + ") hash=" + hash);
                    }
                    var derefnode = this.m_hashTable[hash];
                    var isHash = true;
                    var pderefnode = 0;
                    while ((derefnode !== PairManager.NULL_PAIR_$LI$())) {
                        {
                            if (this.equals$org_jbox2d_collision_Pair$int$int(this.m_pairs[derefnode], proxyId1, proxyId2)) {
                                var index = derefnode;
                                if (isHash) {
                                    this.m_hashTable[hash] = this.m_pairs[this.m_hashTable[hash]].next;
                                }
                                else {
                                    this.m_pairs[pderefnode].next = this.m_pairs[derefnode].next;
                                }
                                var pair = this.m_pairs[index];
                                var userData = pair.userData;
                                pair.next = this.m_freePair;
                                pair.proxyId1 = PairManager.NULL_PROXY_$LI$();
                                pair.proxyId2 = PairManager.NULL_PROXY_$LI$();
                                pair.userData = null;
                                pair.status = 0;
                                this.m_freePair = index;
                                --this.m_pairCount;
                                return userData;
                            }
                            else {
                                pderefnode = derefnode;
                                derefnode = this.m_pairs[derefnode].next;
                                isHash = false;
                            }
                        }
                    }
                    ;
                    if (!((false)))
                        throw new Error("Assertion error line 128: assert (false) : 'Attempted to remove a pair that does not exist';");
                    ;
                    return null;
                };
                /**
                 * Buffer a pair for addition. We may add a pair that is not in the pair manager
                 * or pair buffer. We may add a pair that is already in the pair manager and
                 * pair buffer. If the added pair is not a new pair, then it must be in the pair
                 * buffer (because RemovePair was called).
                 * @param {number} id1
                 * @param {number} id2
                 */
                PairManager.prototype.addBufferedPair = function (id1, id2) {
                    if (!((id1 !== PairManager.NULL_PROXY_$LI$() && id2 !== PairManager.NULL_PROXY_$LI$())))
                        throw new Error("Assertion error line 141: assert (id1 != PairManager.NULL_PROXY && id2 != PairManager.NULL_PROXY);");
                    ;
                    if (!((this.m_pairBufferCount < org.jbox2d.common.Settings.maxPairs_$LI$())))
                        throw new Error("Assertion error line 142: assert (m_pairBufferCount < Settings.maxPairs);");
                    ;
                    var pair = this.addPair(id1, id2);
                    if (pair.isBuffered() === false) {
                        if (!((pair.isFinal() === false)))
                            throw new Error("Assertion error line 145: assert (pair.isFinal() == false);");
                        ;
                        pair.setBuffered();
                        this.m_pairBuffer[this.m_pairBufferCount].proxyId1 = pair.proxyId1;
                        this.m_pairBuffer[this.m_pairBufferCount].proxyId2 = pair.proxyId2;
                        ++this.m_pairBufferCount;
                        if (!((this.m_pairBufferCount <= this.m_pairCount)))
                            throw new Error("Assertion error line 150: assert (m_pairBufferCount <= m_pairCount);");
                        ;
                    }
                    pair.clearRemoved();
                    if (org.jbox2d.collision.BroadPhase.s_validate) {
                        this.validateBuffer();
                    }
                };
                /**
                 * Buffer a pair for removal.
                 *
                 * @param {number} id1
                 * @param {number} id2
                 */
                PairManager.prototype.removeBufferedPair = function (id1, id2) {
                    if (!((id1 !== PairManager.NULL_PROXY_$LI$() && id2 !== PairManager.NULL_PROXY_$LI$())))
                        throw new Error("Assertion error line 165: assert (id1 != PairManager.NULL_PROXY && id2 != PairManager.NULL_PROXY);");
                    ;
                    if (!((this.m_pairBufferCount < org.jbox2d.common.Settings.maxPairs_$LI$())))
                        throw new Error("Assertion error line 166: assert (m_pairBufferCount < Settings.maxPairs);");
                    ;
                    var pair = this.find$int$int(id1, id2);
                    if (pair == null) {
                        return;
                    }
                    if (pair.isBuffered() === false) {
                        if (!((pair.isFinal() === true)))
                            throw new Error("Assertion error line 172: assert (pair.isFinal() == true);");
                        ;
                        pair.setBuffered();
                        this.m_pairBuffer[this.m_pairBufferCount].proxyId1 = pair.proxyId1;
                        this.m_pairBuffer[this.m_pairBufferCount].proxyId2 = pair.proxyId2;
                        ++this.m_pairBufferCount;
                        if (!((this.m_pairBufferCount <= this.m_pairCount)))
                            throw new Error("Assertion error line 177: assert (m_pairBufferCount <= m_pairCount);");
                        ;
                    }
                    pair.setRemoved();
                    if (org.jbox2d.collision.BroadPhase.s_validate) {
                        this.validateBuffer();
                    }
                };
                /**
                 * commits the proxies
                 */
                PairManager.prototype.commit = function () {
                    var removeCount = 0;
                    var proxies = this.m_broadPhase.m_proxyPool;
                    for (var i = 0; i < this.m_pairBufferCount; ++i) {
                        {
                            var pair = this.find$int$int(this.m_pairBuffer[i].proxyId1, this.m_pairBuffer[i].proxyId2);
                            if (!((pair.isBuffered())))
                                throw new Error("Assertion error line 193: assert (pair.isBuffered());");
                            ;
                            pair.clearBuffered();
                            if (!((pair.proxyId1 < org.jbox2d.common.Settings.maxProxies && pair.proxyId2 < org.jbox2d.common.Settings.maxProxies)))
                                throw new Error("Assertion error line 195: assert (pair.proxyId1 < Settings.maxProxies && pair.proxyId2 < Settings.maxProxies);");
                            ;
                            var proxy1 = proxies[pair.proxyId1];
                            var proxy2 = proxies[pair.proxyId2];
                            if (!((proxy1.isValid())))
                                throw new Error("Assertion error line 198: assert (proxy1.isValid());");
                            ;
                            if (!((proxy2.isValid())))
                                throw new Error("Assertion error line 199: assert (proxy2.isValid());");
                            ;
                            if (pair.isRemoved()) {
                                if (pair.isFinal() === true) {
                                    this.m_callback.pairRemoved(proxy1.userData, proxy2.userData, pair.userData);
                                }
                                this.m_pairBuffer[removeCount].proxyId1 = pair.proxyId1;
                                this.m_pairBuffer[removeCount].proxyId2 = pair.proxyId2;
                                ++removeCount;
                            }
                            else {
                                if (!((this.m_broadPhase.testOverlap$org_jbox2d_collision_Proxy$org_jbox2d_collision_Proxy(proxy1, proxy2) === true)))
                                    throw new Error("Assertion error line 208: assert (m_broadPhase.testOverlap(proxy1, proxy2) == true);");
                                ;
                                if (pair.isFinal() === false) {
                                    if (org.jbox2d.collision.BroadPhase.debugPrint) {
                                        console.info("add pair " + proxy1.userData + " == " + proxy2.userData);
                                    }
                                    pair.userData = this.m_callback.pairAdded(proxy1.userData, proxy2.userData);
                                    pair.setFinal();
                                }
                            }
                        }
                        ;
                    }
                    if (org.jbox2d.collision.BroadPhase.debugPrint && removeCount > 0) {
                        console.info("pair manager removeCount=" + removeCount);
                    }
                    for (var i = 0; i < removeCount; ++i) {
                        {
                            this.removePair(this.m_pairBuffer[i].proxyId1, this.m_pairBuffer[i].proxyId2);
                        }
                        ;
                    }
                    this.m_pairBufferCount = 0;
                    if (org.jbox2d.collision.BroadPhase.s_validate) {
                        this.validateTable();
                    }
                };
                /**
                 * Unimplemented - for debugging purposes only in C++ version
                 */
                PairManager.prototype.validateBuffer = function () {
                };
                /**
                 * For debugging
                 */
                PairManager.prototype.validateTable = function () {
                    for (var i = 0; i < PairManager.TABLE_CAPACITY_$LI$(); ++i) {
                        {
                            var index = this.m_hashTable[i];
                            while ((index !== PairManager.NULL_PAIR_$LI$())) {
                                {
                                    var pair = this.m_pairs[index];
                                    if (!((pair.isBuffered() === false)))
                                        throw new Error("Assertion error line 244: assert (pair.isBuffered() == false);");
                                    ;
                                    if (!((pair.isFinal() === true)))
                                        throw new Error("Assertion error line 245: assert (pair.isFinal() == true);");
                                    ;
                                    if (!((pair.isRemoved() === false)))
                                        throw new Error("Assertion error line 246: assert (pair.isRemoved() == false);");
                                    ;
                                    if (!((pair.proxyId1 !== pair.proxyId2)))
                                        throw new Error("Assertion error line 247: assert (pair.proxyId1 != pair.proxyId2);");
                                    ;
                                    if (!((pair.proxyId1 < org.jbox2d.common.Settings.maxProxies)))
                                        throw new Error("Assertion error line 248: assert (pair.proxyId1 < Settings.maxProxies);");
                                    ;
                                    if (!((pair.proxyId2 < org.jbox2d.common.Settings.maxProxies)))
                                        throw new Error("Assertion error line 249: assert (pair.proxyId2 < Settings.maxProxies);");
                                    ;
                                    var proxy1 = this.m_broadPhase.m_proxyPool[pair.proxyId1];
                                    var proxy2 = this.m_broadPhase.m_proxyPool[pair.proxyId2];
                                    if (!((proxy1.isValid() === true)))
                                        throw new Error("Assertion error line 252: assert (proxy1.isValid() == true);");
                                    ;
                                    if (!((proxy2.isValid() === true)))
                                        throw new Error("Assertion error line 253: assert (proxy2.isValid() == true);");
                                    ;
                                    if (!((this.m_broadPhase.testOverlap$org_jbox2d_collision_Proxy$org_jbox2d_collision_Proxy(proxy1, proxy2) === true)))
                                        throw new Error("Assertion error line 254: assert (m_broadPhase.testOverlap(proxy1, proxy2) == true);");
                                    ;
                                    index = pair.next;
                                }
                            }
                            ;
                        }
                        ;
                    }
                };
                PairManager.prototype.find$int$int$int = function (proxyId1, proxyId2, hash) {
                    var index = this.m_hashTable[hash];
                    if (org.jbox2d.collision.BroadPhase.debugPrint) {
                        console.info("find(" + proxyId1 + "," + proxyId2 + ") hash=" + hash + " tableIdx=" + index);
                    }
                    while ((index !== PairManager.NULL_PAIR_$LI$() && this.equals$org_jbox2d_collision_Pair$int$int(this.m_pairs[index], proxyId1, proxyId2) === false)) {
                        {
                            index = this.m_pairs[index].next;
                        }
                    }
                    ;
                    if (index === PairManager.NULL_PAIR_$LI$()) {
                        return null;
                    }
                    if (!(index < org.jbox2d.common.Settings.maxPairs_$LI$()))
                        throw new Error("Assertion error line 271: assert index < Settings.maxPairs;");
                    ;
                    return this.m_pairs[index];
                };
                /**
                 * finds the pair with the given hash
                 *
                 * @param {number} proxyId1
                 * @param {number} proxyId2
                 * @param {number} hash
                 * @return
                 * @return {org.jbox2d.collision.Pair}
                 */
                PairManager.prototype.find = function (proxyId1, proxyId2, hash) {
                    if (((typeof proxyId1 === 'number') || proxyId1 === null) && ((typeof proxyId2 === 'number') || proxyId2 === null) && ((typeof hash === 'number') || hash === null)) {
                        return this.find$int$int$int(proxyId1, proxyId2, hash);
                    }
                    else if (((typeof proxyId1 === 'number') || proxyId1 === null) && ((typeof proxyId2 === 'number') || proxyId2 === null) && hash === undefined) {
                        return this.find$int$int(proxyId1, proxyId2);
                    }
                    else
                        throw new Error('invalid overload');
                };
                PairManager.prototype.find$int$int = function (proxyId1, proxyId2) {
                    if (proxyId1 > proxyId2) {
                        var tmp = proxyId1;
                        proxyId1 = proxyId2;
                        proxyId2 = tmp;
                    }
                    var hash = this.hash(proxyId1, proxyId2) & PairManager.TABLE_MASK_$LI$();
                    return this.find$int$int$int(proxyId1, proxyId2, hash);
                };
                /*private*/ PairManager.prototype.hash = function (proxyId1, proxyId2) {
                    var key = (proxyId2 << 16) | proxyId1;
                    key = ~key + (key << 15);
                    key = key ^ (key >>> 12);
                    key = key + (key << 2);
                    key = key ^ (key >>> 4);
                    key = key * 2057;
                    key = key ^ (key >>> 16);
                    return key;
                };
                PairManager.prototype.equals$org_jbox2d_collision_Pair$int$int = function (pair, proxyId1, proxyId2) {
                    return pair.proxyId1 === proxyId1 && pair.proxyId2 === proxyId2;
                };
                /**
                 * returns if the pair has the two proxy id's
                 *
                 * @param {org.jbox2d.collision.Pair} pair
                 * @param {number} proxyId1
                 * @param {number} proxyId2
                 * @return
                 * @return {boolean}
                 */
                PairManager.prototype.equals = function (pair, proxyId1, proxyId2) {
                    if (((pair != null && pair instanceof org.jbox2d.collision.Pair) || pair === null) && ((typeof proxyId1 === 'number') || proxyId1 === null) && ((typeof proxyId2 === 'number') || proxyId2 === null)) {
                        return this.equals$org_jbox2d_collision_Pair$int$int(pair, proxyId1, proxyId2);
                    }
                    else if (((pair != null && pair instanceof org.jbox2d.collision.BufferedPair) || pair === null) && ((proxyId1 != null && proxyId1 instanceof org.jbox2d.collision.BufferedPair) || proxyId1 === null) && proxyId2 === undefined) {
                        return this.equals$org_jbox2d_collision_BufferedPair$org_jbox2d_collision_BufferedPair(pair, proxyId1);
                    }
                    else
                        throw new Error('invalid overload');
                };
                PairManager.prototype.equals$org_jbox2d_collision_BufferedPair$org_jbox2d_collision_BufferedPair = function (pair1, pair2) {
                    return pair1.proxyId1 === pair2.proxyId1 && pair1.proxyId2 === pair2.proxyId2;
                };
                /**
                 * For sorting. Returns if the first pair's proxyid's are less than the second
                 * pair, starting with proxyId1
                 *
                 * @param {org.jbox2d.collision.BufferedPair} pair1
                 * @param {org.jbox2d.collision.BufferedPair} pair2
                 * @return
                 * @return {boolean}
                 */
                PairManager.prototype.minor = function (pair1, pair2) {
                    if (pair1.proxyId1 < pair2.proxyId1) {
                        return true;
                    }
                    if (pair1.proxyId1 === pair2.proxyId1) {
                        return pair1.proxyId2 < pair2.proxyId2;
                    }
                    return false;
                };
                return PairManager;
            }());
            collision.PairManager = PairManager;
            PairManager["__class"] = "org.jbox2d.collision.PairManager";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            /**
             * A few math methods that don't fit very well anywhere else.
             * @class
             */
            var MathUtils = (function () {
                function MathUtils() {
                }
                MathUtils.__static_initialize = function () { if (!MathUtils.__static_initialized) {
                    MathUtils.__static_initialized = true;
                    MathUtils.__static_initializer_0();
                } };
                MathUtils.PI_$LI$ = function () { MathUtils.__static_initialize(); if (MathUtils.PI == null)
                    MathUtils.PI = Math.fround(Math.PI); return MathUtils.PI; };
                ;
                MathUtils.TWOPI_$LI$ = function () { MathUtils.__static_initialize(); if (MathUtils.TWOPI == null)
                    MathUtils.TWOPI = Math.fround((Math.PI * 2)); return MathUtils.TWOPI; };
                ;
                MathUtils.sinLUT_$LI$ = function () { MathUtils.__static_initialize(); if (MathUtils.sinLUT == null)
                    MathUtils.sinLUT = (function (s) { var a = []; while (s-- > 0)
                        a.push(0); return a; })(org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$()); return MathUtils.sinLUT; };
                ;
                MathUtils.cosLUT_$LI$ = function () { MathUtils.__static_initialize(); if (MathUtils.cosLUT == null)
                    MathUtils.cosLUT = (function (s) { var a = []; while (s-- > 0)
                        a.push(0); return a; })(org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$()); return MathUtils.cosLUT; };
                ;
                MathUtils.__static_initializer_0 = function () {
                    for (var i = 0; i < org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$(); i++) {
                        {
                            MathUtils.sinLUT_$LI$()[i] = Math.fround(Math.sin(Math.fround(i * org.jbox2d.common.Settings.SINCOS_LUT_PRECISION)));
                            MathUtils.cosLUT_$LI$()[i] = Math.fround(Math.cos(Math.fround(i * org.jbox2d.common.Settings.SINCOS_LUT_PRECISION)));
                        }
                        ;
                    }
                };
                MathUtils.sin = function (x) {
                    if (org.jbox2d.common.Settings.SINCOS_LUT_ENABLED) {
                        x %= MathUtils.TWOPI_$LI$();
                        while ((x < 0)) {
                            {
                                x += MathUtils.TWOPI_$LI$();
                            }
                        }
                        ;
                        if (org.jbox2d.common.Settings.SINCOS_LUT_LERP) {
                            x /= org.jbox2d.common.Settings.SINCOS_LUT_PRECISION;
                            var index = (x | 0);
                            if (index !== 0) {
                                x %= index;
                            }
                            if (index === org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$() - 1) {
                                return (Math.fround(Math.fround((Math.fround(1 - x)) * MathUtils.sinLUT_$LI$()[index]) + Math.fround(x * MathUtils.sinLUT_$LI$()[0])));
                            }
                            else {
                                return (Math.fround(Math.fround((Math.fround(1 - x)) * MathUtils.sinLUT_$LI$()[index]) + Math.fround(x * MathUtils.sinLUT_$LI$()[index + 1])));
                            }
                        }
                        else {
                            return MathUtils.sinLUT_$LI$()[MathUtils.round(Math.fround(x / org.jbox2d.common.Settings.SINCOS_LUT_PRECISION)) % org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$()];
                        }
                    }
                    else {
                        return Math.fround(Math.sin(x));
                    }
                };
                MathUtils.cos = function (x) {
                    if (org.jbox2d.common.Settings.SINCOS_LUT_ENABLED) {
                        x %= MathUtils.TWOPI_$LI$();
                        while ((x < 0)) {
                            {
                                x += MathUtils.TWOPI_$LI$();
                            }
                        }
                        ;
                        if (org.jbox2d.common.Settings.SINCOS_LUT_LERP) {
                            x /= org.jbox2d.common.Settings.SINCOS_LUT_PRECISION;
                            var index = (x | 0);
                            if (index !== 0) {
                                x %= index;
                            }
                            if (index === org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$() - 1) {
                                return (Math.fround(Math.fround((Math.fround(1 - x)) * MathUtils.cosLUT_$LI$()[index]) + Math.fround(x * MathUtils.cosLUT_$LI$()[0])));
                            }
                            else {
                                return (Math.fround(Math.fround((Math.fround(1 - x)) * MathUtils.cosLUT_$LI$()[index]) + Math.fround(x * MathUtils.cosLUT_$LI$()[index + 1])));
                            }
                        }
                        else {
                            return MathUtils.cosLUT_$LI$()[MathUtils.round(Math.fround(x / org.jbox2d.common.Settings.SINCOS_LUT_PRECISION)) % org.jbox2d.common.Settings.SINCOS_LUT_LENGTH_$LI$()];
                        }
                    }
                    else {
                        return Math.fround(Math.cos(x));
                    }
                };
                MathUtils.abs = function (x) {
                    if (org.jbox2d.common.Settings.FAST_MATH) {
                        return x > 0 ? x : -x;
                    }
                    else {
                        return Math.abs(x);
                    }
                };
                MathUtils.floor = function (x) {
                    if (org.jbox2d.common.Settings.FAST_MATH) {
                        return x > 0 ? (x | 0) : (x | 0) - 1;
                    }
                    else {
                        return (Math.floor(x) | 0);
                    }
                };
                MathUtils.ceil = function (x) {
                    if (org.jbox2d.common.Settings.FAST_MATH) {
                        return MathUtils.floor(Math.fround(x + 0.5));
                    }
                    else {
                        return (Math.ceil(x) | 0);
                    }
                };
                MathUtils.round = function (x) {
                    if (org.jbox2d.common.Settings.FAST_MATH) {
                        return MathUtils.floor(Math.fround(x + 0.5));
                    }
                    else {
                        return Math.round(x);
                    }
                };
                MathUtils.max$float$float = function (a, b) {
                    return a > b ? a : b;
                };
                MathUtils.max$int$int = function (a, b) {
                    return a > b ? a : b;
                };
                MathUtils.max = function (a, b) {
                    if (((typeof a === 'number') || a === null) && ((typeof b === 'number') || b === null)) {
                        return org.jbox2d.common.MathUtils.max$int$int(a, b);
                    }
                    else if (((typeof a === 'number') || a === null) && ((typeof b === 'number') || b === null)) {
                        return org.jbox2d.common.MathUtils.max$float$float(a, b);
                    }
                    else
                        throw new Error('invalid overload');
                };
                MathUtils.min = function (a, b) {
                    return a < b ? a : b;
                };
                MathUtils.map = function (val, fromMin, fromMax, toMin, toMax) {
                    var mult = Math.fround((Math.fround(val - fromMin)) / (Math.fround(fromMax - fromMin)));
                    var res = Math.fround(toMin + Math.fround(mult * (Math.fround(toMax - toMin))));
                    return res;
                };
                MathUtils.clamp$float$float$float = function (a, low, high) {
                    return MathUtils.max$float$float(low, MathUtils.min(a, high));
                };
                MathUtils.clamp$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2 = function (a, low, high) {
                    var min = new org.jbox2d.common.Vec2();
                    org.jbox2d.common.Vec2.minToOut(a, high, min);
                    org.jbox2d.common.Vec2.maxToOut(low, min, min);
                    return min;
                };
                MathUtils.clamp = function (a, low, high) {
                    if (((a != null && a instanceof org.jbox2d.common.Vec2) || a === null) && ((low != null && low instanceof org.jbox2d.common.Vec2) || low === null) && ((high != null && high instanceof org.jbox2d.common.Vec2) || high === null)) {
                        return org.jbox2d.common.MathUtils.clamp$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(a, low, high);
                    }
                    else if (((typeof a === 'number') || a === null) && ((typeof low === 'number') || low === null) && ((typeof high === 'number') || high === null)) {
                        return org.jbox2d.common.MathUtils.clamp$float$float$float(a, low, high);
                    }
                    else
                        throw new Error('invalid overload');
                };
                MathUtils.clampToOut = function (a, low, high, dest) {
                    org.jbox2d.common.Vec2.minToOut(a, high, dest);
                    org.jbox2d.common.Vec2.maxToOut(low, dest, dest);
                };
                /**
                 * Next Largest Power of 2: Given a binary integer value x, the next largest
                 * power of 2 can be computed by a SWAR algorithm that recursively "folds"
                 * the upper bits into the lower bits. This process yields a bit vector with
                 * the same most significant 1 as x, but all 1's below it. Adding 1 to that
                 * value yields the next largest power of 2.
                 * @param {number} x
                 * @return {number}
                 */
                MathUtils.nextPowerOfTwo = function (x) {
                    x |= x >> 1;
                    x |= x >> 2;
                    x |= x >> 4;
                    x |= x >> 8;
                    x |= x >> 16;
                    return x + 1;
                };
                MathUtils.isPowerOfTwo = function (x) {
                    return x > 0 && (x & x - 1) === 0;
                };
                MathUtils.atan2 = function (y, x) {
                    if (org.jbox2d.common.Settings.FAST_MATH) {
                        var abs_y = Math.fround(MathUtils.abs(y) + 1.0E-10);
                        var angle = void 0;
                        var r = void 0;
                        if (x >= 0) {
                            r = Math.fround((Math.fround(x - abs_y)) / (Math.fround(x + abs_y)));
                            angle = Math.fround(Math.fround(Math.fround(Math.fround(Math.fround(0.1963 * r) * r) * r) - Math.fround(0.9817 * r)) + Math.fround(org.jbox2d.common.Settings.pi_$LI$() / 4));
                        }
                        else {
                            r = Math.fround((Math.fround(x + abs_y)) / (Math.fround(abs_y - x)));
                            angle = Math.fround(Math.fround(Math.fround(Math.fround(Math.fround(0.1963 * r) * r) * r) - Math.fround(0.9817 * r)) + Math.fround(Math.fround(3 * org.jbox2d.common.Settings.pi_$LI$()) / 4));
                        }
                        if (y < 0) {
                            return -angle;
                        }
                        else {
                            return angle;
                        }
                    }
                    else {
                        return Math.fround(Math.atan2(y, x));
                    }
                };
                /**
                 * Computes a fast approximation to <code>Math.pow(a, b)</code>.
                 * Adapted from <url>http://www.dctsystems.co.uk/Software/power.html</url>.
                 *
                 * @param {number} a
                 * a positive number
                 * @param {number} b
                 * a number
                 * @return {number} a^b
                 */
                MathUtils.pow = function (a, b) {
                    if (org.jbox2d.common.Settings.FAST_MATH) {
                        var x = (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(a);
                        x *= Math.fround(1.0 / (1 << 23));
                        x = Math.fround(x - 127);
                        var y = Math.fround(x - MathUtils.floor(x));
                        b *= Math.fround(x + Math.fround((Math.fround(y - Math.fround(y * y))) * 0.346607));
                        y = Math.fround(b - MathUtils.floor(b));
                        y = Math.fround((Math.fround(y - Math.fround(y * y))) * 0.33971);
                        return (function (v) { var buf = new ArrayBuffer(4); (new Uint32Array(buf))[0] = v; return (new Float32Array(buf))[0]; })(((Math.fround((Math.fround(Math.fround(b + 127) - y)) * (1 << 23))) | 0));
                    }
                    else {
                        return Math.fround(Math.pow(a, b));
                    }
                };
                MathUtils.sqrt = function (x) {
                    return Math.fround(Math.sqrt(x));
                };
                MathUtils.invSqrt = function (x) {
                    var xhalf = Math.fround(0.5 * x);
                    var i = (function (f) { var buf = new ArrayBuffer(4); (new Float32Array(buf))[0] = f; return (new Uint32Array(buf))[0]; })(x);
                    i = 1597463007 - (i >> 1);
                    x = (function (v) { var buf = new ArrayBuffer(4); (new Uint32Array(buf))[0] = v; return (new Float32Array(buf))[0]; })(i);
                    x *= Math.fround(1.5 - Math.fround(Math.fround(xhalf * x) * x));
                    x *= Math.fround(1.5 - Math.fround(Math.fround(xhalf * x) * x));
                    x *= Math.fround(1.5 - Math.fround(Math.fround(xhalf * x) * x));
                    x *= Math.fround(1.5 - Math.fround(Math.fround(xhalf * x) * x));
                    return x;
                };
                return MathUtils;
            }());
            MathUtils.__static_initialized = false;
            common.MathUtils = MathUtils;
            MathUtils["__class"] = "org.jbox2d.common.MathUtils";
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var util;
        (function (util) {
            var nonconvex;
            (function (nonconvex) {
                /**
                 *
                 * @author ewjordan
                 * @param {Array} _x
                 * @param {Array} _y
                 * @param {number} nVert
                 * @class
                 */
                var Polygon = (function () {
                    function Polygon(_x, _y, nVert) {
                        var _this = this;
                        if (((_x != null && _x instanceof Array && (_x.length == 0 || _x[0] == null || (typeof _x[0] === 'number'))) || _x === null) && ((_y != null && _y instanceof Array && (_y.length == 0 || _y[0] == null || (typeof _y[0] === 'number'))) || _y === null) && ((typeof nVert === 'number') || nVert === null)) {
                            var __args = arguments;
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            (function () {
                                _this.nVertices = nVert;
                                _this.x = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(_this.nVertices);
                                _this.y = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(_this.nVertices);
                                for (var i = 0; i < _this.nVertices; ++i) {
                                    {
                                        _this.x[i] = _x[i];
                                        _this.y[i] = _y[i];
                                    }
                                    ;
                                }
                                _this.areaIsSet = false;
                            })();
                        }
                        else if (((_x != null && _x instanceof Array && (_x.length == 0 || _x[0] == null || (typeof _x[0] === 'number'))) || _x === null) && ((_y != null && _y instanceof Array && (_y.length == 0 || _y[0] == null || (typeof _y[0] === 'number'))) || _y === null) && nVert === undefined) {
                            var __args = arguments;
                            {
                                var __args_8 = arguments;
                                var nVert_1 = __args_8[0].length;
                                if (this.nVertices === undefined)
                                    this.nVertices = 0;
                                if (this.x === undefined)
                                    this.x = null;
                                if (this.y === undefined)
                                    this.y = null;
                                if (this.areaIsSet === undefined)
                                    this.areaIsSet = false;
                                if (this.area === undefined)
                                    this.area = 0;
                                if (this.nVertices === undefined)
                                    this.nVertices = 0;
                                if (this.x === undefined)
                                    this.x = null;
                                if (this.y === undefined)
                                    this.y = null;
                                if (this.areaIsSet === undefined)
                                    this.areaIsSet = false;
                                if (this.area === undefined)
                                    this.area = 0;
                                (function () {
                                    _this.nVertices = nVert_1;
                                    _this.x = (function (s) { var a = []; while (s-- > 0)
                                        a.push(0); return a; })(_this.nVertices);
                                    _this.y = (function (s) { var a = []; while (s-- > 0)
                                        a.push(0); return a; })(_this.nVertices);
                                    for (var i = 0; i < _this.nVertices; ++i) {
                                        {
                                            _this.x[i] = _x[i];
                                            _this.y[i] = _y[i];
                                        }
                                        ;
                                    }
                                    _this.areaIsSet = false;
                                })();
                            }
                        }
                        else if (((_x != null && _x instanceof Array && (_x.length == 0 || _x[0] == null || (_x[0] != null && _x[0] instanceof org.jbox2d.common.Vec2))) || _x === null) && ((typeof _y === 'number') || _y === null) && nVert === undefined) {
                            var __args = arguments;
                            var v_1 = __args[0];
                            var nVert_2 = __args[1];
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            (function () {
                                _this.nVertices = nVert_2;
                                _this.x = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(_this.nVertices);
                                _this.y = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(_this.nVertices);
                                for (var i = 0; i < _this.nVertices; ++i) {
                                    {
                                        _this.x[i] = v_1[i].x;
                                        _this.y[i] = v_1[i].y;
                                    }
                                    ;
                                }
                                _this.areaIsSet = false;
                            })();
                        }
                        else if (((_x != null && _x instanceof Array && (_x.length == 0 || _x[0] == null || (_x[0] != null && _x[0] instanceof org.jbox2d.common.Vec2))) || _x === null) && _y === undefined && nVert === undefined) {
                            var __args = arguments;
                            var v_2 = __args[0];
                            {
                                var __args_9 = arguments;
                                var nVert_3 = __args_9[0].length;
                                if (this.nVertices === undefined)
                                    this.nVertices = 0;
                                if (this.x === undefined)
                                    this.x = null;
                                if (this.y === undefined)
                                    this.y = null;
                                if (this.areaIsSet === undefined)
                                    this.areaIsSet = false;
                                if (this.area === undefined)
                                    this.area = 0;
                                if (this.nVertices === undefined)
                                    this.nVertices = 0;
                                if (this.x === undefined)
                                    this.x = null;
                                if (this.y === undefined)
                                    this.y = null;
                                if (this.areaIsSet === undefined)
                                    this.areaIsSet = false;
                                if (this.area === undefined)
                                    this.area = 0;
                                (function () {
                                    _this.nVertices = nVert_3;
                                    _this.x = (function (s) { var a = []; while (s-- > 0)
                                        a.push(0); return a; })(_this.nVertices);
                                    _this.y = (function (s) { var a = []; while (s-- > 0)
                                        a.push(0); return a; })(_this.nVertices);
                                    for (var i = 0; i < _this.nVertices; ++i) {
                                        {
                                            _this.x[i] = v_2[i].x;
                                            _this.y[i] = v_2[i].y;
                                        }
                                        ;
                                    }
                                    _this.areaIsSet = false;
                                })();
                            }
                        }
                        else if (((_x != null && _x instanceof org.jbox2d.util.nonconvex.Triangle) || _x === null) && _y === undefined && nVert === undefined) {
                            var __args = arguments;
                            var t_1 = __args[0];
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            (function () {
                                _this.nVertices = 3;
                                _this.x = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(_this.nVertices);
                                _this.y = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(_this.nVertices);
                                for (var i = 0; i < _this.nVertices; ++i) {
                                    {
                                        _this.x[i] = t_1.x[i];
                                        _this.y[i] = t_1.y[i];
                                    }
                                    ;
                                }
                            })();
                        }
                        else if (_x === undefined && _y === undefined && nVert === undefined) {
                            var __args = arguments;
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            if (this.nVertices === undefined)
                                this.nVertices = 0;
                            if (this.x === undefined)
                                this.x = null;
                            if (this.y === undefined)
                                this.y = null;
                            if (this.areaIsSet === undefined)
                                this.areaIsSet = false;
                            if (this.area === undefined)
                                this.area = 0;
                            (function () {
                                _this.x = null;
                                _this.y = null;
                                _this.nVertices = 0;
                                _this.areaIsSet = false;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    Polygon.toiSlop_$LI$ = function () { if (Polygon.toiSlop == null)
                        Polygon.toiSlop = org.jbox2d.common.Settings.toiSlop_$LI$(); return Polygon.toiSlop; };
                    ;
                    Polygon.COLLAPSE_DIST_SQR_$LI$ = function () { if (Polygon.COLLAPSE_DIST_SQR == null)
                        Polygon.COLLAPSE_DIST_SQR = Math.fround(org.jbox2d.common.Settings.EPSILON * org.jbox2d.common.Settings.EPSILON); return Polygon.COLLAPSE_DIST_SQR; };
                    ;
                    Polygon.maxPolygonVertices_$LI$ = function () { if (Polygon.maxPolygonVertices == null)
                        Polygon.maxPolygonVertices = org.jbox2d.common.Settings.maxPolygonVertices; return Polygon.maxPolygonVertices; };
                    ;
                    /**
                     * Check if the lines a0->a1 and b0->b1 cross.
                     * If they do, intersectionPoint will be filled
                     * with the point of crossing.
                     *
                     * Grazing lines should not return true, though
                     * this is not very robust.
                     *
                     * @param {org.jbox2d.common.Vec2} a0
                     * @param {org.jbox2d.common.Vec2} a1
                     * @param {org.jbox2d.common.Vec2} b0
                     * @param {org.jbox2d.common.Vec2} b1
                     * @param {org.jbox2d.common.Vec2} intersectionPoint
                     * @return {boolean}
                     */
                    Polygon.intersect = function (a0, a1, b0, b1, intersectionPoint) {
                        if (a0 === b0 || a0 === b1 || a1 === b0 || a1 === b1)
                            return false;
                        var x1 = a0.x;
                        var y1 = a0.y;
                        var x2 = a1.x;
                        var y2 = a1.y;
                        var x3 = b0.x;
                        var y3 = b0.y;
                        var x4 = b1.x;
                        var y4 = b1.y;
                        if (org.jbox2d.common.MathUtils.max$float$float(x1, x2) < org.jbox2d.common.MathUtils.min(x3, x4) || org.jbox2d.common.MathUtils.max$float$float(x3, x4) < org.jbox2d.common.MathUtils.min(x1, x2))
                            return false;
                        if (org.jbox2d.common.MathUtils.max$float$float(y1, y2) < org.jbox2d.common.MathUtils.min(y3, y4) || org.jbox2d.common.MathUtils.max$float$float(y3, y4) < org.jbox2d.common.MathUtils.min(y1, y2))
                            return false;
                        var ua = (Math.fround(Math.fround((Math.fround(x4 - x3)) * (Math.fround(y1 - y3))) - Math.fround((Math.fround(y4 - y3)) * (Math.fround(x1 - x3)))));
                        var ub = (Math.fround(Math.fround((Math.fround(x2 - x1)) * (Math.fround(y1 - y3))) - Math.fround((Math.fround(y2 - y1)) * (Math.fround(x1 - x3)))));
                        var denom = Math.fround(Math.fround((Math.fround(y4 - y3)) * (Math.fround(x2 - x1))) - Math.fround((Math.fround(x4 - x3)) * (Math.fround(y2 - y1))));
                        if (org.jbox2d.common.MathUtils.abs(denom) < org.jbox2d.common.Settings.EPSILON) {
                            return false;
                        }
                        ua /= denom;
                        ub /= denom;
                        if ((0 < ua) && (ua < 1) && (0 < ub) && (ub < 1)) {
                            intersectionPoint.x = (Math.fround(x1 + Math.fround(ua * (Math.fround(x2 - x1)))));
                            intersectionPoint.y = (Math.fround(y1 + Math.fround(ua * (Math.fround(y2 - y1)))));
                            return true;
                        }
                        return false;
                    };
                    Polygon.prototype.intersect = function (a0, a1, b0, b1) {
                        var myVec = new org.jbox2d.common.Vec2(0.0, 0.0);
                        return Polygon.intersect(a0, a1, b0, b1, myVec);
                    };
                    Polygon.prototype.getArea = function () {
                        this.area = 0.0;
                        this.area += Math.fround(Math.fround(this.x[this.nVertices - 1] * this.y[0]) - Math.fround(this.x[0] * this.y[this.nVertices - 1]));
                        for (var i = 0; i < this.nVertices - 1; ++i) {
                            {
                                this.area += Math.fround(Math.fround(this.x[i] * this.y[i + 1]) - Math.fround(this.x[i + 1] * this.y[i]));
                            }
                            ;
                        }
                        this.area *= 0.5;
                        this.areaIsSet = true;
                        return this.area;
                    };
                    Polygon.prototype.isCCW = function () {
                        return (this.getArea() > 0.0);
                    };
                    Polygon.prototype.mergeParallelEdges = function (tolerance) {
                        if (this.nVertices <= 3)
                            return;
                        var mergeMe = (function (s) { var a = []; while (s-- > 0)
                            a.push(false); return a; })(this.nVertices);
                        var newNVertices = this.nVertices;
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                var lower = (i === 0) ? (this.nVertices - 1) : (i - 1);
                                var middle = i;
                                var upper = (i === this.nVertices - 1) ? (0) : (i + 1);
                                var dx0 = Math.fround(this.x[middle] - this.x[lower]);
                                var dy0 = Math.fround(this.y[middle] - this.y[lower]);
                                var dx1 = Math.fround(this.x[upper] - this.x[middle]);
                                var dy1 = Math.fround(this.y[upper] - this.y[middle]);
                                var norm0 = Math.fround(Math.sqrt(Math.fround(Math.fround(dx0 * dx0) + Math.fround(dy0 * dy0))));
                                var norm1 = Math.fround(Math.sqrt(Math.fround(Math.fround(dx1 * dx1) + Math.fround(dy1 * dy1))));
                                if (!(norm0 > 0.0 && norm1 > 0.0) && newNVertices > 3) {
                                    mergeMe[i] = true;
                                    --newNVertices;
                                }
                                dx0 /= norm0;
                                dy0 /= norm0;
                                dx1 /= norm1;
                                dy1 /= norm1;
                                var cross = Math.fround(Math.fround(dx0 * dy1) - Math.fround(dx1 * dy0));
                                var dot = Math.fround(Math.fround(dx0 * dx1) + Math.fround(dy0 * dy1));
                                if (org.jbox2d.common.MathUtils.abs(cross) < tolerance && dot > 0 && newNVertices > 3) {
                                    mergeMe[i] = true;
                                    --newNVertices;
                                }
                                else {
                                    mergeMe[i] = false;
                                }
                            }
                            ;
                        }
                        if (newNVertices === this.nVertices || newNVertices === 0) {
                            return;
                        }
                        var newx = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(newNVertices);
                        var newy = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(newNVertices);
                        var currIndex = 0;
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                if (mergeMe[i] || newNVertices === 0 || currIndex === newNVertices)
                                    continue;
                                if (!((currIndex < newNVertices)))
                                    throw new Error("Assertion error line 274: assert (currIndex < newNVertices);");
                                ;
                                newx[currIndex] = this.x[i];
                                newy[currIndex] = this.y[i];
                                ++currIndex;
                            }
                            ;
                        }
                        this.x = newx;
                        this.y = newy;
                        this.nVertices = newNVertices;
                    };
                    Polygon.prototype.getVertexVecs = function () {
                        var out = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(this.nVertices);
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                out[i] = new org.jbox2d.common.Vec2(this.x[i], this.y[i]);
                            }
                            ;
                        }
                        return out;
                    };
                    Polygon.prototype.set = function (p) {
                        if (this.nVertices !== p.nVertices) {
                            this.nVertices = p.nVertices;
                            this.x = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(this.nVertices);
                            this.y = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(this.nVertices);
                        }
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                this.x[i] = p.x[i];
                                this.y[i] = p.y[i];
                            }
                            ;
                        }
                        this.areaIsSet = false;
                    };
                    /**
                     * Assuming the polygon is simple, checks if it is convex.
                     * @return {boolean}
                     */
                    Polygon.prototype.isConvex = function () {
                        var isPositive = false;
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                var lower = (i === 0) ? (this.nVertices - 1) : (i - 1);
                                var middle = i;
                                var upper = (i === this.nVertices - 1) ? (0) : (i + 1);
                                var dx0 = Math.fround(this.x[middle] - this.x[lower]);
                                var dy0 = Math.fround(this.y[middle] - this.y[lower]);
                                var dx1 = Math.fround(this.x[upper] - this.x[middle]);
                                var dy1 = Math.fround(this.y[upper] - this.y[middle]);
                                var cross = Math.fround(Math.fround(dx0 * dy1) - Math.fround(dx1 * dy0));
                                var newIsP = (cross >= 0) ? true : false;
                                if (i === 0) {
                                    isPositive = newIsP;
                                }
                                else if (isPositive !== newIsP) {
                                    return false;
                                }
                            }
                            ;
                        }
                        return true;
                    };
                    Polygon.polyCentroid = function (vs, count) {
                        var c = new org.jbox2d.common.Vec2(0.0, 0.0);
                        var area = 0.0;
                        var inv3 = Math.fround(1.0 / 3.0);
                        var pRef = new org.jbox2d.common.Vec2(0.0, 0.0);
                        for (var i = 0; i < count; ++i) {
                            {
                                var p1 = pRef;
                                var p2 = vs[i];
                                var p3 = i + 1 < count ? vs[i + 1] : vs[0];
                                var e1 = p2.sub(p1);
                                var e2 = p3.sub(p1);
                                var D = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(e1, e2);
                                var triangleArea = Math.fround(0.5 * D);
                                area += triangleArea;
                                c.x += Math.fround(Math.fround(triangleArea * inv3) * (Math.fround(Math.fround(p1.x + p2.x) + p3.x)));
                                c.y += Math.fround(Math.fround(triangleArea * inv3) * (Math.fround(Math.fround(p1.y + p2.y) + p3.y)));
                            }
                            ;
                        }
                        c.x *= Math.fround(1.0 / area);
                        c.y *= Math.fround(1.0 / area);
                        return c;
                    };
                    Polygon.prototype.isUsable$boolean = function (printErrors) {
                        var error = -1;
                        var noError = true;
                        if (this.nVertices < 3 || this.nVertices > Polygon.maxPolygonVertices_$LI$()) {
                            noError = false;
                            error = 0;
                        }
                        if (!this.isConvex()) {
                            noError = false;
                            error = 1;
                        }
                        if (!this.isSimple()) {
                            noError = false;
                            error = 2;
                        }
                        if (this.getArea() < org.jbox2d.common.Settings.EPSILON) {
                            noError = false;
                            error = 3;
                        }
                        var normals = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(this.nVertices);
                        var vertices = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(this.nVertices);
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                vertices[i] = new org.jbox2d.common.Vec2(this.x[i], this.y[i]);
                                var i1 = i;
                                var i2 = i + 1 < this.nVertices ? i + 1 : 0;
                                var edge = new org.jbox2d.common.Vec2(Math.fround(this.x[i2] - this.x[i1]), Math.fround(this.y[i2] - this.y[i1]));
                                normals[i] = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$float(edge, 1.0);
                                normals[i].normalize();
                            }
                            ;
                        }
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                var iminus = (i === 0) ? this.nVertices - 1 : i - 1;
                                var cross = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(normals[iminus], normals[i]);
                                cross = org.jbox2d.common.MathUtils.clamp$float$float$float(cross, -1.0, 1.0);
                                var angle = Math.fround(Math.asin(cross));
                                if (angle <= org.jbox2d.common.Settings.angularSlop_$LI$()) {
                                    noError = false;
                                    error = 4;
                                    break;
                                }
                                for (var j = 0; j < this.nVertices; ++j) {
                                    {
                                        if (j === i || j === (i + 1) % this.nVertices) {
                                            continue;
                                        }
                                        var s = org.jbox2d.common.Vec2.dot(normals[i], vertices[j].sub(vertices[i]));
                                        if (s >= -org.jbox2d.common.Settings.linearSlop_$LI$()) {
                                            noError = false;
                                            error = 5;
                                        }
                                    }
                                    ;
                                }
                                var centroid = Polygon.polyCentroid(vertices, this.nVertices);
                                var n1 = normals[iminus];
                                var n2 = normals[i];
                                var v = vertices[i].sub(centroid);
                                var d = new org.jbox2d.common.Vec2();
                                d.x = Math.fround(org.jbox2d.common.Vec2.dot(n1, v) - Polygon.toiSlop_$LI$());
                                d.y = Math.fround(org.jbox2d.common.Vec2.dot(n2, v) - Polygon.toiSlop_$LI$());
                                if ((d.x < 0.0) || (d.y < 0.0)) {
                                    noError = false;
                                    error = 6;
                                }
                            }
                            ;
                        }
                        if (!noError && printErrors) {
                            console.info("Found invalid polygon, ");
                            switch ((error)) {
                                case 0:
                                    console.info("must have between 3 and " + org.jbox2d.common.Settings.maxPolygonVertices + " vertices.");
                                    break;
                                case 1:
                                    console.info("must be convex.\n");
                                    break;
                                case 2:
                                    console.info("must be simple (cannot intersect itself).\n");
                                    break;
                                case 3:
                                    console.info("area is too small.\n");
                                    break;
                                case 4:
                                    console.info("sides are too close to parallel.\n");
                                    break;
                                case 5:
                                    console.info("polygon is too thin.\n");
                                    break;
                                case 6:
                                    console.info("core shape generation would move edge past centroid (too thin).\n");
                                    break;
                                default:
                                    console.info("don\'t know why.\n");
                                    if (!(false))
                                        throw new Error("Assertion error line 439: assert false;");
                                    ;
                            }
                        }
                        return noError;
                    };
                    /**
                     * Checks if polygon is valid for use in Box2d engine.
                     * Last ditch effort to ensure no invalid polygons are
                     * added to world geometry.
                     *
                     * Performs a full check, for simplicity, convexity,
                     * orientation, minimum angle, and volume.  This won't
                     * be very efficient, and a lot of it is redundant when
                     * other tools in this section are used.
                     * @param {boolean} printErrors
                     * @return {boolean}
                     */
                    Polygon.prototype.isUsable = function (printErrors) {
                        if (((typeof printErrors === 'boolean') || printErrors === null)) {
                            return this.isUsable$boolean(printErrors);
                        }
                        else if (printErrors === undefined) {
                            return this.isUsable$();
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    Polygon.prototype.isUsable$ = function () {
                        return this.isUsable$boolean(Polygon.B2_POLYGON_REPORT_ERRORS);
                    };
                    Polygon.prototype.isSimple = function () {
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                var iplus = (i + 1 > this.nVertices - 1) ? 0 : i + 1;
                                var a1 = new org.jbox2d.common.Vec2(this.x[i], this.y[i]);
                                var a2 = new org.jbox2d.common.Vec2(this.x[iplus], this.y[iplus]);
                                for (var j = i + 1; j < this.nVertices; ++j) {
                                    {
                                        var jplus = (j + 1 > this.nVertices - 1) ? 0 : j + 1;
                                        var b1 = new org.jbox2d.common.Vec2(this.x[j], this.y[j]);
                                        var b2 = new org.jbox2d.common.Vec2(this.x[jplus], this.y[jplus]);
                                        if (this.intersect(a1, a2, b1, b2)) {
                                            return false;
                                        }
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                        return true;
                    };
                    /**
                     * Tries to add a triangle to the polygon. Returns null if it can't connect
                     * properly, otherwise returns a pointer to the new Polygon. Assumes bitwise
                     * equality of joined vertex positions.
                     *
                     * Remember to delete the pointer afterwards.
                     * TODO: Make this return a Polygon instead
                     * of a pointer to a heap-allocated one.
                     *
                     * For internal use.
                     * @param {org.jbox2d.util.nonconvex.Triangle} t
                     * @return {org.jbox2d.util.nonconvex.Polygon}
                     */
                    Polygon.prototype.add = function (t) {
                        var firstP = -1;
                        var firstT = -1;
                        var secondP = -1;
                        var secondT = -1;
                        for (var i = 0; i < this.nVertices; i++) {
                            {
                                if (t.x[0] === this.x[i] && t.y[0] === this.y[i]) {
                                    if (firstP === -1) {
                                        firstP = i;
                                        firstT = 0;
                                    }
                                    else {
                                        secondP = i;
                                        secondT = 0;
                                    }
                                }
                                else if (t.x[1] === this.x[i] && t.y[1] === this.y[i]) {
                                    if (firstP === -1) {
                                        firstP = i;
                                        firstT = 1;
                                    }
                                    else {
                                        secondP = i;
                                        secondT = 1;
                                    }
                                }
                                else if (t.x[2] === this.x[i] && t.y[2] === this.y[i]) {
                                    if (firstP === -1) {
                                        firstP = i;
                                        firstT = 2;
                                    }
                                    else {
                                        secondP = i;
                                        secondT = 2;
                                    }
                                }
                                else {
                                }
                            }
                            ;
                        }
                        if (firstP === 0 && secondP === this.nVertices - 1) {
                            firstP = this.nVertices - 1;
                            secondP = 0;
                        }
                        if (secondP === -1) {
                            return null;
                        }
                        var tipT = 0;
                        if (tipT === firstT || tipT === secondT)
                            tipT = 1;
                        if (tipT === firstT || tipT === secondT)
                            tipT = 2;
                        var newx = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(this.nVertices + 1);
                        var newy = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(this.nVertices + 1);
                        var currOut = 0;
                        for (var i = 0; i < this.nVertices; i++) {
                            {
                                newx[currOut] = this.x[i];
                                newy[currOut] = this.y[i];
                                if (i === firstP) {
                                    ++currOut;
                                    newx[currOut] = t.x[tipT];
                                    newy[currOut] = t.y[tipT];
                                }
                                ++currOut;
                            }
                            ;
                        }
                        var result = new Polygon(newx, newy, this.nVertices + 1);
                        return result;
                    };
                    /**
                     * Adds this polygon to a PolyDef.
                     * @param {org.jbox2d.collision.shapes.PolygonDef} pd
                     */
                    Polygon.prototype.addTo = function (pd) {
                        if (this.nVertices < 3)
                            return;
                        var vecs = this.getVertexVecs();
                        if (!((this.nVertices <= org.jbox2d.common.Settings.maxPolygonVertices)))
                            throw new Error("Assertion error line 566: assert (nVertices <= Settings.maxPolygonVertices);");
                        ;
                        var offset = 0;
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                if (vecs[i].x === vecs[Polygon.remainder(i + 1, this.nVertices)].x && vecs[i].y === vecs[Polygon.remainder(i + 1, this.nVertices)].y) {
                                    offset++;
                                    continue;
                                }
                                /* add */ (pd.vertices.push(vecs[i]) > 0);
                            }
                            ;
                        }
                    };
                    /**
                     * Finds and fixes "pinch points," points where two polygon
                     * vertices are at the same point.
                     *
                     * If a pinch point is found, pin is broken up into poutA and poutB
                     * and true is returned; otherwise, returns false.
                     *
                     * Mostly for internal use.
                     *
                     * O(N^2) time, which sucks...
                     * @param {org.jbox2d.util.nonconvex.Polygon} pin
                     * @param {org.jbox2d.util.nonconvex.Polygon} poutA
                     * @param {org.jbox2d.util.nonconvex.Polygon} poutB
                     * @return {boolean}
                     * @private
                     */
                    /*private*/ Polygon.resolvePinchPoint = function (pin, poutA, poutB) {
                        if (pin.nVertices < 3)
                            return false;
                        var tol = 0.001;
                        var hasPinchPoint = false;
                        var pinchIndexA = -1;
                        var pinchIndexB = -1;
                        for (var i = 0; i < pin.nVertices; ++i) {
                            {
                                for (var j = i + 1; j < pin.nVertices; ++j) {
                                    {
                                        if (org.jbox2d.common.MathUtils.abs(Math.fround(pin.x[i] - pin.x[j])) < tol && org.jbox2d.common.MathUtils.abs(Math.fround(pin.y[i] - pin.y[j])) < tol && j !== i + 1) {
                                            pinchIndexA = i;
                                            pinchIndexB = j;
                                            hasPinchPoint = true;
                                            break;
                                        }
                                    }
                                    ;
                                }
                                if (hasPinchPoint)
                                    break;
                            }
                            ;
                        }
                        if (hasPinchPoint) {
                            var sizeA = pinchIndexB - pinchIndexA;
                            if (sizeA === pin.nVertices)
                                return false;
                            var xA = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(sizeA);
                            var yA = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(sizeA);
                            for (var i = 0; i < sizeA; ++i) {
                                {
                                    var ind = Polygon.remainder(pinchIndexA + i, pin.nVertices);
                                    xA[i] = pin.x[ind];
                                    yA[i] = pin.y[ind];
                                }
                                ;
                            }
                            var tempA = new Polygon(xA, yA, sizeA);
                            poutA.set(tempA);
                            var sizeB = pin.nVertices - sizeA;
                            var xB = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(sizeB);
                            var yB = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(sizeB);
                            for (var i = 0; i < sizeB; ++i) {
                                {
                                    var ind = Polygon.remainder(pinchIndexB + i, pin.nVertices);
                                    xB[i] = pin.x[ind];
                                    yB[i] = pin.y[ind];
                                }
                                ;
                            }
                            var tempB = new Polygon(xB, yB, sizeB);
                            poutB.set(tempB);
                        }
                        return hasPinchPoint;
                    };
                    /**
                     * Triangulates a polygon using simple ear-clipping algorithm. Returns
                     * size of Triangle array unless the polygon can't be triangulated.
                     * This should only happen if the polygon self-intersects,
                     * though it will not _always_ return null for a bad polygon - it is the
                     * caller's responsibility to check for self-intersection, and if it
                     * doesn't, it should at least check that the return value is non-null
                     * before using. You're warned!
                     *
                     * Triangles may be degenerate, especially if you have identical points
                     * in the input to the algorithm.  Check this before you use them.
                     *
                     * This is totally unoptimized, so for large polygons it should not be part
                     * of the simulation loop.
                     *
                     * Returns:
                     * -1 if algorithm fails (self-intersection most likely)
                     * 0 if there are not enough vertices to triangulate anything.
                     * Number of triangles if triangulation was successful.
                     *
                     * results will be filled with results - ear clipping always creates vNum - 2
                     * or fewer (due to pinch point polygon snipping), so allocate an array of
                     * this size.
                     * @param {Array} xv
                     * @param {Array} yv
                     * @param {number} vNum
                     * @param {Array} results
                     * @return {number}
                     */
                    Polygon.triangulatePolygon = function (xv, yv, vNum, results) {
                        if (vNum < 3)
                            return 0;
                        var pA = new Polygon();
                        var pB = new Polygon();
                        var pin = new Polygon(xv, yv, vNum);
                        if (Polygon.resolvePinchPoint(pin, pA, pB)) {
                            var mergeA = (function (s) { var a = []; while (s-- > 0)
                                a.push(null); return a; })(pA.nVertices);
                            var mergeB = (function (s) { var a = []; while (s-- > 0)
                                a.push(null); return a; })(pB.nVertices);
                            for (var i = 0; i < pA.nVertices; ++i) {
                                {
                                    mergeA[i] = new org.jbox2d.util.nonconvex.Triangle();
                                }
                                ;
                            }
                            for (var i = 0; i < pB.nVertices; ++i) {
                                {
                                    mergeB[i] = new org.jbox2d.util.nonconvex.Triangle();
                                }
                                ;
                            }
                            var nA = Polygon.triangulatePolygon(pA.x, pA.y, pA.nVertices, mergeA);
                            var nB = Polygon.triangulatePolygon(pB.x, pB.y, pB.nVertices, mergeB);
                            if (nA === -1 || nB === -1) {
                                return -1;
                            }
                            for (var i = 0; i < nA; ++i) {
                                {
                                    results[i].set(mergeA[i]);
                                }
                                ;
                            }
                            for (var i = 0; i < nB; ++i) {
                                {
                                    results[nA + i].set(mergeB[i]);
                                }
                                ;
                            }
                            return (nA + nB);
                        }
                        var buffer = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(vNum - 2);
                        for (var i = 0; i < buffer.length; ++i) {
                            {
                                buffer[i] = new org.jbox2d.util.nonconvex.Triangle();
                            }
                            ;
                        }
                        var bufferSize = 0;
                        var xrem = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(vNum);
                        var yrem = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(vNum);
                        for (var i = 0; i < vNum; ++i) {
                            {
                                xrem[i] = xv[i];
                                yrem[i] = yv[i];
                            }
                            ;
                        }
                        var xremLength = vNum;
                        while ((vNum > 3)) {
                            {
                                var earIndex = -1;
                                var earMaxMinCross = -1000.0;
                                for (var i = 0; i < vNum; ++i) {
                                    {
                                        if (Polygon.isEar(i, xrem, yrem, vNum)) {
                                            var lower = Polygon.remainder(i - 1, vNum);
                                            var upper = Polygon.remainder(i + 1, vNum);
                                            var d1 = new org.jbox2d.common.Vec2(Math.fround(xrem[upper] - xrem[i]), Math.fround(yrem[upper] - yrem[i]));
                                            var d2 = new org.jbox2d.common.Vec2(Math.fround(xrem[i] - xrem[lower]), Math.fround(yrem[i] - yrem[lower]));
                                            var d3 = new org.jbox2d.common.Vec2(Math.fround(xrem[lower] - xrem[upper]), Math.fround(yrem[lower] - yrem[upper]));
                                            d1.normalize();
                                            d2.normalize();
                                            d3.normalize();
                                            var cross12 = org.jbox2d.common.MathUtils.abs(org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(d1, d2));
                                            var cross23 = org.jbox2d.common.MathUtils.abs(org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(d2, d3));
                                            var cross31 = org.jbox2d.common.MathUtils.abs(org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(d3, d1));
                                            var minCross = org.jbox2d.common.MathUtils.min(cross12, org.jbox2d.common.MathUtils.min(cross23, cross31));
                                            if (minCross > earMaxMinCross) {
                                                earIndex = i;
                                                earMaxMinCross = minCross;
                                            }
                                        }
                                    }
                                    ;
                                }
                                if (earIndex === -1) {
                                    if (Polygon.B2_POLYGON_REPORT_ERRORS) {
                                        var dump = new Polygon(xrem, yrem, vNum);
                                        console.info("Couldn\'t find an ear, dumping remaining poly:\n");
                                        dump.printFormatted();
                                        console.info("Please submit this dump to ewjordan at Box2d forums\n");
                                    }
                                    for (var i = 0; i < bufferSize; i++) {
                                        {
                                            results[i].set(buffer[i]);
                                        }
                                        ;
                                    }
                                    if (bufferSize > 0)
                                        return bufferSize;
                                    else
                                        return -1;
                                }
                                --vNum;
                                var newx = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(vNum);
                                var newy = (function (s) { var a = []; while (s-- > 0)
                                    a.push(0); return a; })(vNum);
                                var currDest = 0;
                                for (var i = 0; i < vNum; ++i) {
                                    {
                                        if (currDest === earIndex)
                                            ++currDest;
                                        newx[i] = xrem[currDest];
                                        newy[i] = yrem[currDest];
                                        ++currDest;
                                    }
                                    ;
                                }
                                var under = (earIndex === 0) ? (vNum) : (earIndex - 1);
                                var over = (earIndex === vNum) ? 0 : (earIndex + 1);
                                var toAdd_1 = new org.jbox2d.util.nonconvex.Triangle(xrem[earIndex], yrem[earIndex], xrem[over], yrem[over], xrem[under], yrem[under]);
                                buffer[bufferSize] = toAdd_1;
                                ++bufferSize;
                                xrem = newx;
                                yrem = newy;
                            }
                        }
                        ;
                        var toAdd = new org.jbox2d.util.nonconvex.Triangle(xrem[1], yrem[1], xrem[2], yrem[2], xrem[0], yrem[0]);
                        buffer[bufferSize] = toAdd;
                        ++bufferSize;
                        if (!((bufferSize === xremLength - 2)))
                            throw new Error("Assertion error line 760: assert (bufferSize == xremLength - 2);");
                        ;
                        for (var i = 0; i < bufferSize; i++) {
                            {
                                results[i].set(buffer[i]);
                            }
                            ;
                        }
                        return bufferSize;
                    };
                    /**
                     * Turns a list of triangles into a list of convex polygons. Very simple
                     * method - start with a seed triangle, keep adding triangles to it until
                     * you can't add any more without making the polygon non-convex.
                     *
                     * Returns an integer telling how many polygons were created.  Will fill
                     * polys array up to polysLength entries, which may be smaller or larger
                     * than the return value.
                     *
                     * Takes O(N*P) where P is the number of resultant polygons, N is triangle
                     * count.
                     *
                     * The final polygon list will not necessarily be minimal, though in
                     * practice it works fairly well.
                     * @param {Array} triangulated
                     * @param {number} triangulatedLength
                     * @param {Array} polys
                     * @param {number} polysLength
                     * @return {number}
                     */
                    Polygon.polygonizeTriangles = function (triangulated, triangulatedLength, polys, polysLength) {
                        var polyIndex = 0;
                        if (triangulatedLength <= 0) {
                            return 0;
                        }
                        else {
                            var covered = (function (s) { var a = []; while (s-- > 0)
                                a.push(0); return a; })(triangulatedLength);
                            for (var i = 0; i < triangulatedLength; ++i) {
                                {
                                    covered[i] = 0;
                                    if (((triangulated[i].x[0] === triangulated[i].x[1]) && (triangulated[i].y[0] === triangulated[i].y[1])) || ((triangulated[i].x[1] === triangulated[i].x[2]) && (triangulated[i].y[1] === triangulated[i].y[2])) || ((triangulated[i].x[0] === triangulated[i].x[2]) && (triangulated[i].y[0] === triangulated[i].y[2]))) {
                                        covered[i] = 1;
                                    }
                                }
                                ;
                            }
                            var notDone = true;
                            while ((notDone)) {
                                {
                                    var currTri = -1;
                                    for (var i = 0; i < triangulatedLength; ++i) {
                                        {
                                            if (covered[i] !== 0)
                                                continue;
                                            currTri = i;
                                            break;
                                        }
                                        ;
                                    }
                                    if (currTri === -1) {
                                        notDone = false;
                                    }
                                    else {
                                        var poly = new Polygon(triangulated[currTri]);
                                        covered[currTri] = 1;
                                        var index = 0;
                                        for (var i = 0; i < 2 * triangulatedLength; ++i, ++index) {
                                            {
                                                while ((index >= triangulatedLength)) {
                                                    index -= triangulatedLength;
                                                }
                                                ;
                                                if (covered[index] !== 0) {
                                                    continue;
                                                }
                                                var newP = poly.add(triangulated[index]);
                                                if (newP == null) {
                                                    continue;
                                                }
                                                if (newP.nVertices > Polygon.maxPolygonVertices_$LI$()) {
                                                    newP = null;
                                                    continue;
                                                }
                                                if (newP.isConvex()) {
                                                    poly.set(newP);
                                                    newP = null;
                                                    covered[index] = 1;
                                                }
                                                else {
                                                    newP = null;
                                                }
                                            }
                                            ;
                                        }
                                        if (polyIndex < polysLength) {
                                            poly.mergeParallelEdges(org.jbox2d.common.Settings.angularSlop_$LI$());
                                            if (poly.nVertices >= 3)
                                                polys[polyIndex].set(poly);
                                        }
                                        if (poly.nVertices >= 3)
                                            polyIndex++;
                                    }
                                }
                            }
                            ;
                        }
                        return polyIndex;
                    };
                    /**
                     * Checks if vertex i is the tip of an ear in polygon defined by xv[] and
                     * yv[].
                     *
                     * Assumes clockwise orientation of polygon...ick
                     * @param {number} i
                     * @param {Array} xv
                     * @param {Array} yv
                     * @param {number} xvLength
                     * @return {boolean}
                     * @private
                     */
                    /*private*/ Polygon.isEar = function (i, xv, yv, xvLength) {
                        var dx0;
                        var dy0;
                        var dx1;
                        var dy1;
                        dx0 = dy0 = dx1 = dy1 = 0;
                        if (i >= xvLength || i < 0 || xvLength < 3) {
                            return false;
                        }
                        var upper = i + 1;
                        var lower = i - 1;
                        if (i === 0) {
                            dx0 = Math.fround(xv[0] - xv[xvLength - 1]);
                            dy0 = Math.fround(yv[0] - yv[xvLength - 1]);
                            dx1 = Math.fround(xv[1] - xv[0]);
                            dy1 = Math.fround(yv[1] - yv[0]);
                            lower = xvLength - 1;
                        }
                        else if (i === xvLength - 1) {
                            dx0 = Math.fround(xv[i] - xv[i - 1]);
                            dy0 = Math.fround(yv[i] - yv[i - 1]);
                            dx1 = Math.fround(xv[0] - xv[i]);
                            dy1 = Math.fround(yv[0] - yv[i]);
                            upper = 0;
                        }
                        else {
                            dx0 = Math.fround(xv[i] - xv[i - 1]);
                            dy0 = Math.fround(yv[i] - yv[i - 1]);
                            dx1 = Math.fround(xv[i + 1] - xv[i]);
                            dy1 = Math.fround(yv[i + 1] - yv[i]);
                        }
                        var cross = Math.fround(Math.fround(dx0 * dy1) - Math.fround(dx1 * dy0));
                        if (cross > 0)
                            return false;
                        var myTri = new org.jbox2d.util.nonconvex.Triangle(xv[i], yv[i], xv[upper], yv[upper], xv[lower], yv[lower]);
                        for (var j = 0; j < xvLength; ++j) {
                            {
                                if (j === i || j === lower || j === upper)
                                    continue;
                                if (myTri.containsPoint(xv[j], yv[j]))
                                    return false;
                            }
                            ;
                        }
                        return true;
                    };
                    Polygon.reversePolygon$org_jbox2d_util_nonconvex_Polygon = function (p) {
                        Polygon.reversePolygon$float_A$float_A$int(p.x, p.y, p.nVertices);
                        if (p.areaIsSet)
                            p.area *= -1;
                    };
                    Polygon.reversePolygon$float_A$float_A$int = function (x, y, n) {
                        if (n === 1)
                            return;
                        var low = 0;
                        var high = n - 1;
                        while ((low < high)) {
                            {
                                var buffer = x[low];
                                x[low] = x[high];
                                x[high] = buffer;
                                buffer = y[low];
                                y[low] = y[high];
                                y[high] = buffer;
                                ++low;
                                --high;
                            }
                        }
                        ;
                    };
                    Polygon.reversePolygon = function (x, y, n) {
                        if (((x != null && x instanceof Array && (x.length == 0 || x[0] == null || (typeof x[0] === 'number'))) || x === null) && ((y != null && y instanceof Array && (y.length == 0 || y[0] == null || (typeof y[0] === 'number'))) || y === null) && ((typeof n === 'number') || n === null)) {
                            return org.jbox2d.util.nonconvex.Polygon.reversePolygon$float_A$float_A$int(x, y, n);
                        }
                        else if (((x != null && x instanceof org.jbox2d.util.nonconvex.Polygon) || x === null) && y === undefined && n === undefined) {
                            return org.jbox2d.util.nonconvex.Polygon.reversePolygon$org_jbox2d_util_nonconvex_Polygon(x);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    /**
                     * Decomposes a non-convex polygon into a number of convex polygons, up
                     * to maxPolys (remaining pieces are thrown out, but the total number
                     * is returned, so the return value can be greater than maxPolys).
                     *
                     * Each resulting polygon will have no more than maxVerticesPerPolygon
                     * vertices (set to b2MaxPolyVertices by default, though you can change
                     * this).
                     *
                     * Returns -1 if operation fails (usually due to self-intersection of
                     * polygon).
                     * @param {org.jbox2d.util.nonconvex.Polygon} p
                     * @param {Array} results
                     * @param {number} maxPolys
                     * @return {number}
                     */
                    Polygon.decomposeConvex = function (p, results, maxPolys) {
                        if (p.nVertices < 3)
                            return 0;
                        var triangulated = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(p.nVertices - 2);
                        for (var i = 0; i < triangulated.length; ++i) {
                            {
                                triangulated[i] = new org.jbox2d.util.nonconvex.Triangle();
                            }
                            ;
                        }
                        var nTri;
                        if (p.isCCW()) {
                            var tempP = new Polygon();
                            tempP.set(p);
                            Polygon.reversePolygon$float_A$float_A$int(tempP.x, tempP.y, tempP.nVertices);
                            nTri = Polygon.triangulatePolygon(tempP.x, tempP.y, tempP.nVertices, triangulated);
                        }
                        else {
                            nTri = Polygon.triangulatePolygon(p.x, p.y, p.nVertices, triangulated);
                        }
                        if (nTri < 1) {
                            return -1;
                        }
                        var nPolys = Polygon.polygonizeTriangles(triangulated, nTri, results, maxPolys);
                        return nPolys;
                    };
                    /**
                     * Decomposes a polygon into convex polygons and adds all pieces to a b2BodyDef
                     * using a prototype b2PolyDef. All fields of the prototype are used for every
                     * shape except the vertices (friction, restitution, density, filter, etc).
                     *
                     * If you want finer control, you'll have to add everything by hand.
                     *
                     * This is the simplest method to add a complicated polygon to a body.
                     * @param {org.jbox2d.util.nonconvex.Polygon} p
                     * @param {org.jbox2d.dynamics.Body} bd
                     * @param {org.jbox2d.collision.shapes.PolygonDef} prototype
                     */
                    Polygon.decomposeConvexAndAddTo = function (p, bd, prototype) {
                        if (p.nVertices < 3)
                            return;
                        var decomposed = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(p.nVertices - 2);
                        for (var i = 0; i < decomposed.length; ++i) {
                            {
                                decomposed[i] = new Polygon();
                            }
                            ;
                        }
                        var nPolys = Polygon.decomposeConvex(p, decomposed, p.nVertices - 2);
                        var pdarray = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(2 * p.nVertices);
                        for (var i = 0; i < pdarray.length; ++i) {
                            {
                                pdarray[i] = new org.jbox2d.collision.shapes.PolygonDef();
                            }
                            ;
                        }
                        var extra = 0;
                        for (var i = 0; i < nPolys; ++i) {
                            {
                                var toAdd = pdarray[i + extra];
                                toAdd.set(prototype);
                                var curr = decomposed[i];
                                if (curr.nVertices === 3) {
                                    for (var j = 0; j < 3; ++j) {
                                        {
                                            var lower = (j === 0) ? (curr.nVertices - 1) : (j - 1);
                                            var middle = j;
                                            var upper = (j === curr.nVertices - 1) ? (0) : (j + 1);
                                            var dx0 = Math.fround(curr.x[middle] - curr.x[lower]);
                                            var dy0 = Math.fround(curr.y[middle] - curr.y[lower]);
                                            var dx1 = Math.fround(curr.x[upper] - curr.x[middle]);
                                            var dy1 = Math.fround(curr.y[upper] - curr.y[middle]);
                                            var norm0 = Math.fround(Math.sqrt(Math.fround(Math.fround(dx0 * dx0) + Math.fround(dy0 * dy0))));
                                            var norm1 = Math.fround(Math.sqrt(Math.fround(Math.fround(dx1 * dx1) + Math.fround(dy1 * dy1))));
                                            if (!(norm0 > 0.0 && norm1 > 0.0)) {
                                                continue;
                                            }
                                            dx0 /= norm0;
                                            dy0 /= norm0;
                                            dx1 /= norm1;
                                            dy1 /= norm1;
                                            var cross = Math.fround(Math.fround(dx0 * dy1) - Math.fround(dx1 * dy0));
                                            var dot = Math.fround(Math.fround(dx0 * dx1) + Math.fround(dy0 * dy1));
                                            if (org.jbox2d.common.MathUtils.abs(cross) < org.jbox2d.common.Settings.angularSlop_$LI$() && dot > 0) {
                                                var dx2 = Math.fround(curr.x[lower] - curr.x[upper]);
                                                var dy2 = Math.fround(curr.y[lower] - curr.y[upper]);
                                                var norm2 = Math.fround(Math.sqrt(Math.fround(Math.fround(dx2 * dx2) + Math.fround(dy2 * dy2))));
                                                if (norm2 === 0.0) {
                                                    continue;
                                                }
                                                dx2 /= norm2;
                                                dy2 /= norm2;
                                                var thisArea = curr.getArea();
                                                var thisHeight = Math.fround(Math.fround(2.0 * thisArea) / norm2);
                                                var buffer2 = dx2;
                                                dx2 = dy2;
                                                dy2 = -buffer2;
                                                var newX1 = [Math.fround(curr.x[middle] + Math.fround(dx2 * thisHeight)), curr.x[lower], curr.x[middle]];
                                                var newY1 = [Math.fround(curr.y[middle] + Math.fround(dy2 * thisHeight)), curr.y[lower], curr.y[middle]];
                                                var newX2 = [newX1[0], curr.x[middle], curr.x[upper]];
                                                var newY2 = [newY1[0], curr.y[middle], curr.y[upper]];
                                                var p1 = new Polygon(newX1, newY1, 3);
                                                var p2 = new Polygon(newX2, newY2, 3);
                                                if (p1.isUsable()) {
                                                    p1.addTo(toAdd);
                                                    bd.createShape(toAdd);
                                                    ++extra;
                                                }
                                                else if (Polygon.B2_POLYGON_REPORT_ERRORS) {
                                                    console.error("Didn\'t add unusable polygon.  Dumping vertices:\n");
                                                    p1.print();
                                                }
                                                if (p2.isUsable()) {
                                                    p2.addTo(pdarray[i + extra]);
                                                    bd.createShape(pdarray[i + extra]);
                                                }
                                                else if (Polygon.B2_POLYGON_REPORT_ERRORS) {
                                                    console.error("Didn\'t add unusable polygon.  Dumping vertices:\n");
                                                    p2.print();
                                                }
                                                continue;
                                            }
                                        }
                                        ;
                                    }
                                }
                                if (decomposed[i].isUsable()) {
                                    decomposed[i].addTo(toAdd);
                                    bd.createShape(toAdd);
                                }
                                else if (Polygon.B2_POLYGON_REPORT_ERRORS) {
                                    console.info("Didn\'t add unusable polygon.  Dumping vertices:\n");
                                    decomposed[i].print();
                                }
                            }
                            ;
                        }
                        return;
                    };
                    Polygon.convexHull$org_jbox2d_common_Vec2_A$int = function (v, nVert) {
                        var cloudX = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(nVert);
                        var cloudY = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(nVert);
                        for (var i = 0; i < nVert; ++i) {
                            {
                                cloudX[i] = v[i].x;
                                cloudY[i] = v[i].y;
                            }
                            ;
                        }
                        var result = Polygon.convexHull$float_A$float_A$int(cloudX, cloudY, nVert);
                        return result;
                    };
                    Polygon.convexHull$float_A$float_A$int = function (cloudX, cloudY, nVert) {
                        if (!((nVert > 2)))
                            throw new Error("Assertion error line 1073: assert (nVert > 2);");
                        ;
                        var edgeList = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(nVert);
                        var numEdges = 0;
                        var minY = 3.4028235E38;
                        var minYIndex = nVert;
                        for (var i = 0; i < nVert; ++i) {
                            {
                                if (cloudY[i] < minY) {
                                    minY = cloudY[i];
                                    minYIndex = i;
                                }
                            }
                            ;
                        }
                        var startIndex = minYIndex;
                        var winIndex = -1;
                        var dx = -1.0;
                        var dy = 0.0;
                        while ((winIndex !== minYIndex)) {
                            {
                                var newdx = 0.0;
                                var newdy = 0.0;
                                var maxDot = -2.0;
                                for (var i = 0; i < nVert; ++i) {
                                    {
                                        if (i === startIndex)
                                            continue;
                                        newdx = Math.fround(cloudX[i] - cloudX[startIndex]);
                                        newdy = Math.fround(cloudY[i] - cloudY[startIndex]);
                                        var nrm_1 = Math.fround(Math.sqrt(Math.fround(Math.fround(newdx * newdx) + Math.fround(newdy * newdy))));
                                        nrm_1 = (nrm_1 === 0.0) ? 1.0 : nrm_1;
                                        newdx /= nrm_1;
                                        newdy /= nrm_1;
                                        var newDot = Math.fround(Math.fround(newdx * dx) + Math.fround(newdy * dy));
                                        if (newDot > maxDot) {
                                            maxDot = newDot;
                                            winIndex = i;
                                        }
                                    }
                                    ;
                                }
                                edgeList[numEdges++] = winIndex;
                                dx = Math.fround(cloudX[winIndex] - cloudX[startIndex]);
                                dy = Math.fround(cloudY[winIndex] - cloudY[startIndex]);
                                var nrm = Math.fround(Math.sqrt(Math.fround(Math.fround(dx * dx) + Math.fround(dy * dy))));
                                nrm = (nrm === 0.0) ? 1.0 : nrm;
                                dx /= nrm;
                                dy /= nrm;
                                startIndex = winIndex;
                            }
                        }
                        ;
                        var xres = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(numEdges);
                        var yres = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(numEdges);
                        for (var i = 0; i < numEdges; i++) {
                            {
                                xres[i] = cloudX[edgeList[i]];
                                yres[i] = cloudY[edgeList[i]];
                            }
                            ;
                        }
                        var returnVal = new Polygon(xres, yres, numEdges);
                        returnVal.mergeParallelEdges(org.jbox2d.common.Settings.angularSlop_$LI$());
                        return returnVal;
                    };
                    Polygon.convexHull = function (cloudX, cloudY, nVert) {
                        if (((cloudX != null && cloudX instanceof Array && (cloudX.length == 0 || cloudX[0] == null || (typeof cloudX[0] === 'number'))) || cloudX === null) && ((cloudY != null && cloudY instanceof Array && (cloudY.length == 0 || cloudY[0] == null || (typeof cloudY[0] === 'number'))) || cloudY === null) && ((typeof nVert === 'number') || nVert === null)) {
                            return org.jbox2d.util.nonconvex.Polygon.convexHull$float_A$float_A$int(cloudX, cloudY, nVert);
                        }
                        else if (((cloudX != null && cloudX instanceof Array && (cloudX.length == 0 || cloudX[0] == null || (cloudX[0] != null && cloudX[0] instanceof org.jbox2d.common.Vec2))) || cloudX === null) && ((typeof cloudY === 'number') || cloudY === null) && nVert === undefined) {
                            return org.jbox2d.util.nonconvex.Polygon.convexHull$org_jbox2d_common_Vec2_A$int(cloudX, cloudY);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    Polygon.isRighter = function (sinA, cosA, sinB, cosB) {
                        if (sinA < 0) {
                            if (sinB > 0 || cosA <= cosB)
                                return true;
                            else
                                return false;
                        }
                        else {
                            if (sinB < 0 || cosA <= cosB)
                                return false;
                            else
                                return true;
                        }
                    };
                    /*private*/ Polygon.remainder = function (x, modulus) {
                        var rem = x % modulus;
                        while ((rem < 0)) {
                            {
                                rem += modulus;
                            }
                        }
                        ;
                        return rem;
                    };
                    Polygon.traceEdge = function (p) {
                        var nodes = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(p.nVertices * p.nVertices);
                        var nNodes = 0;
                        for (var i = 0; i < nodes.length; ++i) {
                            {
                                nodes[i] = new org.jbox2d.util.nonconvex.PolyNode();
                            }
                            ;
                        }
                        for (var i = 0; i < p.nVertices; ++i) {
                            {
                                var pos = new org.jbox2d.common.Vec2(p.x[i], p.y[i]);
                                nodes[i].position = (function (o) { if (o.clone != undefined) {
                                    return o.clone();
                                }
                                else {
                                    var clone = Object.create(o);
                                    for (var p_5 in o) {
                                        if (o.hasOwnProperty(p_5))
                                            clone[p_5] = o[p_5];
                                    }
                                    return clone;
                                } })(pos);
                                ++nNodes;
                                var iplus = (i === p.nVertices - 1) ? 0 : i + 1;
                                var iminus = (i === 0) ? p.nVertices - 1 : i - 1;
                                nodes[i].addConnection(nodes[iplus]);
                                nodes[i].addConnection(nodes[iminus]);
                            }
                            ;
                        }
                        var dirty = true;
                        var counter = 0;
                        while ((dirty)) {
                            {
                                dirty = false;
                                for (var i = 0; i < nNodes; ++i) {
                                    {
                                        for (var j = 0; j < nodes[i].nConnected; ++j) {
                                            {
                                                for (var k = 0; k < nNodes; ++k) {
                                                    {
                                                        if (k === i || nodes[k] === nodes[i].connected[j])
                                                            continue;
                                                        for (var l = 0; l < nodes[k].nConnected; ++l) {
                                                            {
                                                                if (nodes[k].connected[l] === nodes[i].connected[j] || nodes[k].connected[l] === nodes[i])
                                                                    continue;
                                                                var intersectPt = new org.jbox2d.common.Vec2();
                                                                var crosses = Polygon.intersect(nodes[i].position, nodes[i].connected[j].position, nodes[k].position, nodes[k].connected[l].position, intersectPt);
                                                                if (crosses) {
                                                                    dirty = true;
                                                                    var connj = nodes[i].connected[j];
                                                                    var connl = nodes[k].connected[l];
                                                                    nodes[i].connected[j].removeConnection(nodes[i]);
                                                                    nodes[i].removeConnection(connj);
                                                                    nodes[k].connected[l].removeConnection(nodes[k]);
                                                                    nodes[k].removeConnection(connl);
                                                                    nodes[nNodes] = new org.jbox2d.util.nonconvex.PolyNode(intersectPt);
                                                                    nodes[nNodes].addConnection(nodes[i]);
                                                                    nodes[i].addConnection(nodes[nNodes]);
                                                                    nodes[nNodes].addConnection(nodes[k]);
                                                                    nodes[k].addConnection(nodes[nNodes]);
                                                                    nodes[nNodes].addConnection(connj);
                                                                    connj.addConnection(nodes[nNodes]);
                                                                    nodes[nNodes].addConnection(connl);
                                                                    connl.addConnection(nodes[nNodes]);
                                                                    ++nNodes;
                                                                    break;
                                                                }
                                                                if (dirty)
                                                                    break;
                                                            }
                                                            ;
                                                        }
                                                        if (dirty)
                                                            break;
                                                    }
                                                    ;
                                                }
                                                if (dirty)
                                                    break;
                                            }
                                            ;
                                        }
                                        if (dirty)
                                            break;
                                    }
                                    ;
                                }
                                ++counter;
                            }
                        }
                        ;
                        var foundDupe = true;
                        var nActive = nNodes;
                        while ((foundDupe)) {
                            {
                                foundDupe = false;
                                for (var i = 0; i < nNodes; ++i) {
                                    {
                                        if (nodes[i].nConnected === 0)
                                            continue;
                                        for (var j = i + 1; j < nNodes; ++j) {
                                            {
                                                if (nodes[j].nConnected === 0)
                                                    continue;
                                                var diff = nodes[i].position.sub(nodes[j].position);
                                                if (diff.lengthSquared() <= Polygon.COLLAPSE_DIST_SQR_$LI$()) {
                                                    if (nActive <= 3)
                                                        return new Polygon();
                                                    --nActive;
                                                    foundDupe = true;
                                                    var inode = nodes[i];
                                                    var jnode = nodes[j];
                                                    var njConn = jnode.nConnected;
                                                    for (var k = 0; k < njConn; ++k) {
                                                        {
                                                            var knode = jnode.connected[k];
                                                            if (!((knode !== jnode)))
                                                                throw new Error("Assertion error line 1225: assert (knode != jnode);");
                                                            ;
                                                            if (knode !== inode) {
                                                                inode.addConnection(knode);
                                                                knode.addConnection(inode);
                                                            }
                                                            knode.removeConnection(jnode);
                                                        }
                                                        ;
                                                    }
                                                    jnode.nConnected = 0;
                                                }
                                            }
                                            ;
                                        }
                                    }
                                    ;
                                }
                            }
                        }
                        ;
                        var minY = 3.4028235E38;
                        var maxX = -3.4028235E38;
                        var minYIndex = -1;
                        for (var i = 0; i < nNodes; ++i) {
                            {
                                if (nodes[i].position.y < minY && nodes[i].nConnected > 1) {
                                    minY = nodes[i].position.y;
                                    minYIndex = i;
                                    maxX = nodes[i].position.x;
                                }
                                else if (nodes[i].position.y === minY && nodes[i].position.x > maxX && nodes[i].nConnected > 1) {
                                    minYIndex = i;
                                    maxX = nodes[i].position.x;
                                }
                            }
                            ;
                        }
                        var origDir = new org.jbox2d.common.Vec2(1.0, 0.0);
                        var resultVecs = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(4 * nNodes);
                        var nResultVecs = 0;
                        var currentNode = nodes[minYIndex];
                        var startNode = currentNode;
                        if (!((currentNode.nConnected > 0)))
                            throw new Error("Assertion error line 1255: assert (currentNode.nConnected > 0);");
                        ;
                        var nextNode = currentNode.getRightestConnection$org_jbox2d_common_Vec2(origDir);
                        if (nextNode == null) {
                            startNode = nextNode;
                        }
                        resultVecs[0] = startNode.position;
                        ++nResultVecs;
                        while ((nextNode !== startNode)) {
                            {
                                if (nResultVecs > 4 * nNodes) {
                                    if (!((false)))
                                        throw new Error("Assertion error line 1264: assert (false);");
                                    ;
                                }
                                resultVecs[nResultVecs++] = nextNode.position;
                                var oldNode = currentNode;
                                currentNode = nextNode;
                                nextNode = currentNode.getRightestConnection$org_jbox2d_util_nonconvex_PolyNode(oldNode);
                                if (nextNode == null)
                                    break;
                            }
                        }
                        ;
                        var xres = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(nResultVecs);
                        var yres = (function (s) { var a = []; while (s-- > 0)
                            a.push(0); return a; })(nResultVecs);
                        for (var i = 0; i < nResultVecs; ++i) {
                            {
                                xres[i] = resultVecs[i].x;
                                yres[i] = resultVecs[i].y;
                            }
                            ;
                        }
                        var retval = new Polygon(xres, yres, nResultVecs);
                        return retval;
                    };
                    Polygon.prototype.print = function () {
                        this.printFormatted();
                    };
                    Polygon.prototype.printFormatted = function () {
                        console.info("float xv[] = {");
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                console.info("%ff,");
                            }
                            ;
                        }
                        console.info("};\nfloat yv[] = {");
                        for (var i = 0; i < this.nVertices; ++i) {
                            {
                                console.info("%ff,");
                            }
                            ;
                        }
                        console.info("};\n");
                    };
                    return Polygon;
                }());
                Polygon.B2_POLYGON_REPORT_ERRORS = true;
                nonconvex.Polygon = Polygon;
                Polygon["__class"] = "org.jbox2d.util.nonconvex.Polygon";
                var PolyNode = (function () {
                    function PolyNode(pos) {
                        var _this = this;
                        this.connected = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(PolyNode.MAX_CONNECTED);
                        if (((pos != null && pos instanceof org.jbox2d.common.Vec2) || pos === null)) {
                            var __args = arguments;
                            if (this.nConnected === undefined)
                                this.nConnected = 0;
                            if (this.visited === undefined)
                                this.visited = false;
                            if (this.position === undefined)
                                this.position = null;
                            this.connected = (function (s) { var a = []; while (s-- > 0)
                                a.push(null); return a; })(PolyNode.MAX_CONNECTED);
                            if (this.nConnected === undefined)
                                this.nConnected = 0;
                            if (this.visited === undefined)
                                this.visited = false;
                            if (this.position === undefined)
                                this.position = null;
                            (function () {
                                _this.position = pos;
                                _this.nConnected = 0;
                                _this.visited = false;
                            })();
                        }
                        else if (pos === undefined) {
                            var __args = arguments;
                            if (this.nConnected === undefined)
                                this.nConnected = 0;
                            if (this.visited === undefined)
                                this.visited = false;
                            if (this.position === undefined)
                                this.position = null;
                            this.connected = (function (s) { var a = []; while (s-- > 0)
                                a.push(null); return a; })(PolyNode.MAX_CONNECTED);
                            if (this.nConnected === undefined)
                                this.nConnected = 0;
                            if (this.visited === undefined)
                                this.visited = false;
                            if (this.position === undefined)
                                this.position = null;
                            (function () {
                                _this.nConnected = 0;
                                _this.visited = false;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                    }
                    PolyNode.prototype.addConnection = function (toMe) {
                        if (!((this.nConnected < PolyNode.MAX_CONNECTED)))
                            throw new Error("Assertion error line 1344: assert (nConnected < MAX_CONNECTED);");
                        ;
                        for (var i = 0; i < this.nConnected; ++i) {
                            {
                                if (this.connected[i] === toMe)
                                    return;
                            }
                            ;
                        }
                        this.connected[this.nConnected] = toMe;
                        ++this.nConnected;
                    };
                    PolyNode.prototype.removeConnection = function (fromMe) {
                        var isFound = false;
                        var foundIndex = -1;
                        for (var i = 0; i < this.nConnected; ++i) {
                            {
                                if (fromMe === this.connected[i]) {
                                    isFound = true;
                                    foundIndex = i;
                                    break;
                                }
                            }
                            ;
                        }
                        if (!((isFound)))
                            throw new Error("Assertion error line 1362: assert (isFound);");
                        ;
                        --this.nConnected;
                        for (var i = foundIndex; i < this.nConnected; ++i) {
                            {
                                this.connected[i] = this.connected[i + 1];
                            }
                            ;
                        }
                    };
                    PolyNode.prototype.removeConnectionByIndex = function (index) {
                        --this.nConnected;
                        for (var i = index; i < this.nConnected; ++i) {
                            {
                                this.connected[i] = this.connected[i + 1];
                            }
                            ;
                        }
                    };
                    PolyNode.prototype.isConnectedTo = function (me) {
                        var isFound = false;
                        for (var i = 0; i < this.nConnected; ++i) {
                            {
                                if (me === this.connected[i]) {
                                    isFound = true;
                                    break;
                                }
                            }
                            ;
                        }
                        return isFound;
                    };
                    PolyNode.prototype.getRightestConnection$org_jbox2d_util_nonconvex_PolyNode = function (incoming) {
                        if (this.nConnected === 0) {
                            if (!((false)))
                                throw new Error("Assertion error line 1389: assert (false);");
                            ;
                            return null;
                        }
                        if (this.nConnected === 1) {
                            return incoming;
                        }
                        var inDir = this.position.sub(incoming.position);
                        var inLength = inDir.normalize();
                        if (!((inLength > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 1397: assert (inLength > Settings.EPSILON);");
                        ;
                        var result = null;
                        for (var i = 0; i < this.nConnected; ++i) {
                            {
                                if (this.connected[i] === incoming)
                                    continue;
                                var testDir = this.connected[i].position.sub(this.position);
                                var testLengthSqr = testDir.lengthSquared();
                                testDir.normalize();
                                if (!((testLengthSqr >= org.jbox2d.util.nonconvex.Polygon.COLLAPSE_DIST_SQR_$LI$())))
                                    throw new Error("Assertion error line 1404: assert (testLengthSqr >= Polygon.COLLAPSE_DIST_SQR);");
                                ;
                                var myCos = org.jbox2d.common.Vec2.dot(inDir, testDir);
                                var mySin = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(inDir, testDir);
                                if (result != null) {
                                    var resultDir = result.position.sub(this.position);
                                    resultDir.normalize();
                                    var resCos = org.jbox2d.common.Vec2.dot(inDir, resultDir);
                                    var resSin = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(inDir, resultDir);
                                    if (org.jbox2d.util.nonconvex.Polygon.isRighter(mySin, myCos, resSin, resCos)) {
                                        result = this.connected[i];
                                    }
                                }
                                else {
                                    result = this.connected[i];
                                }
                            }
                            ;
                        }
                        if (!((result != null)))
                            throw new Error("Assertion error line 1419: assert (result != null);");
                        ;
                        return result;
                    };
                    PolyNode.prototype.getRightestConnection = function (incoming) {
                        if (((incoming != null && incoming instanceof org.jbox2d.util.nonconvex.PolyNode) || incoming === null)) {
                            return this.getRightestConnection$org_jbox2d_util_nonconvex_PolyNode(incoming);
                        }
                        else if (((incoming != null && incoming instanceof org.jbox2d.common.Vec2) || incoming === null)) {
                            return this.getRightestConnection$org_jbox2d_common_Vec2(incoming);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    PolyNode.prototype.getRightestConnection$org_jbox2d_common_Vec2 = function (incomingDir) {
                        var diff = this.position.sub(incomingDir);
                        var temp = new PolyNode(diff);
                        var res = this.getRightestConnection$org_jbox2d_util_nonconvex_PolyNode(temp);
                        if (!((res != null)))
                            throw new Error("Assertion error line 1435: assert (res != null);");
                        ;
                        return res;
                    };
                    return PolyNode;
                }());
                PolyNode.MAX_CONNECTED = 32;
                nonconvex.PolyNode = PolyNode;
                PolyNode["__class"] = "org.jbox2d.util.nonconvex.PolyNode";
            })(nonconvex = util.nonconvex || (util.nonconvex = {}));
        })(util = jbox2d.util || (jbox2d.util = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var NullContact = (function (_super) {
                    __extends(NullContact, _super);
                    function NullContact() {
                        return _super.call(this) || this;
                    }
                    /**
                     *
                     * @param {*} cl
                     */
                    NullContact.prototype.evaluate = function (cl) {
                    };
                    NullContact.prototype.clone = function () {
                        return new NullContact();
                    };
                    /**
                     *
                     * @return {org.jbox2d.collision.Manifold[]}
                     */
                    NullContact.prototype.getManifolds = function () {
                        console.info("NullContact.GetManifolds()");
                        return null;
                    };
                    NullContact.prototype.getFirstManifold = function () {
                        console.info("NullContact.GetFirstManifold()");
                        return null;
                    };
                    return NullContact;
                }(org.jbox2d.dynamics.contacts.Contact));
                contacts.NullContact = NullContact;
                NullContact["__class"] = "org.jbox2d.dynamics.contacts.NullContact";
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var controllers;
            (function (controllers) {
                /**
                 * @author eric
                 * @extends org.jbox2d.dynamics.controllers.Controller
                 * @class
                 */
                var BuoyancyController = (function (_super) {
                    __extends(BuoyancyController, _super);
                    function BuoyancyController(def) {
                        var _this = _super.call(this, def) || this;
                        /**
                         * The outer surface normal
                         */
                        _this.normal = new org.jbox2d.common.Vec2();
                        /**
                         * Fluid velocity, for drag calculations
                         */
                        _this.velocity = new org.jbox2d.common.Vec2();
                        /**
                         * Gravity vector, if the world's gravity is not used
                         */
                        _this.gravity = new org.jbox2d.common.Vec2();
                        if (_this.offset === undefined)
                            _this.offset = 0;
                        if (_this.density === undefined)
                            _this.density = 0;
                        if (_this.linearDrag === undefined)
                            _this.linearDrag = 0;
                        if (_this.angularDrag === undefined)
                            _this.angularDrag = 0;
                        if (_this.useDensity === undefined)
                            _this.useDensity = false;
                        if (_this.useWorldGravity === undefined)
                            _this.useWorldGravity = false;
                        _this.normal = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.normal);
                        _this.offset = def.offset;
                        _this.density = def.density;
                        _this.velocity = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.velocity);
                        _this.linearDrag = def.linearDrag;
                        _this.angularDrag = def.angularDrag;
                        _this.useDensity = def.useDensity;
                        _this.useWorldGravity = def.useWorldGravity;
                        _this.gravity = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.gravity);
                        return _this;
                    }
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    BuoyancyController.prototype.step = function (step) {
                        if (this.m_bodyList == null)
                            return;
                        if (this.useWorldGravity) {
                            this.gravity = this.m_world.getGravity();
                        }
                        for (var i = this.m_bodyList; i != null; i = i.nextBody) {
                            {
                                var body = i.body;
                                if (body.isSleeping()) {
                                    continue;
                                }
                                var areac = new org.jbox2d.common.Vec2(0, 0);
                                var massc = new org.jbox2d.common.Vec2(0, 0);
                                var area = 0;
                                var mass = 0;
                                for (var shape = body.getShapeList(); shape != null; shape = shape.getNext()) {
                                    {
                                        var sc = new org.jbox2d.common.Vec2(0, 0);
                                        var sarea = shape.computeSubmergedArea$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2(this.normal, this.offset, sc);
                                        area += sarea;
                                        areac.x += Math.fround(sarea * sc.x);
                                        areac.y += Math.fround(sarea * sc.y);
                                        var shapeDensity = 0;
                                        if (this.useDensity) {
                                            shapeDensity = shape.getDensity();
                                        }
                                        else {
                                            shapeDensity = 1;
                                        }
                                        mass += Math.fround(sarea * shapeDensity);
                                        massc.x += Math.fround(Math.fround(sarea * sc.x) * shapeDensity);
                                        massc.y += Math.fround(Math.fround(sarea * sc.y) * shapeDensity);
                                    }
                                    ;
                                }
                                areac.x /= area;
                                areac.y /= area;
                                massc.x /= mass;
                                massc.y /= mass;
                                if (area < org.jbox2d.common.Settings.EPSILON)
                                    continue;
                                var buoyancyForce = this.gravity.mul(Math.fround(-this.density * area));
                                body.applyForce(buoyancyForce, massc);
                                var dragForce = body.getLinearVelocityFromWorldPoint(areac).sub(this.velocity);
                                dragForce.mulLocal(Math.fround(-this.linearDrag * area));
                                body.applyForce(dragForce, areac);
                                body.applyTorque(Math.fround(Math.fround(Math.fround(Math.fround(-body.getInertia() / body.getMass()) * area) * body.getAngularVelocity()) * this.angularDrag));
                            }
                            ;
                        }
                    };
                    /**
                     *
                     * @param {org.jbox2d.dynamics.DebugDraw} debugDraw
                     */
                    BuoyancyController.prototype.draw = function (debugDraw) {
                        var r = 1000;
                        var p1 = this.normal.mul(this.offset).addLocal$org_jbox2d_common_Vec2(org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$float(this.normal, r));
                        var p2 = this.normal.mul(this.offset).subLocal(org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$float(this.normal, r));
                        var color = new org.jbox2d.common.Color3f(0, 0, Math.fround(255 * 0.8));
                        var vertices = [p1, p2, p2.sub(this.normal.mul(r)), p1.sub(this.normal.mul(r))];
                        debugDraw.drawSolidPolygon(vertices, 4, color);
                    };
                    return BuoyancyController;
                }(org.jbox2d.dynamics.controllers.Controller));
                controllers.BuoyancyController = BuoyancyController;
                BuoyancyController["__class"] = "org.jbox2d.dynamics.controllers.BuoyancyController";
            })(controllers = dynamics.controllers || (dynamics.controllers = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var controllers;
            (function (controllers) {
                /**
                 * @author eric
                 * @class
                 * @extends org.jbox2d.dynamics.controllers.ControllerDef
                 */
                var BuoyancyControllerDef = (function (_super) {
                    __extends(BuoyancyControllerDef, _super);
                    function BuoyancyControllerDef() {
                        var _this = _super.call(this) || this;
                        if (_this.normal === undefined)
                            _this.normal = null;
                        if (_this.offset === undefined)
                            _this.offset = 0;
                        if (_this.density === undefined)
                            _this.density = 0;
                        if (_this.velocity === undefined)
                            _this.velocity = null;
                        if (_this.linearDrag === undefined)
                            _this.linearDrag = 0;
                        if (_this.angularDrag === undefined)
                            _this.angularDrag = 0;
                        if (_this.useDensity === undefined)
                            _this.useDensity = false;
                        if (_this.useWorldGravity === undefined)
                            _this.useWorldGravity = false;
                        if (_this.gravity === undefined)
                            _this.gravity = null;
                        _this.normal = new org.jbox2d.common.Vec2(0, 1);
                        _this.offset = 0;
                        _this.density = 0;
                        _this.velocity = new org.jbox2d.common.Vec2(0, 0);
                        _this.linearDrag = 0;
                        _this.angularDrag = 0;
                        _this.useDensity = false;
                        _this.useWorldGravity = true;
                        _this.gravity = new org.jbox2d.common.Vec2(0, 0);
                        return _this;
                    }
                    /**
                     * @see org.jbox2d.dynamics.controllers.ControllerDef#create()
                     * @return {org.jbox2d.dynamics.controllers.Controller}
                     */
                    BuoyancyControllerDef.prototype.create = function () {
                        return new org.jbox2d.dynamics.controllers.BuoyancyController(this);
                    };
                    return BuoyancyControllerDef;
                }(org.jbox2d.dynamics.controllers.ControllerDef));
                controllers.BuoyancyControllerDef = BuoyancyControllerDef;
                BuoyancyControllerDef["__class"] = "org.jbox2d.dynamics.controllers.BuoyancyControllerDef";
            })(controllers = dynamics.controllers || (dynamics.controllers = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var testbed;
        (function (testbed) {
            /**
             * Implementation of DebugDraw using Processing (http://www.processing.org)
             *
             * @author ewjordan
             * @param {*} pApplet
             * @class
             * @extends org.jbox2d.dynamics.DebugDraw
             */
            var ProcessingDebugDraw = (function (_super) {
                __extends(ProcessingDebugDraw, _super);
                function ProcessingDebugDraw(pApplet) {
                    var _this = _super.call(this, new org.jbox2d.common.OBBViewportTransform()) || this;
                    /*private*/ _this.firstTime = true;
                    if (_this.g === undefined)
                        _this.g = null;
                    if (_this.pg === undefined)
                        _this.pg = null;
                    if (_this.m_font === undefined)
                        _this.m_font = null;
                    if (_this.fontHeight === undefined)
                        _this.fontHeight = 0;
                    if (_this.transform === undefined)
                        _this.transform = null;
                    _this.transform = _super.prototype.getViewportTranform.call(_this);
                    _this.g = pApplet;
                    _this.pg = _this.g.createGraphics(pApplet.displayWidth, pApplet.displayHeight);
                    ProcessingDebugDraw.screen = _this;
                    _this.m_font = _this.g.createFont("LucidaGrande-Bold", 12);
                    _this.fontHeight = 14.0;
                    _this.viewportTransform.setCamera(320 + (_this.g.width / 2 | 0), 240 + (_this.g.height / 2 | 0), 20);
                    _this.viewportTransform['setExtents$float$float']((_this.g.width / 2 | 0), (_this.g.height / 2 | 0));
                    _this.viewportTransform.setYFlip(true);
                    return _this;
                }
                ProcessingDebugDraw.circlePt_$LI$ = function () { if (ProcessingDebugDraw.circlePt == null)
                    ProcessingDebugDraw.circlePt = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.circlePt; };
                ;
                /**
                 *
                 * @param {org.jbox2d.common.Vec2} argCenter
                 * @param {number} radius
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawCircle = function (argCenter, radius, color) {
                    this.viewportTransform.getWorldToScreen(argCenter, ProcessingDebugDraw.center_$LI$());
                    this.g.noFill();
                    var k_segments = 16.0;
                    var k_increment = Math.fround(Math.fround(2.0 * org.jbox2d.common.MathUtils.PI_$LI$()) / k_segments);
                    var theta = 0.0;
                    this.g.stroke(color.x, color.y, color.z);
                    this.g.noFill();
                    this.g.beginShape(PConstants.POLYGON);
                    for (var i = 0; i < k_segments; ++i) {
                        {
                            var vx = Math.fround(radius * org.jbox2d.common.MathUtils.cos(theta));
                            var vy = Math.fround(radius * org.jbox2d.common.MathUtils.sin(theta));
                            ProcessingDebugDraw.circlePt_$LI$().set$float$float(vx, vy);
                            this.viewportTransform.vectorTransform(ProcessingDebugDraw.circlePt_$LI$(), ProcessingDebugDraw.circlePt_$LI$());
                            ProcessingDebugDraw.circlePt_$LI$().addLocal$org_jbox2d_common_Vec2(ProcessingDebugDraw.center_$LI$());
                            this.g.vertex(ProcessingDebugDraw.circlePt_$LI$().x, ProcessingDebugDraw.circlePt_$LI$().y);
                            theta += k_increment;
                        }
                        ;
                    }
                    ProcessingDebugDraw.circlePt_$LI$().set$float$float(radius, 0);
                    this.viewportTransform.vectorTransform(ProcessingDebugDraw.circlePt_$LI$(), ProcessingDebugDraw.circlePt_$LI$());
                    ProcessingDebugDraw.circlePt_$LI$().addLocal$org_jbox2d_common_Vec2(ProcessingDebugDraw.center_$LI$());
                    this.g.vertex(ProcessingDebugDraw.circlePt_$LI$().x, ProcessingDebugDraw.circlePt_$LI$().y);
                    this.g.endShape();
                };
                ProcessingDebugDraw.p_$LI$ = function () { if (ProcessingDebugDraw.p == null)
                    ProcessingDebugDraw.p = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.p; };
                ;
                ProcessingDebugDraw.center_$LI$ = function () { if (ProcessingDebugDraw.center == null)
                    ProcessingDebugDraw.center = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.center; };
                ;
                /**
                 *
                 * @param {org.jbox2d.common.Vec2} argCenter
                 * @param {number} radius
                 * @param {org.jbox2d.common.Vec2} axis
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawSolidCircle = function (argCenter, radius, axis, color) {
                    this.viewportTransform.getWorldToScreen(argCenter, ProcessingDebugDraw.center_$LI$());
                    var k_segments = 16.0;
                    var k_increment = Math.fround(Math.fround(2.0 * org.jbox2d.common.MathUtils.PI_$LI$()) / k_segments);
                    var theta = 0.0;
                    this.g.fill(Math.fround(0.5 * color.x), Math.fround(0.5 * color.y), Math.fround(0.5 * color.z), Math.fround(0.5 * 255.0));
                    this.g.stroke(color.x, color.y, color.z, 255.0);
                    this.g.beginShape(PConstants.POLYGON);
                    for (var i = 0; i < k_segments; ++i) {
                        {
                            var vx = Math.fround(radius * org.jbox2d.common.MathUtils.cos(theta));
                            var vy = Math.fround(radius * org.jbox2d.common.MathUtils.sin(theta));
                            ProcessingDebugDraw.circlePt_$LI$().set$float$float(vx, vy);
                            this.viewportTransform.vectorTransform(ProcessingDebugDraw.circlePt_$LI$(), ProcessingDebugDraw.circlePt_$LI$());
                            ProcessingDebugDraw.circlePt_$LI$().addLocal$org_jbox2d_common_Vec2(ProcessingDebugDraw.center_$LI$());
                            this.g.vertex(ProcessingDebugDraw.circlePt_$LI$().x, ProcessingDebugDraw.circlePt_$LI$().y);
                            theta += k_increment;
                        }
                        ;
                    }
                    ProcessingDebugDraw.circlePt_$LI$().set$float$float(radius, 0);
                    this.viewportTransform.vectorTransform(ProcessingDebugDraw.circlePt_$LI$(), ProcessingDebugDraw.circlePt_$LI$());
                    ProcessingDebugDraw.circlePt_$LI$().addLocal$org_jbox2d_common_Vec2(ProcessingDebugDraw.center_$LI$());
                    this.g.vertex(ProcessingDebugDraw.circlePt_$LI$().x, ProcessingDebugDraw.circlePt_$LI$().y);
                    this.g.endShape();
                    this.getWorldToScreenToOut$float$float$org_jbox2d_common_Vec2(Math.fround(argCenter.x + Math.fround(radius * axis.x)), Math.fround(argCenter.y + Math.fround(radius * axis.y)), ProcessingDebugDraw.p_$LI$());
                    this.g.beginShape(PConstants.LINES);
                    this.g.vertex(ProcessingDebugDraw.center_$LI$().x, ProcessingDebugDraw.center_$LI$().y);
                    this.g.vertex(ProcessingDebugDraw.p_$LI$().x, ProcessingDebugDraw.p_$LI$().y);
                    this.g.endShape();
                };
                ProcessingDebugDraw.v1_$LI$ = function () { if (ProcessingDebugDraw.v1 == null)
                    ProcessingDebugDraw.v1 = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.v1; };
                ;
                ProcessingDebugDraw.v2_$LI$ = function () { if (ProcessingDebugDraw.v2 == null)
                    ProcessingDebugDraw.v2 = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.v2; };
                ;
                /**
                 *
                 * @param {Array} vertices
                 * @param {number} vertexCount
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawPolygon = function (vertices, vertexCount, color) {
                    this.g.stroke(color.x, color.y, color.z);
                    this.g.noFill();
                    for (var i = 0; i < vertexCount; ++i) {
                        {
                            var ind = (i + 1 < vertexCount) ? i + 1 : (i + 1 - vertexCount);
                            this.viewportTransform.getWorldToScreen(vertices[i], ProcessingDebugDraw.v1_$LI$());
                            this.viewportTransform.getWorldToScreen(vertices[ind], ProcessingDebugDraw.v2_$LI$());
                            this.g.line(ProcessingDebugDraw.v1_$LI$().x, ProcessingDebugDraw.v1_$LI$().y, ProcessingDebugDraw.v2_$LI$().x, ProcessingDebugDraw.v2_$LI$().y);
                        }
                        ;
                    }
                };
                ProcessingDebugDraw.v_$LI$ = function () { if (ProcessingDebugDraw.v == null)
                    ProcessingDebugDraw.v = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.v; };
                ;
                /**
                 *
                 * @param {Array} vertices
                 * @param {number} vertexCount
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawSolidPolygon = function (vertices, vertexCount, color) {
                    this.g.noStroke();
                    this.g.fill(Math.fround(0.5 * color.x), Math.fround(0.5 * color.y), Math.fround(0.5 * color.z), Math.fround(0.5 * 255.0));
                    this.g.beginShape(PConstants.POLYGON);
                    for (var i = 0; i < vertexCount; ++i) {
                        {
                            this.viewportTransform.getWorldToScreen(vertices[i], ProcessingDebugDraw.v_$LI$());
                            this.g.vertex(ProcessingDebugDraw.v_$LI$().x, ProcessingDebugDraw.v_$LI$().y);
                        }
                        ;
                    }
                    this.g.endShape();
                    this.g.stroke(color.x, color.y, color.z, 255.0);
                    for (var i = 0; i < vertexCount; ++i) {
                        {
                            var ind = (i + 1 < vertexCount) ? i + 1 : (i + 1 - vertexCount);
                            this.viewportTransform.getWorldToScreen(vertices[i], ProcessingDebugDraw.v1_$LI$());
                            this.viewportTransform.getWorldToScreen(vertices[ind], ProcessingDebugDraw.v2_$LI$());
                            this.g.line(ProcessingDebugDraw.v1_$LI$().x, ProcessingDebugDraw.v1_$LI$().y, ProcessingDebugDraw.v2_$LI$().x, ProcessingDebugDraw.v2_$LI$().y);
                        }
                        ;
                    }
                };
                /**
                 *
                 * @param {org.jbox2d.common.Vec2} argP1
                 * @param {org.jbox2d.common.Vec2} argP2
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawSegment = function (argP1, argP2, color) {
                    this.viewportTransform.getWorldToScreen(argP1, ProcessingDebugDraw.p1_$LI$());
                    this.viewportTransform.getWorldToScreen(argP2, ProcessingDebugDraw.p2_$LI$());
                    this.g.stroke(color.x, color.y, color.z);
                    this.g.beginShape(PConstants.LINES);
                    this.g.vertex(ProcessingDebugDraw.p1_$LI$().x, ProcessingDebugDraw.p1_$LI$().y);
                    this.g.vertex(ProcessingDebugDraw.p2_$LI$().x, ProcessingDebugDraw.p2_$LI$().y);
                    this.g.endShape();
                };
                ProcessingDebugDraw.p1_$LI$ = function () { if (ProcessingDebugDraw.p1 == null)
                    ProcessingDebugDraw.p1 = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.p1; };
                ;
                ProcessingDebugDraw.p2_$LI$ = function () { if (ProcessingDebugDraw.p2 == null)
                    ProcessingDebugDraw.p2 = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.p2; };
                ;
                ProcessingDebugDraw.p1world_$LI$ = function () { if (ProcessingDebugDraw.p1world == null)
                    ProcessingDebugDraw.p1world = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.p1world; };
                ;
                ProcessingDebugDraw.p2world_$LI$ = function () { if (ProcessingDebugDraw.p2world == null)
                    ProcessingDebugDraw.p2world = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.p2world; };
                ;
                /**
                 *
                 * @param {org.jbox2d.common.XForm} xf
                 */
                ProcessingDebugDraw.prototype.drawXForm = function (xf) {
                    ProcessingDebugDraw.p1_$LI$().set$org_jbox2d_common_Vec2(xf.position);
                    ProcessingDebugDraw.p2_$LI$().setZero();
                    var k_axisScale = 0.4;
                    this.g.beginShape(PConstants.LINES);
                    this.viewportTransform.getWorldToScreen(ProcessingDebugDraw.p1_$LI$(), ProcessingDebugDraw.p1world_$LI$());
                    this.g.stroke(255.0, 0.0, 0.0);
                    this.g.vertex(ProcessingDebugDraw.p1world_$LI$().x, ProcessingDebugDraw.p1world_$LI$().y);
                    ProcessingDebugDraw.p2_$LI$().x = Math.fround(ProcessingDebugDraw.p1_$LI$().x + Math.fround(k_axisScale * xf.R.col1.x));
                    ProcessingDebugDraw.p2_$LI$().y = Math.fround(ProcessingDebugDraw.p1_$LI$().y + Math.fround(k_axisScale * xf.R.col1.y));
                    this.viewportTransform.getWorldToScreen(ProcessingDebugDraw.p2_$LI$(), ProcessingDebugDraw.p2world_$LI$());
                    this.g.vertex(ProcessingDebugDraw.p2world_$LI$().x, ProcessingDebugDraw.p2world_$LI$().y);
                    this.g.stroke(0.0, 255.0, 0.0);
                    this.g.vertex(ProcessingDebugDraw.p1world_$LI$().x, ProcessingDebugDraw.p1world_$LI$().y);
                    ProcessingDebugDraw.p2_$LI$().x = Math.fround(ProcessingDebugDraw.p1_$LI$().x + Math.fround(k_axisScale * xf.R.col2.x));
                    ProcessingDebugDraw.p2_$LI$().y = Math.fround(ProcessingDebugDraw.p1_$LI$().y + Math.fround(k_axisScale * xf.R.col2.y));
                    this.viewportTransform.getWorldToScreen(ProcessingDebugDraw.p2_$LI$(), ProcessingDebugDraw.p2world_$LI$());
                    this.g.vertex(ProcessingDebugDraw.p2world_$LI$().x, ProcessingDebugDraw.p2world_$LI$().y);
                    this.g.endShape();
                };
                /**
                 *
                 * @param {number} x
                 * @param {number} y
                 * @param {string} s
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawString = function (x, y, s, color) {
                    if (this.firstTime) {
                        this.g.textFont(this.m_font);
                        if (this.pg != null && this.pg.is3D())
                            this.g.textMode(PConstants.SCREEN);
                        this.firstTime = false;
                    }
                    this.g.fill(color.x, color.y, color.z);
                    this.g.text(s, x, y);
                };
                ProcessingDebugDraw.position_$LI$ = function () { if (ProcessingDebugDraw.position == null)
                    ProcessingDebugDraw.position = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.position; };
                ;
                /**
                 *
                 * @param {org.jbox2d.common.Vec2} argPosition
                 * @param {number} f
                 * @param {org.jbox2d.common.Color3f} color
                 */
                ProcessingDebugDraw.prototype.drawPoint = function (argPosition, f, color) {
                    this.viewportTransform.getWorldToScreen(argPosition, ProcessingDebugDraw.position_$LI$());
                    var k_segments = 5.0;
                    var k_increment = Math.fround(Math.fround(2.0 * org.jbox2d.common.MathUtils.PI_$LI$()) / k_segments);
                    var k_radius = 3.0;
                    var theta = 0.0;
                    this.g.fill(color.x, color.y, color.z);
                    this.g.noStroke();
                    this.g.beginShape(PConstants.POLYGON);
                    for (var i = 0; i < k_segments; ++i) {
                        {
                            var vx = Math.fround(ProcessingDebugDraw.position_$LI$().x + Math.fround(k_radius * org.jbox2d.common.MathUtils.cos(theta)));
                            var vy = Math.fround(ProcessingDebugDraw.position_$LI$().y + Math.fround(k_radius * org.jbox2d.common.MathUtils.sin(theta)));
                            this.g.vertex(vx, vy);
                            theta += k_increment;
                        }
                        ;
                    }
                    this.g.endShape();
                };
                ProcessingDebugDraw.localOffset_$LI$ = function () { if (ProcessingDebugDraw.localOffset == null)
                    ProcessingDebugDraw.localOffset = new org.jbox2d.common.Vec2(); return ProcessingDebugDraw.localOffset; };
                ;
                /**
                 * First image is centered on position, then
                 * rotation, then localOffset is applied, and
                 * lastly localScale.
                 * <BR><BR>
                 * Thus localOffset should be specified in world
                 * units before scaling is applied.
                 * For instance, if you want a MxN image to have its corner
                 * at body center and be scaled by S, use a localOffset
                 * of (M*S/2, N*S/2) and a localScale of S.
                 * <BR><BR>
                 *
                 * @param {PImage} image
                 * @param {org.jbox2d.common.Vec2} argPosition
                 * @param {number} rotation
                 * @param {number} localScale
                 * @param {org.jbox2d.common.Vec2} argLocalOffset
                 * @param {number} halfImageWidth
                 * @param {number} halfImageHeight
                 */
                ProcessingDebugDraw.prototype.drawImage = function (image, argPosition, rotation, localScale, argLocalOffset, halfImageWidth, halfImageHeight) {
                    this.viewportTransform.getWorldToScreen(argPosition, ProcessingDebugDraw.position_$LI$());
                    this.viewportTransform.vectorTransform(argLocalOffset, ProcessingDebugDraw.localOffset_$LI$());
                    this.g.pushMatrix();
                    this.g.translate(ProcessingDebugDraw.position_$LI$().x, ProcessingDebugDraw.position_$LI$().y);
                    var mat = this.transform.getTransform();
                    if (this.pg.is3D()) {
                        this.g.applyMatrix(mat.col1.x, mat.col2.x, 0, 0, mat.col1.y, mat.col2.y, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
                    }
                    else {
                        this.g.applyMatrix(mat.col1.x, mat.col2.x, 0, mat.col1.y, mat.col2.y, 0);
                    }
                    this.g.rotate(-rotation);
                    this.g.scale(localScale);
                    this.g.translate(ProcessingDebugDraw.localOffset_$LI$().x, ProcessingDebugDraw.localOffset_$LI$().y);
                    this.g.image(image, -halfImageWidth, -halfImageHeight);
                    this.g.popMatrix();
                };
                return ProcessingDebugDraw;
            }(org.jbox2d.dynamics.DebugDraw));
            ProcessingDebugDraw.screen = null;
            testbed.ProcessingDebugDraw = ProcessingDebugDraw;
            ProcessingDebugDraw["__class"] = "org.jbox2d.testbed.ProcessingDebugDraw";
        })(testbed = jbox2d.testbed || (jbox2d.testbed = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var ContactFilter;
            (function (ContactFilter) {
                function DEFAULT_FILTER_$LI$() { if (ContactFilter.DEFAULT_FILTER == null)
                    ContactFilter.DEFAULT_FILTER = new org.jbox2d.dynamics.DefaultContactFilter(); return ContactFilter.DEFAULT_FILTER; }
                ContactFilter.DEFAULT_FILTER_$LI$ = DEFAULT_FILTER_$LI$;
                ;
            })(ContactFilter = dynamics.ContactFilter || (dynamics.ContactFilter = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * A gear joint is used to connect two joints together. Either joint
                 * can be a revolute or prismatic joint. You specify a gear ratio
                 * to bind the motions together:
                 * coordinate1 + ratio * coordinate2 = constant
                 * The ratio can be negative or positive. If one joint is a revolute joint
                 * and the other joint is a prismatic joint, then the ratio will have units
                 * of length or units of 1/length.
                 * <BR><em>Warning</em>: The revolute and prismatic joints must be attached to
                 * fixed bodies (which must be body1 on those joints).
                 * @param {org.jbox2d.dynamics.joints.GearJointDef} def
                 * @class
                 * @extends org.jbox2d.dynamics.joints.Joint
                 */
                var GearJoint = (function (_super) {
                    __extends(GearJoint, _super);
                    function GearJoint(def) {
                        var _this = _super.call(this, def) || this;
                        /*private*/ _this.tlug = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })();
                        /*private*/ _this.tlr = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })();
                        if (_this.m_ground1 === undefined)
                            _this.m_ground1 = null;
                        if (_this.m_ground2 === undefined)
                            _this.m_ground2 = null;
                        if (_this.m_revolute1 === undefined)
                            _this.m_revolute1 = null;
                        if (_this.m_prismatic1 === undefined)
                            _this.m_prismatic1 = null;
                        if (_this.m_revolute2 === undefined)
                            _this.m_revolute2 = null;
                        if (_this.m_prismatic2 === undefined)
                            _this.m_prismatic2 = null;
                        if (_this.m_groundAnchor1 === undefined)
                            _this.m_groundAnchor1 = null;
                        if (_this.m_groundAnchor2 === undefined)
                            _this.m_groundAnchor2 = null;
                        if (_this.m_localAnchor1 === undefined)
                            _this.m_localAnchor1 = null;
                        if (_this.m_localAnchor2 === undefined)
                            _this.m_localAnchor2 = null;
                        if (_this.m_J === undefined)
                            _this.m_J = null;
                        if (_this.m_constant === undefined)
                            _this.m_constant = 0;
                        if (_this.m_ratio === undefined)
                            _this.m_ratio = 0;
                        if (_this.m_mass === undefined)
                            _this.m_mass = 0;
                        if (_this.m_force === undefined)
                            _this.m_force = 0;
                        _this.m_J = new org.jbox2d.dynamics.joints.Jacobian();
                        var type1 = def.joint1.getType();
                        var type2 = def.joint2.getType();
                        if (!((type1 === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT || type1 === org.jbox2d.dynamics.joints.JointType.PRISMATIC_JOINT)))
                            throw new Error("Assertion error line 73: assert (type1 == JointType.REVOLUTE_JOINT || type1 == JointType.PRISMATIC_JOINT);");
                        ;
                        if (!((type2 === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT || type2 === org.jbox2d.dynamics.joints.JointType.PRISMATIC_JOINT)))
                            throw new Error("Assertion error line 74: assert (type2 == JointType.REVOLUTE_JOINT || type2 == JointType.PRISMATIC_JOINT);");
                        ;
                        if (!((def.joint1.getBody1().isStatic())))
                            throw new Error("Assertion error line 75: assert (def.joint1.getBody1().isStatic());");
                        ;
                        if (!((def.joint2.getBody1().isStatic())))
                            throw new Error("Assertion error line 76: assert (def.joint2.getBody1().isStatic());");
                        ;
                        _this.m_revolute1 = null;
                        _this.m_prismatic1 = null;
                        _this.m_revolute2 = null;
                        _this.m_prismatic2 = null;
                        var coordinate1;
                        var coordinate2;
                        _this.m_ground1 = def.joint1.getBody1();
                        _this.m_body1 = def.joint1.getBody2();
                        if (type1 === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT) {
                            _this.m_revolute1 = def.joint1;
                            _this.m_groundAnchor1 = _this.m_revolute1.m_localAnchor1;
                            _this.m_localAnchor1 = _this.m_revolute1.m_localAnchor2;
                            coordinate1 = _this.m_revolute1.getJointAngle();
                        }
                        else {
                            _this.m_prismatic1 = def.joint1;
                            _this.m_groundAnchor1 = _this.m_prismatic1.m_localAnchor1;
                            _this.m_localAnchor1 = _this.m_prismatic1.m_localAnchor2;
                            coordinate1 = _this.m_prismatic1.getJointTranslation();
                        }
                        _this.m_ground2 = def.joint2.getBody1();
                        _this.m_body2 = def.joint2.getBody2();
                        if (type2 === org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT) {
                            _this.m_revolute2 = def.joint2;
                            _this.m_groundAnchor2 = _this.m_revolute2.m_localAnchor1;
                            _this.m_localAnchor2 = _this.m_revolute2.m_localAnchor2;
                            coordinate2 = _this.m_revolute2.getJointAngle();
                        }
                        else {
                            _this.m_prismatic2 = def.joint2;
                            _this.m_groundAnchor2 = _this.m_prismatic2.m_localAnchor1;
                            _this.m_localAnchor2 = _this.m_prismatic2.m_localAnchor2;
                            coordinate2 = _this.m_prismatic2.getJointTranslation();
                        }
                        _this.m_ratio = def.ratio;
                        _this.m_constant = Math.fround(coordinate1 + Math.fround(_this.m_ratio * coordinate2));
                        _this.m_force = 0.0;
                        return _this;
                    }
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    GearJoint.prototype.initVelocityConstraints = function (step) {
                        var g1 = this.m_ground1;
                        var g2 = this.m_ground2;
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var ug = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(this.tlug);
                        var r = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(this.tlr);
                        var K = 0.0;
                        this.m_J.setZero();
                        if (this.m_revolute1 != null) {
                            this.m_J.angular1 = -1.0;
                            K += b1.m_invI;
                        }
                        else {
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(g1.getMemberXForm().R, this.m_prismatic1.m_localXAxis1, ug);
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.getMemberXForm().R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r);
                            var crug = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r, ug);
                            this.m_J.linear1.set$org_jbox2d_common_Vec2(ug);
                            this.m_J.linear1.negateLocal();
                            this.m_J.angular1 = -crug;
                            K += Math.fround(b1.m_invMass + Math.fround(Math.fround(b1.m_invI * crug) * crug));
                        }
                        if (this.m_revolute2 != null) {
                            this.m_J.angular2 = -this.m_ratio;
                            K += Math.fround(Math.fround(this.m_ratio * this.m_ratio) * b2.m_invI);
                        }
                        else {
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(g2.getMemberXForm().R, this.m_prismatic2.m_localXAxis1, ug);
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.getMemberXForm().R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r);
                            var crug = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r, ug);
                            this.m_J.linear2.set$org_jbox2d_common_Vec2(ug);
                            this.m_J.linear2.mulLocal(-this.m_ratio);
                            this.m_J.angular2 = Math.fround(-this.m_ratio * crug);
                            K += Math.fround(Math.fround(this.m_ratio * this.m_ratio) * (Math.fround(b2.m_invMass + Math.fround(Math.fround(b2.m_invI * crug) * crug))));
                        }
                        if (!((K > 0.0)))
                            throw new Error("Assertion error line 155: assert (K > 0.0F);");
                        ;
                        this.m_mass = Math.fround(1.0 / K);
                        if (step.warmStarting) {
                            var P = Math.fround(step.dt * this.m_force);
                            b1.m_linearVelocity.x += Math.fround(Math.fround(b1.m_invMass * P) * this.m_J.linear1.x);
                            b1.m_linearVelocity.y += Math.fround(Math.fround(b1.m_invMass * P) * this.m_J.linear1.y);
                            b1.m_angularVelocity += Math.fround(Math.fround(b1.m_invI * P) * this.m_J.angular1);
                            b2.m_linearVelocity.x += Math.fround(Math.fround(b2.m_invMass * P) * this.m_J.linear2.x);
                            b2.m_linearVelocity.y += Math.fround(Math.fround(b2.m_invMass * P) * this.m_J.linear2.y);
                            b2.m_angularVelocity += Math.fround(Math.fround(b2.m_invI * P) * this.m_J.angular2);
                        }
                        else {
                            this.m_force = 0.0;
                        }
                    };
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    GearJoint.prototype.solveVelocityConstraints = function (step) {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var Cdot = this.m_J.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
                        var force = Math.fround(Math.fround(-step.inv_dt * this.m_mass) * Cdot);
                        this.m_force += force;
                        var P = Math.fround(step.dt * force);
                        b1.m_linearVelocity.x += Math.fround(Math.fround(b1.m_invMass * P) * this.m_J.linear1.x);
                        b1.m_linearVelocity.y += Math.fround(Math.fround(b1.m_invMass * P) * this.m_J.linear1.y);
                        b1.m_angularVelocity += Math.fround(Math.fround(b1.m_invI * P) * this.m_J.angular1);
                        b2.m_linearVelocity.x += Math.fround(Math.fround(b2.m_invMass * P) * this.m_J.linear2.x);
                        b2.m_linearVelocity.y += Math.fround(Math.fround(b2.m_invMass * P) * this.m_J.linear2.y);
                        b2.m_angularVelocity += Math.fround(Math.fround(b2.m_invI * P) * this.m_J.angular2);
                    };
                    /**
                     *
                     * @return {boolean}
                     */
                    GearJoint.prototype.solvePositionConstraints = function () {
                        var linearError = 0.0;
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var coordinate1;
                        var coordinate2;
                        if (this.m_revolute1 != null) {
                            coordinate1 = this.m_revolute1.getJointAngle();
                        }
                        else {
                            coordinate1 = this.m_prismatic1.getJointTranslation();
                        }
                        if (this.m_revolute2 != null) {
                            coordinate2 = this.m_revolute2.getJointAngle();
                        }
                        else {
                            coordinate2 = this.m_prismatic2.getJointTranslation();
                        }
                        var C = Math.fround(this.m_constant - (Math.fround(coordinate1 + Math.fround(this.m_ratio * coordinate2))));
                        var impulse = Math.fround(-this.m_mass * C);
                        b1.m_sweep.c.x += Math.fround(Math.fround(b1.m_invMass * impulse) * this.m_J.linear1.x);
                        b1.m_sweep.c.y += Math.fround(Math.fround(b1.m_invMass * impulse) * this.m_J.linear1.y);
                        b1.m_sweep.a += Math.fround(Math.fround(b1.m_invI * impulse) * this.m_J.angular1);
                        b2.m_sweep.c.x += Math.fround(Math.fround(b2.m_invMass * impulse) * this.m_J.linear2.x);
                        b2.m_sweep.c.y += Math.fround(Math.fround(b2.m_invMass * impulse) * this.m_J.linear2.y);
                        b2.m_sweep.a += Math.fround(Math.fround(b2.m_invI * impulse) * this.m_J.angular2);
                        b1.synchronizeTransform();
                        b2.synchronizeTransform();
                        return linearError < org.jbox2d.common.Settings.linearSlop_$LI$();
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    GearJoint.prototype.getAnchor1 = function () {
                        return this.m_body1.getWorldLocation(this.m_localAnchor1);
                    };
                    GearJoint.prototype.getAnchor1ToOut = function (out) {
                        this.m_body1.getWorldLocationToOut(this.m_localAnchor1, out);
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    GearJoint.prototype.getAnchor2 = function () {
                        return this.m_body2.getWorldLocation(this.m_localAnchor2);
                    };
                    GearJoint.prototype.getAnchor2ToOut = function (out) {
                        this.m_body2.getWorldLocationToOut(this.m_localAnchor2, out);
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    GearJoint.prototype.getReactionForce = function () {
                        return new org.jbox2d.common.Vec2(Math.fround(this.m_force * this.m_J.linear2.x), Math.fround(this.m_force * this.m_J.linear2.y));
                    };
                    GearJoint.prototype.getReactionForceToOut = function (out) {
                        out.x = Math.fround(this.m_force * this.m_J.linear2.x);
                        out.y = Math.fround(this.m_force * this.m_J.linear2.y);
                    };
                    /**
                     *
                     * @return {number}
                     */
                    GearJoint.prototype.getReactionTorque = function () {
                        var r = org.jbox2d.common.Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2(this.m_body2.getMemberXForm().R, this.m_localAnchor2.sub(this.m_body2.getMemberLocalCenter()));
                        var F = new org.jbox2d.common.Vec2(Math.fround(this.m_force * this.m_J.linear2.x), Math.fround(this.m_force * this.m_J.linear2.y));
                        var T = Math.fround(Math.fround(this.m_force * this.m_J.angular2) - org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r, F));
                        return T;
                    };
                    GearJoint.prototype.getRatio = function () {
                        return this.m_ratio;
                    };
                    return GearJoint;
                }(org.jbox2d.dynamics.joints.Joint));
                joints.GearJoint = GearJoint;
                GearJoint["__class"] = "org.jbox2d.dynamics.joints.GearJoint";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * Definition for a {@link ConstantVolumeJoint}, which connects a group a bodies together
                 * so they maintain a constant volume within them.
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var ConstantVolumeJointDef = (function (_super) {
                    __extends(ConstantVolumeJointDef, _super);
                    function ConstantVolumeJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.bodies === undefined)
                            _this.bodies = null;
                        if (_this.frequencyHz === undefined)
                            _this.frequencyHz = 0;
                        if (_this.dampingRatio === undefined)
                            _this.dampingRatio = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.CONSTANT_VOLUME_JOINT;
                        _this.bodies = [];
                        _this.collideConnected = false;
                        _this.frequencyHz = 0.0;
                        _this.dampingRatio = 0.0;
                        return _this;
                    }
                    ConstantVolumeJointDef.prototype.addBody = function (b) {
                        var tmp = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(this.bodies.length + 1);
                        /* arraycopy */ (function (srcPts, srcOff, dstPts, dstOff, size) { if (srcPts !== dstPts || dstOff >= srcOff + size) {
                            while (--size >= 0)
                                dstPts[dstOff++] = srcPts[srcOff++];
                        }
                        else {
                            var tmp_1 = srcPts.slice(srcOff, srcOff + size);
                            for (var i = 0; i < size; i++)
                                dstPts[dstOff++] = tmp_1[i];
                        } })(this.bodies, 0, tmp, 0, this.bodies.length);
                        tmp[this.bodies.length] = b;
                        this.bodies = tmp;
                        if (tmp.length === 1) {
                            this.body1 = b;
                        }
                        if (tmp.length === 2) {
                            this.body2 = b;
                        }
                    };
                    return ConstantVolumeJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.ConstantVolumeJointDef = ConstantVolumeJointDef;
                ConstantVolumeJointDef["__class"] = "org.jbox2d.dynamics.joints.ConstantVolumeJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * Definition for a distance joint.  A distance joint
                 * keeps two points on two bodies at a constant distance
                 * from each other.
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var DistanceJointDef = (function (_super) {
                    __extends(DistanceJointDef, _super);
                    function DistanceJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.localAnchor1 === undefined)
                            _this.localAnchor1 = null;
                        if (_this.localAnchor2 === undefined)
                            _this.localAnchor2 = null;
                        if (_this.length === undefined)
                            _this.length = 0;
                        if (_this.frequencyHz === undefined)
                            _this.frequencyHz = 0;
                        if (_this.dampingRatio === undefined)
                            _this.dampingRatio = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.DISTANCE_JOINT;
                        _this.localAnchor1 = new org.jbox2d.common.Vec2(0.0, 0.0);
                        _this.localAnchor2 = new org.jbox2d.common.Vec2(0.0, 0.0);
                        _this.length = 1.0;
                        _this.frequencyHz = 0.0;
                        _this.dampingRatio = 0.0;
                        return _this;
                    }
                    /**
                     * Initialize the bodies, anchors, and length using the world
                     * anchors.
                     * @param {org.jbox2d.dynamics.Body} b1 First body
                     * @param {org.jbox2d.dynamics.Body} b2 Second body
                     * @param {org.jbox2d.common.Vec2} anchor1 World anchor on first body
                     * @param {org.jbox2d.common.Vec2} anchor2 World anchor on second body
                     */
                    DistanceJointDef.prototype.initialize = function (b1, b2, anchor1, anchor2) {
                        this.body1 = b1;
                        this.body2 = b2;
                        this.localAnchor1.set$org_jbox2d_common_Vec2(this.body1.getLocalPoint(anchor1));
                        this.localAnchor2.set$org_jbox2d_common_Vec2(this.body2.getLocalPoint(anchor2));
                        var d = anchor2.sub(anchor1);
                        this.length = d.length();
                    };
                    return DistanceJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.DistanceJointDef = DistanceJointDef;
                DistanceJointDef["__class"] = "org.jbox2d.dynamics.joints.DistanceJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 *
                 * Gear joint definition. This definition requires two existing
                 * revolute or prismatic joints (any combination will work).
                 * The provided joints must attach a dynamic body to a static body.<BR><BR>
                 * A gear joint is used to connect two joints together. Either joint
                 * can be a revolute or prismatic joint. You specify a gear ratio
                 * to bind the motions together:
                 * coordinate1 + ratio * coordinate2 = constant
                 * The ratio can be negative or positive. If one joint is a revolute joint
                 * and the other joint is a prismatic joint, then the ratio will have units
                 * of length or units of 1/length.
                 * <BR><em>Warning</em>: The revolute and prismatic joints must be attached to
                 * fixed bodies (which must be body1 on those joints).
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var GearJointDef = (function (_super) {
                    __extends(GearJointDef, _super);
                    function GearJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.joint1 === undefined)
                            _this.joint1 = null;
                        if (_this.joint2 === undefined)
                            _this.joint2 = null;
                        if (_this.ratio === undefined)
                            _this.ratio = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.GEAR_JOINT;
                        _this.joint1 = null;
                        _this.joint2 = null;
                        _this.ratio = 1.0;
                        return _this;
                    }
                    return GearJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.GearJointDef = GearJointDef;
                GearJointDef["__class"] = "org.jbox2d.dynamics.joints.GearJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * This joint is used to add force to an object to accelerate to a position,
                 * normally used with the mouse.
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var MouseJointDef = (function (_super) {
                    __extends(MouseJointDef, _super);
                    function MouseJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.target === undefined)
                            _this.target = null;
                        if (_this.maxForce === undefined)
                            _this.maxForce = 0;
                        if (_this.frequencyHz === undefined)
                            _this.frequencyHz = 0;
                        if (_this.dampingRatio === undefined)
                            _this.dampingRatio = 0;
                        if (_this.timeStep === undefined)
                            _this.timeStep = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.MOUSE_JOINT;
                        _this.target = new org.jbox2d.common.Vec2(0.0, 0.0);
                        _this.maxForce = 0.0;
                        _this.frequencyHz = 5.0;
                        _this.dampingRatio = 0.7;
                        _this.timeStep = Math.fround(1.0 / 60.0);
                        return _this;
                    }
                    return MouseJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.MouseJointDef = MouseJointDef;
                MouseJointDef["__class"] = "org.jbox2d.dynamics.joints.MouseJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * A prismatic joint definition. This joint provides one degree of freedom: translation
                 * along an axis fixed in body1. Relative rotation is prevented. You can
                 * use a joint limit to restrict the range of motion and a joint motor to
                 * drive the motion or to model joint friction.
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var PrismaticJointDef = (function (_super) {
                    __extends(PrismaticJointDef, _super);
                    function PrismaticJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.localAnchor1 === undefined)
                            _this.localAnchor1 = null;
                        if (_this.localAnchor2 === undefined)
                            _this.localAnchor2 = null;
                        if (_this.localAxis1 === undefined)
                            _this.localAxis1 = null;
                        if (_this.referenceAngle === undefined)
                            _this.referenceAngle = 0;
                        if (_this.enableLimit === undefined)
                            _this.enableLimit = false;
                        if (_this.lowerTranslation === undefined)
                            _this.lowerTranslation = 0;
                        if (_this.upperTranslation === undefined)
                            _this.upperTranslation = 0;
                        if (_this.enableMotor === undefined)
                            _this.enableMotor = false;
                        if (_this.maxMotorForce === undefined)
                            _this.maxMotorForce = 0;
                        if (_this.motorSpeed === undefined)
                            _this.motorSpeed = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.PRISMATIC_JOINT;
                        _this.localAnchor1 = new org.jbox2d.common.Vec2();
                        _this.localAnchor2 = new org.jbox2d.common.Vec2();
                        _this.localAxis1 = new org.jbox2d.common.Vec2();
                        _this.referenceAngle = 0.0;
                        _this.enableLimit = false;
                        _this.lowerTranslation = 0.0;
                        _this.upperTranslation = 0.0;
                        _this.enableMotor = false;
                        _this.maxMotorForce = 0.0;
                        _this.motorSpeed = 0.0;
                        return _this;
                    }
                    PrismaticJointDef.prototype.initialize = function (b1, b2, anchor, axis) {
                        this.body1 = b1;
                        this.body2 = b2;
                        this.body1.getLocalPointToOut(anchor, this.localAnchor1);
                        this.body2.getLocalPointToOut(anchor, this.localAnchor2);
                        this.body1.getLocalVectorToOut(axis, this.localAxis1);
                        this.referenceAngle = Math.fround(this.body2.getAngle() - this.body1.getAngle());
                    };
                    return PrismaticJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.PrismaticJointDef = PrismaticJointDef;
                PrismaticJointDef["__class"] = "org.jbox2d.dynamics.joints.PrismaticJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * The pulley joint is connected to two bodies and two fixed ground points.
                 * The pulley supports a ratio such that:
                 * length1 + ratio * length2 = constant
                 * Yes, the force transmitted is scaled by the ratio.
                 * The pulley also enforces a maximum length limit on both sides. This is
                 * useful to prevent one side of the pulley hitting the top.
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var PulleyJointDef = (function (_super) {
                    __extends(PulleyJointDef, _super);
                    function PulleyJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.groundAnchor1 === undefined)
                            _this.groundAnchor1 = null;
                        if (_this.groundAnchor2 === undefined)
                            _this.groundAnchor2 = null;
                        if (_this.localAnchor1 === undefined)
                            _this.localAnchor1 = null;
                        if (_this.localAnchor2 === undefined)
                            _this.localAnchor2 = null;
                        if (_this.length1 === undefined)
                            _this.length1 = 0;
                        if (_this.maxLength1 === undefined)
                            _this.maxLength1 = 0;
                        if (_this.length2 === undefined)
                            _this.length2 = 0;
                        if (_this.maxLength2 === undefined)
                            _this.maxLength2 = 0;
                        if (_this.ratio === undefined)
                            _this.ratio = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.PULLEY_JOINT;
                        _this.groundAnchor1 = new org.jbox2d.common.Vec2(-1.0, 1.0);
                        _this.groundAnchor2 = new org.jbox2d.common.Vec2(1.0, 1.0);
                        _this.localAnchor1 = new org.jbox2d.common.Vec2(-1.0, 0.0);
                        _this.localAnchor2 = new org.jbox2d.common.Vec2(1.0, 0.0);
                        _this.length1 = 0.0;
                        _this.maxLength1 = 0.0;
                        _this.length2 = 0.0;
                        _this.maxLength2 = 0.0;
                        _this.ratio = 1.0;
                        _this.collideConnected = true;
                        return _this;
                    }
                    PulleyJointDef.prototype.initialize = function (b1, b2, ga1, ga2, anchor1, anchor2, r) {
                        this.body1 = b1;
                        this.body2 = b2;
                        this.groundAnchor1 = ga1;
                        this.groundAnchor2 = ga2;
                        this.localAnchor1 = this.body1.getLocalPoint(anchor1);
                        this.localAnchor2 = this.body2.getLocalPoint(anchor2);
                        var d1 = anchor1.sub(ga1);
                        this.length1 = d1.length();
                        var d2 = anchor2.sub(ga2);
                        this.length2 = d2.length();
                        this.ratio = r;
                        if (!((this.ratio > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 49: assert (ratio > Settings.EPSILON);");
                        ;
                        var C = Math.fround(this.length1 + Math.fround(this.ratio * this.length2));
                        this.maxLength1 = Math.fround(C - Math.fround(this.ratio * org.jbox2d.dynamics.joints.PulleyJoint.MIN_PULLEY_LENGTH));
                        this.maxLength2 = Math.fround((Math.fround(C - org.jbox2d.dynamics.joints.PulleyJoint.MIN_PULLEY_LENGTH)) / this.ratio);
                    };
                    return PulleyJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.PulleyJointDef = PulleyJointDef;
                PulleyJointDef["__class"] = "org.jbox2d.dynamics.joints.PulleyJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * Revolute joint definition. This requires defining an
                 * anchor point where the bodies are joined. The definition
                 * uses local anchor points so that the initial configuration
                 * can violate the constraint slightly. You also need to
                 * specify the initial relative angle for joint limits. This
                 * helps when saving and loading a game.
                 * The local anchor points are measured from the body's origin
                 * rather than the center of mass because:<br/>
                 * <ul>
                 * <li>you might not know where the center of mass will be.</li>
                 * <li>if you add/remove shapes from a body and recompute the mass,
                 * the joints will be broken.</li></ul>
                 * @class
                 * @extends org.jbox2d.dynamics.joints.JointDef
                 */
                var RevoluteJointDef = (function (_super) {
                    __extends(RevoluteJointDef, _super);
                    function RevoluteJointDef() {
                        var _this = _super.call(this) || this;
                        if (_this.localAnchor1 === undefined)
                            _this.localAnchor1 = null;
                        if (_this.localAnchor2 === undefined)
                            _this.localAnchor2 = null;
                        if (_this.referenceAngle === undefined)
                            _this.referenceAngle = 0;
                        if (_this.enableLimit === undefined)
                            _this.enableLimit = false;
                        if (_this.lowerAngle === undefined)
                            _this.lowerAngle = 0;
                        if (_this.upperAngle === undefined)
                            _this.upperAngle = 0;
                        if (_this.enableMotor === undefined)
                            _this.enableMotor = false;
                        if (_this.motorSpeed === undefined)
                            _this.motorSpeed = 0;
                        if (_this.maxMotorTorque === undefined)
                            _this.maxMotorTorque = 0;
                        _this.type = org.jbox2d.dynamics.joints.JointType.REVOLUTE_JOINT;
                        _this.localAnchor1 = new org.jbox2d.common.Vec2(0.0, 0.0);
                        _this.localAnchor2 = new org.jbox2d.common.Vec2(0.0, 0.0);
                        _this.referenceAngle = 0.0;
                        _this.lowerAngle = 0.0;
                        _this.upperAngle = 0.0;
                        _this.maxMotorTorque = 0.0;
                        _this.motorSpeed = 0.0;
                        _this.enableLimit = false;
                        _this.enableMotor = false;
                        return _this;
                    }
                    RevoluteJointDef.prototype.initialize = function (b1, b2, anchor) {
                        this.body1 = b1;
                        this.body2 = b2;
                        this.localAnchor1 = this.body1.getLocalPoint(anchor);
                        this.localAnchor2 = this.body2.getLocalPoint(anchor);
                        this.referenceAngle = Math.fround(this.body2.getAngle() - this.body1.getAngle());
                    };
                    return RevoluteJointDef;
                }(org.jbox2d.dynamics.joints.JointDef));
                joints.RevoluteJointDef = RevoluteJointDef;
                RevoluteJointDef["__class"] = "org.jbox2d.dynamics.joints.RevoluteJointDef";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var arrays;
            (function (arrays) {
                var BooleanArray = (function (_super) {
                    __extends(BooleanArray, _super);
                    function BooleanArray() {
                        return _super !== null && _super.apply(this, arguments) || this;
                    }
                    /**
                     *
                     * @param {number} argLength
                     * @return {Array}
                     */
                    BooleanArray.prototype.getInitializedArray = function (argLength) {
                        var ray = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(argLength);
                        for (var i = 0; i < argLength; i++) {
                            {
                                ray[i] = false;
                            }
                            ;
                        }
                        return ray;
                    };
                    return BooleanArray;
                }(org.jbox2d.pooling.arrays.DynamicTLArray));
                arrays.BooleanArray = BooleanArray;
                BooleanArray["__class"] = "org.jbox2d.pooling.arrays.BooleanArray";
            })(arrays = pooling.arrays || (pooling.arrays = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var arrays;
            (function (arrays) {
                var IntegerArray = (function (_super) {
                    __extends(IntegerArray, _super);
                    function IntegerArray() {
                        return _super !== null && _super.apply(this, arguments) || this;
                    }
                    /**
                     *
                     * @param {number} argLength
                     * @return {Array}
                     */
                    IntegerArray.prototype.getInitializedArray = function (argLength) {
                        return (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(argLength);
                    };
                    return IntegerArray;
                }(org.jbox2d.pooling.arrays.DynamicTLArray));
                arrays.IntegerArray = IntegerArray;
                IntegerArray["__class"] = "org.jbox2d.pooling.arrays.IntegerArray";
            })(arrays = pooling.arrays || (pooling.arrays = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var arrays;
            (function (arrays) {
                var Vec2Array = (function (_super) {
                    __extends(Vec2Array, _super);
                    function Vec2Array() {
                        return _super !== null && _super.apply(this, arguments) || this;
                    }
                    /**
                     *
                     * @param {number} argLength
                     * @return {Array}
                     */
                    Vec2Array.prototype.getInitializedArray = function (argLength) {
                        var ray = (function (s) { var a = []; while (s-- > 0)
                            a.push(null); return a; })(argLength);
                        for (var i = 0; i < ray.length; i++) {
                            {
                                ray[i] = new org.jbox2d.common.Vec2();
                            }
                            ;
                        }
                        return ray;
                    };
                    return Vec2Array;
                }(org.jbox2d.pooling.arrays.DynamicTLArray));
                arrays.Vec2Array = Vec2Array;
                Vec2Array["__class"] = "org.jbox2d.pooling.arrays.Vec2Array";
            })(arrays = pooling.arrays || (pooling.arrays = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var stacks;
            (function (stacks) {
                var ContactSolverStack = (function (_super) {
                    __extends(ContactSolverStack, _super);
                    function ContactSolverStack() {
                        return _super !== null && _super.apply(this, arguments) || this;
                    }
                    /**
                     *
                     * @return {org.jbox2d.dynamics.contacts.ContactSolver}
                     */
                    ContactSolverStack.prototype.newObjectInstance = function () {
                        return new org.jbox2d.dynamics.contacts.ContactSolver();
                    };
                    return ContactSolverStack;
                }(org.jbox2d.pooling.stacks.DynamicTLStack));
                stacks.ContactSolverStack = ContactSolverStack;
                ContactSolverStack["__class"] = "org.jbox2d.pooling.stacks.ContactSolverStack";
            })(stacks = pooling.stacks || (pooling.stacks = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var stacks;
            (function (stacks) {
                var IslandStack = (function (_super) {
                    __extends(IslandStack, _super);
                    function IslandStack() {
                        return _super !== null && _super.apply(this, arguments) || this;
                    }
                    /**
                     *
                     * @return {org.jbox2d.dynamics.Island}
                     */
                    IslandStack.prototype.newObjectInstance = function () {
                        return new org.jbox2d.dynamics.Island();
                    };
                    return IslandStack;
                }(org.jbox2d.pooling.stacks.DynamicTLStack));
                stacks.IslandStack = IslandStack;
                IslandStack["__class"] = "org.jbox2d.pooling.stacks.IslandStack";
            })(stacks = pooling.stacks || (pooling.stacks = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var pooling;
        (function (pooling) {
            var stacks;
            (function (stacks) {
                var TimeStepStack = (function (_super) {
                    __extends(TimeStepStack, _super);
                    function TimeStepStack() {
                        return _super !== null && _super.apply(this, arguments) || this;
                    }
                    /**
                     *
                     * @return {org.jbox2d.dynamics.TimeStep}
                     */
                    TimeStepStack.prototype.newObjectInstance = function () {
                        return new org.jbox2d.dynamics.TimeStep();
                    };
                    return TimeStepStack;
                }(org.jbox2d.pooling.stacks.DynamicTLStack));
                stacks.TimeStepStack = TimeStepStack;
                TimeStepStack["__class"] = "org.jbox2d.pooling.stacks.TimeStepStack";
            })(stacks = pooling.stacks || (pooling.stacks = {}));
        })(pooling = jbox2d.pooling || (jbox2d.pooling = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var shapes;
            (function (shapes) {
                /**
                 * A shape is used for collision detection. Shapes are created in World.
                 * You can use shape for collision detection before they are attached to the world.
                 * <BR><BR><em>Warning</em>: you cannot reuse shapes on different bodies, they must
                 * be re-created or copied.
                 * @param {org.jbox2d.collision.shapes.ShapeDef} def
                 * @class
                 */
                var Shape = (function () {
                    function Shape(def) {
                        if (this.uid === undefined)
                            this.uid = 0;
                        if (this.m_type === undefined)
                            this.m_type = null;
                        if (this.m_next === undefined)
                            this.m_next = null;
                        if (this.m_body === undefined)
                            this.m_body = null;
                        if (this.m_sweepRadius === undefined)
                            this.m_sweepRadius = 0;
                        if (this.m_density === undefined)
                            this.m_density = 0;
                        if (this.m_friction === undefined)
                            this.m_friction = 0;
                        if (this.m_restitution === undefined)
                            this.m_restitution = 0;
                        if (this.m_proxyId === undefined)
                            this.m_proxyId = 0;
                        if (this.m_filter === undefined)
                            this.m_filter = null;
                        if (this.m_isSensor === undefined)
                            this.m_isSensor = false;
                        if (this.m_userData === undefined)
                            this.m_userData = null;
                        this.uid = Shape.uidcount++;
                        this.m_userData = def.userData;
                        this.m_friction = def.friction;
                        this.m_restitution = def.restitution;
                        this.m_density = def.density;
                        this.m_body = null;
                        this.m_sweepRadius = 0.0;
                        this.m_next = null;
                        this.m_proxyId = org.jbox2d.collision.PairManager.NULL_PROXY_$LI$();
                        this.m_filter = new org.jbox2d.collision.FilterData();
                        this.m_filter.categoryBits = def.filter.categoryBits;
                        this.m_filter.maskBits = def.filter.maskBits;
                        this.m_filter.groupIndex = def.filter.groupIndex;
                        this.m_isSensor = def.isSensor;
                    }
                    /**
                     * Get the coefficient of friction.
                     * @return {number}
                     */
                    Shape.prototype.getFriction = function () {
                        return this.m_friction;
                    };
                    /**
                     * Set the coefficient of friction.
                     * @param {number} friction
                     */
                    Shape.prototype.setFriction = function (friction) {
                        this.m_friction = friction;
                    };
                    /**
                     * Get the coefficient of restitution.
                     * @return {number}
                     */
                    Shape.prototype.getRestitution = function () {
                        return this.m_restitution;
                    };
                    /**
                     * Set the coefficient of restitution.
                     * @param {number} restitution
                     */
                    Shape.prototype.setRestitution = function (restitution) {
                        this.m_restitution = restitution;
                    };
                    /**
                     * Set the collision filtering data.
                     * @param {org.jbox2d.collision.FilterData} filter
                     */
                    Shape.prototype.setFilterData = function (filter) {
                        this.m_filter.set(filter);
                    };
                    /**
                     * Get the collision filtering data.
                     * @return {org.jbox2d.collision.FilterData}
                     */
                    Shape.prototype.getFilterData = function () {
                        return this.m_filter;
                    };
                    /**
                     * Get the type of this shape. You can use this to down cast to the concrete shape.
                     * @return {org.jbox2d.collision.shapes.ShapeType} the shape type.
                     */
                    Shape.prototype.getType = function () {
                        return this.m_type;
                    };
                    /**
                     * Is this shape a sensor (non-solid)?
                     * @return {boolean} the true if the shape is a sensor.
                     */
                    Shape.prototype.isSensor = function () {
                        return this.m_isSensor;
                    };
                    /**
                     * Get the user data that was assigned in the shape definition. Use this to
                     * store your application specific data.
                     * @return {*}
                     */
                    Shape.prototype.getUserData = function () {
                        return this.m_userData;
                    };
                    /**
                     * Set the user data associated with the object.
                     * @param {*} o User data to set
                     */
                    Shape.prototype.setUserData = function (o) {
                        this.m_userData = o;
                    };
                    /**
                     * Get the parent body of this shape. This is NULL if the shape is not attached.
                     * @return {org.jbox2d.dynamics.Body} the parent body.
                     */
                    Shape.prototype.getBody = function () {
                        return this.m_body;
                    };
                    /**
                     * Get the next shape in the parent body's shape list.
                     * @return {org.jbox2d.collision.shapes.Shape} the next shape.
                     */
                    Shape.prototype.getNext = function () {
                        return this.m_next;
                    };
                    /**
                     * Get the sweep radius of the shape.
                     * @return {number} the sweep radius
                     */
                    Shape.prototype.getSweepRadius = function () {
                        return this.m_sweepRadius;
                    };
                    Shape.tlAabb_$LI$ = function () { if (Shape.tlAabb == null)
                        Shape.tlAabb = (function () { var __o = new org.jbox2d.pooling.TLAABB(); __o.__delegate = new org.jbox2d.pooling.TLAABB(); return __o; })(); return Shape.tlAabb; };
                    ;
                    /**
                     * Internal
                     * @param {org.jbox2d.collision.BroadPhase} broadPhase
                     * @param {org.jbox2d.common.XForm} transform1
                     * @param {org.jbox2d.common.XForm} transform2
                     * @return {boolean}
                     */
                    Shape.prototype.synchronize = function (broadPhase, transform1, transform2) {
                        if (this.m_proxyId === org.jbox2d.collision.PairManager.NULL_PROXY_$LI$()) {
                            return false;
                        }
                        var aabb = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(Shape.tlAabb_$LI$());
                        this.computeSweptAABB(aabb, transform1, transform2);
                        if (broadPhase.inRange(aabb)) {
                            broadPhase.moveProxy(this.m_proxyId, aabb);
                            return true;
                        }
                        else {
                            return false;
                        }
                    };
                    /**
                     * Internal
                     * @param {org.jbox2d.collision.BroadPhase} broadPhase
                     * @param {org.jbox2d.common.XForm} transform
                     */
                    Shape.prototype.refilterProxy = function (broadPhase, transform) {
                        if (this.m_proxyId === org.jbox2d.collision.PairManager.NULL_PROXY_$LI$()) {
                            return;
                        }
                        broadPhase.destroyProxy(this.m_proxyId);
                        var aabb = new org.jbox2d.collision.AABB();
                        this.computeAABB(aabb, transform);
                        var inRange = broadPhase.inRange(aabb);
                        if (inRange) {
                            this.m_proxyId = broadPhase.createProxy(aabb, this);
                        }
                        else {
                            this.m_proxyId = org.jbox2d.collision.PairManager.NULL_PROXY_$LI$();
                        }
                    };
                    /**
                     * Internal
                     * @param {org.jbox2d.collision.shapes.ShapeDef} def
                     * @return {org.jbox2d.collision.shapes.Shape}
                     */
                    Shape.create = function (def) {
                        if (def.type === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE) {
                            return new org.jbox2d.collision.shapes.CircleShape(def);
                        }
                        else if (def.type === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE) {
                            return new org.jbox2d.collision.shapes.PolygonShape(def);
                        }
                        else if (def.type === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE) {
                            return new org.jbox2d.collision.shapes.PointShape(def);
                        }
                        if (!(false))
                            throw new Error("Assertion error line 287: assert false;");
                        ;
                        return null;
                    };
                    /**
                     * Internal
                     * @param {org.jbox2d.collision.shapes.Shape} s
                     */
                    Shape.destroy = function (s) {
                        if (s.getType() === org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE) {
                            var edge = s;
                            if (edge.m_nextEdge != null) {
                                edge.m_nextEdge.m_prevEdge = null;
                            }
                            if (edge.m_prevEdge != null) {
                                edge.m_prevEdge.m_nextEdge = null;
                            }
                        }
                        s.destructor();
                    };
                    /**
                     * Internal
                     */
                    Shape.prototype.destructor = function () {
                        if (!((this.m_proxyId === org.jbox2d.collision.PairManager.NULL_PROXY_$LI$())))
                            throw new Error("Assertion error line 312: assert (m_proxyId == PairManager.NULL_PROXY);");
                        ;
                    };
                    /**
                     * Internal
                     * @param {org.jbox2d.collision.BroadPhase} broadPhase
                     * @param {org.jbox2d.common.XForm} transform
                     */
                    Shape.prototype.createProxy = function (broadPhase, transform) {
                        if (!((this.m_proxyId === org.jbox2d.collision.PairManager.NULL_PROXY_$LI$())))
                            throw new Error("Assertion error line 321: assert (m_proxyId == PairManager.NULL_PROXY);");
                        ;
                        var aabb = new org.jbox2d.collision.AABB();
                        this.computeAABB(aabb, transform);
                        var inRange = broadPhase.inRange(aabb);
                        if (!((inRange)))
                            throw new Error("Assertion error line 325: assert (inRange);");
                        ;
                        if (inRange) {
                            this.m_proxyId = broadPhase.createProxy(aabb, this);
                        }
                        else {
                            this.m_proxyId = org.jbox2d.collision.PairManager.NULL_PROXY_$LI$();
                        }
                    };
                    /**
                     * Internal
                     * @param {org.jbox2d.collision.BroadPhase} broadPhase
                     */
                    Shape.prototype.destroyProxy = function (broadPhase) {
                        if (this.m_proxyId !== org.jbox2d.collision.PairManager.NULL_PROXY_$LI$()) {
                            broadPhase.destroyProxy(this.m_proxyId);
                            this.m_proxyId = org.jbox2d.collision.PairManager.NULL_PROXY_$LI$();
                        }
                    };
                    Shape.prototype.computeSubmergedArea$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2 = function (normal, offset, c) {
                        return this.computeSubmergedArea$org_jbox2d_common_Vec2$float$org_jbox2d_common_XForm$org_jbox2d_common_Vec2(normal, offset, this.m_body.getXForm(), c);
                    };
                    Shape.prototype.computeSubmergedArea$org_jbox2d_common_Vec2$float$org_jbox2d_common_XForm$org_jbox2d_common_Vec2 = function (normal, offset, form, c) {
                        return 0;
                    };
                    /**
                     * @param {org.jbox2d.common.Vec2} normal
                     * @param {number} offset
                     * @param {org.jbox2d.common.XForm} form
                     * @param {org.jbox2d.common.Vec2} c
                     * @return
                     * @return {number}
                     */
                    Shape.prototype.computeSubmergedArea = function (normal, offset, form, c) {
                        if (((normal != null && normal instanceof org.jbox2d.common.Vec2) || normal === null) && ((typeof offset === 'number') || offset === null) && ((form != null && form instanceof org.jbox2d.common.XForm) || form === null) && ((c != null && c instanceof org.jbox2d.common.Vec2) || c === null)) {
                            return this.computeSubmergedArea$org_jbox2d_common_Vec2$float$org_jbox2d_common_XForm$org_jbox2d_common_Vec2(normal, offset, form, c);
                        }
                        else if (((normal != null && normal instanceof org.jbox2d.common.Vec2) || normal === null) && ((typeof offset === 'number') || offset === null) && ((form != null && form instanceof org.jbox2d.common.Vec2) || form === null) && c === undefined) {
                            return this.computeSubmergedArea$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2(normal, offset, form);
                        }
                        else
                            throw new Error('invalid overload');
                    };
                    /**
                     * @return {number} shape density
                     */
                    Shape.prototype.getDensity = function () {
                        return this.m_density;
                    };
                    /**
                     * @return {org.jbox2d.collision.shapes.Shape[]} a Set<Shape> of all shapes in contact with this one
                     */
                    Shape.prototype.getShapesInContact = function () {
                        var curr = this.m_body.getContactList();
                        var touching = ([]);
                        while ((curr != null)) {
                            {
                                if (curr.contact.m_shape1 === this) {
                                    /* add */ (function (s, e) { if (s.indexOf(e) == -1) {
                                        s.push(e);
                                        return true;
                                    }
                                    else {
                                        return false;
                                    } })(touching, curr.contact.m_shape2);
                                }
                                else if (curr.contact.m_shape2 === this) {
                                    /* add */ (function (s, e) { if (s.indexOf(e) == -1) {
                                        s.push(e);
                                        return true;
                                    }
                                    else {
                                        return false;
                                    } })(touching, curr.contact.m_shape1);
                                }
                                curr = curr.next;
                            }
                        }
                        ;
                        return touching;
                    };
                    /**
                     * @return {org.jbox2d.dynamics.contacts.Contact[]} a Set<Contact> of all (active) contacts involving this shape
                     */
                    Shape.prototype.getContacts = function () {
                        var curr = this.m_body.getContactList();
                        var contacts = ([]);
                        while ((curr != null)) {
                            {
                                if (curr.contact.getManifoldCount() > 0) {
                                    if (curr.contact.m_shape1 === this) {
                                        /* add */ (function (s, e) { if (s.indexOf(e) == -1) {
                                            s.push(e);
                                            return true;
                                        }
                                        else {
                                            return false;
                                        } })(contacts, curr.contact);
                                    }
                                    else if (curr.contact.m_shape2 === this) {
                                        /* add */ (function (s, e) { if (s.indexOf(e) == -1) {
                                            s.push(e);
                                            return true;
                                        }
                                        else {
                                            return false;
                                        } })(contacts, curr.contact);
                                    }
                                }
                                curr = curr.next;
                            }
                        }
                        ;
                        return contacts;
                    };
                    /**
                     *
                     * @return {string}
                     */
                    Shape.prototype.toString = function () {
                        return "shape:" + (this.m_type == null ? "unknown" : org.jbox2d.collision.shapes.ShapeType[this.m_type]) + "_uid=" + this.uid;
                    };
                    return Shape;
                }());
                /**
                 * Used to generate uids - not initialized on applet reload,
                 * but that's okay since these just have to be unique.
                 */
                Shape.uidcount = 0;
                shapes.Shape = Shape;
                Shape["__class"] = "org.jbox2d.collision.shapes.Shape";
            })(shapes = collision.shapes || (collision.shapes = {}));
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var common;
        (function (common) {
            var OBBViewportTransform = (function () {
                function OBBViewportTransform() {
                    this.box = new org.jbox2d.collision.OBB();
                    /*private*/ this.yFlip = false;
                    /*private*/ this.yFlipMat = new org.jbox2d.common.Mat22(1, 0, 0, -1);
                    /*private*/ this.yFlipMatInv = this.yFlipMat.invert();
                    this.box.R.setIdentity();
                }
                OBBViewportTransform.prototype.set = function (vpt) {
                    this.box.center.set$org_jbox2d_common_Vec2(vpt.box.center);
                    this.box.extents.set$org_jbox2d_common_Vec2(vpt.box.extents);
                    this.box.R.set$org_jbox2d_common_Mat22(vpt.box.R);
                    this.yFlip = vpt.yFlip;
                };
                /**
                 * @see IViewportTransform#setCamera(float, float, float)
                 * @param {number} x
                 * @param {number} y
                 * @param {number} scale
                 */
                OBBViewportTransform.prototype.setCamera = function (x, y, scale) {
                    this.box.center.set$float$float(x, y);
                    org.jbox2d.common.Mat22.createScaleTransform$float$org_jbox2d_common_Mat22(scale, this.box.R);
                };
                /**
                 * @see IViewportTransform#getExtents()
                 * @return {org.jbox2d.common.Vec2}
                 */
                OBBViewportTransform.prototype.getExtents = function () {
                    return this.box.extents;
                };
                OBBViewportTransform.prototype.setExtents$org_jbox2d_common_Vec2 = function (argExtents) {
                    this.box.extents.set$org_jbox2d_common_Vec2(argExtents);
                };
                OBBViewportTransform.prototype.setExtents$float$float = function (argHalfWidth, argHalfHeight) {
                    this.box.extents.set$float$float(argHalfWidth, argHalfHeight);
                };
                /**
                 * @see IViewportTransform#setExtents(float, float)
                 * @param {number} argHalfWidth
                 * @param {number} argHalfHeight
                 */
                OBBViewportTransform.prototype.setExtents = function (argHalfWidth, argHalfHeight) {
                    if (((typeof argHalfWidth === 'number') || argHalfWidth === null) && ((typeof argHalfHeight === 'number') || argHalfHeight === null)) {
                        return this.setExtents$float$float(argHalfWidth, argHalfHeight);
                    }
                    else if (((argHalfWidth != null && argHalfWidth instanceof org.jbox2d.common.Vec2) || argHalfWidth === null) && argHalfHeight === undefined) {
                        return this.setExtents$org_jbox2d_common_Vec2(argHalfWidth);
                    }
                    else
                        throw new Error('invalid overload');
                };
                /**
                 * @see IViewportTransform#getCenter()
                 * @return {org.jbox2d.common.Vec2}
                 */
                OBBViewportTransform.prototype.getCenter = function () {
                    return this.box.center;
                };
                OBBViewportTransform.prototype.setCenter$org_jbox2d_common_Vec2 = function (argPos) {
                    this.box.center.set$org_jbox2d_common_Vec2(argPos);
                };
                OBBViewportTransform.prototype.setCenter$float$float = function (x, y) {
                    this.box.center.set$float$float(x, y);
                };
                /**
                 * @see IViewportTransform#setCenter(float, float)
                 * @param {number} x
                 * @param {number} y
                 */
                OBBViewportTransform.prototype.setCenter = function (x, y) {
                    if (((typeof x === 'number') || x === null) && ((typeof y === 'number') || y === null)) {
                        return this.setCenter$float$float(x, y);
                    }
                    else if (((x != null && x instanceof org.jbox2d.common.Vec2) || x === null) && y === undefined) {
                        return this.setCenter$org_jbox2d_common_Vec2(x);
                    }
                    else
                        throw new Error('invalid overload');
                };
                /**
                 * gets the transform of the viewport, transforms around the center.
                 * Not a copy.
                 * @return
                 * @return {org.jbox2d.common.Mat22}
                 */
                OBBViewportTransform.prototype.getTransform = function () {
                    return this.box.R;
                };
                /**
                 * Sets the transform of the viewport.  Transforms about the center.
                 * @param {org.jbox2d.common.Mat22} transform
                 */
                OBBViewportTransform.prototype.setTransform = function (transform) {
                    this.box.R.set$org_jbox2d_common_Mat22(transform);
                };
                /**
                 * Lerps to the given transform
                 * @param {org.jbox2d.common.Mat22} transform
                 * @param {number} amt
                 */
                OBBViewportTransform.prototype.lerpTransform = function (transform, amt) {
                    this.box.R.col1.x += Math.fround((Math.fround(transform.col1.x - this.box.R.col1.x)) * amt);
                    this.box.R.col1.y += Math.fround((Math.fround(transform.col1.y - this.box.R.col1.y)) * amt);
                    this.box.R.col2.x += Math.fround((Math.fround(transform.col2.x - this.box.R.col2.x)) * amt);
                    this.box.R.col2.y += Math.fround((Math.fround(transform.col2.y - this.box.R.col2.y)) * amt);
                };
                /**
                 * Multiplies the obb transform by the given transform
                 * @param {org.jbox2d.common.Mat22} argTransform
                 */
                OBBViewportTransform.prototype.mulByTransform = function (argTransform) {
                    this.box.R.mulLocal(argTransform);
                };
                /**
                 * @see IViewportTransform#isYFlip()
                 * @return {boolean}
                 */
                OBBViewportTransform.prototype.isYFlip = function () {
                    return this.yFlip;
                };
                /**
                 * @see IViewportTransform#setYFlip(boolean)
                 * @param {boolean} yFlip
                 */
                OBBViewportTransform.prototype.setYFlip = function (yFlip) {
                    this.yFlip = yFlip;
                };
                OBBViewportTransform.tlInv_$LI$ = function () { if (OBBViewportTransform.tlInv == null)
                    OBBViewportTransform.tlInv = (function () { var __o = new org.jbox2d.pooling.TLMat22(); __o.__delegate = new org.jbox2d.pooling.TLMat22(); return __o; })(); return OBBViewportTransform.tlInv; };
                ;
                /**
                 * @see IViewportTransform#vectorInverseTransform(Vec2, Vec2)
                 * @param {org.jbox2d.common.Vec2} argScreen
                 * @param {org.jbox2d.common.Vec2} argWorld
                 */
                OBBViewportTransform.prototype.vectorInverseTransform = function (argScreen, argWorld) {
                    var inv = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(OBBViewportTransform.tlInv_$LI$());
                    inv.set$org_jbox2d_common_Mat22(this.box.R);
                    inv.invertLocal();
                    inv.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argScreen, argWorld);
                    if (this.yFlip) {
                        this.yFlipMatInv.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argWorld, argWorld);
                    }
                };
                /**
                 * @see IViewportTransform#vectorTransform(Vec2, Vec2)
                 * @param {org.jbox2d.common.Vec2} argWorld
                 * @param {org.jbox2d.common.Vec2} argScreen
                 */
                OBBViewportTransform.prototype.vectorTransform = function (argWorld, argScreen) {
                    this.box.R.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argWorld, argScreen);
                    if (this.yFlip) {
                        this.yFlipMat.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argScreen, argScreen);
                    }
                };
                /**
                 * @see IViewportTransform#getWorldToScreen(Vec2, Vec2)
                 * @param {org.jbox2d.common.Vec2} argWorld
                 * @param {org.jbox2d.common.Vec2} argScreen
                 */
                OBBViewportTransform.prototype.getWorldToScreen = function (argWorld, argScreen) {
                    argScreen.set$org_jbox2d_common_Vec2(argWorld);
                    argScreen.subLocal(this.box.center);
                    this.box.R.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argScreen, argScreen);
                    if (this.yFlip) {
                        this.yFlipMat.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argScreen, argScreen);
                    }
                    argScreen.addLocal$org_jbox2d_common_Vec2(this.box.extents);
                };
                /**
                 * @see IViewportTransform#getScreenToWorld(Vec2, Vec2)
                 * @param {org.jbox2d.common.Vec2} argScreen
                 * @param {org.jbox2d.common.Vec2} argWorld
                 */
                OBBViewportTransform.prototype.getScreenToWorld = function (argScreen, argWorld) {
                    argWorld.set$org_jbox2d_common_Vec2(argScreen);
                    argWorld.subLocal(this.box.extents);
                    var inv = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(OBBViewportTransform.tlInv_$LI$());
                    this.box.R.invertToOut(inv);
                    inv.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argWorld, argWorld);
                    if (this.yFlip) {
                        this.yFlipMatInv.mulToOut$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(argWorld, argWorld);
                    }
                    argWorld.addLocal$org_jbox2d_common_Vec2(this.box.center);
                };
                return OBBViewportTransform;
            }());
            common.OBBViewportTransform = OBBViewportTransform;
            OBBViewportTransform["__class"] = "org.jbox2d.common.OBBViewportTransform";
            OBBViewportTransform["__interfaces"] = ["org.jbox2d.common.IViewportTransform"];
        })(common = jbox2d.common || (jbox2d.common = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var collision;
        (function (collision) {
            var Segment = (function () {
                function Segment() {
                    /**
                     * The starting point
                     */
                    this.p1 = new org.jbox2d.common.Vec2();
                    /**
                     * The ending point
                     */
                    this.p2 = new org.jbox2d.common.Vec2();
                }
                Segment.prototype.toString = function () {
                    return "p1: " + this.p1 + "; p2: " + this.p2;
                };
                Segment.tlR_$LI$ = function () { if (Segment.tlR == null)
                    Segment.tlR = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return Segment.tlR; };
                ;
                Segment.tlD_$LI$ = function () { if (Segment.tlD == null)
                    Segment.tlD = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return Segment.tlD; };
                ;
                Segment.tlN_$LI$ = function () { if (Segment.tlN == null)
                    Segment.tlN = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return Segment.tlN; };
                ;
                Segment.tlB_$LI$ = function () { if (Segment.tlB == null)
                    Segment.tlB = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return Segment.tlB; };
                ;
                Segment.prototype.testSegment = function (out, segment, maxLambda) {
                    var s = segment.p1;
                    var r = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(Segment.tlR_$LI$()).set$org_jbox2d_common_Vec2(segment.p2);
                    r.subLocal(s);
                    var d = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(Segment.tlD_$LI$()).set$org_jbox2d_common_Vec2(this.p2);
                    d.subLocal(this.p1);
                    var n = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(Segment.tlN_$LI$());
                    org.jbox2d.common.Vec2.crossToOut$org_jbox2d_common_Vec2$float$org_jbox2d_common_Vec2(d, 1.0, n);
                    var b = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(Segment.tlB_$LI$());
                    var k_slop = Math.fround(100.0 * org.jbox2d.common.Settings.EPSILON);
                    var denom = -org.jbox2d.common.Vec2.dot(r, n);
                    if (denom > k_slop) {
                        b.set$org_jbox2d_common_Vec2(s);
                        b.subLocal(this.p1);
                        var a = org.jbox2d.common.Vec2.dot(b, n);
                        if (0.0 <= a && a <= Math.fround(maxLambda * denom)) {
                            var mu2 = Math.fround(Math.fround(-r.x * b.y) + Math.fround(r.y * b.x));
                            if (Math.fround(-k_slop * denom) <= mu2 && mu2 <= Math.fround(denom * (Math.fround(1.0 + k_slop)))) {
                                a /= denom;
                                n.normalize();
                                out.lambda = a;
                                out.normal.set$org_jbox2d_common_Vec2(n);
                                return true;
                            }
                        }
                    }
                    return false;
                };
                return Segment;
            }());
            collision.Segment = Segment;
            Segment["__class"] = "org.jbox2d.collision.Segment";
        })(collision = jbox2d.collision || (jbox2d.collision = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            /**
             * Delegate of World - for internal use.
             * @class
             */
            var ContactManager = (function () {
                function ContactManager() {
                    if (this.m_world === undefined)
                        this.m_world = null;
                    if (this.m_nullContact === undefined)
                        this.m_nullContact = null;
                    if (this.m_destroyImmediate === undefined)
                        this.m_destroyImmediate = false;
                    this.m_nullContact = new org.jbox2d.dynamics.contacts.NullContact();
                    this.m_destroyImmediate = false;
                }
                ContactManager.prototype.pairAdded = function (proxyUserData1, proxyUserData2) {
                    var shape1 = proxyUserData1;
                    var shape2 = proxyUserData2;
                    if (shape1 == null || shape2 == null) {
                        return this.m_nullContact;
                    }
                    var body1 = shape1.getBody();
                    var body2 = shape2.getBody();
                    if (body1.isStatic() && body2.isStatic()) {
                        return this.m_nullContact;
                    }
                    if (shape1.getBody() === shape2.getBody()) {
                        return this.m_nullContact;
                    }
                    if (body2.isConnected(body1)) {
                        return this.m_nullContact;
                    }
                    if (this.m_world.m_contactFilter != null && this.m_world.m_contactFilter.shouldCollide(shape1, shape2) === false) {
                        return this.m_nullContact;
                    }
                    var c = org.jbox2d.dynamics.contacts.Contact.createContact(shape1, shape2);
                    if (c == null) {
                        return this.m_nullContact;
                    }
                    shape1 = c.getShape1();
                    shape2 = c.getShape2();
                    body1 = shape1.getBody();
                    body2 = shape2.getBody();
                    c.m_prev = null;
                    c.m_next = this.m_world.m_contactList;
                    if (this.m_world.m_contactList != null) {
                        this.m_world.m_contactList.m_prev = c;
                    }
                    this.m_world.m_contactList = c;
                    c.m_node1.contact = c;
                    c.m_node1.other = body2;
                    c.m_node1.prev = null;
                    c.m_node1.next = body1.m_contactList;
                    if (body1.m_contactList != null) {
                        body1.m_contactList.prev = c.m_node1;
                    }
                    body1.m_contactList = c.m_node1;
                    c.m_node2.contact = c;
                    c.m_node2.other = body1;
                    c.m_node2.prev = null;
                    c.m_node2.next = body2.m_contactList;
                    if (body2.m_contactList != null) {
                        body2.m_contactList.prev = c.m_node2;
                    }
                    body2.m_contactList = c.m_node2;
                    ++this.m_world.m_contactCount;
                    return c;
                };
                ContactManager.prototype.pairRemoved = function (proxyUserData1, proxyUserData2, pairUserData) {
                    if (pairUserData == null) {
                        return;
                    }
                    var c = pairUserData;
                    if (c === this.m_nullContact) {
                        return;
                    }
                    this.destroy(c);
                };
                ContactManager.tlV1_$LI$ = function () { if (ContactManager.tlV1 == null)
                    ContactManager.tlV1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return ContactManager.tlV1; };
                ;
                ContactManager.tlCp_$LI$ = function () { if (ContactManager.tlCp == null)
                    ContactManager.tlCp = (function () { var __o = new org.jbox2d.pooling.TLContactPoint(); __o.__delegate = new org.jbox2d.pooling.TLContactPoint(); return __o; })(); return ContactManager.tlCp; };
                ;
                ContactManager.prototype.destroy = function (c) {
                    var v1 = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(ContactManager.tlV1_$LI$());
                    var cp = (function (tlObj) { if (tlObj.___value) {
                        return tlObj.___value;
                    }
                    else {
                        return tlObj.___value = tlObj.initialValue();
                    } })(ContactManager.tlCp_$LI$());
                    var shape1 = c.getShape1();
                    var shape2 = c.getShape2();
                    var manifoldCount = c.getManifoldCount();
                    if (manifoldCount > 0 && (this.m_world.m_contactListener != null)) {
                        var b1 = shape1.getBody();
                        var b2 = shape2.getBody();
                        var manifolds = c.getManifolds();
                        cp.shape1 = c.getShape1();
                        cp.shape2 = c.getShape2();
                        cp.friction = c.m_friction;
                        cp.restitution = c.m_restitution;
                        for (var i = 0; i < manifoldCount; ++i) {
                            {
                                var manifold = manifolds[i];
                                cp.normal.set$org_jbox2d_common_Vec2(manifold.normal);
                                for (var j = 0; j < manifold.pointCount; ++j) {
                                    {
                                        var mp = manifold.points[j];
                                        b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                        b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                        b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                        cp.velocity.subLocal(v1);
                                        cp.separation = mp.separation;
                                        cp.id.set(mp.id);
                                        this.m_world.m_contactListener.remove(cp);
                                    }
                                    ;
                                }
                            }
                            ;
                        }
                    }
                    if (c.m_prev != null) {
                        c.m_prev.m_next = c.m_next;
                    }
                    if (c.m_next != null) {
                        c.m_next.m_prev = c.m_prev;
                    }
                    if (c === this.m_world.m_contactList) {
                        this.m_world.m_contactList = c.m_next;
                    }
                    var body1 = shape1.getBody();
                    var body2 = shape2.getBody();
                    if (c.m_node1.prev != null) {
                        c.m_node1.prev.next = c.m_node1.next;
                    }
                    if (c.m_node1.next != null) {
                        c.m_node1.next.prev = c.m_node1.prev;
                    }
                    if (c.m_node1 === body1.m_contactList) {
                        body1.m_contactList = c.m_node1.next;
                    }
                    if (c.m_node2.prev != null) {
                        c.m_node2.prev.next = c.m_node2.next;
                    }
                    if (c.m_node2.next != null) {
                        c.m_node2.next.prev = c.m_node2.prev;
                    }
                    if (c.m_node2 === body2.m_contactList) {
                        body2.m_contactList = c.m_node2.next;
                    }
                    org.jbox2d.dynamics.contacts.Contact.destroy(c);
                    --this.m_world.m_contactCount;
                };
                ContactManager.prototype.collide = function () {
                    for (var c = this.m_world.m_contactList; c != null; c = c.getNext()) {
                        {
                            var body1 = c.getShape1().getBody();
                            var body2 = c.getShape2().getBody();
                            if (body1.isSleeping() && body2.isSleeping()) {
                                continue;
                            }
                            c.update(this.m_world.m_contactListener);
                        }
                        ;
                    }
                };
                return ContactManager;
            }());
            dynamics.ContactManager = ContactManager;
            ContactManager["__class"] = "org.jbox2d.dynamics.ContactManager";
            ContactManager["__interfaces"] = ["org.jbox2d.collision.PairCallback"];
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var CircleContact = (function (_super) {
                    __extends(CircleContact, _super);
                    function CircleContact(shape1, shape2) {
                        var _this = this;
                        if (((shape1 != null && shape1 instanceof org.jbox2d.collision.shapes.Shape) || shape1 === null) && ((shape2 != null && shape2 instanceof org.jbox2d.collision.shapes.Shape) || shape2 === null)) {
                            var __args = arguments;
                            _this = _super.call(this, shape1, shape2) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                                if (!((_this.m_shape1.getType() === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE)))
                                    throw new Error("Assertion error line 33: assert (m_shape1.getType() == ShapeType.CIRCLE_SHAPE);");
                                ;
                                if (!((_this.m_shape2.getType() === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE)))
                                    throw new Error("Assertion error line 34: assert (m_shape2.getType() == ShapeType.CIRCLE_SHAPE);");
                                ;
                                _this.m_manifold.pointCount = 0;
                                _this.m_manifold.points[0].normalImpulse = 0.0;
                                _this.m_manifold.points[0].tangentImpulse = 0.0;
                                _this.m_manifold.points[0].localPoint1.setZero();
                                _this.m_manifold.points[0].localPoint2.setZero();
                            })();
                        }
                        else if (shape1 === undefined && shape2 === undefined) {
                            var __args = arguments;
                            _this = _super.call(this) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                _this.m_manifoldCount = 0;
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                        return _this;
                    }
                    CircleContact.prototype.create = function (shape1, shape2) {
                        return new CircleContact(shape1, shape2);
                    };
                    CircleContact.Destroy = function (contact) {
                        contact.destructor();
                    };
                    /**
                     *
                     * @return {org.jbox2d.dynamics.contacts.CircleContact}
                     */
                    CircleContact.prototype.clone = function () {
                        return this;
                    };
                    CircleContact.prototype.destructor = function () {
                    };
                    CircleContact.tlm0_$LI$ = function () { if (CircleContact.tlm0 == null)
                        CircleContact.tlm0 = (function () { var __o = new org.jbox2d.pooling.TLManifold(); __o.__delegate = new org.jbox2d.pooling.TLManifold(); return __o; })(); return CircleContact.tlm0; };
                    ;
                    CircleContact.tlV1_$LI$ = function () { if (CircleContact.tlV1 == null)
                        CircleContact.tlV1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return CircleContact.tlV1; };
                    ;
                    CircleContact.tlCp_$LI$ = function () { if (CircleContact.tlCp == null)
                        CircleContact.tlCp = (function () { var __o = new org.jbox2d.pooling.TLContactPoint(); __o.__delegate = new org.jbox2d.pooling.TLContactPoint(); return __o; })(); return CircleContact.tlCp; };
                    ;
                    /**
                     *
                     * @param {*} listener
                     */
                    CircleContact.prototype.evaluate = function (listener) {
                        var b1 = this.m_shape1.getBody();
                        var b2 = this.m_shape2.getBody();
                        var m0 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(CircleContact.tlm0_$LI$());
                        var v1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(CircleContact.tlV1_$LI$());
                        var cp = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(CircleContact.tlCp_$LI$());
                        m0.set(this.m_manifold);
                        org.jbox2d.pooling.SingletonPool.getCollideCircle().collideCircles(this.m_manifold, this.m_shape1, b1.m_xf, this.m_shape2, b2.m_xf);
                        cp.shape1 = this.m_shape1;
                        cp.shape2 = this.m_shape2;
                        cp.friction = this.m_friction;
                        cp.restitution = this.m_restitution;
                        if (this.m_manifold.pointCount > 0) {
                            this.m_manifoldCount = 1;
                            var mp = this.m_manifold.points[0];
                            if (m0.pointCount === 0) {
                                mp.normalImpulse = 0.0;
                                mp.tangentImpulse = 0.0;
                                if (listener != null) {
                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                    cp.velocity.subLocal(v1);
                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                    cp.separation = mp.separation;
                                    cp.id.set(mp.id);
                                    listener.add(cp);
                                }
                            }
                            else {
                                var mp0 = m0.points[0];
                                mp.normalImpulse = mp0.normalImpulse;
                                mp.tangentImpulse = mp0.tangentImpulse;
                                if (listener != null) {
                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                    cp.velocity.subLocal(v1);
                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                    cp.separation = mp.separation;
                                    cp.id.set(mp.id);
                                    listener.persist(cp);
                                }
                            }
                        }
                        else {
                            this.m_manifoldCount = 0;
                            if (m0.pointCount > 0 && (listener != null)) {
                                var mp0 = m0.points[0];
                                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                                cp.velocity.subLocal(v1);
                                cp.normal.set$org_jbox2d_common_Vec2(m0.normal);
                                cp.separation = mp0.separation;
                                cp.id.set(mp0.id);
                                listener.remove(cp);
                            }
                        }
                    };
                    /**
                     *
                     * @return {org.jbox2d.collision.Manifold[]}
                     */
                    CircleContact.prototype.getManifolds = function () {
                        return this.manifoldList;
                    };
                    return CircleContact;
                }(org.jbox2d.dynamics.contacts.Contact));
                contacts.CircleContact = CircleContact;
                CircleContact["__class"] = "org.jbox2d.dynamics.contacts.CircleContact";
                CircleContact["__interfaces"] = ["org.jbox2d.dynamics.contacts.ContactCreateFcn"];
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var EdgeAndCircleContact = (function (_super) {
                    __extends(EdgeAndCircleContact, _super);
                    function EdgeAndCircleContact(s1, s2) {
                        var _this = this;
                        if (((s1 != null && s1 instanceof org.jbox2d.collision.shapes.Shape) || s1 === null) && ((s2 != null && s2 instanceof org.jbox2d.collision.shapes.Shape) || s2 === null)) {
                            var __args = arguments;
                            _this = _super.call(this, s1, s2) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                if (!((_this.m_shape1.getType() === org.jbox2d.collision.shapes.ShapeType.EDGE_SHAPE)))
                                    throw new Error("Assertion error line 15: assert (m_shape1.getType() == ShapeType.EDGE_SHAPE);");
                                ;
                                if (!((_this.m_shape2.getType() === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE)))
                                    throw new Error("Assertion error line 16: assert (m_shape2.getType() == ShapeType.CIRCLE_SHAPE);");
                                ;
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                                _this.m_manifoldCount = 0;
                            })();
                        }
                        else if (s1 === undefined && s2 === undefined) {
                            var __args = arguments;
                            _this = _super.call(this) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                                _this.m_manifoldCount = 0;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                        return _this;
                    }
                    /**
                     *
                     * @return {org.jbox2d.dynamics.contacts.Contact}
                     */
                    EdgeAndCircleContact.prototype.clone = function () {
                        if (!(false))
                            throw new Error("Assertion error line 40: assert false : 'Not yet implemented.';");
                        ;
                        return this;
                    };
                    EdgeAndCircleContact.Destroy = function (contact) {
                        contact.destructor();
                    };
                    EdgeAndCircleContact.prototype.destructor = function () {
                    };
                    EdgeAndCircleContact.tlm0_$LI$ = function () { if (EdgeAndCircleContact.tlm0 == null)
                        EdgeAndCircleContact.tlm0 = (function () { var __o = new org.jbox2d.pooling.TLManifold(); __o.__delegate = new org.jbox2d.pooling.TLManifold(); return __o; })(); return EdgeAndCircleContact.tlm0; };
                    ;
                    EdgeAndCircleContact.tlV1_$LI$ = function () { if (EdgeAndCircleContact.tlV1 == null)
                        EdgeAndCircleContact.tlV1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return EdgeAndCircleContact.tlV1; };
                    ;
                    EdgeAndCircleContact.tlCp_$LI$ = function () { if (EdgeAndCircleContact.tlCp == null)
                        EdgeAndCircleContact.tlCp = (function () { var __o = new org.jbox2d.pooling.TLContactPoint(); __o.__delegate = new org.jbox2d.pooling.TLContactPoint(); return __o; })(); return EdgeAndCircleContact.tlCp; };
                    ;
                    /**
                     *
                     * @param {*} listener
                     */
                    EdgeAndCircleContact.prototype.evaluate = function (listener) {
                        var b1 = this.m_shape1.getBody();
                        var b2 = this.m_shape2.getBody();
                        var m0 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(EdgeAndCircleContact.tlm0_$LI$());
                        var v1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(EdgeAndCircleContact.tlV1_$LI$());
                        var cp = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(EdgeAndCircleContact.tlCp_$LI$());
                        m0.set(this.m_manifold);
                        org.jbox2d.pooling.SingletonPool.getCollideCircle().collideEdgeAndCircle(this.m_manifold, this.m_shape1, b1.getMemberXForm(), this.m_shape2, b2.getMemberXForm());
                        cp.shape1 = this.m_shape1;
                        cp.shape2 = this.m_shape2;
                        cp.friction = this.m_friction;
                        cp.restitution = this.m_restitution;
                        if (this.m_manifold.pointCount > 0) {
                            this.m_manifoldCount = 1;
                            var mp = this.m_manifold.points[0];
                            if (m0.pointCount === 0) {
                                mp.normalImpulse = 0.0;
                                mp.tangentImpulse = 0.0;
                                if (listener != null) {
                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                    cp.velocity.subLocal(v1);
                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                    cp.separation = mp.separation;
                                    cp.id.set(mp.id);
                                    listener.add(cp);
                                }
                            }
                            else {
                                var mp0 = m0.points[0];
                                mp.normalImpulse = mp0.normalImpulse;
                                mp.tangentImpulse = mp0.tangentImpulse;
                                if (listener != null) {
                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                    cp.velocity.subLocal(v1);
                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                    cp.separation = mp.separation;
                                    cp.id.set(mp.id);
                                    listener.persist(cp);
                                }
                            }
                        }
                        else {
                            this.m_manifoldCount = 0;
                            if (m0.pointCount > 0 && (listener != null)) {
                                var mp0 = m0.points[0];
                                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                                cp.velocity.subLocal(v1);
                                cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                cp.separation = mp0.separation;
                                cp.id.set(mp0.id);
                                listener.remove(cp);
                            }
                        }
                    };
                    /**
                     *
                     * @return {org.jbox2d.collision.Manifold[]}
                     */
                    EdgeAndCircleContact.prototype.getManifolds = function () {
                        return this.manifoldList;
                    };
                    EdgeAndCircleContact.prototype.create = function (s1, s2) {
                        return new EdgeAndCircleContact(s1, s2);
                    };
                    return EdgeAndCircleContact;
                }(org.jbox2d.dynamics.contacts.Contact));
                contacts.EdgeAndCircleContact = EdgeAndCircleContact;
                EdgeAndCircleContact["__class"] = "org.jbox2d.dynamics.contacts.EdgeAndCircleContact";
                EdgeAndCircleContact["__interfaces"] = ["org.jbox2d.dynamics.contacts.ContactCreateFcn"];
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var PointAndCircleContact = (function (_super) {
                    __extends(PointAndCircleContact, _super);
                    function PointAndCircleContact(shape1, shape2) {
                        var _this = this;
                        if (((shape1 != null && shape1 instanceof org.jbox2d.collision.shapes.Shape) || shape1 === null) && ((shape2 != null && shape2 instanceof org.jbox2d.collision.shapes.Shape) || shape2 === null)) {
                            var __args = arguments;
                            _this = _super.call(this, shape1, shape2) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                if (!((_this.m_shape1.getType() === org.jbox2d.collision.shapes.ShapeType.POINT_SHAPE)))
                                    throw new Error("Assertion error line 32: assert (m_shape1.getType() == ShapeType.POINT_SHAPE);");
                                ;
                                if (!((_this.m_shape2.getType() === org.jbox2d.collision.shapes.ShapeType.CIRCLE_SHAPE)))
                                    throw new Error("Assertion error line 33: assert (m_shape2.getType() == ShapeType.CIRCLE_SHAPE);");
                                ;
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                                _this.m_manifold.pointCount = 0;
                                _this.m_manifold.points[0].normalImpulse = 0.0;
                                _this.m_manifold.points[0].tangentImpulse = 0.0;
                                _this.m_manifold.points[0].localPoint1.setZero();
                                _this.m_manifold.points[0].localPoint2.setZero();
                            })();
                        }
                        else if (shape1 === undefined && shape2 === undefined) {
                            var __args = arguments;
                            _this = _super.call(this) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                                _this.m_manifoldCount = 0;
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                        return _this;
                    }
                    PointAndCircleContact.prototype.create = function (shape1, shape2) {
                        return new PointAndCircleContact(shape1, shape2);
                    };
                    PointAndCircleContact.Destroy = function (contact) {
                        contact.destructor();
                    };
                    /**
                     *
                     * @return {org.jbox2d.dynamics.contacts.PointAndCircleContact}
                     */
                    PointAndCircleContact.prototype.clone = function () {
                        return this;
                    };
                    PointAndCircleContact.prototype.destructor = function () {
                    };
                    PointAndCircleContact.tlm0_$LI$ = function () { if (PointAndCircleContact.tlm0 == null)
                        PointAndCircleContact.tlm0 = (function () { var __o = new org.jbox2d.pooling.TLManifold(); __o.__delegate = new org.jbox2d.pooling.TLManifold(); return __o; })(); return PointAndCircleContact.tlm0; };
                    ;
                    PointAndCircleContact.tlV1_$LI$ = function () { if (PointAndCircleContact.tlV1 == null)
                        PointAndCircleContact.tlV1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PointAndCircleContact.tlV1; };
                    ;
                    PointAndCircleContact.tlCp_$LI$ = function () { if (PointAndCircleContact.tlCp == null)
                        PointAndCircleContact.tlCp = (function () { var __o = new org.jbox2d.pooling.TLContactPoint(); __o.__delegate = new org.jbox2d.pooling.TLContactPoint(); return __o; })(); return PointAndCircleContact.tlCp; };
                    ;
                    /**
                     *
                     * @param {*} listener
                     */
                    PointAndCircleContact.prototype.evaluate = function (listener) {
                        var b1 = this.m_shape1.getBody();
                        var b2 = this.m_shape2.getBody();
                        var m0 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PointAndCircleContact.tlm0_$LI$());
                        var v1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PointAndCircleContact.tlV1_$LI$());
                        var cp = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PointAndCircleContact.tlCp_$LI$());
                        m0.set(this.m_manifold);
                        org.jbox2d.pooling.SingletonPool.getCollideCircle().collidePointAndCircle(this.m_manifold, this.m_shape1, b1.m_xf, this.m_shape2, b2.m_xf);
                        cp.shape1 = this.m_shape1;
                        cp.shape2 = this.m_shape2;
                        cp.friction = this.m_friction;
                        cp.restitution = this.m_restitution;
                        if (this.m_manifold.pointCount > 0) {
                            this.m_manifoldCount = 1;
                            var mp = this.m_manifold.points[0];
                            if (m0.pointCount === 0) {
                                mp.normalImpulse = 0.0;
                                mp.tangentImpulse = 0.0;
                                if (listener != null) {
                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                    cp.velocity.subLocal(v1);
                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                    cp.separation = mp.separation;
                                    cp.id.set(mp.id);
                                    listener.add(cp);
                                }
                            }
                            else {
                                var mp0 = m0.points[0];
                                mp.normalImpulse = mp0.normalImpulse;
                                mp.tangentImpulse = mp0.tangentImpulse;
                                if (listener != null) {
                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                    cp.velocity.subLocal(v1);
                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                    cp.separation = mp.separation;
                                    cp.id.set(mp.id);
                                    listener.persist(cp);
                                }
                            }
                        }
                        else {
                            this.m_manifoldCount = 0;
                            if (m0.pointCount > 0 && (listener != null)) {
                                var mp0 = m0.points[0];
                                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                                cp.velocity.subLocal(v1);
                                cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                cp.separation = mp0.separation;
                                cp.id.set(mp0.id);
                                listener.remove(cp);
                            }
                        }
                    };
                    /**
                     *
                     * @return {org.jbox2d.collision.Manifold[]}
                     */
                    PointAndCircleContact.prototype.getManifolds = function () {
                        return this.manifoldList;
                    };
                    return PointAndCircleContact;
                }(org.jbox2d.dynamics.contacts.Contact));
                contacts.PointAndCircleContact = PointAndCircleContact;
                PointAndCircleContact["__class"] = "org.jbox2d.dynamics.contacts.PointAndCircleContact";
                PointAndCircleContact["__interfaces"] = ["org.jbox2d.dynamics.contacts.ContactCreateFcn"];
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var contacts;
            (function (contacts) {
                var PolyContact = (function (_super) {
                    __extends(PolyContact, _super);
                    function PolyContact(s1, s2) {
                        var _this = this;
                        if (((s1 != null && s1 instanceof org.jbox2d.collision.shapes.Shape) || s1 === null) && ((s2 != null && s2 instanceof org.jbox2d.collision.shapes.Shape) || s2 === null)) {
                            var __args = arguments;
                            _this = _super.call(this, s1, s2) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                if (!((_this.m_shape1.getType() === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE)))
                                    throw new Error("Assertion error line 15: assert (m_shape1.getType() == ShapeType.POLYGON_SHAPE);");
                                ;
                                if (!((_this.m_shape2.getType() === org.jbox2d.collision.shapes.ShapeType.POLYGON_SHAPE)))
                                    throw new Error("Assertion error line 16: assert (m_shape2.getType() == ShapeType.POLYGON_SHAPE);");
                                ;
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                _this.m_manifoldCount = 0;
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                            })();
                        }
                        else if (s1 === undefined && s2 === undefined) {
                            var __args = arguments;
                            _this = _super.call(this) || this;
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            _this.manifoldList = ([]);
                            if (_this.m_manifold === undefined)
                                _this.m_manifold = null;
                            (function () {
                                _this.m_manifold = new org.jbox2d.collision.Manifold();
                                _this.m_manifoldCount = 0;
                                /* add */ (_this.manifoldList.push(_this.m_manifold) > 0);
                            })();
                        }
                        else
                            throw new Error('invalid overload');
                        return _this;
                    }
                    /**
                     *
                     * @return {org.jbox2d.dynamics.contacts.Contact}
                     */
                    PolyContact.prototype.clone = function () {
                        var newC = new PolyContact(this.m_shape1, this.m_shape2);
                        if (this.m_manifold != null) {
                            newC.m_manifold.set(this.m_manifold);
                        }
                        newC.m_manifoldCount = this.m_manifoldCount;
                        newC.m_world = this.m_world;
                        newC.m_toi = this.m_toi;
                        newC.m_prev = this.m_prev;
                        newC.m_next = this.m_next;
                        newC.m_node1.set(this.m_node1);
                        newC.m_node2.set(this.m_node2);
                        newC.m_friction = this.m_friction;
                        newC.m_restitution = this.m_restitution;
                        newC.m_flags = this.m_flags;
                        return newC;
                    };
                    /**
                     *
                     * @return {org.jbox2d.collision.Manifold[]}
                     */
                    PolyContact.prototype.getManifolds = function () {
                        return this.manifoldList;
                    };
                    PolyContact.prototype.create = function (shape1, shape2) {
                        return new PolyContact(shape1, shape2);
                    };
                    PolyContact.prototype.dumpManifoldPoints = function () {
                        for (var i = 0; i < this.m_manifold.pointCount; ++i) {
                            {
                                var mp = this.m_manifold.points[i];
                                console.info("Manifold point dump: " + mp.normalImpulse + " " + mp.tangentImpulse);
                            }
                            ;
                        }
                    };
                    PolyContact.tlm0_$LI$ = function () { if (PolyContact.tlm0 == null)
                        PolyContact.tlm0 = (function () { var __o = new org.jbox2d.pooling.TLManifold(); __o.__delegate = new org.jbox2d.pooling.TLManifold(); return __o; })(); return PolyContact.tlm0; };
                    ;
                    PolyContact.tlV1_$LI$ = function () { if (PolyContact.tlV1 == null)
                        PolyContact.tlV1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PolyContact.tlV1; };
                    ;
                    PolyContact.tlCp_$LI$ = function () { if (PolyContact.tlCp == null)
                        PolyContact.tlCp = (function () { var __o = new org.jbox2d.pooling.TLContactPoint(); __o.__delegate = new org.jbox2d.pooling.TLContactPoint(); return __o; })(); return PolyContact.tlCp; };
                    ;
                    /**
                     *
                     * @param {*} listener
                     */
                    PolyContact.prototype.evaluate = function (listener) {
                        var b1 = this.m_shape1.getBody();
                        var b2 = this.m_shape2.getBody();
                        var m0 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PolyContact.tlm0_$LI$());
                        var v1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PolyContact.tlV1_$LI$());
                        var cp = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PolyContact.tlCp_$LI$());
                        m0.set(this.m_manifold);
                        org.jbox2d.pooling.SingletonPool.getCollidePoly().collidePolygons(this.m_manifold, this.m_shape1, b1.getMemberXForm(), this.m_shape2, b2.getMemberXForm());
                        var persisted = [false, false];
                        cp.shape1 = this.m_shape1;
                        cp.shape2 = this.m_shape2;
                        cp.friction = this.m_friction;
                        cp.restitution = this.m_restitution;
                        if (this.m_manifold.pointCount > 0) {
                            for (var i = 0; i < this.m_manifold.pointCount; ++i) {
                                {
                                    var mp = this.m_manifold.points[i];
                                    mp.normalImpulse = 0.0;
                                    mp.tangentImpulse = 0.0;
                                    var found = false;
                                    var id = mp.id;
                                    for (var j = 0; j < m0.pointCount; ++j) {
                                        {
                                            if (persisted[j] === true) {
                                                continue;
                                            }
                                            var mp0 = m0.points[j];
                                            if (mp0.id.isEqual(id)) {
                                                persisted[j] = true;
                                                mp.normalImpulse = mp0.normalImpulse;
                                                mp.tangentImpulse = mp0.tangentImpulse;
                                                found = true;
                                                if (listener != null) {
                                                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                                    cp.velocity.subLocal(v1);
                                                    cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                                    cp.separation = mp.separation;
                                                    cp.id.set(id);
                                                    listener.persist(cp);
                                                }
                                                break;
                                            }
                                        }
                                        ;
                                    }
                                    if (found === false && listener != null) {
                                        b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                                        b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                                        b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                                        cp.velocity.subLocal(v1);
                                        cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                        cp.separation = mp.separation;
                                        cp.id.set(id);
                                        listener.add(cp);
                                    }
                                }
                                ;
                            }
                            this.m_manifoldCount = 1;
                        }
                        else {
                            this.m_manifoldCount = 0;
                        }
                        if (listener == null) {
                            return;
                        }
                        for (var i = 0; i < m0.pointCount; ++i) {
                            {
                                if (persisted[i]) {
                                    continue;
                                }
                                var mp0 = m0.points[i];
                                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                                cp.velocity.subLocal(v1);
                                cp.normal.set$org_jbox2d_common_Vec2(this.m_manifold.normal);
                                cp.separation = mp0.separation;
                                cp.id.set(mp0.id);
                                listener.remove(cp);
                            }
                            ;
                        }
                    };
                    return PolyContact;
                }(org.jbox2d.dynamics.contacts.Contact));
                contacts.PolyContact = PolyContact;
                PolyContact["__class"] = "org.jbox2d.dynamics.contacts.PolyContact";
                PolyContact["__interfaces"] = ["org.jbox2d.dynamics.contacts.ContactCreateFcn"];
            })(contacts = dynamics.contacts || (dynamics.contacts = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var DistanceJoint = (function (_super) {
                    __extends(DistanceJoint, _super);
                    function DistanceJoint(def) {
                        var _this = _super.call(this, def) || this;
                        if (_this.m_localAnchor1 === undefined)
                            _this.m_localAnchor1 = null;
                        if (_this.m_localAnchor2 === undefined)
                            _this.m_localAnchor2 = null;
                        if (_this.m_u === undefined)
                            _this.m_u = null;
                        if (_this.m_impulse === undefined)
                            _this.m_impulse = 0;
                        if (_this.m_mass === undefined)
                            _this.m_mass = 0;
                        if (_this.m_length === undefined)
                            _this.m_length = 0;
                        if (_this.m_frequencyHz === undefined)
                            _this.m_frequencyHz = 0;
                        if (_this.m_dampingRatio === undefined)
                            _this.m_dampingRatio = 0;
                        if (_this.m_gamma === undefined)
                            _this.m_gamma = 0;
                        if (_this.m_bias === undefined)
                            _this.m_bias = 0;
                        _this.m_localAnchor1 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAnchor1);
                        _this.m_localAnchor2 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAnchor2);
                        _this.m_length = def.length;
                        _this.m_impulse = 0.0;
                        _this.m_u = new org.jbox2d.common.Vec2();
                        _this.m_frequencyHz = def.frequencyHz;
                        _this.m_dampingRatio = def.dampingRatio;
                        _this.m_gamma = 0.0;
                        _this.m_bias = 0.0;
                        _this.m_inv_dt = 0.0;
                        return _this;
                    }
                    DistanceJoint.prototype.setFrequency = function (hz) {
                        this.m_frequencyHz = hz;
                    };
                    DistanceJoint.prototype.getFrequency = function () {
                        return this.m_frequencyHz;
                    };
                    DistanceJoint.prototype.setDampingRatio = function (damp) {
                        this.m_dampingRatio = damp;
                    };
                    DistanceJoint.prototype.getDampingRatio = function () {
                        return this.m_dampingRatio;
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    DistanceJoint.prototype.getAnchor1 = function () {
                        return this.m_body1.getWorldLocation(this.m_localAnchor1);
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    DistanceJoint.prototype.getAnchor2 = function () {
                        return this.m_body2.getWorldLocation(this.m_localAnchor2);
                    };
                    DistanceJoint.tlReactionForce_$LI$ = function () { if (DistanceJoint.tlReactionForce == null)
                        DistanceJoint.tlReactionForce = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tlReactionForce; };
                    ;
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    DistanceJoint.prototype.getReactionForce = function () {
                        var reactionForce = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlReactionForce_$LI$());
                        reactionForce.x = Math.fround(this.m_impulse * this.m_u.x);
                        reactionForce.y = Math.fround(this.m_impulse * this.m_u.y);
                        return reactionForce;
                    };
                    /**
                     *
                     * @return {number}
                     */
                    DistanceJoint.prototype.getReactionTorque = function () {
                        return 0.0;
                    };
                    DistanceJoint.tlr1_$LI$ = function () { if (DistanceJoint.tlr1 == null)
                        DistanceJoint.tlr1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tlr1; };
                    ;
                    DistanceJoint.tlr2_$LI$ = function () { if (DistanceJoint.tlr2 == null)
                        DistanceJoint.tlr2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tlr2; };
                    ;
                    DistanceJoint.tlP_$LI$ = function () { if (DistanceJoint.tlP == null)
                        DistanceJoint.tlP = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tlP; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    DistanceJoint.prototype.initVelocityConstraints = function (step) {
                        this.m_inv_dt = step.inv_dt;
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlr2_$LI$());
                        var P = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlP_$LI$());
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.getMemberXForm().R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.getMemberXForm().R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
                        this.m_u.x = Math.fround(Math.fround(Math.fround(b2.m_sweep.c.x + r2.x) - b1.m_sweep.c.x) - r1.x);
                        this.m_u.y = Math.fround(Math.fround(Math.fround(b2.m_sweep.c.y + r2.y) - b1.m_sweep.c.y) - r1.y);
                        var length = this.m_u.length();
                        if (length > org.jbox2d.common.Settings.linearSlop_$LI$()) {
                            this.m_u.x *= Math.fround(1.0 / length);
                            this.m_u.y *= Math.fround(1.0 / length);
                        }
                        else {
                            this.m_u.set$float$float(0.0, 0.0);
                        }
                        var cr1u = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, this.m_u);
                        var cr2u = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, this.m_u);
                        var invMass = Math.fround(Math.fround(Math.fround(b1.m_invMass + Math.fround(Math.fround(b1.m_invI * cr1u) * cr1u)) + b2.m_invMass) + Math.fround(Math.fround(b2.m_invI * cr2u) * cr2u));
                        if (!((invMass > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 131: assert (invMass > Settings.EPSILON);");
                        ;
                        this.m_mass = Math.fround(1.0 / invMass);
                        if (this.m_frequencyHz > 0.0) {
                            var C = Math.fround(length - this.m_length);
                            var omega = Math.fround(Math.fround(2.0 * org.jbox2d.common.MathUtils.PI_$LI$()) * this.m_frequencyHz);
                            var d = Math.fround(Math.fround(Math.fround(2.0 * this.m_mass) * this.m_dampingRatio) * omega);
                            var k = Math.fround(Math.fround(this.m_mass * omega) * omega);
                            this.m_gamma = Math.fround(1.0 / (Math.fround(step.dt * (Math.fround(d + Math.fround(step.dt * k))))));
                            this.m_bias = Math.fround(Math.fround(Math.fround(C * step.dt) * k) * this.m_gamma);
                            this.m_mass = Math.fround(1.0 / (Math.fround(invMass + this.m_gamma)));
                        }
                        if (step.warmStarting) {
                            this.m_impulse *= step.dtRatio;
                            P.set$org_jbox2d_common_Vec2(this.m_u);
                            P.mulLocal(this.m_impulse);
                            b1.m_linearVelocity.x -= Math.fround(b1.m_invMass * P.x);
                            b1.m_linearVelocity.y -= Math.fround(b1.m_invMass * P.y);
                            b1.m_angularVelocity -= Math.fround(b1.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, P));
                            b2.m_linearVelocity.x += Math.fround(b2.m_invMass * P.x);
                            b2.m_linearVelocity.y += Math.fround(b2.m_invMass * P.y);
                            b2.m_angularVelocity += Math.fround(b2.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, P));
                        }
                        else {
                            this.m_impulse = 0.0;
                        }
                    };
                    DistanceJoint.tld_$LI$ = function () { if (DistanceJoint.tld == null)
                        DistanceJoint.tld = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tld; };
                    ;
                    /**
                     *
                     * @return {boolean}
                     */
                    DistanceJoint.prototype.solvePositionConstraints = function () {
                        if (this.m_frequencyHz > 0.0) {
                            return true;
                        }
                        var d = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tld_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlr2_$LI$());
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlr1_$LI$());
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.getMemberXForm().R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.getMemberXForm().R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
                        d.x = Math.fround(Math.fround(Math.fround(b2.m_sweep.c.x + r2.x) - b1.m_sweep.c.x) - r1.x);
                        d.y = Math.fround(Math.fround(Math.fround(b2.m_sweep.c.y + r2.y) - b1.m_sweep.c.y) - r1.y);
                        var length = d.normalize();
                        var C = Math.fround(length - this.m_length);
                        C = org.jbox2d.common.MathUtils.clamp$float$float$float(C, -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), org.jbox2d.common.Settings.maxLinearCorrection_$LI$());
                        var impulse = Math.fround(-this.m_mass * C);
                        this.m_u.set$org_jbox2d_common_Vec2(d);
                        var Px = Math.fround(impulse * this.m_u.x);
                        var Py = Math.fround(impulse * this.m_u.y);
                        b1.m_sweep.c.x -= Math.fround(b1.m_invMass * Px);
                        b1.m_sweep.c.y -= Math.fround(b1.m_invMass * Py);
                        b1.m_sweep.a -= Math.fround(b1.m_invI * (Math.fround(Math.fround(r1.x * Py) - Math.fround(r1.y * Px))));
                        b2.m_sweep.c.x += Math.fround(b2.m_invMass * Px);
                        b2.m_sweep.c.y += Math.fround(b2.m_invMass * Py);
                        b2.m_sweep.a += Math.fround(b2.m_invI * (Math.fround(Math.fround(r2.x * Py) - Math.fround(r2.y * Px))));
                        b1.synchronizeTransform();
                        b2.synchronizeTransform();
                        return org.jbox2d.common.MathUtils.abs(C) < org.jbox2d.common.Settings.linearSlop_$LI$();
                    };
                    DistanceJoint.tlv1_$LI$ = function () { if (DistanceJoint.tlv1 == null)
                        DistanceJoint.tlv1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tlv1; };
                    ;
                    DistanceJoint.tlv2_$LI$ = function () { if (DistanceJoint.tlv2 == null)
                        DistanceJoint.tlv2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return DistanceJoint.tlv2; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    DistanceJoint.prototype.solveVelocityConstraints = function (step) {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var v1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlv1_$LI$());
                        var v2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlv2_$LI$());
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(DistanceJoint.tlr2_$LI$());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
                        org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_angularVelocity, r1, v1);
                        org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_angularVelocity, r2, v2);
                        v1.addLocal$org_jbox2d_common_Vec2(b1.m_linearVelocity);
                        v2.addLocal$org_jbox2d_common_Vec2(b2.m_linearVelocity);
                        var Cdot = org.jbox2d.common.Vec2.dot(this.m_u, v2.subLocal(v1));
                        var impulse = Math.fround(-this.m_mass * (Math.fround(Math.fround(Cdot + this.m_bias) + Math.fround(this.m_gamma * this.m_impulse))));
                        this.m_impulse += impulse;
                        var Px = Math.fround(impulse * this.m_u.x);
                        var Py = Math.fround(impulse * this.m_u.y);
                        b1.m_linearVelocity.x -= Math.fround(b1.m_invMass * Px);
                        b1.m_linearVelocity.y -= Math.fround(b1.m_invMass * Py);
                        b1.m_angularVelocity -= Math.fround(b1.m_invI * (Math.fround(Math.fround(r1.x * Py) - Math.fround(r1.y * Px))));
                        b2.m_linearVelocity.x += Math.fround(b2.m_invMass * Px);
                        b2.m_linearVelocity.y += Math.fround(b2.m_invMass * Py);
                        b2.m_angularVelocity += Math.fround(b2.m_invI * (Math.fround(Math.fround(r2.x * Py) - Math.fround(r2.y * Px))));
                    };
                    return DistanceJoint;
                }(org.jbox2d.dynamics.joints.Joint));
                joints.DistanceJoint = DistanceJoint;
                DistanceJoint["__class"] = "org.jbox2d.dynamics.joints.DistanceJoint";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var MouseJoint = (function (_super) {
                    __extends(MouseJoint, _super);
                    function MouseJoint(def) {
                        var _this = _super.call(this, def) || this;
                        if (_this.m_localAnchor === undefined)
                            _this.m_localAnchor = null;
                        if (_this.m_target === undefined)
                            _this.m_target = null;
                        if (_this.m_force === undefined)
                            _this.m_force = null;
                        if (_this.m_mass === undefined)
                            _this.m_mass = null;
                        if (_this.m_C === undefined)
                            _this.m_C = null;
                        if (_this.m_maxForce === undefined)
                            _this.m_maxForce = 0;
                        if (_this.m_beta === undefined)
                            _this.m_beta = 0;
                        if (_this.m_gamma === undefined)
                            _this.m_gamma = 0;
                        _this.m_force = new org.jbox2d.common.Vec2();
                        _this.m_target = new org.jbox2d.common.Vec2();
                        _this.m_C = new org.jbox2d.common.Vec2();
                        _this.m_mass = new org.jbox2d.common.Mat22();
                        _this.m_target.set$org_jbox2d_common_Vec2(def.target);
                        _this.m_localAnchor = org.jbox2d.common.XForm.mulTrans(_this.m_body2.m_xf, _this.m_target);
                        _this.m_maxForce = def.maxForce;
                        var mass = _this.m_body2.m_mass;
                        var omega = Math.fround(Math.fround(2.0 * org.jbox2d.common.Settings.pi_$LI$()) * def.frequencyHz);
                        var d = Math.fround(Math.fround(Math.fround(2.0 * mass) * def.dampingRatio) * omega);
                        var k = Math.fround(Math.fround(mass * omega) * omega);
                        _this.m_gamma = Math.fround(1.0 / (Math.fround(d + Math.fround(def.timeStep * k))));
                        _this.m_beta = Math.fround(Math.fround(def.timeStep * k) / (Math.fround(d + Math.fround(def.timeStep * k))));
                        return _this;
                    }
                    /**
                     * Use this to update the target point.
                     * @param {org.jbox2d.common.Vec2} target
                     */
                    MouseJoint.prototype.setTarget = function (target) {
                        if (this.m_body2.isSleeping()) {
                            this.m_body2.wakeUp();
                        }
                        this.m_target.set$org_jbox2d_common_Vec2(target);
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    MouseJoint.prototype.getAnchor1 = function () {
                        return this.m_target;
                    };
                    MouseJoint.tlanchor2_$LI$ = function () { if (MouseJoint.tlanchor2 == null)
                        MouseJoint.tlanchor2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return MouseJoint.tlanchor2; };
                    ;
                    /**
                     * this comes from a pooled value
                     * @return {org.jbox2d.common.Vec2}
                     */
                    MouseJoint.prototype.getAnchor2 = function () {
                        var anchor2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlanchor2_$LI$());
                        this.m_body2.getWorldLocationToOut(this.m_localAnchor, anchor2);
                        return anchor2;
                    };
                    MouseJoint.tlr_$LI$ = function () { if (MouseJoint.tlr == null)
                        MouseJoint.tlr = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return MouseJoint.tlr; };
                    ;
                    MouseJoint.tlK1_$LI$ = function () { if (MouseJoint.tlK1 == null)
                        MouseJoint.tlK1 = (function () { var __o = new org.jbox2d.pooling.TLMat22(); __o.__delegate = new org.jbox2d.pooling.TLMat22(); return __o; })(); return MouseJoint.tlK1; };
                    ;
                    MouseJoint.tlK2_$LI$ = function () { if (MouseJoint.tlK2 == null)
                        MouseJoint.tlK2 = (function () { var __o = new org.jbox2d.pooling.TLMat22(); __o.__delegate = new org.jbox2d.pooling.TLMat22(); return __o; })(); return MouseJoint.tlK2; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    MouseJoint.prototype.initVelocityConstraints = function (step) {
                        var b = this.m_body2;
                        var r = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlr_$LI$());
                        var K1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlK1_$LI$());
                        var K2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlK2_$LI$());
                        r.set$org_jbox2d_common_Vec2(this.m_localAnchor);
                        r.subLocal(b.getMemberLocalCenter());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b.m_xf.R, r, r);
                        var invMass = b.m_invMass;
                        var invI = b.m_invI;
                        K1.set$float$float$float$float(invMass, 0.0, 0.0, invMass);
                        K2.set$float$float$float$float(Math.fround(Math.fround(invI * r.y) * r.y), Math.fround(Math.fround(-invI * r.x) * r.y), Math.fround(Math.fround(-invI * r.x) * r.y), Math.fround(Math.fround(invI * r.x) * r.x));
                        K1.addLocal(K2);
                        K1.col1.x += this.m_gamma;
                        K1.col2.y += this.m_gamma;
                        K1.invertToOut(this.m_mass);
                        this.m_C.set$float$float(Math.fround(Math.fround(b.m_sweep.c.x + r.x) - this.m_target.x), Math.fround(Math.fround(b.m_sweep.c.y + r.y) - this.m_target.y));
                        b.m_angularVelocity *= 0.98;
                        var Px = Math.fround(step.dt * this.m_force.x);
                        var Py = Math.fround(step.dt * this.m_force.y);
                        b.m_linearVelocity.x += Math.fround(invMass * Px);
                        b.m_linearVelocity.y += Math.fround(invMass * Py);
                        b.m_angularVelocity += Math.fround(invI * (Math.fround(Math.fround(r.x * Py) - Math.fround(r.y * Px))));
                    };
                    /**
                     *
                     * @return {boolean}
                     */
                    MouseJoint.prototype.solvePositionConstraints = function () {
                        return true;
                    };
                    MouseJoint.tlCdot_$LI$ = function () { if (MouseJoint.tlCdot == null)
                        MouseJoint.tlCdot = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return MouseJoint.tlCdot; };
                    ;
                    MouseJoint.tlforce_$LI$ = function () { if (MouseJoint.tlforce == null)
                        MouseJoint.tlforce = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return MouseJoint.tlforce; };
                    ;
                    MouseJoint.tloldForce_$LI$ = function () { if (MouseJoint.tloldForce == null)
                        MouseJoint.tloldForce = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return MouseJoint.tloldForce; };
                    ;
                    MouseJoint.tlP_$LI$ = function () { if (MouseJoint.tlP == null)
                        MouseJoint.tlP = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return MouseJoint.tlP; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    MouseJoint.prototype.solveVelocityConstraints = function (step) {
                        var b = this.m_body2;
                        var r = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlr_$LI$());
                        var Cdot = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlCdot_$LI$());
                        var force = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlforce_$LI$());
                        var oldForce = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tloldForce_$LI$());
                        var P = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(MouseJoint.tlP_$LI$());
                        r.set$org_jbox2d_common_Vec2(this.m_localAnchor);
                        r.subLocal(b.getMemberLocalCenter());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b.m_xf.R, r, r);
                        org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b.m_angularVelocity, r, Cdot);
                        Cdot.addLocal$org_jbox2d_common_Vec2(b.m_linearVelocity);
                        force.set$float$float(Math.fround(Math.fround(Cdot.x + Math.fround((Math.fround(this.m_beta * step.inv_dt)) * this.m_C.x)) + Math.fround(Math.fround(this.m_gamma * step.dt) * this.m_force.x)), Math.fround(Math.fround(Cdot.y + Math.fround((Math.fround(this.m_beta * step.inv_dt)) * this.m_C.y)) + Math.fround(Math.fround(this.m_gamma * step.dt) * this.m_force.y)));
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(this.m_mass, force, force);
                        force.mulLocal(-step.inv_dt);
                        oldForce.set$org_jbox2d_common_Vec2(this.m_force);
                        this.m_force.addLocal$org_jbox2d_common_Vec2(force);
                        var forceMagnitude = this.m_force.length();
                        if (forceMagnitude > this.m_maxForce) {
                            this.m_force.mulLocal(Math.fround(this.m_maxForce / forceMagnitude));
                        }
                        force.set$float$float(Math.fround(this.m_force.x - oldForce.x), Math.fround(this.m_force.y - oldForce.y));
                        P.x = Math.fround(step.dt * force.x);
                        P.y = Math.fround(step.dt * force.y);
                        b.m_angularVelocity += Math.fround(b.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r, P));
                        b.m_linearVelocity.addLocal$org_jbox2d_common_Vec2(P.mulLocal(b.m_invMass));
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    MouseJoint.prototype.getReactionForce = function () {
                        return this.m_force;
                    };
                    /**
                     *
                     * @return {number}
                     */
                    MouseJoint.prototype.getReactionTorque = function () {
                        return 0.0;
                    };
                    return MouseJoint;
                }(org.jbox2d.dynamics.joints.Joint));
                joints.MouseJoint = MouseJoint;
                MouseJoint["__class"] = "org.jbox2d.dynamics.joints.MouseJoint";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                /**
                 * A prismatic joint. This joint provides one degree of freedom: translation
                 * along an axis fixed in body1. Relative rotation is prevented. You can
                 * use a joint limit to restrict the range of motion and a joint motor to
                 * drive the motion or to model joint friction.
                 * @param {org.jbox2d.dynamics.joints.PrismaticJointDef} def
                 * @class
                 * @extends org.jbox2d.dynamics.joints.Joint
                 */
                var PrismaticJoint = (function (_super) {
                    __extends(PrismaticJoint, _super);
                    function PrismaticJoint(def) {
                        var _this = _super.call(this, def) || this;
                        if (_this.m_localAnchor1 === undefined)
                            _this.m_localAnchor1 = null;
                        if (_this.m_localAnchor2 === undefined)
                            _this.m_localAnchor2 = null;
                        if (_this.m_localXAxis1 === undefined)
                            _this.m_localXAxis1 = null;
                        if (_this.m_localYAxis1 === undefined)
                            _this.m_localYAxis1 = null;
                        if (_this.m_refAngle === undefined)
                            _this.m_refAngle = 0;
                        if (_this.m_linearJacobian === undefined)
                            _this.m_linearJacobian = null;
                        if (_this.m_linearMass === undefined)
                            _this.m_linearMass = 0;
                        if (_this.m_force === undefined)
                            _this.m_force = 0;
                        if (_this.m_angularMass === undefined)
                            _this.m_angularMass = 0;
                        if (_this.m_torque === undefined)
                            _this.m_torque = 0;
                        if (_this.m_motorJacobian === undefined)
                            _this.m_motorJacobian = null;
                        if (_this.m_motorMass === undefined)
                            _this.m_motorMass = 0;
                        if (_this.m_motorForce === undefined)
                            _this.m_motorForce = 0;
                        if (_this.m_limitForce === undefined)
                            _this.m_limitForce = 0;
                        if (_this.m_limitPositionImpulse === undefined)
                            _this.m_limitPositionImpulse = 0;
                        if (_this.m_lowerTranslation === undefined)
                            _this.m_lowerTranslation = 0;
                        if (_this.m_upperTranslation === undefined)
                            _this.m_upperTranslation = 0;
                        if (_this.m_maxMotorForce === undefined)
                            _this.m_maxMotorForce = 0;
                        if (_this.m_motorSpeed === undefined)
                            _this.m_motorSpeed = 0;
                        if (_this.m_enableLimit === undefined)
                            _this.m_enableLimit = false;
                        if (_this.m_enableMotor === undefined)
                            _this.m_enableMotor = false;
                        if (_this.m_limitState === undefined)
                            _this.m_limitState = null;
                        if (_this.m_lastWarmStartingForce === undefined)
                            _this.m_lastWarmStartingForce = 0;
                        if (_this.m_lastWarmStartingTorque === undefined)
                            _this.m_lastWarmStartingTorque = 0;
                        _this.m_localAnchor1 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAnchor1);
                        _this.m_localAnchor2 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAnchor2);
                        _this.m_localXAxis1 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAxis1);
                        _this.m_localYAxis1 = org.jbox2d.common.Vec2.cross$float$org_jbox2d_common_Vec2(1.0, _this.m_localXAxis1);
                        _this.m_refAngle = def.referenceAngle;
                        _this.m_linearJacobian = new org.jbox2d.dynamics.joints.Jacobian();
                        _this.m_linearMass = 0.0;
                        _this.m_force = 0.0;
                        _this.m_angularMass = 0.0;
                        _this.m_torque = 0.0;
                        _this.m_motorJacobian = new org.jbox2d.dynamics.joints.Jacobian();
                        _this.m_motorMass = 0.0;
                        _this.m_motorForce = 0.0;
                        _this.m_limitForce = 0.0;
                        _this.m_limitPositionImpulse = 0.0;
                        _this.m_lowerTranslation = def.lowerTranslation;
                        _this.m_upperTranslation = def.upperTranslation;
                        _this.m_maxMotorForce = def.maxMotorForce;
                        _this.m_motorSpeed = def.motorSpeed;
                        _this.m_enableLimit = def.enableLimit;
                        _this.m_enableMotor = def.enableMotor;
                        return _this;
                    }
                    PrismaticJoint.tlr1_$LI$ = function () { if (PrismaticJoint.tlr1 == null)
                        PrismaticJoint.tlr1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlr1; };
                    ;
                    PrismaticJoint.tlr2_$LI$ = function () { if (PrismaticJoint.tlr2 == null)
                        PrismaticJoint.tlr2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlr2; };
                    ;
                    PrismaticJoint.tlax1_$LI$ = function () { if (PrismaticJoint.tlax1 == null)
                        PrismaticJoint.tlax1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlax1; };
                    ;
                    PrismaticJoint.tlay1_$LI$ = function () { if (PrismaticJoint.tlay1 == null)
                        PrismaticJoint.tlay1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlay1; };
                    ;
                    PrismaticJoint.tle_$LI$ = function () { if (PrismaticJoint.tle == null)
                        PrismaticJoint.tle = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tle; };
                    ;
                    PrismaticJoint.tlax1Neg_$LI$ = function () { if (PrismaticJoint.tlax1Neg == null)
                        PrismaticJoint.tlax1Neg = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlax1Neg; };
                    ;
                    PrismaticJoint.tlay1Neg_$LI$ = function () { if (PrismaticJoint.tlay1Neg == null)
                        PrismaticJoint.tlay1Neg = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlay1Neg; };
                    ;
                    PrismaticJoint.tld_$LI$ = function () { if (PrismaticJoint.tld == null)
                        PrismaticJoint.tld = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tld; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    PrismaticJoint.prototype.initVelocityConstraints = function (step) {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr2_$LI$());
                        var ax1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlax1_$LI$());
                        var ay1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlay1_$LI$());
                        var e = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tle_$LI$());
                        var ax1Neg = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlax1Neg_$LI$());
                        var ay1Neg = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlay1Neg_$LI$());
                        var d = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tld_$LI$());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
                        var invMass1 = b1.m_invMass;
                        var invMass2 = b2.m_invMass;
                        var invI1 = b1.m_invI;
                        var invI2 = b2.m_invI;
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localYAxis1, ay1);
                        e.set$org_jbox2d_common_Vec2(b2.m_sweep.c);
                        e.addLocal$org_jbox2d_common_Vec2(r2).subLocal(b1.m_sweep.c);
                        org.jbox2d.common.Vec2.negateToOut(ay1, ay1Neg);
                        this.m_linearJacobian.set(ay1Neg, -org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(e, ay1), ay1, org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, ay1));
                        this.m_linearMass = Math.fround(Math.fround(Math.fround(invMass1 + Math.fround(Math.fround(invI1 * this.m_linearJacobian.angular1) * this.m_linearJacobian.angular1)) + invMass2) + Math.fround(Math.fround(invI2 * this.m_linearJacobian.angular2) * this.m_linearJacobian.angular2));
                        if (!(this.m_linearMass > org.jbox2d.common.Settings.EPSILON))
                            throw new Error("Assertion error line 148: assert m_linearMass > Settings.EPSILON;");
                        ;
                        this.m_linearMass = Math.fround(1.0 / this.m_linearMass);
                        this.m_angularMass = Math.fround(invI1 + invI2);
                        if (this.m_angularMass > org.jbox2d.common.Settings.EPSILON) {
                            this.m_angularMass = Math.fround(1.0 / this.m_angularMass);
                        }
                        if (this.m_enableLimit || this.m_enableMotor) {
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localXAxis1, ax1);
                            org.jbox2d.common.Vec2.negateToOut(ax1, ax1Neg);
                            this.m_motorJacobian.set(ax1Neg, -org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(e, ax1), ax1, org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, ax1));
                            this.m_motorMass = Math.fround(Math.fround(Math.fround(invMass1 + Math.fround(Math.fround(invI1 * this.m_motorJacobian.angular1) * this.m_motorJacobian.angular1)) + invMass2) + Math.fround(Math.fround(invI2 * this.m_motorJacobian.angular2) * this.m_motorJacobian.angular2));
                            if (!(this.m_motorMass > org.jbox2d.common.Settings.EPSILON))
                                throw new Error("Assertion error line 159: assert m_motorMass > Settings.EPSILON;");
                            ;
                            this.m_motorMass = Math.fround(1.0 / this.m_motorMass);
                            if (this.m_enableLimit) {
                                d.set$org_jbox2d_common_Vec2(e);
                                d.subLocal(r1);
                                var jointTranslation = org.jbox2d.common.Vec2.dot(ax1, d);
                                if (org.jbox2d.common.MathUtils.abs(Math.fround(this.m_upperTranslation - this.m_lowerTranslation)) < Math.fround(2.0 * org.jbox2d.common.Settings.linearSlop_$LI$())) {
                                    this.m_limitState = org.jbox2d.dynamics.joints.LimitState.EQUAL_LIMITS;
                                }
                                else if (jointTranslation <= this.m_lowerTranslation) {
                                    if (this.m_limitState !== org.jbox2d.dynamics.joints.LimitState.AT_LOWER_LIMIT) {
                                        this.m_limitForce = 0.0;
                                    }
                                    this.m_limitState = org.jbox2d.dynamics.joints.LimitState.AT_LOWER_LIMIT;
                                }
                                else if (jointTranslation >= this.m_upperTranslation) {
                                    if (this.m_limitState !== org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                                        this.m_limitForce = 0.0;
                                    }
                                    this.m_limitState = org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT;
                                }
                                else {
                                    this.m_limitState = org.jbox2d.dynamics.joints.LimitState.INACTIVE_LIMIT;
                                    this.m_limitForce = 0.0;
                                }
                            }
                        }
                        if (this.m_enableMotor === false) {
                            this.m_motorForce = 0.0;
                        }
                        if (this.m_enableLimit === false) {
                            this.m_limitForce = 0.0;
                        }
                        if (step.warmStarting) {
                            var L1 = Math.fround(step.dt * (Math.fround(Math.fround(Math.fround(this.m_force * this.m_linearJacobian.angular1) - this.m_torque) + Math.fround((Math.fround(this.m_motorForce + this.m_limitForce)) * this.m_motorJacobian.angular1))));
                            var L2 = Math.fround(step.dt * (Math.fround(Math.fround(Math.fround(this.m_force * this.m_linearJacobian.angular2) + this.m_torque) + Math.fround((Math.fround(this.m_motorForce + this.m_limitForce)) * this.m_motorJacobian.angular2))));
                            b1.m_linearVelocity.x += Math.fround(Math.fround(invMass1 * step.dt) * (Math.fround(Math.fround(this.m_force * this.m_linearJacobian.linear1.x) + Math.fround((Math.fround(this.m_motorForce + this.m_limitForce)) * this.m_motorJacobian.linear1.x))));
                            b1.m_linearVelocity.y += Math.fround(Math.fround(invMass1 * step.dt) * (Math.fround(Math.fround(this.m_force * this.m_linearJacobian.linear1.y) + Math.fround((Math.fround(this.m_motorForce + this.m_limitForce)) * this.m_motorJacobian.linear1.y))));
                            b1.m_angularVelocity += Math.fround(invI1 * L1);
                            b2.m_linearVelocity.x += Math.fround(Math.fround(invMass2 * step.dt) * (Math.fround(Math.fround(this.m_force * this.m_linearJacobian.linear2.x) + Math.fround((Math.fround(this.m_motorForce + this.m_limitForce)) * this.m_motorJacobian.linear2.x))));
                            b2.m_linearVelocity.y += Math.fround(Math.fround(invMass2 * step.dt) * (Math.fround(Math.fround(this.m_force * this.m_linearJacobian.linear2.y) + Math.fround((Math.fround(this.m_motorForce + this.m_limitForce)) * this.m_motorJacobian.linear2.y))));
                            b2.m_angularVelocity += Math.fround(invI2 * L2);
                        }
                        else {
                            this.m_force = 0.0;
                            this.m_torque = 0.0;
                            this.m_limitForce = 0.0;
                            this.m_motorForce = 0.0;
                        }
                        this.m_limitPositionImpulse = 0.0;
                    };
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    PrismaticJoint.prototype.solveVelocityConstraints = function (step) {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var invMass1 = b1.m_invMass;
                        var invMass2 = b2.m_invMass;
                        var invI1 = b1.m_invI;
                        var invI2 = b2.m_invI;
                        var linearCdot = this.m_linearJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
                        var force = Math.fround(Math.fround(-step.inv_dt * this.m_linearMass) * linearCdot);
                        if (step.warmStarting) {
                            this.m_force += (force);
                            this.m_lastWarmStartingForce = this.m_force;
                        }
                        else {
                            this.m_force = this.m_lastWarmStartingForce;
                        }
                        var P = Math.fround(step.dt * force);
                        b1.m_linearVelocity.x += Math.fround((Math.fround(invMass1 * P)) * this.m_linearJacobian.linear1.x);
                        b1.m_linearVelocity.y += Math.fround((Math.fround(invMass1 * P)) * this.m_linearJacobian.linear1.y);
                        b1.m_angularVelocity += Math.fround(Math.fround(invI1 * P) * this.m_linearJacobian.angular1);
                        b2.m_linearVelocity.x += Math.fround((Math.fround(invMass2 * P)) * this.m_linearJacobian.linear2.x);
                        b2.m_linearVelocity.y += Math.fround((Math.fround(invMass2 * P)) * this.m_linearJacobian.linear2.y);
                        b2.m_angularVelocity += Math.fround(Math.fround(invI2 * P) * this.m_linearJacobian.angular2);
                        var angularCdot = Math.fround(b2.m_angularVelocity - b1.m_angularVelocity);
                        var torque = Math.fround(Math.fround(-step.inv_dt * this.m_angularMass) * angularCdot);
                        this.m_torque += torque;
                        if (step.warmStarting) {
                            this.m_torque += torque;
                            this.m_lastWarmStartingTorque = this.m_torque;
                        }
                        else {
                            this.m_torque = this.m_lastWarmStartingTorque;
                        }
                        var L = Math.fround(step.dt * torque);
                        b1.m_angularVelocity -= Math.fround(invI1 * L);
                        b2.m_angularVelocity += Math.fround(invI2 * L);
                        if (this.m_enableMotor && this.m_limitState !== org.jbox2d.dynamics.joints.LimitState.EQUAL_LIMITS) {
                            var motorCdot = Math.fround(this.m_motorJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity) - this.m_motorSpeed);
                            var motorForce = Math.fround(Math.fround(-step.inv_dt * this.m_motorMass) * motorCdot);
                            var oldMotorForce = this.m_motorForce;
                            this.m_motorForce = org.jbox2d.common.MathUtils.clamp$float$float$float(Math.fround(this.m_motorForce + motorForce), -this.m_maxMotorForce, this.m_maxMotorForce);
                            motorForce = Math.fround(this.m_motorForce - oldMotorForce);
                            var P2 = Math.fround(step.dt * motorForce);
                            b1.m_linearVelocity.x += Math.fround((Math.fround(invMass1 * P2)) * this.m_motorJacobian.linear1.x);
                            b1.m_linearVelocity.y += Math.fround((Math.fround(invMass1 * P2)) * this.m_motorJacobian.linear1.y);
                            b1.m_angularVelocity += Math.fround(Math.fround(invI1 * P2) * this.m_motorJacobian.angular1);
                            b2.m_linearVelocity.x += Math.fround((Math.fround(invMass2 * P2)) * this.m_motorJacobian.linear2.x);
                            b2.m_linearVelocity.y += Math.fround((Math.fround(invMass2 * P2)) * this.m_motorJacobian.linear2.y);
                            b2.m_angularVelocity += Math.fround(Math.fround(invI2 * P2) * this.m_motorJacobian.angular2);
                        }
                        if (this.m_enableLimit && this.m_limitState !== org.jbox2d.dynamics.joints.LimitState.INACTIVE_LIMIT) {
                            var limitCdot = this.m_motorJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
                            var limitForce = Math.fround(Math.fround(-step.inv_dt * this.m_motorMass) * limitCdot);
                            if (this.m_limitState === org.jbox2d.dynamics.joints.LimitState.EQUAL_LIMITS) {
                                this.m_limitForce += limitForce;
                            }
                            else if (this.m_limitState === org.jbox2d.dynamics.joints.LimitState.AT_LOWER_LIMIT) {
                                var oldLimitForce = this.m_limitForce;
                                this.m_limitForce = org.jbox2d.common.MathUtils.max$float$float(Math.fround(this.m_limitForce + limitForce), 0.0);
                                limitForce = Math.fround(this.m_limitForce - oldLimitForce);
                            }
                            else if (this.m_limitState === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                                var oldLimitForce = this.m_limitForce;
                                this.m_limitForce = org.jbox2d.common.MathUtils.min(Math.fround(this.m_limitForce + limitForce), 0.0);
                                limitForce = Math.fround(this.m_limitForce - oldLimitForce);
                            }
                            var P2 = Math.fround(step.dt * limitForce);
                            b1.m_linearVelocity.x += Math.fround((Math.fround(invMass1 * P2)) * this.m_motorJacobian.linear1.x);
                            b1.m_linearVelocity.y += Math.fround((Math.fround(invMass1 * P2)) * this.m_motorJacobian.linear1.y);
                            b1.m_angularVelocity += Math.fround(Math.fround(invI1 * P2) * this.m_motorJacobian.angular1);
                            b2.m_linearVelocity.x += Math.fround((Math.fround(invMass2 * P2)) * this.m_motorJacobian.linear2.x);
                            b2.m_linearVelocity.y += Math.fround((Math.fround(invMass2 * P2)) * this.m_motorJacobian.linear2.y);
                            b2.m_angularVelocity += Math.fround(Math.fround(invI2 * P2) * this.m_motorJacobian.angular2);
                        }
                    };
                    PrismaticJoint.tltemp_$LI$ = function () { if (PrismaticJoint.tltemp == null)
                        PrismaticJoint.tltemp = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tltemp; };
                    ;
                    PrismaticJoint.tlp1_$LI$ = function () { if (PrismaticJoint.tlp1 == null)
                        PrismaticJoint.tlp1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlp1; };
                    ;
                    PrismaticJoint.tlp2_$LI$ = function () { if (PrismaticJoint.tlp2 == null)
                        PrismaticJoint.tlp2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlp2; };
                    ;
                    PrismaticJoint.tlr1z_$LI$ = function () { if (PrismaticJoint.tlr1z == null)
                        PrismaticJoint.tlr1z = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlr1z; };
                    ;
                    PrismaticJoint.tlr2z_$LI$ = function () { if (PrismaticJoint.tlr2z == null)
                        PrismaticJoint.tlr2z = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlr2z; };
                    ;
                    PrismaticJoint.tlp1z_$LI$ = function () { if (PrismaticJoint.tlp1z == null)
                        PrismaticJoint.tlp1z = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlp1z; };
                    ;
                    PrismaticJoint.tlp2z_$LI$ = function () { if (PrismaticJoint.tlp2z == null)
                        PrismaticJoint.tlp2z = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlp2z; };
                    ;
                    PrismaticJoint.tldz_$LI$ = function () { if (PrismaticJoint.tldz == null)
                        PrismaticJoint.tldz = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tldz; };
                    ;
                    /**
                     *
                     * @return {boolean}
                     */
                    PrismaticJoint.prototype.solvePositionConstraints = function () {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var temp = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tltemp_$LI$());
                        var p1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp1_$LI$());
                        var p2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp2_$LI$());
                        var r1z = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr1z_$LI$());
                        var r2z = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr2z_$LI$());
                        var p1z = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp1z_$LI$());
                        var p2z = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp2z_$LI$());
                        var dz = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tldz_$LI$());
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr2_$LI$());
                        var d = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tld_$LI$());
                        var ax1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlax1_$LI$());
                        var ay1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlay1_$LI$());
                        var invMass1 = b1.m_invMass;
                        var invMass2 = b2.m_invMass;
                        var invI1 = b1.m_invI;
                        var invI2 = b2.m_invI;
                        temp.set$org_jbox2d_common_Vec2(this.m_localAnchor1);
                        temp.subLocal(b1.getMemberLocalCenter());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, temp, r1);
                        temp.set$org_jbox2d_common_Vec2(this.m_localAnchor2);
                        temp.subLocal(b2.getMemberLocalCenter());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, temp, r2);
                        p1.set$org_jbox2d_common_Vec2(b1.m_sweep.c);
                        p1.addLocal$org_jbox2d_common_Vec2(r1);
                        p2.set$org_jbox2d_common_Vec2(b2.m_sweep.c);
                        p2.addLocal$org_jbox2d_common_Vec2(r2);
                        d.set$org_jbox2d_common_Vec2(p2);
                        d.subLocal(p1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localYAxis1, ay1);
                        var linearC = org.jbox2d.common.Vec2.dot(ay1, d);
                        linearC = org.jbox2d.common.MathUtils.clamp$float$float$float(linearC, -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), org.jbox2d.common.Settings.maxLinearCorrection_$LI$());
                        var linearImpulse = Math.fround(-this.m_linearMass * linearC);
                        b1.m_sweep.c.x += Math.fround((Math.fround(invMass1 * linearImpulse)) * this.m_linearJacobian.linear1.x);
                        b1.m_sweep.c.y += Math.fround((Math.fround(invMass1 * linearImpulse)) * this.m_linearJacobian.linear1.y);
                        b1.m_sweep.a += Math.fround(Math.fround(invI1 * linearImpulse) * this.m_linearJacobian.angular1);
                        b2.m_sweep.c.x += Math.fround((Math.fround(invMass2 * linearImpulse)) * this.m_linearJacobian.linear2.x);
                        b2.m_sweep.c.y += Math.fround((Math.fround(invMass2 * linearImpulse)) * this.m_linearJacobian.linear2.y);
                        b2.m_sweep.a += Math.fround(Math.fround(invI2 * linearImpulse) * this.m_linearJacobian.angular2);
                        var positionError = org.jbox2d.common.MathUtils.abs(linearC);
                        var angularC = Math.fround(Math.fround(b2.m_sweep.a - b1.m_sweep.a) - this.m_refAngle);
                        angularC = org.jbox2d.common.MathUtils.clamp$float$float$float(angularC, -org.jbox2d.common.Settings.maxAngularCorrection_$LI$(), org.jbox2d.common.Settings.maxAngularCorrection_$LI$());
                        var angularImpulse = Math.fround(-this.m_angularMass * angularC);
                        b1.m_sweep.a -= Math.fround(b1.m_invI * angularImpulse);
                        b2.m_sweep.a += Math.fround(b2.m_invI * angularImpulse);
                        b1.synchronizeTransform();
                        b2.synchronizeTransform();
                        var angularError = org.jbox2d.common.MathUtils.abs(angularC);
                        if (this.m_enableLimit && this.m_limitState !== org.jbox2d.dynamics.joints.LimitState.INACTIVE_LIMIT) {
                            temp.set$org_jbox2d_common_Vec2(this.m_localAnchor1);
                            temp.subLocal(b1.getMemberLocalCenter());
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, temp, r1z);
                            temp.set$org_jbox2d_common_Vec2(this.m_localAnchor2);
                            temp.subLocal(b2.getMemberLocalCenter());
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, temp, r2z);
                            p1z.set$org_jbox2d_common_Vec2(b1.m_sweep.c);
                            p1z.addLocal$org_jbox2d_common_Vec2(r1z);
                            p2z.set$org_jbox2d_common_Vec2(b2.m_sweep.c);
                            p2z.addLocal$org_jbox2d_common_Vec2(r2z);
                            dz.set$org_jbox2d_common_Vec2(p2z);
                            dz.subLocal(p1z);
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localXAxis1, ax1);
                            var translation = org.jbox2d.common.Vec2.dot(ax1, dz);
                            var limitImpulse = 0.0;
                            if (this.m_limitState === org.jbox2d.dynamics.joints.LimitState.EQUAL_LIMITS) {
                                var limitC = org.jbox2d.common.MathUtils.clamp$float$float$float(translation, -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), org.jbox2d.common.Settings.maxLinearCorrection_$LI$());
                                limitImpulse = Math.fround(-this.m_motorMass * limitC);
                                positionError = org.jbox2d.common.MathUtils.max$float$float(positionError, org.jbox2d.common.MathUtils.abs(angularC));
                            }
                            else if (this.m_limitState === org.jbox2d.dynamics.joints.LimitState.AT_LOWER_LIMIT) {
                                var limitC = Math.fround(translation - this.m_lowerTranslation);
                                positionError = org.jbox2d.common.MathUtils.max$float$float(positionError, -limitC);
                                limitC = org.jbox2d.common.MathUtils.clamp$float$float$float(Math.fround(limitC + org.jbox2d.common.Settings.linearSlop_$LI$()), -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), 0.0);
                                limitImpulse = Math.fround(-this.m_motorMass * limitC);
                                var oldLimitImpulse = this.m_limitPositionImpulse;
                                this.m_limitPositionImpulse = org.jbox2d.common.MathUtils.max$float$float(Math.fround(this.m_limitPositionImpulse + limitImpulse), 0.0);
                                limitImpulse = Math.fround(this.m_limitPositionImpulse - oldLimitImpulse);
                            }
                            else if (this.m_limitState === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                                var limitC = Math.fround(translation - this.m_upperTranslation);
                                positionError = org.jbox2d.common.MathUtils.max$float$float(positionError, limitC);
                                limitC = org.jbox2d.common.MathUtils.clamp$float$float$float(Math.fround(limitC - org.jbox2d.common.Settings.linearSlop_$LI$()), 0.0, org.jbox2d.common.Settings.maxLinearCorrection_$LI$());
                                limitImpulse = Math.fround(-this.m_motorMass * limitC);
                                var oldLimitImpulse = this.m_limitPositionImpulse;
                                this.m_limitPositionImpulse = org.jbox2d.common.MathUtils.min(Math.fround(this.m_limitPositionImpulse + limitImpulse), 0.0);
                                limitImpulse = Math.fround(this.m_limitPositionImpulse - oldLimitImpulse);
                            }
                            b1.m_sweep.c.x += Math.fround((Math.fround(invMass1 * limitImpulse)) * this.m_motorJacobian.linear1.x);
                            b1.m_sweep.c.y += Math.fround((Math.fround(invMass1 * limitImpulse)) * this.m_motorJacobian.linear1.y);
                            b1.m_sweep.a += Math.fround(Math.fround(invI1 * limitImpulse) * this.m_motorJacobian.angular1);
                            b2.m_sweep.c.x += Math.fround((Math.fround(invMass2 * limitImpulse)) * this.m_motorJacobian.linear2.x);
                            b2.m_sweep.c.y += Math.fround((Math.fround(invMass2 * limitImpulse)) * this.m_motorJacobian.linear2.y);
                            b2.m_sweep.a += Math.fround(Math.fround(invI2 * limitImpulse) * this.m_motorJacobian.angular2);
                            b1.synchronizeTransform();
                            b2.synchronizeTransform();
                        }
                        return positionError <= org.jbox2d.common.Settings.linearSlop_$LI$() && angularError <= org.jbox2d.common.Settings.angularSlop_$LI$();
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    PrismaticJoint.prototype.getAnchor1 = function () {
                        return this.m_body1.getWorldLocation(this.m_localAnchor1);
                    };
                    PrismaticJoint.prototype.getAnchor1ToOut = function (out) {
                        this.m_body1.getWorldLocationToOut(this.m_localAnchor1, out);
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    PrismaticJoint.prototype.getAnchor2 = function () {
                        return this.m_body2.getWorldLocation(this.m_localAnchor2);
                    };
                    PrismaticJoint.prototype.getAnchor2ToOut = function (out) {
                        this.m_body2.getWorldLocationToOut(this.m_localAnchor2, out);
                    };
                    PrismaticJoint.tlaxis_$LI$ = function () { if (PrismaticJoint.tlaxis == null)
                        PrismaticJoint.tlaxis = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlaxis; };
                    ;
                    PrismaticJoint.prototype.getJointTranslation = function () {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var axis = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlaxis_$LI$());
                        var p1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp1_$LI$());
                        var p2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp2_$LI$());
                        var d = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tld_$LI$());
                        b1.getWorldLocationToOut(this.m_localAnchor1, p1);
                        b2.getWorldLocationToOut(this.m_localAnchor2, p2);
                        d.set$org_jbox2d_common_Vec2(p2);
                        d.subLocal(p1);
                        b1.getWorldDirectionToOut(this.m_localXAxis1, axis);
                        var translation = org.jbox2d.common.Vec2.dot(d, axis);
                        return translation;
                    };
                    PrismaticJoint.tlw1xAxis_$LI$ = function () { if (PrismaticJoint.tlw1xAxis == null)
                        PrismaticJoint.tlw1xAxis = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlw1xAxis; };
                    ;
                    PrismaticJoint.tlv22_$LI$ = function () { if (PrismaticJoint.tlv22 == null)
                        PrismaticJoint.tlv22 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlv22; };
                    ;
                    PrismaticJoint.tlw2xR2_$LI$ = function () { if (PrismaticJoint.tlw2xR2 == null)
                        PrismaticJoint.tlw2xR2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlw2xR2; };
                    ;
                    PrismaticJoint.tlw1xR1_$LI$ = function () { if (PrismaticJoint.tlw1xR1 == null)
                        PrismaticJoint.tlw1xR1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlw1xR1; };
                    ;
                    PrismaticJoint.prototype.getJointSpeed = function () {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlr2_$LI$());
                        var p1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp1_$LI$());
                        var p2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlp2_$LI$());
                        var d = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tld_$LI$());
                        var axis = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlaxis_$LI$());
                        var w1xAxis = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlw1xAxis_$LI$());
                        var v22 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlv22_$LI$());
                        var w2xR2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlw2xR2_$LI$());
                        var w1xR1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlw1xR1_$LI$());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
                        p1.set$org_jbox2d_common_Vec2(b1.m_sweep.c);
                        p1.addLocal$org_jbox2d_common_Vec2(r1);
                        p2.set$org_jbox2d_common_Vec2(b2.m_sweep.c);
                        p2.addLocal$org_jbox2d_common_Vec2(r2);
                        d.set$org_jbox2d_common_Vec2(p2);
                        d.subLocal(p1);
                        b1.getWorldDirectionToOut(this.m_localXAxis1, axis);
                        var v1 = b1.m_linearVelocity;
                        var v2 = b2.m_linearVelocity;
                        var w1 = b1.m_angularVelocity;
                        var w2 = b2.m_angularVelocity;
                        org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(w1, axis, w1xAxis);
                        org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(w2, r2, w2xR2);
                        org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(w1, r1, w1xR1);
                        v22.set$org_jbox2d_common_Vec2(v2);
                        var speed = Math.fround(org.jbox2d.common.Vec2.dot(d, w1xAxis) + org.jbox2d.common.Vec2.dot(axis, v22.addLocal$org_jbox2d_common_Vec2(w2xR2).subLocal(v1).subLocal(w1xR1)));
                        return speed;
                    };
                    /**
                     *
                     * @return {number}
                     */
                    PrismaticJoint.prototype.getReactionTorque = function () {
                        return this.m_torque;
                    };
                    /**
                     *
                     * @return {org.jbox2d.common.Vec2}
                     */
                    PrismaticJoint.prototype.getReactionForce = function () {
                        var ax1 = org.jbox2d.common.Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2(this.m_body1.m_xf.R, this.m_localXAxis1);
                        var ay1 = org.jbox2d.common.Mat22.mul$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2(this.m_body1.m_xf.R, this.m_localYAxis1);
                        return new org.jbox2d.common.Vec2(Math.fround(Math.fround(this.m_limitForce * ax1.x) + Math.fround(this.m_force * ay1.x)), Math.fround(Math.fround(this.m_limitForce * ax1.y) + Math.fround(this.m_force * ay1.y)));
                    };
                    PrismaticJoint.tlreactionAx1_$LI$ = function () { if (PrismaticJoint.tlreactionAx1 == null)
                        PrismaticJoint.tlreactionAx1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PrismaticJoint.tlreactionAx1; };
                    ;
                    PrismaticJoint.prototype.getReactionForceToOut = function (out) {
                        var reactionAx1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PrismaticJoint.tlreactionAx1_$LI$());
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(this.m_body1.m_xf.R, this.m_localXAxis1, reactionAx1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(this.m_body1.m_xf.R, this.m_localYAxis1, out);
                        out.x = Math.fround(Math.fround(this.m_limitForce * reactionAx1.x) + Math.fround(this.m_force * out.x));
                        out.y = Math.fround(Math.fround(this.m_limitForce * reactionAx1.y) + Math.fround(this.m_force * out.y));
                    };
                    /**
                     * Is the joint limit enabled?
                     * @return {boolean}
                     */
                    PrismaticJoint.prototype.isLimitEnabled = function () {
                        return this.m_enableLimit;
                    };
                    /**
                     * Enable/disable the joint limit.
                     * @param {boolean} flag
                     */
                    PrismaticJoint.prototype.enableLimit = function (flag) {
                        this.m_enableLimit = flag;
                    };
                    /**
                     * Get the lower joint limit, usually in meters.
                     * @return {number}
                     */
                    PrismaticJoint.prototype.getLowerLimit = function () {
                        return this.m_lowerTranslation;
                    };
                    /**
                     * Get the upper joint limit, usually in meters.
                     * @return {number}
                     */
                    PrismaticJoint.prototype.getUpperLimit = function () {
                        return this.m_upperTranslation;
                    };
                    /**
                     * Set the joint limits, usually in meters.
                     * @param {number} lower
                     * @param {number} upper
                     */
                    PrismaticJoint.prototype.setLimits = function (lower, upper) {
                        if (!((lower <= upper)))
                            throw new Error("Assertion error line 557: assert (lower <= upper);");
                        ;
                        this.m_lowerTranslation = lower;
                        this.m_upperTranslation = upper;
                    };
                    /**
                     * Is the joint motor enabled?
                     * @return {boolean}
                     */
                    PrismaticJoint.prototype.isMotorEnabled = function () {
                        return this.m_enableMotor;
                    };
                    /**
                     * Enable/disable the joint motor.
                     * @param {boolean} flag
                     */
                    PrismaticJoint.prototype.enableMotor = function (flag) {
                        this.m_enableMotor = flag;
                    };
                    /**
                     * Set the motor speed, usually in meters per second.
                     * @param {number} speed
                     */
                    PrismaticJoint.prototype.setMotorSpeed = function (speed) {
                        this.m_motorSpeed = speed;
                    };
                    /**
                     * Get the motor speed, usually in meters per second.
                     * @return {number}
                     */
                    PrismaticJoint.prototype.getMotorSpeed = function () {
                        return this.m_motorSpeed;
                    };
                    /**
                     * Set the maximum motor torque, usually in N.
                     * @param {number} force
                     */
                    PrismaticJoint.prototype.setMaxMotorForce = function (force) {
                        this.m_maxMotorForce = force;
                    };
                    /**
                     * Get the current motor torque, usually in N.
                     * @return {number}
                     */
                    PrismaticJoint.prototype.getMotorForce = function () {
                        return this.m_motorForce;
                    };
                    return PrismaticJoint;
                }(org.jbox2d.dynamics.joints.Joint));
                joints.PrismaticJoint = PrismaticJoint;
                PrismaticJoint["__class"] = "org.jbox2d.dynamics.joints.PrismaticJoint";
            })(joints = dynamics.joints || (dynamics.joints = {}));
        })(dynamics = jbox2d.dynamics || (jbox2d.dynamics = {}));
    })(jbox2d = org.jbox2d || (org.jbox2d = {}));
})(org || (org = {}));
(function (org) {
    var jbox2d;
    (function (jbox2d) {
        var dynamics;
        (function (dynamics) {
            var joints;
            (function (joints) {
                var PulleyJoint = (function (_super) {
                    __extends(PulleyJoint, _super);
                    function PulleyJoint(def) {
                        var _this = _super.call(this, def) || this;
                        if (_this.m_ground === undefined)
                            _this.m_ground = null;
                        if (_this.m_groundAnchor1 === undefined)
                            _this.m_groundAnchor1 = null;
                        if (_this.m_groundAnchor2 === undefined)
                            _this.m_groundAnchor2 = null;
                        if (_this.m_localAnchor1 === undefined)
                            _this.m_localAnchor1 = null;
                        if (_this.m_localAnchor2 === undefined)
                            _this.m_localAnchor2 = null;
                        if (_this.m_u1 === undefined)
                            _this.m_u1 = null;
                        if (_this.m_u2 === undefined)
                            _this.m_u2 = null;
                        if (_this.m_constant === undefined)
                            _this.m_constant = 0;
                        if (_this.m_ratio === undefined)
                            _this.m_ratio = 0;
                        if (_this.m_maxLength1 === undefined)
                            _this.m_maxLength1 = 0;
                        if (_this.m_maxLength2 === undefined)
                            _this.m_maxLength2 = 0;
                        if (_this.m_pulleyMass === undefined)
                            _this.m_pulleyMass = 0;
                        if (_this.m_limitMass1 === undefined)
                            _this.m_limitMass1 = 0;
                        if (_this.m_limitMass2 === undefined)
                            _this.m_limitMass2 = 0;
                        if (_this.m_force === undefined)
                            _this.m_force = 0;
                        if (_this.m_limitForce1 === undefined)
                            _this.m_limitForce1 = 0;
                        if (_this.m_limitForce2 === undefined)
                            _this.m_limitForce2 = 0;
                        if (_this.m_positionImpulse === undefined)
                            _this.m_positionImpulse = 0;
                        if (_this.m_limitPositionImpulse1 === undefined)
                            _this.m_limitPositionImpulse1 = 0;
                        if (_this.m_limitPositionImpulse2 === undefined)
                            _this.m_limitPositionImpulse2 = 0;
                        if (_this.m_state === undefined)
                            _this.m_state = null;
                        if (_this.m_limitState1 === undefined)
                            _this.m_limitState1 = null;
                        if (_this.m_limitState2 === undefined)
                            _this.m_limitState2 = null;
                        _this.m_ground = _this.m_body1.m_world.getGroundBody();
                        _this.m_groundAnchor1 = def.groundAnchor1.sub(_this.m_ground.m_xf.position);
                        _this.m_groundAnchor2 = def.groundAnchor2.sub(_this.m_ground.m_xf.position);
                        _this.m_localAnchor1 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAnchor1);
                        _this.m_localAnchor2 = (function (o) { if (o.clone != undefined) {
                            return o.clone();
                        }
                        else {
                            var clone = Object.create(o);
                            for (var p in o) {
                                if (o.hasOwnProperty(p))
                                    clone[p] = o[p];
                            }
                            return clone;
                        } })(def.localAnchor2);
                        _this.m_u1 = new org.jbox2d.common.Vec2();
                        _this.m_u2 = new org.jbox2d.common.Vec2();
                        if (!((def.ratio !== 0.0)))
                            throw new Error("Assertion error line 83: assert (def.ratio != 0.0F);");
                        ;
                        _this.m_ratio = def.ratio;
                        _this.m_constant = Math.fround(def.length1 + Math.fround(_this.m_ratio * def.length2));
                        _this.m_maxLength1 = org.jbox2d.common.MathUtils.min(def.maxLength1, Math.fround(_this.m_constant - Math.fround(_this.m_ratio * PulleyJoint.MIN_PULLEY_LENGTH)));
                        _this.m_maxLength2 = org.jbox2d.common.MathUtils.min(def.maxLength2, Math.fround((Math.fround(_this.m_constant - PulleyJoint.MIN_PULLEY_LENGTH)) / _this.m_ratio));
                        _this.m_force = 0.0;
                        _this.m_limitForce1 = 0.0;
                        _this.m_limitForce2 = 0.0;
                        return _this;
                    }
                    PulleyJoint.tlr1_$LI$ = function () { if (PulleyJoint.tlr1 == null)
                        PulleyJoint.tlr1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlr1; };
                    ;
                    PulleyJoint.tlr2_$LI$ = function () { if (PulleyJoint.tlr2 == null)
                        PulleyJoint.tlr2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlr2; };
                    ;
                    PulleyJoint.tlp1_$LI$ = function () { if (PulleyJoint.tlp1 == null)
                        PulleyJoint.tlp1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlp1; };
                    ;
                    PulleyJoint.tlp2_$LI$ = function () { if (PulleyJoint.tlp2 == null)
                        PulleyJoint.tlp2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlp2; };
                    ;
                    PulleyJoint.tls1_$LI$ = function () { if (PulleyJoint.tls1 == null)
                        PulleyJoint.tls1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tls1; };
                    ;
                    PulleyJoint.tls2_$LI$ = function () { if (PulleyJoint.tls2 == null)
                        PulleyJoint.tls2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tls2; };
                    ;
                    PulleyJoint.tlP1_$LI$ = function () { if (PulleyJoint.tlP1 == null)
                        PulleyJoint.tlP1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlP1; };
                    ;
                    PulleyJoint.tlP2_$LI$ = function () { if (PulleyJoint.tlP2 == null)
                        PulleyJoint.tlP2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlP2; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    PulleyJoint.prototype.initVelocityConstraints = function (step) {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlr2_$LI$());
                        var p1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlp1_$LI$());
                        var p2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlp2_$LI$());
                        var s1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tls1_$LI$());
                        var s2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tls2_$LI$());
                        var P1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlP1_$LI$());
                        var P2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlP2_$LI$());
                        r1.set$org_jbox2d_common_Vec2(b1.getMemberLocalCenter());
                        r2.set$org_jbox2d_common_Vec2(b2.getMemberLocalCenter());
                        r1.subLocal(this.m_localAnchor1).negateLocal();
                        r2.subLocal(this.m_localAnchor2).negateLocal();
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, r1, r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, r2, r2);
                        p1.set$org_jbox2d_common_Vec2(b1.m_sweep.c);
                        p1.addLocal$org_jbox2d_common_Vec2(r1);
                        p2.set$org_jbox2d_common_Vec2(b2.m_sweep.c);
                        p2.addLocal$org_jbox2d_common_Vec2(r2);
                        s1.set$org_jbox2d_common_Vec2(this.m_ground.m_xf.position);
                        s1.addLocal$org_jbox2d_common_Vec2(this.m_groundAnchor1);
                        s2.set$org_jbox2d_common_Vec2(this.m_ground.m_xf.position);
                        s2.addLocal$org_jbox2d_common_Vec2(this.m_groundAnchor2);
                        this.m_u1.set$org_jbox2d_common_Vec2(p1);
                        this.m_u1.subLocal(s1);
                        this.m_u2.set$org_jbox2d_common_Vec2(p2);
                        this.m_u2.subLocal(s2);
                        var length1 = this.m_u1.length();
                        var length2 = this.m_u2.length();
                        if (length1 > org.jbox2d.common.Settings.linearSlop_$LI$()) {
                            this.m_u1.mulLocal(Math.fround(1.0 / length1));
                        }
                        else {
                            this.m_u1.setZero();
                        }
                        if (length2 > org.jbox2d.common.Settings.linearSlop_$LI$()) {
                            this.m_u2.mulLocal(Math.fround(1.0 / length2));
                        }
                        else {
                            this.m_u2.setZero();
                        }
                        var C = Math.fround(Math.fround(this.m_constant - length1) - Math.fround(this.m_ratio * length2));
                        if (C > 0.0) {
                            this.m_state = org.jbox2d.dynamics.joints.LimitState.INACTIVE_LIMIT;
                            this.m_force = 0.0;
                        }
                        else {
                            this.m_state = org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT;
                            this.m_positionImpulse = 0.0;
                        }
                        if (length1 < this.m_maxLength1) {
                            this.m_limitState1 = org.jbox2d.dynamics.joints.LimitState.INACTIVE_LIMIT;
                            this.m_limitForce1 = 0.0;
                        }
                        else {
                            this.m_limitState1 = org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT;
                            this.m_limitPositionImpulse1 = 0.0;
                        }
                        if (length2 < this.m_maxLength2) {
                            this.m_limitState2 = org.jbox2d.dynamics.joints.LimitState.INACTIVE_LIMIT;
                            this.m_limitForce2 = 0.0;
                        }
                        else {
                            this.m_limitState2 = org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT;
                            this.m_limitPositionImpulse2 = 0.0;
                        }
                        var cr1u1 = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, this.m_u1);
                        var cr2u2 = org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, this.m_u2);
                        this.m_limitMass1 = Math.fround(b1.m_invMass + Math.fround(Math.fround(b1.m_invI * cr1u1) * cr1u1));
                        this.m_limitMass2 = Math.fround(b2.m_invMass + Math.fround(Math.fround(b2.m_invI * cr2u2) * cr2u2));
                        this.m_pulleyMass = Math.fround(this.m_limitMass1 + Math.fround(Math.fround(this.m_ratio * this.m_ratio) * this.m_limitMass2));
                        if (!((this.m_limitMass1 > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 181: assert (m_limitMass1 > Settings.EPSILON);");
                        ;
                        if (!((this.m_limitMass2 > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 182: assert (m_limitMass2 > Settings.EPSILON);");
                        ;
                        if (!((this.m_pulleyMass > org.jbox2d.common.Settings.EPSILON)))
                            throw new Error("Assertion error line 183: assert (m_pulleyMass > Settings.EPSILON);");
                        ;
                        this.m_limitMass1 = Math.fround(1.0 / this.m_limitMass1);
                        this.m_limitMass2 = Math.fround(1.0 / this.m_limitMass2);
                        this.m_pulleyMass = Math.fround(1.0 / this.m_pulleyMass);
                        if (step.warmStarting) {
                            P1.set$org_jbox2d_common_Vec2(this.m_u1);
                            P1.mulLocal(Math.fround(step.dt * (Math.fround(-this.m_force - this.m_limitForce1))));
                            P2.set$org_jbox2d_common_Vec2(this.m_u2);
                            P2.mulLocal(Math.fround(step.dt * (Math.fround(Math.fround(-this.m_ratio * this.m_force) - this.m_limitForce2))));
                            b1.m_angularVelocity += Math.fround(b1.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, P1));
                            b2.m_angularVelocity += Math.fround(b2.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, P2));
                            b1.m_linearVelocity.addLocal$org_jbox2d_common_Vec2(P1.mulLocal(b1.m_invMass));
                            b2.m_linearVelocity.addLocal$org_jbox2d_common_Vec2(P2.mulLocal(b2.m_invMass));
                        }
                        else {
                            this.m_force = 0.0;
                            this.m_limitForce1 = 0.0;
                            this.m_limitForce2 = 0.0;
                        }
                    };
                    PulleyJoint.tlv1_$LI$ = function () { if (PulleyJoint.tlv1 == null)
                        PulleyJoint.tlv1 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlv1; };
                    ;
                    PulleyJoint.tlv2_$LI$ = function () { if (PulleyJoint.tlv2 == null)
                        PulleyJoint.tlv2 = (function () { var __o = new org.jbox2d.pooling.TLVec2(); __o.__delegate = new org.jbox2d.pooling.TLVec2(); return __o; })(); return PulleyJoint.tlv2; };
                    ;
                    /**
                     *
                     * @param {org.jbox2d.dynamics.TimeStep} step
                     */
                    PulleyJoint.prototype.solveVelocityConstraints = function (step) {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var v1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlv1_$LI$());
                        var v2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlv2_$LI$());
                        var P1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlP1_$LI$());
                        var P2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlP2_$LI$());
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlr2_$LI$());
                        r1.set$org_jbox2d_common_Vec2(b1.getMemberLocalCenter());
                        r2.set$org_jbox2d_common_Vec2(b2.getMemberLocalCenter());
                        r1.subLocal(this.m_localAnchor1).negateLocal();
                        r2.subLocal(this.m_localAnchor2).negateLocal();
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, r1, r1);
                        org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, r2, r2);
                        if (this.m_state === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                            org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_angularVelocity, r1, v1);
                            org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_angularVelocity, r2, v2);
                            v1.add(b1.m_linearVelocity);
                            v2.add(b2.m_linearVelocity);
                            var Cdot = Math.fround(-org.jbox2d.common.Vec2.dot(this.m_u1, v1) - Math.fround(this.m_ratio * org.jbox2d.common.Vec2.dot(this.m_u2, v2)));
                            var force = Math.fround(Math.fround(-step.inv_dt * this.m_pulleyMass) * Cdot);
                            var oldForce = this.m_force;
                            this.m_force = org.jbox2d.common.MathUtils.max$float$float(0.0, Math.fround(this.m_force + force));
                            force = Math.fround(this.m_force - oldForce);
                            P1.set$org_jbox2d_common_Vec2(this.m_u1);
                            P1.mulLocal(Math.fround(-step.dt * force));
                            P2.set$org_jbox2d_common_Vec2(this.m_u2);
                            P2.mulLocal(Math.fround(Math.fround(-step.dt * this.m_ratio) * force));
                            b1.m_linearVelocity.x += Math.fround(b1.m_invMass * P1.x);
                            b1.m_linearVelocity.y += Math.fround(b1.m_invMass * P1.y);
                            b1.m_angularVelocity += Math.fround(b1.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, P1));
                            b2.m_linearVelocity.x += Math.fround(b2.m_invMass * P2.x);
                            b2.m_linearVelocity.y += Math.fround(b2.m_invMass * P2.y);
                            b2.m_angularVelocity += Math.fround(b2.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, P2));
                        }
                        if (this.m_limitState1 === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                            org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_angularVelocity, r1, v1);
                            v1.addLocal$org_jbox2d_common_Vec2(b1.m_linearVelocity);
                            var Cdot = -org.jbox2d.common.Vec2.dot(this.m_u1, v1);
                            var force = Math.fround(Math.fround(-step.inv_dt * this.m_limitMass1) * Cdot);
                            var oldForce = this.m_limitForce1;
                            this.m_limitForce1 = org.jbox2d.common.MathUtils.max$float$float(0.0, Math.fround(this.m_limitForce1 + force));
                            force = Math.fround(this.m_limitForce1 - oldForce);
                            P1.set$org_jbox2d_common_Vec2(this.m_u1);
                            P1.mulLocal(Math.fround(-step.dt * force));
                            b1.m_linearVelocity.x += Math.fround(b1.m_invMass * P1.x);
                            b1.m_linearVelocity.y += Math.fround(b1.m_invMass * P1.y);
                            b1.m_angularVelocity += Math.fround(b1.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, P1));
                        }
                        if (this.m_limitState2 === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                            org.jbox2d.common.Vec2.crossToOut$float$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_angularVelocity, r2, v2);
                            v2.addLocal$org_jbox2d_common_Vec2(b2.m_linearVelocity);
                            var Cdot = -org.jbox2d.common.Vec2.dot(this.m_u2, v2);
                            var force = Math.fround(Math.fround(-step.inv_dt * this.m_limitMass2) * Cdot);
                            var oldForce = this.m_limitForce2;
                            this.m_limitForce2 = org.jbox2d.common.MathUtils.max$float$float(0.0, Math.fround(this.m_limitForce2 + force));
                            force = Math.fround(this.m_limitForce2 - oldForce);
                            P2.set$org_jbox2d_common_Vec2(this.m_u2);
                            P2.mulLocal(Math.fround(-step.dt * force));
                            b2.m_linearVelocity.x += Math.fround(b2.m_invMass * P2.x);
                            b2.m_linearVelocity.y += Math.fround(b2.m_invMass * P2.y);
                            b2.m_angularVelocity += Math.fround(b2.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, P2));
                        }
                    };
                    /**
                     *
                     * @return {boolean}
                     */
                    PulleyJoint.prototype.solvePositionConstraints = function () {
                        var b1 = this.m_body1;
                        var b2 = this.m_body2;
                        var r1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlr1_$LI$());
                        var r2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlr2_$LI$());
                        var p1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlp1_$LI$());
                        var p2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlp2_$LI$());
                        var s1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tls1_$LI$());
                        var s2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tls2_$LI$());
                        var P1 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlP1_$LI$());
                        var P2 = (function (tlObj) { if (tlObj.___value) {
                            return tlObj.___value;
                        }
                        else {
                            return tlObj.___value = tlObj.initialValue();
                        } })(PulleyJoint.tlP2_$LI$());
                        s1.set$org_jbox2d_common_Vec2(this.m_ground.m_xf.position);
                        s1.addLocal$org_jbox2d_common_Vec2(this.m_groundAnchor1);
                        s2.set$org_jbox2d_common_Vec2(this.m_ground.m_xf.position);
                        s2.addLocal$org_jbox2d_common_Vec2(this.m_groundAnchor2);
                        var linearError = 0.0;
                        if (this.m_state === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                            r1.set$org_jbox2d_common_Vec2(b1.getMemberLocalCenter());
                            r2.set$org_jbox2d_common_Vec2(b2.getMemberLocalCenter());
                            r1.subLocal(this.m_localAnchor1).negateLocal();
                            r2.subLocal(this.m_localAnchor2).negateLocal();
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, r1, r1);
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, r2, r2);
                            p1.set$org_jbox2d_common_Vec2(b1.m_sweep.c);
                            p1.addLocal$org_jbox2d_common_Vec2(r1);
                            p2.set$org_jbox2d_common_Vec2(b2.m_sweep.c);
                            p2.addLocal$org_jbox2d_common_Vec2(r2);
                            this.m_u1.set$float$float(Math.fround(p1.x - s1.x), Math.fround(p1.y - s1.y));
                            this.m_u2.set$float$float(Math.fround(p2.x - s2.x), Math.fround(p2.y - s2.y));
                            var length1 = this.m_u1.length();
                            var length2 = this.m_u2.length();
                            if (length1 > org.jbox2d.common.Settings.linearSlop_$LI$()) {
                                this.m_u1.mulLocal(Math.fround(1.0 / length1));
                            }
                            else {
                                this.m_u1.setZero();
                            }
                            if (length2 > org.jbox2d.common.Settings.linearSlop_$LI$()) {
                                this.m_u2.mulLocal(Math.fround(1.0 / length2));
                            }
                            else {
                                this.m_u2.setZero();
                            }
                            var C = Math.fround(Math.fround(this.m_constant - length1) - Math.fround(this.m_ratio * length2));
                            linearError = org.jbox2d.common.MathUtils.max$float$float(linearError, -C);
                            C = org.jbox2d.common.MathUtils.clamp$float$float$float(Math.fround(C + org.jbox2d.common.Settings.linearSlop_$LI$()), -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), 0.0);
                            var impulse = Math.fround(-this.m_pulleyMass * C);
                            var oldImpulse = this.m_positionImpulse;
                            this.m_positionImpulse = org.jbox2d.common.MathUtils.max$float$float(0.0, Math.fround(this.m_positionImpulse + impulse));
                            impulse = Math.fround(this.m_positionImpulse - oldImpulse);
                            P1.set$org_jbox2d_common_Vec2(this.m_u1);
                            P1.mulLocal(-impulse);
                            P2.set$org_jbox2d_common_Vec2(this.m_u2);
                            P2.mulLocal(Math.fround(-this.m_ratio * impulse));
                            b1.m_sweep.c.x += Math.fround(b1.m_invMass * P1.x);
                            b1.m_sweep.c.y += Math.fround(b1.m_invMass * P1.y);
                            b1.m_sweep.a += Math.fround(b1.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, P1));
                            b2.m_sweep.c.x += Math.fround(b2.m_invMass * P2.x);
                            b2.m_sweep.c.y += Math.fround(b2.m_invMass * P2.y);
                            b2.m_sweep.a += Math.fround(b2.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r2, P2));
                            b1.synchronizeTransform();
                            b2.synchronizeTransform();
                        }
                        if (this.m_limitState1 === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                            r1.set$org_jbox2d_common_Vec2(b1.getMemberLocalCenter());
                            r1.subLocal(this.m_localAnchor1).negateLocal();
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b1.m_xf.R, r1, r1);
                            p1.set$org_jbox2d_common_Vec2(b1.m_sweep.c);
                            p1.addLocal$org_jbox2d_common_Vec2(r1);
                            this.m_u1.set$float$float(Math.fround(p1.x - s1.x), Math.fround(p1.y - s1.y));
                            var length1 = this.m_u1.length();
                            if (length1 > org.jbox2d.common.Settings.linearSlop_$LI$()) {
                                this.m_u1.mulLocal(Math.fround(1.0 / length1));
                            }
                            else {
                                this.m_u1.setZero();
                            }
                            var C = Math.fround(this.m_maxLength1 - length1);
                            linearError = org.jbox2d.common.MathUtils.max$float$float(linearError, -C);
                            C = org.jbox2d.common.MathUtils.clamp$float$float$float(Math.fround(C + org.jbox2d.common.Settings.linearSlop_$LI$()), -org.jbox2d.common.Settings.maxLinearCorrection_$LI$(), 0.0);
                            var impulse = Math.fround(-this.m_limitMass1 * C);
                            var oldLimitPositionImpulse = this.m_limitPositionImpulse1;
                            this.m_limitPositionImpulse1 = org.jbox2d.common.MathUtils.max$float$float(0.0, Math.fround(this.m_limitPositionImpulse1 + impulse));
                            impulse = Math.fround(this.m_limitPositionImpulse1 - oldLimitPositionImpulse);
                            P1.set$org_jbox2d_common_Vec2(this.m_u1);
                            P1.mulLocal(-impulse);
                            b1.m_sweep.c.x += Math.fround(b1.m_invMass * P1.x);
                            b1.m_sweep.c.y += Math.fround(b1.m_invMass * P1.y);
                            b1.m_sweep.a += Math.fround(b1.m_invI * org.jbox2d.common.Vec2.cross$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(r1, P1));
                            b1.synchronizeTransform();
                        }
                        if (this.m_limitState2 === org.jbox2d.dynamics.joints.LimitState.AT_UPPER_LIMIT) {
                            r2.set$org_jbox2d_common_Vec2(b2.getMemberLocalCenter());
                            r2.subLocal(this.m_localAnchor2).negateLocal();
                            org.jbox2d.common.Mat22.mulToOut$org_jbox2d_common_Mat22$org_jbox2d_common_Vec2$org_jbox2d_common_Vec2(b2.m_xf.R, r2, r2);
                            p2.set$org_jbox2d_co