/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.nonconvex;

import org.jbox2d.collision.shapes.PolygonDef;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.util.nonconvex.PolyNode;
import org.jbox2d.util.nonconvex.Triangle;

public class Polygon {
    static final float toiSlop = 0.04f;
    public static boolean B2_POLYGON_REPORT_ERRORS = true;
    static final float COLLAPSE_DIST_SQR = 1.4210855E-14f;
    static int maxPolygonVertices = 8;
    public int nVertices;
    public float[] x;
    public float[] y;
    boolean areaIsSet;
    float area;

    static boolean intersect(Vec2 a0, Vec2 a1, Vec2 b0, Vec2 b1, Vec2 intersectionPoint) {
        if (a0 == b0 || a0 == b1 || a1 == b0 || a1 == b1) {
            return false;
        }
        float x1 = a0.x;
        float y1 = a0.y;
        float x2 = a1.x;
        float y2 = a1.y;
        float x3 = b0.x;
        float y3 = b0.y;
        float x4 = b1.x;
        float y4 = b1.y;
        if (MathUtils.max(x1, x2) < MathUtils.min(x3, x4) || MathUtils.max(x3, x4) < MathUtils.min(x1, x2)) {
            return false;
        }
        if (MathUtils.max(y1, y2) < MathUtils.min(y3, y4) || MathUtils.max(y3, y4) < MathUtils.min(y1, y2)) {
            return false;
        }
        float ua = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
        float ub = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
        float denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (MathUtils.abs(denom) < 1.1920929E-7f) {
            return false;
        }
        ua /= denom;
        ub /= denom;
        if (0.0f < ua && ua < 1.0f && 0.0f < ub && ub < 1.0f) {
            intersectionPoint.x = x1 + ua * (x2 - x1);
            intersectionPoint.y = y1 + ua * (y2 - y1);
            return true;
        }
        return false;
    }

    boolean intersect(Vec2 a0, Vec2 a1, Vec2 b0, Vec2 b1) {
        Vec2 myVec = new Vec2(0.0f, 0.0f);
        return Polygon.intersect(a0, a1, b0, b1, myVec);
    }

    public Polygon(float[] _x, float[] _y) {
        this(_x, _y, _x.length);
    }

    public Polygon(float[] _x, float[] _y, int nVert) {
        this.nVertices = nVert;
        this.x = new float[this.nVertices];
        this.y = new float[this.nVertices];
        int i = 0;
        while (i < this.nVertices) {
            this.x[i] = _x[i];
            this.y[i] = _y[i];
            ++i;
        }
        this.areaIsSet = false;
    }

    public Polygon(Vec2[] v) {
        this(v, v.length);
    }

    public Polygon(Vec2[] v, int nVert) {
        this.nVertices = nVert;
        this.x = new float[this.nVertices];
        this.y = new float[this.nVertices];
        int i = 0;
        while (i < this.nVertices) {
            this.x[i] = v[i].x;
            this.y[i] = v[i].y;
            ++i;
        }
        this.areaIsSet = false;
    }

    public Polygon(Triangle t) {
        this.nVertices = 3;
        this.x = new float[this.nVertices];
        this.y = new float[this.nVertices];
        int i = 0;
        while (i < this.nVertices) {
            this.x[i] = t.x[i];
            this.y[i] = t.y[i];
            ++i;
        }
    }

    public Polygon() {
        this.x = null;
        this.y = null;
        this.nVertices = 0;
        this.areaIsSet = false;
    }

    float getArea() {
        this.area = 0.0f;
        this.area += this.x[this.nVertices - 1] * this.y[0] - this.x[0] * this.y[this.nVertices - 1];
        int i = 0;
        while (i < this.nVertices - 1) {
            this.area += this.x[i] * this.y[i + 1] - this.x[i + 1] * this.y[i];
            ++i;
        }
        this.area *= 0.5f;
        this.areaIsSet = true;
        return this.area;
    }

    boolean isCCW() {
        return this.getArea() > 0.0f;
    }

    void mergeParallelEdges(float tolerance) {
        if (this.nVertices <= 3) {
            return;
        }
        boolean[] mergeMe = new boolean[this.nVertices];
        int newNVertices = this.nVertices;
        int i = 0;
        while (i < this.nVertices) {
            int lower = i == 0 ? this.nVertices - 1 : i - 1;
            int middle = i;
            int upper = i == this.nVertices - 1 ? 0 : i + 1;
            float dx0 = this.x[middle] - this.x[lower];
            float dy0 = this.y[middle] - this.y[lower];
            float dx1 = this.x[upper] - this.x[middle];
            float dy1 = this.y[upper] - this.y[middle];
            float norm0 = (float)Math.sqrt(dx0 * dx0 + dy0 * dy0);
            float norm1 = (float)Math.sqrt(dx1 * dx1 + dy1 * dy1);
            if (!(norm0 > 0.0f && norm1 > 0.0f || newNVertices <= 3)) {
                mergeMe[i] = true;
                --newNVertices;
            }
            float cross = (dx0 /= norm0) * (dy1 /= norm1) - (dx1 /= norm1) * (dy0 /= norm0);
            float dot = dx0 * dx1 + dy0 * dy1;
            if (MathUtils.abs(cross) < tolerance && dot > 0.0f && newNVertices > 3) {
                mergeMe[i] = true;
                --newNVertices;
            } else {
                mergeMe[i] = false;
            }
            ++i;
        }
        if (newNVertices == this.nVertices || newNVertices == 0) {
            return;
        }
        float[] newx = new float[newNVertices];
        float[] newy = new float[newNVertices];
        int currIndex = 0;
        int i2 = 0;
        while (i2 < this.nVertices) {
            if (!mergeMe[i2] && newNVertices != 0 && currIndex != newNVertices) {
                assert (currIndex < newNVertices);
                newx[currIndex] = this.x[i2];
                newy[currIndex] = this.y[i2];
                ++currIndex;
            }
            ++i2;
        }
        this.x = newx;
        this.y = newy;
        this.nVertices = newNVertices;
    }

    public Vec2[] getVertexVecs() {
        Vec2[] out = new Vec2[this.nVertices];
        int i = 0;
        while (i < this.nVertices) {
            out[i] = new Vec2(this.x[i], this.y[i]);
            ++i;
        }
        return out;
    }

    public void set(Polygon p) {
        if (this.nVertices != p.nVertices) {
            this.nVertices = p.nVertices;
            this.x = new float[this.nVertices];
            this.y = new float[this.nVertices];
        }
        int i = 0;
        while (i < this.nVertices) {
            this.x[i] = p.x[i];
            this.y[i] = p.y[i];
            ++i;
        }
        this.areaIsSet = false;
    }

    public boolean isConvex() {
        boolean isPositive = false;
        int i = 0;
        while (i < this.nVertices) {
            boolean newIsP;
            int lower = i == 0 ? this.nVertices - 1 : i - 1;
            int middle = i;
            int upper = i == this.nVertices - 1 ? 0 : i + 1;
            float dx0 = this.x[middle] - this.x[lower];
            float dy0 = this.y[middle] - this.y[lower];
            float dx1 = this.x[upper] - this.x[middle];
            float dy1 = this.y[upper] - this.y[middle];
            float cross = dx0 * dy1 - dx1 * dy0;
            boolean bl = newIsP = cross >= 0.0f;
            if (i == 0) {
                isPositive = newIsP;
            } else if (isPositive != newIsP) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Vec2 polyCentroid(Vec2[] vs, int count) {
        Vec2 c = new Vec2(0.0f, 0.0f);
        float area = 0.0f;
        float inv3 = 0.33333334f;
        Vec2 pRef = new Vec2(0.0f, 0.0f);
        int i = 0;
        while (i < count) {
            Vec2 p1 = pRef;
            Vec2 p2 = vs[i];
            Vec2 p3 = i + 1 < count ? vs[i + 1] : vs[0];
            Vec2 e1 = p2.sub(p1);
            Vec2 e2 = p3.sub(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            c.x += triangleArea * 0.33333334f * (p1.x + p2.x + p3.x);
            c.y += triangleArea * 0.33333334f * (p1.y + p2.y + p3.y);
            ++i;
        }
        c.x *= 1.0f / area;
        c.y *= 1.0f / area;
        return c;
    }

    public boolean isUsable(boolean printErrors) {
        int error = -1;
        boolean noError = true;
        if (this.nVertices < 3 || this.nVertices > maxPolygonVertices) {
            noError = false;
            error = 0;
        }
        if (!this.isConvex()) {
            noError = false;
            error = 1;
        }
        if (!this.isSimple()) {
            noError = false;
            error = 2;
        }
        if (this.getArea() < 1.1920929E-7f) {
            noError = false;
            error = 3;
        }
        Vec2[] normals = new Vec2[this.nVertices];
        Vec2[] vertices = new Vec2[this.nVertices];
        int i = 0;
        while (i < this.nVertices) {
            vertices[i] = new Vec2(this.x[i], this.y[i]);
            int i1 = i;
            int i2 = i + 1 < this.nVertices ? i + 1 : 0;
            Vec2 edge = new Vec2(this.x[i2] - this.x[i1], this.y[i2] - this.y[i1]);
            normals[i] = Vec2.cross(edge, 1.0f);
            normals[i].normalize();
            ++i;
        }
        i = 0;
        while (i < this.nVertices) {
            int iminus = i == 0 ? this.nVertices - 1 : i - 1;
            float cross = Vec2.cross(normals[iminus], normals[i]);
            float angle = (float)Math.asin(cross = MathUtils.clamp(cross, -1.0f, 1.0f));
            if (angle <= 0.03490659f) {
                noError = false;
                error = 4;
                break;
            }
            int j = 0;
            while (j < this.nVertices) {
                float s;
                if (j != i && j != (i + 1) % this.nVertices && (s = Vec2.dot(normals[i], vertices[j].sub(vertices[i]))) >= -0.005f) {
                    noError = false;
                    error = 5;
                }
                ++j;
            }
            Vec2 centroid = Polygon.polyCentroid(vertices, this.nVertices);
            Vec2 n1 = normals[iminus];
            Vec2 n2 = normals[i];
            Vec2 v = vertices[i].sub(centroid);
            Vec2 d = new Vec2();
            d.x = Vec2.dot(n1, v) - 0.04f;
            d.y = Vec2.dot(n2, v) - 0.04f;
            if (d.x < 0.0f || d.y < 0.0f) {
                noError = false;
                error = 6;
            }
            ++i;
        }
        if (!noError && printErrors) {
            System.out.println("Found invalid polygon, ");
            switch (error) {
                case 0: {
                    System.out.println("must have between 3 and 8 vertices.");
                    break;
                }
                case 1: {
                    System.out.println("must be convex.\n");
                    break;
                }
                case 2: {
                    System.out.println("must be simple (cannot intersect itself).\n");
                    break;
                }
                case 3: {
                    System.out.println("area is too small.\n");
                    break;
                }
                case 4: {
                    System.out.println("sides are too close to parallel.\n");
                    break;
                }
                case 5: {
                    System.out.println("polygon is too thin.\n");
                    break;
                }
                case 6: {
                    System.out.println("core shape generation would move edge past centroid (too thin).\n");
                    break;
                }
                default: {
                    System.out.println("don't know why.\n");
                    assert (false);
                    break;
                }
            }
        }
        return noError;
    }

    public boolean isUsable() {
        return this.isUsable(B2_POLYGON_REPORT_ERRORS);
    }

    public boolean isSimple() {
        int i = 0;
        while (i < this.nVertices) {
            int iplus = i + 1 > this.nVertices - 1 ? 0 : i + 1;
            Vec2 a1 = new Vec2(this.x[i], this.y[i]);
            Vec2 a2 = new Vec2(this.x[iplus], this.y[iplus]);
            int j = i + 1;
            while (j < this.nVertices) {
                Vec2 b1 = new Vec2(this.x[j], this.y[j]);
                int jplus = j + 1 > this.nVertices - 1 ? 0 : j + 1;
                Vec2 b2 = new Vec2(this.x[jplus], this.y[jplus]);
                if (this.intersect(a1, a2, b1, b2)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Polygon add(Triangle t) {
        int firstP = -1;
        int firstT = -1;
        int secondP = -1;
        int secondT = -1;
        int i = 0;
        while (i < this.nVertices) {
            if (t.x[0] == this.x[i] && t.y[0] == this.y[i]) {
                if (firstP == -1) {
                    firstP = i;
                    firstT = 0;
                } else {
                    secondP = i;
                    secondT = 0;
                }
            } else if (t.x[1] == this.x[i] && t.y[1] == this.y[i]) {
                if (firstP == -1) {
                    firstP = i;
                    firstT = 1;
                } else {
                    secondP = i;
                    secondT = 1;
                }
            } else if (t.x[2] == this.x[i] && t.y[2] == this.y[i]) {
                if (firstP == -1) {
                    firstP = i;
                    firstT = 2;
                } else {
                    secondP = i;
                    secondT = 2;
                }
            }
            ++i;
        }
        if (firstP == 0 && secondP == this.nVertices - 1) {
            firstP = this.nVertices - 1;
            secondP = 0;
        }
        if (secondP == -1) {
            return null;
        }
        int tipT = 0;
        if (tipT == firstT || tipT == secondT) {
            tipT = 1;
        }
        if (tipT == firstT || tipT == secondT) {
            tipT = 2;
        }
        float[] newx = new float[this.nVertices + 1];
        float[] newy = new float[this.nVertices + 1];
        int currOut = 0;
        int i2 = 0;
        while (i2 < this.nVertices) {
            newx[currOut] = this.x[i2];
            newy[currOut] = this.y[i2];
            if (i2 == firstP) {
                newx[++currOut] = t.x[tipT];
                newy[currOut] = t.y[tipT];
            }
            ++currOut;
            ++i2;
        }
        Polygon result = new Polygon(newx, newy, this.nVertices + 1);
        return result;
    }

    public void addTo(PolygonDef pd) {
        if (this.nVertices < 3) {
            return;
        }
        Vec2[] vecs = this.getVertexVecs();
        assert (this.nVertices <= 8);
        int offset = 0;
        int i = 0;
        while (i < this.nVertices) {
            if (vecs[i].x == vecs[Polygon.remainder((int)(i + 1), (int)this.nVertices)].x && vecs[i].y == vecs[Polygon.remainder((int)(i + 1), (int)this.nVertices)].y) {
                ++offset;
            } else {
                pd.vertices.add(vecs[i]);
            }
            ++i;
        }
    }

    private static boolean resolvePinchPoint(Polygon pin, Polygon poutA, Polygon poutB) {
        if (pin.nVertices < 3) {
            return false;
        }
        float tol = 0.001f;
        boolean hasPinchPoint = false;
        int pinchIndexA = -1;
        int pinchIndexB = -1;
        int i = 0;
        while (i < pin.nVertices) {
            int j = i + 1;
            while (j < pin.nVertices) {
                if (MathUtils.abs(pin.x[i] - pin.x[j]) < tol && MathUtils.abs(pin.y[i] - pin.y[j]) < tol && j != i + 1) {
                    pinchIndexA = i;
                    pinchIndexB = j;
                    hasPinchPoint = true;
                    break;
                }
                ++j;
            }
            if (hasPinchPoint) break;
            ++i;
        }
        if (hasPinchPoint) {
            int sizeA = pinchIndexB - pinchIndexA;
            if (sizeA == pin.nVertices) {
                return false;
            }
            float[] xA = new float[sizeA];
            float[] yA = new float[sizeA];
            int i2 = 0;
            while (i2 < sizeA) {
                int ind = Polygon.remainder(pinchIndexA + i2, pin.nVertices);
                xA[i2] = pin.x[ind];
                yA[i2] = pin.y[ind];
                ++i2;
            }
            Polygon tempA = new Polygon(xA, yA, sizeA);
            poutA.set(tempA);
            int sizeB = pin.nVertices - sizeA;
            float[] xB = new float[sizeB];
            float[] yB = new float[sizeB];
            int i3 = 0;
            while (i3 < sizeB) {
                int ind = Polygon.remainder(pinchIndexB + i3, pin.nVertices);
                xB[i3] = pin.x[ind];
                yB[i3] = pin.y[ind];
                ++i3;
            }
            Polygon tempB = new Polygon(xB, yB, sizeB);
            poutB.set(tempB);
        }
        return hasPinchPoint;
    }

    public static int triangulatePolygon(float[] xv, float[] yv, int vNum, Triangle[] results) {
        Triangle toAdd;
        if (vNum < 3) {
            return 0;
        }
        Polygon pin = new Polygon(xv, yv, vNum);
        Polygon pA = new Polygon();
        Polygon pB = new Polygon();
        if (Polygon.resolvePinchPoint(pin, pA, pB)) {
            Triangle[] mergeA = new Triangle[pA.nVertices];
            Triangle[] mergeB = new Triangle[pB.nVertices];
            int i = 0;
            while (i < pA.nVertices) {
                mergeA[i] = new Triangle();
                ++i;
            }
            i = 0;
            while (i < pB.nVertices) {
                mergeB[i] = new Triangle();
                ++i;
            }
            int nA = Polygon.triangulatePolygon(pA.x, pA.y, pA.nVertices, mergeA);
            int nB = Polygon.triangulatePolygon(pB.x, pB.y, pB.nVertices, mergeB);
            if (nA == -1 || nB == -1) {
                return -1;
            }
            int i2 = 0;
            while (i2 < nA) {
                results[i2].set(mergeA[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < nB) {
                results[nA + i2].set(mergeB[i2]);
                ++i2;
            }
            return nA + nB;
        }
        Triangle[] buffer = new Triangle[vNum - 2];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = new Triangle();
            ++i;
        }
        int bufferSize = 0;
        float[] xrem = new float[vNum];
        float[] yrem = new float[vNum];
        int i3 = 0;
        while (i3 < vNum) {
            xrem[i3] = xv[i3];
            yrem[i3] = yv[i3];
            ++i3;
        }
        int xremLength = vNum;
        while (vNum > 3) {
            Triangle toAdd2;
            int earIndex = -1;
            float earMaxMinCross = -1000.0f;
            int i4 = 0;
            while (i4 < vNum) {
                if (Polygon.isEar(i4, xrem, yrem, vNum)) {
                    int lower = Polygon.remainder(i4 - 1, vNum);
                    int upper = Polygon.remainder(i4 + 1, vNum);
                    Vec2 d1 = new Vec2(xrem[upper] - xrem[i4], yrem[upper] - yrem[i4]);
                    Vec2 d2 = new Vec2(xrem[i4] - xrem[lower], yrem[i4] - yrem[lower]);
                    Vec2 d3 = new Vec2(xrem[lower] - xrem[upper], yrem[lower] - yrem[upper]);
                    d1.normalize();
                    d2.normalize();
                    d3.normalize();
                    float cross12 = MathUtils.abs(Vec2.cross(d1, d2));
                    float cross23 = MathUtils.abs(Vec2.cross(d2, d3));
                    float cross31 = MathUtils.abs(Vec2.cross(d3, d1));
                    float minCross = MathUtils.min(cross12, MathUtils.min(cross23, cross31));
                    if (minCross > earMaxMinCross) {
                        earIndex = i4;
                        earMaxMinCross = minCross;
                    }
                }
                ++i4;
            }
            if (earIndex == -1) {
                if (B2_POLYGON_REPORT_ERRORS) {
                    Polygon dump = new Polygon(xrem, yrem, vNum);
                    System.out.println("Couldn't find an ear, dumping remaining poly:\n");
                    dump.printFormatted();
                    System.out.println("Please submit this dump to ewjordan at Box2d forums\n");
                }
                i = 0;
                while (i < bufferSize) {
                    results[i].set(buffer[i]);
                    ++i;
                }
                if (bufferSize > 0) {
                    return bufferSize;
                }
                return -1;
            }
            float[] newx = new float[--vNum];
            float[] newy = new float[vNum];
            int currDest = 0;
            int i5 = 0;
            while (i5 < vNum) {
                if (currDest == earIndex) {
                    ++currDest;
                }
                newx[i5] = xrem[currDest];
                newy[i5] = yrem[currDest];
                ++currDest;
                ++i5;
            }
            int under = earIndex == 0 ? vNum : earIndex - 1;
            int over = earIndex == vNum ? 0 : earIndex + 1;
            buffer[bufferSize] = toAdd2 = new Triangle(xrem[earIndex], yrem[earIndex], xrem[over], yrem[over], xrem[under], yrem[under]);
            ++bufferSize;
            xrem = newx;
            yrem = newy;
        }
        buffer[bufferSize] = toAdd = new Triangle(xrem[1], yrem[1], xrem[2], yrem[2], xrem[0], yrem[0]);
        assert (++bufferSize == xremLength - 2);
        int i6 = 0;
        while (i6 < bufferSize) {
            results[i6].set(buffer[i6]);
            ++i6;
        }
        return bufferSize;
    }

    /*
     * Unable to fully structure code
     */
    public static int polygonizeTriangles(Triangle[] triangulated, int triangulatedLength, Polygon[] polys, int polysLength) {
        polyIndex = 0;
        if (triangulatedLength <= 0) {
            return 0;
        }
        covered = new int[triangulatedLength];
        i = 0;
        while (i < triangulatedLength) {
            covered[i] = 0;
            if (triangulated[i].x[0] == triangulated[i].x[1] && triangulated[i].y[0] == triangulated[i].y[1] || triangulated[i].x[1] == triangulated[i].x[2] && triangulated[i].y[1] == triangulated[i].y[2] || triangulated[i].x[0] == triangulated[i].x[2] && triangulated[i].y[0] == triangulated[i].y[2]) {
                covered[i] = 1;
            }
            ++i;
        }
        notDone = true;
        while (notDone) {
            currTri = -1;
            i = 0;
            while (i < triangulatedLength) {
                if (covered[i] == 0) {
                    currTri = i;
                    break;
                }
                ++i;
            }
            if (currTri == -1) {
                notDone = false;
                continue;
            }
            poly = new Polygon(triangulated[currTri]);
            covered[currTri] = 1;
            index = 0;
            i = 0;
            ** GOTO lbl45
            {
                index -= triangulatedLength;
                do {
                    if (index >= triangulatedLength) continue block3;
                    if (covered[index] == 0 && (newP = poly.add(triangulated[index])) != null) {
                        if (newP.nVertices > Polygon.maxPolygonVertices) {
                            newP = null;
                        } else if (newP.isConvex()) {
                            poly.set(newP);
                            newP = null;
                            covered[index] = 1;
                        } else {
                            newP = null;
                        }
                    }
                    ++i;
                    ++index;
lbl45:
                    // 2 sources

                } while (i < 2 * triangulatedLength);
            }
            if (polyIndex < polysLength) {
                poly.mergeParallelEdges(0.03490659f);
                if (poly.nVertices >= 3) {
                    polys[polyIndex].set(poly);
                }
            }
            if (poly.nVertices < 3) continue;
            ++polyIndex;
        }
        return polyIndex;
    }

    private static boolean isEar(int i, float[] xv, float[] yv, int xvLength) {
        float dy1 = 0.0f;
        float dx1 = 0.0f;
        float dy0 = 0.0f;
        float dx0 = 0.0f;
        if (i >= xvLength || i < 0 || xvLength < 3) {
            return false;
        }
        int upper = i + 1;
        int lower = i - 1;
        if (i == 0) {
            dx0 = xv[0] - xv[xvLength - 1];
            dy0 = yv[0] - yv[xvLength - 1];
            dx1 = xv[1] - xv[0];
            dy1 = yv[1] - yv[0];
            lower = xvLength - 1;
        } else if (i == xvLength - 1) {
            dx0 = xv[i] - xv[i - 1];
            dy0 = yv[i] - yv[i - 1];
            dx1 = xv[0] - xv[i];
            dy1 = yv[0] - yv[i];
            upper = 0;
        } else {
            dx0 = xv[i] - xv[i - 1];
            dy0 = yv[i] - yv[i - 1];
            dx1 = xv[i + 1] - xv[i];
            dy1 = yv[i + 1] - yv[i];
        }
        float cross = dx0 * dy1 - dx1 * dy0;
        if (cross > 0.0f) {
            return false;
        }
        Triangle myTri = new Triangle(xv[i], yv[i], xv[upper], yv[upper], xv[lower], yv[lower]);
        int j = 0;
        while (j < xvLength) {
            if (j != i && j != lower && j != upper && myTri.containsPoint(xv[j], yv[j])) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static void reversePolygon(Polygon p) {
        Polygon.reversePolygon(p.x, p.y, p.nVertices);
        if (p.areaIsSet) {
            p.area *= -1.0f;
        }
    }

    public static void reversePolygon(float[] x, float[] y, int n) {
        if (n == 1) {
            return;
        }
        int low = 0;
        int high = n - 1;
        while (low < high) {
            float buffer = x[low];
            x[low] = x[high];
            x[high] = buffer;
            buffer = y[low];
            y[low] = y[high];
            y[high] = buffer;
            ++low;
            --high;
        }
    }

    public static int decomposeConvex(Polygon p, Polygon[] results, int maxPolys) {
        int nTri;
        if (p.nVertices < 3) {
            return 0;
        }
        Triangle[] triangulated = new Triangle[p.nVertices - 2];
        int i = 0;
        while (i < triangulated.length) {
            triangulated[i] = new Triangle();
            ++i;
        }
        if (p.isCCW()) {
            Polygon tempP = new Polygon();
            tempP.set(p);
            Polygon.reversePolygon(tempP.x, tempP.y, tempP.nVertices);
            nTri = Polygon.triangulatePolygon(tempP.x, tempP.y, tempP.nVertices, triangulated);
        } else {
            nTri = Polygon.triangulatePolygon(p.x, p.y, p.nVertices, triangulated);
        }
        if (nTri < 1) {
            return -1;
        }
        int nPolys = Polygon.polygonizeTriangles(triangulated, nTri, results, maxPolys);
        return nPolys;
    }

    public static void decomposeConvexAndAddTo(Polygon p, Body bd, PolygonDef prototype) {
        if (p.nVertices < 3) {
            return;
        }
        Polygon[] decomposed = new Polygon[p.nVertices - 2];
        int i = 0;
        while (i < decomposed.length) {
            decomposed[i] = new Polygon();
            ++i;
        }
        int nPolys = Polygon.decomposeConvex(p, decomposed, p.nVertices - 2);
        PolygonDef[] pdarray = new PolygonDef[2 * p.nVertices];
        int i2 = 0;
        while (i2 < pdarray.length) {
            pdarray[i2] = new PolygonDef();
            ++i2;
        }
        int extra = 0;
        int i3 = 0;
        while (i3 < nPolys) {
            PolygonDef toAdd = pdarray[i3 + extra];
            toAdd.set(prototype);
            Polygon curr = decomposed[i3];
            if (curr.nVertices == 3) {
                int j = 0;
                while (j < 3) {
                    int lower = j == 0 ? curr.nVertices - 1 : j - 1;
                    int middle = j;
                    int upper = j == curr.nVertices - 1 ? 0 : j + 1;
                    float dx0 = curr.x[middle] - curr.x[lower];
                    float dy0 = curr.y[middle] - curr.y[lower];
                    float dx1 = curr.x[upper] - curr.x[middle];
                    float dy1 = curr.y[upper] - curr.y[middle];
                    float norm0 = (float)Math.sqrt(dx0 * dx0 + dy0 * dy0);
                    float norm1 = (float)Math.sqrt(dx1 * dx1 + dy1 * dy1);
                    if (norm0 > 0.0f && norm1 > 0.0f) {
                        float dy2;
                        float dx2;
                        float norm2;
                        float cross = (dx0 /= norm0) * (dy1 /= norm1) - (dx1 /= norm1) * (dy0 /= norm0);
                        float dot = dx0 * dx1 + dy0 * dy1;
                        if (MathUtils.abs(cross) < 0.03490659f && dot > 0.0f && (norm2 = (float)Math.sqrt((dx2 = curr.x[lower] - curr.x[upper]) * dx2 + (dy2 = curr.y[lower] - curr.y[upper]) * dy2)) != 0.0f) {
                            float thisArea = curr.getArea();
                            float thisHeight = 2.0f * thisArea / norm2;
                            float buffer2 = dx2 /= norm2;
                            dx2 = dy2 /= norm2;
                            dy2 = -buffer2;
                            float[] newX1 = new float[]{curr.x[middle] + dx2 * thisHeight, curr.x[lower], curr.x[middle]};
                            float[] newY1 = new float[]{curr.y[middle] + dy2 * thisHeight, curr.y[lower], curr.y[middle]};
                            float[] newX2 = new float[]{newX1[0], curr.x[middle], curr.x[upper]};
                            float[] newY2 = new float[]{newY1[0], curr.y[middle], curr.y[upper]};
                            Polygon p1 = new Polygon(newX1, newY1, 3);
                            Polygon p2 = new Polygon(newX2, newY2, 3);
                            if (p1.isUsable()) {
                                p1.addTo(toAdd);
                                bd.createShape(toAdd);
                                ++extra;
                            } else if (B2_POLYGON_REPORT_ERRORS) {
                                System.err.println("Didn't add unusable polygon.  Dumping vertices:\n");
                                p1.print();
                            }
                            if (p2.isUsable()) {
                                p2.addTo(pdarray[i3 + extra]);
                                bd.createShape(pdarray[i3 + extra]);
                            } else if (B2_POLYGON_REPORT_ERRORS) {
                                System.err.println("Didn't add unusable polygon.  Dumping vertices:\n");
                                p2.print();
                            }
                        }
                    }
                    ++j;
                }
            }
            if (decomposed[i3].isUsable()) {
                decomposed[i3].addTo(toAdd);
                bd.createShape(toAdd);
            } else if (B2_POLYGON_REPORT_ERRORS) {
                System.out.println("Didn't add unusable polygon.  Dumping vertices:\n");
                decomposed[i3].print();
            }
            ++i3;
        }
    }

    public static Polygon convexHull(Vec2[] v, int nVert) {
        float[] cloudX = new float[nVert];
        float[] cloudY = new float[nVert];
        int i = 0;
        while (i < nVert) {
            cloudX[i] = v[i].x;
            cloudY[i] = v[i].y;
            ++i;
        }
        Polygon result = Polygon.convexHull(cloudX, cloudY, nVert);
        return result;
    }

    public static Polygon convexHull(float[] cloudX, float[] cloudY, int nVert) {
        assert (nVert > 2);
        int[] edgeList = new int[nVert];
        int numEdges = 0;
        float minY = Float.MAX_VALUE;
        int minYIndex = nVert;
        int i = 0;
        while (i < nVert) {
            if (cloudY[i] < minY) {
                minY = cloudY[i];
                minYIndex = i;
            }
            ++i;
        }
        int startIndex = minYIndex;
        int winIndex = -1;
        float dx = -1.0f;
        float dy = 0.0f;
        while (winIndex != minYIndex) {
            float newdx = 0.0f;
            float newdy = 0.0f;
            float maxDot = -2.0f;
            int i2 = 0;
            while (i2 < nVert) {
                float nrm;
                float newDot;
                if (i2 != startIndex && (newDot = (newdx /= (nrm = (nrm = (float)Math.sqrt((newdx = cloudX[i2] - cloudX[startIndex]) * newdx + (newdy = cloudY[i2] - cloudY[startIndex]) * newdy)) == 0.0f ? 1.0f : nrm)) * dx + (newdy /= nrm) * dy) > maxDot) {
                    maxDot = newDot;
                    winIndex = i2;
                }
                ++i2;
            }
            edgeList[numEdges++] = winIndex;
            dx = cloudX[winIndex] - cloudX[startIndex];
            dy = cloudY[winIndex] - cloudY[startIndex];
            float nrm = (float)Math.sqrt(dx * dx + dy * dy);
            nrm = nrm == 0.0f ? 1.0f : nrm;
            dx /= nrm;
            dy /= nrm;
            startIndex = winIndex;
        }
        float[] xres = new float[numEdges];
        float[] yres = new float[numEdges];
        int i3 = 0;
        while (i3 < numEdges) {
            xres[i3] = cloudX[edgeList[i3]];
            yres[i3] = cloudY[edgeList[i3]];
            ++i3;
        }
        Polygon returnVal = new Polygon(xres, yres, numEdges);
        returnVal.mergeParallelEdges(0.03490659f);
        return returnVal;
    }

    static boolean isRighter(float sinA, float cosA, float sinB, float cosB) {
        if (sinA < 0.0f) {
            return sinB > 0.0f || cosA <= cosB;
        }
        return !(sinB < 0.0f) && !(cosA <= cosB);
    }

    private static final int remainder(int x, int modulus) {
        int rem = x % modulus;
        while (rem < 0) {
            rem += modulus;
        }
        return rem;
    }

    public static Polygon traceEdge(Polygon p) {
        PolyNode currentNode;
        PolyNode[] nodes = new PolyNode[p.nVertices * p.nVertices];
        int nNodes = 0;
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = new PolyNode();
            ++i;
        }
        i = 0;
        while (i < p.nVertices) {
            Vec2 pos = new Vec2(p.x[i], p.y[i]);
            nodes[i].position = pos.clone();
            ++nNodes;
            int iplus = i == p.nVertices - 1 ? 0 : i + 1;
            int iminus = i == 0 ? p.nVertices - 1 : i - 1;
            nodes[i].addConnection(nodes[iplus]);
            nodes[i].addConnection(nodes[iminus]);
            ++i;
        }
        boolean dirty = true;
        int counter = 0;
        while (dirty) {
            dirty = false;
            int i2 = 0;
            while (i2 < nNodes) {
                int j = 0;
                while (j < nodes[i2].nConnected) {
                    int k = 0;
                    while (k < nNodes) {
                        if (k != i2 && nodes[k] != nodes[i2].connected[j]) {
                            int l = 0;
                            while (l < nodes[k].nConnected) {
                                if (nodes[k].connected[l] != nodes[i2].connected[j] && nodes[k].connected[l] != nodes[i2]) {
                                    Vec2 intersectPt = new Vec2();
                                    boolean crosses = Polygon.intersect(nodes[i2].position, nodes[i2].connected[j].position, nodes[k].position, nodes[k].connected[l].position, intersectPt);
                                    if (crosses) {
                                        dirty = true;
                                        PolyNode connj = nodes[i2].connected[j];
                                        PolyNode connl = nodes[k].connected[l];
                                        nodes[i2].connected[j].removeConnection(nodes[i2]);
                                        nodes[i2].removeConnection(connj);
                                        nodes[k].connected[l].removeConnection(nodes[k]);
                                        nodes[k].removeConnection(connl);
                                        nodes[nNodes] = new PolyNode(intersectPt);
                                        nodes[nNodes].addConnection(nodes[i2]);
                                        nodes[i2].addConnection(nodes[nNodes]);
                                        nodes[nNodes].addConnection(nodes[k]);
                                        nodes[k].addConnection(nodes[nNodes]);
                                        nodes[nNodes].addConnection(connj);
                                        connj.addConnection(nodes[nNodes]);
                                        nodes[nNodes].addConnection(connl);
                                        connl.addConnection(nodes[nNodes]);
                                        ++nNodes;
                                        break;
                                    }
                                    if (dirty) break;
                                }
                                ++l;
                            }
                            if (dirty) break;
                        }
                        ++k;
                    }
                    if (dirty) break;
                    ++j;
                }
                if (dirty) break;
                ++i2;
            }
            ++counter;
        }
        boolean foundDupe = true;
        int nActive = nNodes;
        while (foundDupe) {
            foundDupe = false;
            int i3 = 0;
            while (i3 < nNodes) {
                if (nodes[i3].nConnected != 0) {
                    int j = i3 + 1;
                    while (j < nNodes) {
                        Vec2 diff;
                        if (nodes[j].nConnected != 0 && (diff = nodes[i3].position.sub(nodes[j].position)).lengthSquared() <= 1.4210855E-14f) {
                            if (nActive <= 3) {
                                return new Polygon();
                            }
                            --nActive;
                            foundDupe = true;
                            PolyNode inode = nodes[i3];
                            PolyNode jnode = nodes[j];
                            int njConn = jnode.nConnected;
                            int k = 0;
                            while (k < njConn) {
                                PolyNode knode = jnode.connected[k];
                                assert (knode != jnode);
                                if (knode != inode) {
                                    inode.addConnection(knode);
                                    knode.addConnection(inode);
                                }
                                knode.removeConnection(jnode);
                                ++k;
                            }
                            jnode.nConnected = 0;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
        }
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        int minYIndex = -1;
        int i4 = 0;
        while (i4 < nNodes) {
            if (nodes[i4].position.y < minY && nodes[i4].nConnected > 1) {
                minY = nodes[i4].position.y;
                minYIndex = i4;
                maxX = nodes[i4].position.x;
            } else if (nodes[i4].position.y == minY && nodes[i4].position.x > maxX && nodes[i4].nConnected > 1) {
                minYIndex = i4;
                maxX = nodes[i4].position.x;
            }
            ++i4;
        }
        Vec2 origDir = new Vec2(1.0f, 0.0f);
        Vec2[] resultVecs = new Vec2[4 * nNodes];
        int nResultVecs = 0;
        PolyNode startNode = currentNode = nodes[minYIndex];
        assert (currentNode.nConnected > 0);
        PolyNode nextNode = currentNode.getRightestConnection(origDir);
        if (nextNode == null) {
            startNode = nextNode;
        }
        resultVecs[0] = startNode.position;
        ++nResultVecs;
        while (nextNode != startNode) {
            if (nResultVecs > 4 * nNodes) assert (false);
            resultVecs[nResultVecs++] = nextNode.position;
            currentNode = nextNode;
            PolyNode oldNode = currentNode;
            if ((nextNode = currentNode.getRightestConnection(oldNode)) == null) break;
        }
        float[] xres = new float[nResultVecs];
        float[] yres = new float[nResultVecs];
        int i5 = 0;
        while (i5 < nResultVecs) {
            xres[i5] = resultVecs[i5].x;
            yres[i5] = resultVecs[i5].y;
            ++i5;
        }
        Polygon retval = new Polygon(xres, yres, nResultVecs);
        return retval;
    }

    public void print() {
        this.printFormatted();
    }

    void printFormatted() {
        System.out.printf("float xv[] = {", new Object[0]);
        int i = 0;
        while (i < this.nVertices) {
            System.out.printf("%ff,", Float.valueOf(this.x[i]));
            ++i;
        }
        System.out.printf("};\nfloat yv[] = {", new Object[0]);
        i = 0;
        while (i < this.nVertices) {
            System.out.printf("%ff,", Float.valueOf(this.y[i]));
            ++i;
        }
        System.out.printf("};\n", new Object[0]);
    }
}

