/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.blob;

import java.util.ArrayList;
import org.jbox2d.util.blob.BlobPoint;

public class BlobStructure {
    ArrayList<BlobPoint> points = new ArrayList();
    ArrayList<IntIntFloatFloat> connections = new ArrayList();
    ArrayList<IntIntFloatFloat> connectionsR = new ArrayList();
    ArrayList<IntIntFloatFloat> connectionsDR = new ArrayList();
    ArrayList<IntIntFloatFloat> connectionsD = new ArrayList();
    ArrayList<IntIntFloatFloat> connectionsUR = new ArrayList();
    float currentFrequency = 10.0f;
    float currentDamping = 0.9f;

    private void updateSprings() {
        for (IntIntFloatFloat iiff : this.connections) {
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (IntIntFloatFloat iiff : this.connectionsR) {
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (IntIntFloatFloat iiff : this.connectionsDR) {
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (IntIntFloatFloat iiff : this.connectionsD) {
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (IntIntFloatFloat iiff : this.connectionsUR) {
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
    }

    public void setSpringFrequency(float freq) {
        this.currentFrequency = freq;
        this.updateSprings();
    }

    public float getSpringFrequency() {
        return this.currentFrequency;
    }

    public void setSpringDamping(float damp) {
        this.currentDamping = damp;
        this.updateSprings();
    }

    public float getSpringDamping() {
        return this.currentDamping;
    }

    public int addPoint(BlobPoint p) {
        if (p.position.x < 0.0f || p.position.x > 1.0f || p.position.y < 0.0f || p.position.y > 1.0f) {
            throw new RuntimeException("Points must be within (0,0)->(1,1) in a BlobStructure.");
        }
        this.points.add(p);
        return this.points.indexOf(p);
    }

    public void addConnection(int a, int b) {
        this.connections.add(new IntIntFloatFloat(a, b, this.currentFrequency, this.currentDamping));
    }

    public void addConnection(int a, int b, Region r) {
        switch (r) {
            case CENTER: {
                this.addConnection(a, b);
                break;
            }
            case RIGHT: {
                this.connectionsR.add(new IntIntFloatFloat(a, b, this.currentFrequency, this.currentDamping));
                break;
            }
            case DOWN_RIGHT: {
                this.connectionsDR.add(new IntIntFloatFloat(a, b, this.currentFrequency, this.currentDamping));
                break;
            }
            case DOWN: {
                this.connectionsD.add(new IntIntFloatFloat(a, b, this.currentFrequency, this.currentDamping));
                break;
            }
            case UP_RIGHT: {
                this.connectionsUR.add(new IntIntFloatFloat(a, b, this.currentFrequency, this.currentDamping));
            }
        }
    }

    class IntIntFloatFloat {
        public int a;
        public int b;
        public float c;
        public float d;

        public IntIntFloatFloat(int _a, int _b, float _c, float _d) {
            this.a = _a;
            this.b = _b;
            this.c = _c;
            this.d = _d;
        }
    }

    static enum Region {
        DOWN,
        RIGHT,
        DOWN_RIGHT,
        UP_RIGHT,
        CENTER;

    }
}

