/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.blob;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.CircleDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.util.blob.BlobContainer;
import org.jbox2d.util.blob.BlobStructure;

public class BlobMaker {
    public static float pointRadius = 3.0f;
    public static float pointDensity = 1.0f;
    public static float pointFriction = 0.5f;

    public static void createBlob(BlobStructure s, BlobContainer c, World w) {
        BlobMaker.createBlob(s, c, w, 1.0f, 1.0f);
    }

    public static void createBlob(BlobStructure s, BlobContainer c, World w, float scaleX, float scaleY) {
        BlobMaker.createBlob(s, c, w, scaleX, scaleY, 0.0f, 0.0f);
    }

    public static void createBlob(BlobStructure s, BlobContainer c, World w, float scaleX, float scaleY, float transX, float transY) {
        int i;
        AABB aabb = c.getAABB();
        while (transX > 0.0f) {
            transX -= scaleX;
        }
        while (transY > 0.0f) {
            transY -= scaleY;
        }
        float xMin = aabb.lowerBound.x + transX;
        float yMin = aabb.lowerBound.y + transY;
        int nWidth = (int)Math.ceil((aabb.upperBound.x - xMin) / scaleX);
        int nHeight = (int)Math.ceil((aabb.upperBound.y - yMin) / scaleY);
        int nPerCell = s.points.size();
        int nPoints = nPerCell * (nWidth += 3) * (nHeight += 3);
        System.out.println(String.valueOf(nWidth) + " " + nHeight);
        Body[] bodies = new Body[nPoints];
        CircleDef cd = new CircleDef();
        cd.radius = pointRadius;
        cd.density = pointDensity;
        cd.friction = pointFriction;
        int index = 0;
        int j = 0;
        while (j < nHeight) {
            float yStart = yMin + transY + (float)j * scaleY;
            i = 0;
            while (i < nWidth) {
                float xStart = xMin + transX + (float)i * scaleX;
                int k = 0;
                while (k < nPerCell) {
                    Vec2 position = new Vec2(s.points.get((int)k).position.x + xStart, s.points.get((int)k).position.y + yStart);
                    if (!c.containsPoint(position)) {
                        bodies[index++] = null;
                    } else {
                        BodyDef bd = new BodyDef();
                        bd.position = position;
                        bd.fixedRotation = false;
                        bd.angularDamping = 0.2f;
                        bodies[index] = w.createBody(bd);
                        bodies[index].createShape(cd);
                        bodies[index].setMassFromShapes();
                        ++index;
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < nHeight) {
            int rowStartIndex = j * nWidth * nPerCell;
            i = 0;
            while (i < nWidth) {
                float damp;
                float freq;
                int b;
                int a;
                BlobStructure.IntIntFloatFloat iiff;
                int boxStartIndex = rowStartIndex + i * nPerCell;
                int indexUR = -(nWidth - 1) * nPerCell + boxStartIndex;
                int indexR = nPerCell + boxStartIndex;
                int indexDR = (nWidth + 1) * nPerCell + boxStartIndex;
                int indexD = nWidth * nPerCell + boxStartIndex;
                int k = 0;
                while (k < s.connections.size()) {
                    iiff = s.connections.get(k);
                    a = iiff.a + boxStartIndex;
                    b = iiff.b + boxStartIndex;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                    ++k;
                }
                k = 0;
                while (k < s.connectionsR.size()) {
                    iiff = s.connectionsR.get(k);
                    a = iiff.a + boxStartIndex;
                    b = iiff.b + indexR;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                    ++k;
                }
                k = 0;
                while (k < s.connectionsDR.size()) {
                    iiff = s.connectionsDR.get(k);
                    a = iiff.a + boxStartIndex;
                    b = iiff.b + indexDR;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                    ++k;
                }
                k = 0;
                while (k < s.connectionsD.size()) {
                    iiff = s.connectionsD.get(k);
                    a = iiff.a + boxStartIndex;
                    b = iiff.b + indexD;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                    ++k;
                }
                k = 0;
                while (k < s.connectionsUR.size()) {
                    if (j == 0) break;
                    iiff = s.connectionsUR.get(k);
                    a = iiff.a + boxStartIndex;
                    b = iiff.b + indexUR;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a, b, freq, damp, w);
                    ++k;
                }
                ++i;
            }
            ++j;
        }
    }

    private static Joint createConnection(Body[] bodies, int a, int b, float frequency, float damping, World w) {
        if (a >= bodies.length || b >= bodies.length || bodies[a] == null || bodies[b] == null) {
            return null;
        }
        DistanceJointDef jd = new DistanceJointDef();
        jd.collideConnected = false;
        jd.dampingRatio = damping;
        jd.frequencyHz = frequency;
        jd.initialize(bodies[a], bodies[b], bodies[a].getMemberPosition(), bodies[b].getMemberPosition());
        return w.createJoint(jd);
    }
}

