/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.timingTests;

import org.jbox2d.collision.shapes.CircleDef;
import org.jbox2d.collision.shapes.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.timingTests.SimpleTest;

public class PistonBenchmark
implements SimpleTest {
    public static boolean BULLETS = false;
    public RevoluteJoint m_joint1;
    public PrismaticJoint m_joint2;

    @Override
    public void create(World world) {
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(0.5f, 2.0f);
        sd.density = 1.0f;
        RevoluteJointDef rjd = new RevoluteJointDef();
        Body prevBody = world.getGroundBody();
        BodyDef bd = new BodyDef();
        bd.position.set(0.0f, 7.0f);
        Body body = world.createBody(bd);
        body.createShape(sd);
        body.setMassFromShapes();
        rjd.initialize(prevBody, body, new Vec2(0.0f, 5.0f));
        rjd.motorSpeed = 3.1415f;
        rjd.maxMotorTorque = Float.MAX_VALUE;
        rjd.enableMotor = true;
        this.m_joint1 = (RevoluteJoint)world.createJoint(rjd);
        prevBody = body;
        sd.setAsBox(0.5f, 4.0f);
        bd.position.set(0.0f, 13.0f);
        body = world.createBody(bd);
        body.createShape(sd);
        body.setMassFromShapes();
        rjd.initialize(prevBody, body, new Vec2(0.0f, 9.0f));
        rjd.enableMotor = false;
        world.createJoint(rjd);
        prevBody = body;
        sd.setAsBox(5.0f, 1.5f);
        bd.position.set(0.0f, 17.0f);
        body = world.createBody(bd);
        body.createShape(sd);
        body.setMassFromShapes();
        rjd.initialize(prevBody, body, new Vec2(0.0f, 17.0f));
        world.createJoint(rjd);
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(world.getGroundBody(), body, new Vec2(0.0f, 17.0f), new Vec2(0.0f, 1.0f));
        pjd.enableMotor = false;
        this.m_joint2 = (PrismaticJoint)world.createJoint(pjd);
        int i = 0;
        while (i < 100) {
            sd.setAsBox(0.4f, 0.3f);
            sd.density = 0.1f;
            bd.position.set(-1.0f, 23.0f + (float)i);
            bd.isBullet = BULLETS;
            body = world.createBody(bd);
            body.createShape(sd);
            body.setMassFromShapes();
            ++i;
        }
        CircleDef cd = new CircleDef();
        cd.density = 2.0f;
        cd.radius = 0.36f;
        int i2 = 0;
        while (i2 < 100) {
            bd.position.set(1.0f, 23.0f + (float)i2);
            bd.isBullet = BULLETS;
            body = world.createBody(bd);
            body.createShape(cd);
            body.setMassFromShapes();
            ++i2;
        }
        sd.density = 0.0f;
        sd.friction = 0.0f;
        sd.setAsBox(1.0f, 100.0f);
        bd = new BodyDef();
        bd.position.set(-6.1f, 50.0f);
        Body bod = world.createBody(bd);
        bod.createShape(sd);
        bd.position.set(6.1f, 50.0f);
        bod = world.createBody(bd);
        bod.createShape(sd);
    }

    @Override
    public String toString() {
        return "Piston test";
    }
}

