/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.mathtests;

import org.jbox2d.common.MathUtils;

public class SinCosTable {
    public static final float TWOPI = (float)Math.PI * 2;
    public static boolean LERP_LOOKUP = true;
    public final float precision;
    public final int tableLength;
    public final float[] sinLUT;

    public SinCosTable(float argPrecision) {
        this.precision = argPrecision;
        this.tableLength = (int)Math.ceil((float)Math.PI * 2 / this.precision);
        this.sinLUT = new float[this.tableLength];
        int i = 0;
        while (i < this.tableLength) {
            this.sinLUT[i] = (float)Math.sin((float)i * this.precision);
            ++i;
        }
    }

    public final float sin(float x) {
        x %= (float)Math.PI * 2;
        if (LERP_LOOKUP) {
            int index = (int)(x /= this.precision);
            if (index != 0) {
                x %= (float)index;
            }
            if (index == this.tableLength - 1) {
                return (1.0f - x) * this.sinLUT[index] + x * this.sinLUT[0];
            }
            return (1.0f - x) * this.sinLUT[index] + x * this.sinLUT[index + 1];
        }
        return this.sinLUT[MathUtils.round(x / this.precision) % this.tableLength];
    }
}

