/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed;

import def.processing.core.PApplet;
import def.processing.core.PFont;
import def.processing.core.PGraphics;
import def.processing.core.PImage;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.DebugDraw;

public class ProcessingDebugDraw
extends DebugDraw {
    public static ProcessingDebugDraw screen;
    private boolean firstTime = true;
    public PApplet g;
    public PGraphics pg;
    public PFont m_font;
    public float fontHeight;
    private final OBBViewportTransform transform = (OBBViewportTransform)super.getViewportTranform();
    private static final Vec2 circlePt;
    private static final Vec2 p;
    private static final Vec2 center;
    private static final Vec2 v1;
    private static final Vec2 v2;
    private static final Vec2 v;
    private static final Vec2 p1;
    private static final Vec2 p2;
    private static final Vec2 p1world;
    private static final Vec2 p2world;
    private static final Vec2 position;
    private static final Vec2 localOffset;

    static {
        circlePt = new Vec2();
        p = new Vec2();
        center = new Vec2();
        v1 = new Vec2();
        v2 = new Vec2();
        v = new Vec2();
        p1 = new Vec2();
        p2 = new Vec2();
        p1world = new Vec2();
        p2world = new Vec2();
        position = new Vec2();
        localOffset = new Vec2();
    }

    public ProcessingDebugDraw(PApplet pApplet) {
        super(new OBBViewportTransform());
        this.g = pApplet;
        this.pg = this.g.createGraphics(pApplet.displayWidth, pApplet.displayHeight);
        screen = this;
        this.m_font = this.g.createFont("LucidaGrande-Bold", 12.0f);
        this.fontHeight = 14.0f;
        this.viewportTransform.setCamera(320 + this.g.width / 2, 240 + this.g.height / 2, 20.0f);
        this.viewportTransform.setExtents(this.g.width / 2, this.g.height / 2);
        this.viewportTransform.setYFlip(true);
    }

    @Override
    public void drawCircle(Vec2 argCenter, float radius, Color3f color) {
        this.viewportTransform.getWorldToScreen(argCenter, center);
        this.g.noFill();
        float k_segments = 16.0f;
        float k_increment = (float)Math.PI * 2 / k_segments;
        float theta = 0.0f;
        this.g.stroke(color.x, color.y, color.z);
        this.g.noFill();
        this.g.beginShape(20);
        int i = 0;
        while ((float)i < k_segments) {
            float vx = radius * MathUtils.cos(theta);
            float vy = radius * MathUtils.sin(theta);
            circlePt.set(vx, vy);
            this.viewportTransform.vectorTransform(circlePt, circlePt);
            circlePt.addLocal(center);
            this.g.vertex(ProcessingDebugDraw.circlePt.x, ProcessingDebugDraw.circlePt.y);
            theta += k_increment;
            ++i;
        }
        circlePt.set(radius, 0.0f);
        this.viewportTransform.vectorTransform(circlePt, circlePt);
        circlePt.addLocal(center);
        this.g.vertex(ProcessingDebugDraw.circlePt.x, ProcessingDebugDraw.circlePt.y);
        this.g.endShape();
    }

    @Override
    public void drawSolidCircle(Vec2 argCenter, float radius, Vec2 axis, Color3f color) {
        this.viewportTransform.getWorldToScreen(argCenter, center);
        float k_segments = 16.0f;
        float k_increment = (float)Math.PI * 2 / k_segments;
        float theta = 0.0f;
        this.g.fill(0.5f * color.x, 0.5f * color.y, 0.5f * color.z, 127.5f);
        this.g.stroke(color.x, color.y, color.z, 255.0f);
        this.g.beginShape(20);
        int i = 0;
        while ((float)i < k_segments) {
            float vx = radius * MathUtils.cos(theta);
            float vy = radius * MathUtils.sin(theta);
            circlePt.set(vx, vy);
            this.viewportTransform.vectorTransform(circlePt, circlePt);
            circlePt.addLocal(center);
            this.g.vertex(ProcessingDebugDraw.circlePt.x, ProcessingDebugDraw.circlePt.y);
            theta += k_increment;
            ++i;
        }
        circlePt.set(radius, 0.0f);
        this.viewportTransform.vectorTransform(circlePt, circlePt);
        circlePt.addLocal(center);
        this.g.vertex(ProcessingDebugDraw.circlePt.x, ProcessingDebugDraw.circlePt.y);
        this.g.endShape();
        this.getWorldToScreenToOut(argCenter.x + radius * axis.x, argCenter.y + radius * axis.y, p);
        this.g.beginShape(5);
        this.g.vertex(ProcessingDebugDraw.center.x, ProcessingDebugDraw.center.y);
        this.g.vertex(ProcessingDebugDraw.p.x, ProcessingDebugDraw.p.y);
        this.g.endShape();
    }

    @Override
    public void drawPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        this.g.stroke(color.x, color.y, color.z);
        this.g.noFill();
        int i = 0;
        while (i < vertexCount) {
            int ind = i + 1 < vertexCount ? i + 1 : i + 1 - vertexCount;
            this.viewportTransform.getWorldToScreen(vertices[i], v1);
            this.viewportTransform.getWorldToScreen(vertices[ind], v2);
            this.g.line(ProcessingDebugDraw.v1.x, ProcessingDebugDraw.v1.y, ProcessingDebugDraw.v2.x, ProcessingDebugDraw.v2.y);
            ++i;
        }
    }

    @Override
    public void drawSolidPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        this.g.noStroke();
        this.g.fill(0.5f * color.x, 0.5f * color.y, 0.5f * color.z, 127.5f);
        this.g.beginShape(20);
        int i = 0;
        while (i < vertexCount) {
            this.viewportTransform.getWorldToScreen(vertices[i], v);
            this.g.vertex(ProcessingDebugDraw.v.x, ProcessingDebugDraw.v.y);
            ++i;
        }
        this.g.endShape();
        this.g.stroke(color.x, color.y, color.z, 255.0f);
        i = 0;
        while (i < vertexCount) {
            int ind = i + 1 < vertexCount ? i + 1 : i + 1 - vertexCount;
            this.viewportTransform.getWorldToScreen(vertices[i], v1);
            this.viewportTransform.getWorldToScreen(vertices[ind], v2);
            this.g.line(ProcessingDebugDraw.v1.x, ProcessingDebugDraw.v1.y, ProcessingDebugDraw.v2.x, ProcessingDebugDraw.v2.y);
            ++i;
        }
    }

    @Override
    public void drawSegment(Vec2 argP1, Vec2 argP2, Color3f color) {
        this.viewportTransform.getWorldToScreen(argP1, p1);
        this.viewportTransform.getWorldToScreen(argP2, p2);
        this.g.stroke(color.x, color.y, color.z);
        this.g.beginShape(5);
        this.g.vertex(ProcessingDebugDraw.p1.x, ProcessingDebugDraw.p1.y);
        this.g.vertex(ProcessingDebugDraw.p2.x, ProcessingDebugDraw.p2.y);
        this.g.endShape();
    }

    @Override
    public void drawXForm(XForm xf) {
        p1.set(xf.position);
        p2.setZero();
        float k_axisScale = 0.4f;
        this.g.beginShape(5);
        this.viewportTransform.getWorldToScreen(p1, p1world);
        this.g.stroke(255.0f, 0.0f, 0.0f);
        this.g.vertex(ProcessingDebugDraw.p1world.x, ProcessingDebugDraw.p1world.y);
        ProcessingDebugDraw.p2.x = ProcessingDebugDraw.p1.x + k_axisScale * xf.R.col1.x;
        ProcessingDebugDraw.p2.y = ProcessingDebugDraw.p1.y + k_axisScale * xf.R.col1.y;
        this.viewportTransform.getWorldToScreen(p2, p2world);
        this.g.vertex(ProcessingDebugDraw.p2world.x, ProcessingDebugDraw.p2world.y);
        this.g.stroke(0.0f, 255.0f, 0.0f);
        this.g.vertex(ProcessingDebugDraw.p1world.x, ProcessingDebugDraw.p1world.y);
        ProcessingDebugDraw.p2.x = ProcessingDebugDraw.p1.x + k_axisScale * xf.R.col2.x;
        ProcessingDebugDraw.p2.y = ProcessingDebugDraw.p1.y + k_axisScale * xf.R.col2.y;
        this.viewportTransform.getWorldToScreen(p2, p2world);
        this.g.vertex(ProcessingDebugDraw.p2world.x, ProcessingDebugDraw.p2world.y);
        this.g.endShape();
    }

    @Override
    public void drawString(float x, float y, String s, Color3f color) {
        if (this.firstTime) {
            this.g.textFont(this.m_font);
            if (this.pg != null && this.pg.is3D()) {
                this.g.textMode(256);
            }
            this.firstTime = false;
        }
        this.g.fill(color.x, color.y, color.z);
        this.g.text(s, x, y);
    }

    @Override
    public void drawPoint(Vec2 argPosition, float f, Color3f color) {
        this.viewportTransform.getWorldToScreen(argPosition, position);
        float k_segments = 5.0f;
        float k_increment = (float)Math.PI * 2 / k_segments;
        float k_radius = 3.0f;
        float theta = 0.0f;
        this.g.fill(color.x, color.y, color.z);
        this.g.noStroke();
        this.g.beginShape(20);
        int i = 0;
        while ((float)i < k_segments) {
            float vx = ProcessingDebugDraw.position.x + k_radius * MathUtils.cos(theta);
            float vy = ProcessingDebugDraw.position.y + k_radius * MathUtils.sin(theta);
            this.g.vertex(vx, vy);
            theta += k_increment;
            ++i;
        }
        this.g.endShape();
    }

    public void drawImage(PImage image, Vec2 argPosition, float rotation, float localScale, Vec2 argLocalOffset, float halfImageWidth, float halfImageHeight) {
        this.viewportTransform.getWorldToScreen(argPosition, position);
        this.viewportTransform.vectorTransform(argLocalOffset, localOffset);
        this.g.pushMatrix();
        this.g.translate(ProcessingDebugDraw.position.x, ProcessingDebugDraw.position.y);
        Mat22 mat = this.transform.getTransform();
        if (this.pg.is3D()) {
            this.g.applyMatrix(mat.col1.x, mat.col2.x, 0.0f, 0.0f, mat.col1.y, mat.col2.y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        } else {
            this.g.applyMatrix(mat.col1.x, mat.col2.x, 0.0f, mat.col1.y, mat.col2.y, 0.0f);
        }
        this.g.rotate(-rotation);
        this.g.scale(localScale);
        this.g.translate(ProcessingDebugDraw.localOffset.x, ProcessingDebugDraw.localOffset.y);
        this.g.image(image, -halfImageWidth, -halfImageHeight);
        this.g.popMatrix();
    }
}

