/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.p5;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;

public class JointUtils {
    public static DistanceJoint createDistanceJoint(World w, Vec2 pA, Vec2 pB) {
        Body[] bodies = JointUtils.getTwoDistinctBodies(w, pA, pB);
        if (bodies == null || bodies.length != 2) {
            return null;
        }
        DistanceJointDef jd = new DistanceJointDef();
        jd.initialize(bodies[0], bodies[1], pA, pB);
        return (DistanceJoint)w.createJoint(jd);
    }

    public static DistanceJoint createDistanceJoint(Body a, Body b) {
        float length;
        DistanceJointDef jd = new DistanceJointDef();
        jd.body1 = a;
        jd.body2 = b;
        jd.length = length = a.getMemberPosition().subLocal(b.getMemberPosition()).length();
        DistanceJoint j = (DistanceJoint)a.getWorld().createJoint(jd);
        return j;
    }

    public static RevoluteJoint createRevoluteJoint(Body a, Body b, Vec2 worldCenter) {
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.body1 = a;
        jd.body2 = b;
        jd.localAnchor1 = a.getLocalPoint(worldCenter);
        jd.localAnchor2 = b.getLocalPoint(worldCenter);
        RevoluteJoint j = (RevoluteJoint)a.getWorld().createJoint(jd);
        return j;
    }

    private static Body[] getTwoDistinctBodies(World w, Vec2 pA, Vec2 pB) {
        AABB aabb1 = new AABB(new Vec2(pA.x - 0.001f, pA.y - 0.001f), new Vec2(pA.x + 0.001f, pA.y + 0.001f));
        AABB aabb2 = new AABB(new Vec2(pB.x - 0.001f, pB.y - 0.001f), new Vec2(pB.x + 0.001f, pB.y + 0.001f));
        int maxCount = 10;
        Shape[] shapes1 = w.query(aabb1, maxCount);
        if (shapes1[0] == null) {
            return null;
        }
        Shape[] shapes2 = w.query(aabb2, maxCount);
        if (shapes2[0] == null) {
            return null;
        }
        boolean found = false;
        int i = 0;
        int j = 0;
        Body body1 = null;
        Body body2 = null;
        block0: while (!found) {
            if (i >= shapes1.length || shapes1[i] == null) {
                return null;
            }
            if (shapes1[i].testPoint(shapes1[i].getBody().getMemberXForm(), pA)) {
                body1 = shapes1[i++].getBody();
            }
            j = 0;
            while (j < shapes2.length) {
                if (shapes2[j] == null) continue block0;
                if (shapes2[j].testPoint(shapes2[j].getBody().getMemberXForm(), pB)) {
                    body2 = shapes2[j].getBody();
                }
                if (body2 != body1) {
                    found = true;
                    continue block0;
                }
                ++j;
            }
        }
        if (body1 == null || body2 == null) {
            return null;
        }
        Body[] bodies = new Body[]{body1, body2};
        return bodies;
    }
}

