/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.p5;

import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Steppable;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.p5.PhysicsUtils;

public class JointBreaker
implements Steppable {
    Joint joint;
    float reactionThreshold;
    float angleLo;
    float angleHi;

    public JointBreaker(Joint joint, float reactionThreshold) {
        this.joint = joint;
        this.reactionThreshold = reactionThreshold;
    }

    @Override
    public void step(float dt, int iterations) {
        if (this.joint != null) {
            Vec2 force = this.joint.getReactionForce();
            float forceAngle = PhysicsUtils.angle(force);
            float forceMag = force.length();
            if (forceMag > this.reactionThreshold && (this.angleLo == this.angleHi || forceAngle >= this.angleLo && forceAngle <= this.angleHi)) {
                this.joint.getBody1().getWorld().destroyJoint(this.joint);
                this.joint = null;
                this.joint.getBody1().getWorld().unregisterPostStep(this);
            }
        }
    }

    public void setAngleLimits(float lo, float hi) {
        this.angleLo = lo;
        this.angleHi = hi;
    }
}

