/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.pooling.TLMat22;
import org.jbox2d.pooling.TLVec2;

public class RevoluteJoint
extends Joint {
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_pivotForce;
    public float m_motorForce;
    public float m_limitForce;
    public float m_limitPositionImpulse;
    public final Mat22 m_pivotMass;
    public float m_motorMass;
    public boolean m_enableMotor;
    public float m_maxMotorTorque;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public float m_referenceAngle;
    public float m_lowerAngle;
    public float m_upperAngle;
    public LimitState m_limitState;
    private static final TLVec2 tlr1 = new TLVec2();
    private static final TLVec2 tlr2 = new TLVec2();
    private static final TLMat22 tlK1 = new TLMat22();
    private static final TLMat22 tlK2 = new TLMat22();
    private static final TLMat22 tlK3 = new TLMat22();
    final Vec2 m_lastWarmStartingPivotForce = new Vec2(0.0f, 0.0f);
    private static final TLVec2 tltemp = new TLVec2();
    private static final TLVec2 tlpivotCdot = new TLVec2();
    private static final TLVec2 tlpivotForce = new TLVec2();
    private static final TLVec2 tlp1 = new TLVec2();
    private static final TLVec2 tlp2 = new TLVec2();
    private static final TLVec2 tlptpC = new TLVec2();
    private static final TLVec2 tlimpulse = new TLVec2();

    public RevoluteJoint(RevoluteJointDef def) {
        super(def);
        this.m_localAnchor1 = def.localAnchor1.clone();
        this.m_localAnchor2 = def.localAnchor2.clone();
        this.m_referenceAngle = def.referenceAngle;
        this.m_pivotForce = new Vec2(0.0f, 0.0f);
        this.m_motorForce = 0.0f;
        this.m_limitForce = 0.0f;
        this.m_limitPositionImpulse = 0.0f;
        this.m_pivotMass = new Mat22();
        this.m_lowerAngle = def.lowerAngle;
        this.m_upperAngle = def.upperAngle;
        this.m_maxMotorTorque = def.maxMotorTorque;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Mat22 K1 = (Mat22)tlK1.get();
        Mat22 K2 = (Mat22)tlK2.get();
        Mat22 K3 = (Mat22)tlK3.get();
        r1.set(b1.getMemberLocalCenter());
        r2.set(b2.getMemberLocalCenter());
        r1.subLocal(this.m_localAnchor1).negateLocal();
        r2.subLocal(this.m_localAnchor2).negateLocal();
        Mat22.mulToOut(b1.m_xf.R, r1, r1);
        Mat22.mulToOut(b2.m_xf.R, r2, r2);
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        K1.col1.x = invMass1 + invMass2;
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = invMass1 + invMass2;
        K2.col1.x = invI1 * r1.y * r1.y;
        K2.col2.x = -invI1 * r1.x * r1.y;
        K2.col1.y = -invI1 * r1.x * r1.y;
        K2.col2.y = invI1 * r1.x * r1.x;
        K3.col1.x = invI2 * r2.y * r2.y;
        K3.col2.x = -invI2 * r2.x * r2.y;
        K3.col1.y = -invI2 * r2.x * r2.y;
        K3.col2.y = invI2 * r2.x * r2.x;
        K1.addLocal(K2).addLocal(K3);
        K1.invertToOut(this.m_pivotMass);
        this.m_motorMass = 1.0f / (invI1 + invI2);
        if (!this.m_enableMotor) {
            this.m_motorForce = 0.0f;
        }
        if (this.m_enableLimit) {
            float jointAngle = b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
            if (MathUtils.abs(this.m_upperAngle - this.m_lowerAngle) < 0.06981318f) {
                this.m_limitState = LimitState.EQUAL_LIMITS;
            } else if (jointAngle <= this.m_lowerAngle) {
                if (this.m_limitState != LimitState.AT_LOWER_LIMIT) {
                    this.m_limitForce = 0.0f;
                }
                this.m_limitState = LimitState.AT_LOWER_LIMIT;
            } else if (jointAngle >= this.m_upperAngle) {
                if (this.m_limitState != LimitState.AT_UPPER_LIMIT) {
                    this.m_limitForce = 0.0f;
                }
                this.m_limitState = LimitState.AT_UPPER_LIMIT;
            } else {
                this.m_limitState = LimitState.INACTIVE_LIMIT;
                this.m_limitForce = 0.0f;
            }
        } else {
            this.m_limitForce = 0.0f;
        }
        if (step.warmStarting) {
            b1.m_linearVelocity.x -= step.dt * invMass1 * this.m_pivotForce.x;
            b1.m_linearVelocity.y -= step.dt * invMass1 * this.m_pivotForce.y;
            b1.m_angularVelocity -= step.dt * invI1 * (Vec2.cross(r1, this.m_pivotForce) + this.m_motorForce + this.m_limitForce);
            b2.m_linearVelocity.x += step.dt * invMass2 * this.m_pivotForce.x;
            b2.m_linearVelocity.y += step.dt * invMass2 * this.m_pivotForce.y;
            b2.m_angularVelocity += step.dt * invI2 * (Vec2.cross(r2, this.m_pivotForce) + this.m_motorForce + this.m_limitForce);
        } else {
            this.m_pivotForce.setZero();
            this.m_motorForce = 0.0f;
            this.m_limitForce = 0.0f;
        }
        this.m_limitPositionImpulse = 0.0f;
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 temp = (Vec2)tltemp.get();
        Vec2 pivotCdot = (Vec2)tlpivotCdot.get();
        Vec2 pivotForce = (Vec2)tlpivotForce.get();
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        r1.set(b1.getMemberLocalCenter());
        r2.set(b2.getMemberLocalCenter());
        r1.subLocal(this.m_localAnchor1).negateLocal();
        r2.subLocal(this.m_localAnchor2).negateLocal();
        Mat22.mulToOut(b1.m_xf.R, r1, r1);
        Mat22.mulToOut(b2.m_xf.R, r2, r2);
        Vec2.crossToOut(b1.m_angularVelocity, r1, temp);
        Vec2.crossToOut(b2.m_angularVelocity, r2, pivotCdot);
        pivotCdot.subLocal(b1.m_linearVelocity).subLocal(temp).addLocal(b2.m_linearVelocity);
        Mat22.mulToOut(this.m_pivotMass, pivotCdot, pivotForce);
        pivotForce.mulLocal(-step.inv_dt);
        if (step.warmStarting) {
            this.m_pivotForce.addLocal(pivotForce);
            this.m_lastWarmStartingPivotForce.set(this.m_pivotForce);
        } else {
            this.m_pivotForce.set(this.m_lastWarmStartingPivotForce);
        }
        Vec2 P = pivotForce.mulLocal(step.dt);
        b1.m_linearVelocity.x -= b1.m_invMass * P.x;
        b1.m_linearVelocity.y -= b1.m_invMass * P.y;
        b1.m_angularVelocity -= b1.m_invI * Vec2.cross(r1, P);
        b2.m_linearVelocity.x += b2.m_invMass * P.x;
        b2.m_linearVelocity.y += b2.m_invMass * P.y;
        b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P);
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL_LIMITS) {
            float motorCdot = b2.m_angularVelocity - b1.m_angularVelocity - this.m_motorSpeed;
            float motorForce = -step.inv_dt * this.m_motorMass * motorCdot;
            float oldMotorForce = this.m_motorForce;
            this.m_motorForce = MathUtils.clamp(this.m_motorForce + motorForce, -this.m_maxMotorTorque, this.m_maxMotorTorque);
            motorForce = this.m_motorForce - oldMotorForce;
            if (!step.warmStarting) {
                this.m_motorForce = oldMotorForce;
            }
            float P2 = step.dt * motorForce;
            b1.m_angularVelocity -= b1.m_invI * P2;
            b2.m_angularVelocity += b2.m_invI * P2;
        }
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE_LIMIT) {
            float oldLimitForce;
            float limitCdot = b2.m_angularVelocity - b1.m_angularVelocity;
            float limitForce = -step.inv_dt * this.m_motorMass * limitCdot;
            if (this.m_limitState == LimitState.EQUAL_LIMITS) {
                this.m_limitForce += limitForce;
            } else if (this.m_limitState == LimitState.AT_LOWER_LIMIT) {
                oldLimitForce = this.m_limitForce;
                this.m_limitForce = MathUtils.max(this.m_limitForce + limitForce, 0.0f);
                limitForce = this.m_limitForce - oldLimitForce;
            } else if (this.m_limitState == LimitState.AT_UPPER_LIMIT) {
                oldLimitForce = this.m_limitForce;
                this.m_limitForce = MathUtils.min(this.m_limitForce + limitForce, 0.0f);
                limitForce = this.m_limitForce - oldLimitForce;
            }
            float P2 = step.dt * limitForce;
            b1.m_angularVelocity -= b1.m_invI * P2;
            b2.m_angularVelocity += b2.m_invI * P2;
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 p1 = (Vec2)tlp1.get();
        Vec2 p2 = (Vec2)tlp2.get();
        Vec2 ptpC = (Vec2)tlptpC.get();
        Vec2 impulse = (Vec2)tlimpulse.get();
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Mat22 K1 = (Mat22)tlK1.get();
        Mat22 K2 = (Mat22)tlK2.get();
        Mat22 K3 = (Mat22)tlK3.get();
        float positionError = 0.0f;
        r1.set(b1.getMemberLocalCenter());
        r2.set(b2.getMemberLocalCenter());
        r1.subLocal(this.m_localAnchor1).negateLocal();
        r2.subLocal(this.m_localAnchor2).negateLocal();
        Mat22.mulToOut(b1.m_xf.R, r1, r1);
        Mat22.mulToOut(b2.m_xf.R, r2, r2);
        p1.set(b1.m_sweep.c);
        p1.addLocal(r1);
        p2.set(b2.m_sweep.c);
        p2.addLocal(r2);
        ptpC.set(p2);
        ptpC.subLocal(p1);
        positionError = ptpC.length();
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        K1.col1.x = invMass1 + invMass2;
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = invMass1 + invMass2;
        K2.col1.x = invI1 * r1.y * r1.y;
        K2.col2.x = -invI1 * r1.x * r1.y;
        K2.col1.y = -invI1 * r1.x * r1.y;
        K2.col2.y = invI1 * r1.x * r1.x;
        K3.col1.x = invI2 * r2.y * r2.y;
        K3.col2.x = -invI2 * r2.x * r2.y;
        K3.col1.y = -invI2 * r2.x * r2.y;
        K3.col2.y = invI2 * r2.x * r2.x;
        Mat22 K = K1.addLocal(K2).addLocal(K3);
        K.solveToOut(ptpC.negateLocal(), impulse);
        b1.m_sweep.c.x -= b1.m_invMass * impulse.x;
        b1.m_sweep.c.y -= b1.m_invMass * impulse.y;
        b1.m_sweep.a -= b1.m_invI * Vec2.cross(r1, impulse);
        b2.m_sweep.c.x += b2.m_invMass * impulse.x;
        b2.m_sweep.c.y += b2.m_invMass * impulse.y;
        b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, impulse);
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        float angularError = 0.0f;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE_LIMIT) {
            float angle = b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
            float limitImpulse = 0.0f;
            if (this.m_limitState == LimitState.EQUAL_LIMITS) {
                float limitC = MathUtils.clamp(angle, -0.13962635f, 0.13962635f);
                limitImpulse = -this.m_motorMass * limitC;
                angularError = MathUtils.abs(limitC);
            } else if (this.m_limitState == LimitState.AT_LOWER_LIMIT) {
                float limitC = angle - this.m_lowerAngle;
                angularError = MathUtils.max(0.0f, -limitC);
                limitC = MathUtils.clamp(limitC + 0.03490659f, -0.13962635f, 0.0f);
                limitImpulse = -this.m_motorMass * limitC;
                float oldLimitImpulse = this.m_limitPositionImpulse;
                this.m_limitPositionImpulse = MathUtils.max(this.m_limitPositionImpulse + limitImpulse, 0.0f);
                limitImpulse = this.m_limitPositionImpulse - oldLimitImpulse;
            } else if (this.m_limitState == LimitState.AT_UPPER_LIMIT) {
                float limitC = angle - this.m_upperAngle;
                angularError = MathUtils.max(0.0f, limitC);
                limitC = MathUtils.clamp(limitC - 0.03490659f, 0.0f, 0.13962635f);
                limitImpulse = -this.m_motorMass * limitC;
                float oldLimitImpulse = this.m_limitPositionImpulse;
                this.m_limitPositionImpulse = MathUtils.min(this.m_limitPositionImpulse + limitImpulse, 0.0f);
                limitImpulse = this.m_limitPositionImpulse - oldLimitImpulse;
            }
            b1.m_sweep.a -= b1.m_invI * limitImpulse;
            b2.m_sweep.a += b2.m_invI * limitImpulse;
            b1.synchronizeTransform();
            b2.synchronizeTransform();
        }
        return positionError <= 0.005f && angularError <= 0.03490659f;
    }

    @Override
    public Vec2 getAnchor1() {
        return this.m_body1.getWorldLocation(this.m_localAnchor1);
    }

    @Override
    public Vec2 getAnchor2() {
        return this.m_body2.getWorldLocation(this.m_localAnchor2);
    }

    @Override
    public Vec2 getReactionForce() {
        return this.m_pivotForce;
    }

    @Override
    public float getReactionTorque() {
        return this.m_limitForce;
    }

    public float getJointAngle() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        return b2.m_sweep.a - b1.m_sweep.a - this.m_referenceAngle;
    }

    public float getJointSpeed() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        return b2.m_angularVelocity - b1.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_enableMotor = flag;
    }

    public float getMotorTorque() {
        return this.m_motorForce;
    }

    public void setMotorSpeed(float speed) {
        this.m_motorSpeed = speed;
    }

    public void setMaxMotorTorque(float torque) {
        this.m_maxMotorTorque = torque;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean flag) {
        this.m_enableLimit = flag;
    }

    public float getLowerLimit() {
        return this.m_lowerAngle;
    }

    public float getUpperLimit() {
        return this.m_upperAngle;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        this.m_lowerAngle = lower;
        this.m_upperAngle = upper;
    }
}

