/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.pooling.TLVec2;

public class PulleyJoint
extends Joint {
    public static final float MIN_PULLEY_LENGTH = 2.0f;
    public Body m_ground;
    public final Vec2 m_groundAnchor1;
    public final Vec2 m_groundAnchor2;
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_u1;
    public final Vec2 m_u2;
    public float m_constant;
    public float m_ratio;
    public float m_maxLength1;
    public float m_maxLength2;
    public float m_pulleyMass;
    public float m_limitMass1;
    public float m_limitMass2;
    public float m_force;
    public float m_limitForce1;
    public float m_limitForce2;
    public float m_positionImpulse;
    public float m_limitPositionImpulse1;
    public float m_limitPositionImpulse2;
    public LimitState m_state;
    public LimitState m_limitState1;
    public LimitState m_limitState2;
    private static final TLVec2 tlr1 = new TLVec2();
    private static final TLVec2 tlr2 = new TLVec2();
    private static final TLVec2 tlp1 = new TLVec2();
    private static final TLVec2 tlp2 = new TLVec2();
    private static final TLVec2 tls1 = new TLVec2();
    private static final TLVec2 tls2 = new TLVec2();
    private static final TLVec2 tlP1 = new TLVec2();
    private static final TLVec2 tlP2 = new TLVec2();
    private static final TLVec2 tlv1 = new TLVec2();
    private static final TLVec2 tlv2 = new TLVec2();

    public PulleyJoint(PulleyJointDef def) {
        super(def);
        this.m_ground = this.m_body1.m_world.getGroundBody();
        this.m_groundAnchor1 = def.groundAnchor1.sub(this.m_ground.m_xf.position);
        this.m_groundAnchor2 = def.groundAnchor2.sub(this.m_ground.m_xf.position);
        this.m_localAnchor1 = def.localAnchor1.clone();
        this.m_localAnchor2 = def.localAnchor2.clone();
        this.m_u1 = new Vec2();
        this.m_u2 = new Vec2();
        assert (def.ratio != 0.0f);
        this.m_ratio = def.ratio;
        this.m_constant = def.length1 + this.m_ratio * def.length2;
        this.m_maxLength1 = MathUtils.min(def.maxLength1, this.m_constant - this.m_ratio * 2.0f);
        this.m_maxLength2 = MathUtils.min(def.maxLength2, (this.m_constant - 2.0f) / this.m_ratio);
        this.m_force = 0.0f;
        this.m_limitForce1 = 0.0f;
        this.m_limitForce2 = 0.0f;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 p1 = (Vec2)tlp1.get();
        Vec2 p2 = (Vec2)tlp2.get();
        Vec2 s1 = (Vec2)tls1.get();
        Vec2 s2 = (Vec2)tls2.get();
        Vec2 P1 = (Vec2)tlP1.get();
        Vec2 P2 = (Vec2)tlP2.get();
        r1.set(b1.getMemberLocalCenter());
        r2.set(b2.getMemberLocalCenter());
        r1.subLocal(this.m_localAnchor1).negateLocal();
        r2.subLocal(this.m_localAnchor2).negateLocal();
        Mat22.mulToOut(b1.m_xf.R, r1, r1);
        Mat22.mulToOut(b2.m_xf.R, r2, r2);
        p1.set(b1.m_sweep.c);
        p1.addLocal(r1);
        p2.set(b2.m_sweep.c);
        p2.addLocal(r2);
        s1.set(this.m_ground.m_xf.position);
        s1.addLocal(this.m_groundAnchor1);
        s2.set(this.m_ground.m_xf.position);
        s2.addLocal(this.m_groundAnchor2);
        this.m_u1.set(p1);
        this.m_u1.subLocal(s1);
        this.m_u2.set(p2);
        this.m_u2.subLocal(s2);
        float length1 = this.m_u1.length();
        float length2 = this.m_u2.length();
        if (length1 > 0.005f) {
            this.m_u1.mulLocal(1.0f / length1);
        } else {
            this.m_u1.setZero();
        }
        if (length2 > 0.005f) {
            this.m_u2.mulLocal(1.0f / length2);
        } else {
            this.m_u2.setZero();
        }
        float C = this.m_constant - length1 - this.m_ratio * length2;
        if (C > 0.0f) {
            this.m_state = LimitState.INACTIVE_LIMIT;
            this.m_force = 0.0f;
        } else {
            this.m_state = LimitState.AT_UPPER_LIMIT;
            this.m_positionImpulse = 0.0f;
        }
        if (length1 < this.m_maxLength1) {
            this.m_limitState1 = LimitState.INACTIVE_LIMIT;
            this.m_limitForce1 = 0.0f;
        } else {
            this.m_limitState1 = LimitState.AT_UPPER_LIMIT;
            this.m_limitPositionImpulse1 = 0.0f;
        }
        if (length2 < this.m_maxLength2) {
            this.m_limitState2 = LimitState.INACTIVE_LIMIT;
            this.m_limitForce2 = 0.0f;
        } else {
            this.m_limitState2 = LimitState.AT_UPPER_LIMIT;
            this.m_limitPositionImpulse2 = 0.0f;
        }
        float cr1u1 = Vec2.cross(r1, this.m_u1);
        float cr2u2 = Vec2.cross(r2, this.m_u2);
        this.m_limitMass1 = b1.m_invMass + b1.m_invI * cr1u1 * cr1u1;
        this.m_limitMass2 = b2.m_invMass + b2.m_invI * cr2u2 * cr2u2;
        this.m_pulleyMass = this.m_limitMass1 + this.m_ratio * this.m_ratio * this.m_limitMass2;
        assert (this.m_limitMass1 > 1.1920929E-7f);
        assert (this.m_limitMass2 > 1.1920929E-7f);
        assert (this.m_pulleyMass > 1.1920929E-7f);
        this.m_limitMass1 = 1.0f / this.m_limitMass1;
        this.m_limitMass2 = 1.0f / this.m_limitMass2;
        this.m_pulleyMass = 1.0f / this.m_pulleyMass;
        if (step.warmStarting) {
            P1.set(this.m_u1);
            P1.mulLocal(step.dt * (-this.m_force - this.m_limitForce1));
            P2.set(this.m_u2);
            P2.mulLocal(step.dt * (-this.m_ratio * this.m_force - this.m_limitForce2));
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
            b1.m_linearVelocity.addLocal(P1.mulLocal(b1.m_invMass));
            b2.m_linearVelocity.addLocal(P2.mulLocal(b2.m_invMass));
        } else {
            this.m_force = 0.0f;
            this.m_limitForce1 = 0.0f;
            this.m_limitForce2 = 0.0f;
        }
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        float oldForce;
        float force;
        float Cdot;
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 v1 = (Vec2)tlv1.get();
        Vec2 v2 = (Vec2)tlv2.get();
        Vec2 P1 = (Vec2)tlP1.get();
        Vec2 P2 = (Vec2)tlP2.get();
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        r1.set(b1.getMemberLocalCenter());
        r2.set(b2.getMemberLocalCenter());
        r1.subLocal(this.m_localAnchor1).negateLocal();
        r2.subLocal(this.m_localAnchor2).negateLocal();
        Mat22.mulToOut(b1.m_xf.R, r1, r1);
        Mat22.mulToOut(b2.m_xf.R, r2, r2);
        if (this.m_state == LimitState.AT_UPPER_LIMIT) {
            Vec2.crossToOut(b1.m_angularVelocity, r1, v1);
            Vec2.crossToOut(b2.m_angularVelocity, r2, v2);
            v1.add(b1.m_linearVelocity);
            v2.add(b2.m_linearVelocity);
            Cdot = -Vec2.dot(this.m_u1, v1) - this.m_ratio * Vec2.dot(this.m_u2, v2);
            force = -step.inv_dt * this.m_pulleyMass * Cdot;
            oldForce = this.m_force;
            this.m_force = MathUtils.max(0.0f, this.m_force + force);
            force = this.m_force - oldForce;
            P1.set(this.m_u1);
            P1.mulLocal(-step.dt * force);
            P2.set(this.m_u2);
            P2.mulLocal(-step.dt * this.m_ratio * force);
            b1.m_linearVelocity.x += b1.m_invMass * P1.x;
            b1.m_linearVelocity.y += b1.m_invMass * P1.y;
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            b2.m_linearVelocity.x += b2.m_invMass * P2.x;
            b2.m_linearVelocity.y += b2.m_invMass * P2.y;
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
        }
        if (this.m_limitState1 == LimitState.AT_UPPER_LIMIT) {
            Vec2.crossToOut(b1.m_angularVelocity, r1, v1);
            v1.addLocal(b1.m_linearVelocity);
            Cdot = -Vec2.dot(this.m_u1, v1);
            force = -step.inv_dt * this.m_limitMass1 * Cdot;
            oldForce = this.m_limitForce1;
            this.m_limitForce1 = MathUtils.max(0.0f, this.m_limitForce1 + force);
            force = this.m_limitForce1 - oldForce;
            P1.set(this.m_u1);
            P1.mulLocal(-step.dt * force);
            b1.m_linearVelocity.x += b1.m_invMass * P1.x;
            b1.m_linearVelocity.y += b1.m_invMass * P1.y;
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
        }
        if (this.m_limitState2 == LimitState.AT_UPPER_LIMIT) {
            Vec2.crossToOut(b2.m_angularVelocity, r2, v2);
            v2.addLocal(b2.m_linearVelocity);
            Cdot = -Vec2.dot(this.m_u2, v2);
            force = -step.inv_dt * this.m_limitMass2 * Cdot;
            oldForce = this.m_limitForce2;
            this.m_limitForce2 = MathUtils.max(0.0f, this.m_limitForce2 + force);
            force = this.m_limitForce2 - oldForce;
            P2.set(this.m_u2);
            P2.mulLocal(-step.dt * force);
            b2.m_linearVelocity.x += b2.m_invMass * P2.x;
            b2.m_linearVelocity.y += b2.m_invMass * P2.y;
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        float oldLimitPositionImpulse;
        float impulse;
        float C;
        float length1;
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 p1 = (Vec2)tlp1.get();
        Vec2 p2 = (Vec2)tlp2.get();
        Vec2 s1 = (Vec2)tls1.get();
        Vec2 s2 = (Vec2)tls2.get();
        Vec2 P1 = (Vec2)tlP1.get();
        Vec2 P2 = (Vec2)tlP2.get();
        s1.set(this.m_ground.m_xf.position);
        s1.addLocal(this.m_groundAnchor1);
        s2.set(this.m_ground.m_xf.position);
        s2.addLocal(this.m_groundAnchor2);
        float linearError = 0.0f;
        if (this.m_state == LimitState.AT_UPPER_LIMIT) {
            r1.set(b1.getMemberLocalCenter());
            r2.set(b2.getMemberLocalCenter());
            r1.subLocal(this.m_localAnchor1).negateLocal();
            r2.subLocal(this.m_localAnchor2).negateLocal();
            Mat22.mulToOut(b1.m_xf.R, r1, r1);
            Mat22.mulToOut(b2.m_xf.R, r2, r2);
            p1.set(b1.m_sweep.c);
            p1.addLocal(r1);
            p2.set(b2.m_sweep.c);
            p2.addLocal(r2);
            this.m_u1.set(p1.x - s1.x, p1.y - s1.y);
            this.m_u2.set(p2.x - s2.x, p2.y - s2.y);
            length1 = this.m_u1.length();
            float length2 = this.m_u2.length();
            if (length1 > 0.005f) {
                this.m_u1.mulLocal(1.0f / length1);
            } else {
                this.m_u1.setZero();
            }
            if (length2 > 0.005f) {
                this.m_u2.mulLocal(1.0f / length2);
            } else {
                this.m_u2.setZero();
            }
            float C2 = this.m_constant - length1 - this.m_ratio * length2;
            linearError = MathUtils.max(linearError, -C2);
            C2 = MathUtils.clamp(C2 + 0.005f, -0.2f, 0.0f);
            float impulse2 = -this.m_pulleyMass * C2;
            float oldImpulse = this.m_positionImpulse;
            this.m_positionImpulse = MathUtils.max(0.0f, this.m_positionImpulse + impulse2);
            impulse2 = this.m_positionImpulse - oldImpulse;
            P1.set(this.m_u1);
            P1.mulLocal(-impulse2);
            P2.set(this.m_u2);
            P2.mulLocal(-this.m_ratio * impulse2);
            b1.m_sweep.c.x += b1.m_invMass * P1.x;
            b1.m_sweep.c.y += b1.m_invMass * P1.y;
            b1.m_sweep.a += b1.m_invI * Vec2.cross(r1, P1);
            b2.m_sweep.c.x += b2.m_invMass * P2.x;
            b2.m_sweep.c.y += b2.m_invMass * P2.y;
            b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, P2);
            b1.synchronizeTransform();
            b2.synchronizeTransform();
        }
        if (this.m_limitState1 == LimitState.AT_UPPER_LIMIT) {
            r1.set(b1.getMemberLocalCenter());
            r1.subLocal(this.m_localAnchor1).negateLocal();
            Mat22.mulToOut(b1.m_xf.R, r1, r1);
            p1.set(b1.m_sweep.c);
            p1.addLocal(r1);
            this.m_u1.set(p1.x - s1.x, p1.y - s1.y);
            length1 = this.m_u1.length();
            if (length1 > 0.005f) {
                this.m_u1.mulLocal(1.0f / length1);
            } else {
                this.m_u1.setZero();
            }
            C = this.m_maxLength1 - length1;
            linearError = MathUtils.max(linearError, -C);
            C = MathUtils.clamp(C + 0.005f, -0.2f, 0.0f);
            impulse = -this.m_limitMass1 * C;
            oldLimitPositionImpulse = this.m_limitPositionImpulse1;
            this.m_limitPositionImpulse1 = MathUtils.max(0.0f, this.m_limitPositionImpulse1 + impulse);
            impulse = this.m_limitPositionImpulse1 - oldLimitPositionImpulse;
            P1.set(this.m_u1);
            P1.mulLocal(-impulse);
            b1.m_sweep.c.x += b1.m_invMass * P1.x;
            b1.m_sweep.c.y += b1.m_invMass * P1.y;
            b1.m_sweep.a += b1.m_invI * Vec2.cross(r1, P1);
            b1.synchronizeTransform();
        }
        if (this.m_limitState2 == LimitState.AT_UPPER_LIMIT) {
            r2.set(b2.getMemberLocalCenter());
            r2.subLocal(this.m_localAnchor2).negateLocal();
            Mat22.mulToOut(b2.m_xf.R, r2, r2);
            p2.set(b2.m_sweep.c);
            p2.addLocal(r2);
            this.m_u2.set(p2.x - s2.x, p2.y - s2.y);
            float length2 = this.m_u2.length();
            if (length2 > 0.005f) {
                this.m_u2.mulLocal(1.0f / length2);
            } else {
                this.m_u2.setZero();
            }
            C = this.m_maxLength2 - length2;
            linearError = MathUtils.max(linearError, -C);
            C = MathUtils.clamp(C + 0.005f, -0.2f, 0.0f);
            impulse = -this.m_limitMass2 * C;
            oldLimitPositionImpulse = this.m_limitPositionImpulse2;
            this.m_limitPositionImpulse2 = MathUtils.max(0.0f, this.m_limitPositionImpulse2 + impulse);
            impulse = this.m_limitPositionImpulse2 - oldLimitPositionImpulse;
            P2.set(this.m_u2);
            P2.mulLocal(-impulse);
            b2.m_sweep.c.x += b2.m_invMass * P2.x;
            b2.m_sweep.c.y += b2.m_invMass * P2.y;
            b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, P2);
            b2.synchronizeTransform();
        }
        return linearError < 0.005f;
    }

    @Override
    public Vec2 getAnchor1() {
        return this.m_body1.getWorldLocation(this.m_localAnchor1);
    }

    @Override
    public Vec2 getAnchor2() {
        return this.m_body2.getWorldLocation(this.m_localAnchor2);
    }

    @Override
    public Vec2 getReactionForce() {
        Vec2 F = this.m_u2.mul(this.m_force);
        return F;
    }

    @Override
    public float getReactionTorque() {
        return 0.0f;
    }

    public Vec2 getGroundAnchor1() {
        return this.m_ground.m_xf.position.add(this.m_groundAnchor1);
    }

    public Vec2 getGroundAnchor2() {
        return this.m_ground.m_xf.position.add(this.m_groundAnchor2);
    }

    public float getLength1() {
        Vec2 p = this.m_body1.getWorldLocation(this.m_localAnchor1);
        Vec2 s = this.m_ground.m_xf.position.add(this.m_groundAnchor1);
        Vec2 d = p.subLocal(s);
        return d.length();
    }

    public float getLength2() {
        Vec2 p = this.m_body2.getWorldLocation(this.m_localAnchor2);
        Vec2 s = this.m_ground.m_xf.position.add(this.m_groundAnchor2);
        Vec2 d = p.subLocal(s);
        return d.length();
    }

    public float getRatio() {
        return this.m_ratio;
    }
}

