/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.pooling.TLMat22;
import org.jbox2d.pooling.TLVec2;

public class MouseJoint
extends Joint {
    public final Vec2 m_localAnchor;
    public final Vec2 m_target;
    public final Vec2 m_force = new Vec2();
    public final Mat22 m_mass;
    public final Vec2 m_C;
    public float m_maxForce;
    public float m_beta;
    public float m_gamma;
    private static final TLVec2 tlanchor2 = new TLVec2();
    private static final TLVec2 tlr = new TLVec2();
    private static final TLMat22 tlK1 = new TLMat22();
    private static final TLMat22 tlK2 = new TLMat22();
    private static final TLVec2 tlCdot = new TLVec2();
    private static final TLVec2 tlforce = new TLVec2();
    private static final TLVec2 tloldForce = new TLVec2();
    private static final TLVec2 tlP = new TLVec2();

    public MouseJoint(MouseJointDef def) {
        super(def);
        this.m_target = new Vec2();
        this.m_C = new Vec2();
        this.m_mass = new Mat22();
        this.m_target.set(def.target);
        this.m_localAnchor = XForm.mulTrans(this.m_body2.m_xf, this.m_target);
        this.m_maxForce = def.maxForce;
        float mass = this.m_body2.m_mass;
        float omega = (float)Math.PI * 2 * def.frequencyHz;
        float d = 2.0f * mass * def.dampingRatio * omega;
        float k = mass * omega * omega;
        this.m_gamma = 1.0f / (d + def.timeStep * k);
        this.m_beta = def.timeStep * k / (d + def.timeStep * k);
    }

    public void setTarget(Vec2 target) {
        if (this.m_body2.isSleeping()) {
            this.m_body2.wakeUp();
        }
        this.m_target.set(target);
    }

    @Override
    public Vec2 getAnchor1() {
        return this.m_target;
    }

    @Override
    public Vec2 getAnchor2() {
        Vec2 anchor2 = (Vec2)tlanchor2.get();
        this.m_body2.getWorldLocationToOut(this.m_localAnchor, anchor2);
        return anchor2;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b = this.m_body2;
        Vec2 r = (Vec2)tlr.get();
        Mat22 K1 = (Mat22)tlK1.get();
        Mat22 K2 = (Mat22)tlK2.get();
        r.set(this.m_localAnchor);
        r.subLocal(b.getMemberLocalCenter());
        Mat22.mulToOut(b.m_xf.R, r, r);
        float invMass = b.m_invMass;
        float invI = b.m_invI;
        K1.set(invMass, 0.0f, 0.0f, invMass);
        K2.set(invI * r.y * r.y, -invI * r.x * r.y, -invI * r.x * r.y, invI * r.x * r.x);
        K1.addLocal(K2);
        K1.col1.x += this.m_gamma;
        K1.col2.y += this.m_gamma;
        K1.invertToOut(this.m_mass);
        this.m_C.set(b.m_sweep.c.x + r.x - this.m_target.x, b.m_sweep.c.y + r.y - this.m_target.y);
        b.m_angularVelocity *= 0.98f;
        float Px = step.dt * this.m_force.x;
        float Py = step.dt * this.m_force.y;
        b.m_linearVelocity.x += invMass * Px;
        b.m_linearVelocity.y += invMass * Py;
        b.m_angularVelocity += invI * (r.x * Py - r.y * Px);
    }

    @Override
    public boolean solvePositionConstraints() {
        return true;
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b = this.m_body2;
        Vec2 r = (Vec2)tlr.get();
        Vec2 Cdot = (Vec2)tlCdot.get();
        Vec2 force = (Vec2)tlforce.get();
        Vec2 oldForce = (Vec2)tloldForce.get();
        Vec2 P = (Vec2)tlP.get();
        r.set(this.m_localAnchor);
        r.subLocal(b.getMemberLocalCenter());
        Mat22.mulToOut(b.m_xf.R, r, r);
        Vec2.crossToOut(b.m_angularVelocity, r, Cdot);
        Cdot.addLocal(b.m_linearVelocity);
        force.set(Cdot.x + this.m_beta * step.inv_dt * this.m_C.x + this.m_gamma * step.dt * this.m_force.x, Cdot.y + this.m_beta * step.inv_dt * this.m_C.y + this.m_gamma * step.dt * this.m_force.y);
        Mat22.mulToOut(this.m_mass, force, force);
        force.mulLocal(-step.inv_dt);
        oldForce.set(this.m_force);
        this.m_force.addLocal(force);
        float forceMagnitude = this.m_force.length();
        if (forceMagnitude > this.m_maxForce) {
            this.m_force.mulLocal(this.m_maxForce / forceMagnitude);
        }
        force.set(this.m_force.x - oldForce.x, this.m_force.y - oldForce.y);
        P.x = step.dt * force.x;
        P.y = step.dt * force.y;
        b.m_angularVelocity += b.m_invI * Vec2.cross(r, P);
        b.m_linearVelocity.addLocal(P.mulLocal(b.m_invMass));
    }

    @Override
    public Vec2 getReactionForce() {
        return this.m_force;
    }

    @Override
    public float getReactionTorque() {
        return 0.0f;
    }
}

