/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.TLVec2;

public class DistanceJoint
extends Joint {
    public final Vec2 m_localAnchor1;
    public final Vec2 m_localAnchor2;
    public final Vec2 m_u;
    public float m_impulse;
    public float m_mass;
    public float m_length;
    public float m_frequencyHz;
    public float m_dampingRatio;
    public float m_gamma;
    public float m_bias;
    private static final TLVec2 tlReactionForce = new TLVec2();
    private static final TLVec2 tlr1 = new TLVec2();
    private static final TLVec2 tlr2 = new TLVec2();
    private static final TLVec2 tlP = new TLVec2();
    private static final TLVec2 tld = new TLVec2();
    private static final TLVec2 tlv1 = new TLVec2();
    private static final TLVec2 tlv2 = new TLVec2();

    public DistanceJoint(DistanceJointDef def) {
        super(def);
        this.m_localAnchor1 = def.localAnchor1.clone();
        this.m_localAnchor2 = def.localAnchor2.clone();
        this.m_length = def.length;
        this.m_impulse = 0.0f;
        this.m_u = new Vec2();
        this.m_frequencyHz = def.frequencyHz;
        this.m_dampingRatio = def.dampingRatio;
        this.m_gamma = 0.0f;
        this.m_bias = 0.0f;
        this.m_inv_dt = 0.0f;
    }

    public void setFrequency(float hz) {
        this.m_frequencyHz = hz;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public void setDampingRatio(float damp) {
        this.m_dampingRatio = damp;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    @Override
    public Vec2 getAnchor1() {
        return this.m_body1.getWorldLocation(this.m_localAnchor1);
    }

    @Override
    public Vec2 getAnchor2() {
        return this.m_body2.getWorldLocation(this.m_localAnchor2);
    }

    @Override
    public Vec2 getReactionForce() {
        Vec2 reactionForce = (Vec2)tlReactionForce.get();
        reactionForce.x = this.m_impulse * this.m_u.x;
        reactionForce.y = this.m_impulse * this.m_u.y;
        return reactionForce;
    }

    @Override
    public float getReactionTorque() {
        return 0.0f;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        this.m_inv_dt = step.inv_dt;
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 P = (Vec2)tlP.get();
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Mat22.mulToOut(b1.getMemberXForm().R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
        Mat22.mulToOut(b2.getMemberXForm().R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
        this.m_u.x = b2.m_sweep.c.x + r2.x - b1.m_sweep.c.x - r1.x;
        this.m_u.y = b2.m_sweep.c.y + r2.y - b1.m_sweep.c.y - r1.y;
        float length = this.m_u.length();
        if (length > 0.005f) {
            this.m_u.x *= 1.0f / length;
            this.m_u.y *= 1.0f / length;
        } else {
            this.m_u.set(0.0f, 0.0f);
        }
        float cr1u = Vec2.cross(r1, this.m_u);
        float cr2u = Vec2.cross(r2, this.m_u);
        float invMass = b1.m_invMass + b1.m_invI * cr1u * cr1u + b2.m_invMass + b2.m_invI * cr2u * cr2u;
        assert (invMass > 1.1920929E-7f);
        this.m_mass = 1.0f / invMass;
        if (this.m_frequencyHz > 0.0f) {
            float C = length - this.m_length;
            float omega = (float)Math.PI * 2 * this.m_frequencyHz;
            float d = 2.0f * this.m_mass * this.m_dampingRatio * omega;
            float k = this.m_mass * omega * omega;
            this.m_gamma = 1.0f / (step.dt * (d + step.dt * k));
            this.m_bias = C * step.dt * k * this.m_gamma;
            this.m_mass = 1.0f / (invMass + this.m_gamma);
        }
        if (step.warmStarting) {
            this.m_impulse *= step.dtRatio;
            P.set(this.m_u);
            P.mulLocal(this.m_impulse);
            b1.m_linearVelocity.x -= b1.m_invMass * P.x;
            b1.m_linearVelocity.y -= b1.m_invMass * P.y;
            b1.m_angularVelocity -= b1.m_invI * Vec2.cross(r1, P);
            b2.m_linearVelocity.x += b2.m_invMass * P.x;
            b2.m_linearVelocity.y += b2.m_invMass * P.y;
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P);
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        if (this.m_frequencyHz > 0.0f) {
            return true;
        }
        Vec2 d = (Vec2)tld.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Vec2 r1 = (Vec2)tlr1.get();
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Mat22.mulToOut(b1.getMemberXForm().R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
        Mat22.mulToOut(b2.getMemberXForm().R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
        d.x = b2.m_sweep.c.x + r2.x - b1.m_sweep.c.x - r1.x;
        d.y = b2.m_sweep.c.y + r2.y - b1.m_sweep.c.y - r1.y;
        float length = d.normalize();
        float C = length - this.m_length;
        C = MathUtils.clamp(C, -0.2f, 0.2f);
        float impulse = -this.m_mass * C;
        this.m_u.set(d);
        float Px = impulse * this.m_u.x;
        float Py = impulse * this.m_u.y;
        b1.m_sweep.c.x -= b1.m_invMass * Px;
        b1.m_sweep.c.y -= b1.m_invMass * Py;
        b1.m_sweep.a -= b1.m_invI * (r1.x * Py - r1.y * Px);
        b2.m_sweep.c.x += b2.m_invMass * Px;
        b2.m_sweep.c.y += b2.m_invMass * Py;
        b2.m_sweep.a += b2.m_invI * (r2.x * Py - r2.y * Px);
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        return MathUtils.abs(C) < 0.005f;
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 v1 = (Vec2)tlv1.get();
        Vec2 v2 = (Vec2)tlv2.get();
        Vec2 r1 = (Vec2)tlr1.get();
        Vec2 r2 = (Vec2)tlr2.get();
        Mat22.mulToOut(b1.m_xf.R, this.m_localAnchor1.sub(b1.getMemberLocalCenter()), r1);
        Mat22.mulToOut(b2.m_xf.R, this.m_localAnchor2.sub(b2.getMemberLocalCenter()), r2);
        Vec2.crossToOut(b1.m_angularVelocity, r1, v1);
        Vec2.crossToOut(b2.m_angularVelocity, r2, v2);
        v1.addLocal(b1.m_linearVelocity);
        v2.addLocal(b2.m_linearVelocity);
        float Cdot = Vec2.dot(this.m_u, v2.subLocal(v1));
        float impulse = -this.m_mass * (Cdot + this.m_bias + this.m_gamma * this.m_impulse);
        this.m_impulse += impulse;
        float Px = impulse * this.m_u.x;
        float Py = impulse * this.m_u.y;
        b1.m_linearVelocity.x -= b1.m_invMass * Px;
        b1.m_linearVelocity.y -= b1.m_invMass * Py;
        b1.m_angularVelocity -= b1.m_invI * (r1.x * Py - r1.y * Px);
        b2.m_linearVelocity.x += b2.m_invMass * Px;
        b2.m_linearVelocity.y += b2.m_invMass * Py;
        b2.m_angularVelocity += b2.m_invI * (r2.x * Py - r2.y * Px);
    }
}

