/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.pooling.arrays.Vec2Array;

public class ConstantVolumeJoint
extends Joint {
    Body[] bodies;
    float[] targetLengths;
    float targetVolume;
    World world;
    Vec2[] normals;
    TimeStep m_step;
    private float m_impulse = 0.0f;
    DistanceJoint[] distanceJoints;
    private static final Vec2Array tlD = new Vec2Array();

    public Body[] getBodies() {
        return this.bodies;
    }

    public void inflate(float factor) {
        this.targetVolume *= factor;
    }

    public ConstantVolumeJoint(ConstantVolumeJointDef def) {
        super(def);
        int next;
        if (def.bodies.length <= 2) {
            throw new IllegalArgumentException("You cannot create a constant volume joint with less than three bodies.");
        }
        this.world = def.bodies[0].getWorld();
        this.bodies = def.bodies;
        this.targetLengths = new float[this.bodies.length];
        int i = 0;
        while (i < this.targetLengths.length) {
            float dist;
            next = i == this.targetLengths.length - 1 ? 0 : i + 1;
            this.targetLengths[i] = dist = this.bodies[i].getMemberWorldCenter().sub(this.bodies[next].getMemberWorldCenter()).length();
            ++i;
        }
        this.targetVolume = this.getArea();
        this.distanceJoints = new DistanceJoint[this.bodies.length];
        i = 0;
        while (i < this.targetLengths.length) {
            next = i == this.targetLengths.length - 1 ? 0 : i + 1;
            DistanceJointDef djd = new DistanceJointDef();
            djd.frequencyHz = def.frequencyHz;
            djd.dampingRatio = def.dampingRatio;
            djd.initialize(this.bodies[i], this.bodies[next], this.bodies[i].getMemberWorldCenter(), this.bodies[next].getMemberWorldCenter());
            this.distanceJoints[i] = (DistanceJoint)this.world.createJoint(djd);
            ++i;
        }
        this.normals = new Vec2[this.bodies.length];
        i = 0;
        while (i < this.normals.length) {
            this.normals[i] = new Vec2();
            ++i;
        }
        this.m_body1 = this.bodies[0];
        this.m_body2 = this.bodies[1];
        this.m_collideConnected = false;
    }

    @Override
    public void destructor() {
        int i = 0;
        while (i < this.distanceJoints.length) {
            this.world.destroyJoint(this.distanceJoints[i]);
            ++i;
        }
    }

    private float getArea() {
        float area = 0.0f;
        area += this.bodies[this.bodies.length - 1].getMemberWorldCenter().x * this.bodies[0].getMemberWorldCenter().y - this.bodies[0].getMemberWorldCenter().x * this.bodies[this.bodies.length - 1].getMemberWorldCenter().y;
        int i = 0;
        while (i < this.bodies.length - 1) {
            area += this.bodies[i].getMemberWorldCenter().x * this.bodies[i + 1].getMemberWorldCenter().y - this.bodies[i + 1].getMemberWorldCenter().x * this.bodies[i].getMemberWorldCenter().y;
            ++i;
        }
        return area *= 0.5f;
    }

    public boolean constrainEdges(TimeStep step) {
        float perimeter = 0.0f;
        int i = 0;
        while (i < this.bodies.length) {
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            float dx = this.bodies[next].getMemberWorldCenter().x - this.bodies[i].getMemberWorldCenter().x;
            float dy = this.bodies[next].getMemberWorldCenter().y - this.bodies[i].getMemberWorldCenter().y;
            float dist = MathUtils.sqrt(dx * dx + dy * dy);
            if (dist < 1.1920929E-7f) {
                dist = 1.0f;
            }
            this.normals[i].x = dy / dist;
            this.normals[i].y = -dx / dist;
            perimeter += dist;
            ++i;
        }
        float deltaArea = this.targetVolume - this.getArea();
        float toExtrude = 0.5f * deltaArea / perimeter;
        boolean done = true;
        int i2 = 0;
        while (i2 < this.bodies.length) {
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            Vec2 delta = new Vec2(toExtrude * (this.normals[i2].x + this.normals[next].x), toExtrude * (this.normals[i2].y + this.normals[next].y));
            float norm = delta.length();
            if (norm > 0.2f) {
                delta.mulLocal(0.2f / norm);
            }
            if (norm > 0.005f) {
                done = false;
            }
            this.bodies[next].m_sweep.c.x += delta.x;
            this.bodies[next].m_sweep.c.y += delta.y;
            this.bodies[next].synchronizeTransform();
            ++i2;
        }
        return done;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        this.m_step = step;
        Vec2[] d = (Vec2[])tlD.get(this.bodies.length);
        int i = 0;
        while (i < this.bodies.length) {
            int prev = i == 0 ? this.bodies.length - 1 : i - 1;
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            d[i].set(this.bodies[next].getMemberWorldCenter());
            d[i].subLocal(this.bodies[prev].getMemberWorldCenter());
            ++i;
        }
        if (step.warmStarting) {
            this.m_impulse *= step.dtRatio;
            i = 0;
            while (i < this.bodies.length) {
                this.bodies[i].m_linearVelocity.x += this.bodies[i].m_invMass * d[i].y * 0.5f * this.m_impulse;
                this.bodies[i].m_linearVelocity.y += this.bodies[i].m_invMass * -d[i].x * 0.5f * this.m_impulse;
                ++i;
            }
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        return this.constrainEdges(this.m_step);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        float crossMassSum = 0.0f;
        float dotMassSum = 0.0f;
        Vec2[] d = (Vec2[])tlD.get(this.bodies.length);
        int i = 0;
        while (i < this.bodies.length) {
            int prev = i == 0 ? this.bodies.length - 1 : i - 1;
            int next = i == this.bodies.length - 1 ? 0 : i + 1;
            d[i].set(this.bodies[next].getMemberWorldCenter());
            d[i].subLocal(this.bodies[prev].getMemberWorldCenter());
            dotMassSum += d[i].lengthSquared() / this.bodies[i].getMass();
            crossMassSum += Vec2.cross(this.bodies[i].getLinearVelocity(), d[i]);
            ++i;
        }
        float lambda = -2.0f * crossMassSum / dotMassSum;
        this.m_impulse += lambda;
        int i2 = 0;
        while (i2 < this.bodies.length) {
            this.bodies[i2].m_linearVelocity.x += this.bodies[i2].m_invMass * d[i2].y * 0.5f * lambda;
            this.bodies[i2].m_linearVelocity.y += this.bodies[i2].m_invMass * -d[i2].x * 0.5f * lambda;
            ++i2;
        }
    }

    @Override
    public Vec2 getAnchor1() {
        return null;
    }

    @Override
    public Vec2 getAnchor2() {
        return null;
    }

    @Override
    public Vec2 getReactionForce() {
        return null;
    }

    @Override
    public float getReactionTorque() {
        return 0.0f;
    }
}

