/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.controllers;

import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.DebugDraw;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.controllers.BuoyancyControllerDef;
import org.jbox2d.dynamics.controllers.Controller;
import org.jbox2d.dynamics.controllers.ControllerEdge;

public class BuoyancyController
extends Controller {
    public Vec2 normal = new Vec2();
    public float offset;
    public float density;
    public Vec2 velocity = new Vec2();
    public float linearDrag;
    public float angularDrag;
    public boolean useDensity;
    public boolean useWorldGravity;
    public Vec2 gravity = new Vec2();

    protected BuoyancyController(BuoyancyControllerDef def) {
        super(def);
        this.normal = def.normal.clone();
        this.offset = def.offset;
        this.density = def.density;
        this.velocity = def.velocity.clone();
        this.linearDrag = def.linearDrag;
        this.angularDrag = def.angularDrag;
        this.useDensity = def.useDensity;
        this.useWorldGravity = def.useWorldGravity;
        this.gravity = def.gravity.clone();
    }

    @Override
    public void step(TimeStep step) {
        if (this.m_bodyList == null) {
            return;
        }
        if (this.useWorldGravity) {
            this.gravity = this.m_world.getGravity();
        }
        ControllerEdge i = this.m_bodyList;
        while (i != null) {
            Body body = i.body;
            if (!body.isSleeping()) {
                Vec2 areac = new Vec2(0.0f, 0.0f);
                Vec2 massc = new Vec2(0.0f, 0.0f);
                float area = 0.0f;
                float mass = 0.0f;
                Shape shape = body.getShapeList();
                while (shape != null) {
                    Vec2 sc = new Vec2(0.0f, 0.0f);
                    float sarea = shape.computeSubmergedArea(this.normal, this.offset, sc);
                    area += sarea;
                    areac.x += sarea * sc.x;
                    areac.y += sarea * sc.y;
                    float shapeDensity = 0.0f;
                    shapeDensity = this.useDensity ? shape.getDensity() : 1.0f;
                    mass += sarea * shapeDensity;
                    massc.x += sarea * sc.x * shapeDensity;
                    massc.y += sarea * sc.y * shapeDensity;
                    shape = shape.getNext();
                }
                areac.x /= area;
                areac.y /= area;
                massc.x /= mass;
                massc.y /= mass;
                if (!(area < 1.1920929E-7f)) {
                    Vec2 buoyancyForce = this.gravity.mul(-this.density * area);
                    body.applyForce(buoyancyForce, massc);
                    Vec2 dragForce = body.getLinearVelocityFromWorldPoint(areac).sub(this.velocity);
                    dragForce.mulLocal(-this.linearDrag * area);
                    body.applyForce(dragForce, areac);
                    body.applyTorque(-body.getInertia() / body.getMass() * area * body.getAngularVelocity() * this.angularDrag);
                }
            }
            i = i.nextBody;
        }
    }

    @Override
    public void draw(DebugDraw debugDraw) {
        float r = 1000.0f;
        Vec2 p1 = this.normal.mul(this.offset).addLocal(Vec2.cross(this.normal, r));
        Vec2 p2 = this.normal.mul(this.offset).subLocal(Vec2.cross(this.normal, r));
        Color3f color = new Color3f(0.0f, 0.0f, 204.0f);
        Vec2[] vertices = new Vec2[]{p1, p2, p2.sub(this.normal.mul(r)), p1.sub(this.normal.mul(r))};
        debugDraw.drawSolidPolygon(vertices, 4, color);
    }
}

