/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;
import org.jbox2d.pooling.SingletonPool;
import org.jbox2d.pooling.TLContactPoint;
import org.jbox2d.pooling.TLManifold;
import org.jbox2d.pooling.TLVec2;

public class PolyContact
extends Contact
implements ContactCreateFcn {
    public final Manifold m_manifold;
    public final ArrayList<Manifold> manifoldList = new ArrayList();
    private static final TLManifold tlm0 = new TLManifold();
    private static final TLVec2 tlV1 = new TLVec2();
    private static final TLContactPoint tlCp = new TLContactPoint();

    public PolyContact(Shape s1, Shape s2) {
        super(s1, s2);
        assert (this.m_shape1.getType() == ShapeType.POLYGON_SHAPE);
        assert (this.m_shape2.getType() == ShapeType.POLYGON_SHAPE);
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
        this.manifoldList.add(this.m_manifold);
    }

    public PolyContact() {
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
        this.manifoldList.add(this.m_manifold);
    }

    @Override
    public Contact clone() {
        PolyContact newC = new PolyContact(this.m_shape1, this.m_shape2);
        if (this.m_manifold != null) {
            newC.m_manifold.set(this.m_manifold);
        }
        newC.m_manifoldCount = this.m_manifoldCount;
        newC.m_world = this.m_world;
        newC.m_toi = this.m_toi;
        newC.m_prev = this.m_prev;
        newC.m_next = this.m_next;
        newC.m_node1.set(this.m_node1);
        newC.m_node2.set(this.m_node2);
        newC.m_friction = this.m_friction;
        newC.m_restitution = this.m_restitution;
        newC.m_flags = this.m_flags;
        return newC;
    }

    @Override
    public List<Manifold> getManifolds() {
        return this.manifoldList;
    }

    @Override
    public Contact create(Shape shape1, Shape shape2) {
        return new PolyContact(shape1, shape2);
    }

    public void dumpManifoldPoints() {
        int i = 0;
        while (i < this.m_manifold.pointCount) {
            ManifoldPoint mp = this.m_manifold.points[i];
            System.out.println("Manifold point dump: " + mp.normalImpulse + " " + mp.tangentImpulse);
            ++i;
        }
    }

    @Override
    public void evaluate(ContactListener listener) {
        int i;
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = (Manifold)tlm0.get();
        Vec2 v1 = (Vec2)tlV1.get();
        ContactPoint cp = (ContactPoint)tlCp.get();
        m0.set(this.m_manifold);
        SingletonPool.getCollidePoly().collidePolygons(this.m_manifold, (PolygonShape)this.m_shape1, b1.getMemberXForm(), (PolygonShape)this.m_shape2, b2.getMemberXForm());
        boolean[] persisted = new boolean[2];
        cp.shape1 = this.m_shape1;
        cp.shape2 = this.m_shape2;
        cp.friction = this.m_friction;
        cp.restitution = this.m_restitution;
        if (this.m_manifold.pointCount > 0) {
            i = 0;
            while (i < this.m_manifold.pointCount) {
                ManifoldPoint mp = this.m_manifold.points[i];
                mp.normalImpulse = 0.0f;
                mp.tangentImpulse = 0.0f;
                boolean found = false;
                ContactID id = mp.id;
                int j = 0;
                while (j < m0.pointCount) {
                    if (!persisted[j]) {
                        ManifoldPoint mp0 = m0.points[j];
                        if (mp0.id.isEqual(id)) {
                            persisted[j] = true;
                            mp.normalImpulse = mp0.normalImpulse;
                            mp.tangentImpulse = mp0.tangentImpulse;
                            found = true;
                            if (listener == null) break;
                            b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                            b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                            b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                            cp.velocity.subLocal(v1);
                            cp.normal.set(this.m_manifold.normal);
                            cp.separation = mp.separation;
                            cp.id.set(id);
                            listener.persist(cp);
                            break;
                        }
                    }
                    ++j;
                }
                if (!found && listener != null) {
                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                    cp.velocity.subLocal(v1);
                    cp.normal.set(this.m_manifold.normal);
                    cp.separation = mp.separation;
                    cp.id.set(id);
                    listener.add(cp);
                }
                ++i;
            }
            this.m_manifoldCount = 1;
        } else {
            this.m_manifoldCount = 0;
        }
        if (listener == null) {
            return;
        }
        i = 0;
        while (i < m0.pointCount) {
            if (!persisted[i]) {
                ManifoldPoint mp0 = m0.points[i];
                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                cp.velocity.subLocal(v1);
                cp.normal.set(this.m_manifold.normal);
                cp.separation = mp0.separation;
                cp.id.set(mp0.id);
                listener.remove(cp);
            }
            ++i;
        }
    }
}

