/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;
import org.jbox2d.pooling.SingletonPool;
import org.jbox2d.pooling.TLContactPoint;
import org.jbox2d.pooling.TLManifold;
import org.jbox2d.pooling.TLVec2;

public class CircleContact
extends Contact
implements ContactCreateFcn {
    public final Manifold m_manifold;
    public final ArrayList<Manifold> manifoldList = new ArrayList();
    private static final TLManifold tlm0 = new TLManifold();
    private static final TLVec2 tlV1 = new TLVec2();
    private static final TLContactPoint tlCp = new TLContactPoint();

    @Override
    public Contact create(Shape shape1, Shape shape2) {
        return new CircleContact(shape1, shape2);
    }

    public static void Destroy(Contact contact) {
        ((CircleContact)contact).destructor();
    }

    @Override
    public CircleContact clone() {
        return this;
    }

    public CircleContact() {
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
        this.manifoldList.add(this.m_manifold);
    }

    public CircleContact(Shape shape1, Shape shape2) {
        super(shape1, shape2);
        this.m_manifold = new Manifold();
        this.manifoldList.add(this.m_manifold);
        assert (this.m_shape1.getType() == ShapeType.CIRCLE_SHAPE);
        assert (this.m_shape2.getType() == ShapeType.CIRCLE_SHAPE);
        this.m_manifold.pointCount = 0;
        this.m_manifold.points[0].normalImpulse = 0.0f;
        this.m_manifold.points[0].tangentImpulse = 0.0f;
        this.m_manifold.points[0].localPoint1.setZero();
        this.m_manifold.points[0].localPoint2.setZero();
    }

    public void destructor() {
    }

    @Override
    public void evaluate(ContactListener listener) {
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = (Manifold)tlm0.get();
        Vec2 v1 = (Vec2)tlV1.get();
        ContactPoint cp = (ContactPoint)tlCp.get();
        m0.set(this.m_manifold);
        SingletonPool.getCollideCircle().collideCircles(this.m_manifold, (CircleShape)this.m_shape1, b1.m_xf, (CircleShape)this.m_shape2, b2.m_xf);
        cp.shape1 = this.m_shape1;
        cp.shape2 = this.m_shape2;
        cp.friction = this.m_friction;
        cp.restitution = this.m_restitution;
        if (this.m_manifold.pointCount > 0) {
            this.m_manifoldCount = 1;
            ManifoldPoint mp = this.m_manifold.points[0];
            if (m0.pointCount == 0) {
                mp.normalImpulse = 0.0f;
                mp.tangentImpulse = 0.0f;
                if (listener != null) {
                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                    cp.velocity.subLocal(v1);
                    cp.normal.set(this.m_manifold.normal);
                    cp.separation = mp.separation;
                    cp.id.set(mp.id);
                    listener.add(cp);
                }
            } else {
                ManifoldPoint mp0 = m0.points[0];
                mp.normalImpulse = mp0.normalImpulse;
                mp.tangentImpulse = mp0.tangentImpulse;
                if (listener != null) {
                    b1.getWorldLocationToOut(mp.localPoint1, cp.position);
                    b1.getLinearVelocityFromLocalPointToOut(mp.localPoint1, v1);
                    b2.getLinearVelocityFromLocalPointToOut(mp.localPoint2, cp.velocity);
                    cp.velocity.subLocal(v1);
                    cp.normal.set(this.m_manifold.normal);
                    cp.separation = mp.separation;
                    cp.id.set(mp.id);
                    listener.persist(cp);
                }
            }
        } else {
            this.m_manifoldCount = 0;
            if (m0.pointCount > 0 && listener != null) {
                ManifoldPoint mp0 = m0.points[0];
                b1.getWorldLocationToOut(mp0.localPoint1, cp.position);
                b1.getLinearVelocityFromLocalPointToOut(mp0.localPoint1, v1);
                b2.getLinearVelocityFromLocalPointToOut(mp0.localPoint2, cp.velocity);
                cp.velocity.subLocal(v1);
                cp.normal.set(m0.normal);
                cp.separation = mp0.separation;
                cp.id.set(mp0.id);
                listener.remove(cp);
            }
        }
    }

    @Override
    public List<Manifold> getManifolds() {
        return this.manifoldList;
    }
}

