/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import java.util.ArrayList;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.BroadPhase;
import org.jbox2d.collision.OBB;
import org.jbox2d.collision.Pair;
import org.jbox2d.collision.Proxy;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SegmentCollide;
import org.jbox2d.collision.SortKeyFunc;
import org.jbox2d.collision.TOI;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PointShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BoundaryListener;
import org.jbox2d.dynamics.ContactFilter;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.ContactManager;
import org.jbox2d.dynamics.DebugDraw;
import org.jbox2d.dynamics.DestructionListener;
import org.jbox2d.dynamics.Island;
import org.jbox2d.dynamics.Steppable;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.controllers.Controller;
import org.jbox2d.dynamics.controllers.ControllerDef;
import org.jbox2d.dynamics.controllers.ControllerEdge;
import org.jbox2d.dynamics.joints.ConstantVolumeJoint;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.pooling.TLTimeStep;
import org.jbox2d.pooling.stacks.IslandStack;
import org.jbox2d.pooling.stacks.TimeStepStack;

public class World {
    boolean m_lock = false;
    BroadPhase m_broadPhase;
    ContactManager m_contactManager;
    Body m_bodyList = null;
    Contact m_contactList = null;
    Joint m_jointList = null;
    Controller m_controllerList = null;
    int m_controllerCount = 0;
    int m_bodyCount = 0;
    int m_contactCount = 0;
    int m_jointCount = 0;
    Vec2 m_gravity;
    boolean m_allowSleep;
    Body m_groundBody;
    int m_positionIterationCount;
    boolean m_positionCorrection = true;
    boolean m_warmStarting = true;
    boolean m_continuousPhysics = true;
    DestructionListener m_destructionListener = null;
    BoundaryListener m_boundaryListener = null;
    ContactFilter m_contactFilter;
    ContactListener m_contactListener = null;
    DebugDraw m_debugDraw = null;
    boolean m_drawDebugData;
    private float m_inv_dt0 = 0.0f;
    private final ArrayList<Steppable> postStepList;
    private boolean autoDebugDraw = true;
    private static final TLTimeStep tlStep = new TLTimeStep();
    private static final IslandStack islands = new IslandStack();
    private static final TimeStepStack steps = new TimeStepStack();
    private static Integer LIQUID_INT = new Integer(12345);
    private float liquidLength = 0.12f;
    private float averageLinearVel = -1.0f;
    private final Color3f coreColor = new Color3f(229.5f, 153.0f, 153.0f);
    private final Vec2 drawingCenter = new Vec2();
    private final Vec2 liquidOffset = new Vec2();
    private final Vec2 circCenterMoved = new Vec2();
    private final Color3f liquidColor = new Color3f(80.0f, 80.0f, 255.0f);
    private final Vec2 segLeft = new Vec2();
    private final Vec2 segRight = new Vec2();
    private final Color3f jointColor = new Color3f(127.5f, 204.0f, 204.0f);
    private final Color3f staticColor = new Color3f(127.5f, 229.5f, 127.5f);
    private final Color3f sleepingColor = new Color3f(127.5f, 127.5f, 229.5f);
    private final Color3f activeColor = new Color3f(229.5f, 229.5f, 229.5f);
    private final Color3f pairColor = new Color3f(229.5f, 229.5f, 76.5f);
    private final Color3f aabbColor = new Color3f(229.5f, 76.5f, 229.5f);
    private final Color3f obbColor = new Color3f(0.5f, 0.3f, 0.5f);
    private final Color3f worldColor = new Color3f(76.5f, 229.5f, 229.5f);
    private final AABB pairB1 = new AABB();
    private final AABB pairB2 = new AABB();
    private final Vec2 pairX1 = new Vec2();
    private final Vec2 pairX2 = new Vec2();
    private final AABB aabbB = new AABB();
    private final Vec2[] cornerVecs = new Vec2[]{new Vec2(), new Vec2(), new Vec2(), new Vec2()};
    Segment m_raycastSegment;
    Vec2 m_raycastNormal;
    Object m_raycastUserData;
    boolean m_raycastSolidShape;
    private SortKeyFunc raycastSortKey = new SortKeyFunc(){

        @Override
        public float apply(Object shape) {
            return World.this.raycastSortKeyFunc(shape);
        }
    };

    public boolean isAutoDebugDraw() {
        return this.autoDebugDraw;
    }

    public void setAutoDebugDraw(boolean autoDebugDraw) {
        this.autoDebugDraw = autoDebugDraw;
    }

    public void setDrawDebugData(boolean tf) {
        this.m_drawDebugData = tf;
    }

    public boolean isDrawingDebugData() {
        return this.m_drawDebugData;
    }

    public int getBodyCount() {
        return this.m_bodyCount;
    }

    public int getJointCount() {
        return this.m_jointCount;
    }

    public int getContactCount() {
        return this.m_contactCount;
    }

    public void setGravity(Vec2 gravity) {
        this.m_gravity = gravity;
    }

    public Vec2 getGravity() {
        return this.m_gravity.clone();
    }

    public Body getGroundBody() {
        return this.m_groundBody;
    }

    public Body getBodyList() {
        return this.m_bodyList;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public World(AABB worldAABB, Vec2 gravity, boolean doSleep) {
        this.m_contactFilter = ContactFilter.DEFAULT_FILTER;
        this.m_allowSleep = doSleep;
        this.m_gravity = gravity;
        this.m_contactManager = new ContactManager();
        this.m_contactManager.m_world = this;
        this.m_broadPhase = new BroadPhase(worldAABB, this.m_contactManager);
        BodyDef bd = new BodyDef();
        this.m_groundBody = this.createBody(bd);
        this.postStepList = new ArrayList();
        this.setDrawDebugData(true);
    }

    public void setDestructionListener(DestructionListener listener) {
        this.m_destructionListener = listener;
    }

    public void setBoundaryListener(BoundaryListener listener) {
        this.m_boundaryListener = listener;
    }

    public void setContactListener(ContactListener listener) {
        this.m_contactListener = listener;
    }

    public void setContactFilter(ContactFilter filter) {
        this.m_contactFilter = filter;
    }

    public void setDebugDraw(DebugDraw debugDraw) {
        this.m_debugDraw = debugDraw;
    }

    public DebugDraw getDebugDraw() {
        return this.m_debugDraw;
    }

    public Body createBody(BodyDef def) {
        assert (!this.m_lock);
        Body b = new Body(def, this);
        b.m_prev = null;
        b.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = b;
        }
        this.m_bodyList = b;
        ++this.m_bodyCount;
        return b;
    }

    public void destroyBody(Body b) {
        assert (this.m_bodyCount > 0);
        assert (!this.m_lock);
        JointEdge jn = b.m_jointList;
        while (jn != null) {
            JointEdge jn0 = jn;
            jn = jn.next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(jn0.joint);
            }
            this.destroyJoint(jn0.joint);
        }
        ControllerEdge ce = b.m_controllerList;
        while (ce != null) {
            ControllerEdge ce0 = ce;
            ce = ce.nextController;
            ce0.controller.removeBody(b);
        }
        Shape s = b.m_shapeList;
        while (s != null) {
            Shape s0 = s;
            s = s.m_next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(s0);
            }
            s0.destroyProxy(this.m_broadPhase);
            Shape.destroy(s0);
        }
        if (b.m_prev != null) {
            b.m_prev.m_next = b.m_next;
        }
        if (b.m_next != null) {
            b.m_next.m_prev = b.m_prev;
        }
        if (b == this.m_bodyList) {
            this.m_bodyList = b.m_next;
        }
        --this.m_bodyCount;
    }

    public Joint createJoint(JointDef def) {
        assert (!this.m_lock);
        Joint j = Joint.create(def);
        j.m_prev = null;
        j.m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = j;
        }
        this.m_jointList = j;
        ++this.m_jointCount;
        j.m_node1.joint = j;
        j.m_node1.other = j.m_body2;
        j.m_node1.prev = null;
        j.m_node1.next = j.m_body1.m_jointList;
        if (j.m_body1.m_jointList != null) {
            j.m_body1.m_jointList.prev = j.m_node1;
        }
        j.m_body1.m_jointList = j.m_node1;
        j.m_node2.joint = j;
        j.m_node2.other = j.m_body1;
        j.m_node2.prev = null;
        j.m_node2.next = j.m_body2.m_jointList;
        if (j.m_body2.m_jointList != null) {
            j.m_body2.m_jointList.prev = j.m_node2;
        }
        j.m_body2.m_jointList = j.m_node2;
        if (!def.collideConnected) {
            Body b = def.body1.m_shapeCount < def.body2.m_shapeCount ? def.body1 : def.body2;
            Shape s = b.m_shapeList;
            while (s != null) {
                s.refilterProxy(this.m_broadPhase, b.getMemberXForm());
                s = s.m_next;
            }
        }
        return j;
    }

    public void destroyJoint(Joint j) {
        assert (!this.m_lock);
        boolean collideConnected = j.m_collideConnected;
        if (j.m_prev != null) {
            j.m_prev.m_next = j.m_next;
        }
        if (j.m_next != null) {
            j.m_next.m_prev = j.m_prev;
        }
        if (j == this.m_jointList) {
            this.m_jointList = j.m_next;
        }
        Body body1 = j.m_body1;
        Body body2 = j.m_body2;
        body1.wakeUp();
        body2.wakeUp();
        if (j.m_node1.prev != null) {
            j.m_node1.prev.next = j.m_node1.next;
        }
        if (j.m_node1.next != null) {
            j.m_node1.next.prev = j.m_node1.prev;
        }
        if (j.m_node1 == body1.m_jointList) {
            body1.m_jointList = j.m_node1.next;
        }
        j.m_node1.prev = null;
        j.m_node1.next = null;
        if (j.m_node2.prev != null) {
            j.m_node2.prev.next = j.m_node2.next;
        }
        if (j.m_node2.next != null) {
            j.m_node2.next.prev = j.m_node2.prev;
        }
        if (j.m_node2 == body2.m_jointList) {
            body2.m_jointList = j.m_node2.next;
        }
        j.m_node2.prev = null;
        j.m_node2.next = null;
        Joint.destroy(j);
        assert (this.m_jointCount > 0);
        --this.m_jointCount;
        if (!collideConnected) {
            Body b = body1.m_shapeCount < body2.m_shapeCount ? body1 : body2;
            Shape s = b.m_shapeList;
            while (s != null) {
                s.refilterProxy(this.m_broadPhase, b.getMemberXForm());
                s = s.m_next;
            }
        }
    }

    public Controller createController(ControllerDef def) {
        Controller controller = def.create();
        controller.m_next = this.m_controllerList;
        controller.m_prev = null;
        if (this.m_controllerList != null) {
            this.m_controllerList.m_prev = controller;
        }
        this.m_controllerList = controller;
        ++this.m_controllerCount;
        controller.m_world = this;
        return controller;
    }

    public void destroyController(Controller controller) {
        assert (this.m_controllerCount > 0);
        if (controller.m_next != null) {
            controller.m_next.m_prev = controller.m_prev;
        }
        if (controller.m_prev != null) {
            controller.m_prev.m_next = controller.m_next;
        }
        if (controller == this.m_controllerList) {
            this.m_controllerList = controller.m_next;
        }
        --this.m_controllerCount;
    }

    public void step(float dt, int iterations) {
        this.m_lock = true;
        TimeStep step = (TimeStep)tlStep.get();
        step.dt = dt;
        step.maxIterations = iterations;
        step.inv_dt = dt > 0.0f ? 1.0f / dt : 0.0f;
        step.dtRatio = this.m_inv_dt0 * dt;
        step.positionCorrection = this.m_positionCorrection;
        step.warmStarting = this.m_warmStarting;
        this.m_contactManager.collide();
        if (step.dt > 0.0f) {
            this.solve(step);
        }
        if (this.m_continuousPhysics && step.dt > 0.0f) {
            this.solveTOI(step);
        }
        if (this.autoDebugDraw) {
            this.drawDebugData();
        }
        this.m_inv_dt0 = step.inv_dt;
        this.m_lock = false;
        this.postStep(dt, iterations);
    }

    private void postStep(float dt, int iterations) {
        for (Steppable s : this.postStepList) {
            s.step(dt, iterations);
        }
    }

    public void registerPostStep(Steppable s) {
        this.postStepList.add(s);
    }

    public void unregisterPostStep(Steppable s) {
        if (this.postStepList != null) {
            this.postStepList.remove(s);
        }
    }

    public void refilter(Shape shape) {
        shape.refilterProxy(this.m_broadPhase, shape.getBody().getMemberXForm());
    }

    public Shape[] query(AABB aabb, int maxCount) {
        Object[] objs = this.m_broadPhase.query(aabb, maxCount);
        Shape[] ret = new Shape[objs.length];
        System.arraycopy(objs, 0, ret, 0, objs.length);
        return ret;
    }

    public void solve(TimeStep step) {
        this.m_positionIterationCount = 0;
        Controller controller = this.m_controllerList;
        while (controller != null) {
            controller.step(step);
            controller = controller.m_next;
        }
        Island island = (Island)islands.get();
        island.init(this.m_bodyCount, this.m_contactCount, this.m_jointCount, this.m_contactListener);
        Body b = this.m_bodyList;
        while (b != null) {
            b.m_flags &= 0xFFFFFFFB;
            b = b.m_next;
        }
        Contact c = this.m_contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFFB;
            c = c.m_next;
        }
        Joint j = this.m_jointList;
        while (j != null) {
            j.m_islandFlag = false;
            j = j.m_next;
        }
        int stackSize = this.m_bodyCount;
        Body[] stack = new Body[stackSize];
        Body seed = this.m_bodyList;
        while (seed != null) {
            if ((seed.m_flags & 0xE) <= 0 && !seed.isStatic()) {
                island.clear();
                int stackCount = 0;
                stack[stackCount++] = seed;
                seed.m_flags |= 4;
                while (stackCount > 0) {
                    Body other;
                    Body b2 = stack[--stackCount];
                    island.add(b2);
                    b2.m_flags &= 0xFFFFFFF7;
                    if (b2.isStatic()) continue;
                    ContactEdge cn = b2.m_contactList;
                    while (cn != null) {
                        if ((cn.contact.m_flags & 5) <= 0 && cn.contact.getManifoldCount() != 0) {
                            island.add(cn.contact);
                            cn.contact.m_flags |= 4;
                            other = cn.other;
                            if ((other.m_flags & 4) <= 0) {
                                assert (stackCount < stackSize);
                                stack[stackCount++] = other;
                                other.m_flags |= 4;
                            }
                        }
                        cn = cn.next;
                    }
                    JointEdge jn = b2.m_jointList;
                    while (jn != null) {
                        if (!jn.joint.m_islandFlag) {
                            island.add(jn.joint);
                            jn.joint.m_islandFlag = true;
                            other = jn.other;
                            if ((other.m_flags & 4) <= 0) {
                                assert (stackCount < stackSize);
                                stack[stackCount++] = other;
                                other.m_flags |= 4;
                            }
                        }
                        jn = jn.next;
                    }
                }
                island.solve(step, this.m_gravity, this.m_positionCorrection, this.m_allowSleep);
                this.m_positionIterationCount = MathUtils.max(this.m_positionIterationCount, Island.m_positionIterationCount);
                int i = 0;
                while (i < island.m_bodyCount) {
                    Body b3 = island.m_bodies[i];
                    if (b3.isStatic()) {
                        b3.m_flags &= 0xFFFFFFFB;
                    }
                    ++i;
                }
            }
            seed = seed.m_next;
        }
        Body b4 = this.m_bodyList;
        while (b4 != null) {
            boolean inRange;
            if ((b4.m_flags & 0xA) == 0 && !b4.isStatic() && !(inRange = b4.synchronizeShapes()) && this.m_boundaryListener != null) {
                this.m_boundaryListener.violation(b4);
            }
            b4 = b4.getNext();
        }
        this.m_broadPhase.commit();
        islands.recycle(island);
    }

    public void solveTOI(TimeStep step) {
        Island island = (Island)islands.get();
        island.init(this.m_bodyCount, Settings.maxTOIContactsPerIsland, Settings.maxTOIJointsPerIsland, this.m_contactListener);
        int queueCapacity = this.m_bodyCount;
        Body[] queue = new Body[queueCapacity];
        Body b = this.m_bodyList;
        while (b != null) {
            b.m_flags &= 0xFFFFFFFB;
            b.m_sweep.t0 = 0.0f;
            b = b.m_next;
        }
        Contact c = this.m_contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFF3;
            c = c.m_next;
        }
        Joint j = this.m_jointList;
        while (j != null) {
            j.m_islandFlag = false;
            j = j.m_next;
        }
        while (true) {
            Contact minContact = null;
            float minTOI = 1.0f;
            Contact c2 = this.m_contactList;
            while (c2 != null) {
                block34: {
                    float toi;
                    block36: {
                        block35: {
                            if ((c2.m_flags & 3) != 0) break block34;
                            toi = 1.0f;
                            if ((c2.m_flags & 8) == 0) break block35;
                            toi = c2.m_toi;
                            break block36;
                        }
                        Shape s1 = c2.getShape1();
                        Shape s2 = c2.getShape2();
                        Body b1 = s1.getBody();
                        Body b2 = s2.getBody();
                        if (!(!b1.isStatic() && !b1.isSleeping() || !b2.isStatic() && !b2.isSleeping())) break block34;
                        float t0 = b1.m_sweep.t0;
                        if (b1.m_sweep.t0 < b2.m_sweep.t0) {
                            t0 = b2.m_sweep.t0;
                            b1.m_sweep.advance(t0);
                        } else if (b2.m_sweep.t0 < b1.m_sweep.t0) {
                            t0 = b1.m_sweep.t0;
                            b2.m_sweep.advance(t0);
                        }
                        assert (t0 < 1.0f);
                        toi = TOI.timeOfImpact(c2.m_shape1, b1.m_sweep, c2.m_shape2, b2.m_sweep);
                        assert (0.0f <= toi && toi <= 1.0f);
                        if (toi > 0.0f && toi < 1.0f) {
                            toi = MathUtils.min((1.0f - toi) * t0 + toi, 1.0f);
                        }
                        c2.m_toi = toi;
                        c2.m_flags |= 8;
                    }
                    if (1.1920929E-7f < toi && toi < minTOI) {
                        minContact = c2;
                        minTOI = toi;
                    }
                }
                c2 = c2.m_next;
            }
            if (minContact == null || 0.9999881f < minTOI) break;
            Shape s1 = minContact.getShape1();
            Shape s2 = minContact.getShape2();
            Body b1 = s1.getBody();
            Body b2 = s2.getBody();
            b1.advance(minTOI);
            b2.advance(minTOI);
            minContact.update(this.m_contactListener);
            minContact.m_flags &= 0xFFFFFFF7;
            if (minContact.getManifoldCount() == 0) continue;
            Body seed = b1;
            if (seed.isStatic()) {
                seed = b2;
            }
            island.clear();
            int queueStart = 0;
            int queueSize = 0;
            queue[queueStart + queueSize++] = seed;
            seed.m_flags |= 4;
            while (queueSize > 0) {
                Body other;
                Body b3 = queue[queueStart++];
                --queueSize;
                island.add(b3);
                b3.m_flags &= 0xFFFFFFF7;
                if (b3.isStatic()) continue;
                ContactEdge cn = b3.m_contactList;
                while (cn != null) {
                    if (island.m_contactCount != island.m_contactCapacity && (cn.contact.m_flags & 7) == 0 && cn.contact.getManifoldCount() != 0) {
                        island.add(cn.contact);
                        cn.contact.m_flags |= 4;
                        other = cn.other;
                        if ((other.m_flags & 4) == 0) {
                            if (!other.isStatic()) {
                                other.advance(minTOI);
                                other.wakeUp();
                            }
                            assert (queueSize < queueCapacity);
                            queue[queueStart + queueSize++] = other;
                            other.m_flags |= 4;
                        }
                    }
                    cn = cn.next;
                }
                JointEdge jn = b3.m_jointList;
                while (jn != null) {
                    if (island.m_jointCount != island.m_jointCapacity && !jn.joint.m_islandFlag) {
                        island.add(jn.joint);
                        jn.joint.m_islandFlag = true;
                        other = jn.other;
                        if ((other.m_flags & 4) <= 0) {
                            if (!other.isStatic()) {
                                other.advance(minTOI);
                                other.wakeUp();
                            }
                            assert (queueSize < queueCapacity);
                            queue[queueStart + queueSize++] = other;
                            other.m_flags |= 4;
                        }
                    }
                    jn = jn.next;
                }
            }
            TimeStep subStep = (TimeStep)steps.get();
            subStep.warmStarting = false;
            subStep.dt = (1.0f - minTOI) * step.dt;
            assert (subStep.dt > 1.1920929E-7f);
            subStep.inv_dt = 1.0f / subStep.dt;
            subStep.maxIterations = step.maxIterations;
            island.solveTOI(subStep);
            steps.recycle(subStep);
            int i = 0;
            while (i < island.m_bodyCount) {
                Body b4 = island.m_bodies[i];
                b4.m_flags &= 0xFFFFFFFB;
                if ((b4.m_flags & 0xA) == 0 && !b4.isStatic()) {
                    boolean inRange = b4.synchronizeShapes();
                    if (!inRange && this.m_boundaryListener != null) {
                        this.m_boundaryListener.violation(b4);
                    }
                    ContactEdge cn = b4.m_contactList;
                    while (cn != null) {
                        cn.contact.m_flags &= 0xFFFFFFF7;
                        cn = cn.next;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < island.m_contactCount) {
                Contact c3 = island.m_contacts[i];
                c3.m_flags &= 0xFFFFFFF3;
                ++i;
            }
            i = 0;
            while (i < island.m_jointCount) {
                Joint j2 = island.m_joints[i];
                j2.m_islandFlag = false;
                ++i;
            }
            this.m_broadPhase.commit();
        }
        islands.recycle(island);
    }

    public void drawShape(Shape shape, XForm xf, Color3f color, boolean core) {
        if (shape.getType() == ShapeType.CIRCLE_SHAPE) {
            CircleShape circle = (CircleShape)shape;
            XForm.mulToOut(xf, circle.getMemberLocalPosition(), this.drawingCenter);
            float radius = circle.getRadius();
            Vec2 axis = xf.R.col1;
            if (circle.getUserData() != null && circle.getUserData().equals(LIQUID_INT)) {
                Body b = circle.getBody();
                this.liquidOffset.set(b.m_linearVelocity);
                float linVelLength = b.m_linearVelocity.length();
                this.averageLinearVel = this.averageLinearVel == -1.0f ? linVelLength : 0.98f * this.averageLinearVel + 0.02f * linVelLength;
                this.liquidOffset.mulLocal(this.liquidLength / this.averageLinearVel / 2.0f);
                this.circCenterMoved.set(this.drawingCenter).addLocal(this.liquidOffset);
                this.drawingCenter.subLocal(this.liquidOffset);
                this.m_debugDraw.drawSegment(this.drawingCenter, this.circCenterMoved, this.liquidColor);
                return;
            }
            this.m_debugDraw.drawSolidCircle(this.drawingCenter, radius, axis, color);
            if (core) {
                this.m_debugDraw.drawCircle(this.drawingCenter, radius - 0.04f, this.coreColor);
            }
        } else if (shape.getType() == ShapeType.POINT_SHAPE) {
            PointShape point = (PointShape)shape;
            XForm.mulToOut(xf, point.getMemberLocalPosition(), this.drawingCenter);
            this.m_debugDraw.drawPoint(this.drawingCenter, 0.0f, color);
        } else if (shape.getType() == ShapeType.POLYGON_SHAPE) {
            PolygonShape poly = (PolygonShape)shape;
            int vertexCount = poly.getVertexCount();
            Vec2[] localVertices = poly.getVertices();
            assert (vertexCount <= 8);
            Vec2[] vertices = new Vec2[vertexCount];
            int i = 0;
            while (i < vertexCount) {
                vertices[i] = XForm.mul(xf, localVertices[i]);
                ++i;
            }
            this.m_debugDraw.drawSolidPolygon(vertices, vertexCount, color);
            if (core) {
                Vec2[] localCoreVertices = poly.getCoreVertices();
                int i2 = 0;
                while (i2 < vertexCount) {
                    vertices[i2] = XForm.mul(xf, localCoreVertices[i2]);
                    ++i2;
                }
                this.m_debugDraw.drawPolygon(vertices, vertexCount, this.coreColor);
            }
        } else if (shape.getType() == ShapeType.EDGE_SHAPE) {
            EdgeShape edge = (EdgeShape)shape;
            XForm.mulToOut(xf, edge.getVertex1(), this.segLeft);
            XForm.mulToOut(xf, edge.getVertex2(), this.segRight);
            this.m_debugDraw.drawSegment(this.segLeft, this.segRight, color);
            if (core) {
                XForm.mulToOut(xf, edge.getCoreVertex1(), this.segLeft);
                XForm.mulToOut(xf, edge.getCoreVertex2(), this.segRight);
                this.m_debugDraw.drawSegment(this.segLeft, this.segRight, this.coreColor);
            }
        }
    }

    public void drawJoint(Joint joint) {
        Body b1 = joint.getBody1();
        Body b2 = joint.getBody2();
        XForm xf1 = b1.getMemberXForm();
        XForm xf2 = b2.getMemberXForm();
        Vec2 x1 = xf1.position;
        Vec2 x2 = xf2.position;
        Vec2 p1 = joint.getAnchor1();
        Vec2 p2 = joint.getAnchor2();
        JointType type = joint.getType();
        if (type == JointType.DISTANCE_JOINT) {
            this.m_debugDraw.drawSegment(p1, p2, this.jointColor);
        } else if (type == JointType.PULLEY_JOINT) {
            PulleyJoint pulley = (PulleyJoint)joint;
            Vec2 s1 = pulley.getGroundAnchor1();
            Vec2 s2 = pulley.getGroundAnchor2();
            this.m_debugDraw.drawSegment(s1, p1, this.jointColor);
            this.m_debugDraw.drawSegment(s2, p2, this.jointColor);
            this.m_debugDraw.drawSegment(s1, s2, this.jointColor);
        } else if (type != JointType.MOUSE_JOINT) {
            if (type == JointType.CONSTANT_VOLUME_JOINT) {
                ConstantVolumeJoint cvj = (ConstantVolumeJoint)joint;
                Body[] bodies = cvj.getBodies();
                int i = 0;
                while (i < bodies.length) {
                    int next = i == bodies.length - 1 ? 0 : i + 1;
                    Vec2 first = bodies[i].getMemberWorldCenter();
                    Vec2 nextV = bodies[next].getMemberWorldCenter();
                    this.m_debugDraw.drawSegment(first, nextV, this.jointColor);
                    ++i;
                }
            } else {
                this.m_debugDraw.drawSegment(x1, p1, this.jointColor);
                this.m_debugDraw.drawSegment(p1, p2, this.jointColor);
                this.m_debugDraw.drawSegment(x2, p2, this.jointColor);
            }
        }
    }

    public void drawDebugData() {
        XForm xf;
        if (this.m_debugDraw == null || !this.m_drawDebugData) {
            return;
        }
        int flags = this.m_debugDraw.getFlags();
        if ((flags & 1) != 0) {
            boolean core = (flags & 4) == 4;
            Body b = this.m_bodyList;
            while (b != null) {
                XForm xf2 = b.getMemberXForm();
                Shape s = b.getShapeList();
                while (s != null) {
                    if (b.isStatic()) {
                        this.drawShape(s, xf2, this.staticColor, core);
                    } else if (b.isSleeping()) {
                        this.drawShape(s, xf2, this.sleepingColor, core);
                    } else {
                        this.drawShape(s, xf2, this.activeColor, core);
                    }
                    s = s.getNext();
                }
                b = b.getNext();
            }
        }
        if ((flags & 2) != 0) {
            Joint j = this.m_jointList;
            while (j != null) {
                if (j.getType() != JointType.MOUSE_JOINT) {
                    this.drawJoint(j);
                }
                j = j.getNext();
            }
        }
        if ((flags & 0x20) != 0) {
            BroadPhase bp = this.m_broadPhase;
            Vec2 invQ = new Vec2(0.0f, 0.0f);
            invQ.set(1.0f / bp.m_quantizationFactor.x, 1.0f / bp.m_quantizationFactor.y);
            int i = 0;
            while (i < 4096) {
                int index = bp.m_pairManager.m_hashTable[i];
                while (index != Integer.MAX_VALUE) {
                    Pair pair = bp.m_pairManager.m_pairs[index];
                    Proxy p1 = bp.m_proxyPool[pair.proxyId1];
                    Proxy p2 = bp.m_proxyPool[pair.proxyId2];
                    this.pairB1.lowerBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p1.lowerBounds[0]].value;
                    this.pairB1.lowerBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p1.lowerBounds[1]].value;
                    this.pairB1.upperBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p1.upperBounds[0]].value;
                    this.pairB1.upperBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p1.upperBounds[1]].value;
                    this.pairB2.lowerBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p2.lowerBounds[0]].value;
                    this.pairB2.lowerBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p2.lowerBounds[1]].value;
                    this.pairB2.upperBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p2.upperBounds[0]].value;
                    this.pairB2.upperBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p2.upperBounds[1]].value;
                    this.pairX1.x = 0.5f * (this.pairB1.lowerBound.x + this.pairB1.upperBound.x);
                    this.pairX1.y = 0.5f * (this.pairB1.lowerBound.y + this.pairB1.upperBound.y);
                    this.pairX2.x = 0.5f * (this.pairB2.lowerBound.x + this.pairB2.upperBound.x);
                    this.pairX2.y = 0.5f * (this.pairB2.lowerBound.y + this.pairB2.upperBound.y);
                    this.m_debugDraw.drawSegment(this.pairX1, this.pairX1, this.pairColor);
                    index = pair.next;
                }
                ++i;
            }
        }
        if ((flags & 0x80) != 0) {
            Controller c = this.m_controllerList;
            while (c != null) {
                c.draw(this.m_debugDraw);
                c = c.getNext();
            }
        }
        BroadPhase bp = this.m_broadPhase;
        Vec2 worldLower = bp.m_worldAABB.lowerBound;
        Vec2 worldUpper = bp.m_worldAABB.upperBound;
        if ((flags & 8) != 0) {
            Vec2 invQ = new Vec2();
            invQ.set(1.0f / bp.m_quantizationFactor.x, 1.0f / bp.m_quantizationFactor.y);
            int i = 0;
            while (i < 64) {
                Proxy p = bp.m_proxyPool[i];
                if (p.isValid()) {
                    this.aabbB.lowerBound.x = worldLower.x + invQ.x * (float)bp.m_bounds[0][p.lowerBounds[0]].value;
                    this.aabbB.lowerBound.y = worldLower.y + invQ.y * (float)bp.m_bounds[1][p.lowerBounds[1]].value;
                    this.aabbB.upperBound.x = worldLower.x + invQ.x * (float)bp.m_bounds[0][p.upperBounds[0]].value;
                    this.aabbB.upperBound.y = worldLower.y + invQ.y * (float)bp.m_bounds[1][p.upperBounds[1]].value;
                    this.cornerVecs[0].set(this.aabbB.lowerBound.x, this.aabbB.lowerBound.y);
                    this.cornerVecs[1].set(this.aabbB.upperBound.x, this.aabbB.lowerBound.y);
                    this.cornerVecs[2].set(this.aabbB.upperBound.x, this.aabbB.upperBound.y);
                    this.cornerVecs[3].set(this.aabbB.lowerBound.x, this.aabbB.upperBound.y);
                    this.m_debugDraw.drawPolygon(this.cornerVecs, 4, this.aabbColor);
                }
                ++i;
            }
        }
        this.cornerVecs[0].set(worldLower.x, worldLower.y);
        this.cornerVecs[1].set(worldUpper.x, worldLower.y);
        this.cornerVecs[2].set(worldUpper.x, worldUpper.y);
        this.cornerVecs[3].set(worldLower.x, worldUpper.y);
        this.m_debugDraw.drawPolygon(this.cornerVecs, 4, this.worldColor);
        if ((flags & 0x10) != 0) {
            Body b = this.m_bodyList;
            while (b != null) {
                xf = b.getMemberXForm();
                Shape s = b.getShapeList();
                while (s != null) {
                    if (s.getType() == ShapeType.POLYGON_SHAPE) {
                        PolygonShape poly = (PolygonShape)s;
                        OBB obb = poly.getOBB();
                        Vec2 h = obb.extents;
                        this.cornerVecs[0].set(-h.x, -h.y);
                        this.cornerVecs[1].set(h.x, -h.y);
                        this.cornerVecs[2].set(h.x, h.y);
                        this.cornerVecs[3].set(-h.x, h.y);
                        int i = 0;
                        while (i < this.cornerVecs.length) {
                            Mat22.mulToOut(obb.R, this.cornerVecs[i], this.cornerVecs[i]);
                            XForm.mulToOut(xf, this.cornerVecs[i], this.cornerVecs[i]);
                            ++i;
                        }
                        this.m_debugDraw.drawPolygon(this.cornerVecs, 4, this.obbColor);
                    }
                    s = s.getNext();
                }
                b = b.getNext();
            }
        }
        if ((flags & 0x40) != 0) {
            Body b = this.m_bodyList;
            while (b != null) {
                xf = b.getMemberXForm();
                xf.position = b.getMemberWorldCenter();
                this.m_debugDraw.drawXForm(xf);
                b = b.getNext();
            }
        }
    }

    public void setWarmStarting(boolean flag) {
        this.m_warmStarting = flag;
    }

    public void setPositionCorrection(boolean flag) {
        this.m_positionCorrection = flag;
    }

    public void setContinuousPhysics(boolean flag) {
        this.m_continuousPhysics = flag;
    }

    public void validate() {
        this.m_broadPhase.validate();
    }

    public int getProxyCount() {
        return this.m_broadPhase.m_proxyCount;
    }

    public int getPairCount() {
        return this.m_broadPhase.m_pairManager.m_pairCount;
    }

    public AABB getWorldAABB() {
        return this.m_broadPhase.m_worldAABB;
    }

    public boolean inRange(AABB aabb) {
        return this.m_broadPhase.inRange(aabb);
    }

    public int raycast(Segment segment, Shape[] shapes, int maxCount, boolean solidShapes, Object userData) {
        this.m_raycastSegment = segment;
        this.m_raycastUserData = userData;
        this.m_raycastSolidShape = solidShapes;
        Object[] results = new Object[maxCount];
        int count = this.m_broadPhase.querySegment(segment, results, maxCount, this.raycastSortKey);
        int i = 0;
        while (i < count) {
            shapes[i] = (Shape)results[i];
            ++i;
        }
        return count;
    }

    public Shape raycastOne(Segment segment, RaycastResult result, boolean solidShapes, Object userData) {
        int maxCount = 1;
        Shape[] shapes = new Shape[maxCount];
        int count = this.raycast(segment, shapes, maxCount, solidShapes, userData);
        if (count == 0) {
            return null;
        }
        assert (count == 1);
        shapes[0].testSegment(shapes[0].getBody().getMemberXForm(), result, segment, 1.0f);
        return shapes[0];
    }

    private float raycastSortKeyFunc(Object data) {
        Shape shape = (Shape)data;
        Body body = shape.getBody();
        World world = body.getWorld();
        if (world.m_contactFilter != null && !world.m_contactFilter.rayCollide(world.m_raycastUserData, shape)) {
            return -1.0f;
        }
        RaycastResult result = new RaycastResult();
        SegmentCollide collide = shape.testSegment(body.getMemberXForm(), result, world.m_raycastSegment, 1.0f);
        float lambda = result.lambda;
        if (world.m_raycastSolidShape && collide == SegmentCollide.MISS_COLLIDE) {
            return -1.0f;
        }
        if (!world.m_raycastSolidShape && collide != SegmentCollide.HIT_COLLIDE) {
            return -1.0f;
        }
        return lambda;
    }
}

