/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.common.Color3f;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public abstract class DebugDraw {
    public static final int e_shapeBit = 1;
    public static final int e_jointBit = 2;
    public static final int e_coreShapeBit = 4;
    public static final int e_aabbBit = 8;
    public static final int e_obbBit = 16;
    public static final int e_pairBit = 32;
    public static final int e_centerOfMassBit = 64;
    public static final int e_controllerBit = 128;
    protected int m_drawFlags = 0;
    protected final IViewportTransform viewportTransform;

    public DebugDraw(IViewportTransform viewport) {
        this.viewportTransform = viewport;
    }

    public void setFlags(int flags) {
        this.m_drawFlags = flags;
    }

    public int getFlags() {
        return this.m_drawFlags;
    }

    public void appendFlags(int flags) {
        this.m_drawFlags |= flags;
    }

    public void clearFlags(int flags) {
        this.m_drawFlags &= ~flags;
    }

    public abstract void drawPolygon(Vec2[] var1, int var2, Color3f var3);

    public abstract void drawSolidPolygon(Vec2[] var1, int var2, Color3f var3);

    public abstract void drawCircle(Vec2 var1, float var2, Color3f var3);

    public abstract void drawSolidCircle(Vec2 var1, float var2, Vec2 var3, Color3f var4);

    public abstract void drawPoint(Vec2 var1, float var2, Color3f var3);

    public abstract void drawSegment(Vec2 var1, Vec2 var2, Color3f var3);

    public abstract void drawXForm(XForm var1);

    public abstract void drawString(float var1, float var2, String var3, Color3f var4);

    public IViewportTransform getViewportTranform() {
        return this.viewportTransform;
    }

    public void setCamera(float x, float y, float scale) {
        this.viewportTransform.setCamera(x, y, scale);
    }

    public void getScreenToWorldToOut(Vec2 argScreen, Vec2 argWorld) {
        this.viewportTransform.getScreenToWorld(argScreen, argWorld);
    }

    public void getWorldToScreenToOut(Vec2 argWorld, Vec2 argScreen) {
        this.viewportTransform.getWorldToScreen(argWorld, argScreen);
    }

    public void getWorldToScreenToOut(float worldX, float worldY, Vec2 argScreen) {
        argScreen.set(worldX, worldY);
        this.viewportTransform.getWorldToScreen(argScreen, argScreen);
    }

    public Vec2 getWorldToScreen(Vec2 argWorld) {
        Vec2 screen = new Vec2();
        this.viewportTransform.getWorldToScreen(argWorld, screen);
        return screen;
    }

    public Vec2 getWorldToScreen(float worldX, float worldY) {
        Vec2 argScreen = new Vec2(worldX, worldY);
        this.viewportTransform.getWorldToScreen(argScreen, argScreen);
        return argScreen;
    }

    public void getScreenToWorldToOut(float screenX, float screenY, Vec2 argWorld) {
        argWorld.set(screenX, screenY);
        this.viewportTransform.getScreenToWorld(argWorld, argWorld);
    }

    public Vec2 getScreenToWorld(Vec2 argScreen) {
        Vec2 world = new Vec2();
        this.viewportTransform.getScreenToWorld(argScreen, world);
        return world;
    }

    public Vec2 getScreenToWorld(float screenX, float screenY) {
        Vec2 screen = new Vec2(screenX, screenY);
        this.viewportTransform.getScreenToWorld(screen, screen);
        return screen;
    }
}

