/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;

public class XForm {
    public Vec2 position;
    public Mat22 R;
    public static XForm identity = new XForm();

    static {
        identity.setIdentity();
    }

    public XForm() {
        this.position = new Vec2();
        this.R = new Mat22();
    }

    public XForm(XForm xf) {
        this.position = xf.position.clone();
        this.R = xf.R.clone();
    }

    public XForm(Vec2 _position, Mat22 _R) {
        this.position = _position.clone();
        this.R = _R.clone();
    }

    public final XForm set(XForm xf) {
        this.position.set(xf.position);
        this.R.set(xf.R);
        return this;
    }

    public final void setIdentity() {
        this.position.setZero();
        this.R.setIdentity();
    }

    public static final Vec2 mul(XForm T, Vec2 v) {
        return new Vec2(T.position.x + T.R.col1.x * v.x + T.R.col2.x * v.y, T.position.y + T.R.col1.y * v.x + T.R.col2.y * v.y);
    }

    public static final void mulToOut(XForm T, Vec2 v, Vec2 out) {
        float tempy = T.position.y + T.R.col1.y * v.x + T.R.col2.y * v.y;
        out.x = T.position.x + T.R.col1.x * v.x + T.R.col2.x * v.y;
        out.y = tempy;
    }

    public static final Vec2 mulTrans(XForm T, Vec2 v) {
        float v1x = v.x - T.position.x;
        float v1y = v.y - T.position.y;
        Vec2 b = T.R.col1;
        Vec2 b1 = T.R.col2;
        return new Vec2(v1x * b.x + v1y * b.y, v1x * b1.x + v1y * b1.y);
    }

    public static final void mulTransToOut(XForm T, Vec2 v, Vec2 out) {
        float v1x = v.x - T.position.x;
        float v1y = v.y - T.position.y;
        Vec2 b = T.R.col1;
        Vec2 b1 = T.R.col2;
        float tempy = v1x * b1.x + v1y * b1.y;
        out.x = v1x * b.x + v1y * b.y;
        out.y = tempy;
    }

    public final String toString() {
        String s = "XForm:\n";
        s = String.valueOf(s) + "Position: " + this.position + "\n";
        s = String.valueOf(s) + "R: \n" + this.R + "\n";
        return s;
    }
}

