/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float TWOPI = (float)Math.PI * 2;
    public static final float[] sinLUT = new float[Settings.SINCOS_LUT_LENGTH];
    public static final float[] cosLUT = new float[Settings.SINCOS_LUT_LENGTH];

    static {
        int i = 0;
        while (i < Settings.SINCOS_LUT_LENGTH) {
            MathUtils.sinLUT[i] = (float)Math.sin((float)i * 0.00131f);
            MathUtils.cosLUT[i] = (float)Math.cos((float)i * 0.00131f);
            ++i;
        }
    }

    public static final float sin(float x) {
        x %= (float)Math.PI * 2;
        while (x < 0.0f) {
            x += (float)Math.PI * 2;
        }
        return sinLUT[MathUtils.round(x / 0.00131f) % Settings.SINCOS_LUT_LENGTH];
    }

    public static final float cos(float x) {
        x %= (float)Math.PI * 2;
        while (x < 0.0f) {
            x += (float)Math.PI * 2;
        }
        return cosLUT[MathUtils.round(x / 0.00131f) % Settings.SINCOS_LUT_LENGTH];
    }

    public static final float abs(float x) {
        return x > 0.0f ? x : -x;
    }

    public static final int floor(float x) {
        return x > 0.0f ? (int)x : (int)x - 1;
    }

    public static final int ceil(float x) {
        return MathUtils.floor(x + 0.5f);
    }

    public static final int round(float x) {
        return MathUtils.floor(x + 0.5f);
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final float map(float val, float fromMin, float fromMax, float toMin, float toMax) {
        float mult = (val - fromMin) / (fromMax - fromMin);
        float res = toMin + mult * (toMax - toMin);
        return res;
    }

    public static final float clamp(float a, float low, float high) {
        return MathUtils.max(low, MathUtils.min(a, high));
    }

    public static final Vec2 clamp(Vec2 a, Vec2 low, Vec2 high) {
        Vec2 min = new Vec2();
        Vec2.minToOut(a, high, min);
        Vec2.maxToOut(low, min, min);
        return min;
    }

    public static final void clampToOut(Vec2 a, Vec2 low, Vec2 high, Vec2 dest) {
        Vec2.minToOut(a, high, dest);
        Vec2.maxToOut(low, dest, dest);
    }

    public static final int nextPowerOfTwo(int x) {
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static final boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static final float atan2(float y, float x) {
        float angle;
        float abs_y = MathUtils.abs(y) + 1.0E-10f;
        if (x >= 0.0f) {
            float r = (x - abs_y) / (x + abs_y);
            angle = 0.1963f * r * r * r - 0.9817f * r + 0.7853982f;
        } else {
            float r = (x + abs_y) / (abs_y - x);
            angle = 0.1963f * r * r * r - 0.9817f * r + 2.3561945f;
        }
        if (y < 0.0f) {
            return -angle;
        }
        return angle;
    }

    public static final float pow(float a, float b) {
        float x = Float.floatToRawIntBits(a);
        x *= 1.1920929E-7f;
        float y = (x -= 127.0f) - (float)MathUtils.floor(x);
        b *= x + (y - y * y) * 0.346607f;
        y = b - (float)MathUtils.floor(b);
        y = (y - y * y) * 0.33971f;
        return Float.intBitsToFloat((int)((b + 127.0f - y) * 8388608.0f));
    }

    public static final float sqrt(float x) {
        return (float)StrictMath.sqrt(x);
    }

    public static final float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToRawIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        x *= 1.5f - xhalf * x * x;
        x *= 1.5f - xhalf * x * x;
        x *= 1.5f - xhalf * x * x;
        return x;
    }
}

