/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.Vec3;

public class Mat33 {
    public Vec3 col1;
    public Vec3 col2;
    public Vec3 col3;
    private Vec3 temp = new Vec3();

    public Mat33() {
        this.col1 = new Vec3();
        this.col2 = new Vec3();
        this.col3 = new Vec3();
    }

    public Mat33(Vec3 argCol1, Vec3 argCol2, Vec3 argCol3) {
        this.col1 = argCol1.clone();
        this.col2 = argCol2.clone();
        this.col3 = argCol3.clone();
    }

    public void setZero() {
        this.col1.setZero();
        this.col2.setZero();
        this.col3.setZero();
    }

    public static final Vec3 mul(Mat33 A, Vec3 v) {
        return new Vec3(v.x * A.col1.x + v.y * A.col2.x + v.z + A.col3.x, v.x * A.col1.y + v.y * A.col2.y + v.z * A.col3.y, v.x * A.col1.z + v.y * A.col2.z + v.z * A.col3.z);
    }

    public static final void mulToOut(Mat33 A, Vec3 v, Vec3 out) {
        float tempy = v.x * A.col1.y + v.y * A.col2.y + v.z * A.col3.y;
        float tempz = v.x * A.col1.z + v.y * A.col2.z + v.z * A.col3.z;
        out.x = v.x * A.col1.x + v.y * A.col2.x + v.z + A.col3.x;
        out.y = tempy;
        out.z = tempz;
    }

    public Vec3 solve(Vec3 b) {
        Vec3.crossToOut(this.col1, this.col2, this.temp);
        float det = Vec3.dot(this.col1, this.temp);
        assert (det != 0.0f);
        det = 1.0f / det;
        Vec3 x = new Vec3();
        Vec3.crossToOut(this.col2, this.col3, this.temp);
        x.x = det * Vec3.dot(b, this.temp);
        Vec3.crossToOut(b, this.col3, this.temp);
        x.y = det * Vec3.dot(this.col1, this.temp);
        Vec3.crossToOut(this.col2, b, this.temp);
        x.z = det * Vec3.dot(this.col1, this.temp);
        return x;
    }

    public void solveToOut(Vec3 b, Vec3 out) {
        Vec3.crossToOut(this.col1, this.col2, out);
        float det = Vec3.dot(this.col1, out);
        assert (det != 0.0f);
        det = 1.0f / det;
        Vec3.crossToOut(this.col2, this.col3, out);
        float tempx = det * Vec3.dot(b, out);
        Vec3.crossToOut(b, this.col3, out);
        float tempy = det * Vec3.dot(this.col1, out);
        Vec3.crossToOut(this.col2, b, out);
        float tempz = det * Vec3.dot(this.col1, out);
        out.x = tempx;
        out.y = tempy;
        out.z = tempz;
    }
}

