/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import java.util.List;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.OBB;
import org.jbox2d.collision.Segment;
import org.jbox2d.collision.SegmentCollide;
import org.jbox2d.collision.SupportsGenericDistance;
import org.jbox2d.collision.shapes.PolygonDef;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.RaycastResult;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.pooling.TLAABB;
import org.jbox2d.pooling.TLMassData;
import org.jbox2d.pooling.TLMat22;
import org.jbox2d.pooling.TLVec2;

public class PolygonShape
extends Shape
implements SupportsGenericDistance {
    private static boolean m_debug = false;
    public final Vec2 m_centroid;
    public final OBB m_obb;
    public final Vec2[] m_vertices;
    public final Vec2[] m_normals;
    public final Vec2[] m_coreVertices;
    public int m_vertexCount;
    private static final TLVec2 tlEdge = new TLVec2();
    private static final TLVec2 tlV = new TLVec2();
    private static final TLVec2 tlD = new TLVec2();
    private static final TLMat22 tlA = new TLMat22();
    private static final TLVec2 tlTemp = new TLVec2();
    private static final TLVec2 tlPLocal = new TLVec2();
    private static final TLVec2 tlP1 = new TLVec2();
    private static final TLVec2 tlP2 = new TLVec2();
    private static final TLVec2 tlSupDLocal = new TLVec2();
    private static final TLVec2 tlPRef = new TLVec2();
    private static final TLVec2 tlE1 = new TLVec2();
    private static final TLVec2 tlE2 = new TLVec2();
    private static final TLVec2 tlUX = new TLVec2();
    private static final TLVec2 tlUY = new TLVec2();
    private static final TLVec2 tlLower = new TLVec2();
    private static final TLVec2 tlUpper = new TLVec2();
    private static final TLVec2 tlR = new TLVec2();
    private static final TLVec2 tlCenter = new TLVec2();
    private static final TLMat22 tlCaabbR = new TLMat22();
    private static final TLVec2 tlCaabbH = new TLVec2();
    private static final TLAABB tlSwept1 = new TLAABB();
    private static final TLAABB tlSwept2 = new TLAABB();
    private static final TLVec2 tlNormalL = new TLVec2();
    private static final TLMassData tlMd = new TLMassData();
    private static final TLVec2 tlIntoVec = new TLVec2();
    private static final TLVec2 tlOutoVec = new TLVec2();
    private static final TLVec2 tlP2b = new TLVec2();
    private static final TLVec2 tlP3 = new TLVec2();

    public PolygonShape(ShapeDef def) {
        super(def);
        assert (def.type == ShapeType.POLYGON_SHAPE);
        this.m_type = ShapeType.POLYGON_SHAPE;
        PolygonDef poly = (PolygonDef)def;
        this.m_vertexCount = poly.getVertexCount();
        this.m_vertices = new Vec2[this.m_vertexCount];
        this.m_normals = new Vec2[this.m_vertexCount];
        this.m_coreVertices = new Vec2[this.m_vertexCount];
        this.m_obb = new OBB();
        assert (3 <= this.m_vertexCount && this.m_vertexCount <= 8);
        int i = 0;
        while (i < this.m_vertexCount) {
            this.m_vertices[i] = poly.vertices.get(i).clone();
            ++i;
        }
        Vec2 edge = (Vec2)tlEdge.get();
        int i2 = 0;
        while (i2 < this.m_vertexCount) {
            int i1 = i2;
            int i22 = i2 + 1 < this.m_vertexCount ? i2 + 1 : 0;
            edge.set(this.m_vertices[i22]).subLocal(this.m_vertices[i1]);
            assert (edge.lengthSquared() > 1.4210855E-14f);
            this.m_normals[i2] = Vec2.cross(edge, 1.0f);
            this.m_normals[i2].normalize();
            ++i2;
        }
        if (m_debug) {
            i2 = 0;
            while (i2 < this.m_vertexCount) {
                int j = 0;
                while (j < this.m_vertexCount) {
                    if (j != i2 && j != (i2 + 1) % this.m_vertexCount) assert (Vec2.dot(this.m_normals[i2], this.m_vertices[j].sub(this.m_vertices[i2])) < -0.005f);
                    ++j;
                }
                ++i2;
            }
            i2 = 1;
            while (i2 < this.m_vertexCount) {
                float cross = Vec2.cross(this.m_normals[i2 - 1], this.m_normals[i2]);
                cross = MathUtils.clamp(cross, -1.0f, 1.0f);
                float angle = (float)Math.asin(cross);
                assert (angle > 0.03490659f);
                ++i2;
            }
        }
        this.m_centroid = PolygonShape.computeCentroid(poly.vertices);
        PolygonShape.computeOBB(this.m_obb, this.m_vertices);
        Vec2 v = (Vec2)tlV.get();
        Vec2 d = (Vec2)tlD.get();
        Mat22 A = (Mat22)tlA.get();
        int i3 = 0;
        while (i3 < this.m_vertexCount) {
            int i1 = i3 - 1 >= 0 ? i3 - 1 : this.m_vertexCount - 1;
            int i23 = i3;
            Vec2 n1 = this.m_normals[i1];
            Vec2 n2 = this.m_normals[i23];
            v.set(this.m_vertices[i3]).subLocal(this.m_centroid);
            d.x = Vec2.dot(n1, v) - 0.04f;
            d.y = Vec2.dot(n2, v) - 0.04f;
            if (d.x < 0.0f || d.y < 0.0f) {
                System.out.println("Error, polygon extents less than b2_toiSlop, dumping details: ");
                System.out.println("d.x: " + d.x + "d.y: " + d.y);
                System.out.println("n1: " + n1 + "; n2: " + n2);
                System.out.println("v: " + v);
            }
            assert (d.x >= 0.0f);
            assert (d.y >= 0.0f);
            A.col1.x = n1.x;
            A.col2.x = n1.y;
            A.col1.y = n2.x;
            A.col2.y = n2.y;
            this.m_coreVertices[i3] = A.solve(d).addLocal(this.m_centroid);
            ++i3;
        }
        if (m_debug) {
            System.out.println("\nDumping polygon shape...");
            System.out.println("Vertices: ");
            i3 = 0;
            while (i3 < this.m_vertexCount) {
                System.out.println(this.m_vertices[i3]);
                ++i3;
            }
            System.out.println("Core Vertices: ");
            i3 = 0;
            while (i3 < this.m_vertexCount) {
                System.out.println(this.m_coreVertices[i3]);
                ++i3;
            }
            System.out.println("Normals: ");
            i3 = 0;
            while (i3 < this.m_vertexCount) {
                System.out.println(this.m_normals[i3]);
                ++i3;
            }
            System.out.println("Centroid: " + this.m_centroid);
        }
    }

    @Override
    public void updateSweepRadius(Vec2 center) {
        Vec2 d = (Vec2)tlD.get();
        this.m_sweepRadius = 0.0f;
        int i = 0;
        while (i < this.m_vertexCount) {
            d.set(this.m_coreVertices[i]);
            d.subLocal(center);
            this.m_sweepRadius = MathUtils.max(this.m_sweepRadius, d.length());
            ++i;
        }
    }

    @Override
    public boolean testPoint(XForm xf, Vec2 p) {
        int i;
        Vec2 temp = (Vec2)tlTemp.get();
        Vec2 pLocal = (Vec2)tlPLocal.get();
        temp.set(p);
        temp.subLocal(xf.position);
        Mat22.mulTransToOut(xf.R, temp, pLocal);
        if (m_debug) {
            System.out.println("--testPoint debug--");
            System.out.println("Vertices: ");
            i = 0;
            while (i < this.m_vertexCount) {
                System.out.println(this.m_vertices[i]);
                ++i;
            }
            System.out.println("pLocal: " + pLocal);
        }
        i = 0;
        while (i < this.m_vertexCount) {
            temp.set(pLocal);
            temp.subLocal(this.m_vertices[i]);
            float dot = Vec2.dot(this.m_normals[i], temp);
            if (dot > 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public SegmentCollide testSegment(XForm xf, RaycastResult out, Segment segment, float maxLambda) {
        float lower = 0.0f;
        float upper = maxLambda;
        Vec2 p1 = (Vec2)tlP1.get();
        Vec2 p2 = (Vec2)tlP2.get();
        Vec2 d = (Vec2)tlD.get();
        Vec2 temp = (Vec2)tlTemp.get();
        p1.set(segment.p1).subLocal(xf.position);
        Mat22.mulTransToOut(xf.R, p1, p1);
        p2.set(segment.p2).subLocal(xf.position);
        Mat22.mulTransToOut(xf.R, p2, p2);
        d.set(p2).subLocal(p1);
        int index = -1;
        int i = 0;
        while (i < this.m_vertexCount) {
            temp.set(this.m_vertices[i]).subLocal(p1);
            float numerator = Vec2.dot(this.m_normals[i], temp);
            float denominator = Vec2.dot(this.m_normals[i], d);
            if (denominator == 0.0f && numerator < 0.0f) {
                return SegmentCollide.MISS_COLLIDE;
            }
            if (denominator < 0.0f && numerator < lower * denominator) {
                lower = numerator / denominator;
                index = i;
            } else if (denominator > 0.0f && numerator < upper * denominator) {
                upper = numerator / denominator;
            }
            if (upper < lower) {
                return SegmentCollide.MISS_COLLIDE;
            }
            ++i;
        }
        assert (0.0f <= lower && lower <= maxLambda);
        if (index >= 0) {
            out.lambda = lower;
            Mat22.mulToOut(xf.R, this.m_normals[index], out.normal);
            return SegmentCollide.HIT_COLLIDE;
        }
        out.lambda = 0.0f;
        return SegmentCollide.STARTS_INSIDE_COLLIDE;
    }

    @Override
    public void support(Vec2 dest, XForm xf, Vec2 d) {
        Vec2 supportDLocal = (Vec2)tlSupDLocal.get();
        Mat22.mulTransToOut(xf.R, d, supportDLocal);
        int bestIndex = 0;
        float bestValue = Vec2.dot(this.m_coreVertices[0], supportDLocal);
        int i = 1;
        while (i < this.m_vertexCount) {
            float value = Vec2.dot(this.m_coreVertices[i], supportDLocal);
            if (value > bestValue) {
                bestIndex = i;
                bestValue = value;
            }
            ++i;
        }
        XForm.mulToOut(xf, this.m_coreVertices[bestIndex], dest);
    }

    public static final Vec2 computeCentroid(List<Vec2> vs) {
        int count = vs.size();
        assert (count >= 3);
        Vec2 c = new Vec2();
        float area = 0.0f;
        Vec2 pRef = (Vec2)tlPRef.get();
        pRef.setZero();
        float inv3 = 0.33333334f;
        Vec2 e1 = (Vec2)tlE1.get();
        Vec2 e2 = (Vec2)tlE2.get();
        Vec2 p1 = (Vec2)tlP1.get();
        int i = 0;
        while (i < count) {
            p1.set(pRef);
            Vec2 p2 = vs.get(i);
            Vec2 p3 = i + 1 < count ? vs.get(i + 1) : vs.get(0);
            e1.set(p2).subLocal(p1);
            e2.set(p3).subLocal(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            c.x += triangleArea * 0.33333334f * (p1.x + p2.x + p3.x);
            c.y += triangleArea * 0.33333334f * (p1.y + p2.y + p3.y);
            ++i;
        }
        assert (area > 1.1920929E-7f);
        c.mulLocal(1.0f / area);
        return c;
    }

    public static void computeOBB(OBB obb, Vec2[] vs) {
        int count = vs.length;
        assert (count <= 8);
        Vec2 ux = (Vec2)tlUX.get();
        Vec2 uy = (Vec2)tlUY.get();
        Vec2 lower = (Vec2)tlLower.get();
        Vec2 upper = (Vec2)tlUpper.get();
        Vec2 d = (Vec2)tlD.get();
        Vec2 r = (Vec2)tlR.get();
        Vec2 center = (Vec2)tlCenter.get();
        Vec2[] pRay = new Vec2[9];
        int i = 0;
        while (i < count) {
            pRay[i] = vs[i];
            ++i;
        }
        pRay[count] = pRay[0];
        float minArea = Float.MAX_VALUE;
        int i2 = 1;
        while (i2 <= count) {
            Vec2 root = pRay[i2 - 1];
            ux.set(pRay[i2]);
            ux.subLocal(root);
            float length = ux.normalize();
            assert (length > 1.1920929E-7f);
            uy.x = -ux.y;
            uy.y = ux.x;
            lower.x = Float.MAX_VALUE;
            lower.y = Float.MAX_VALUE;
            upper.x = -3.4028235E38f;
            upper.y = -3.4028235E38f;
            int j = 0;
            while (j < count) {
                d.set(pRay[j]);
                d.subLocal(root);
                r.x = Vec2.dot(ux, d);
                r.y = Vec2.dot(uy, d);
                Vec2.minToOut(lower, r, lower);
                Vec2.maxToOut(upper, r, upper);
                ++j;
            }
            float area = (upper.x - lower.x) * (upper.y - lower.y);
            if (area < 0.95f * minArea) {
                minArea = area;
                obb.R.col1.set(ux);
                obb.R.col2.set(uy);
                center.set(0.5f * (lower.x + upper.x), 0.5f * (lower.y + upper.y));
                Mat22.mulToOut(obb.R, center, obb.center);
                obb.center.addLocal(root);
                obb.extents.x = 0.5f * (upper.x - lower.x);
                obb.extents.y = 0.5f * (upper.y - lower.y);
            }
            ++i2;
        }
        assert (minArea < Float.MAX_VALUE);
    }

    @Override
    public void computeAABB(AABB aabb, XForm xf) {
        Mat22 caabbR = (Mat22)tlCaabbR.get();
        Vec2 caabbH = (Vec2)tlCaabbH.get();
        Mat22.mulToOut(xf.R, this.m_obb.R, caabbR);
        caabbR.absLocal();
        Mat22.mulToOut(caabbR, this.m_obb.extents, caabbH);
        Mat22.mulToOut(xf.R, this.m_obb.center, aabb.lowerBound);
        aabb.lowerBound.addLocal(xf.position);
        aabb.upperBound.set(aabb.lowerBound);
        aabb.lowerBound.subLocal(caabbH);
        aabb.upperBound.addLocal(caabbH);
    }

    @Override
    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        AABB sweptAABB1 = (AABB)tlSwept1.get();
        AABB sweptAABB2 = (AABB)tlSwept2.get();
        this.computeAABB(sweptAABB1, transform1);
        this.computeAABB(sweptAABB2, transform2);
        Vec2.minToOut(sweptAABB1.lowerBound, sweptAABB2.lowerBound, aabb.lowerBound);
        Vec2.maxToOut(sweptAABB1.upperBound, sweptAABB2.upperBound, aabb.upperBound);
    }

    @Override
    public void computeMass(MassData massData) {
        this.computeMass(massData, this.m_density);
    }

    public void computeMass(MassData massData, float density) {
        assert (this.m_vertexCount >= 3);
        Vec2 center = (Vec2)tlCenter.get();
        center.setZero();
        float area = 0.0f;
        float I = 0.0f;
        Vec2 pRef = (Vec2)tlPRef.get();
        pRef.setZero();
        float k_inv3 = 0.33333334f;
        Vec2 e1 = (Vec2)tlE1.get();
        Vec2 e2 = (Vec2)tlE2.get();
        int i = 0;
        while (i < this.m_vertexCount) {
            Vec2 p1 = pRef;
            Vec2 p2 = this.m_vertices[i];
            Vec2 p3 = i + 1 < this.m_vertexCount ? this.m_vertices[i + 1] : this.m_vertices[0];
            e1.set(p2);
            e1.subLocal(p1);
            e2.set(p3);
            e2.subLocal(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            center.x += triangleArea * 0.33333334f * (p1.x + p2.x + p3.x);
            center.y += triangleArea * 0.33333334f * (p1.y + p2.y + p3.y);
            float px = p1.x;
            float py = p1.y;
            float ex1 = e1.x;
            float ey1 = e1.y;
            float ex2 = e2.x;
            float ey2 = e2.y;
            float intx2 = 0.33333334f * (0.25f * (ex1 * ex1 + ex2 * ex1 + ex2 * ex2) + (px * ex1 + px * ex2)) + 0.5f * px * px;
            float inty2 = 0.33333334f * (0.25f * (ey1 * ey1 + ey2 * ey1 + ey2 * ey2) + (py * ey1 + py * ey2)) + 0.5f * py * py;
            I += D * (intx2 + inty2);
            ++i;
        }
        massData.mass = density * area;
        assert (area > 1.1920929E-7f);
        center.mulLocal(1.0f / area);
        massData.center.set(center);
        massData.I = I * density;
    }

    @Override
    public void getFirstVertexToOut(XForm xf, Vec2 out) {
        XForm.mulToOut(xf, this.m_coreVertices[0], out);
    }

    public OBB getOBB() {
        return this.m_obb.clone();
    }

    public Vec2 getCentroid() {
        return this.m_centroid.clone();
    }

    public int getVertexCount() {
        return this.m_vertexCount;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getCoreVertices() {
        return this.m_coreVertices;
    }

    public Vec2[] getNormals() {
        return this.m_normals;
    }

    public Vec2 centroid(XForm xf) {
        return XForm.mul(xf, this.m_centroid);
    }

    @Override
    public float computeSubmergedArea(Vec2 normal, float offset, XForm xf, Vec2 c) {
        Vec2 normalL = (Vec2)tlNormalL.get();
        MassData md = (MassData)tlMd.get();
        Mat22.mulTransToOut(xf.R, normal, normalL);
        float offsetL = offset - Vec2.dot(normal, xf.position);
        float[] depths = new float[8];
        int diveCount = 0;
        int intoIndex = -1;
        int outoIndex = -1;
        boolean lastSubmerged = false;
        int i = 0;
        i = 0;
        while (i < this.m_vertexCount) {
            boolean isSubmerged;
            depths[i] = Vec2.dot(normalL, this.m_vertices[i]) - offsetL;
            boolean bl = isSubmerged = depths[i] < -1.1920929E-7f;
            if (i > 0) {
                if (isSubmerged) {
                    if (!lastSubmerged) {
                        intoIndex = i - 1;
                        ++diveCount;
                    }
                } else if (lastSubmerged) {
                    outoIndex = i - 1;
                    ++diveCount;
                }
            }
            lastSubmerged = isSubmerged;
            ++i;
        }
        switch (diveCount) {
            case 0: {
                if (lastSubmerged) {
                    this.computeMass(md, 1.0f);
                    XForm.mulToOut(xf, md.center, c);
                    return md.mass;
                }
                return 0.0f;
            }
            case 1: {
                if (intoIndex == -1) {
                    intoIndex = this.m_vertexCount - 1;
                    break;
                }
                outoIndex = this.m_vertexCount - 1;
            }
        }
        Vec2 intoVec = (Vec2)tlIntoVec.get();
        Vec2 outoVec = (Vec2)tlOutoVec.get();
        Vec2 e1 = (Vec2)tlE1.get();
        Vec2 e2 = (Vec2)tlE2.get();
        int intoIndex2 = (intoIndex + 1) % this.m_vertexCount;
        int outoIndex2 = (outoIndex + 1) % this.m_vertexCount;
        float intoLambda = (0.0f - depths[intoIndex]) / (depths[intoIndex2] - depths[intoIndex]);
        float outoLambda = (0.0f - depths[outoIndex]) / (depths[outoIndex2] - depths[outoIndex]);
        intoVec.set(this.m_vertices[intoIndex].x * (1.0f - intoLambda) + this.m_vertices[intoIndex2].x * intoLambda, this.m_vertices[intoIndex].y * (1.0f - intoLambda) + this.m_vertices[intoIndex2].y * intoLambda);
        outoVec.set(this.m_vertices[outoIndex].x * (1.0f - outoLambda) + this.m_vertices[outoIndex2].x * outoLambda, this.m_vertices[outoIndex].y * (1.0f - outoLambda) + this.m_vertices[outoIndex2].y * outoLambda);
        float area = 0.0f;
        Vec2 center = (Vec2)tlCenter.get();
        center.setZero();
        Vec2 p2b = ((Vec2)tlP2b.get()).set(this.m_vertices[intoIndex2]);
        Vec2 p3 = (Vec2)tlP3.get();
        p3.setZero();
        float k_inv3 = 0.33333334f;
        i = intoIndex2;
        while (i != outoIndex2) {
            if ((i = (i + 1) % this.m_vertexCount) == outoIndex2) {
                p3.set(outoVec);
            } else {
                p3.set(this.m_vertices[i]);
            }
            e1.set(p2b).subLocal(intoVec);
            e2.set(p3).subLocal(intoVec);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            center.x += triangleArea * k_inv3 * (intoVec.x + p2b.x + p3.x);
            center.y += triangleArea * k_inv3 * (intoVec.y + p2b.y + p3.y);
            p2b.set(p3);
        }
        center.x *= 1.0f / area;
        center.y *= 1.0f / area;
        XForm.mulToOut(xf, center, c);
        return area;
    }
}

