/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.FilterData;
import org.jbox2d.collision.shapes.ShapeDef;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class PolygonDef
extends ShapeDef {
    public List<Vec2> vertices;

    public void set(PolygonDef copyMe) {
        this.density = copyMe.density;
        this.filter = new FilterData();
        this.filter.set(copyMe.filter);
        this.friction = copyMe.friction;
        this.isSensor = copyMe.isSensor;
        this.restitution = copyMe.restitution;
        this.type = copyMe.type;
        this.userData = copyMe.userData;
        this.vertices = new ArrayList<Vec2>();
        int i = 0;
        while (i < copyMe.vertices.size()) {
            this.addVertex(copyMe.vertices.get(i).clone());
            ++i;
        }
    }

    public PolygonDef() {
        this.type = ShapeType.POLYGON_SHAPE;
        this.vertices = new ArrayList<Vec2>();
    }

    public void addVertex(Vec2 v) {
        this.vertices.add(v);
    }

    public void clearVertices() {
        this.vertices.clear();
    }

    public Vec2[] getVertexArray() {
        return this.vertices.toArray(new Vec2[0]);
    }

    public List<Vec2> getVertexList() {
        return this.vertices;
    }

    public void setAsBox(float hx, float hy) {
        this.vertices.clear();
        this.vertices.add(new Vec2(-hx, -hy));
        this.vertices.add(new Vec2(hx, -hy));
        this.vertices.add(new Vec2(hx, hy));
        this.vertices.add(new Vec2(-hx, hy));
    }

    public void setAsBox(float hx, float hy, Vec2 center, float angle) {
        this.setAsBox(hx, hy);
        XForm xf = new XForm();
        xf.position.set(center);
        xf.R.set(angle);
        int i = 0;
        while (i < this.vertices.size()) {
            XForm.mulToOut(xf, this.vertices.get(i), this.vertices.get(i));
            ++i;
        }
    }

    public int getVertexCount() {
        return this.vertices.size();
    }
}

