/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PointShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class CollideCircle {
    private final Vec2 colCCP1 = new Vec2();
    private final Vec2 colCCP2 = new Vec2();
    private final Vec2 colCCD = new Vec2();
    private final Vec2 colCCP = new Vec2();
    private final Vec2 colPCP1 = new Vec2();
    private final Vec2 colPCP2 = new Vec2();
    private final Vec2 colPCD = new Vec2();
    private final Vec2 colPCP = new Vec2();
    private final Vec2 ECd = new Vec2();
    private final Vec2 ECc = new Vec2();
    private final Vec2 ECcLocal = new Vec2();

    public final void collideCircles(Manifold manifold, CircleShape circle1, XForm xf1, CircleShape circle2, XForm xf2) {
        float separation;
        manifold.pointCount = 0;
        XForm.mulToOut(xf1, circle1.getMemberLocalPosition(), this.colCCP1);
        XForm.mulToOut(xf2, circle2.getMemberLocalPosition(), this.colCCP2);
        this.colCCD.x = this.colCCP2.x - this.colCCP1.x;
        this.colCCD.y = this.colCCP2.y - this.colCCP1.y;
        float distSqr = Vec2.dot(this.colCCD, this.colCCD);
        float r1 = circle1.getRadius();
        float r2 = circle2.getRadius();
        float radiusSum = r1 + r2;
        if (distSqr > radiusSum * radiusSum) {
            return;
        }
        if (distSqr < 1.1920929E-7f) {
            separation = -radiusSum;
            manifold.normal.set(0.0f, 1.0f);
        } else {
            float dist = MathUtils.sqrt(distSqr);
            separation = dist - radiusSum;
            float a = 1.0f / dist;
            manifold.normal.x = a * this.colCCD.x;
            manifold.normal.y = a * this.colCCD.y;
        }
        manifold.pointCount = 1;
        manifold.points[0].id.zero();
        manifold.points[0].separation = separation;
        this.colCCP1.addLocal(manifold.normal.mul(r1));
        this.colCCP2.subLocal(manifold.normal.mul(r2));
        this.colCCP.x = 0.5f * (this.colCCP1.x + this.colCCP2.x);
        this.colCCP.y = 0.5f * (this.colCCP1.y + this.colCCP2.y);
        XForm.mulTransToOut(xf1, this.colCCP, manifold.points[0].localPoint1);
        XForm.mulTransToOut(xf2, this.colCCP, manifold.points[0].localPoint2);
    }

    public final void collidePointAndCircle(Manifold manifold, PointShape point1, XForm xf1, CircleShape circle2, XForm xf2) {
        float separation;
        manifold.pointCount = 0;
        XForm.mulToOut(xf1, point1.getMemberLocalPosition(), this.colPCP1);
        XForm.mulToOut(xf2, circle2.getMemberLocalPosition(), this.colPCP2);
        this.colPCD.x = this.colPCP2.x - this.colPCP1.x;
        this.colPCD.y = this.colPCP2.y - this.colPCP1.y;
        float distSqr = Vec2.dot(this.colPCD, this.colPCD);
        float r2 = circle2.getRadius();
        if (distSqr > r2 * r2) {
            return;
        }
        if (distSqr < 1.1920929E-7f) {
            separation = -r2;
            manifold.normal.set(0.0f, 1.0f);
        } else {
            float dist = MathUtils.sqrt(distSqr);
            separation = dist - r2;
            float a = 1.0f / dist;
            manifold.normal.x = a * this.colPCD.x;
            manifold.normal.y = a * this.colPCD.y;
        }
        manifold.pointCount = 1;
        manifold.points[0].id.zero();
        manifold.points[0].separation = separation;
        this.colPCP2.subLocal(manifold.normal.mul(r2));
        this.colPCP.x = 0.5f * (this.colPCP1.x + this.colPCP2.x);
        this.colPCP.y = 0.5f * (this.colPCP1.y + this.colPCP2.y);
        XForm.mulTransToOut(xf1, this.colPCP, manifold.points[0].localPoint1);
        XForm.mulTransToOut(xf2, this.colPCP, manifold.points[0].localPoint2);
    }

    public final void collidePolygonAndCircle(Manifold manifold, PolygonShape polygon, XForm xf1, CircleShape circle, XForm xf2) {
        float py;
        float px;
        manifold.pointCount = 0;
        float cx = xf2.position.x + xf2.R.col1.x * circle.m_localPosition.x + xf2.R.col2.x * circle.m_localPosition.y;
        float cy = xf2.position.y + xf2.R.col1.y * circle.m_localPosition.x + xf2.R.col2.y * circle.m_localPosition.y;
        float v1x = cx - xf1.position.x;
        float v1y = cy - xf1.position.y;
        float cLocalx = v1x * xf1.R.col1.x + v1y * xf1.R.col1.y;
        float cLocaly = v1x * xf1.R.col2.x + v1y * xf1.R.col2.y;
        int normalIndex = 0;
        float separation = -3.4028235E38f;
        float radius = circle.getRadius();
        int vertexCount = polygon.getVertexCount();
        Vec2[] vertices = polygon.getVertices();
        Vec2[] normals = polygon.getNormals();
        int i = 0;
        while (i < vertexCount) {
            float s = normals[i].x * (cLocalx - vertices[i].x) + normals[i].y * (cLocaly - vertices[i].y);
            if (s > circle.m_radius) {
                return;
            }
            if (s > separation) {
                normalIndex = i;
                separation = s;
            }
            ++i;
        }
        if (separation < 1.1920929E-7f) {
            manifold.pointCount = 1;
            manifold.normal.x = xf1.R.col1.x * normals[normalIndex].x + xf1.R.col2.x * normals[normalIndex].y;
            manifold.normal.y = xf1.R.col1.y * normals[normalIndex].x + xf1.R.col2.y * normals[normalIndex].y;
            manifold.points[0].id.features.incidentEdge = normalIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
            manifold.points[0].id.features.referenceEdge = 0;
            manifold.points[0].id.features.flip = 0;
            float positionx = cx - manifold.normal.x * radius;
            float positiony = cy - manifold.normal.y * radius;
            float v1x1 = positionx - xf1.position.x;
            float v1y1 = positiony - xf1.position.y;
            manifold.points[0].localPoint1.x = v1x1 * xf1.R.col1.x + v1y1 * xf1.R.col1.y;
            manifold.points[0].localPoint1.y = v1x1 * xf1.R.col2.x + v1y1 * xf1.R.col2.y;
            float v1x2 = positionx - xf2.position.x;
            float v1y2 = positiony - xf2.position.y;
            manifold.points[0].localPoint2.x = v1x2 * xf2.R.col1.x + v1y2 * xf2.R.col1.y;
            manifold.points[0].localPoint2.y = v1x2 * xf2.R.col2.x + v1y2 * xf2.R.col2.y;
            manifold.points[0].separation = separation - radius;
            return;
        }
        int vertIndex1 = normalIndex;
        int vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
        float ex = vertices[vertIndex2].x - vertices[vertIndex1].x;
        float ey = vertices[vertIndex2].y - vertices[vertIndex1].y;
        float length = MathUtils.sqrt(ex * ex + ey * ey);
        assert (length > 1.1920929E-7f);
        float invLength = 1.0f / length;
        float u = (cLocalx - vertices[vertIndex1].x) * (ex *= invLength) + (cLocaly - vertices[vertIndex1].y) * (ey *= invLength);
        if (u <= 0.0f) {
            px = vertices[vertIndex1].x;
            py = vertices[vertIndex1].y;
            manifold.points[0].id.features.incidentEdge = Integer.MAX_VALUE;
            manifold.points[0].id.features.incidentVertex = vertIndex1;
        } else if (u >= length) {
            px = vertices[vertIndex2].x;
            py = vertices[vertIndex2].y;
            manifold.points[0].id.features.incidentEdge = Integer.MAX_VALUE;
            manifold.points[0].id.features.incidentVertex = vertIndex2;
        } else {
            px = vertices[vertIndex1].x;
            py = vertices[vertIndex1].y;
            px += u * ex;
            py += u * ey;
            manifold.points[0].id.features.incidentEdge = normalIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
        }
        float dx = cLocalx - px;
        float dy = cLocaly - py;
        float dist = MathUtils.sqrt(dx * dx + dy * dy);
        if (dist > radius) {
            return;
        }
        if (dist >= 1.1920929E-7f) {
            float invDist = 1.0f / dist;
            dx *= invDist;
            dy *= invDist;
        }
        manifold.pointCount = 1;
        manifold.normal.x = xf1.R.col1.x * dx + xf1.R.col2.x * dy;
        manifold.normal.y = xf1.R.col1.y * dx + xf1.R.col2.y * dy;
        float positionx = cx - manifold.normal.x * radius;
        float positiony = cy - manifold.normal.y * radius;
        float v1x1 = positionx - xf1.position.x;
        float v1y1 = positiony - xf1.position.y;
        manifold.points[0].localPoint1.x = v1x1 * xf1.R.col1.x + v1y1 * xf1.R.col1.y;
        manifold.points[0].localPoint1.y = v1x1 * xf1.R.col2.x + v1y1 * xf1.R.col2.y;
        float v1x2 = positionx - xf2.position.x;
        float v1y2 = positiony - xf2.position.y;
        manifold.points[0].localPoint2.x = v1x2 * xf2.R.col1.x + v1y2 * xf2.R.col1.y;
        manifold.points[0].localPoint2.y = v1x2 * xf2.R.col2.x + v1y2 * xf2.R.col2.y;
        manifold.points[0].separation = dist - radius;
        manifold.points[0].id.features.referenceEdge = 0;
        manifold.points[0].id.features.flip = 0;
    }

    public final void collideEdgeAndCircle(Manifold manifold, EdgeShape edge, XForm xf1, CircleShape circle, XForm xf2) {
        float separation;
        manifold.pointCount = 0;
        XForm.mulToOut(xf2, circle.getMemberLocalPosition(), this.ECc);
        XForm.mulTransToOut(xf1, this.ECc, this.ECcLocal);
        Vec2 n = edge.getNormalVector();
        Vec2 v1 = edge.getVertex1();
        Vec2 v2 = edge.getVertex2();
        float radius = circle.getRadius();
        this.ECd.set(this.ECcLocal);
        this.ECd.subLocal(v1);
        float dirDist = Vec2.dot(this.ECd, edge.getDirectionVector());
        if (dirDist <= 0.0f) {
            if (Vec2.dot(this.ECd, edge.getCorner1Vector()) < 0.0f) {
                return;
            }
            XForm.mulToOut(xf1, v1, this.ECd);
            this.ECd.subLocal(this.ECc);
            this.ECd.negateLocal();
        } else if (dirDist >= edge.getLength()) {
            this.ECd.set(this.ECcLocal);
            this.ECd.subLocal(v2);
            if (Vec2.dot(this.ECd, edge.getCorner2Vector()) > 0.0f) {
                return;
            }
            XForm.mulToOut(xf1, v2, this.ECd);
            this.ECd.subLocal(this.ECc);
            this.ECd.negateLocal();
        } else {
            float separation2 = Vec2.dot(this.ECd, n);
            if (separation2 > radius || separation2 < -radius) {
                return;
            }
            Mat22.mulToOut(xf1.R, n, manifold.normal);
            manifold.pointCount = 1;
            manifold.points[0].id.zero();
            manifold.points[0].separation = separation2 -= radius;
            this.ECd.set(manifold.normal);
            this.ECd.mulLocal(radius);
            this.ECc.subLocal(this.ECd);
            XForm.mulTransToOut(xf1, this.ECc, manifold.points[0].localPoint1);
            XForm.mulTransToOut(xf2, this.ECc, manifold.points[0].localPoint2);
            return;
        }
        float distSqr = Vec2.dot(this.ECd, this.ECd);
        if (distSqr > radius * radius) {
            return;
        }
        if (distSqr < 1.1920929E-7f) {
            separation = -radius;
            Mat22.mulToOut(xf1.R, n, manifold.normal);
        } else {
            separation = this.ECd.normalize() - radius;
            manifold.normal.set(this.ECd);
        }
        manifold.pointCount = 1;
        manifold.points[0].id.zero();
        manifold.points[0].separation = separation;
        this.ECd.set(manifold.normal);
        this.ECd.mulLocal(radius);
        this.ECc.subLocal(this.ECd);
        XForm.mulTransToOut(xf1, this.ECc, manifold.points[0].localPoint1);
        XForm.mulTransToOut(xf2, this.ECc, manifold.points[0].localPoint2);
    }
}

